#include<stdio.h>
#include<fcntl.h>
#include<sys\types.h>
#include<sys\stat.h>

/* NOTE: Status output is specifically designed to work well with
 *       that of SWAPLIST, and maybe similar things (i.e. wildcard)
 */

unsigned char ibuf[4096], obuf[4096];
int ibufn, ibufi, obufn;
int ifd, ofd;
long bknum;

void putbyte(unsigned char byte)
	{
	if(obufn>=4096)
		{
		if(write(ofd, obuf, obufn)!=obufn)
			{
			printf(" Write error.\n");
			exit(11);
			}
		obufn=0;
		printf("\b\b\b\b%-4d", ++bknum);
		}
	obuf[obufn++]=byte;
	}

void flusho()
	{
	if(obufn)
		if(write(ofd, obuf, obufn)!=obufn)
			{
			printf(" Write error in flush.\n");
			exit(12);
			}
	}

int getbyte() /* int allows -1 error return to be out of band */
	{
	if(ibufi>=ibufn)
		if((ibufn=read(ifd, ibuf, 4096))<=0)
			return(-1);
		else
			ibufi=0;
	return(ibuf[ibufi++]);
	}

int getreal()
	{
	int b;
	if((b=getbyte())==-1)
		return(-1);
	if(b==0x10)
		{
		if((b=getbyte())==-1)
			return(-1);
		if(b==0x10)
			return(0x10);
		else
			return(b|0x0100);
		}
	return(b);
	}

main(int argc, char **argv)
	{
	unsigned char alpha, special, donealpha;
	int b;
	ibufi=ibufn=obufn=0;
	donealpha=0;
	bknum=0L;
	if(argc<3)
		{
		printf("USAGE: byteswap <source> <target>\n");
		exit(1);
		}
	if((ifd=open(argv[1], O_RDONLY|O_BINARY))==-1)
		{
		printf(" Error opening %s for read.\n", argv[1]);
		exit(2);
		}
	if((ofd=open(argv[2], O_WRONLY|O_BINARY|O_CREAT|O_TRUNC, S_IWRITE))==-1)
		{
		printf(" Error opening %s for write.\n", argv[2]);
		exit(3);
		}
	printf("Block: 0   ");
	while(1)
		{
		if((b=getreal())==-1)
			break;
		if(b&0x0100)
			{
			putbyte(0x10);
			putbyte(b&0xff);
			}
		else if(donealpha)
			{
			donealpha=0;
			putbyte(b&0xff);
			if(b==0x10)
				putbyte(0x10);
			putbyte(alpha);
			if(alpha==0x10)
				putbyte(0x10);
			}
		else
			{
			alpha=b;
			donealpha++;
			}
		}
	flusho();
	printf(" ");
	exit(0);
	}
