/* CSPREPRO: COMSCRPT pre-processor. Copyright (C) 1993 Peter Edward Cann */

/* Author Quote: "If I introduce one more escape
 *		  character, I'm going to vomit!
 *
 * (While the above statement is believed to be accurate at the time
 *  of publication, it should not be construed as constituting a legal
 *  commitment of any kind. Anyone desiring any quantity of previously-
 *  owned comestibles should contact a local distributor thereof.)
 */

#include<stdio.h>

int lnum;

unsigned char symtab[256][32]; /* NOTE: >> 31 << char symbols! */
char symflags[256];
int nsyms;

int alr; /* Assoc. length return. More info back from assoc functions */

void symoffer(char *candidate)
	{
	int i;
	char *tcp, *kcp;
	for(i=0,kcp=candidate;((*kcp)!=' ')&&((*kcp)!='\t')&&((*kcp)!='\n')&&*kcp;kcp++,i++);
	if(i>=32)
		{
		printf("\nSymbolic label too long at line %d; substring is\n", lnum);
		printf("%%%s\n", candidate);
		exit(71);
		}
	for(i=0;i<nsyms;i++)
		{
		for(tcp=symtab[i],kcp=candidate;(*tcp)&&((*kcp)==(*tcp));tcp++,kcp++);
		if(*tcp)
			continue; /* Miss */
		if(((*kcp)!=' ')&&((*kcp)!='\t')&&((*kcp)!='\n')&&*kcp)
			continue; /* Miss */
		return((void)0); /* Hit */
		}
	/* Total miss; it's a new one! */
	kcp=candidate; /* Damned name's too long! */
	tcp=symtab[nsyms];
	while(((*kcp)!=' ')&&((*kcp)!='\t')&&((*kcp)!='\n')&&*kcp)
		(*(tcp++))=(*(kcp++));
	(*tcp)='\0';
	nsyms++;
	}

int symassoc(char *key)
	{
	int i;
	char *tcp, *kcp;
	for(i=0;i<nsyms;i++)
		{
		for(alr=0,tcp=symtab[i],kcp=key;(*tcp)&&((*kcp)==(*tcp));tcp++,kcp++,alr++);
		if(*tcp)
			continue; /* (*kcp)!=(*tcp); Miss */
		if(((*kcp)!=' ')&&((*kcp)!='\t')&&((*kcp)!='\n')&&*kcp)
			continue; /* Miss */
		return(i); /* Hit */
		}
	/* Total miss */
	printf("\n\nThere appears to be an error in this preprocessing program.\n");
	printf("A symbolic label was found at substitute time that did not appear to\n");
	printf("match any of the symbols tabulated earlier. The symbol that\n");
	printf("had no table match, plus remaining line, in >>><<<s, was:\n>>>%s<<<\n", key);
	/* DEBUG ONLY *
	printf("Symbol table dump:\n");
	for(i=0;i<nsyms;i++)
		printf("%s\n", symtab[i]);
	* END DEBUG ONLY */
	exit(55);
	}

struct		/* Such discipline! No 3-D arrays here! */
	{
	unsigned char key[32];
	unsigned char value[64];
	}
	eqtab[256]; /* Hell, it's only 25 K and not needed elsewhere */

int neqs;

void eqput(char *thing) /* thing starts right after '=' */
	{
	int i;
	unsigned char *ki, *ke, *ci;
	if(neqs>=256)
		{
		printf("\nToo many equates.\n");
		exit(66);
		}
	for(ke=thing,i=0;((*ke)!=' ')&&((*ke)!='\t')&&((*ke)!='\n')&&*ke;ke++,i++);
	if(i>=32)
		{
		printf("Equate symbol too long in line %d\n%%=%s\n", lnum, thing);
		exit(62);
		}
	/* *ke is now key end. What a coincidence! */
	for(i=0;i<neqs;i++)
		{
		for(ki=thing,ci=eqtab[i].key;((*ki)==(*ci))&&(ki!=ke);ki++,ci++);
		if(ki==ke)
			{
			printf("Duplicate equate definition with second at line %d\n%%=%s\n", lnum, thing);
			exit(61);
			}
		}
	/* Unique */
	for(i=0;i<nsyms;i++)
		{
		for(ki=thing,ci=symtab[i];((*ki)==(*ci))&&(ki!=ke);ki++,ci++);
		if(ki==ke)
			{
			printf("Equate symbol already defined as label. (You need to equate higher in file.\n"
				"Failed equate at line%d:\n%%=%s\n", lnum, thing);
			exit(61);
			}
		}
	/* Really unique */
	for(ci=eqtab[neqs].key,ki=thing;ki!=ke;ci++,ki++)
		(*ci)=(*ki); /* ci not exactly candidate index anymore */
	(*ci)='\0';
	for(;((*ke)==' ')||((*ke)=='\t');ke++);
	if(((*ke)=='\n')||!*ke)
		{
		printf("Equate statement internally delimited with non- space or tab at line %d\n", lnum);
		printf("%%=%s\n", thing);
		exit(63);
		}
	/* ke (no longer key end, actually) now is beginning of value) */
	for(ci=eqtab[neqs].value,i=0;(*ke)&&((*ke)!='\n')&&(i<63);(*(ci++))=(*(ke++)),i++);
	if(i>=63)
		{
		printf("Equate value too long at line %d\n%%=%s\n", lnum, thing);
		exit(64);
		}
	if(!*ke)
		{
		printf("An equate value ended without a newline at line %d.\n"
		       "The value was: %s\n",
			lnum, thing);
		exit(68);
		}
	(*ci)='\0';
	/* DEBUG ONLY *
	printf("Entered equate >>>%s<<<\n", eqtab[neqs].key);
	* END DEBUG ONLY */
	neqs++;
	}

unsigned char *eqassoc(char *key)
	{
	int i;
	char *tcp, *kcp;
	for(i=0;i<neqs;i++)
		{
		for(alr=0,tcp=eqtab[i].key,kcp=key;(*tcp)&&((*kcp)==(*tcp));tcp++,kcp++,alr++);
		if(*tcp)
			continue; /* Miss */
		/* The following is WRONG! We can't insist on delimited
		 * equate references; it would blow the whole concept!
		 *
		 * Of course, if you're wondering why it's here... (blush!)
		 *
		 * if(((*kcp)!=' ')&&((*kcp)!='\t')&&((*kcp)!='\n')&&*kcp)
		 *	continue; * Miss *
		 */
		return(eqtab[i].value); /* Hit */
		}
	/* Total miss */
	return(NULL);
	}

main(int argc, char **argv)
	{
	FILE *ifd, *ofd;
	int i, j, k, cursym, breakflag, newslen;
	float labincf, labofff;
	char str[256], *sptr, numstr[8], *rightptr, *leftptr, *news;
	if(argc<2)
		{
		printf("\nUSAGE: csprepro <infile> [<outfile>]\n\n"
		       "<outfile> is optional provided <infile> has no extension, in which case the\n"
		       "actual infile is <infile>.ssc and the outfile is <infile>.scr; or if <infile>\n"
		       "already has the extension .SSC, which gives the .SCR file the same basename.\n\n"
		       "Equate syntax: %%=<symbol><whitespace><rest of line>\n"
		       "Equate reference is %%:<symbol><whitespace>.\n"
		       "Equate key must be <32 chars & value <64 chars\n\n"
		       "The colon (:) is optional, but if you don't use it you will be plagued\n"
		       "with things expanding into labels instead of equates because you haven't\n"
		       "remembered to define the equate yet.\n\n"
		       "For symbolic labels, any occurrence of %%<stuff><whitespace> where stuff does\n"
		       "not begin with '=' or ':' is replaced with a decimal number, followed by the\n"
		       "same whitespace, where the numbers are spread from 0 to 255. <stuff> must not\n"
		       "be more than 31 characters, and no more than 256 unique labels may be used.\n\n"
		       "%%%% translates to a non-magic %%.\n"); /* End printf */
		exit(1);
		}
	if(argc==2)
		{
		for(i=0;argv[1][i];i++)
			if((str[i]=argv[1][i])=='.')
				if(i++,(str[i]=argv[1][i])!='.')/*peek&skip*/
					if(((argv[1][i]!='s')&&(argv[1][i]!='S'))
						||((argv[1][i+1]!='s')&&(argv[1][i+1]!='S'))
						||((argv[1][i+2]!='c')&&(argv[1][i+2]!='C')))
						{
						printf("\nSingle argument mode only works without an extension, or with\n"
							"the extension .SSC. The name %s is not a .SSC.\n", argv[1]);
						exit(44);
						}
					else
						{
						i--; /* Back over '.' */
						break; /* and park it */
						}
		str[i]='.';
		str[i+1]='s';
		str[i+2]='s';
		str[i+3]='c';
		str[i+4]='\0';
		}
	else
		strcpy(str, argv[1]);
	if((ifd=fopen(str, "r"))==NULL)
		{
		printf("Error opening %s for read.\n", str);
		exit(2);
		}
	printf("Preprocessing from %s ", str);
	if(argc==2)
		{
		str[i]='.';    /* Unnecessary, but good self-doc */
		str[i+1]='s';  /* Ditto! */
		str[i+2]='c';
		str[i+3]='r';
		str[i+4]='\0'; /* More ditto! */
		}
	else
		strcpy(str, argv[2]);
	printf("to %s.\n", str); /* Kinky, eh what? Look ma, one str! */
	if((ofd=fopen(str, "w"))==NULL)
		{
		printf("Error opening %s for read.\n", str);
		exit(3);
		}
	nsyms=neqs=lnum=0;
	printf("Tabulating: line ....");
	while(1)
		{
		printf("\b\b\b\b%-4d", ++lnum);
		fgets(str, 255, ifd);
		if(feof(ifd))
			break;
		sptr=str;
		breakflag=0;
		while(1)
			{
			for(;(*sptr)!='%';sptr++)
				if(!*sptr)
					{
					breakflag=1;
					break;
					}
			if(breakflag)
				break; /* break should take an argument! */
			if(sptr[1]=='=')
				eqput(&sptr[2]);
			else if(sptr[1]==':')
				;
			else if(sptr[1]=='%')
				sptr++; /* non-magic, skip 1 now 1 later */
			else if(eqassoc(&sptr[1])==NULL)
				{
				if(nsyms>255)
					{
					printf("Too many label symbols; limit 256.\n");
					exit(30);
					}
				/* Note: We don't tabulate icky % */
				symoffer(&sptr[1]);
				}
			sptr++; /* move off of % */
			}
		}
	rewind(ifd); /* Handy, this! Too bad it ain't frewind(), though. */
	printf("\nChecking use of the %d allocated label symbols as labels", nsyms);
	for(i=0;i<nsyms;i++)
		symflags[i]=0;
	while(1)
		{
		fgets(str, 255, ifd);
		if(feof(ifd))
			break;
		if((str[0]==':')&&(str[1]==' ')&&(str[2]=='%'))
			symflags[symassoc(&str[3])]=1;
		}
	for(i=0;i<nsyms;i++)
		if(!symflags[i])
			{ /* Not very slow if you think about it */
			printf("\nThe following label symbols were not in fact used in label declarations:\n");
			for(i=0;i<nsyms;i++)
				if(!symflags[i])
					printf("%s\n", symtab[i]);
			break; /* Not this for */
			}
	rewind(ifd);
	labincf=256.0/nsyms;
	labofff=labincf/2;
	lnum=0;
	printf("\nSubstituting: line ....");
	while(1)
		{
		breakflag=0;
		printf("\b\b\b\b%-4d", ++lnum);
		fgets(str, 255, ifd);
		if(feof(ifd))
			break;
		sptr=str;
		while(1)
			{
			for(;(*sptr)&&((*sptr)!='%');sptr++);
			if(!*sptr)
				break;
			/* Hit an escape (percent) */
			if(sptr[1]=='%')
				{
				leftptr=++sptr; /* Save one; no hit later */
				rightptr=leftptr+1;
				while((*(leftptr++))=(*(rightptr++)));
				continue;
				}
			/* Hit a symbol */
			if(sptr[1]=='=')
				{
				breakflag=1;
				break; /* Dike out equate def line */
				}
			if(sptr[1]==':')
				if((news=eqassoc(&sptr[2]))==NULL)
					{
					printf("\nUndefined mandatory equate referenced in line %d; reads:\n%s\n", lnum, sptr);
					exit(86);
					}
				else
					alr++;
			else if((news=eqassoc(&sptr[1]))==NULL)
				sprintf(news=numstr, "%d", (int)((symassoc(&sptr[1])*labincf)+labofff));
			alr++;
			/* NOTE: We have very carefully adjusted alr to now
			 *       reflect the size of the key WITH escapes. */
			if(alr<(newslen=strlen(news)))
				{
				/* key hole smaller than value */
				for(rightptr=sptr;*rightptr;rightptr++);
				leftptr=rightptr-(newslen-alr);
				while(leftptr>sptr)
					(*(leftptr--))=(*(rightptr--));
				}
			else
				{
				/* key hole equal or larger vs value */
				leftptr=sptr;
				rightptr=sptr+(alr-newslen);
				while((*(leftptr++))=(*(rightptr++)));
				}
			rightptr=news;
			while(*rightptr) /* No nul in middle of line please */
				(*(sptr++))=(*(rightptr++));
			}
		if(!breakflag) /* Well, flag, anyway... */
			fputs(str, ofd);
		}
	fclose(ofd);
	fclose(ifd);
	/* "Moo!" said the loose cow with delight as it finished the last
	 * of the asparagus patch. Sorry; just had to say that here.
	 */
	exit(0);
	}
