#include<stdio.h>
#include<fcntl.h>
#include<bios.h>

struct header_s
	{
	unsigned char mfgr;
	unsigned char version;
	unsigned char encoding;
	unsigned char bppix;
	unsigned short xmin;
	unsigned short ymin;
	unsigned short xmax;
	unsigned short ymax;
	unsigned short hdpi;
	unsigned short vdpi;
	unsigned char cmap[48];
	unsigned char reserved;
	unsigned char nplanes;
	unsigned short bypl;
	unsigned short paltinf;
	unsigned short hscrnsz;
	unsigned short vscrnsz;
	unsigned char filler[54];
	};

struct header_s header;

unsigned char buf0[4147], buf1[4147], bybuf[216], fbuf[8192];

void quit()
	{
	exit(99);
	}

void prchar(int lptn, char c)
	{
	while(!(_bios_printer(_PRINTER_STATUS, lptn, 0)&0x80))
		if(kbhit())
			getchar(); /* Allow interrupt */
	_bios_printer(_PRINTER_WRITE, lptn, c);
	}

main(argc, argv)
	int argc;
	char **argv;
	{
	int ifd, vsiz, n, curbyt, lptn, fbufn, rns; /* rns=Rough nStripes */
	int i, icnt, j, nslices, totbpl, vdstate, hdstate, fbufindex, stripen;
	long totbyts;
	unsigned char c, nlo, nhi, imask, bitmask;
	if(argc!=3)
		{
		printf("\nUSAGE: epfaxpcx <lpt #> <file>\n\n"
			"Prints a fax pcx file on Epson (?) @ 180 x 180, alternate bits in stripes.\n");
		exit(1);
		}
	if(sscanf(argv[1], "%d", &lptn)!=1)
		{
		printf("Bad scan of LPT number.\n");
		exit(10);
		}
	lptn--;
	if((ifd=open(argv[2], O_RDONLY|O_BINARY))==-1)
		{
		printf("Couldn't open %s for read.\n", argv[2]);
		exit(2);
		}
	read(ifd, &header, 128);
	printf("Got header OK.\n");
	if(header.encoding!=1)
		{
		printf("Bad type of encoding declared in header.\n");
		exit();
		}
	if(header.nplanes!=1)
		{
		printf("Only one plane allowed.\n");
		exit();
		}
	if(header.bppix!=1)
		{
		printf("Grayscale.\n");
		exit();
		}
	if((header.xmax-header.xmin)!=1727)
		{
		printf("Wrong width.\n");
		exit();	
		}
	printf("All checks OK.\n");
	vsiz=header.ymax-header.ymin+1;
	totbpl=header.bypl;
	totbyts=totbpl*(long)vsiz;
	curbyt=n=vdstate=hdstate=stripen=0;
	bitmask=0x80;
	for(i=0;i<4146;++i)
		buf0[i]=buf1[i]=0;
	fbufindex=fbufn=0;
	rns=vsiz*4/5/24; /* Include destructive resolution-matching. */
	for(;;)          /* Very important I'm right re left to right eval! */
		{
		if(fbufindex>=fbufn)
			{
			if((fbufn=read(ifd, fbuf, 8192))<=0)
				{
				printf("Terminated by End of File rather than full count.\n");
				printf("We were expecting %ld more horizontal fat bytes of image.\n", totbyts);
				break;
				}
			fbufindex=0;
			}
		c=fbuf[fbufindex++];
		if((c & (unsigned char) 0xc0)== (unsigned char) 0xc0)
			{
			i = c & (unsigned char) 0x3f;
			if(fbufindex>=fbufn)
				{
				if((fbufn=read(ifd, fbuf, 8192))<=0)
					{
					printf("Terminated by End of File rather than full count.\n");
					printf("We were expecting %ld more horizontal fat bytes of image.\n", totbyts);
					break;
					}
				fbufindex=0;
				}
			c=fbuf[fbufindex++];
			while(i--)
				bybuf[n++]=c;
			}
		else
			bybuf[n++]=c;
		if(n>=totbpl)
			{
			if(n!=totbpl)
				{
				printf("Mismatch.\n");
				exit();
				}
			for(i=0,j=0,hdstate=0,icnt=216;icnt;i++,icnt--)
				for(imask=0x80;imask;imask>>=1)
					{
					if(bybuf[i]&imask)
						;
					else
						if(imask&0xaa)
							if(bitmask&0xaa)
								buf0[j+curbyt]|=bitmask;
							else
								buf1[j+curbyt]|=bitmask;
						else
							if(bitmask&0xaa)
								buf1[j+curbyt]|=bitmask;
							else
								buf0[j+curbyt]|=bitmask;
					if(hdstate)
						j+=3;
					if(hdstate++==4)
						hdstate=0;
					}
			if(vdstate)
				if((!(bitmask>>=1))||(totbyts==n))
					{
					bitmask=0x80;
					if((++curbyt==3)||(totbyts==n))
						{
						printf("Sending stripe %d of about %d.\n", ++stripen, rns);
						nslices=1382;
						nlo=nslices%256;
						nhi=nslices/256;
						prchar(lptn, '\033');
						prchar(lptn, '*');
						prchar(lptn, 39);
						prchar(lptn, nlo);
						prchar(lptn, nhi);
						for(i=0,icnt=4146;icnt;i++,icnt--)
							prchar(lptn, buf0[i]);
						prchar(lptn, '\r');
						prchar(lptn, '\033');
						prchar(lptn, '*');
						prchar(lptn, 39);
						prchar(lptn, nlo);
						prchar(lptn, nhi);
						for(i=0,icnt=4146;icnt;i++,icnt--)
							prchar(lptn, buf1[i]);
						prchar(lptn, '\r');
						prchar(lptn, '\033');
						prchar(lptn, 'J');
						prchar(lptn, 24);
						curbyt=0;
						for(i=0,icnt=4146;icnt;++i,--icnt)
							buf0[i]=buf1[i]=0;
						}
					}
			if(vdstate++==4)
				vdstate=0;
			totbyts-=n;
			if(totbyts<=0)
				{
				if(curbyt&&(bitmask!=0x80))
					{
					printf("Sending flush stripe.\n");
					nslices=1382;
					nlo=nslices%256;
					nhi=nslices/256;
					prchar(lptn, '\033');
					prchar(lptn, '*');
					prchar(lptn, 39);
					prchar(lptn, nlo);
					prchar(lptn, nhi);
					for(i=0,icnt=4146;icnt;i++,icnt--)
						prchar(lptn, buf0[i]);
					prchar(lptn, '\r');
					prchar(lptn, '\033');
					prchar(lptn, '*');
					prchar(lptn, 39);
					prchar(lptn, nlo);
					prchar(lptn, nhi);
					for(i=0,icnt=4146;icnt;i++,icnt--)
						prchar(lptn, buf1[i]);
					prchar(lptn, '\r');
					prchar(lptn, '\033');
					prchar(lptn, 'J');
					prchar(lptn, 24);
					curbyt=0;
					for(i=0,icnt=4146;icnt;++i,--icnt)
						buf0[i]=buf1[i]=0;
					}
				close(ifd);
				prchar(lptn, 0x0c);
				printf("\nFinished correctly.\n");
				exit();
				}
			n=0;
			}
		}
	close(ifd);
	prchar(lptn, 0x0c);
	exit(40);
	}
