/* Copyright (C) 1992 Peter Edward Cann */

#include<stdio.h>
#include<dos.h>
#include<process.h>
#include<graph.h>
#include<time.h>

#define MAXTIMES 1024

long times[MAXTIMES];

int ntimes;

main(argc, argv)
	int argc;
	char **argv;
	{
	int i, j, topind, curind, flag;
	char str[256], str1[256], c;
	long tmptime;
	struct tm *tptr;
	struct find_t buf;
	printf("FAXMANIP Copyright (C) 1992,1993 Peter Edward Cann\n");
	if(argc>2)
		{
		printf("\nUSAGE: faxmanip [<directory>]\n");
		exit(93);
		}
	if(!strcmp(getenv("REMOTE"), "YES"))
		{
		printf("You appear to be logged in remotely, judging by the environment\n");
		printf("variable REMOTE, so this is probably a very bad idea.\n");
		printf("Are you sure you want to run FAXMANIP? (y or n) --> ");
		if(getchar()!='y') /* Note getchar() and not getch()! */
			{
			printf("n\nI didn't think so!\n");
			exit(99);
			}
		else
			printf("y\nOK, you're the boss!\n");
		}
	if(argc>=2)
		sprintf(str, "%s\\*.rfx", argv[1]);
	else
		sprintf(str, "*.rfx");
	if(_dos_findfirst(str, _A_NORMAL, &buf))
		{
		printf("No .rfx files found in current directory.\n");
		exit(1);
		}
	ntimes=0;
	if(sscanf(buf.name, "%lx", &times[ntimes++])!=1)
		ntimes--;
	while(!_dos_findnext(&buf))
		{
		if(sscanf(buf.name, "%lx", &times[ntimes++])!=1)
			ntimes--;
		if(ntimes>=MAXTIMES)
			break;
		}
	for(i=0;i<ntimes;++i)
		for(j=i+1;j<ntimes;++j)
			if(times[i]<times[j])
				{
				tmptime=times[i];
				times[i]=times[j];
				times[j]=tmptime;
				}
	topind=curind=0;
	while(1)
		{
		_settextwindow(1,1,1,80);
		_settextcolor(0);
		_setbkcolor((long)7);
		_clearscreen(_GWINDOW);
		_outtext("     n=next   p=previous   c=convert   r=rename   d=delete   ESC or q=quit");
		_settextwindow(2,1,25,80);
		_settextcolor(7);
		_setbkcolor((long)0);
		_clearscreen(_GWINDOW);
		if(curind<12)
			topind=0;
		else if((ntimes-curind)<13)
			topind=ntimes-25;
		for(i=0;(i<24)&&(i<(ntimes-topind));++i)
			{
			tptr=localtime(&times[topind+i]);
			_settextposition(i+1, 1);
			printf("%02d.%02d.%02d @ %02d:%02d:%02d",
				(tptr->tm_year)+1900,
				(tptr->tm_mon)+1,
				tptr->tm_mday,
				tptr->tm_hour,
				tptr->tm_min,
				tptr->tm_sec
				);
			}
		flag=1;
		while((curind-topind<24)&&(curind>=topind)&&flag)
			{
			_settextposition(curind-topind+1, 21);
			switch(getch())
				{
				case 0:
					/* Funny key */
					switch(getch())
						{
						case 0x50:
							if(curind>=(ntimes-1))
								putch(0x07);
							else
								curind++;
							break;
						case 0x48:
							if(curind==0)
								putch(0x07);
							else
								curind--;
							break;
						default:
							putch(0x07);
						}
					break;
				case 'n':
				case 'N':
					if(curind>=(ntimes-1))
						putch(0x07);
					else
						curind++;
					break;
				case 'p':
				case 'P':
					if(curind==0)
						putch(0x07);
					else
						curind--;
					break;
				case 'q':
				case 'Q':
				case '\033': /* I'm getting old! */
					_settextposition(24, 1);
					exit(0);
					break;
				case 'd':
				case 'D':
					_settextposition(curind-topind+1, 23);
					printf("Really delete? (Y/N) --> ");
					c=getch();
					if((c!='Y')&&(c!='y'))
						{
						_settextposition(curind-topind+1, 23);
						printf("\t\t\t\t");
						break;
						}
					flag=0;
					if(argc>=2)
						sprintf(str, "%s\\%08lx.rfx", argv[1], times[curind]);
					else
						sprintf(str, "%08lx.rfx", times[curind]);
					if(unlink(str))
						{
						putch(7);
						break;
						}
					--ntimes;
					if(!ntimes)
						{
						_settextposition(24,1);
						printf("\nNo more faxes.\n");
						exit(0);
						}
					for(i=curind;i<ntimes;++i)
						times[i]=times[i+1];
					if(curind==ntimes)
						curind--;
					break;
				case 'r':
				case 'R':
					flag=0;
					_settextposition(curind-topind+1, 23);
					printf("New name --> ");
					gets(str1);
					if(!str1[0])
						{
						_settextposition(curind-topind+1, 23);
						printf("\t\t\t\t\t\t\t");
						break;
						}
					flag=0;
					if(argc>=2)
						sprintf(str, "%s\\%08lx.rfx", argv[1], times[curind]);
					else
						sprintf(str, "%08lx.rfx", times[curind]);
					if(rename(str,str1))
						{
						putch(7);
						break;
						}
					--ntimes;
					if(!ntimes)
						{
						_settextposition(24,1);
						printf("\nNo more faxes.\n");
						exit(0);
						}
					for(i=curind;i<ntimes;++i)
						times[i]=times[i+1];
					if(curind==ntimes)
						curind--;
					break;
				case 'c':
				case 'C':
					_settextposition(24,1);
					printf("\nSpawning RFXTOPCX...\n");
					if(argc>=2)
						sprintf(str, "%s\\%08lx.rfx", argv[1], times[curind]);
					else
						sprintf(str, "%08lx.rfx", times[curind]);
					spawnlp(P_WAIT, "rfxtopcx", "rfxtopcx", str, NULL);
					printf("\nPress any key to resume faxmanip: --> ");
					getch();
					flag=0;
					break;
				case 'e':
				case 'E':
					_settextposition(24,1);
					printf("\nCalling editor...\n");
					if(argc<3)
						printf("\007You must have given two arguments to use the editor feature.\n");
					else
						{
						sprintf(str1, "%s %s\\%08lx.rfx", argv[2], argv[1], times[curind]);
						system(str1);
						}
					printf("\nPress any key to resume faxmanip: --> ");
					getch();
					flag=0;
					break;
				default:
					putch(0x07);
					break;
				}
			}
		if(curind>12)
			topind=curind-12;
		else
			topind=0;
		}
	}
