/* Copyright (C) 1992, 1993 Peter Edward Cann, all rights reserved */

#include<stdio.h>
#include<process.h>
#include<dos.h>
#include"port.h"

unsigned long tick;

void (interrupt far *oldtick)();

void interrupt far tickhndl()
	{
	tick++;
	}

/* MUSIC: A below (?) middle C is 440 Hz. Semitone is factor of 2^(1/12), */
/* or about 1.059463. Timer/counter timebase is 1.193 MHz. */

stupid_success_noise()
	{
	oldtick=_dos_getvect(0x1c);
	_dos_setvect(0x1c, tickhndl);
	outp(0x43, 0xb6); /* Ctl Reg = #3 Lo-Hi Square Wave */
	outp(0x42, 0xe8); /* Divisor LSB (293 Hz) */
	outp(0x42, 0x0f); /* Divisor MSB (293 Hz) */
	tick=0L;
	while(tick==0L); /* Synchronize w/ tick phase; i.e. eliminate slop  */
	outp(0x61, inp(0x61)|0x03); /* PortB; 2^0: timer gate, 2^1: AND/OR? */
	while(tick<3);
	tick=0L;
	outp(0x42, 235); /* Divisor LSB (391 Hz) */
	outp(0x42, 11); /* Divisor MSB (391 Hz) */
	while(tick<2);
	tick=0L;
	outp(0x42, 117); /* Divisor LSB (493 Hz) */
	outp(0x42, 9); /* Divisor MSB (493 Hz) */
	while(tick<2);
	tick=0L;
	outp(0x42, 0xf4); /* Divisor LSB (586 Hz) */
	outp(0x42, 0x07); /* Divisor MSB (586 Hz) */
	while(tick<4);
	tick=0L;
	outp(0x42, 117); /* Divisor LSB (493 Hz) */
	outp(0x42, 9); /* Divisor MSB (493 Hz) */
	while(tick<2);
	tick=0L;
	outp(0x42, 0xf4); /* Divisor LSB (586 Hz) */
	outp(0x42, 0x07); /* Divisor MSB (586 Hz) */
	while(tick<4);
	outp(0x61, inp(0x61)&~(unsigned char)0x03);
	_dos_setvect(0x1c, oldtick);
	}
	
stupid_error_noise()
	{
	oldtick=_dos_getvect(0x1c);
	_dos_setvect(0x1c, tickhndl);
	outp(0x43, 0xb6); /* Ctl Reg = #3 Lo-Hi Square Wave */
	outp(0x42, 152); /* Divisor LSB (370 Hz) */
	outp(0x42, 12); /* Divisor MSB (370 Hz) */
	tick=0L;
	while(tick==0L); /* Synchronize w/ tick phase; i.e. eliminate slop  */
	outp(0x61, inp(0x61)|0x03); /* PortB; 2^0: timer gate, 2^1: AND/OR? */
	while(tick<4);
	tick=0L;
	outp(0x42, 90); /* Divisor LSB (349 Hz) */
	outp(0x42, 13); /* Divisor MSB (349 Hz) */
	while(tick<3);
	tick=0L;
	outp(0x42, 31); /* Divisor LSB (330 Hz) */
	outp(0x42, 14); /* Divisor MSB (330 Hz) */
	while(tick<3);
	tick=0L;
	outp(0x42, 252); /* Divisor LSB (311 Hz) */
	outp(0x42, 14); /* Divisor MSB (311 Hz) */
	while(tick<3);
	tick=0L;
	outp(0x42, 232); /* Divisor LSB (293 Hz) */
	outp(0x42, 15); /* Divisor MSB (293 Hz) */
	while(tick<3);
	outp(0x61, inp(0x61)&~(unsigned char)0x03);
	_dos_setvect(0x1c, oldtick);
	}
	

main(argc, argv)
	int argc;
	char **argv;
	{
	int run, basereg, result;
	char stopbstr[2], fpname[256], cmdstr[256], c, oldstat;
	if(!strcmp(getenv("REMOTE"), "YES"))
		{
		printf("You appear to be logged in remotely, judging by the environment\n");
		printf("variable REMOTE, so this is probably a very bad idea.\n");
		printf("Are you sure you want to run MASTERM? (y or n) --> ");
		if(getchar()!='y') /* Note getchar() and not getch()! */
			{
			printf("n\nI didn't think so!\n");
			exit(99);
			}
		else
			printf("y\nOK, you're the boss!\n");
		}
	if((argc!=4)&&(argc!=5))
		{
		printf("USAGE: masterm <port#> <speed> <databits><parity><stopbits> [<emu file>]\n");
		exit(1);
		}
	switch(argv[1][0])
		{
		case '1':
			basereg=0x3f8;
			break;
		case '2':
			basereg=0x2f8;
			break;
		case '3':
		case '5':
		case '7':
			basereg=0x3e8;
			break;
		case '4':
		case '6':
		case '8':
			basereg=0x2e8;
			break;
		default:
			printf("Bad port number.\n");
			exit(2);
		}
	oldstat=inp(basereg+MCTLREG);
	outp(basereg+MCTLREG, 0x03);
	if(getenv("PCCPPATH")==NULL)
		sprintf(cmdstr, "term");
	else
		sprintf(cmdstr, "%s/term", getenv("PCCPPATH"));
	if(argc==5)
		spawnlp(P_WAIT, cmdstr, "term", argv[1], argv[2], argv[3], argv[4], NULL);
	else
		spawnlp(P_WAIT, cmdstr, "term", argv[1], argv[2], argv[3], NULL);
	stopbstr[0]=argv[3][2];
	stopbstr[1]='\0';
	run=1;
	while(run)
		{
		printf("\nMASTERM   Copyright (C) 1992, 1993 Peter Edward Cann, all rights reserved.\n\n");
		printf("     UPLOAD:  (1) X   (2) X CRC   (3) X CRC 1K   (4) X CRC 16K   (a) ASCII\n\n");
		printf("   DOWNLOAD:  (5) X   (6) X CRC 128/1K/16K Automatic\n\n");
		printf("      (t, SPACE or ENTER) Terminal   (d) Terminal with Dribble\n\n");
		printf("                             (q) Quit\n\n");
		printf(" MASTERM Command: ---> ");
		c=getch();
		printf("%c\n", c);
		switch(c)
			{
			case 'q':
			case 'Q':
				run=0;
				break;
			case 't':
			case 'T':
			case ' ':
			case '\r':
				if(getenv("PCCPPATH")==NULL)
					sprintf(cmdstr, "term");
				else
					sprintf(cmdstr, "%s/term", getenv("PCCPPATH"));
				if(argc==5)
					spawnlp(P_WAIT, cmdstr, "term", argv[1], argv[2], argv[3], argv[4], NULL);
				else
					spawnlp(P_WAIT, cmdstr, "term", argv[1], argv[2], argv[3], NULL);
				break;
			case 'd':
			case 'D':
				if(getenv("PCCPPATH")==NULL)
					sprintf(cmdstr, "term");
				else
					sprintf(cmdstr, "%s/term", getenv("PCCPPATH"));
				printf("Dribble file pathname? (Blank to cancel)\n --> ");
				gets(fpname);
				if(!strlen(fpname))
					break;
				if(argc==5)
					spawnlp(P_WAIT, cmdstr, "term", argv[1], argv[2], argv[3], argv[4], fpname, NULL);
				else
					spawnlp(P_WAIT, cmdstr, "term", argv[1], argv[2], argv[3], "-", fpname, NULL);
				break;
			case '1':
				if(getenv("PCCPPATH")==NULL)
					sprintf(cmdstr, "xmodems");
				else
					sprintf(cmdstr, "%s/xmodems", getenv("PCCPPATH"));
				printf("Source file pathname? (Blank to cancel)\n --> ");
				gets(fpname);
				if(!strlen(fpname))
					break;
				result=spawnlp(P_WAIT, cmdstr, "xmodems", argv[1], argv[2], stopbstr, fpname, NULL);
				if(result)
					stupid_error_noise();
				else
					stupid_success_noise();
				break;
			case 'a':
			case 'A':
				if(getenv("PCCPPATH")==NULL)
					sprintf(cmdstr, "asciis");
				else
					sprintf(cmdstr, "%s/asciis", getenv("PCCPPATH"));
				printf("Source file pathname? (Blank to cancel)\n --> ");
				gets(fpname);
				if(!strlen(fpname))
					break;
				result=spawnlp(P_WAIT, cmdstr, "asciis", argv[1], argv[2], argv[3], fpname, NULL);
				if(result)
					stupid_error_noise();
				else
					stupid_success_noise();
				break;
			case '2':
				if(getenv("PCCPPATH")==NULL)
					sprintf(cmdstr, "xmcrcs");
				else
					sprintf(cmdstr, "%s/xmcrcs", getenv("PCCPPATH"));
				printf("Source file pathname? (Blank to cancel)\n --> ");
				gets(fpname);
				if(!strlen(fpname))
					break;
				result=spawnlp(P_WAIT, cmdstr, "xmcrcs", argv[1], argv[2], stopbstr, fpname, NULL);
				if(result)
					stupid_error_noise();
				else
					stupid_success_noise();
				break;
			case '3':
				if(getenv("PCCPPATH")==NULL)
					sprintf(cmdstr, "xmcrc1ks");
				else
					sprintf(cmdstr, "%s/xmcrc1ks", getenv("PCCPPATH"));
				printf("Source file pathname? (Blank to cancel)\n --> ");
				gets(fpname);
				if(!strlen(fpname))
					break;
				result=spawnlp(P_WAIT, cmdstr, "xmcrc1ks", argv[1], argv[2], stopbstr, fpname, NULL);
				if(result)
					stupid_error_noise();
				else
					stupid_success_noise();
				break;
			case '4':
				if(getenv("PCCPPATH")==NULL)
					sprintf(cmdstr, "xmcrc16s");
				else
					sprintf(cmdstr, "%s/xmcrc16s", getenv("PCCPPATH"));
				printf("Source file pathname? (Blank to cancel)\n --> ");
				gets(fpname);
				if(!strlen(fpname))
					break;
				result=spawnlp(P_WAIT, cmdstr, "xmcrc16s", argv[1], argv[2], stopbstr, fpname, NULL);
				if(result)
					stupid_error_noise();
				else
					stupid_success_noise();
				break;
			case '5':
				if(getenv("PCCPPATH")==NULL)
					sprintf(cmdstr, "xmodemr");
				else
					sprintf(cmdstr, "%s/xmodemr", getenv("PCCPPATH"));
				printf(">>> This is a receive. Any existing file will be trashed. <<<\n");
				printf("Target file pathname? (Blank to cancel)\n --> ");
				gets(fpname);
				if(!strlen(fpname))
					break;
				result=spawnlp(P_WAIT, cmdstr, "xmodemr", argv[1], argv[2], stopbstr, fpname, NULL);
				if(result)
					stupid_error_noise();
				else
					stupid_success_noise();
				break;
			case '6':
				if(getenv("PCCPPATH")==NULL)
					sprintf(cmdstr, "xmcrcr");
				else
					sprintf(cmdstr, "%s/xmcrcr", getenv("PCCPPATH"));
				printf(">>> This is a receive. Any existing file will be trashed. <<<\n");
				printf("Target file pathname? (Blank to cancel)\n --> ");
				gets(fpname);
				if(!strlen(fpname))
					break;
				result=spawnlp(P_WAIT, cmdstr, "xmcrcr", argv[1], argv[2], stopbstr, fpname, NULL);
				if(result)
					stupid_error_noise();
				else
					stupid_success_noise();
				break;
			}
		}
	outp(basereg+MCTLREG, oldstat);
	exit(0);
	}
