/*	Copyright (C) 1992,1994 Peter Edward Cann, all rights reserved.
 */

#include<stdio.h>
#include<bios.h>
#include<dos.h>
#include<fcntl.h>
#include<graph.h>
#include"emu.h"
#include"color.h"

#define LISTSIZ 16

struct
	{
	short index;
	short row;
	char rowset;
	short column;
	char colset;
	short list[LISTSIZ];
	short listindex;
	}
	funcstor[NFUNCS];

clrfuncstor(seqn)
	short seqn;
	{
	int i;
	if(funcstor[seqn].listindex==LISTSIZ)
		funcstor[seqn].listindex--;
	for(i=funcstor[seqn].listindex;i>=0;i--)
		funcstor[seqn].list[i]=0;
	funcstor[seqn].row=funcstor[seqn].column=funcstor[seqn].listindex=funcstor[seqn].index=funcstor[seqn].rowset=funcstor[seqn].colset=0;
	}

int bold, faint, blink, inverse, bkcolor, fgcolor;
struct videoconfig vconf;

atthndl()
	{
	int adds, workingbk, workingfg;
	adds=0;
	if((vconf.adapter!=_MDPA)&&(vconf.adapter!=_HGC))
		{
		/* Color Adapter */
		workingbk=bkcolor;
		workingfg=fgcolor;
		if(faint&&(fgcolor==WHITE))
			workingfg=GRAY;
		if(bold)
			adds+=BOLDADD;
		if(blink)
			adds+=BLINKADD;
		if(inverse)
			{
			_settextcolor(workingbk+adds);
			_setbkcolor((long)(workingfg&0x07));
			}
		else
			{
			_settextcolor(workingfg+adds);
			_setbkcolor((long)(workingbk&0x07));
			}
		}
	else
		{
		workingbk=BLACK;
		if(bold&&!inverse)
			workingfg=M_UNDER;
		else
			if(inverse)
				workingfg=WHITE;
			else
				workingfg=M_NORMAL;
		if(faint)
			if(inverse)
				if(bkcolor!=BLACK)
					adds+=FAINTADD;
				else;
			else
				if(fgcolor!=BLACK)
					adds+=FAINTADD;
		if(blink)
			adds+=BLINKADD;
		if(inverse)
			{
			_settextcolor(workingbk+adds);
			_setbkcolor((long)(workingfg&0x07));
			}
		else
			{
			_settextcolor(workingfg+adds);
			_setbkcolor((long)(workingbk&0x07));
			}
		}
	}


ansiatthndl(seqn)
	short seqn;
	{
	int i, adds, workingbk, workingfg;
	if(emu.funcs[seqn].func==ANSIATTRIB)
		for(i=0;i<funcstor[seqn].listindex;i++)
			switch(funcstor[seqn].list[i])
				{
				/*at the moment this is strictly ANSI subset*/
				case 0:
					bkcolor=BLACK;
					fgcolor=WHITE;
					bold=faint=blink=inverse=0;
					break;
				case 1:
					bold=1;
					break;
				case 2:
					faint=1;
					break;
				case 5:
				case 6:
					blink=1;
					break;
				case 7:
					inverse=1;
					break;
				case 30:
					fgcolor=BLACK;
					break;
				case 31:
					fgcolor=RED;
					break;
				case 32:
					fgcolor=GREEN;
					break;	
				case 33:
					fgcolor=YELLOW;
					break;
				case 34:
					fgcolor=BLUE;
					break;
				case 35:
					fgcolor=MAGENTA;
					break;
				case 36:
					fgcolor=CYAN;
					break;
				case 37:
					fgcolor=WHITE;
					break;
				case 40:
					bkcolor=BLACK;
					break;
				case 41:
					bkcolor=RED;
					break;
				case 42:
					bkcolor=GREEN;
					break;	
				case 43:
					bkcolor=YELLOW;
					break;
				case 44:
					bkcolor=BLUE;
					break;
				case 45:
					bkcolor=MAGENTA;
					break;
				case 46:
					bkcolor=CYAN;
					break;
				case 47:
					bkcolor=WHITE;
					break;
				default:
					break;
				}
	atthndl();
	}

int wrap_p;

wrapctl()
	{
	if(wrap_p)
		_wrapon(_GWRAPON);
	else
		_wrapon(_GWRAPOFF);
	}

char fpname[256];

updstatus(c)
	{
	struct rccoord posptr;
	short tc;
	long bc;
	char str[80];
	posptr=_gettextposition();
	tc=_gettextcolor();
	bc=_getbkcolor();
	_settextwindow(1,1,1,80);
	_settextposition(1,1);
	_settextcolor(BLACK);
	_setbkcolor((long)WHITE);
	_wrapon(_GWRAPOFF);
	sprintf(str, " Ctl-C exits.  Next=%02x  Bold=%d  Faint=%d  Blink=%d  Inverse=%d", c, bold, faint, blink, inverse);
	_outtext(str);
	_settextwindow(2,1,25,80);
	wrapctl();
	_settextcolor(tc);
	_setbkcolor(bc);
	_settextposition(posptr.row, posptr.col);
	}

int graphics;

showchar(c)
	unsigned char c;
	{
	unsigned char str[2];
	if(graphics)
		if(emu.gchars[c])
			c=emu.gchars[c];
	str[0]=c;
	str[1]='\0';
	_outtext(str);
	}

int savedrow, savedcol;

perffunc(seqn)
	short seqn;
	{
	struct rccoord posptr;
	int i;
	switch(emu.funcs[seqn].func)
		{
		case CLEAR:
			_clearscreen(_GCLEARSCREEN);
			updstatus();
			_settextposition(1,1);
			break;
		case HOME:
			_settextposition(1,1);
			break;
		case CLREOL:
			posptr=_gettextposition();
			_wrapon(_GWRAPOFF);
			for(i=posptr.col;i<=80;i++)
				_outtext(" ");
			_settextposition(posptr.row, posptr.col);
			wrapctl();
			break;
		case UP:
			posptr=_gettextposition();
			if(posptr.row>1)
				_settextposition(posptr.row-1, posptr.col);
			break;
		case DOWN:
			posptr=_gettextposition();
			if(posptr.row<24)
				_settextposition(posptr.row+1, posptr.col);
			else
				{
				showchar('\n');
				_settextposition(posptr.row, posptr.col);
				}
			break;
		case LEFT:
			posptr=_gettextposition();
			if(posptr.col>1)
				_settextposition(posptr.row, posptr.col-1);
			break;
		case RIGHT:
			posptr=_gettextposition();
			if(posptr.col<80)
				_settextposition(posptr.row, posptr.col+1);
			break;
		case GOTO:
			funcstor[seqn].row-=(emu.firstrowaddr-1);
			funcstor[seqn].column-=(emu.firstcoladdr-1);
			if(funcstor[seqn].row<1)
				funcstor[seqn].row=1;
			if(funcstor[seqn].row>24)
				funcstor[seqn].row=24;
			if(funcstor[seqn].column<1)
				funcstor[seqn].column=1;
			if(funcstor[seqn].column>80)
				funcstor[seqn].row=80;
			_settextposition((emu.tophi_p?25-funcstor[seqn].row:funcstor[seqn].row), funcstor[seqn].column);
			break;
		case NORMAL:
			fgcolor=WHITE;
			bkcolor=BLACK;
			blink=faint=bold=inverse=0;
			atthndl();
			break;
		case BLINK:
			blink=1;
			atthndl();
			break;
		case NOBLINK:
			blink=0;
			atthndl();
			break;
		case BOLD:
			bold=1;
			atthndl();
			break;
		case NOBOLD:
			bold=0;
			atthndl();
			break;
		case FAINT:
			faint=1;
			atthndl();
			break;
		case NOFAINT:
			faint=0;
			atthndl();
			break;
		case INVERSE:
			inverse=1;
			atthndl();
			break;
		case NOINVERSE:
			inverse=0;
			atthndl();
			break;
		case UPN:
			posptr=_gettextposition();
			if(posptr.row-funcstor[seqn].row<1)
				_settextposition(1, posptr.col);
			else
				_settextposition(posptr.row-funcstor[seqn].row, posptr.col);
			break;
		case DOWNN:
			posptr=_gettextposition();
			if(posptr.row+funcstor[seqn].row>24)
				{
				_settextposition(24,1);
				for(i=25-(posptr.row+funcstor[seqn].row);i<0;++i)
					showchar('\n');
				_settextposition(24, posptr.col);
				}
			else
				_settextposition(posptr.row+funcstor[seqn].row, posptr.col);
			break;
		case LEFTN:
			posptr=_gettextposition();
			if(posptr.col-funcstor[seqn].column<1)
				_settextposition(posptr.row, 1);
			else
				_settextposition(posptr.row, posptr.col-funcstor[seqn].column);
			break;
		case RIGHTN:
			posptr=_gettextposition();
			if(posptr.col+funcstor[seqn].column>80)
				_settextposition(posptr.row, 80);
			else
				_settextposition(posptr.row, posptr.col+funcstor[seqn].column);
			break;
		case ANSIATTRIB:
			ansiatthndl(seqn);
			break;
		case WRAP:
			wrap_p=1;
			wrapctl();
			break;
		case NOWRAP:
			wrap_p=0;
			wrapctl();
			break;
		case GOTOLINE:
			funcstor[seqn].row-=(emu.firstrowaddr-1);
			posptr=_gettextposition();
			if(funcstor[seqn].row<1)
				funcstor[seqn].row=1;
			if(funcstor[seqn].row>24)
				funcstor[seqn].row=24;
			_settextposition(emu.tophi_p?25-funcstor[seqn].row:funcstor[seqn].row, 1);
			break;
		case GOTOCOL:
			funcstor[seqn].column-=(emu.firstcoladdr-1);
			posptr=_gettextposition();
			if(funcstor[seqn].column<1)
				funcstor[seqn].column=1;
			if(funcstor[seqn].column>80)
				funcstor[seqn].row=80;
			_settextposition(posptr.row, funcstor[seqn].column);
			break;
		case BINATTR:
			if((funcstor[seqn].row-emu.attroffset)&emu.blinkmask)
				blink=1;
			else
				blink=0;
			if((funcstor[seqn].row-emu.attroffset)&emu.inversemask)
				inverse=1;
			else
				inverse=0;
			if((funcstor[seqn].row-emu.attroffset)&emu.boldmask)
				bold=1;
			else
				bold=0;
			if((funcstor[seqn].row-emu.attroffset)&emu.faintmask)
				faint=1;
			else
				faint=0;
			atthndl();
			break;
		case GRAPHCHAR:
			showchar(emu.gchars[funcstor[seqn].row]);
			break;
		case BEGGRAPH:
			graphics=1;
			break;
		case ENDGRAPH:
			graphics=0;
			break;
		case TAB:
			posptr=_gettextposition();
			_settextposition(posptr.row, posptr.col+(8-((posptr.col-1)%8)));
			break;
		case BELL:
			putch(7);
			break;
		case DTAB:
			posptr=_gettextposition();
			for(i=0;i<(8-((posptr.col-1)%8));++i)
				_outtext(" ");
			break;

		case CRLF:
			showchar('\n');
			break;
		case SAVEPOS:
			posptr=_gettextposition();
			savedrow=posptr.row;
			savedcol=posptr.col;
			break;
		case RESTOREPOS:
			_settextposition(savedrow, savedcol);
			break;
		default:
			break;
		}
	}

dispport(c)
	unsigned char c;
	{
	int seqn, done, ok;
	done=0;
	ok=0;
	for(seqn=0;seqn<NFUNCS;seqn++)
		{
		if(emu.funcs[seqn].codes[funcstor[seqn].index]&0xff00)
			switch(emu.funcs[seqn].codes[funcstor[seqn].index])
				{
				case END:
					if(funcstor[seqn].index)
						{
						done=1;
						perffunc(seqn);
						}
					break;
				case BINCOL:
					funcstor[seqn].column=c-emu.bincoloff;
					ok=1;
					if(emu.funcs[seqn].codes[++funcstor[seqn].index]==END)
						{
						done=1;
						perffunc(seqn);
						}
					break;
				case BINROW:
					funcstor[seqn].row=c-emu.binrowoff;
					ok=1;
					if(emu.funcs[seqn].codes[++funcstor[seqn].index]==END)
						{
						done=1;
						perffunc(seqn);
						}
					break;
				case ASCDECCOL:
					if((c>='0')&&(c<='9'))
						{
						ok=1;
						funcstor[seqn].column*=10;
						funcstor[seqn].column+=(c-'0');
						funcstor[seqn].colset=1;
						}
					else
						if(funcstor[seqn].colset&&(c==emu.funcs[seqn].codes[++funcstor[seqn].index]))
							{
							ok=1;
							if(emu.funcs[seqn].codes[++funcstor[seqn].index]==END)
								{
								done=1;
								perffunc(seqn);
								}
							}
						else
							clrfuncstor(seqn);
					break;
				case ASCDECROW:
					if((c>='0')&&(c<='9'))
						{
						ok=1;
						funcstor[seqn].row*=10;
						funcstor[seqn].row+=(c-'0');
						funcstor[seqn].rowset=1;
						}
					else
						if(funcstor[seqn].rowset&&(c==emu.funcs[seqn].codes[++funcstor[seqn].index]))
							{
							ok=1;
							if(emu.funcs[seqn].codes[++funcstor[seqn].index]==END)
								{
								done=1;
								perffunc(seqn);
								}
							}
						else
							clrfuncstor(seqn);
					break;
				case ASCDECSEMILIST:
					if((c>='0')&&(c<='9')&&(funcstor[seqn].listindex<LISTSIZ))
						{
						ok=1;
						funcstor[seqn].list[funcstor[seqn].listindex]*=10;
						funcstor[seqn].list[funcstor[seqn].listindex]+=(c-'0');
						}
					else
						{
						if(funcstor[seqn].listindex<LISTSIZ)
							funcstor[seqn].listindex++;
						
						if(c==';')
							ok=1;
						else
							if(c==emu.funcs[seqn].codes[++funcstor[seqn].index])
								{
								ok=1;
								if(emu.funcs[seqn].codes[++funcstor[seqn].index]==END)
									{
									done=1;
									perffunc(seqn);
									}
								}
							else
								clrfuncstor(seqn);
						}
					break;
				case GRABCHAR:
					ok=1;
					funcstor[seqn].row=c;
					if(emu.funcs[seqn].codes[++funcstor[seqn].index]==END)
						{
						done=1;
						perffunc(seqn);
						}
					break;
				case GRAPHCHAR_T:
					if(emu.gchars[c])
						{
						ok=1;
						funcstor[seqn].row=c;
						if(emu.funcs[seqn].codes[funcstor[seqn].index]==END)
							{
							done=1;
							perffunc(seqn);
							}
						}
					else
						clrfuncstor(seqn);
					break;
				}
		else
			if(c==emu.funcs[seqn].codes[funcstor[seqn].index])
				{
				ok=1;
				if(emu.funcs[seqn].codes[++funcstor[seqn].index]==END)
					{
					done=1;
					perffunc(seqn);
					}
				}
			else
				clrfuncstor(seqn);
		if(done)
			{
			ok=1;
			for(seqn=0;seqn<NFUNCS;seqn++)
				clrfuncstor(seqn);
			break;
			}
		}
	if(!ok)
		showchar(c);
	}

initdisp()
	{
	int i;
	for(i=0;i<NFUNCS;i++)
		{
		funcstor[i].listindex=LISTSIZ;
		clrfuncstor(i);
		}
	bold=faint=blink=inverse=0;
	fgcolor=WHITE;
	bkcolor=BLACK;
	graphics=0;
	wrap_p=emu.default_wrap_p;
	}

main(argc, argv)
	int argc;
	char **argv;
	{
	FILE *playfd;
	char c;
	struct rccoord posptr;
	int follow, emufd, i, lineflag;
	_getvideoconfig(&vconf);
	_setvideomode(_DEFAULTMODE);
	if(argc!=3)
		{
		printf("Copyright (C) 1992 Peter Edward Cann, all rights reserved.\n");
		printf("USAGE: termplay <emu or - > <script>\n");
		printf("<emu> is an emulation file base pathname.\n");
		printf("<script> is a file of codes to play.\n");
		printf("The environment variable PCCPPATH is used for the emulation file if set.\n\n");
		printf("Any key processes the next character of the script, except that \\r or \\n\n");
		printf("process until that character. Control-C exits.\n");
		exit(1);
		}
	if(!strcmp(getenv("REMOTE"), "YES"))
		{
		printf("You appear to be logged in remotely, judging by the environment\n");
		printf("variable REMOTE, so this is probably a very bad idea.\n");
		printf("Are you sure you want to run TERMPLAY? (y or n) --> ");
		if(getchar()!='y') /* Note getchar() and not getch()! */
			{
			printf("n\nI didn't think so!\n");
			exit(99);
			}
		else
			printf("y\nOK, you're the boss!\n");
		}
	fpname[0]='\0';
	if(argv[1][0]!='-')
		{
		if((getenv("PCCPPATH")==NULL)||(argv[1][0]=='\\')||(argv[1][0]&&(argv[1][1]==':'))||(argv[1][0]=='.'))
			sprintf(fpname, "%s.emu", argv[1]);
		else
			sprintf(fpname, "%s\\%s.emu", getenv("PCCPPATH"), argv[1]);
		if((emufd=open(fpname, O_RDONLY|O_BINARY))==-1)
			{
			printf("Error opening emulation file %s.\n", fpname);
			exit(2);
			}
		else
			if(read(emufd, &emu, sizeof(emu))!=sizeof(emu))
				{
				printf("Error reading emulation file %s.\n", fpname);
				exit(3);
				}
			else;
		}
	else
		{
		nullemu();
		emu.funcs[0].func=LEFT;
		emu.funcs[0].codes[0]='\b';
		emu.funcs[0].codes[1]=END;
		emu.funcs[1].func=DTAB;
		emu.funcs[1].codes[0]='\t';
		emu.funcs[1].codes[1]=END;
		emu.funcs[2].func=BELL;
		emu.funcs[2].codes[0]='\007';
		emu.funcs[2].codes[1]=END;
		emu.funcs[3].func=DOWN;
		emu.funcs[3].codes[0]='\n';
		emu.funcs[3].codes[1]=END;
		}
	if((playfd=fopen(argv[2], "r"))==NULL)
		{
		printf("Couldn't open script file %s.\n");
		exit(10);
		}
	setmode(fileno(playfd), O_BINARY);
	_clearscreen(_GCLEARSCREEN);
	initdisp();
	atthndl();
	_settextposition(1,1);
	if(vconf.adapter==_VGA)
		_remappalette(GRAY, (long)0x00202020); /* Lighten up gray */
	lineflag=0;
	while(1)
		{
		if((c=getc(playfd))==EOF)
			exit(0);
		updstatus(c);
		if(!lineflag)
			{
			if((lineflag=_bios_keybrd(_KEYBRD_READ)&0xff)==0x03)
				exit(0);
			if((lineflag!='\r')&&(lineflag!='\n'))
				lineflag=0;
			}
		else if(c==lineflag)
			lineflag=0;
		dispport(c);
		}
	}
