@ECHO OFF

CLS
IF "%1"=="" GOTO SYNTAX

ECHO ͻ
ECHO            CDD 3.O with the DOS EXTENDER                     
ECHO                                                              
ECHO           patch from version 3007.2 to 3008                  
ECHO                                                              
ECHO  This patchfile implements fixes to CDD version 3007.2  with 
ECHO  the DOS Extender. Patch will ONLY work on CDD ver 3007.2    
ECHO ͼ

ECHO ͻ
ECHO  If you are using a version prior to 3007.2, you can order   
ECHO  a complete install set from the Customer Service department 
ECHO  at 305-785-4555, for $10.00 plus shipping charges.          
ECHO ͼ

ECHO ͻ
ECHO  Press any key to continue or Control-C to abort.            
ECHO ͼ
pause

if not exist PATCH.EXE GOTO missing_file
if not exist cx72to8.RTP GOTO missing_file

ECHO ͻ
ECHO   Now applying patch to upgrade CDD 3007.2 to revision 3008         
ECHO   If any files are not found, or don't need patching, a message file
ECHO   will be created as Patch.err                                      
ECHO ͼ

PATCH %1 -E cx72to8.rtp

IF ERRORLEVEL 37 GOTO ERRORFILE
IF ERRORLEVEL 36 GOTO BADVER
IF ERRORLEVEL 35 GOTO SYNTAX
IF ERRORLEVEL 34 GOTO NOTADIR
IF ERRORLEVEL 29 GOTO NOSPACE
IF ERRORLEVEL 24 GOTO NONFATAL
IF ERRORLEVEL 16 GOTO NONFATAL
IF ERRORLEVEL 15 GOTO BADVER_15
IF ERRORLEVEL 9 GOTO BAD_PATCHFILE
IF ERRORLEVEL 8 GOTO BAD_PATCHEXE
IF ERRORLEVEL 5 GOTO NOTADIR
IF ERRORLEVEL 4 GOTO NOTADIR
IF ERRORLEVEL 1 GOTO SYNTAX


GOTO patch_complete

:NOTADIR
ECHO ͻ
ECHO  CANNOT FIND A DIRECTORY NAMED:    " %1 "
ECHO ͼ
GOTO SYNTAX

:SYNTAX
ECHO ͻ
ECHO  This patch should be applied by UNZIPPING P3008x.ZIP        
ECHO  then typing:                                                
ECHO                                                              
ECHO   cx72to8 [DRIVE:\DIRECTORY]                                 
ECHO                                                              
ECHO   where [DRIVE:\DIRECTORY] is the name of the drive and path 
ECHO          where CDD 3.0 is installed                          
ECHO                                                              
ECHO                                                              
ECHO   example: if CDD 3.0 is installed in C:\CLARION3            
ECHO            then type cx72to8 C:\CLARION3                     
ECHO                                                              
ECHO ͼ
GOTO EXIT

:ERRORFILE
ECHO   An error occurred when Patch.exe tried opening %1\Patch.err
ECHO ͻ
ECHO  The probable cause is some type of DOS error, retry the operation  
ECHO  after checking the disks integrity.                                
ECHO ͼ
GOTO EXIT

:BADVER
ECHO   Patch.exe CANNOT find version 3007.2 installed in %1
ECHO ͻ
ECHO  error ept0036: Old file not found. However, a file of the same name    
ECHO           was found. No update done since file contents do not match.   
ECHO                                                                         
ECHO  PATCH was unable to locate an exact match for the original file to     
ECHO  be updated. However, PATCH was able to locate a file with the same     
ECHO  name as the original file. However, the file found did not have either 
ECHO  the same size or checksum as the actual original file that PATCH is    
ECHO  seeking in order to perform the update.                                
ECHO ͼ
GOTO EXIT

:BADVER_15
ECHO ͻ
ECHO                                                                         
ECHO  CANNOT find version 3007.2                                             
ECHO  error ept0015: Old file does not exist                                 
ECHO                                                                         
ECHO  PATCH needs Bytes from the existing version of a file in order to build
ECHO  the new file. However, it was unable to locate the old file.           
ECHO ͼ
GOTO EXIT

:NONFATAL
ECHO ͻ
ECHO   These messages indicate the file(s) does not need patching:   
ECHO                                                                 
ECHO   ept0016: New file already exists                              
ECHO   ept0024: New file already exists                              
ECHO                                                                 
ECHO                                                                 
ECHO ͼ

:patch_complete
IF NOT EXIST %1\PATCH.ERR GOTO noerrors
ECHO 
ECHO ͻ
ECHO  The patch process has created a message file       
ECHO                                                     
ECHO              DON'T PANIC!                           
ECHO                                                     
ECHO   The following messages are informational only!    
ECHO                                                     
ECHO   ept0016: New file already exists                  
ECHO   ept0024: New file already exists                  
ECHO                                                     
ECHO                                                     
ECHO   In almost all cases if the patch reached this     
ECHO   point everything is Okay.                         
ECHO ͼ
pause
EDITOR %1\PATCH.ERR

CLS
ECHO ͻ
ECHO  A complete install set is available from Clarion Customer Service    
ECHO  at 305-785-4555 for $10.00 plus shipping charges.                    
ECHO                                                                       
ECHO ͼ

pause
GOTO EXIT

:missing_file
ECHO ͻ
ECHO  Cannot locate patch file(s)                                
ECHO  This patch should be applied by UNZIPPING P3008x.ZIP       
ECHO  then typing:                                               
ECHO                  cx72to8 [DRIVE:\DIRECTORY]                 
ECHO ͼ
GOTO EXIT

:nospace
ECHO ͻ
ECHO                                                             
ECHO  There is insufficient disk space to apply the Patch,       
ECHO  please free up some space and reapply the Patch.           
ECHO                                                             
ECHO ͼ
GOTO EXIT

:BAD_PATCHFILE
ECHO ͻ
ECHO  error ept0009:                                             
ECHO  PATCH.EXE was unable to read the correct information       
ECHO  from the patch file.  Get a new copy and rerun the PATCH   
ECHO                                                             
ECHO ͼ
GOTO EXIT

:BAD_PATCHEXE
ECHO ͻ
ECHO  error ept0008: PATCH.EXE and Patch file are incompatible   
ECHO                                                             
ECHO  You need a new copy of PATCH.EXE to apply this patch.      
ECHO                                                             
ECHO ͼ
GOTO EXIT

:dirtest_failed
ECHO   Unable to create directory \SAVECDD
ECHO ͻ
ECHO  Cannot perform backup of files, we suggest you        
ECHO  backup your files and then rerun the patch            
ECHO  but answer NO to the backup prompt.                   
ECHO ͼ
GOTO EXIT

:noerrors
ECHO  
ECHO ͻ
ECHO   Patch is complete, no errors encountered!      
ECHO ͼ
:EXIT
