* Program..: USPSBC.prg
* Author...: Terry L. Johnson.
* Telephone: (303) 352-8025
* Date.....: 4/15/94.
* Notice...: Copyright 1994,  Terry Johnson Consulting.
* Notes....: To update a field withing a data base
*   which contains the characters necessary to print a Bar code.
*
SET TALK OFF
SET BELL OFF
SET COLOR ON
SET COLOR TO W+/B,W+/R,B
SET INTENSITY ON
* Initialize memory variables...
STORE "zip      " + SPACE(20) TO i_zip
STORE "zip4     " + SPACE(20) TO i_zip4
STORE "dp       " + SPACE(20) TO i_dp
STORE "BarCode  " TO o_bc
SET STATUS OFF
SET SCOREBOARD OFF
SET PRINT OFF
SET CONSOLE ON
* Heading is displayed and parameters are entered...
CLEAR GETS
CLEAR
@ 0,17  SAY "----------------------------------------------"
@ 1,17  SAY "  General Zip Code - Bar Code Field Generation"
@ 3,17  SAY "----------------------------------------------"
@ 5,5   SAY "This screen requests the source FIELDS for calculation of the"
@ 6,5   SAY "Postal Bar Code Print Field, The three fields needed are:"
@ 7,5   SAY "  1) Postal Five digit ZIP code"
@ 8,5   SAY "  2) Postal Four digit ZIP code extension"
@ 9,5   SAY "  3) Postal Delivery Point (Two digit code)"
@ 11,5  SAY "Output Field:";
        GET o_bc PICTURE "@B! XXXXXXXXXX"
@ 12,5  SAY "consists of the characters needed to print the US Postal Bar Code"
@ 12,5  SAY "using the special TTF Font.  The Output Consists of 14 characters"
@ 13,5  SAY "broken up in the following manner:"
@ 15,5  SAY "      1 Character Start Character ([)"
@ 16,5  SAY "      5 Characters Zip Code             ";
        GET i_zip PICTURE  "@B! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
@ 17,5  SAY "      4 Characters Zip + 4 Code         ";
        GET i_zip4 PICTURE "@B! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
@ 18,5  SAY "      2 Characters Delivery Point       ";
        GET i_dp PICTURE   "@B! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
@ 14,5  SAY "      1 Character Base 10 Check Digit"
@ 14,5  SAY "      1 Character Trailing Character (])"
READ
CLEAR
SET STATUS ON
SET SCOREBOARD ON
i_zip = TRIM(i_zip)
IF LEN(i_zip) > 0
  e_zip = .T.
ELSE
  e_zip = .F.
ENDIF
i_zip4 = TRIM(i_zip4)
IF LEN(i_zip4) > 0
  e_zip4 = .T.
ELSE
  e_zip4 = .F.
ENDIF
i_dp = TRIM(i_dp)
IF LEN(i_dp) > 0
  e_dp = .T.
ELSE
  e_dp = .F.
ENDIF
o_bc = TRIM(o_bc)
IF LEN(o_bc) > 0
  e_bc = .T.
ELSE
  e_bc = .F.
ENDIF
******
*   main loop *********************************************
******
GO TOP
DO WHILE .NOT. EOF()
  STORE SPACE(14) TO b_code
*******
*  Process Bar Code if enough Information Present
*******
  IF e_zip .and. e_bc
    STORE  LEFT(&i_zip,5) TO b_code
    IF e_zip4
      IF LEN(TRIM(LEFT(&i_zip4,4))) = 4
        b_code = b_code + LEFT(&i_zip4,4)
        IF e_dp
          IF LEN(TRIM(LEFT(&i_dp,2))) = 2
            b_code = b_code + LEFT(&i_dp,2)
          ENDIF
        ENDIF
      ENDIF
    ENDIF
    STORE  LEN(b_code) TO lnb_code
    STORE  .F. TO pb_code
    IF lnb_code >= 5
      STORE  .T. TO pb_code
      STORE  0 TO dig_sum
      STORE  0 TO lop_e
      DO WHILE lop_e < lnb_code
        lop_e = lop_e + 1
        IF (SUBSTR(b_code,lop_e,1) < "0").or.(SUBSTR(b_code,lop_e,1) > "9")
          pb_code = .F.
        ELSE
          dig_sum = dig_sum + VAL(SUBSTR(b_code,lop_e,1))
        ENDIF
      ENDDO
      STORE  RIGHT(STR(dig_sum,5,0),1) TO un_dig
      IF un_dig = "0"
        b_code = b_code + "0"
      ELSE
        b_code = b_code + STR((10 - VAL(un_dig)),1,0)
      ENDIF
      STORE  LEN(b_code) TO lnb_code
    ENDIF
    IF pb_code
      b_code = "[" + b_code + "]"
      Replace &o_bc with b_code
    ENDIF
  ENDIF
  SKIP
ENDDO while .not.eof
