/* Kuvert/2 2.11 Installation */
'@Echo Off'
Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs
Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX
Call SysCls
Say 'Installing Kuvert/2 Version 2.11...'
Say ''
Result = SysFileTree( 'KUVERT.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: KUVERT.EXE not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'KUVERT.HLP', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: KUVERT.HLP not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'PRINTQ.DLL', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: PRINTQ.DLL not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'KUVERT.DAT', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: KUVERT.DAT not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'KUVERT.DOC', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: KUVERT.DOC not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'LICENSE.TXT', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: LICENSE.TXT not found! Installation cancelled.'
  Signal DONE
  End
Say 'Please enter the full name of the directory you want to'
Say 'have Kuvert/2 installed to (default is C:\OS2\APPS): '
Pull Directory
If Directory = "" Then Directory = 'C:\OS2\APPS'
Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'ERROR: Unable to create directory. Installation cancelled.'
    Signal DONE
    End
  End
Folder = '<WP_DESKTOP>'
Say 'The program object for Kuvert/2 is created on the Desktop.'
Say ''

Say 'Copying KUVERT.EXE to' Directory '...'
Copy KUVERT.EXE Directory                  '1>NUL'
Say 'Copying KUVERT.HLP to' Directory '...'
Copy KUVERT.HLP Directory                  '1>NUL'
Say 'Copying PRINTQ.DLL to' Directory '...'
Copy PRINTQ.DLL Directory                  '1>NUL'
Say 'Copying KUVERT.DAT to' Directory '...'
Copy KUVERT.DAT Directory                  '1>NUL'
Say 'Copying KUVERT.DOC to' Directory '...'
Copy KUVERT.DOC Directory                  '1>NUL'
Say 'Copying LICENSE.TXT to' Directory '...'
Copy LICENSE.TXT Directory                 '1>NUL'
Say ''
Say 'Creating program object...'
Say ''
Type = 'WPProgram'
Title = 'Kuvert/2'
Parms = 'MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\KUVERT.EXE;STARTUPDIR='Directory';ASSOCFILTER=*.DAT;OBJECTID=<KUVERT>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
If Result = 1 Then
  Say 'Kuvert/2 was successfully installed.'
  Say 'Please make sure that the directory' Directory 'is'
  Say 'listed in the LIBPATH statement of your CONFIG.SYS file.'
  Say 'Please read the Extended help online information before'
  Say 'using Kuvert/2.'
  Exit
Else
  Say 'ERROR: Unable to create program object. Installation cancelled.'
  Exit

FAILURE:
Say 'Installation error.'
Signal DONE
HALT:
Say 'Installation error.'
Signal DONE
SYNTAX:
Say 'Installation error.'
Signal DONE
DONE:
Exit
