/* Addrules.Cpp


        Addrules Copyright 1994, Rollin White

        Addrules is a simple program to read an EchoAreaList style file
        and ad the area descriptions it contains to either an .SQR or
        .DSC file for use with Maximus.  For an explaination of their
        difference, please see the Max documentation.

        This is a quick hack.  There are lots of short cuts, bad naming
        conventions, and inefficencies.  But then what good would a hack
        be without them.

        05/31/94        rw  Initial coding.
        06/04/94        rw  Added support for configurable extension
                            Added support for merging files


*/

#include <iostream.h>
#include "tree.h"
#include <stdio.h>
#include <stdlib.h>
#include <String.h>
#include <ctype.h>
#include <errno.h>




/* w_wrap.c */

/*
**  This is an attempt at a useful word-wrap function.  It is given an array
**  of characters ( a string ) and it modifies the string, replacing any
**  new-lines found with spaces and placing new-lines where needed to make
**  lines of the width specified, placing them only where there was previously
**  white-space. ( ie. Words are not split across lines. )  At the present
**  time it is rather stupid. 1) It doesn't know enough to split a line at an
**  existing hyphen.  2) It has no clue about how to hyphenate words.  3) It
**  makes no attempt at dealing intelligently with a singly word longer than
**  the specified line length 4) It does not deal intelligently with multiple
**  spaces new-lines, etc. ( eg. has no clue of paragraph seperation, etc. )
**  OTOH, it does deal well with unformatted, left justified text.
**
**  Tabs will be considered the size specified.  Note that word_wrap() does
**  not actually expand tabs.  This is only to inform it of the number of
**  spaces the output device will expand them to, so it will know how much
**  they expand a line.  The only time word_wrap does anything with tabs, is
**  if the tab size is set to zero, in which case each tab is replaced with a
**  single space character.  This often provides the most useful output, since
**  tabs will often be in the wrong places after re-formatting, and is
**  therfore the default.
**
**
**  Publicly available contents:
**
**      char *word_wrap(char *string,long line_len);
**          Does the actual word-wrapping, as described above;
**          Parameters:
**            string:     actual string to work with
**            line_len:   length of lines for output
**          Returns:        pointer to justified string.
**
**          void set_tab_size(int size);
**            Set the number of spaces that tabs will be expanded to on output
**            default tab size is zero. (each tab replaced with a space char )
**            word_wrap does not actually expand tabs.  This only lets it keep
**            track of how many spaces they take up.  If this is set to
**            zero, each tab will be replaced with a single space.
**
**  Other procedures:
**      int get_word(char *string);
**          returns the number of characters in the next word in string,
**          including leading white-space characters.
**
**  This compiles without warnings and runs with the following compilers:
**      MS Quick C 2.51:
**      Borland C++ 2.0:            either as C or C++
**      GNU C++ 1.39, DOS port:     either as C or C++
**  As far as I know, it uses only portable, standard C constructs.  It should
**  compile and run with little or no modification under nearly any C compiler
**  and environment.
**
**
**  This code was written Nov 16, 1991 by Jerry Coffin.
**  It is hereby placed in the public domain, for free use by any and
**  all who wish to do so, for any use, public, private, or commercial.
*/

#include <stdlib.h>

static int tab_size = 0;                  /* size to consider tabs as */
#define EOL '\n'        /* the end of line character */

static size_t get_word(char *string);     /* returns size of next word*/

void set_tab_size(size_t size)
{
      tab_size = size;
}

void word_wrap(char *string, int line_len)
{
      size_t len,                         /* length of current word */
             current_len = 0;             /* current length of line */
	 size_t start_line = 0;              /* index of beginning if line */
	 int i;

      while (0 != (len = get_word(&string[current_len + start_line])))
	 {
		i=len;
		while(i>=0)
		{
		  if(string[current_len+start_line+i]=='\r' )
		  {
			start_line += current_len + 1 + len;
			current_len=0-len;
			i=-1;
			continue;
		  }
		  i--;
		}
		  if (current_len + len < line_len)
                  current_len += len;
            else
            {
               string[start_line+current_len] = EOL;
			   start_line += current_len + 1;
			   current_len = 0;
		  }
	 }
     return;
}

static size_t get_word(char *string)
{
      register int i = 0, word_len = 0;

      if (!string[0])
            return 0;
      while (isspace(string[i]))
      {
		  if ('\r' == string[i])
		  {
			word_len++;
			break;
		  }
            if ('\t' == string[i])
            {
                  if (0 == tab_size)
                        string[i] = ' ';
                  else  word_len += tab_size-1;
            }
            else if ('\n' == string[i])
                  string[i]=' ';
            word_len++;
            i++;
      }
      while (string[i] && !isspace(string[i++]))
            word_len++;
      return word_len;
}


void ShowUsage( void ){
        cout << "Correct command line is:\n";
        cout << "    ADDRULES <Squish.Cfg> <Elarea.dat> <Ext> [<MergeDir>]\n";
        cout << "    Where:\n";
        cout << "        <Squish.Cfg> is the path and filename of your Squish.Cfg File\n";
        cout << "        <Elarea.Dat> is the path and filename of your ELArea.Dat style file\n";
        cout << "        <Ext> is the three letter extension of the resulting files to have.\n";
        cout << "               Usually SQR or DSC.  For an explaination of the difference,\n";
        cout << "               see the Maximus manual.\n";
        cout << "        <MergeDir> The directory that contains files of the same name as the\n";
        cout << "               area filename to merge with the resulting files.(optional)\n";
        exit(0);
}


/* replace with C++ stream I/O? */

void WriteText ( FILE   *fp, char       *Text){
        if ( fp != NULL )      {
                fputs(Text, fp);
                fputs("\n\n", fp);
        }
}

void GenerateRule( char *FileName, char *Rule, char *Ext) {
        FILE    *fp = NULL;
        char    Path[4096];    /* Plenty of room for an HPFS path */

        if ( FileName != NULL ) {
                strcpy(Path, FileName);
                strcat(Path, ".");
                strcat(Path, Ext);
                fp = fopen(Path, "w");
                word_wrap(Rule, 78);
                WriteText(fp, Rule);
                fclose(fp);
        }
}

int AppendFile ( char *Source, char *AppendFile ){
        FILE    *Src, *Apnd;
        char    Buffer[4096];

        Src = fopen(Source, "a+");
        if ( Src == NULL ){
                return -1;
        }
        Apnd = fopen(AppendFile, "r");
        if ( Apnd == NULL ){
                return -1;
        }
        fputs("\nConference Rules:\n\n", Src);
        while ( !feof(Apnd) ){
                fgets(Buffer, sizeof(Buffer), Apnd);
                fputs(Buffer, Src);
        }
        fclose(Src);
        fclose(Apnd);

}

void MergeFiles( char *BaseFile, char *Ext, char *SourceDir ){

        char    *FileNamePtr;
        char    *DirPtr;
        char    Source[512], Append[512];


        FileNamePtr = strrchr(BaseFile, '\\');
        if (FileNamePtr == NULL )
                return;
        FileNamePtr ++;

        sprintf(Source, "%s.%s", BaseFile, Ext);
        sprintf(Append, "%s\\%s.txt", SourceDir, FileNamePtr);
        AppendFile(Source, Append);
}

int main ( int argc, char *argv[]){

        FILE    *Sqfp, *Elfp;
        binary_tree   SquishList;
        char    Buffer[8192];
        char    *Ptr, *Ptr2, *Ptr3;


        cout << "AddRules V1.0.  Copyright 1994, Rollin White\n";

        if ( argc < 4 ){
                ShowUsage();
        }

        /* argv[1] = Squish.cfg
           argv[2] = Elarea.Dat
           argv[3] = extension
           argv[4] = merge dir
           */

        if ( ( Sqfp = fopen ( argv[1], "r")) == NULL ){
                cerr << "Error opening file " << argv[1] << "\n";
                return -1;
        }
        if (( Elfp = fopen ( argv[2], "r")) == NULL ) {
                cerr << "Error opening file " << argv[2] << "\n";
                return -1;
        }

/* Parses Squish.Cfg.  This method is far from fool proof and will
encounter a few false hits.  The general method is:
        1.  Search for "Echoarea"
        2.  Skip spaces following the text
        3.  Find the next space and terminate the string there.  The
                result is the echotag
        4.  Skip spaces.
        5.  Find the next space and terminate there.  The result is the
                base path for the area.
        6.  The two are added to SquishList which is a template binary
                tree.
*/

        cout << "Reading " << argv[1] << "\n";

        while ( !feof(Sqfp) ){
                fgets(Buffer, sizeof(Buffer), Sqfp);
                Ptr2 = strlwr(Buffer);
                Ptr = strstr (Ptr2 , "echoarea");
                if ( Ptr != NULL ){
                        Ptr += 8;
                        while (isspace(*Ptr))
                                Ptr++;
                        Ptr2 = strchr ( Ptr, ' ');
                        if ( Ptr2 != NULL ){
                                *Ptr2 = '\0';
                                Ptr2++;
                                while ( isspace(*Ptr2) )
                                        Ptr2++;
                                Ptr3 = strchr ( Ptr2, ' ');
                                if ( Ptr3 != NULL ){
                                        *Ptr3 = '\0';
                                        if ( strcmp(Ptr2,"") != 0 && strcmp(Ptr,"") != 0){
                                                SquishList[Ptr] = strdup(Ptr2);
                                                cout << "Processing " << Ptr << "                     \r";
                                        }
                                }
                        }
                }

        }
        fclose (Sqfp);


/* Repeat a similar process for the Echo Area data file.  This time
rather than spaces, we key off of delimter combinations such as quote
comma quote. */

        cout << "\nReading " << argv[2] << "\n";
        while ( !feof(Elfp) ){
                fgets(Buffer, sizeof(Buffer), Elfp);
                Ptr = Buffer+1;
                Ptr2 = strchr(Ptr, '\"');
                if ( Ptr2 != NULL ){
                        *Ptr2 = '\0';
                        Ptr2++;
                        Ptr3 = strstr(Ptr2, "\",\"");
                        if ( Ptr3 != NULL ){
                                Ptr3+=3;
                                Ptr2 = strstr(Ptr3, "\",");
                                if ( Ptr2 != NULL ){
                                        *Ptr2 = '\0';
                                        Ptr2 = SquishList[strlwr(Ptr)];
                                        if ( Ptr2 != NULL ){
                                                GenerateRule(Ptr2,
                                                        Ptr3, argv[3]);

                                                if ( argc == 5) {
                                                        if (argv[4][strlen(argv[4])] == '\\' )
                                                                argv[4][strlen(argv[4])] = '\0';
                                                        MergeFiles(Ptr2,argv[3], argv[4]);
                                                }
                                        }

                                        cout << "Processing " << Ptr << "                     \r";
                                }
                        }
                }
        }
        fclose(Elfp);
}
