/**/
v="$VER: GenMailer Rexx  The Shelter Mailers Generator  Williamson   56.01.55"
CKDOMAIN=1      /* fix domain if fidonet and zone not 1-6             EMSI  */
FIXDOMAIN=0     /* fix domain using Acvt.WPLRX, requires 680x0        EMSI  */
KILLBAD=0       /* 1=hangup on bad password, 0=send PASSWORD.BAD      EMSI  */   
KNOWNAKAONLY=1  /* 1=Use AKAs in SiteCache, 0=Primary address ONLY    EMSI  */
LOOSESPEC=0     /* 1=BOTH pickup and hold link flags presented        EMSI  */
STRICTZMH=1     /* 1=HXT,HRQ presented during UMH                     EMSI  */
SHOWXPRASC=0    /* 1=display xprascii windwon for text files                */
GPFAX=0         /* GPfax */

/* known bad EMSI implementations                              NOT USED YET */
BADEMSI="Portal of Power,D'Bridge,wpl.library,JamMail"

script="GenMailer"
xv=right(v,8);genver=left(xv,5);smver=right(xv,5)
say script" v"genver" The SHELTER v"smver" Mailers Generator by Robert Williamson"
if ~show('L', "rexxsupport.library") then
    if ~addlib("rexxsupport.library", 0, -30, 0) then do
        say "Couldn't access rexxsupport.library !"
        exit 20
    end
if ~show('L',"RexxDosSupport.library") then
    if ~addlib("RexxDosSupport.library", 2, -30, 0) then do
        say "Couldn't access RexxDosSupport.library !"
        exit 20
    end

if (left(ReadVar('KickStart',"R"),2)) < 37 then do
say 'Sorry, AmigaDOS Release 2 or higher is required to use Shelter';exit 20
end
call SetGlobal('SMVER',smver)
call SetGlobal('GENVER',genver)
pragma("W","NULL")
log=show('p',ROOFLOG)
debug=0;wpldebug=0
CLS='0C'x;CSI='9b'x;AOFF=CSI||'0m';BOLD=CSI||'1m';ITALICS=CSI||'3;40m'
mwarn=BOLD||"WARNING:"||AOFF
lf='0A'x;cr='0D'x;nl="\r\n"
wprogress='CON:0/20/620/200/GenMailer v'genver' ['smver'] [Click to Close - ^C to Abort]/INACTIVE/AUTO/WAIT'
call close('STDOUT');call open('STDOUT',wprogress,'W')
call close('STDIN');call open('STDIN','*','R');call writech('STDOUT',CLS)
say " "BOLD||script||AOFF' v'genver||ITALICS||BOLD||" The SHELTER Mailers Generator"||AOFF||" by "BOLD||"Robert Williamson"||AOFF;say

parse upper arg u_mailer mode cfgpath

if u_mailer="" | u_mailer="?" then call usage1(0,0)
u_mailer=strip(u_mailer)
l_mailer=lower(u_mailer)
minitial=upper(left(u_mailer,1))
mode=strip(mode)
roof    =u_mailer=="ROOF"
porticus=u_mailer=="PORTICUS"
gazebo  =u_mailer=="GAZEBO"
umbrella=u_mailer=="UMBRELLA"
power=(roof|porticus)
call SetGlobal('SHELTER',u_mailer)

ROOFLOG=0
if roof then do
ROOFLOG=1
envpath=""    
end;else do   
call makedir("ENV:"u_mailer)
call makedir("ENVARC:"u_mailer)
envpath=u_mailer"/"
end   

if ~roof & ~porticus & ~gazebo & ~umbrella then call usage("Invalid Mailer Name:"||BOLD||u_mailer||AOFF,10)
if roof then call roofusage()
wpldir="CFG:wpl/"
gendir=wpldir||"gen/"||u_mailer||'/'
if cfgpath~="" then gendir=addslash(strip(cfgpath))
srcdir=gendir||"src/"
modemdir=gendir||"modems/"
/* input files */
src=srcdir||u_mailer||'.src'
gencfg=gendir||u_mailer||'GEN.cfg'
cachecfg=gendir||'cache.cfg'
/* output files */
wdir=wpldir||l_mailer
main=wdir||".wpl";menuwpl=wdir||"MENUS.wpl";cfgwpl=wdir||"CFG.wpl"
mdmwpl=wdir||"MODEM.wpl";cachewpl=wdir||"CACHE.wpl";clockwpl=wdir||"CLOCK.wpl"
notifywpl=wdir||"NOTIFY.wpl";callscript ="S:"minitial"call";buscript="S:"minitial"boot"
loggroup=l_mailer||'wpl'
if umbrella then statgroup='umbrellawplstat1'
else statgroup=l_mailer||'wplstat$(line)'
if power then do
    notifylabel=l_mailer||'notify!'
    ftsprod="${ftsflags.$(remote.product)}"
    nameprod="${mname.$(remote.product)}"
end;else do
    notifylabel=l_mailer||'!'
    ftsprod="$(ftsflags.$(remote.product))"
    nameprod="$(mname.$(remote.product))"
end

addemsi=0;domodules=0;doall=0
select
when mode="EMSI" then do
doall=1;addemsi=1;domodules=1
end
when mode="EMSINC" then do
doall=1;addemsi=1;domodules=0
end
when mode="ALL" then do
doall=1;addemsi=0;domodules=1
end
when mode="ALLNC" then do
doall=1;addemsi=0;domodules=0
end
when mode="MODEM" then do
    addfax=ReadVar('FAX')=="TRUE"
    call setserial
    signal genmodems
end
when mode="CACHE" then do
    call setserial
    signal gencache
end
otherwise call usage('Invalid mode:'||BOLD||mode||AOFF,10)
end
call setserial
if doall & domodules then call gencache

if ~open('cfg',gencfg,"R") then CALL errorabort('Cannot open 'gencfg,10)

call SetGlobal('SHELTER',u_mailer)
/*indices*/
it=0;im=0;ib=1;ix=1;ic=0;id=0;iw=0;in=0;is=0;ip=0
ib.1=""
ix.1=""
im.0=""
it.0=""
txtlst=""
bbslst=""
cmdlst=""
adllst=""
wrxlst=""
extlst=""
domainlst=""
myakas=""
if power then menusbuf=";WPLSCRIPT "l_mailer"menus"||lf
cBUF=";WPLSCRIPT "l_mailer"cfg"||lf||"setstatics:"||lf
abUF=""
pBUF=""
utBUF="setutils:"||lf
dialBUF=""
xprBUF=""
ansBUF=""
asBUF=""
faxBUF=""
uuBUF=""
notBUF=""
emsiBUF=""
wzBUF=""
mainBUF=""
userBUF=""
varBUF=""
loopBUF=""
sc_modem=0;sc_init=0;sc_dial=0;sc_answer=0;sc_connect=0;sc_user=0
adduucp=0;addfax=0;addhost=0;addclock=0;addbbs=0;addfreq=0;genmenufile=0;noanswer=0
freqsetup=0;showxpr=0;addspeech=0;sendbanner=0;sendbull=0;primary=0;forcesort=0
nobbs=0;nodoor=0;notext=0;nomagic=0
usexflo=0
setDbuf=""
setAbuf="setakas:"||lf
setHbuf="sethostadr:"||lf
if addemsi & CKDOMAIN then do
ckdBUF='j_ck_emsidomain:'||lf||'Pattern $(remote.address) FIDONET?(1:|2:|3:|4:|5:|6:)#?'||lf||'TrueReturn'||lf
setEbuf=""
end
akas=0
say "Parsing "gencfg
do while ~eof('cfg')
    call writech('STDOUT',".")
    cfgline=strip(translate(ReadLn('cfg')," ",'09'x))
    if (cfgline="" | left(cfgline,2)="/*" | left(cfgline,2)="*/") then iterate
    cfgline=expand(cfgline)
    key=upper(word(cfgline,1))

    if key="ROOFLOG" & upper(dequote(strip(subword(cfgline,2))))="TRUE" then do
        ROOFLOG=1
    end
    if key="NOANSWER" & upper(dequote(strip(subword(cfgline,2))))="TRUE" then do
        if ~umbrella then call errorabort('Invalid option: 'key' for 'u_mailer,10)
        noanswer=1
    end
    if umbrella & key="USEXFLO" & upper(dequote(strip(subword(cfgline,2))))="TRUE" then do
        if ~noanswer then call errorabort('Invalid option: 'key' for 'u_mailer', NOASNWER must be TRUE',10)
        usexflo=1
    end

    if power & key="SYSOPPW" then do
        sysoppw=upper(dequote(strip(subword(cfgline,2))))
    end
    if key="SYSOP" then do
        sysop=dequote(strip(subword(cfgline,2)))
        call SetVars("SYSOP",sysop)
        utBUF=utBUF||'Set host.sysop "'sysop'"'||lf
    end
    if key="CITY" | key="PHONE" | key="FLAGS" then do
        utBUF=utBUF||'Set host.'lower(key)' "'strip(dequote(subword(cfgline,2)))'"'||lf
    end
    if key="AKA" then do
        aka.akas=subword(cfgline,2)
        if power & index(upper(word(cfgline,2)),'UUCP') > 0 then do
            setAbuf=setAbuf||'Set host.uucp' word(aka.akas,1)||lf
            setDbuf=setDbuf||'uucphost:'||lf||'Set host.domain "UUCP" host.address' word(aka.akas,1)||lf||'Return'||lf
            setHbuf=setHbuf||'Cmp $(remote.network) UUCP'||lf||'TrueJump uucphost'||lf
        end
        else akas=akas+1
        if akas=1 then default_address=upper(strip(word(cfgline,2)))
    end
    if key="DIR" then do
        parse var cfgline junk dirvar.id dirname.id .
        if right(dirname.id,1)=":" then CALL errorabort('DIR 'dirname.id' cannot be a VOLUME, must be a path',10)
        if right(dirname.id,1)="/" then CALL errorabort('DIR path 'dirname.id' cannot have a trailing slash',10)
        id=id+1
    end
    if pos(key,"WSPEC,SSPEC,WPOS,SPOS,BOSS") > 0 then call SetVars(key,upper(dequote(strip(subword(cfgline,2)))))
    if ~umbrella & key="ESC-ESC" then escmode=upper(dequote(strip(subword(cfgline,2))))
    if ~umbrella & key="BANNER" then do
        sendbanner=1
        bannerfile=upper(dequote(strip(subword(cfgline,2))))
        if bannerfile="BANNERFILE" | bannerfile="" then do
            say mwarn' No BANNER'
            bannerfile=0
        end;else if ~exists(bannerfile) then call errorabort('Banner 'bannerfile' not found')
    end
    if ~umbrella & key="BULL" then do
        sendbull=1
        bullfile=upper(dequote(strip(subword(cfgline,2))))
        if bullfile="BULLFILE" | bullfile="" then do
            say mwarn' No BULL'
            bullfile=0
        end;else if ~exists(bullfile) then call errorabort('Bulletin 'bullfile' not found')
    end
    if power & key="MENUS" then do
        menuvol="CFG:";menuext=".MENU"
        select
            when upper(word(cfgline,2))="GEN" then genmenufile=0
            when upper(word(cfgline,2))="MAKE" then do
                genmenufile=1
                if word(cfgline,3)="RAM" then menuvol="RAM:"
            end
            otherwise genmenufile=0
        end
    end
    if key="SCROLL" then do
        scl=dequote(strip(word(cfgline,2)))
        Select
            when scl=5 then do
            sc_modem=1;sc_init=1;sc_dial=1;sc_answer=1;sc_connect=1;sc_user=1
            end
            when scl=4 then do
            sc_modem=1;sc_dial=1;sc_answer=1;sc_connect=1;sc_user=1
            end
            when scl=3 then do
            sc_dial=1;sc_answer=1;sc_connect=1;sc_user=1
            end
            when scl=2 then do
            sc_connect=1;sc_user=1
            end
            when scl=1 then sc_user=1
            when scl=0 then nop
            otherwise do
            say;say mwarn' Invalid scroll level:'scl' ,using 0'
            end
        end
    end
    /* TRUE FALSE */
    if key="POLLWIN" | key="XPRWIN" | key="SPEECH" ,
     | key="ACCESS" | key="ALLOWFREQS" | key="FTSFREQS" ,
     | key="ACCEPTCOLLECT" | key="SENDCOLLECT" ,
     | key="DOMAINAWARE" | key="PRIMARYONLY" | key="IGNORENOANSWER" ,
     | key="WFHOST" | key="UUCP" | key="FAX" | key="CLOCK" | key="ONLINE" then do
        bolvar=upper(dequote(strip(subword(cfgline,2))))
        if bolvar="TRUE" | bolvar="FALSE" then call SetVars(key,bolvar)
        else CALL errorabort(key" value "bolvar" must be TRUE or FALSE",10)
        if ~umbrella then do
            if key="SPEECH" & bolvar="TRUE" then addspeech=1
            if key="CLOCK"  & bolvar="TRUE" then addclock=1
            if key="ONLINE" & bolvar="TRUE" then addbbs=1
            if key="UUCP"   & bolvar="TRUE" then adduucp=1
            if key="FAX"    & bolvar="TRUE" then addfax=1
            if key="WFHOST" & bolvar="TRUE" then addhost=1
            if key="ALLOWFREQS" & bolvar="TRUE" then addfreq=1
        end
        if key="XPRWIN" & bolvar="TRUE" then showxpr=1
        if addemsi then do
            if (key="PRIMARYONLY" & bolvar="TRUE") then primary=1
            if (key="DOMAINAWARE" & bolvar="FALSE") then forcesort=1
        end
    end
    if key="CALLWINDOWMIN" | key="REDIALDELAY" | key="BUSYDELAY" then do 
        numvar=strip(word(cfgline,2))
        if datatype(numvar,"NUMERIC") then call SetVars(key,numvar)
        else CALL errorabort(key" value "numvar" must be numeric",10)
    end
    if ~umbrella & key="UMH" then do
        umh=dequote(strip(subword(cfgline,2)))
        call SetVars("UMH",umh)
        utBUF=utBUF||'Set umh "'umh'"'||lf
    end
    if key="PSCREEN" then do
        pscreen=dequote(strip(subword(cfgline,2)))
        call SetVars("SCREEN",pscreen)
        utBUF=utBUF||'Set pscreen "'pscreen'"'||lf
    end
    if key="LOGFILE" then do
        logfile=dequote(strip(subword(cfgline,2)))
        call SetVars("LOGFILE",logfile)
        utBUF=utBUF||'Set logfile "'logfile'"'||lf
    end
    if key="LOGWINDOW" then do
        logwindow=dequote(strip(subword(cfgline,2)))
        if logwindow ~= "" & logwindow ~= "LOGWINDOW" then do
            call SetVars("LOGWINDOW",logwindow)
            utBUF=utBUF||'Set logwindow "'logwindow'"'||lf
        end
    end
    if gazebo & key="FREQCMD" then do
        if addfreq then do
            freqcmd=dequote(strip(subword(cfgline,2)))
            freqsetup=freqsetup+1
        end;else do
            say;say mwarn' Request Server disabled, keyword 'key' ignored'
        end
    end 
    if gazebo & key="FREQCFG" then do
        if addfreq then do
            freqcfg=dequote(strip(subword(cfgline,2)))
            freqsetup=freqsetup+1
        end;else do
            say;say mwarn' Request Server disabled, keyword 'key' ignored'
        end
        
    end 
    if gazebo & key="FREQLOG" then do
        if addfreq then do
            freqlog=dequote(strip(subword(cfgline,2)))
            freqsetup=freqsetup+1
        end;else do
            say;say mwarn' Request Server disabled, keyword 'key' ignored'
        end
    end 
    if key="XFERQ" then do
        ADDRESS COMMAND 'ASSIGN XFERQ:' upper(strip(word(cfgline,2)))
        if RC~=0 then call errorabort('XFERQ: Assign failed',10)
        call SetVars('XFERQ',upper(strip(word(cfgline,2))))   
        ADDRESS COMMAND 'ECHO >XFERQ:hostaddr 'default_address
    end
    if key="NODELIST" then do
        ADDRESS COMMAND 'ASSIGN NODELIST:' upper(strip(word(cfgline,2)))
        if RC~=0 then call errorabort('NODELIST: Assign failed',10)
        call SetVars('NODELIST',upper(strip(word(cfgline,2))))   
    end

    if key="WAKEUP" | key="LOGINWAIT" | key="STACK" | key="PRIORITY" ,
        | key="LAUNCHPRI" | key="NEGOPRI" | key="XFERPRI" then do
        parse var cfgline cfgnumber.in cfgnvalue.in .;in=in+1
    end
    if key="LOOKUP" | key="UUCICO" | key="LOGIN" ,
        | key="FAXSEND" | key="FAXRECV" then do
        parse var cfgline cfgstring.is '"' cfgsvalue.is '"' .;is=is+1
    end
    if key="BAN" then do
        parse var cfgline junk promptname.ip '"' prompt.ip '"' .;ip=ip+1
    end
    if power & (key="WRX" | key="WRM") then do
        parse var cfgline junk wrxcmd.iw '"' wrxdesc.iw '"' .
        if key="WRX" then wrxlst=wrxlst||wrxcmd.iw" "
        iw=iw+1
    end
    if power & key="TEXT" then do
        parse var cfgline junk text.it textpath.it '"' txtdesc.it '"' .;it=it+1
    end
    if power & key="MAGIC" then do
        parse var cfgline junk magicname.im magicpath.im '"' magicdesc.im '"' .;im=im+1
    end
    if power & key="DOOR" then do
        parse var cfgline junk '"' doorname.ix '"' doorcmd.ix ;ix=ix+1
    end
    if ~umbrella & key="BBS" then do
        parse var cfgline junk '"' bbsname.ib '"' bbscmd.ib ;ib=ib+1
    end
    if key="CMD" then do
        parse var cfgline junk cmdname.ic cmdcmd.ic;ic=ic+1
    end
    if power & key="SYSOPBASE" then do
        call SetVars("SYSOPBASE",dequote(strip(subword(cfgline,2))))
    end
end
call close('cfg')
drop cfg

    say;call writech('STDOUT','Compiling')
if power then do
    if ~genmenufile then do
    wmBUF='wplmenu:'||lf||'Print "Sending main menu\n"'||lf
    wmBUF=wmBUF||'Send "'cls||nl'"'||lf||'Send " ͸'nl'"'||lf
    if roof then       wmBUF=wmBUF||'Send "  ۳  The Roof WPL Command Menu  ۲ 'nl'"'||lf
    if porticus then   wmBUF=wmBUF||'Send "  ۳  Porticus WPL Command Menu  ۲ 'nl'"'||lf
    wmBUF=wmBUF                   ||'Send " ;'nl'"'||lf||'Send "'nl'"'||lf
    bmBUF='bbsmenu:'||lf||'Print "Sending bbs menu\n"'||lf||'Send "'cls||nl||copies('20'x,16)||u_mailer' BBS Menu'nl'"'||lf
    mmBUF='magicmenu:'||lf||'Print "Sending magic menu\n"'||lf||'Send "'cls||nl||copies('20'x,16)||u_mailer' Magic DownLoad Menu'nl'"'||lf
    tmBUF='textmenu:'||lf||'Print "Sending text menu\n"'||lf||'Send "'cls||nl||copies('20'x,16)||u_mailer' Bulletin Menu'nl'"'||lf
    dmBUF='doormenu:'||lf||'Print "Sending door menu\n"'||lf||'Send "'cls||nl||copies('20'x,16)||u_mailer' Door Menu'nl'"'||lf
    end;else do
    MainMenuBuf=cr                            ||" ͸"||cr
    if roof then       MainMenuBuf=MainMenuBuf||"  ۳  The Roof WPL Command Menu  ۲ "||cr
    if porticus then   MainMenuBuf=MainMenuBuf||"  ۳  Porticus WPL Command Menu  ۲ "||cr
    MainMenuBuf=MainMenuBuf                   ||" ;"||cr
    BBSmenuBUF=cr||copies('20'x,16)'The 'u_mailer' BBS Menu'||cr
    MagicMenuBuf=cr||copies('20'x,16)'The 'u_mailer' Magic DownLoad Menu'||cr
    TextMenuBuf=cr||copies('20'x,16)'The 'u_mailer' Bulletin Menu'||cr
    DoorMenuBuf=cr||copies('20'x,16)'The 'u_mailer' Door Menu'||cr
    end
end
    default=0
    do x=0 to akas-1
        call writech('STDOUT','.')
        if index(aka.x,"UUCP") > 0 then iterate

        PARSE var aka.x domain.x '#' zone.x ':' net.x '/' node.x '.' point.x '"' sitename.x '"' wazoo.x zones.x
        zones.x=strip(zones.x)
        if ~default then do
            defaultdomain=domain.x
            default=1
        end
        tmpadr=strip(zone.x':'net.x'/'node.x'.'point.x)
        call SetVars('HOST.ADDRESS.'upper(domain.x),tmpadr)
        domainlst=domainlst||" "upper(domain.x) strip(zone.x)

        if addemsi then do
            if point.x=0 then tmpaka=zone.x":"net.x"/"node.x"@"strip(domain.x)
            else tmpaka=zone.x":"net.x"/"node.x"."strip(point.x)"@"strip(domain.x)
            myakas=myakas||tmpaka||" "
            setAbuf=setAbuf||'Set host.aka.'||upper(domain.x) tmpaka||lf
        end

        setAbuf=setAbuf||'Set host.address.'||upper(domain.x) tmpadr 'host.wzdomain.'||upper(domain.x) domain.x"."wazoo.x||lf
        setAbuf=setAbuf||'Set host.sitename.'||upper(domain.x) '"'sitename.x'"'||lf
        setDbuf=setDbuf||domain.x||'host:'||lf||'Set host.domain 'upper(domain.x)||lf||'Jump sethost'||lf
if addemsi & CKDOMAIN then do
    setDbuf=setDbuf||domain.x||'remote:'||lf||'Set remote.domain 'upper(domain.x)||lf||'Jump setemsidomain'||lf
end
        if domain.x ~= defaultdomain then do
            setHbuf=setHbuf||'Pattern $(remote.address) ('domain.x'|#?'
if addemsi & CKDOMAIN then setEbuf=setEbuf||'Pattern $(remote.address) #?'
            if words(zones.x)=1 then do
                setHbuf=setHbuf||zones.x':)#?'||lf
if addemsi & CKDOMAIN then setEbuf=setEbuf||zones.x':#?'||lf
            end;else do
                setHbuf=setHbuf||"("
if addemsi & CKDOMAIN then setEbuf=setEbuf||"("
                do j=1 to words(zones.x)-1
                    setHbuf=setHbuf||word(zones.x,j)||':|'
if addemsi & CKDOMAIN then setEbuf=setEbuf||word(zones.x,j)||':|'
                end
                setHbuf=setHbuf||word(zones.x,j)||':))#?'||lf
if addemsi & CKDOMAIN then setEbuf=setEbuf||word(zones.x,j)||':)#?'||lf
            end
            setHbuf=setHbuf||'TrueJump 'domain.x'host'||lf
if addemsi & CKDOMAIN then setEbuf=setEbuf||'TrueJump 'domain.x'remote'||lf
        end
    end
    setHbuf=setHbuf||'Jump 'defaultdomain'host'||lf
if addemsi & CKDOMAIN then setEbuf=setEbuf||'Jump unknownemsidomain'||lf
    if addemsi then setAbuf=setAbuf||'Set host.addresses "'strip(myakas)'"'||lf

    setAbuf=setAbuf||'Return'||lf
    setAbuf=space(setAbuf,1)

    if roof then call SetVars("DOMAIN",upper(defaultdomain))
    else call SetVars("FTNDOMAIN",upper(defaultdomain))

    call SetVars("DOMAINLIST",strip(upper(domainlst)))
    call SetVars(minitial'CFG','TRUE')

    aBUF=aBUF||setHbuf||setDbuf
    drop setHbuf setDbuf

if addemsi & CKDOMAIN then do
setEbuf=setEbuf||'setemsidomain:'||lf||'Set inbound $(inbound.$(remote.domain))'||lf
setEbuf=setEbuf||'SetA remote $(remote.domain)#$(remote.zone):$(remote.net)/$(remote.node).$(remote.point)'||lf
setEbuf=setEbuf||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.remote) $(remote.address) $(p.number) $(remote.number)"'||lf
setEbuf=setEbuf||'Return'||lf
setEbuf=setEbuf||'unknownemsidomain:'||lf||'Set inbound $(nonsecure)'||lf||'Return'||lf
aBUF=aBUF||ckDbuf||setEbuf
end

    aBUF=aBUF||'sethost:'||lf||'Set host.wzdomain $(host.wzdomain.$(host.domain))'||lf
    aBUF=aBUF||'Set inbound $(inbound.$(host.domain))'||lf||'Set host.sitename $(host.sitename.$(host.domain))'||lf
    aBUF=aBUF||'SetA host $(host.domain)#$(host.address.$(host.domain))'||lf
    aBUF=aBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.host) $(host.address) $(p.inbound) SECURE $(p.hfreqs) $(host.freq)"'||lf
    aBUF=aBUF||'Return'||lf

    aBUF=aBUF||'setremote:'||lf||'CmpI $(remote.domain) $(host.domain)'||lf||'TrueReturn'||lf
    aBUF=aBUF||'SetA remote $(host.domain)#$(remote.zone):$(remote.net)/$(remote.node).$(remote.point)'||lf
    aBUF=aBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.remote) $(remote.address) $(p.number) $(remote.number)"'||lf
    aBUF=aBUF||'Return'||lf

    /* set dirs*/
    do i=0 to id-1
        call writech('STDOUT',".")
        if upper(dirvar.i)="OUTDIR" then utBUF=utBUF||'Set outbound' dirname.i"/"||lf
            else utBUF=utBUF||'Set 'dirvar.i dirname.i"/"||lf
        call SetVars(upper(dirvar.i),upper(dirname.i))
    end
    singleinbound=GetClip('DOMAINAWARE')=="TRUE"
    dl=GetClip('DOMAINLIST')
    do ftn=1 to words(dl)-1 by 2
        call writech('STDOUT',".")
        if singleinbound then utBUF=utBUF||'Set inbound.'strip(word(dl,ftn))' $(indir)'||lf
        else utBUF=utBUF||'Set inbound.'strip(word(dl,ftn))' $(indir)'strip(word(dl,ftn))'/'||lf
    end
    /*number*/
    do i=0 to in-1
        call writech('STDOUT',".")
        cBUF=cBUF||'Set 'lower(cfgnumber.i) cfgnvalue.i||lf
        if upper(cfgnumber.i)="STACK" then stack=strip(cfgnvalue.i)
        if upper(cfgnumber.i)="XFERPRI" then xferpri=strip(cfgnvalue.i)
        if upper(cfgnumber.i)="NEGOPRI" then negopri=strip(cfgnvalue.i)
        if upper(cfgnumber.i)="LAUNCHPRI" then launchpri=strip(cfgnvalue.i)
    end
    /*string*/
    do i=0 to is-1
        call writech('STDOUT',".")
        cBUF=cBUF||'Set 'lower(cfgstring.i) '"'cfgsvalue.i'"'||lf
    end

    do i=0 to ip-1
        call writech('STDOUT',".")
        pBUF=pBUF||'Set 'strip(promptname.i) '"'prompt.i'"'||lf
    end

if power then do
    /*WRX*/
    rexxdir=addslash(GetCLip('REXXDIR'))
    do i=0 to iw-1
        call writech('STDOUT',".")
        wrxcmd.i=strip(wrxcmd.i)
        if (index(wrxlst,wrxcmd.i) > 0) & ~exists(rexxdir||wrxcmd.i||".WPLRX") then call errorabort("Command" rexxdir||wrxcmd.i||".WPLRX does not exist",40)
        if ~addfreq & (wrxcmd.i="GRAB" | wrxcmd.i="WFREQIT") then call errorabort("Request Handler disabled, Command" rexxdir||wrxcmd.i||".WPLRX CANNOT be used",40)
        if upper(wrxdesc.i)~="NA" then do
            if ~genmenufile then wmBUF=wmBUF||'Send "  'left_justify(upper(wrxcmd.i),14)||wrxdesc.i||nl'"'||lf
            else MainMenuBuf=MainMenuBuf||"  "left_justify(upper(wrxcmd.i),14)||wrxdesc.i||cr
        end
    end
    utBUF=utBUF||'Set wrxlist "'space(wrxlst,1)'"'||lf

    /*TEXT*/
    /* set text and command menu */
    if text.0="" then do
        say;Say mwarn||"No text menu"
        notext=1
    end;else do
        notext=0
        if ~genmenufile then wmBUF=wmBUF||'Send "  'left_justify("INFO",14)||'Information and Bulletins'nl'"'||lf
        else MainMenuBUF=MainMenuBUF||"  "left_justify("INFO",14)||"Information and Bulletins"||cr
        do i=0 to it-1
            call writech('STDOUT',".")
            textpath.i=strip(textpath.i)
            if ~exists(textpath.i) then do
                say;say mwarn" Text" textpath.i" does not exist, ignoring"
                iterate
            end
            utBUF=utBUF||'Set 'text.i textpath.i||lf
            txtlst=txtlst||text.i||" "
            if upper(txtdesc.i)~="NA" then do
                if ~genmenufile then tmBUF=tmBUF||'Send "  'left_justify(upper(text.i),14)||txtdesc.i||nl'"'||lf 
                else textMenuBuf=TextMenuBuf||"  "left_justify(upper(text.i),14)||txtdesc.i||cr
            end
        end
        utBUF=utBUF||'Set textlist "'strip(txtlst)'"'||lf
        if ~genmenufile then tmBUF=tmBUF||'Send "'nl'  Enter text name or hit Return to return to main menu: "'||lf||'Return'||lf
        else TextMenuBuf=TextMenuBuf||cr||"  Enter text name or hit Return to return to main menu: "||cr
    end

    /*MAGIC*/
    if magicname.0="" then do
        say;say mwarn||"No MAGIC menu"
        nomagic=1
    end;else do
        nomagic=0
        if ~genmenufile then wmBUF=wmBUF||'Send "  'left_justify("MAGIC",14)||'Magic Downloads - no byte limits'nl'"'||lf
            else MainMenuBuf=MainMenuBUF||"  "left_justify("MAGIC",14)||"Magic Downloads - no byte limits"||cr
        do i=0 to im-1
            call writech('STDOUT',".")
            magicpath.i=strip(magicpath.i)
            if ~exists(magicpath.i) then do
                say;say mwarn" Magic File" magicpath.i" does not exist"
            end
            utBUF=utBUF||'Set 'magicname.i'.file' get_fn(magicpath.i)||lf
            utBUF=utBUF||'Set 'magicname.i'.full' magicpath.i||lf
            utBUF=utBUF||'Set 'magicname.i'.desc "'magicdesc.i'"'||lf
            adllst=adllst||magicname.i||" "
            if upper(magicdesc.i)~="NA" then do
                if ~genmenufile then mmBUF=mmBUF||'Send "  'left_justify(upper(magicname.i),14)||magicdesc.i||nl'"'||lf
                else MagicMenuBuf=MagicMenuBuf||"  "left_justify(upper(magicname.i),14)||magicdesc.i||cr
            end
        end
        if ~genmenufile then mmBUF=mmBUF||'Send "'nl'  Enter MAGIC name or hit Return to return to main menu: "'||lf||'Return'||lf
        else MagicMenuBuf=MagicMenuBuf||cr||"  Enter MAGIC name or hit Return to return to main menu: "||cr
        utBUF=utBUF||'Set adllist "'strip(adllst)'"'||lf
    end

    /*BBS*/
    if bbs.1="" then do
        say;say mwarn||"No BBS menu"
        nobbs=1
        call SetVars('BBS','FALSE')
    end;else do
        nobbs=0
        if ~genmenufile then wmBUF=wmBUF||'Send "  'left_justify("BOARD",14)||'Select a Bulletin Board System'nl'"'||lf
        else MainMenuBUF=MainMenuBUF||"  "left_justify("BOARD",14)||"Select a Bulletin Board System"||cr
        do i=1 to ib-1
            call writech('STDOUT',".")
            utBUF=utBUF||'Set bbsname.'i '"'bbsname.i'"'||lf
            utBUF=utBUF||'Set bbs.'i '"'strip(bbscmd.i)'"'||lf
            if ~genmenufile then bmBUF=bmBUF||'Send "  'left_justify(i,14)||bbsname.i||nl'"'||lf
                else BBSmenuBUF=BBSmenuBUF||"  "left_justify(i,14)||bbsname.i||cr
            bbslst=bbslst||i||" "
        end
        utBUF=utBUF||'Set bbslist "'strip(bbslst)'"'||lf
        if ~genmenufile then bmBUF=bmBUF||'Send "'nl'  Enter number of BBS or hit Return to return to main menu: "'||lf
            else BBSmenuBUF=BBSmenuBUF||cr||"  Enter number of BBS or hit Return to return to main menu: "||cr
        call SetVars('BBS',"TRUE")
    end

    /*DOOR*/
    if door.1="" then do
        say;say mwarn||"No DOOR menu"
        nodoor=1
    end;else do
        nodoor=0
        if ~genmenufile then wmBUF=wmBUF||'Send "  'left_justify("DOOR",14)||'Select a Game or Utility Door'nl'"'||lf
        else MainMenuBUF=MainMenuBUF||"  "left_justify("DOOR",14)||"Select a Game or Utility Door"||cr
        do i=1 to ix-1
            call writech('STDOUT',".")
            utBUF=utBUF||'Set doorname.'i '"'doorname.i'"'||lf
            utBUF=utBUF||'Set door.'i '"'strip(doorcmd.i)'"'||lf
            if ~genmenufile then dmBUF=dmBUF||'Send "  'left_justify(i,14)||doorname.i||nl'"'||lf
                else DOORmenuBUF=DOORmenuBUF||"  "left_justify(i,14)||doorname.i||cr
            extlst=extlst||i||" "
        end
        utBUF=utBUF||'Set doorlist "'strip(extlst)'"'||lf
        if ~genmenufile then dmBUF=dmBUF||'Send "'nl'  Enter number of DOOR or hit Return to return to main menu: "'||lf
            else DOORmenuBUF=DOORmenuBUF||cr||"  Enter number of DOOR or hit Return to return to main menu: "||cr
    end

    /*CMD*/
    do i=0 to ic-1
        call writech('STDOUT',".")
        ecmd=strip(dequote(strip(cmdcmd.i)))
        if ecmd~="" & ecmd~="""" then do
            utBUF=utBUF||'Set cmd.^'||cmdname.i '"'ecmd'"'||lf
            cmdlst=cmdlst||cmdname.i||" "
            if index(ecmd,"$$(")>0 then call errorabort("CMD "strip(cmdcmd.i)" cannot contain deferred variables",10)
            if left(ecmd,2)~="${" then call SetVars(upper(cmdname.i),ecmd,'E')
        end
    end
    utBUF=utBUF||'Set cmdlist "'strip(cmdlst)'"'||lf
/* roof & porticus */
end;else do
    do i=0 to ic-1
        call writech('STDOUT',".")
        ecmd=strip(dequote(strip(cmdcmd.i)))
        if index(ecmd,"$$(")>0 then call errorabort("CMD "strip(cmdcmd.i)" cannot contain deferred variables",10)
        if (ecmd~="" & emcd~="""" & left(ecmd,2)~="${") then call SetVars(upper(cmdname.i),ecmd,'E')
    end
end
if gazebo & addfreq then do
    if freqsetup=3 then utBUF=utBUF||'Set freqcmd "Run 'freqcmd' >>'freqlog freqcfg' $$(remfile) $$(infile) \"$$(remote.address)\" $$(baud)"'||lf
    else CALL errorabort('File Request handler setup missing parameters',20)
end

if power then do
    bmBUF=bmBUF||'Return'||lf
    dmBUF=dmBUF||'Return'||lf
    wmBUF=wmBUF||'Return'||lf
    wmBUF=wmBUF||mmBUF||tmBUF||dmBUF
    drop mmBUF tmBUF dmBUF
end /*roof & porticus */


    call writech('STDOUT',".")
if showxpr then cBUF=cBUF||'Set showxpr TRUE'||lf

cBUF=cBUF||'Set postinbound 'notifylabel'postinbound postoutbound 'notifylabel'postoutbound'||lf
cBUF=cBUF||'Set preinbound 'notifylabel'preinbound preoutbound 'notifylabel'preoutbound'||lf
cBUF=cBUF||'Set prefullname 'notifylabel'prefullname postfullname 'notifylabel'postfullname'||lf
cBUF=cBUF||'Set preoutfullname 'notifylabel'preoutfullname postoutfullname 'notifylabel'postoutfullname'||lf
cBUF=cBUF||'Set OwnDev "'notifylabel'showdevowner"'||lf
cBUF=cBUF||'Set host.wzcap  13 host.wzprot "DietIFNA ZedZip ZedZap"'||lf 
if umbrella then do
cBUF=cBUF||'Set host.wzext "-Freq +Domain" host.freq "FALSE"'||lf
end;else do
if addfreq then cBUF=cBUF||'Set host.wzext "+Freq +Domain" host.freq "TRUE"'||lf
else cBUF=cBUF||'Set host.wzext "-Freq +Domain" host.freq "FALSE"'||lf
end
cBUF=cBUF||'SubJump 'l_mailer'cfg!setakas'||lf||'SubJump 'l_mailer'cfg!setutils'||lf
cBUF=space(cBUF,1)

if (umbrella | gazebo) then do
cBUF=cBUF||'Set mname.0 "Fido" ftsflags.0 "ot" mname.5 "OPUS" mname.7 "WPL" mname.12 "FrontDoor" "Binkley" mname.50'||lf
cBUF=cBUF||'Set mname.27 "Paragon" mname.57 "TrapDoor" mname.58 "Welmat" ftsflags.58 "7n,by" mname.66 "Portal of Power"'||lf
cBUF=cBUF||'Set mname.106 "MacWoof" mname.170 "Xenolink" mname.196 "ProMailer" mname.218 "ROOF"'||lf
end

if ROOFLOG then cBUF=cBUF||'Set callsin 1 callsout 11 ftnin 2 ftnout 12 uucpin 3 uucpout 13 faxsin 4 faxsout 14 humanin 5 humanout 15 bbsin 6 bbsout 16 msgin 7 msgout 17 filesin 8 filesout 18 bytesin 9 bytesout 10'||lf

if addemsi then do
cBUF=cBUF||'Set host.mailer "'u_mailer'" host.product DA host.serial "'emsiserial'"'||lf
cBUF=cBUF||'Set host.baud $(linkrate) emsi.link "8N1"'||lf
if addfreq then cBUF=cBUF||'Set emsi.compat "DZA,ZAP,ZMO,SLK,TEL,ARC,XMA"'||lf
else cBUF=cBUF||'Set emsi.compat "DZA,ZAP,ZMO,SLK,TEL,ARC,XMA,NRQ"'||lf
end

cBUF=cBUF||'Return'||lf
cBUF=cBUF||setAbuf
cBUF=cBUF||utBUF
cBUF=cBUF||pBUF||'Return'||lf

drop setAbuf utBUF pBUF
call open('cw',cfgwpl,"W")
call writech('cw',cBUF)
call close('cw')
drop cw cBUF 
say;Say "Wrote "cfgwpl

if power then do
    call writech('STDOUT',"Generating User Menus: ")
    if genmenufile then do
        call writech('STDOUT',"MAIN ")
        call savemenu(menuvol||"MAIN"||menuext,MainMenuBuf)
        drop MainMenuBuf
        if ~nomagic then do
            call writech('STDOUT',"MAGIC ")
            call savemenu(menuvol||"MAGIC"||menuext,MagicMenuBuf)
        end
        drop MagicMenuBuf
        if ~notext then do
            call writech('STDOUT',"INFO ")
            call savemenu(menuvol||"INFO"||menuext,TextMenuBuf)
        end
        drop TextMenuBuf
        if ~nobbs then do
            call writech('STDOUT',"BOARD ")
            call savemenu(menuvol||"BOARD"|menuext,BBSmenuBuf)
        end
        drop BBSmenuBuf
        if ~nodoor then do
            call writech('STDOUT',"DOOR ")
            call savemenu(menuvol||"DOOR"|menuext,DOORmenuBuf)
        end
        drop DOORmenuBuf
        call SetVars('MENUS','FILE')
        say;say "Wrote Menu Files"
    end;else do
        menusbuf=menusbuf||bmBUF||wmBUF
        drop bmBUF wmBUF
        call writech('STDOUT',"MAIN ")
        if ~nomagic then call writech('STDOUT',"MAGIC ")
        if ~notext then call writech('STDOUT',"INFO ")
        if ~nobbs then call writech('STDOUT',"BOARD ")
        if ~nodoor then call writech('STDOUT',"DOOR ")
        call open('cw',menuwpl,"W")
        call writech('cw',menusbuf)
        call close('cw')
        drop cw menusbuf
        say;Say "Wrote "menuwpl
        call SetVars('MENUS','MENU')
    end
end

if ~power then call gennotify
if doall then do
    if power & domodules then call gennotify
    if ~roof then call gencallscript
    if power then call genbootuserscript
    signal genmodems
end
call SaveEnv()
Say 'Generation of 'u_mailer' Mailer completed'
exit

savemenu:
    if ~open('m',arg(1),"W") then call errorabort('Unable to save' arg(1),10)
    call writech('m',arg(2))
    call close('m')
    say 'Wrote 'arg(1)
return

genmodems:
nummodems=0;faxinitdone=0
if ~umbrella then do
    mdmcfgs=showdir(modemdir,'f')
    if words(mdmcfgs)=0 then CALL errorabort('No modem configs in 'modemdir,10)
    mBUF=""
    m1BUF=""
    do i=1 to words(mdmcfgs)
        call genline(modemdir||word(mdmcfgs,i))
        say
    end

    m1BUF=m1BUF||'launchit:'||lf||'SubJump 'l_mailer'cfg!setstatics'||lf||'SubJump 'l_mailer'!setglobals'||lf||'SubJump 'l_mailer'modem!preinit'||lf
    if roof then m1BUF=m1BUF||'RexxMsg FY ROOFLOG "OPENSTATUS WPL $(line)"'||lf
        else m1BUF=m1BUF||'Print "Opening Window\n"'||lf||'RexxMsg "" REXX "$(rexxdir)SHELTER.rexx OPENSTATUS $(line)"'||lf
    m1BUF=m1BUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Launched Slave:$(line) $(modem)"'||lf

    m1BUF=m1BUF||'Set openstatus "CON:0/$($(line).w_offset)/640/40/'u_mailer' Line $(line) $(modem) Status/AUTO/INACTIVE/CLOSE/SCREEN$(pscreen)"'||lf
    m1BUF=m1BUF||'SetStatus NULL:'||lf||'Set priority $(launchpri)'||lf
    m1BUF=m1BUF||'Set RC ${CACHE}'||lf||'FalseReturn'||lf
    m1BUF=m1BUF||'SubJump xcache!setcache'||lf
    m1BUF=m1BUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Loaded Cache"'||lf||'Return'||lf

    m1BUF=m1BUF||'preinit:'||lf||'Set modem "$(modem) $(baudlocked)bps"'||lf
    if sc_modem then m1BUF=m1BUF||'SetStatus "CON:0/10/600/60/PreInit $(modem)"'||lf
    m1BUF=m1BUF||'ModemOpen'||lf||'SetBaud $(lockedrate)'||lf
    m1BUF=m1BUF||'Print "$(state) Baud:$(baud) Locked:$(baudlocked)\n"'||lf||'subJump 'l_mailer'modem!attention'||lf||'TrueJump preinit1'||lf
    m1BUF=m1BUF||'SetBaud $(lockedrate)'||lf||'SubJump 'l_mailer'modem!init'||lf||'Jump preinit2'||lf
    m1BUF=m1BUF||'preinit1:'||lf||'Set state "ModemInit $(modem)"'||lf||'SubJump 'l_mailer'modem!init'||lf||'SetBaud $(lockedrate)'||lf
    m1BUF=m1BUF||'Print "$(state) Baud:$(baud) Locked:$(baudlocked)\n"'||lf||'SubJump 'l_mailer'modem!attention'||lf
    m1BUF=m1BUF||'preinit2:'||lf||'FalseJump initerr'||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(state)"'||lf
    m1BUF=m1BUF||'Print "Preinit OK  $(baud) $(baudlocked)\n"'||lf||'Return'||lf
    m1BUF=m1BUF||'initerr:'||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Modem Dead: $(state)"'||lf
    m1BUF=m1BUF||'RexxMsg NY LOGPROC "FlushLog 'loggroup'"'||lf||'Set RC FALSE'||lf||'SetStatus NULL:'||lf||'Return'||lf

    m1BUF=m1BUF||'attention:'||lf||'ModemClear'||lf||'SmartSend $(atten)'||lf||'GetResponse 30'||lf||'Pattern $(event) #?$(prompt)#?'||lf
    m1BUF=m1BUF||'Print "$(atten) Response:$(event)\n"'||lf||'Return'||lf

    m1BUF=m1BUF||'init:'||lf||'ModemClear'||lf||'SmartSend $(initstring)'||lf||'GetResponse 30'||lf||'Pattern $(event) #?$(prompt)#?'||lf
    m1BUF=m1BUF||'Print "$(initistring) Response:$(event)\n"'||lf||'Return'||lf


    m1BUF=m1BUF||'modeminit:'||lf||'Print "WAKEUP\n"'||lf||'SetBaud $(lockedrate)'||lf
    m1BUF=m1BUF||'SubJump 'l_mailer'modem!attention'||lf||'FalseSubJump 'l_mailer'modem!init'||lf||'Return'||lf

    mBUF=m1BUF||mBUF
/*NOT UMBRELLA*/
end;else do
/*IS UMBRELLA*/
    if ~exists(modemdir||"MODEM.CFG") then CALL errorabort("Cannot find "modemdir"MODEM.CFG",10)
    mBUF='launchit:'||lf
    mBUF=mBUF||'Set openstatus "CON:0/80/600/80/Umbrella Status/INACTIVE/AUTO/CLOSE/SCREEN$(pscreen)"'||lf
    if sc_modem then mBUF=mBUF||'SetStatus $(openstatus)'||lf
    mBUF=mBUF||'Print "Modem Setup\n"'||lf||'Set RC $(locked)'||lf||'TrueSubJump umbrellamodem!preinit'||lf
    mBUF=mBUF||'SubJump umbrellacfg!setstatics'||lf||'SubJump umbrella!setglobals'||lf
    mBUF=mBUF||'Print "Opening Window\n"'||lf||'RexxMsg "" REXX "$(rexxdir)SHELTER.rexx OPENSTATUS"'||lf
    mBUF=mBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Launched Slave:$(line) $(modem)"'||lf
    mBUF=mBUF||'SetStatus NULL:'||lf||'Set priority $(launchpri)'||lf
    mBUF=mBUF||'Set RC ${CACHE}'||lf||'FalseReturn'||lf
    mBUF=mBUF||'SubJump xcache!setcache'||lf
    mBUF=mBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Loaded Cache"'||lf||'Return'||lf
    mBUF=mBUF||'preinit:'||lf||'ModemOpen'||lf||'SetBaud $(lockedrate)'||lf
    mBUF=mBUF||'Print "$(state) Baud:$(baud) Locked:$(baudlocked)\n"'||lf||'subJump umbrellamodem!attention'||lf||'TrueJump preinit1'||lf
    mBUF=mBUF||'SetBaud $(lockedrate)'||lf||'SubJump umbrellamodem!init'||lf||'Jump preinit2'||lf
    mBUF=mBUF||'preinit1:'||lf||'Set state "ModemInit $(modem)"'||lf||'SubJump umbrellamodem!init'||lf||'SetBaud $(lockedrate)'||lf
    mBUF=mBUF||'Print "$(state) Baud:$(baud) Locked:$(baudlocked)\n"'||lf||'SubJump umbrellamodem!attention'||lf
    mBUF=mBUF||'preinit2:'||lf||'FalseJump initerr'||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(state)"'||lf
    mBUF=mBUF||'Print "Preinit OK  $(baud) $(baudlocked)\n"'||lf||'Return'||lf
    mBUF=mBUF||'initerr:'||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Modem Dead: $(state)"'||lf
    mBUF=mBUF||'RexxMsg NY LOGPROC "FlushLog 'loggroup'"'||lf||'Set RC FALSE'||lf||'Return'||lf
    mBUF=mBUF||'attention:'||lf||'ModemClear'||lf'SmartSend $(atten)'||lf||'GetResponse 30'||lf||'Pattern $(event) #?$(prompt)#?'||lf
    mBUF=mBUF||'Print "$(atten) Response:$(event)\n"'||lf||'return'||lf
    mBUF=mBUF||'init:'||lf||'ModemClear'||lf||'SmartSend $(initstring)'||lf
    mBUF=mBUF||'GetResponse 30'||lf||'Pattern $(event) #?$(prompt)#?'||lf||'Print "$(atten) Response:$(event)\n"'||lf||'Return'||lf
    mBUF=mBUF||'modeminit:'||lf||'Print "Reinit\n"'||lf||'SetBaud $(lockedrate)'||lf||'SetStatus NULL:'||lf
    mBUF=mBUF||'SubJump umbrellamodem!attention'||lf||'TrueReturn'||lf
    mBUF=mBUF||'SubJump umbrellamodem!init'||lf||'Return'||lf
    call genline(modemdir||"MODEM.CFG")
    say
end /*UMBRELLA*/
    if debug & log then address 'ROOFLOG' 'logline' left(time(),5) script': mBUF:'length(mBUF)
    call open('wpl',mdmwpl,'w')
    call writech('wpl',mBUF)
    call close('wpl')
    drop wpl mBUF
    say "Wrote" mdmwpl "for" nummodems "lines"
    if mode="MODEM" then return
genmainwpl:
    say 'Generating startup code'
    launches=0
    sBUF=""
    if addhost & power then do
        firstmodem=2
        call genhost
    end;else do
        firstmodem=1
    end

do i=firstmodem to nummodems+1
    sBUF=sBUF||'startup-'i':'||lf
    sBUF=sBUF||'SubJump 'l_mailer'modem!modem'i||lf
    sBUF=sBUF||'SubJump cleargui'||lf
    if islocked.i=1 then do
        tmppri=(xferpri+1)
        sBUF=sBUF||'Set xferpri' tmppri||lf
        tmppri=(negopri+1)
        sBUF=sBUF||'Set negopri' tmppri||lf
/*        tmppri=(launchpri+1)  */
/*        sBUF=sBUF||'Set launchpri' tmppri||lf */

    end
    sBUF=sBUF||'Jump slaveloop '||lf
    if umbrella then leave
end

sBUF=sBUF||'startup:'||lf
sBUF=sBUF||'Set GENVER "'genver'" line 0 stack 50000 priority 0 pscreen "'pscreen'"'||lf
sBUF=sBUF||'SetEnv WPLVER "${WPLname}"'||lf
if roof then do
    sBUF=sBUF||'RexxMsg FY ROOFLOG "LOGLINE $<time> WPL0: ${WPLname} 'genver'"'||lf
    sBUF=sBUF||'Address LOGPROC "OpenLog 'l_mailer'file f ${W_SLAVE_LOGFILE}"'||lf
    sBUF=sBUF||'RexxMsg FY ROOFLOG "LOGLINE $<time> WPL0: OpenLog rooffile f ${W_SLAVE_LOGFILE} returned: $(RESULT1)"'||lf
    sBUF=sBUF||'Address LOGPROC "AddLogGroup 'loggroup  l_mailer'file"'||lf
    sBUF=sBUF||'RexxMsg FY ROOFLOG "LOGLINE $<time> WPL0: AddLogGroup roofwpl rooffile returned: $(RESULT1)"'||lf
end
/* Load Cache */
    sBUF=sBUF||'RexxMsg SY REXX "return exists(\"CFG:WPL/'l_mailer'CACHE.WPL\")"'||lf
    sBUF=sBUF||'Set RC $(result1)'||lf||'FalseJump cache_none'||lf
    sBUF=sBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Loading Cache"'||lf
if ROOFLOG then sBUF=sBUF||'RexxMsg FY ROOFLOG "LOGLINE $<time> WPL0: Loading Cache"'||lf
    sBUF=sBUF||'LoadScript xcache CFG:WPL/'l_mailer'CACHE.WPL'||lf||'FalseJump cache_loaderr'||lf
    sBUF=sBUF||'SetEnv CACHE TRUE'||lf||'Jump loadslaves'||lf
    sBUF=sBUF||'cache_loaderr:'||lf
if ROOFLOG then sBUF=sBUF||'RexxMsg FY ROOFLOG "LOGLINE $<time> WPL0: Load failed Xcache[CFG:WPL/'l_mailer'CACHE.WPL]"'||lf
    sBUF=sBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Load failed RC:$(RC) Xcache[CFG:WPL/'l_mailer'CACHE.WPL]"'||lf||'SetEnv CACHE FALSE'||lf||'Jump loadslaves'||lf
    sBUF=sBUF||'cache_none:'||lf
if ROOFLOG then sBUF=sBUF||'RexxMsg FY ROOFLOG "LOGLINE $<time> WPL0: Xcache[CFG:WPL/'l_mailer'CACHE.WPL] does not exist"'||lf
    sBUF=sBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Xcache[CFG:WPL/'l_mailer'CACHE.WPL] does not exist"'||lf||'SetEnv CACHE FALSE'||lf
    sBUF=sBUF||'loadslaves:'||lf
if addhost & power then do
    sBUF=sBUF||'Launch 'u_mailer'1 'l_mailer'!startup-1 -1 'stack||lf 
if ROOFLOG then sBUF=sBUF||'RexxMsg FY ROOFLOG "LOGLINE $<time> WPL0: Launch of ROOF1 roof!startup-1 -1 'stack' returned $(RC)"'||lf
    launches=launches+1
end

sBUF=sBUF||'RexxMsg NY LOGPROC "PutLog' l_mailer||'wpl $<time> $(line) ${WPLName}/KS:${Kickstart}/WB:${WorkBench}"'||lf

if umbrella then say "Generating Modem launch code"
else say "Generating Modem launch code, BOLD=ENABLED, ITALICS=DISABLED"
if ~umbrella then call writech('STDOUT',"Modem line: ")
do i=firstmodem to nummodems+1
    if dolaunch.i=1 then do
        if ~umbrella then call writech('STDOUT',bold||i||AOFF" ")
        sBUF=sBUF||'Set slaves 'i' line 'i||lf
        sBUF=sBUF||'Launch 'u_mailer||i l_mailer'!startup-'i launchpri stack||lf
        if ROOFLOG then sBUF=sBUF||'RexxMsg FY ROOFLOG "LOGLINE $<time> WPL0: Launch of ROOF'i 'roof!startup-'i launchpri stack' returned $(RC)"'||lf
        sBUF=sBUF||'Address LOGPROC' '"PutLog 'loggroup' $<time> $(line) Launched 'u_mailer||i'"'||lf
        launches=launches+1
    end;else do
        if umbrella then call errorabort('Modem Launch is DISABLED',10)
        else call writech('STDOUT',ITALICS||i||AOFF" ")
        sBUF=sBUF||'Address LOGPROC' '"PutLog 'loggroup' $<time> $(line) 'u_mailer||i' NOT Launched"'||lf
        if ROOFLOG then sBUF=sBUF||'RexxMsg FY ROOFLOG "LOGLINE $<time> WPL0: 'u_mailer||i' NOT Launched"'||lf
    end
    if umbrella then leave
end

say
if ~umbrella & launches=0 then call errorabort('No Modems Launched',10)
sBUF=sBUF||'Set slaves 'launches+1||lf
if ~umbrella then sBUF=sBUF||'System "RXSET SLAVES $(slaves)"'||lf
sBUF=sBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) ${WPLName}/KS:${Kickstart}/WB:${WorkBench}"'||lf
if ROOFLOG then sBUF=sBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Compiled 'u_mailer' Mailer v'genver' Stack: $(stack) Priority: $(priority)"'||lf
    else sBUF=sBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Compiled 'u_mailer' Mailer v'smver' Stack: $(stack) Priority: $(priority)"'||lf
sBUF=sBUF||'RexxMsg NY LOGPROC "FlushLog 'loggroup'" '||lf||'Set RC 0'||lf||'Return'||lf

                                         call genmain
                                         call genwazoo
                         if addemsi then call genemsi
                       if ~umbrella then call genuucp
                                         call genxpr
              if ~umbrella & addfax then call genfax
if ~umbrella & addclock & domodules then call genclock
    else call writech('STDOUT',lf)
                                         call gendialer
                       if ~noanswer then call genanswer
                       if ~umbrella then call genuser
                                         call genloop

if debug & log then call sizebuffers
if power then do
    mainBUF=mainBUF||emsiBUF||wzBUF||xprBUF||faxBUF||uuBUF||aBUF||dialBUF||ansBUF||userBUF||loopBUF
    drop emsiBUF wzBUF xprBUF faxBUF uuBUF dialBUF ansBUF aBUF userBUF loopBUF
end;else do
    mainBUF=mainBUF||notBUF||emsiBUF||wzBUF||xprBUF||faxBUF||uuBUF||aBUF||dialBUF||ansBUF||userBUF||loopBUF
    drop notBUF emsiBUF wzBUF xprBUF faxBUF uuBUF dialBUF ansBUF aBUF userBUF loopBUF
end

if debug & log then address 'ROOFLOG' 'logline' left(time(),5) script': AllBUF:'length(mainBUF)
if ~open('wpl',main,'W') then CALL errorabort("Unable to write "main,40)
call writech('wpl',mainBUF)
call close('wpl')
drop mainBUF

if exists(src) then call join(main,src,main)
                        call genaftersession
                        call genvars

if ~open('wpl',main,'A') then CALL errorabort("Unable to append to "main,40)
srcbuf=readch('wpl')
srcbuf=srcbuf||asBUF||varBUF||sBUF
if debug & log then address 'ROOFLOG' 'logline' left(time(),5) script': SrcBUF:'length(srcBUF)
drop asBUF varBUF sBUF
call writech('wpl',srcbuf)
call close('wpl')
drop srcbuf

if addhost then modems=launches-1
else modems=launches
Say 'Wrote' main 'for' launches 'line launches,' modems 'modems'
call SaveEnv()
say 'Generation of 'u_mailer' completed'
return

genline:
    if ~open('mcfg',arg(1),'R') then CALL errorabort("Cannot open ["arg(1)"]",10)

    f=get_fn(upper(arg(1)))
    parse var f 'MODEM' modem '.CFG'
    if modem="" | modem="MODEM" then do
        if umbrella then modem=1
        else do
            Say 'Skipping Umbrella Modem config file:'arg(1)
            call close('mcfg')
            return
        end
    end
    say 'Compiling 'arg(1)' for line 'modem

    nummodems=nummodems+1

    mBUF=mBUF||"modem"modem":"||lf||'Set line' modem||lf
    dolaunch.modem=1
    inflags="E0"
    outflags=""
    emsiline=0
    bpsBUF="Set"
    dlyBUF="Set"
    dvBUF="Set" 
    do while ~eof('mcfg')
        call writech('STDOUT','.')
        cfgline=strip(translate(ReadLn('mcfg')," ",'09'x))
        if (cfgline="" | left(cfgline,2)="/*" | left(cfgline,2)="*/") then iterate
        cfgline=expand(cfgline)
        key=upper(word(cfgline,1))
        select
            when key="TRYFTS1" then do
                inflags=inflags  ||",G1"
                outflags=outflags||",G1,D1"
            end
            when key="TRYWAZOO" then do
                inflags =inflags ||",G6"
                outflags=outflags||",G6,D6"
            end
            when key="TRYEMSI" then do
                inflags =inflags ||",GE"
/*                outflags=outflags||",GE,DE"   */
                outflags=outflags||",GE"  
                emsiline=1
            end
            when key="LAUNCH" then dolaunch.modem=1
            when key="NOLAUNCH" then dolaunch.modem=0
            when key="LO" then mBUF=mBUF||'Set LO 'word(cfgline,2)||lf
            when key="OFFSET" then mBUF=mBUF||'Set 'modem'.w_offset' word(cfgline,2)||lf
            when key="MODEM" then dvBUF=dvBUF||' modem "'subword(cfgline,2)'"'
            when key="DEVICE" then dvBUF=dvBUF||' Device 'word(cfgline,2)' Unit 'word(cfgline,3)
            when key="RTSCTS" then do
                if word(cfgline,2)="TRUE" then flags=164
                    else flags=160
                dvBUF=dvBUF||' SerFlags' flags
            end
            when key="DTRCTL" then dvBUF=dvBUF||' DTR_Control 'word(cfgline,2)
            when key="BUFFERS" then dvBUF=dvBUF||' SerReadBuf 'word(cfgline,2)' SerWriteBuf 'word(cfgline,3)
            when key="SLOWMODEM" then dlyBUF=dlyBUF||' SlowModem 'word(cfgline,2)
            when key="LOCKED" then do
                locked=strip(upper(word(cfgline,2)))
                if locked="TRUE" then islocked.modem=1
                    else islocked.modem=0
                bpsBUF=bpsBUF||' Locked 'locked
            end
            when key="LOCKEDBPS" then do
                lockbps=strip(word(cfgline,2))
                bpsBUF=bpsBUF||' LockedRate 'lockbps
            end
            when key="LINKBPS" then do
                linkbps=strip(word(cfgline,2))
                bpsBUF=bpsBUF||' LinkRate 'linkbps
            end
            when key="INITWAIT" then dlyBUF=dlyBUF||' InitWait 'strip(word(cfgline,2))' InitLoop 5'
            when key="RESPONSETIMEOUT" then dlyBUF=dlyBUF||' ResponseTimeout 'subword(cfgline,2)

            when key="OK" then mBUF=mBUF||'Set prompt 'word(cfgline,2)||lf||'AddResponse OK 'word(cfgline,2)||lf 
            when key="FIND" then mBUF=mBUF||'AddResponse find "'subword(cfgline,2)' "'||lf
            when key="300" then mBUF=mBUF||'AddResponse 300 "'subword(cfgline,2)'"'||lf
            when key="FAX" then do
                if ~addfax then do
                    say;say mwarn' FAX install disabled, response keyword ignored'
                end;else do
                    mBUF=mBUF||'Set isfax.'modem' TRUE'||lf
                    mBUF=mBUF||'AddResponse 'upper(key)' "'subword(cfgline,2)'"'||lf
                end
            end 
            when key="BUSY" | key="PROGRESS" | key="CID"| key="CONNECT" ,
            | key="VOICE" | key="MAID" | key="LINE" | key="TIMEOUT" | key="ERROR" ,
                then mBUF=mBUF||'AddResponse 'upper(key)' "'subword(cfgline,2)'"'||lf
            when key="RING" then do
                if ~noanswer then mBUF=mBUF||'AddResponse 'upper(key)' "'subword(cfgline,2)'"'||lf
                else call errorabort('Invalid modem response: 'key' for dial only Umbrella',10)
            end                
            when key="ATTEN"  then mBUF=mBUF||'Set Atten "'subword(cfgline,2)'"'||lf
            when key="HANGUP" then mBUF=mBUF||'Set HangupString "'subword(cfgline,2)'"'||lf
            when key="INIT"   then mBUF=mBUF||'Set InitString "'subword(cfgline,2)'"'||lf
            when key="DIAL"   then mBUF=mBUF||'Set DialString "'subword(cfgline,2)'"'||lf
            when key="ANSWER" then do
                if ~noanswer then mBUF=mBUF||'Set AnswerString "'subword(cfgline,2)'"'||lf
                else call errorabort('Invalid modem command: 'key' for dial only Umbrella',10)
            end
            when key="GETPROFILE" then mBUF=mBUF||'Set GetProfileString "'subword(cfgline,2)'"'||lf
            otherwise CALL errorabort('Error in 'arg(1)':'cfgline,10)
        end
    end
    call close('mcfg');drop mcfg

    if ~islocked.modem & (linkbps~=lockbps) then call errorabort('LINKBPS and LOCKBPS not EQUAL for LOCKED FALSE Modem',20)
    if islocked.modem & flags~=164 then call errorabort('RTS/CTS Handshake not set for LOCKED modem',20)

    mBUF=mBUF||dvBUF||lf||dlyBUF||lf
    drop dvBUF dlyBUF
    if emsiline then mBUF=mBUF||'Set emsi.'modem' TRUE inflags.'modem strip(inflags,'L',',') 'outflags.'modem strip(outflags,'L',',')||lf
        else mBUF=mBUF||'Set emsi.'modem' FALSE inflags.'modem strip(inflags,'L',',') 'outflags.'modem strip(outflags,'L',',')||lf
    if locked="TRUE" then do
        bpsBUF=bpsBUF||' BaudLocked 'lockbps' Baud 'linkbps' maxrate 'lockbps
        mBUF=mBUF||'SetBaud 'lockbps||lf
    end;else do
        bpsBUF=bpsBUF||' BaudLocked 'linkbps' Baud 'linkbps' maxrate 'linkbps
        mBUF=mBUF||'SetBaud 'linkbps||lf
    end
    mBUF=mBUF||bpsBUF||lf
    drop bpsBUF
    mBUF=mBUF||'Jump launchit'||lf
return


genuucp:
if adduucp then do
call writech('STDOUT',"UUCP ")
uuBUF='uucpconnect:'||lf
uuBUF=uuBUF||'SubJump ckpresess'||lf||'Cmp dialrc 5'||lf||'TrueJump dodial_exit'||lf
uuBUF=uuBUF||'Set session "OUTBOUND UUCP" state "SESSION $(session) $(remote.address)"'||lf
if ROOFLOG then uuBUF=uuBUF||'RexxMsg FY ROOFLOG "CALLSTATUS $(calltask.$(remote.address)) $(line) $(callcount.$(remote.address)) $(callstart.$(remote.address)) $<time> $(remote.address) CONNECTED"'||lf
uuBUF=uuBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.baud) $(baud) $(p.status) $(session) Connect $(p.host) $(host.address) $(p.session) UUCP $(p.protocol) UUCP-G"'||lf
uuBUF=uuBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) uucpconnect:$(remote.address) $(lastresponse)[$(baud)]"'||lf
if ROOFLOG then uuBUF=uuBUF||'RexxMsg FY ROOFLOG "UPDATE_STAT $(uucpout)"'||lf
uuBUF=uuBUF||'SetPri $(xferpri)'||lf||'Set systemcmd "$(uucico) -o -xx $(uuoptions.$(remote.address)) -s$(remote.address) -DEVICE $(device) -UNIT $(unit)"'||lf
uuBUF=uuBUF||'SubJump runasync'||lf||'ReplyCall 0'||lf||'EndSession all'||lf||'Jump aftersession'||lf
uuBUF=uuBUF||'uucp_inbound:'||lf||'CmpI ${'envpath'UUCP} FALSE'||lf||'FalseJump uucp_inbound.1'||lf
uuBUF=uuBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Denied UUCP login: $(namebuf)"'||lf
uuBUF=uuBUF||'Set txt "'nl'  Sorry $(namebuf), UUCP logins are disabled during system maintenance'nl'  Call back in an hour or so, Thanks.'nl'"'||lf
uuBUF=uuBUF||'SubJump showtxt'||lf||'Jump freeline'||lf
uuBUF=uuBUF||'uucp_inbound.1:'||lf
uuBUF=uuBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.baud) $(baud) $(p.status) $(session) Connect $(p.login) $(namebuf) $(p.session) UUCP $(p.protocol) UUCP-G"'||lf
uuBUF=uuBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) UUCP login: $(namebuf)"'||lf
if ROOFLOG then uuBUF=uuBUF||'RexxMsg FY ROOFLOG "UPDATE_STAT $(uucpin)"'||lf
uuBUF=uuBUF||'RexxMsg "SY,RY" REXX "return delstr(\"$(namebuf)\",1,2)"'||lf||'Set remote.address $(result2)'||lf
if ROOFLOG then uuBUF=uuBUF||'RexxMsg FY ROOFLOG "LOGLINE $<time> WPL$(line): Inbound UUCP Session $(remote.address)"'||lf
uuBUF=uuBUF||'Cmp $(password.$(remote.address)) ""'||lf||'TrueJump getuulogin'||lf||'SubJump getuucached'||lf||'Set pw CACHE listed 1 issecure TRUE'||lf
uuBUF=uuBUF||'Set txt "Whats the Password: "'||lf||'SubJump showtxt'||lf
uuBUF=uuBUF||'GetInbound E2 20'||lf||'Cmp $(event) LOGIN'||lf||'FalseJump do_menu'||lf
uuBUF=uuBUF||'CmpI $(remote.password) $(namebuf)'||lf||'FalseJump badlogin'||lf
uuBUF=uuBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $(line) $<time> Inbound UUCP Session $(remote.sitename)"'||lf
uuBUF=uuBUF||'Set pw "$(pw) OK"'||lf
uuBUF=uuBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.password) $(pw)"'||lf
uuBUF=uuBUF||'SetPri $(xferpri)'||lf||'Set systemcmd "$(uucico) -xx $(uuoptions.$(remote.address)) -Getty -D $(device) -U $(unit)"'||lf
uuBUF=uuBUF||'SubJump runasync'||lf||'Jump aftersession'||lf
uuBUF=uuBUF||'getuulogin:'||lf||'Set systemcmd "$(login) -b$(baud) -lower -oUUSPOOL:logfile -pCFG:passwd -d$(device) -u$(unit) \"$(namebuf)\""'||lf
uuBUF=uuBUF||'SubJump runasync'||lf||'Set tmprc $(RC)'||lf
uuBUF=uuBUF||'Cmp $(tmprc) 1'||lf||'TrueJump badlogin'||lf
uuBUF=uuBUF||'Cmp $(tmprc) 7'||lf||'TrueJump timeout_exit'||lf
uuBUF=uuBUF||'Cmp $(tmprc) 9'||lf||'TrueJump aftersession'||lf
uuBUF=uuBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) UUCP Login returned: $(tmprc)"'||lf
uuBUF=uuBUF||'Jump aftersession'||lf
uuBUF=uuBUF||'badlogin:'||lf||'Set pw "$(pw) BAD"'||lf
uuBUF=uuBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.password) $(pw)"'||lf
uuBUF=uuBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $(line) $<time> Password error $(remote.sitename) $(namebuf) [$(remote.password)]"'||lf
uuBUF=uuBUF||'Jump aftersession'||lf
end;else do
uuBUF='uucpconnect:'||lf||'Print "ERROR: UUCP is not installed\n"'||lf||'Return'||lf||'uucp_inbound:'||lf||'Send "There are no UUCP logins here'nl'"'||lf||'Return'||lf||'getuulogin:'||lf||'Print "ERROR: UUCP is not installed\n"'||lf||'Return'||lf
end
if debug & log then address 'ROOFLOG' 'logline' left(time(),5) script': UucpBUF:'length(uuBUF)
return


gennotify:
say "Generating Resume Handling"
if power then do
notBUF=';WPLSCRIPT 'l_mailer'notify'||lf
notBUF=notBUF||'runsync:'||lf||'CmpI $(systemcmd) ""'||lf||'TrueReturn'||lf||'System $(systemcmd)'||lf'Clear systemcmd'||lf||'Return'||lf
end
else notBUF=""

notBUF=notBUF||'showdevowner:'||lf||'SubJump 'l_mailer'!cleargui'||lf
notBUF=notBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) $(state) $(Owner)"'||lf
notBUF=notBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(Owner) owns device - Waiting"'||lf
if ROOFLOG then notBUF=notBUF||'RexxMsg FY ROOFLOG "UPDATE_STAT $(humanout)'||lf
notBUF=notBUF||'Set RC TRUE'||lf
notBUF=notBUF||'Return'||lf

notBUF=notBUF||'set_resume:'||lf||'Set  resumefile.$(remote.address) $(remfile) resume.cmd "$(resumedir)$(remote.domain).$(remote.zone).$(remote.net).$(remote.node).$(remote.point)"'||lf
if exists("MAIL:ResumeFill") | exists("RAM:ResumeFill") then notBUF=notBUF||'System "ResumeFill $(resume.cmd) $(remote.address) $(tempfile) $(remfile)"'||lf
else do
say;say mwarn" ResumeFill command not found, using ECHO"
notBUF=notBUF||'System "echo  >$(resume.cmd) resume:"'||lf||'System "echo >>$(resume.cmd) Set resumefull.$(remote.address) $(tempfile) resumefile.$(remote.address) $(remfile) resume TRUE"'||lf
notBUF=notBUF||'System "echo >>$(resume.cmd) XprSetFile $(tempfile) $(remfile) F"'||lf||'System "echo >>$(resume.cmd) return"'||lf
end
notBUF=notBUF||'Return'||lf
notBUF=notBUF||'get_resume:'||lf||'Set resume.cmd "$(resumedir)$(remote.domain).$(remote.zone).$(remote.net).$(remote.node).$(remote.point)"'||lf
notBUF=notBUF||'RexxMsg SY REXX "return exists(\"$(resume.cmd)\")"'||lf||'Set RC $(result1)'||lf||'FalseJump get_resume_none'||lf
notBUF=notBUF||'LoadScript xresume $(resume.cmd)'||lf||'FalseJump get_resume_loaderr'||lf||'SubJump xresume!resume'||lf||'LoadScript xresume ""'||lf||'Return'||lf
notBUF=notBUF||'get_resume_loaderr:'||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Load failed RC:$(RC) Xresume[$(resume.cmd)]"'||lf
notBUF=notBUF||'get_resume_none:'||lf||'Set resume FALSE'||lf||'Return'||lf
notBUF=notBUF||'clr_resume:'||lf||'Set resume.cmd "$(resumedir)$(remote.domain).$(remote.zone).$(remote.net).$(remote.node).$(remote.point)"'||lf
if wpldebug then notBUF=notBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Deleting Xresume[$(resume.cmd)]"'||lf
notBUF=notBUF||'LoadScript xresume ""'||lf||'RexxMsg SY REXX "call Delete(\"$(resume.cmd)\")"'||lf
notBUF=notBUF||'Clear resumefull.$(remote.address) resumefile.$(remote.address)'||lf||'Return'||lf
notBUF=notBUF||'prefullname:'||lf
notBUF=notBUF||'Set RC $(fsend)'||lf||'TrueJump preoutfullname'||lf
notBUF=notBUF||'Set RC $(resume)'||lf||'TrueJump preresume'||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) PreFullName Receiving:$(localfile)[$(remfile)][$(filesize)] from $(remote.address)"'||lf
notBUF=notBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) $(session) Receiving $(remfile)"'||lf||'Return'||lf
if power then do
notBUF=notBUF||'preoutfullname:'||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(protocol) PreFullName Sending:$(localfile)[$(remfile)][$(filesize)] to $(remote.address)"'||lf
notBUF=notBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) $(session) Sending $(localfile)[$(remfile)] $(p.protocol) $(protocol)"'||lf||'Return'||lf
end
notBUF=notBUF||'postfullname:'||lf
if (power | sendbull | sendbanner) then do
notBUF=notBUF||'Set tmprc $(RC)'||lf||'Cmp $(protocol) ASCII'||lf||'FalseJump tstrc'||lf
notBUF=notBUF||'Set tmprc TRUE filestatus "Ascii Send OK" cps 240 '||lf
notBUF=notBUF||'tstrc:'||lf||'Set RC $(tmprc)'||lf
end
notBUF=notBUF||'FalseJump xfererr'||lf
notBUF=notBUF||'Set RC $(fsend)'||lf||'TrueJump postoutfullname'||lf
notBUF=notBUF||'Set RC $(resume)'||lf||'TrueJump postresume'||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) PostFullName $(filestatus):$(localfile)[$(remfile)] $(protocol) CPS:$(CPS) ($(CPSP)%) Size:$(filesize)"'||lf
notBUF=notBUF||'Jump in_notify'||lf
notBUF=notBUF||'postoutfullname:'||lf||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) $(session) Sent $(localfile) for $(remfile)"'||lf
notBUF=notBUF||'SubJump 'notifylabel'out_notify'||lf||'Set fsend FALSE'||lf||'Return'||lf
notBUF=notBUF||'preresume:'||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Resuming $(protocol) receive $(remfile)[$(filesize)] $(resumefull.$(remote.address)) $(resumefile.$(remote.address))"'||lf
notBUF=notBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) $(session) Resuming $(remfile)"'||lf||'Return'||lf
notBUF=notBUF||'preinbound:'||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Receiving:$(remfile) [$(filesize)] as $(tempfile) from $(remote.address)"'||lf||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) $(session) Receiving $(remfile)"'||lf
notBUF=notBUF||'Set RC $(resume)'||lf||'FalseSubJump 'notifylabel'set_resume'||lf||'Return'||lf
notBUF=notBUF||'postresume:'||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) PostResume $(filestatus):$(localfile)[$(remfile)] $(protocol) CPS:$(CPS)[$(CPSP)%] Size:$(filesize)"'||lf||'CmpI $(resumefull.$(remote.address)) $(localfile)'||lf
notBUF=notBUF||'FalseJump in_notify'||lf||'Set remfile $(resumefile.$(remote.address)) infile $(inbound)$(remfile)'||lf
notBUF=notBUF||'RexxMsg SY REXX "call rename(\"$(localfile)\",\"$(inbound)\"||\"$(remfile)\")"'||lf||'Jump in_notify'||lf
notBUF=notBUF||'postinbound:'||lf||'FalseJump xfererr'||lf||'in_notify:'||lf
if wpldebug then notBUF=notBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Expected:[$(resumefile.$(remote.address))] Recd:[$(remfile)]"'||lf
notBUF=notBUF||'CmpI $(resumefile.$(remote.address)) $(remfile)'||lf
notBUF=notBUF||'TrueSubJump 'notifylabel'clr_resume'||lf
notBUF=notBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(protocol) $(filestatus):$(infile)[$(remfile)] CPS:$(CPS) ($(CPSP)%) Size:$(filesize)"'||lf
if ROOFLOG then notBUF=notBUF||'RexxMsg FY ROOFLOG "UPDATE_STAT $(bytesin) $(filesize)"'||lf
notBUF=notBUF||'Set RC $(FTS1)'||lf||'FalseJump filenotify'||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) FTS1 Receive $(remfile)"'||lf||'SetA remote fidonet#1:1/1.1'||lf
call writech('STDOUT','Generating WhenRecd Processing: REQ ')
notBUF=notBUF||'filenotify:'||lf
if ~umbrella & addfreq then do
if gazebo then notBUF=notBUF||'Set systemcmd "$(freqcmd)"'||lf
else notBUF=notBUF||'Set systemcmd "Rx $(rexxdir)STARTRFS 'u_mailer' $(line) $(baud) $(host.address) $(infile) $(listed) $(remote.address) $(remote.sysop)"'||lf
notBUF=notBUF||'Pattern $(remfile) #?.REQ'||lf||'FalseJump show_recd'||lf||'Set RC $(host.freq)'||lf||'FalseJump badreq'||lf
notBUF=notBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Processing REQ from $(remote.address)"'||lf||'Jump runsync'||lf||'badreq:'||lf
notBUF=notBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(remote.address) ignored $(session) No-FREQS"'||lf
notBUF=notBUF||'show_recd:'||lf
end /*NOT UMBRELLA*/
if ROOFLOG then notBUF=notBUF||'RexxMsg FY ROOFLOG "SHOWRECD $(line) $(remfile) $(remote.address) $(filesize) $(cps) $(baud)"'||lf

notBUF=notBUF||'Cmp $(issecure) TRUE'||lf||'TrueJump knownsite'||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(remfile) from $(remote.address) is non-secure"'||lf
if power then notBUF=notBUF||'Jump logfiles'||lf
else notBUF=notBUF||'Return'||lf

call writech('STDOUT','SORT ')
notBUF=notBUF||'knownsite:'||lf
notBUF=notBUF||'Cmp $(multihub) FALSE'||lf||'TrueJump notmulti1'||lf
notBUF=notBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Sorting $(remfile) from $(remote.address) with ${'envpath'SORTRECD}" '||lf
notBUF=notBUF||'Set systemcmd "${'envpath'SORTRECD}"'||lf||'Jump ck_mail1'||lf
call writech('STDOUT','MAIL ')
notBUF=notBUF||'notmulti1:'||lf||'Set systemcmd "${'envpath'ARCRECD}"'||lf
notBUF=notBUF||'ck_mail1:'||lf||'Pattern $(remfile) ????????.(MO|TU|WE|TH|FR|SA|SU)[0-9]'||lf||'TrueJump ck_mail22'||lf

notBUF=notBUF||'ck_mail11:'||lf||'Cmp $(multihub) FALSE'||lf||'TrueJump notmulti2'||lf
notBUF=notBUF||'Set systemcmd "${'envpath'SORTRECD}"'||lf||'Jump ck_mail2'||lf
notBUF=notBUF||'notmulti2:'||lf||'Set systemcmd "${'envpath'PKTRECD}"'||lf
notBUF=notBUF||'ck_mail2:'||lf||'Pattern $(remfile) ????????.PKT'||lf||'FalseJump ck_other'||lf
notBUF=notBUF||'ck_mail22:'||lf||'Set mail TRUE'||lf||'TrueSubJump runsync'||lf
notBUF=notBUF||'ck_other:'||lf
if adduucp then do
call writech('STDOUT','UUCP ')
notBUF=notBUF||'Set systemcmd "${'envpath'UUCPRECD}"'||lf||'Pattern $(remfile) X.#?'||lf||'TrueJump runsync'||lf
end
call writech('STDOUT','TIC ')
notBUF=notBUF||'Set systemcmd "${'envpath'TICRECD}"'||lf||'Pattern $(remfile) #?.TIC '||lf
if power then notBUF=notBUF||'FalseJump logfiles'||lf
else notBUF=notBUF||'FalseReturn'||lf
notBUF=notBUF||'Set tic TRUE'||lf||'Jump runsync'||lf

if power then do
call writech('STDOUT','UPLOAD ')
notBUF=notBUF||'logfiles:'||lf||'Cmp $(session) UPLOAD'||lf||'FalseReturn'||lf||'System "Echo >>LOG:needdesc \"$(remfile) $(infile)\""'||lf||'Return'||lf
end
notBUF=notBUF||'preoutbound:'||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Sending:$(localfile) [$(filesize)] as $(remfile) to $(remote.address)"'||lf||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) $(session) Sending $(remfile)"'||lf||'Return'||lf
notBUF=notBUF||'postoutbound:'||lf||'FalseJump xfererr'||lf||'Cmp $(filesize) 0'||lf||'TrueJump zeroerr'||lf
notBUF=notBUF||'out_notify:'||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(filestatus):$(localfile)[$(remfile)] $(protocol) CPS:$(CPS) ($(CPSP)%) Size:$(filesize)"'||lf
if ROOFLOG then do
  notBUF=notBUF||'RexxMsg FY ROOFLOG "UPDATE_STAT $(bytesout) $(filesize)"'||lf
  notBUF=notBUF||'Cmp $(protocol) ASCII'||lf||'TrueReturn'||lf
  notBUF=notBUF||'RexxMsg FY ROOFLOG "SHOWSENT $(line) $(remfile) $(remote.address) $(filesize) $(cps) $(baud)"'||lf
end
notBUF=notBUF||'Return'||lf
notBUF=notBUF||'zeroerr:'||lf||'Set filestatus "$(filestatus) zero-length"'||lf
notBUF=notBUF||'xfererr:'||lf||'Set filestatus "$(filestatus) Resume:$(resume) Send:$(fsend) RC:$(RC)" '||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(protocol) transfer $(filestatus):$(remfile)"'||lf
notBUF=notBUF||'Set fsend FALSE'||lf
notBUF=notBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) Transfer $(filestatus):$(remfile)"'||lf
notBUF=notBUF||'Return'||lf
if debug & log then address 'ROOFLOG' 'logline' left(time(),5) script': NotBUF:'length(notBUF)

if power then do
call open('not',notifywpl,"W")
call writech('not',notBUF)
call close('not')
drop not notBUF
say;Say "Wrote "notifywpl
end
return

genhost:
say 'Generating WPL Function Host'
sBUF=sBUF||'startup-1:'||lf||'Set line 1 modem "WPL Function Host"'||lf||'SubJump setglobals'||lf||'SubJump 'l_mailer'cfg!setstatics'||lf
sBUF=sBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Launched Slave:$(line) $(modem)"'||lf
sBUF=sBUF||'SetStatus NULL:'||lf
if ROOFLOG then do
sBUF=sBUF||'Set sl 70 speech  "Launched Slave:$(line) $(modem)"'||lf
sBUF=sBUF||'RexxMsg FY ROOFLOG "LOGLINE $<time> WPL$(line): $(speech)"'||lf
if addspeech then sBUF=sBUF||'SubJump sayit'||lf
end
if roof then do
    if exists("RPDIR:QUEUEMGR") then sBUF=sBUF||'System "Run >NIL: QUEUEMGR SCHED"'||lf
    else sBUF=sBUF||'RexxMsg "" AREXX "$(rexxdir)QUEUEMGR.rexx SCHED"'||lf
end
sBUF=sBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Waiting for a Command"'||lf
sBUF=sBUF||'exeloop:'||lf||'Set CallInterupt FALSE'||lf||'Clear state remote.text remote.address remote.network'||lf
sBUF=sBUF||'CheckCall'||lf||'TrueJump ck_function'||lf||'Set RC $<abort>'||lf||'TrueJump mailer_exit'||lf
sBUF=sBUF||'Set CallInterupt TRUE'||lf||'WaitEvent 60'||lf||'Jump exeloop'||lf
sBUF=sBUF||'ck_function:'||lf||'Cmp $(remote.network) UUCP'||lf||'FalseJump ck_func'||lf
sBUF=sBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' Received Call: $(remote.text)"'||lf
sBUF=sBUF||'Set state "EXECUTING Script $(remote.text)"'||lf
if sc_modem then sBUF=sBUF||'SetStatus "$(openstatus)"'||lf||'Print "$(state)\n"'||lf
sBUF=sBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Executing WPLrx script:$(rexxdir)$(remote.text)"'||lf
if ROOFLOG then sBUF=sBUF||'RexxMsg FY ROOFLOG "CALLSTATUS 0 $(line) 1 $<time> $<time> $(remote.text) RUNNING"'||lf
sBUF=sBUF||'Address REXX "$(rexxdir)$(remote.text)"'||lf||'ReplyCall $(RC)'||lf
if ROOFLOG then sBUF=sBUF||'RexxMsg FY ROOFLOG "CALLSTATUS 0 $(line) 1 $<time> $<time> $(remote.text) COMPLETED"'||lf
sBUF=sBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Waiting for a Command"'||lf
sBUF=sBUF||'SetStatus NULL:'||lf||'Jump exeloop'||lf
sBUF=sBUF||'ck_func:'||lf||'Cmp $(remote.network) TEXT'||lf||'FalseJump exeloop'||lf
sBUF=sBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' Received Call: $(remote.text)"'||lf
sBUF=sBUF||'Set state "EXECUTING Function $(remote.text)"'||lf
if sc_modem then sBUF=sBUF||'SetStatus "$(openstatus)"'||lf||'Print "$(state)\n"'||lf
sBUF=sBUF||'Pattern $(cmdlist) #?$(remote.text)#?'||lf||'FalseJump exeloop'||lf
sBUF=sBUF||'Set systemcmd $(cmd.$(remote.text))'||lf
sBUF=sBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Executing [$(systemcmd)]"'||lf
sBUF=sBUF||'SubJump runsync'||lf||'ReplyCall $(RC)'||lf
sBUF=sBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(state) returned:$(RC)"'||lf
sBUF=sBUF||'SetStatus NULL:'||lf||'Clear state remote.address remote.network remote.text'||lf
sBUF=sBUF||'Jump exeloop'||lf
sBUF=sBUF||'mailer_exit:'||lf||'Set state "$(modem) CLOSE"'||lf
sBUF=sBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Closing Slave$(line)"'||lf
sBUF=sBUF||'Cmp $(exit) RESTART'||lf||'FalseJump closelogs'||lf||'Jump recompile'||lf
return

genmain:
mainBUF=';WPLSCRIPT 'l_mailer||lf||';$VER: 'u_mailer 'v'smver' GenMailer v'genver||lf
mainBUF=mainBUF||'Print "You Goofed up your config, eh!\n"'||lf||'Return'||lf
mainBUF=mainBUF||'wazoo: Jump j_wazoo'||lf
if addemsi then do
mainBUF=mainBUF||'pwemsi: Jump j_pwemsi'||lf
if CKDOMAIN then mainBUF=mainBUF||'ck_emsidomain: Jump j_ck_emsidomain'||lf
end
if sendbanner then mainBUF=mainBUF||'sendbanner: Jump j_sendbanner'||lf
if sendbull then mainBUF=mainBUF||'sendbull: Jump j_sendbull'||lf
if (sendbanner | sendbull | power) then do
    mainBUF=mainBUF||'ascii_start: Jump j_ascii_start'||lf
    mainBUF=mainBUF||'ascii_end: Jump j_ascii_end'||lf
end
if ~umbrella then do
    mainBUF=mainBUF||'getlookup: Jump j_getlookup'||lf
    mainBUF=mainBUF||'getuulookup: Jump j_getuulookup'||lf
end
mainBUF=mainBUF||'getcached: Jump j_getcached'||lf
if ~umbrella then mainBUF=mainBUF||'getuucached: Jump j_getuucached'||lf
mainBUF=mainBUF||'ck_multiftn: Jump j_ck_multiftn'||lf
mainBUF=mainBUF||'xprdisplay: Jump j_xprdisplay'||lf
mainBUF=mainBUF||'xprend: Jump j_xprend'||lf
mainBUF=mainBUF||'clearglobals: Jump j_clearglobals'||lf
mainBUF=mainBUF||'setglobals: Jump j_setglobals'||lf
if ~umbrella then do
    mainBUF=mainBUF||'do_menu: Jump j_do_menu'||lf
    mainBUF=mainBUF||'user_input: Jump j_user_input'||lf
end
if power then do
    mainBUF=mainBUF||'menu_input: Jump j_menu_input'||lf
    mainBUF=mainBUF||'get_user: Jump j_get_user'||lf
    mainBUF=mainBUF||'showmenu: Jump j_showmenu'||lf
if ~nobbs then mainBUF=mainBUF||'loadbbs: Jump j_loadbbs'||lf
    mainBUF=mainBUF||'loadwplrx: Jump j_loadwplrx'||lf
    mainBUF=mainBUF||'sendhelp: Jump j_sendhelp'||lf
    mainBUF=mainBUF||'sendtext: Jump j_sendtext'||lf
if ~nodoor then mainBUF=mainBUF||'loaddoor: Jump j_loaddoor'||lf
if genmenufile then mainBUF=mainBUF||'sendmenu: Jump j_sendmenu'||lf
end

    mainBUF=mainBUF||'cleargui:'||lf
    mainBUF=mainBUF||'RexxMSG NY LOGPROC "PutLine 'statgroup' $(p.response) $(p.baud) $(p.number) $(p.password) $(p.session) $(p.protocol) $(p.login) $(p.host) $(p.remote) $(p.rsysop) $(p.hoffer) $(p.roffer) $(p.hfreqs) $(p.rfreqs) $(p.inbound) $(p.domain)"'||lf
    mainBUF=mainBUF||'Return'||lf
if addspeech then do
    mainBUF=mainBUF||'sayit:'||lf||'RexxMsg SY REXX "return (GetClip('SAYLEVEL') >= $(sl))"'||lf||'Set RC $(result1)'||lf||'TrueReturn'||lf||'System "run >nil: SAY \"$(speech).\""'||lf
    mainBUF=mainBUF||'Clear speech'||lf||'Return'||lf
end
    mainBUF=mainBUF||'showtxt:'||lf||'Print $(txt)'||lf||'Send $(txt)'||lf||'Clear txt'||lf||'Return'||lf

    mainBUF=mainBUF||'runsync:'||lf||'CmpI $(systemcmd) ""'||lf||'TrueReturn'||lf||'Set tstate $(state) state "EXTERNAL"'||lf
if wpldebug then mainBUF=mainBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Executing: $(systemcmd)" '||lf
    mainBUF=mainBUF||'System $(systemcmd)'||lf||'Set state $(tstate)'||lf||'Clear systemcmd tstate'||lf||'Return'||lf
    mainBUF=mainBUF||'runasync:'||lf||'CmpI $(systemcmd) ""'||lf||'TrueReturn'||lf
if wpldebug then mainBUF=mainBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Executing: $(systemcmd)" '||lf
    mainBUF=mainBUF||'RexxMsg SY REXX "Address COMMAND \"$(systemcmd)\""'||lf||'Set RC $(RESULT1)'||lf||'Clear systemcmd'||lf||'Return'||lf
if ~umbrella then do
mainBUF=mainBUF||'j_getlookup:'||lf||'Seta remote ${$(line).domain}#${$(line).zone}:${$(line).net}/${$(line).node}.${$(line).point}'||lf
mainBUF=mainBUF||'Set pw LOOKUP remote.number ${$(line).number} remote.password ${$(line).password}'||lf
mainBUF=mainBUF||'Set remote.sysop ${$(line).sysop} remote.sitename ${$(line).sitename}'||lf||'Set useline $(line) dial $(DialString)'||lf||'Jump get_exit'||lf
mainBUF=mainBUF||'j_getuulookup:'||lf||'Address REXX "$(rexxdir)uulookup.wplrx $(remote.address)"'||lf
mainBUF=mainBUF||'Set pw LOOKUP remote.sitename $(remote.address) remote.sysop root"'||lf||'Set useline $(line) dial $(DialString)'||lf||'Jump get_exit'||lf
end
mainBUF=mainBUF||'j_getcached:'||lf||'Seta remote $(remote.address)'||lf
if ~umbrella then mainBUF=mainBUF||'j_getuucached:'||lf
mainBUF=mainBUF||'Set pw CACHE remote.number $(number.$(remote.address)) remote.password $(password.$(remote.address))'||lf
mainBUF=mainBUF||'Set remote.sysop $(sysop.$(remote.address)) remote.sitename $(sitename.$(remote.address))'||lf
mainBUF=mainBUF||'get_exit:'||lf
mainBUF=mainBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.host) $(host.address) $(p.password) $(pw) $(p.remote) $(remote.address) $(p.number) $(remote.number) $(p.rsysop) $(remote.sysop) $(remote.sitename)"'||lf
mainBUF=mainBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Network:$(remote.network) Address:$(remote.address)"'||lf
mainBUF=mainBUF||'Return'||lf
mainBUF=mainBUF||'j_ck_multiftn:'||lf||'Set RC $(multi.$(remote.address))'||lf||'FalseReturn'||lf
mainBUF=mainBUF||'SubJump 'l_mailer'!fidonethost'||lf
mainBUF=mainBUF||'Set inbound $(nonsecure) multihub TRUE '||lf
mainBUF=mainBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.inbound) NONSECURE"'||lf
mainBUF=mainBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Tagged $(remote.address) for FTN mail sort"'||lf||'Set RC 0'||lf||'Return'||lf
return

genemsi:
call writech('STDOUT',"EMSI ")
if ~noanswer then do
emsiBUF=emsiBUF||'login_emsi:'||lf
emsiBUF=emsiBUF||'Pattern $(event) #?Portal of Power#?"'||lf||'FalseJump NoPopEmsi'||lf
/*emsiBUF=emsiBUF||'PopEmsi:'||lf||'Send "|**EMSI_NAKA77E|<CTRL-M>"'||lf    */
emsiBUF=emsiBUF||'PopEmsi:'||lf||'SmartSend "**EMSI_NAKEEC3\r"'||lf
emsiBUF=emsiBUF||'NoPopEmsi:'||lf
emsiBUF=emsiBUF||'SetPri $(negopri)'||lf||'Print "Inbound EMSI\n"'||lf
emsiBUF=emsiBUF||'Set host.addresses "'strip(myakas)'"'||lf
/*emsiBUF=emsiBUF||'Send "|**EMSI_NAKA77E|'cr'"'||lf */

emsiBUF=emsiBUF||'XprSetup wplemsi.library "Receive"'||lf||'XprReceive ""'||lf||'XprClose'||lf
emsiBUF=emsiBUF||'set RC $(EMSI)'||lf||'FalseJump bademsilogin'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) EMSI HandShake OK $(remote.address)"'||lf
if FIXDOMAIN then emsiBUF=emsiBUF||'Address REXX "$(rexxdir)ACVT.wplrx $(remote.addresses)"'||lf
emsiBUF=emsiBUF||'Seta Remote $(remote.addresses)'||lf
if ~FIXDOMAIN & CKDOMAIN then emsiBUF=emsiBUF||'SubJump ck_emsidomain'||lf
emsiBUF=emsiBUF||'SubJump pwemsi'||lf
if KILLBAD then emsiBUF=emsiBUF||'FalseJump freeline'||lf
else do
    emsiBUF=emsiBUF||'TrueJump ppwok'||lf
    emsiBUF=emsiBUF||'Set remote.link "$(remote.link),NPU" inbound $(nonsecure)'||lf
    emsiBUF=emsiBUF||'BeginSession BADPASSWORD'||lf
    emsiBUF=emsiBUF||'ppwok:'||lf
end
emsiBUF=emsiBUF||'Set remote.freq FALSE'||lf||'Pattern $(remote.compat) #?NRQ#?'||lf
emsiBUF=emsiBUF||'TrueJump nrqemsi'||lf||'Set remote.freq TRUE'||lf
emsiBUF=emsiBUF||'nrqemsi:'||lf||'Pattern $(remote.link) #?PUP#?'||lf||'FalseJump pupemsi'||lf
emsiBUF=emsiBUF||'BeginSession "$(remote.address) EMSI"'||lf
emsiBUF=emsiBUF||'pupemsi:'||lf||'Pattern $(remote.link) #?NPU#?'||lf||'TrueJump npuemsi'||lf
emsiBUF=emsiBUF||'BeginSession $(remote.address)'||lf

if KNOWNAKAONLY then do
emsiBUF=emsiBUF||'Cmp $(remote.number) ""'||lf||'TrueJump npuemsi'||lf
emsiBUF=emsiBUF||'getakalist:'||lf
emsiBUF=emsiBUF||'RexxMsg "SY,RY" REXX "return(right(compress(\"$(remote.number)\",\"-\"),7))"'||lf
emsiBUF=emsiBUF||'BeginSession "$(akas.$(result2))"'||lf
end;else do
emsiBUF=emsiBUF||'BeginSession "$(remote.addresses) EMSI"'||lf
end
emsiBUF=emsiBUF||'npuemsi:'||lf||'Set state "SESSION INBOUND $(remote.address)"'||lf
if ROOFLOG then emsiBUF=emsiBUF||'RexxMsg FY ROOFLOG "LOGLINE $<time> WPL$(line): Inbound EMSI FTN Session $(remote.address) @ $(baud)"'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) System:[$(remote.sitename)][$(remote.address)] Sysop:$(remote.sysop)"'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Mailer:$(remote.mailer) v$(remote.version)[$(remote.product)]"'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) AKAs:$(remote.addresses)"'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Pass:[$(remote.password)] $(password.$(remote.address))"'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Remote Serial:$(remote.serial)"'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Remote Link:$(remote.link) Compt:$(remote.compat)"'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Host Link:$(host.link) Compt:$(host.compat)"'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Flags:$(remote.flags),$(remote.baud)"'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "FlushLog 'loggroup'"'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) $(state) $(p.host) $(host.address) $(p.remote) $(remote.address) $(p.rsysop) $(remote.sysop) $(remote.sitename) $(p.login) $(remote.mailer) v$(remote.version) $<time>"'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.hoffer) $(host.compat) $(host.link) $(p.roffer) $(remote.compat) $(remote.link) $(p.rfreqs) $(remote.freq) $(p.domain) $(remote.domain)"'||lf
if forcesort then emsiBUF=emsiBUF||'Set multihub TRUE'||lf
emsiBUF=emsiBUF||'Pattern $(Host.Compat) "#?DZA#?"'||lf||'TrueJump DirectZapIn'||lf
emsiBUF=emsiBUF||'Pattern $(Host.Compat) "#?ZAP#?"'||lf||'TrueJump ZedZapIn'||lf
emsiBUF=emsiBUF||'Pattern $(Host.Compat) "#?ZMO#?"'||lf||'TrueJump ZedZipIn'||lf
/*emsiBUF=emsiBUF||'Pattern $(Remote.Compat) "KER#?"'||lf||'TrueJump KermitIn'||lf */
/*emsiBUF=emsiBUF||'Pattern $(Remote.Compat) "JAN#?"'||lf||'TrueJump JanusIn'||lf */
/*emsiBUF=emsiBUF||'Pattern $(Remote.Compat) "HYD#?"'||lf||'TrueJump HydraIn'||lf */
emsiBUF=emsiBUF||'Pattern $(Host.Compat) "#?SLK#?"'||lf||'TrueJump SeaLinkIn'||lf
emsiBUF=emsiBUF||'Pattern $(Host.Compat) "#?TLK#?"'||lf||'TrueJump TeLinkIn'||lf
emsiBUF=emsiBUF||'Jump dietifnain'||lf

emsiBUF=emsiBUF||'bademsilogin:'||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) EMSI HandShake Failed"'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.session) BADEMSI $(remote.addresses)"'||lf
emsiBUF=emsiBUF||'Clear namebuf'||lf||'Jump freeline'||lf

emsiBUF=emsiBUF||'j_pwemsi:'||lf
emsiBUF=emsiBUF||'Cmp $(password.$(remote.address)) ""'||lf||'TrueJump notincache'||lf
emsiBUF=emsiBUF||'CmpI $(password.$(remote.address)) $(remote.password)'||lf||'FalseJump badpwemsi'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Password:OK $(remote.address)"'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.inbound) SECURE $(p.password) CACHE OK"'||lf
emsiBUF=emsiBUF||'Set listed 1 issecure TRUE inbound $(inbound.$(remote.domain)) RC TRUE'||lf||'Return'||lf

emsiBUF=emsiBUF||'notincache:'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Password: NOCACHE $(remote.address) $(remote.number)"'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.inbound) NONSECURE $(p.password) NOCACHE"'||lf
emsiBUF=emsiBUF||'Set listed 0 issecure FALSE inbound $(nonsecure) RC TRUE'||lf||'Return'||lf

emsiBUF=emsiBUF||'badpwemsi:'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Password: BAD $(remote.address) His:[$(remote.password)] Ours:[$(password.$(remote.address))]"'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.inbound) NONSECURE $(p.password) CACHE BAD"'||lf
emsiBUF=emsiBUF||'Set listed 0 issecure FALSE inbound $(nonsecure) RC FALSE'||lf||'Return'||lf
end/* not nonasnwer */

emsiBUF=emsiBUF||'do_emsi:'||lf||'SetPri $(negopri)'||lf||'Print "Outbound EMSI\n"'||lf
if primary then emsiBUF=emsiBUF||'Set host.link "8N1,PUP"'||lf
           else emsiBUF=emsiBUF||'Set host.link "8N1,PUA"'||lf
emsiBUF=emsiBUF||'Set RC $(nopickup)'||lf||'FalseJump do_emsi.1'||lf
emsiBUF=emsiBUF||'Set host.link "8N1,NPU"'||lf
emsiBUF=emsiBUF||'do_emsi.1:'||lf
emsiBUF=emsiBUF||'XprSetup wplemsi.library "Outbound Emsi"'||lf||'XprSend ""'||lf||'XprClose'||lf
emsiBUF=emsiBUF||'set RC $(EMSI)'||lf||'FalseJump bademsihandshake'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) EMSI HandShake OK"'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.session) EMSI_REQ"'||lf
if FIXDOMAIN then emsiBUF=emsiBUF||'Address REXX "$(rexxdir)ACVT.wplrx $(remote.addresses)"'||lf
emsiBUF=emsiBUF||'Pattern $(remote.link) #?HAT#?'||lf||'TrueJump hatemsi'||lf
emsiBUF=emsiBUF||'Seta Remote $(remote.addresses)'||lf||'SubJump ck_emsipoint'||lf
emsiBUF=emsiBUF||'Pattern $(remote.link) #?HXT#?'||lf||'FalseJump hxtemsi'||lf
emsiBUF=emsiBUF||'Set MinSendPri 60'||lf
emsiBUF=emsiBUF||'hxtemsi:'||lf
if KNOWNAKAONLY then do
emsiBUF=emsiBUF||'Set RC "$(akas.$(number.$(remote.address)))"'||lf||'FalseJump noakalist'||lf
emsiBUF=emsiBUF||'BeginSession "$(akas.$(number.$(remote.address)))"'||lf
emsiBUF=emsiBUF||'Set RC $(remote.freq)'||lf||'FalseJump hatemsi'||lf||'FindFreq "$(akas.$(number.$(remote.address)))"'||lf
emsiBUF=emsiBUF||'Jump hatemsi'||lf
emsiBUF=emsiBUF||'noakalist:'||lf||'BeginSession $(remote.address)'||lf
emsiBUF=emsiBUF||'Set RC $(remote.freq)'||lf||'FalseJump hatemsi'||lf||'FindFreq $(called)'||lf
end;else do
emsiBUF=emsiBUF||'BeginSession "$(remote.addresses) EMSI"'||lf
emsiBUF=emsiBUF||'Set RC $(remote.freq)'||lf||'FalseJump hatemsi'||lf||'FindFreq $(called)'||lf
end
emsiBUF=emsiBUF||'hatemsi:'||lf
if forcesort then emsiBUF=emsiBUF||'Set multihub TRUE'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Called:$(called)"'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) AKAs:$(remote.addresses)"'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) System:[$(remote.sitename)][$(remote.address)] Sysop:$(remote.sysop)"'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Mailer:$(remote.mailer) v$(remote.version)[$(remote.product)]"'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Pass:[$(remote.password)] $(password.$(remote.address))"'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Remote Serial:$(remote.serial)"'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Remote Link:$(remote.link) Compt:$(remote.compat)"'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Host Link:$(host.link) Compt:$(host.compat)"'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Flags:$(remote.flags),$(remote.baud)"'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "FlushLog 'loggroup'"'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.host) $(host.address) $(p.remote) $(remote.address) $(p.rsysop) $(remote.sysop) $(remote.sitename) $(p.login) $(remote.mailer) v$(remote.version) $<time>"'||lf
emsiBUF=emsiBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.hoffer) $(host.compat) $(host.link) $(p.roffer) $(remote.compat) $(remote.link) $(p.rfreqs) $(remote.freq) $(p.domain) $(remote.domain)"'||lf
emsiBUF=emsiBUF||'Pattern $(Remote.Compat) "DZA#?"'||lf||'TrueJump DirectZapOut'||lf
emsiBUF=emsiBUF||'Pattern $(Remote.Compat) "ZAP#?"'||lf||'TrueJump ZedZapOut'||lf
emsiBUF=emsiBUF||'Pattern $(Remote.Compat) "ZMO#?"'||lf||'TrueJump ZedZipOut'||lf
emsiBUF=emsiBUF||'Pattern $(Remote.Compat) "SLK#?"'||lf||'TrueJump SeaLinkOut'||lf
/*emsiBUF=emsiBUF||'Pattern $(Remote.Compat) "KER#?"'||lf||'TrueJump KermitOut'||lf */
/*emsiBUF=emsiBUF||'Pattern $(Remote.Compat) "JAN#?"'||lf||'TrueJump JanusOut'||lf */
/*emsiBUF=emsiBUF||'Pattern $(Remote.Compat) "HYD#?"'||lf||'TrueJump HydraOut'||lf */
emsiBUF=emsiBUF||'Pattern $(Remote.Compat) "TLK#?"'||lf||'TrueJump TeLinkOut'||lf
emsiBUF=emsiBUF||'Jump dietifnaout'||lf

emsiBUF=emsiBUF||'ck_emsipoint:'||lf
emsiBUF=emsiBUF||'CmpI $(remote.address) $(host.address)'||lf||'FalseReturn'||lf
emsiBUF=emsiBUF||'Set remote.point 0'||lf||'SetA Remote $(remote.domain)#$(remote.zone):$(remote.net)/$(remote.node).$(remote.point)'||lf
emsiBUF=emsiBUF||'Return'||lf
Return

genwazoo:
call writech('STDOUT',"Installing Handshakes: FTS1 WAZOO ")
wzBUF='j_wazoo:'||lf||'System "Wazoo $(remote.wzcap) $(line).RYH"'||lf
wzBUF=wzBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.remote) $(remote.address) $(p.rsysop) $(remote.sysop) $(remote.sitename) $(p.login) 'nameprod' v$(remote.product_maj).$(remote.product_min) $<time> $(p.rfreqs) $(remote.freq)"'||lf
wzBUF=wzBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) System:[$(remote.sitename)][$(remote.address)] Sysop:$(remote.sysop) Mailer:'nameprod' v$(remote.product_maj).$(remote.product_min)"'||lf
wzBUF=wzBUF||'Set RC $(IsOutbound)'||lf||'FalseJump notin'||lf
wzBUF=wzBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.hoffer) $(host.wzprot) $(host.wzext)" '||lf
wzBUF=wzBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Our Offer: $(host.wzprot) $(host.wzext) $(host.wzdomain)"'||lf
wzBUF=wzBUF||'notin:'||lf||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.roffer)${$(line).RYH} $(p.domain) $(remote.wzdomain)"'||lf
wzBUF=wzBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Remote Offer:${$(line).RYH} $(remote.wzdomain)"'||lf
wzBUF=wzBUF||'checkwzcap:'||lf||'Cmp $(host.wzcap) 1'||lf||'FalseJump wazoo.1.0'||lf||'Set protocol DietIFNA'||lf||'Jump wazoo.4'||lf
wzBUF=wzBUF||'wazoo.1.0:'||lf||'Cmp $(host.wzcap) 4'||lf||'FalseJump wazoo.1.1'||lf||'Set protocol ZedZip'||lf||'Jump wazoo.4'||lf
wzBUF=wzBUF||'wazoo.1.1:'||lf||'Cmp $(host.wzcap) 8'||lf||'FalseJump wazoo.1.2'||lf||'Set protocol ZedZap'||lf||'Jump wazoo.4'||lf
wzBUF=wzBUF||'wazoo.1.2:'||lf||'Set protocol NOCOMMON'||lf||'Jump badwazoo'||lf
wzBUF=wzBUF||'wazoo.4:'||lf||'Set RC $(IsOutbound)'||lf||'TrueJump sentwazoo'||lf||'SubJump 'l_mailer'!sethostadr'||lf||'SubJump 'l_mailer'!setremote'||lf
wzBUF=wzBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.remote) $(remote.address) $(p.hoffer) $(host.wzprot) $(host.wzext)" '||lf
wzBUF=wzBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Our Offer: $(host.wzprot) $(host.wzext) $(host.wzdomain)"'||lf
wzBUF=wzBUF||'Set RC $(number.$(remote.address))'||lf||'FalseJump wazoo.4.0'||lf
wzBUF=wzBUF||'Set pw CACHE listed 1 issecure TRUE remote.number $(number.$(remote.address))'||lf
wzBUF=wzBUF||'CmpI $(password.$(remote.address)) $(remote.password) '||lf||'TrueJump wazoo_password'||lf||'Jump badwazoo'||lf
wzBUF=wzBUF||'wazoo.4.0:'||lf||'Set pw DEFERRED inbound $(nonsecure)'||lf
if umbrella then wzBUF=wzBUF||'Set listed 0 inbound $(nonsecure) issecure FALSE'||lf
wzBUF=wzBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.protocol) $(protocol) $(p.host) $(host.address) $(p.password) $(pw) $(p.inbound) NONSECURE"'||lf||'Set RC TRUE'||lf||'Return'||lf
if ~umbrella then do
wzBUF=wzBUF||'dolookup:'||lf||'Set pw LOOKUP systemcmd "$(lookup) $(remote.address) nodelist: $(line) "'||lf||'SubJump runsync'||lf||'Cmp $(RC) 0'||lf||'FalseJump wazoo_unlisted'||lf
wzBUF=wzBUF||'Set listed 1 remote.number ${$(line).number}'||lf||'Jump wazoo_nopassword'||lf
wzBUF=wzBUF||'wazoo_unlisted:'||lf||'Set listed 0 inbound $(nonsecure) issecure FALSE'||lf
wzBUF=wzBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(remote.address) not in NodeList - Lookup:$(RC) $(listed)"'||lf
wzBUF=wzBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.inbound) NONSECURE"'||lf||'Set RC $(LO)'||lf||'TrueJump badwazoo'||lf
end
wzBUF=wzBUF||'wazoo_nopassword:'||lf||'Set pw "$(pw) NONE"'||lf||'Jump goodwazoo'||lf
wzBUF=wzBUF||'wazoo_password:'||lf||'Set pw "$(pw) OK"'||lf||'Jump goodwazoo'||lf
wzBUF=wzBUF||'sentwazoo:'||lf||'Set pw "$(pw) SENT"'||lf
wzBUF=wzBUF||'goodwazoo:'||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Password $(pw) Selected: $(protocol) Host:$(host.address)"'||lf
wzBUF=wzBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.protocol) $(protocol) $(p.host) $(host.address) $(p.password) $(pw) $(p.number) $(remote.number)"'||lf||'Clear pw'||lf||'Set RC TRUE'||lf||'Return'||lf
wzBUF=wzBUF||'badwazoo:'||lf||'Set pw "$(pw) BAD" inbound $(nonsecure) issecure FALSE'||lf
wzBUF=wzBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) BADWAZOO Cap:$(host.wzcap) Selected:$(protocol) Password:$(pw) His:[$(remote.password)] Ours:[$(password.$(remote.address))][${$(line).password}]"'||lf
wzBUF=wzBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.password) $(pw) $(p.protocol) $(protocol) $(p.number) $(remote.number) $(p.inbound) NONSECURE"'||lf
wzBUF=wzBUF||'Clear pw'||lf||'Set RC FALSE'||lf||'Return'||lf
return

genxpr:
say;call writech('STDOUT',"Installing Protocols: ")
if (power | sendbull | sendbanner) then do
    call writech('STDOUT',"Ascii ")
    xprBUF=xprBUF||'j_ascii_start:'||lf||'Set protocol ASCII fsend TRUE'||lf||'XprSetup "xprascii.library" "E1,RA,FA"'||lf
if SHOWXPRASC then xprBUF=xprBUF||'Set RC $(showxpr)'||lf||'FalseReturn'||lf||'SetUpDate "RAW:0/$($(line).w_offset)/640/130/Line $(line) $(protocol) $(session)/AUTO/INACTIVE/NOCLOSE/NOSIZE/SCREEN$(pscreen)"'||lf
else xprBUF=xprBUF||'SetUpdate NULL'||lf
    xprBUF=xprBUF||'Return'||lf
    xprBUF=xprBUF||'j_ascii_end:'||lf||'XprClose'||lf||'SetUpdate NULL'||lf||'RexxMsg NY LOGPROC "FlushLog 'loggroup'"'||lf
if ROOFLOG then xprBUF=xprBUF||'RexxMsg FY ROOFLOG "UPDATE_STAT $(filesout)"'||lf
    xprBUF=xprBUF||'Clear protocol'||lf||'Return'||lf
end

if power then do
call writech('STDOUT',"Zmodem ")
xprBUF=xprBUF||'zmodemsend:'||lf||'Set protocol ZMODEM session DOWNLOAD fsend TRUE'||lf
xprBUF=xprBUF||'XprSetup "xprzedzap.library" "TN,OR,B8,F0,E30,AN,DN,KN,SY,RN,M1024"'||lf||'SubJump xprdisplay'||lf
xprBUF=xprBUF||'XprSetFile $($(namebuf).full) $($(namebuf).file) ""'||lf||'XprSend $($(namebuf).file)'||lf||'XprClose'||lf||'SetUpdate NULL'||lf||'RexxMsg NY LOGPROC "FlushLog 'loggroup'"'||lf
if ROOFLOG then xprBUF=xprBUF||'RexxMsg FY ROOFLOG "UPDATE_STAT $(filesout)"'||lf
xprBUF=xprBUF||'Clear protocol session'||lf||'Return'||lf
xprBUF=xprBUF||'zmodemrecv:'||lf||'Set RC $(user)'||lf||'TrueJump zmrcv.1'||lf||'Set username USER remote.address "USER#0:0/0.0"'||lf||'SetA remote $(remote.address)'||lf||'Set remote.network FIDO'||lf
xprBUF=xprBUF||'zmrcv.1:'||lf
if ROOFLOG then xprBUF=xprBUF||'RexxMsg FY ROOFLOG "UPDATE_STAT $(filesin)"'||lf
xprBUF=xprBUF||'Set protocol ZMODEM session "UPLOAD" inbound $(userdir) remote.sysop $(username) remote.sitename UNKNOWN '||lf||'BeginSession $(remote.address)'||lf
xprBUF=xprBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(session) from $(username) at $(remote.address)"'||lf
xprBUF=xprBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.session) $(session) $(p.protocol) $(protocol) $(p.inbound) USER $(p.rsysop) $(remote.sysop)"'||lf||'Jump zedzapin'||lf
end


if addemsi | power then do
call writech('STDOUT',"DirectZap ")
xprBUF=xprBUF||'directzapout:'||lf
xprBUF=xprBUF||'SetMailerFlags "DN,PN"'||lf||'Set protocol DirectZap'||lf||'SubJump 'notifylabel'get_resume'||lf
xprBUF=xprBUF||'XprSetup xprzedzap.library TN,OR,B16,F0,E30,AN,DN,KN,SN,RN,NY,M8192,QY,C$(baud)'||lf
xprBUF=xprBUF||'SubJump xprdisplay'||lf
xprBUF=xprBUF||'Jump xprout'||lf

xprBUF=xprBUF||'directzapin:'||lf
xprBUF=xprBUF||'SetMailerFlags "DN,PN"'||lf||'Set protocol DirectZap'||lf||'SubJump 'notifylabel'get_resume'||lf
/*xprBUF=xprBUF||'XprSetup xprzedzap.library TN,OR,B8,F0,E30,AN,DN,KN,SN,RN,NN,M1024,QY'||lf    */
xprBUF=xprBUF||'XprSetup xprzedzap.library TN,OR,B16,F0,E30,AN,DN,KN,SN,RN,NY,M8192,QY,C$(baud)'||lf
xprBUF=xprBUF||'SubJump xprdisplay'||lf
xprBUF=xprBUF||'Jump xprin'||lf
end

call writech('STDOUT',"ZedZip ")
xprBUF=xprBUF||'zedzipin:'||lf||'SetMailerFlags "DE,PN"'||lf||'Set protocol ZedZip'||lf||'SubJump 'notifylabel'get_resume'||lf
/*xprBUF=xprBUF||'XprSetup xprzedzap.library TN,OR,B8,F0,E30,AN,DN,KN,SN,RN,NN,M1024'||lf||'SubJump xprdisplay'||lf||'Jump xprin'||lf   */
xprBUF=xprBUF||'XprSetup xprzedzap.library TN,OR,B16,F0,E30,AN,DN,KN,SN,RN,NN,M1024'||lf||'SubJump xprdisplay'||lf||'Jump xprin'||lf

xprBUF=xprBUF||'zedzipout:'||lf||'SetMailerFlags "DN,PN"'||lf||'Set protocol ZedZip'||lf||'SubJump 'notifylabel'get_resume'||lf
/*xprBUF=xprBUF||'XprSetup xprzedzap.library TN,OR,B8,F0,E30,AN,DN,KN,SN,RN,NN,M1024'||lf||'SubJump xprdisplay '||lf||'Jump xprout'||lf */
xprBUF=xprBUF||'XprSetup xprzedzap.library TN,OR,B16,F0,E30,AN,DN,KN,SN,RN,NN,M1024'||lf||'SubJump xprdisplay '||lf||'Jump xprout'||lf

call writech('STDOUT',"ZedZap ")
xprBUF=xprBUF||'zedzapin:'||lf||'SetMailerFlags "DN,PN"'||lf||'Set protocol ZedZap'||lf||'SubJump 'notifylabel'get_resume'||lf
/*xprBUF=xprBUF||'XprSetup xprzedzap.library TN,OR,B8,F0,E30,AN,DN,KN,SN,RN,NY,M8192,C$(baud)'||lf||'SubJump xprdisplay'||lf    */
xprBUF=xprBUF||'XprSetup xprzedzap.library TN,OR,B16,F0,E30,AN,DN,KN,SN,RN,NY,M8192,C$(baud)'||lf||'SubJump xprdisplay'||lf
xprBUF=xprBUF||'zmodemin:'||lf||'Jump xprin'||lf

xprBUF=xprBUF||'zedzapout:'||lf||'SetMailerFlags "DN,PN"'||lf||'Set protocol ZedZap'||lf||'SubJump 'notifylabel'get_resume'||lf
/*xprBUF=xprBUF||'XprSetup xprzedzap.library TN,OR,B8,F0,E30,AN,DN,KN,SN,RN,NY,M8192,C$(baud)'||lf||'SubJump xprdisplay'||lf    */
xprBUF=xprBUF||'XprSetup xprzedzap.library TN,OR,B168,F0,E30,AN,DN,KN,SN,RN,NY,M8192,C$(baud)'||lf||'SubJump xprdisplay'||lf
xprBUF=xprBUF||'zmodemout:'||lf||'Jump xprout'||lf


if addemsi then do
call writech('STDOUT',"TeLink ")   
xprBUF=xprBUF||'telinkout:'||lf||'XprSetup xprfts.library "OT,SN,MN"'||lf||'Set protocol Telink'||lf   
xprBUF=xprBUF||'Jump e_xmodemout'||lf   

xprBUF=xprBUF||'telinkin:'||lf||'XprSetup xprfts.library "OT,SN,MN"'||lf||'Set protocol Telink'||lf
xprBUF=xprBUF||'Jump xmodemin'||lf   

call writech('STDOUT',"SeaLink ")   
xprBUF=xprBUF||'sealinkout:'||lf||'XprSetup xprfts.library "OS,SF,WY,MN"'||lf||'Set protocol Sealink'||lf
xprBUF=xprBUF||'Jump e_xmodemout'||lf   

xprBUF=xprBUF||'sealinkin:'||lf||'XprSetup xprfts.library "OS,SF,WY,MN"'||lf||'Set protocol Sealink'||lf
xprBUF=xprBUF||'Jump xmodemout'||lf   
end

call writech('STDOUT',"Lotek ")
xprBUF=xprBUF||'lotekout:'||lf||'FindFreq $(called)'||lf||'SetMailerFlags "DY,PY"'||lf||'Set protocol Lotek'||lf||'Jump xmodemout'||lf
xprBUF=xprBUF||'lotekin:'||lf||'SetMailerFlags "DY,PY"'||lf||'XprSetup xprfts.library "7Y,CY,OB,IB,SY,BN,AN,NY,WY,FY"'||lf||'Set protocol Lotek'||lf||'Jump xmodemin'||lf
call writech('STDOUT',"DietIFNA ")
xprBUF=xprBUF||'dietifnaout:'||lf||'SetMailerFlags "DY,PN"'||lf||'Set protocol DietIFNA'||lf
call writech('STDOUT',"Xmodem ")
xprBUF=xprBUF||'xmodemout:'||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(protocol) ftsflags: 'ftsprod'"'||lf
xprBUF=xprBUF||'XprSetup xprfts.library "'ftsprod'"'||lf
if addemsi then xprBUF=xprBUF||'e_xmodemout:'||lf
xprBUF=xprBUF||'SubJump xprdisplay'||lf
xprBUF=xprBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(protocol) Setup:$(XprSetup) RC:$(RC)"'||lf||'Jump xpr_send'||lf

xprBUF=xprBUF||'dietifnain:'||lf||'SetMailerFlags "DY,PN"'||lf||'Set protocol DietIFNA'||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(protocol) ftsflags: 'ftsprod'"'||lf
xprBUF=xprBUF||'XprSetup xprfts.library "'ftsprod'"'||lf
xprBUF=xprBUF||'xmodemin:'||lf||'SubJump xprdisplay'||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(protocol) Setup:$(XprSetup) RC:$(RC)"'||lf||'Jump xpr_recv'||lf

xprBUF=xprBUF||'j_xprdisplay:'||lf||'SetPri $(xferpri)'||lf||'Set RC $(showxpr)'||lf||'FalseReturn'||lf
xprBUF=xprBUF||'SetUpDate "RAW:0/$($(line).w_offset)/640/130/Line $(line) $(protocol) $(session) $(remote.domain) $(remote.zone) $(remote.net) $(remote.node) $(remote.point) $(remote.sysop) $(remote.sitename)/AUTO/INACTIVE/NOCLOSE/NOSIZE/SCREEN$(pscreen)"'||lf
xprBUF=xprBUF||'SetStatus NULL:'||lf||'Return'||lf

xprBUF=xprBUF||'xprout:'||lf||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.protocol) $(protocol)"'||lf
if wpldebug then xprBUF=xprBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(protocol) Setup:$(XprSetup) RC:$(RC)"'||lf
xprBUF=xprBUF||'XprSend ""'||lf
if wpldebug then xprBUF=xprBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(protocol) Send:$(RC)"'||lf
xprBUF=xprBUF||'FalseJump xprend'||lf
xprBUF=xprBUF||'Set RC $(nopickup)'||lf||'TrueJump xprend'||lf
xprBUF=xprBUF||'Delay 2'||lf
xprBUF=xprBUF||'xpr_recv:'||lf||'XprReceive ""'||lf
if wpldebug then xprBUF=xprBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(protocol) Receive:$(RC)"'||lf
xprBUF=xprBUF||'Jump xprend'||lf

xprBUF=xprBUF||'xprin:'||lf||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.protocol) $(protocol)"'||lf
if wpldebug then xprBUF=xprBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(protocol) Setup:$(XprSetup) RC:$(RC)"'||lf
xprBUF=xprBUF||'Set RC $(resume)'||lf||'FalseJump xprin_recv'||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Resuming"'||lf
xprBUF=xprBUF||'xprin_recv:'||lf||'XprReceive ""'||lf
if wpldebug then xprBUF=xprBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(protocol) Receive:$(RC)"'||lf
xprBUF=xprBUF||'FalseJump xprend'||lf
if power then xprBUF=xprBUF||'Cmp $(session) UPLOAD'||lf||'TrueJump xprend'||lf
xprBUF=xprBUF||'Delay 2'||lf
xprBUF=xprBUF||'xpr_send:'||lf||'XprSend ""'||lf
if wpldebug then xprBUF=xprBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(protocol) Send:$(RC)"'||lf
xprBUF=xprBUF||'j_xprend:'||lf||'XprClose'||lf||'SetUpdate NULL'||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(remote.address) $(protocol) RC:$(RC)"'||lf||'ReplyCall 0'||lf||'EndSession all'||lf
if power then xprBUF=xprBUF||'Cmp $(session) UPLOAD'||lf||'TrueJump xprdesc'||lf
if ROOFLOG then xprBUF=xprBUF||'set tmp $(ftnin)'||lf||'Set RC $(IsOutbound)'||lf||'FalseJump setss'||lf||'Set tmp $(ftnout)'||lf||'setss:'||lf||'RexxMsg FY ROOFLOG "UPDATE_STAT $(tmp)"'||lf
xprBUF=xprBUF||'Jump aftersession'||lf
if power then do
xprBUF=xprBUF||'xprdesc:'||lf
if sc_user then xprBUF=xprBUF||'SetStatus "$(openstatus)"'||lf||'Print "Getting upload desciptions\n"'||lf
if addfreq then do
xprBUF=xprBUF||'RexxMsg "SY,RY" REXX "return upper(translate(\"$(username)\",\"_\",\" \"))" '||lf
xprBUF=xprBUF||'Pattern $(remfile) #?$(result2).GRAB'||lf||'FalseJump xprdesc.1'||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Received GRAB request from $(username)"'||lf||'Set namebuf GRAB'||lf||'Jump loadwplrx'||lf
end
xprBUF=xprBUF||'xprdesc.1:'||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Getting upload descriptions from $(username)"'||lf
xprBUF=xprBUF||';RexxMsg "" REXX "$(rexxdir)UserUL.wplrx $(username)"'||lf
xprBUF=xprBUF||'Address REXX "$(rexxdir)UserUL.wplrx $(username)"'||lf||'Jump do_menu'||lf
end
return

genclock:
call writech('STDOUT',"CLOCK ")
clkBUF=';WPLSCRIPT 'l_mailer'clock'||lf||'clockcall:'||lf
if sc_connect then clkBUF=clkBUF||'SetStatus $(openstatus)'||lf
clkBUF=clkBUF||'Print "Switching to $(baud.$(remote.address))bps\n"'||lf
clkBUF=clkBUF||'Print "$(sitename.$(remote.address)) $(number.$(remote.address))\n"'||lf
clkBUF=clkBUF||'Print "$(baud.$(remote.address) $(xprsetup.$(remote.address))\n"'||lf
clkBUF=clkBUF||'SetBaud $(baud.$(remote.address))'||lf||'ModemInit'||lf||'Set state "DIALING $(remote.address)" protocol "XprClock"'||lf
clkBUF=clkBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) $(state) $(p.baud) $(baud) $(p.number) $(number.$(remote.address)) $(p.remote) $(sitename.$(remote.address)) $(p.session) $(xprsetup.$(remote.address))"'||lf
if ROOFLOG then clkBUF=clkBUF||' RexxMsg FY ROOFLOG "LOGLINE $<time> WPL$(line): Calling $(sitename.$(remote.address)) @ $(number.$(remote.address))"'||lf
clkBUF=clkBUF||'SmartSend "|~~ATDT$(number.$(remote.address))|"'||lf||'GetResponse 60'||lf
clkBUF=clkBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.response) $(event)"'||lf
clkBUF=clkBUF||'Cmp $(event) CONNECT'||lf||'TrueJump clockconnect'||lf||'Cmp $(event) BUSY'||lf||'Set dialrc 5'||lf||'TrueJump clockexit'||lf||'Set dialrc 11'||lf||'Jump clockexit'||lf
clkBUF=clkBUF||'clockconnect:'||lf||'SetPri $(xferpri)'||lf||'Set state "OUTBOUND $(sitename.$(remote.address))"'||lf
clkBUF=clkBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) $(state) $(p.protocol) $(protocol)"'||lf
clkBUF=clkBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) dataconnect:$(remote.address) $(lastresponse)[$(baud)]"'||lf
clkBUF=clkBUF||'XprSetup xprclock.library "$(xprsetup.$(remote.address))"'||lf
if showxpr then clkBUF=clkBUF||'SetUpDate "RAW:0/$($(line).w_offset)/640/130/Line $(line) $(protocol) $(session)/AUTO/INACTIVE/NOCLOSE/NOSIZE/SCREEN$(pscreen)"'||lf
clkBUF=clkBUF||'XprSend ""'||lf||'Set clockrc $(RC)'||lf||'XprClose'||lf||'Cmp $(clockrc) 1'||lf||'TrueJump clockset'||lf
clkBUF=clkBUF||'Set dialrc 15'||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) ERROR Clock NOT Set"'||lf
if ROOFLOG then clkBUF=clkBUF||'RexxMsg FY ROOFLOG "LOGLINE $<time> WPL$(line): $(protocol) ERROR Clock NOT Set"'||lf
clkBUF=clkBUF||'clockexit:'||lf||'SetUpdate NULL'||lf||'SmartSend "|~~AT|"'||lf||'Print "Switching back to $(LockedRate)bps\n"'||lf
clkBUF=clkBUF||'SetBaud $(LockedRate)'||lf||'SmartSend "|~~AT|"'||lf||'ReplyCall $(dialrc)'||lf||'SetStatus NULL:'||lf
clkBUF=clkBUF||'Clear tbaud dialrc clockrc'||lf||'Return '||lf
clkBUF=clkBUF||'clockset:'||lf||'Set dialrc 0'||lf||'SubJump clockexit'||lf||'System "SetClock save"'||lf
clkBUF=clkBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Clock Set"'||lf
if ROOFLOG then clkBUF=clkBUF||'RexxMsg FY ROOFLOG "LOGLINE $<time> WPL$(line): Clock Set"'||lf
clkBUF=clkBUF||'Return'||lf
if debug & log then address 'ROOFLOG' 'logline' left(time(),5) script': clockBUF:'length(clkBUF)

    call open('clk',clockwpl,"W")
    call writech('clk',clkBUF)
    call close('clk')
    drop clk clkBUF
    Say;Say "Wrote "clockwpl
return


gendialer:
if umbrella | ~domodules then say
call writech('STDOUT',"Installing Dialers: FTN ")
dialBUF=dialBUF||'setmanual:'||lf||'Set RC $(MANUAL)'||lf||'FalseReturn'||lf||'Set remote.number $(number)'||lf
dialBUF=dialBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Manual poll: $(remote.address) $(remote.number)"'||lf
dialBUF=dialBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.remote) $(remote.address) $(p.number) $(remote.number)"'||lf||'Clear manual number'||lf||'Set RC TRUE'||lf||'Return'||lf
dialBUF=dialBUF||'line_check:'||lf||'Set RC $(line.$(remote.address))'||lf||'FalseJump dial_site'||lf||'Cmp $(line.$(remote.address)) $(line)'||lf||'TrueJump dial_site'||lf
dialBUF=dialBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(remote.address) UseLine:$(line.$(remote.address))"'||lf
dialBUF=dialBUF||'CallForward 'u_mailer'$(line.$(remote.address))'||lf||'ReplyCall 7'||lf||'Jump freeline'||lf

dialBUF=dialBUF||'ckpresess:'||lf||'Cmp "$(presess.$(remote.address))" ""'||lf||'TrueReturn'||lf
dialBUF=dialBUF||'RexxMsg NY LOGPROC "PutLine roofwplstat$(line) $(p.status) PreSession: $(presess.$(remote.address))"'||lf
dialBUF=dialBUF||'RexxMsg NY LOGPROC "PutLog roofwpl $<time> $(line) PreSession: $(presess.$(remote.address)) loading for $(remote.address)"'||lf
dialBUF=dialBUF||'Address REXX "$(rexxdir)$(presess.$(remote.address))"'||lf
dialBUF=dialBUF||'Set dialrc $(result1)'||lf
dialBUF=dialBUF||'RexxMsg NY LOGPROC "PutLog roofwpl $<time> $(line) PreSession RC:$(RC) $(dialrc)"'||lf
dialBUF=dialBUF||'Return'||lf

dialBUF=dialBUF||'dialftn:'||lf||'Set state "DIALING FTN $(remote.address)"'||lf
if addspeech then dialBUF=dialBUF||'Set sl 70 speech $(state)'||lf||'SubJump sayit'||lf
dialBUF=dialBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) $(state)"'||lf||'ModemClear'||lf
if loosespec & strictzmh & addemsi then do
dialBUF=dialBUF||'RexxMsg SY "return((time(m)<(left(word(\"$(umh)\",1),2)*60+right(word(\"$(umh)\",1),2)))|(time(m)>(left(word(\"$(umh)\",2),2)*60+right(word(\"$(umh)\",2),2))))"'||lf
dialBUF=dialBUF||'Set RC $(result1)'||lf
dialBUF=dialBUF||'FalseJump notzmhdial'||lf
dialBUF=dialBUF||'Set host.link "8N1,HXT"'||lf
dialBUF=dialBUF||'notzmhdial:'||lf
end
dialBUF=dialBUF||'SubJump 'l_mailer'!sethostadr'||lf||'SubJump setmanual'||lf||'TrueJump dial_site'||lf
dialBUF=dialBUF||'dodial.0:'||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(state)"'||lf
dialBUF=dialBUF||'Set RC $(number.$(remote.address))'||lf
if umbrella then dialBUF=dialBUF||'FalseJump nonumber'||lf||'SubJump getcached'||lf||'Jump line_check'||lf
else do
dialBUF=dialBUF||'FalseJump ftn_lookup'||lf||'SubJump getcached'||lf||'Jump line_check'||lf
dialBUF=dialBUF||'ftn_lookup:'||lf||'Set systemcmd "$(lookup) $(remote.address) nodelist: $(line) "'||lf
dialBUF=dialBUF||'SubJump runsync'||lf||'TrueJump nonumber'||lf||'SubJump getlookup'||lf||'Jump dial_site'||lf
end
if addhost then dialBUF=dialBUF||'dialforward:'||lf||'CallForward 'u_mailer'1'||lf||'Jump aftersession'||lf

if addclock then do
call writech('STDOUT',"CLOCK ")
dialBUF=dialBUF||'dialclock:'||lf
if addspeech then dialBUF=dialBUF||'Set sl 70 speech "Calling Atomic Clock $(remote.sitename)"'||lf||'SubJump sayit'||lf
dialBUF=dialBUF||'ModemClear'||lf||'LoadScript clock CFG:WPL/'l_mailer'CLOCK.WPL'||lf||'SubJump clock!clockcall'||lf||'LoadScript clock ""'||lf||'Jump dodial_exit'||lf
end

if addbbs then do
call writech('STDOUT',"BBS ")
dialBUF=dialBUF||'dialbbs:'||lf||'Set state "DIALING BBS $(remote.address)" term TRUE'||lf
if addspeech then dialBUF=dialBUF||'Set sl 70 speech $(state)'||lf||'SubJump sayit'||lf
dialBUF=dialBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) $(state)"'||lf||'ModemCLear'||lf||'SubJump setmanual'||lf||'TrueJump dial_site'||lf
dialBUF=dialBUF||'dialbbs.0:'||lf||'Set RC $(number.$(remote.address))'||lf||'FalseJump nonumber'||lf||'SubJump getuucached'||lf||'Jump line_check'||lf
dialBUF=dialBUF||'bbsconnect:'||lf
if ROOFLOG then dialBUF=dialBUF||'RexxMsg FY ROOFLOG "UPDATE_STAT $(bbsout)"'||lf
dialBUF=dialBUF||'SubJump ckpresess'||lf||'Cmp dialrc 5'||lf||'TrueJump dodial_exit'||lf
dialBUF=dialBUF||'Set systemcmd "$(term.$(remote.address))"'||lf||'SubJump runasync'||lf||'ReplyCall 0'||lf||'Jump aftersession'||lf
end

if addfax then do
call writech('STDOUT',"FAX ")
dialBUF=dialBUF||'dialfax:'||lf
dialBUF=dialBUF||'Set state "DIALING FAX $(remote.address)" fax TRUE'||lf
if addspeech then dialBUF=dialBUF||'Set sl 70 speech $(state)'||lf||'SubJump sayit'||lf
dialBUF=dialBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) $(state)"'||lf
dialBUF=dialBUF||'ModemClear'||lf||'SubJump setmanual'||lf
dialBUF=dialBUF||'TrueJump faxconnect'||lf
dialBUF=dialBUF||'dialfax.0:'||lf
dialBUF=dialBUF||'Set RC $(number.$(remote.address))'||lf
dialBUF=dialBUF||'FalseJump nonumber'||lf
dialBUF=dialBUF||'SubJump getuucached'||lf
dialBUF=dialBUF||';Jump line_check'||lf
dialBUF=dialBUF||'Jump faxconnect'||lf
end

if adduucp then do
call writech('STDOUT',"UUCP ")
dialBUF=dialBUF||'dialuucp:'||lf||'Set state "DIALING UUCP $(remote.address)"'||lf
if addspeech then dialBUF=dialBUF||'Set sl 70 speech $(state)'||lf||'SubJump sayit'||lf
dialBUF=dialBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) $(state)"'||lf||'SubJump 'l_mailer'!sethostadr'||lf||'ModemClear'||lf||'SubJump setmanual'||lf||'TrueJump dial_site'||lf
dialBUF=dialBUF||'dialuucp.0:'||lf||'Set RC $(number.$(remote.address))'||lf||'FalseJump uucp_lookup'||lf||'SubJump getuucached'||lf||'Jump line_check'||lf
dialBUF=dialBUF||'uucp_lookup:'||lf||'SubJump getuulookup'||lf||'CmpI $(remote.number) ""'||lf||'TrueJump nonumber'||lf||'Jump dial_site'||lf
end

dialBUF=dialBUF||'dodial:'||lf||'SubJump cleargui'||lf
if addclock then dialBUF=dialBUF||'Pattern $(remote.address) CLOCK#?'||lf||'TrueJump dialclock'||lf
if addbbs then dialBUF=dialBUF||'Pattern $(remote.address) BBS#?'||lf||'TrueJump dialbbs'||lf
if addfax then dialBUF=dialBUF||'Pattern $(remote.address) FAX#?'||lf||'TrueJump dialfax'||lf
if addhost then dialBUF=dialBUF||'Cmp $(remote.network) TEXT'||lf||'TrueJump dialforward'||lf
if adduucp then dialBUF=dialBUF||'Cmp $(remote.network) UUCP'||lf||'TrueJump dialuucp'||lf
dialBUF=dialBUF||'Jump dialftn'||lf
dialBUF=dialBUF||'dial_site:'||lf
dialBUF=dialBUF||'Set RC "$(predial.$(remote.address))"'||lf||'FalseJump nopredial'||lf
dialBUF=dialBUF||'Set systemcmd "$(predial.$(remote.address))"'||lf||'SubJump runsync'||lf
dialBUF=dialBUF||'nopredial:'||lf
dialBUF=dialBUF||'Set dial $(DialString) RC $(dial.$(remote.address))'||lf||'FalseJump dial_mdm'||lf||'Set dial $(dial.$(remote.address))'||lf
dialBUF=dialBUF||'dial_mdm:'||lf
if sc_dial then dialBUF=dialBUF||'SetStatus $(openstatus)'||lf||'Print "Dialing $(remote.sitename)\n"'||lf
dialBUF=dialBUF||'SmartSend "$(dial)$(remote.number)|"'||lf||'GetResponse $(responsetimeout)'||lf
dialBUF=dialBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.response) $(event):$(lastresponse)"'||lf
dialBUF=dialBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(remote.address) $(lastresponse) $(event)"'||lf
dialBUF=dialBUF||'Cmp $(event) CONNECT'||lf||'TrueJump dataconnect'||lf
if addfax then dialBUF=dialBUF||'Cmp $(event) FAX'||lf||'TrueJump faxconnect'||lf
dialBUF=dialBUF||'Cmp $(event) VOICE'||lf||'TrueJump voiceconnect'||lf
dialBUF=dialBUF||'Cmp $(event) BUSY'||lf||'TrueJump dodial_alternate'||lf
if ~noanswer then do
dialBUF=dialBUF||'Cmp $(event) RING'||lf||'FalseJump dt.0'||lf
dialBUF=dialBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Got Ring during dial"'||lf
dialBUF=dialBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) Inbound call Dial interrupt"'||lf
dialBUF=dialBUF||'ReplyCall 5'||lf||'set txt "'nl'  Welcoming you despite the fact you interrupted my dialing out'nl'"'||lf||'SubJump 'l_mailer'!fidonethost'||lf||'Jump answer'||lf
end
dialBUF=dialBUF||'dt.0:'||lf||'Cmp $(event) NOMODEM'||lf||'FalseJump dt.1'||lf||'ReplyCall 10'||lf||'Jump slaveloop'||lf
dialBUF=dialBUF||'dt.1:'||lf||'Cmp $(event) OWNDEVUNIT'||lf||'FalseJump dt.2'||lf||'ReplyCall 1'||lf||'Jump freeline'||lf
dialBUF=dialBUF||'dt.2:'||lf||'Cmp $(event) CARRIER'||lf||'FalseJump dt.3'||lf||'ReplyCall 11'||lf||'Jump lost_carrier'||lf
dialBUF=dialBUF||'dt.3:'||lf||'Cmp $(event) TIMEOUT'||lf||'FalseJump dt.4'||lf||'Set dialrc 12'||lf||'Jump dodial_exit'||lf||'Set dialrc $(RC)'||lf
dialBUF=dialBUF||'dt.4:'||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Dialrc:$(dialrc) RC:$(RC) Event:[$(event)] Modem:[$(lastresponse)]"'||lf||'Jump dodial_exit'||lf
dialBUF=dialBUF||'nonumber:'||lf||'Set dialrc 6'||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) No phone number for $(remote.address)"'||lf||'Jump dodial_exit'||lf
dialBUF=dialBUF||'dodial_alternate:'||lf||'Cmp $(alternate) TRUE'||lf||'TrueJump return_busy'||lf||'Set RC $(altnum.$(remote.address))'||lf||'FalseJump return_busy'||lf
dialBUF=dialBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(remote.number) Busy, Dialing $(altnum.$(remote.address))"'||lf
dialBUF=dialBUF||'Set remote.number $(altnum.$(remote.address)) alternate TRUE'||lf||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.number) $(remote.number)"'||lf||'Jump dial_site'||lf
dialBUF=dialBUF||'return_busy:'||lf||'Clear alternate'||lf||'Set dialrc 5'||lf
dialBUF=dialBUF||'dodial_exit:'||lf||'ReplyCall $(dialrc)'||lf||'Jump freeline'||lf

dialBUF=dialBUF||'dataconnect:'||lf
dialBUF=dialBUF||'SubJump ckpresess'||lf||'Cmp dialrc 5'||lf||'TrueJump dodial_exit'||lf
dialBUF=dialBUF||'Set session OUTBOUND state "SESSION $(session) $(remote.address) $(lastresponse)"'||lf
if sc_connect then dialBUF=dialBUF||'SetStatus "$(openstatus)"'||lf||'Print "$(session)\n"'||lf
dialBUF=dialBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.baud) $(baud) $(p.status) $(session):$(lastresponse)"'||lf
if ROOFLOG then dialBUF=dialBUF||'RexxMsg FY ROOFLOG "CALLSTATUS $(calltask.$(remote.address)) $(line) $(callcount.$(remote.address)) $(callstart.$(remote.address)) $<time> $(remote.address) CONNECTED"'||lf
dialBUF=dialBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) dataconnect:$(remote.address) $(lastresponse)[$(baud)]"'||lf
if ROOFLOG then dialBUF=dialBUF||'RexxMsg FY ROOFLOG "UPDATE_STAT $(callsout)"'||lf
if addbbs then dialBUF=dialBUF||'Set RC $(term)'||lf||'TrueJump bbsconnect'||lf
if adduucp then dialBUF=dialBUF||'Cmp $(remote.network) UUCP'||lf||'TrueJump uucpconnect'||lf
dialBUF=dialBUF||'Set called $(remote.address)'||lf
dialBUF=dialBUF||'Set RC $(useakasout.$(remote.address))'||lf||'FalseJump dataconnect.1'||lf
dialBUF=dialBUF||'Set RC "$(akalist.$(remote.number))"'||lf||'FalseJump dataconnect.1'||lf
dialBUF=dialBUF||'Set called "$(akalist.$(remote.number))"'||lf
dialBUF=dialBUF||'dataconnect.1:'||lf||'Set RC $(crash)'||lf||'FalseJump dc.1'||lf||'Set MinSendPri 50'||lf
dialBUF=dialBUF||'dc.1:'||lf||'BeginSession $(called)'||lf||'SetPri $(negopri)'||lf
dialBUF=dialBUF||'Set host.wzcap 13 host.wzext "-Freq +Domain" host.freq FALSE'||lf

if usexflo then do
if exists('RPDIR:XFLO') then dialBUF=dialBUF||'Set systemcmd "XFLO $(outbound) $(host.address) $(called)"'||lf
else dialBUF=dialBUF||'Set systemcmd "Rx $(rexxdir)XFLO.rexx $(outbound) $(host.address) $(called)"'||lf
dialBUF=dialBUF||'SubJump runsync'||lf
end

if addemsi then do
dialBUF=dialBUF||'Set RC $(emsi.$(line))'||lf||'FalseJump gethandshake'||lf
dialBUF=dialBUF||'Cmp $(outflags.$(remote.address)) ""'||lf||'TrueJump dc.2'||lf
dialBUF=dialBUF||'Pattern $(outflags.$(remote.address)) "#?GE#?"'||lf
dialBUF=dialBUF||'FalseJump gethandshake'||lf

dialBUF=dialBUF||'dc.2:'||lf
if primary then dialBUF=dialBUF||'Set host.addresses $(host.aka.$(host.domain))'||lf
else dialBUF=dialBUF||'Set host.addresses "'strip(myakas)'"'||lf
dialBUF=dialBUF||'Cmp $(present.$(remote.address)) ""'||lf||'TrueJump do_emsi'||lf
dialBUF=dialBUF||'Set host.addresses "$(present.$(remote.address))"'||lf
dialBUF=dialBUF||'Jump do_emsi'||lf

dialBUF=dialBUF||'bademsihandshake:'||lf
dialBUF=dialBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) EMSI failed $(remote.addresses), trying FTS1/WAZOO"'||lf
end

dialBUF=dialBUF||'gethandshake:'||lf
dialBUF=dialBUF||'Set outflags $(outflags.$(line))'||lf
dialBUF=dialBUF||'Set RC $(outflags.$(remote.address))'||lf||'FalseJump gh.0'||lf
dialBUF=dialBUF||'Set outFlags $(outflags.$(remote.address))'||lf
dialBUF=dialBUF||'gh.0:'||lf||'GetOutbound $(outflags)'||lf
dialBUF=dialBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(event):$(namebuf) $(called)"'||lf
dialBUF=dialBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.login) $(event) $<time> $(p.hfreqs) $(host.freq) $(p.session) $(event) $(p.roffer) $(namebuf)"'||lf
if addemsi then do
/*dialBUF=dialBUF||'Cmp $(event) EMSI'||lf||'TrueJump do_emsi'||lf  */
dialBUF=dialBUF||'Pattern $(event) #?EMSI#?'||lf||'TrueJump do_emsi'||lf
end
dialBUF=dialBUF||'Cmp $(event) WAZOO'||lf||'TrueJump do_wazoo'||lf
dialBUF=dialBUF||'Cmp $(event) FTS1'||lf||'TrueJump do_fts1'||lf
dialBUF=dialBUF||'Jump bad_handshake'||lf
dialBUF=dialBUF||'do_fts1:'||lf||'Set protocol FTS1 FTS1 TRUE'||lf||'Jump lotekout'||lf
dialBUF=dialBUF||'do_wazoo:'||lf||'CmpI $(called) $(remote.address)'||lf||'TrueJump do_wazoo.1'||lf
dialBUF=dialBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Called:$(called) Got:$(remote.address)"'||lf
dialBUF=dialBUF||'; Send files queued for address given in WaZoo'||lf
dialBUF=dialBUF||'; BeginSession $(remote.address)'||lf
dialBUF=dialBUF||'do_wazoo.1:'||lf||'Set IsOutbound TRUE'||lf||'SubJump wazoo'||lf
dialBUF=dialBUF||';Set IsOutbound FALSE'||lf
dialBUF=dialBUF||'Set RC $(remote.freq)'||lf||'TrueJump dofreqs'||lf
dialBUF=dialBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Freqs disabled at $(called)"'||lf
dialBUF=dialBUF||';Set RC $(forcefreqs)'||lf
dialBUF=dialBUF||';FalseJump getwzcap'||lf
dialBUF=dialBUF||';RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Sending REQ anyways"'||lf
dialBUF=dialBUF||';Jump dofreqs'||lf
dialBUF=dialBUF||'Jump getwzcap'||lf
dialBUF=dialBUF||'dofreqs:'||lf||'FindFreq $(called)'||lf||'FindFreq $(remote.address)'||lf||'Set freq $(RC)'||lf
dialBUF=dialBUF||'getwzcap:'||lf||'Cmp $(host.wzcap) 8'||lf||'TrueJump zedzapout'||lf||'Cmp $(host.wzcap) 4'||lf||'TrueJump zedzipout'||lf||'Cmp $(host.wzcap) 1'||lf||'TrueJump dietifnaout'||lf
dialBUF=dialBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) FTS1 fallback"'||lf
dialBUF=dialBUF||'Set protocol FTS1 FTS1 TRUE'||lf||'Jump lotekout'||lf
dialBUF=dialBUF||'bad_handshake:'||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Handshake failed:$(event) $(remote.address)"'||lf
dialBUF=dialBUF||'ReplyCall 99'||lf||'EndSession all'||lf||'Jump freeline'||lf
return

genanswer:
say;call writech('STDOUT','Installing Answer: FTN ')
call SetVars('NOANSWER','FALSE')
ansBUF=ansBUF||'answer:'||lf||'SetPri $(negopri)'||lf||'System "Run >NIL: Delete ENV:$(line).#?"'||lf||'SubJump cleargui'||lf||'Set state "ANSWERING" session INBOUND'||lf
if sc_answer then ansBUF=ansBUF||'SetStatus "$(openstatus)"'||lf||'Print "$(state)\n"'||lf
ansBUF=ansBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) $(state) $(lastresponse) $(p.response) $(event) $(p.baud) $(baud)"'||lf
if ROOFLOG then ansBUF=ansBUF||'RexxMsg FY ROOFLOG "UPDATE_STAT $(callsin)"'||lf
ansBUF=ansBUF||'ModemClear'||lf
ansBUF=ansBUF||'answer0:'||lf
ansBUF=ansBUF||'Set RC ${'envpath'NOANSWER}'||lf||'FalseJump answer01'||lf
ansBUF=ansBUF||'Print "IGNORED\n"'||lf||'Jump waitring'||lf
ansBUF=ansBUF||'answer01:'||lf
ansBUF=ansBUF||'SmartSend $(AnswerString)'||lf||'GetResponse $(responsetimeout)'||lf
ansBUF=ansBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) $(state) $(lastresponse) $(p.response) $(event) $(p.baud) $(baud)"'||lf
ansBUF=ansBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(state) $(lastresponse) $(event):$(baud)"'||lf
if addfax then do
call writech('STDOUT',"FAX ")
ansBUF=ansBUF||'Cmp $(event) FAX'||lf||'TrueJump faxanswer'||lf
end
ansBUF=ansBUF||'Cmp $(event) RING'||lf||'TrueJump answer0'||lf
ansBUF=ansBUF||'Cmp $(event) CONNECT'||lf||'TrueJump answer1'||lf
ansBUF=ansBUF||'Cmp $(event) NOMODEM'||lf||'TrueJump freeline'||lf
ansBUF=ansBUF||'Cmp $(event) OWNDEVUNIT'||lf||'TrueJump freeline'||lf
ansBUF=ansBUF||'Cmp $(event) TIMEOUT'||lf||'TrueJump freeline'||lf
ansBUF=ansBUF||'Cmp $(event) CARRIER'||lf||'TrueJump lost_carrier'||lf
ansBUF=ansBUF||'Jump waitring'||lf
ansBUF=ansBUF||'answer1:'||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(lastresponse) $(baud)"'||lf||'Delay 6'||lf||'ModemClear'||lf
ansBUF=ansBUF||'CheckCarrier'||lf||'FalseJump lost_carrier'||lf
if sc_connect then ansBUF=ansBUF||'SetStatus "$(openstatus)"'||lf
ansBUF=ansBUF||'Set txt "'nl||emsiserial' ${WPLVER}'||nl||'$(sysver)'nl'  You have a $(lastresponse) on line $(line) at $<time> on $<date>'nl''||lf||'SubJump showtxt'||lf
if sendbanner then ansBUF=ansBUF||'SubJump sendbanner'||lf||'CheckCarrier'||lf||'FalseJump lost_carrier'||lf
else ansBUF=ansBUF||'Set txt $(welcome)'||lf||'SubJump showtxt'||lf

if adduucp then ansBUF=ansBUF||'Set txt "Do NOT use your name to login:'nl'"'||lf||'SubJump showtxt'||lf
ansBUF=ansBUF||'SetPri $(negopri)'||lf||'Set state "SESSION $(session) unknown"'||lf
ansBUF=ansBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) $(session) $(p.baud) $(baud)"'||lf

if addemsi then do
ansBUF=ansBUF||'Set host.link "8N1"'||lf
if strictzmh then do
ansBUF=ansBUF||'RexxMsg SY "return((time(m)<(left(word(\"$(umh)\",1),2)*60+right(word(\"$(umh)\",1),2)))|(time(m)>(left(word(\"$(umh)\",2),2)*60+right(word(\"$(umh)\",2),2))))"'||lf
ansBUF=ansBUF||'Set RC $(result1)'||lf
ansBUF=ansBUF||'FalseJump notzmhans'||lf
ansBUF=ansBUF||'Set host.link "$(host.link),HXT"'||lf
ansBUF=ansBUF||'notzmhans:'||lf
end
end

if ~umbrella & addfreq then ansBUF=ansBUF||'Cmp ${'envpath'ALLOWFREQS} TRUE'||lf||'TrueJump do_menu'||lf
ansBUF=ansBUF||'Set host.wzext "-Freq +Domain" host.freq FALSE'||lf
if addemsi then ansBUF=ansBUF||'Set host.link "$(host.link),HRQ"'||lf

ansBUF=ansBUF||'j_do_menu:'||lf||'Clear namebuf event'||lf
ansBUF=ansBUF||'CheckCarrier'||lf||'FalseJump lost_carrier'||lf
if addemsi then do
ansBUF=ansBUF||'Set RC $(emsireqsent)'||lf||'TrueJump do_menu.1'||lf
ansBUF=ansBUF||'sendemsireq:'||lf||'Set RC $(user)'||lf||'TrueJump do_menu.1'||lf
ansBUF=ansBUF||'Set RC $(emsi.$(line))'||lf||'FalseJump do_menu.1'||lf
ansBUF=ansBUF||'Set txt "**EMSI_REQA77E\r" emsireqsent TRUE'||lf
ansBUF=ansBUF||'do_menu.1:'||lf
end

if umbrella then ansBUF=ansBUF||'Set txt "$(txt) 'nl'Mailers only!'nl'"'||lf
else ansBUF=ansBUF||'Set txt "$(txt) $(sysprompt)"'||lf||'Cmp ${'envpath'ACCESS} TRUE'||lf||'TrueJump allwelcome'||lf||'Set txt "$(txt) 'nl'Mailers only at this time for login: "'||lf

ansBUF=ansBUF||'allwelcome:'||lf||'SubJump showtxt'||lf
ansBUF=ansBUF||'get_login:'||lf||'GetInbound "$(inflags.$(line))" $(loginwait)'||lf
ansBUF=ansBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) $(session) $(p.session) $(event) $(p.login) $(namebuf) $<time> $(p.hfreqs) $(host.freq)"'||lf
if ~umbrella then do
    call writech('STDOUT',"HUMAN ")
    ansBUF=ansBUF||'Cmp $(event) LOGIN'||lf||'TrueJump user_input'||lf
end
ansBUF=ansBUF||'Cmp $(event) GOTYOOHOO'||lf||'TrueJump login_wazoo'||lf
if addemsi then ansBUF=ansBUF||'Pattern $(event) #?EMSI#?'||lf||'TrueJump login_emsi'||lf
ansBUF=ansBUF||'Cmp $(event) FTS1'||lf||'TrueJump login_fts1'||lf
ansBUF=ansBUF||'Cmp $(event) CARRIER'||lf||'TrueJump lost_carrier'||lf
ansBUF=ansBUF||'Cmp $(event) TIMEOUT'||lf||'TrueJump timeout_exit'||lf
ansBUF=ansBUF||'Jump get_login'||lf

ansBUF=ansBUF||'login_wazoo:'||lf||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.session) WAZOO"'||lf||'SubJump wazoo'||lf||'FalseJump loginerr'||lf
ansBUF=ansBUF||'Set expect 2U2'||lf||'WazooRespond'||lf||'Cmp $(event) $(expect)'||lf||'FalseJump loginerr'||lf||'Cmp $(pw) DEFERRED'||lf||'FalseJump login1'||lf||'SubJump dolookup'||lf||'TrueJump login2'||lf||'Jump loginerr'||lf
ansBUF=ansBUF||'login1:'||lf||'SubJump ck_multiftn'||lf
ansBUF=ansBUF||'login2:'||lf||'SetPri $(launchpri)'||lf||'Set state "SESSION INBOUND $(remote.address)"'||lf
ansBUF=ansBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.remote) $(remote.address)"'||lf
if ROOFLOG then ansBUF=ansBUF||'RexxMsg FY ROOFLOG "LOGLINE $<time> WPL$(line): Inbound WAZOO FTN Session $(remote.address) @ $(baud)"'||lf
ansBUF=ansBUF||'Set called $(remote.address)'||lf||'Set RC $(useakasin.$(remote.address))'||lf||'FalseJump login3'||lf||'Set called "$(akalist.$(remote.number))"'||lf
ansBUF=ansBUF||'login3:'||lf||'BeginSession $(called)'||lf||'Cmp $(host.wzcap) 8'||lf||'TrueJump zedzapin'||lf||'Cmp $(host.wzcap) 4'||lf||'TrueJump zedzipin'||lf||'Cmp $(host.wzcap) 1'||lf||'TrueJump dietifnain'||lf
ansBUF=ansBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) FTS1 fallback"'||lf||'Jump lotekin'||lf

ansBUF=ansBUF||'login_fts1:'||lf||'Set state "SESSION $(session) $(event)"'||lf||'SetA remote fidonet#1:1/1.1'||lf
ansBUF=ansBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.remote) $(remote.address)"'||lf
if ~umbrella & addfreq then ansBUF=ansBUF||'Cmp ${'envpath'FTSFREQS} TRUE'||lf||'TrueJump lotekin'||lf
ansBUF=ansBUF||'Set host.wzext "-Freq +Domain" host.freq FALSE'||lf||'Jump lotekin'||lf

ansBUF=ansBUF||'timeout_exit:'||lf||'Set txt $(timeout)'||lf||'SubJump showtxt'||lf||'Delay 2'||lf||'Jump freeline'||lf
ansBUF=ansBUF||'loginerr:'||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) WAZOO Negotiation failed:[$(event)] expected:[$(expect)]"'||lf
ansBUF=ansBUF||'Clear expect'||lf||'ReplyCall 111'||lf||'EndSession all'||lf||'Jump freeline'||lf
return

genaftersession:
call writech('STDOUT',lf||"Generating AfterSession Process code: ")
asBUF=asBUF||'aftersession:'||lf||'SetStatus NULL:'||lf
asBUF=asBUF||'SubJump openslave'||lf||'FalseJump freeline'||lf||'SetPri $(launchpri)'||lf
asBUF=asBUF||'RexxMsg NY LOGPROC "FlushLog 'loggroup'"'||lf||'SetStatus NULL:'||lf
asBUF=asBUF||'Set state "SESSION PROCESSING" issecure TRUE user FALSE'||lf
asBUF=asBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) $(state)"'||lf
call writech('STDOUT',"SORT ")
asBUF=asBUF||'aftersession.sort:'||lf||'Set RC $(mail)'||lf||'FalseJump aftersession.tic'||lf
asBUF=asBUF||'Set RC $(multihub) multihub FALSE'||lf||'FalseJump aftersession.mail'||lf
/*asBUF=asBUF||'Set RC "$(sortsess.$(remote.address))"'||lf||'FalseJump noSSS'||lf  */
asBUF=asBUF||'Cmp "$(sortsess.$(remote.address))" ""'||lf||'TrueJump noSSS'||lf
asBUF=asBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) Site AfterSession $(sortsess.$(remote.address))"'||lf
asBUF=asBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Site AfterSession: $(sortsess.$(remote.address))"'||lf
asBUF=asBUF||'Set systemcmd "$(sortsess.$(remote.address))"'||lf||'Jump SSS'||lf
asBUF=asBUF||'noSSS:'||lf
/*asBUF=asBUF||'Set RC "${'envpath'SORTSESS}"'||lf||'FalseJump aftersession.mail'||lf   */
asBUF=asBUF||'Cmp "${'envpath'SORTSESS}" ""'||lf||'TrueJump aftersession.mail'||lf
asBUF=asBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) AfterSession ${'envpath'SORTSESS}"'||lf
asBUF=asBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) AfterSession:${'envpath'SORTSESS}"'||lf
asBUF=asBUF||'Set systemcmd "${'envpath'SORTSESS}"'||lf
asBUF=asBUF||'SSS:'||lf||'SubJump runsync'||lf||'Set mail FALSE'||lf||'Jump aftersession.tic'||lf
call writech('STDOUT',"MAIL ")
asBUF=asBUF||'aftersession.mail:'||lf||'Set RC $(mail) mail FALSE'||lf||'FalseJump aftersession.tic'||lf
/*asBUF=asBUF||'Set RC "$(impsess.$(remote.address))"'||lf||'FalseJump noISS'||lf   */
asBUF=asBUF||'Cmp "$(impsess.$(remote.address))" ""'||lf||'TrueJump noISS'||lf
asBUF=asBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) Site AfterSession $(impsess.$(remote.address))"'||lf
asBUF=asBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Site AfterSession: $(impsess.$(remote.address))"'||lf
asBUF=asBUF||'Set systemcmd "$(impsess.$(remote.address))"'||lf||'Jump ISS'||lf
asBUF=asBUF||'noISS:'||lf
/*asBUF=asBUF||'Set RC ${'envpath'IMPSESS}'||lf||'FalseJump aftersession.tic'||lf   */
asBUF=asBUF||'Cmp "${'envpath'IMPSESS}" ""'||lf||'TrueJump aftersession.tic'||lf
asBUF=asBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) AfterSession ${'envpath'IMPSESS}"'||lf
asBUF=asBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) AfterSession:${'envpath'IMPSESS}"'||lf
asBUF=asBUF||'Set systemcmd "${'envpath'IMPSESS}"'||lf
asBUF=asBUF||'ISS:'||lf||'SubJump runsync'||lf
call writech('STDOUT',"TIC ")
asBUF=asBUF||'aftersession.tic:'||lf||'Set RC $(tic)'||lf||'FalseJump aftersession.freq'||lf
/*asBUF=asBUF||'Set RC "$(ticsess.$(remote.address))"'||lf||'FalseJump noFSS'||lf   */
asBUF=asBUF||'Cmp "$(ticsess.$(remote.address))" ""'||lf||'TrueJump noFSS'||lf
asBUF=asBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) Site AfterSession $(ticsess.$(remote.address))"'||lf
asBUF=asBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Site AfterSession: $(ticsess.$(remote.address))"'||lf
asBUF=asBUF||'Set systemcmd "$(ticsess.$(remote.address))"'||lf||'Jump FSS'||lf
asBUF=asBUF||'noFSS:'||lf
asBUF=asBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) AfterSession ${'envpath'TICSESS}"'||lf
asBUF=asBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) AfterSession:${'envpath'TICSESS}"'||lf
asBUF=asBUF||'Set tic FALSE systemcmd "${'envpath'TICSESS}"'||lf
asBUF=asBUF||'FSS:'||lf||'SubJump runsync'||lf
call writech('STDOUT',"FREQ ")
asBUF=asBUF||'aftersession.freq:'||lf||'Set RC $(freq)'||lf||'FalseJump aftersession.term'||lf
/*asBUF=asBUF||'Set RC "$(freqsess.$(remote.address))"'||lf||'FalseJump noRSS'||lf  */
asBUF=asBUF||'Cmp "$(freqsess.$(remote.address))" ""'||lf||'TrueJump noRSS'||lf
asBUF=asBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) Site AfterSession $(freqsess.$(remote.address))"'||lf
asBUF=asBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Site AfterSession: $(freqsess.$(remote.address))"'||lf
asBUF=asBUF||'Set systemcmd "$(freqsess.$(remote.address))"'||lf||'Jump RSS'||lf
asBUF=asBUF||'noRSS:'||lf
asBUF=asBUF||'RexxMsg NY LOGPROC "PutLog 'statgroup' $<p.status) AfterSession ${'envpath'FREQSESS}"'||lf
asBUF=asBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) AfterSession:${'envpath'FREQSESS}"'||lf
asBUF=asBUF||'Set freq FALSE systemcmd "${'envpath'FREQSESS}"'||lf
asBUF=asBUF||'RSS:'||lf||'SubJump runsync'||lf
call writech('STDOUT',"TERM "||lf)
asBUF=asBUF||'aftersession.term:'||lf||'Set RC $(term)'||lf||'FalseJump aftersession_end'||lf
/*asBUF=asBUF||'Set RC "$(termsess.$(remote.address))"'||lf||'FalseJump noTSS'||lf  */
asBUF=asBUF||'Cmp "$(termsess.$(remote.address))" ""'||lf||'TrueJump noTSS'||lf
asBUF=asBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) Site AfterSession $(termsess.$(remote.address))"'||lf
asBUF=asBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Site AfterSession: $(termsess.$(remote.address))"'||lf
asBUF=asBUF||'Set systemcmd "$(termsess.$(remote.address))"'||lf||'Jump TSS'||lf
asBUF=asBUF||'noTSS:'||lf
asBUF=asBUF||'RexxMsg NY LOGPROC "PutLog 'statgroup' $<p.status) AfterSession ${'envpath'TERMSESS}"'||lf
asBUF=asBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) AfterSession:${'envpath'TERMSESS}"'||lf
asBUF=asBUF||'Set term FALSE systemcmd "${'envpath'TERMSESS}"'||lf
asBUF=asBUF||'TSS:'||lf||'SubJump runsync'||lf

asBUF=asBUF||'aftersession_end:'||lf||'SubJump 'l_mailer'!fidonethost'||lf||'SubJump setglobals'||lf||'Set state "WAITING"'||lf
asBUF=asBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) $(state)"'||lf
asBUF=asBUF||'RexxMsg NY LOGPROC "FlushLog 'loggroup'"'||lf
asBUF=asBUF||'Jump idleloopinit'||lf
if debug & log then address 'ROOFLOG' 'logline' left(time(),5) script': asBUF:'length(asBUF)
return

genuser:
userBUF=userBUF||'j_user_input:'||lf
userBUF=userBUF||'Cmp $(chatmode) SYSOP'||lf||'TrueJump forcechat'||lf
userBUF=userBUF||'Set RC $(bootuser)'||lf||'TrueJump freeline'||lf
if addemsi then do
userBUF=userBUF||'Cmp $(namebuf) "
"'||lf'TrueJump sendemsireq'||lf
end
userBUF=userBUF||'Cmp $(namebuf) ""'||lf
/*if addemsi then userBUF=userBUF'TrueJump sendemsireq'||lf */
/*else userBUF=userBUF||'TrueJump do_menu'||lf  */
userBUF=userBUF||'TrueJump do_menu'||lf
userBUF=userBUF||'Set state "SESSION LOGIN $(namebuf)"'||lf
if sc_user then userBUF=userBUF||'SetStatus "$(openstatus)"'||lf||'Print "$(state)\n"'||lf
userBUF=userBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) $(state) $(p.session) $(event) $(p.login) $(username) $(namebuf) $<time>"'||lf
if adduucp then do
call writech('STDOUT',"UUCP ")
userBUF=userBUF||'Pattern $(namebuf) uu#?'||lf
userBUF=userBUF||'TrueJump uucp_inbound'||lf
end
if power then do
userBUF=userBUF||'CmpI $(namebuf) BYE'||lf
userBUF=userBUF||'TrueJump aftersession'||lf
userBUF=userBUF||'Cmp $(namebuf) "${${'sysoppw'}}"'||lf
userBUF=userBUF||'TrueJump loadshell'||lf
end
userBUF=userBUF||'Cmp ${'envpath'ACCESS} TRUE'||lf
userBUF=userBUF||'FalseJump no_access'||lf
if power then do
userBUF=userBUF||'Cmp $(namebuf) "?"'||lf
userBUF=userBUF||'TrueJump showmenu'||lf
end

if ~nobbs then do
    userBUF=userBUF||'CmpI $(namebuf) BBS'||lf
    if gazebo then do
    userBUF=userBUF||'FalseJump do_menu'||lf
    if sendbull then userBUF=userBUF||'SubJump sendbull'||lf||'CheckCarrier'||lf||'FalseJump lost_carrier'||lf
    userBUF=userBUF||'Set RC ${'envpath'BBS}'||lf||'TrueJump bbsok'||lf||'Send "Board access disabled\r\n"'||lf||'Jump do_menu'||lf
    userBUF=userBUF||'bbsok:'||lf||'Set txt "'nl'  Please wait, 'bbsname.1' loading time depends on system load'nl'"'||lf
    userBUF=userBUF||'SubJump showtxt'||lf
    userBUF=userBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) 'bbsname.1'['bbscmd.1'] loading"'||lf
    userBUF=userBUF||'RexxMsg "SY,RY" REXX "Address COMMAND \"'bbscmd.1'\""'||lf||'Set RC $(RESULT1)'||lf
    userBUF=userBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) 'bbsname.1' RC:$(RC)"'||lf
    userBUF=userBUF||'Jump aftersession'||lf
    end /*GAZEBO*/

    if power then do
    select
        when escmode="MENU" then userBUF=userBUF||'TrueJump showmenu'||lf
        when escmode="SELECT" then userBUF=userBUF||'TrueJump selectbbs'||lf
        when escmode="BBS" then userBUF=userBUF||'TrueJump loadbbs1'||lf
        otherwise call errorexit('INVALID ESC-ESC option 'escmode,10)
    end
end
userBUF=userBUF||'Pattern $(namebuf) HELP#?'||lf||'TrueJump sendhelp'||lf
userBUF=userBUF||'Pattern $(wrxlist) #?$(namebuf)#?'||lf||'TrueJump loadwplrx'||lf
userBUF=userBUF||'CmpI $(namebuf) UL'||lf||'FalseJump not_upload'||lf
userBUF=userBUF||'SubJump get_user'||lf||'FalseJump do_menu'||lf||'Jump zmodemrecv'||lf
userBUF=userBUF||'not_upload:'||lf
if ~notext then do
userBUF=userBUF||'CmpI $(namebuf) INFO'||lf||'FalseJump input.1'||lf
userBUF=userBUF||'SubJump get_user'||lf||'FalseJump do_menu'||lf
userBUF=userBUF||'submenu.text:'||lf||'CheckCarrier'||lf||'FalseJump freeline'||lf
userBUF=userBUF||'Cmp $(chatmode) SYSOP'||lf||'TrueJump forcechat'||lf
userBUF=userBUF||'Set RC $(bootuser)'||lf||'TrueJump freeline'||lf
if genmenufile then userBUF=userBUF||'SubJump SendMenu'||lf
else userBUF=userBUF||'SubJump 'l_mailer'menus!textmenu'||lf
userBUF=userBUF||'Set searchlist $(textlist)'||lf||'SubJump menu_input'||lf||'TrueSubJump sendtext'||lf
userBUF=userBUF||'Set RC $(inputerr)'||lf||'TrueJump freeline'||lf
userBUF=userBUF||'Set RC $(main)'||lf||'TrueJump do_menu'||lf
userBUF=userBUF||'Jump submenu.text'||lf
end /*text*/
if ~nomagic then do
userBUF=userBUF||'input.1:'||lf||'CmpI $(namebuf) MAGIC'||lf||'FalseJump input.2'||lf
userBUF=userBUF||'SubJump get_user'||lf||'FalseJump do_menu'||lf
userBUF=userBUF||'submenu.magic:'||lf||'CheckCarrier'||lf||'FalseJump freeline'||lf
userBUF=userBUF||'Cmp $(chatmode) SYSOP'||lf||'TrueJump forcechat'||lf
userBUF=userBUF||'Set RC $(bootuser)'||lf||'TrueJump freeline'||lf
if genmenufile then userBUF=userBUF||'SubJump SendMenu'||lf
else userBUF=userBUF||'SubJump 'l_mailer'menus!magicmenu'||lf
userBUF=userBUF||'Set searchlist $(adllist)'||lf||'SubJump menu_input'||lf||'TrueSubJump zmodemsend'||lf
userBUF=userBUF||'Set RC $(inputerr)'||lf||'TrueJump freeline'||lf
userBUF=userBUF||'Set RC $(main)'||lf||'TrueJump do_menu'||lf
userBUF=userBUF||'Jump submenu.magic'||lf
end
if ~nobbs then do
userBUF=userBUF||'input.2:'||lf||'CmpI $(namebuf) BOARD'||lf||'FalseJump input.3'||lf
if escmode="SELECT" then userBUF=userBUF||'selectbbs:'||lf
userBUF=userBUF||'Set RC ${'envpath'BBS}'||lf||'TrueJump bbsok'||lf||'Send "Sorry, board access is temporarly disabled'nl'"'||lf||'Jump do_menu'||lf
userBUF=userBUF||'bbsok:'||lf
userBUF=userBUF||'SubJump get_user'||lf||'FalseJump do_menu'||lf
userBUF=userBUF||'submenu.bbs:'||lf||'CheckCarrier'||lf||'FalseJump freeline'||lf
userBUF=userBUF||'Cmp $(chatmode) SYSOP'||lf||'TrueJump forcechat'||lf
userBUF=userBUF||'Set RC $(bootuser)'||lf||'TrueJump freeline'||lf
if genmenufile then userBUF=userBUF||'SubJump SendMenu'||lf
else userBUF=userBUF||'SubJump 'l_mailer'menus!bbsmenu'||lf
userBUF=userBUF||'Set searchlist $(bbslist)'||lf||'SubJump menu_input'||lf||'TrueSubJump loadbbs'||lf
userBUF=userBUF||'Set RC $(inputerr)'||lf||'TrueJump freeline'||lf
userBUF=userBUF||'Set RC $(main)'||lf||'TrueJump do_menu'||lf
userBUF=userBUF||'Jump submenu.bbs'||lf
end
if ~nodoor then do
userBUF=userBUF||'input.3:'||lf||'CmpI $(namebuf) DOOR'||lf||'FalseJump do_menu'||lf
userBUF=userBUF||'SubJump get_user'||lf||'FalseJump do_menu'||lf
userBUF=userBUF||'submenu.door:'||lf||'CheckCarrier'||lf||'FalseJump freeline'||lf
userBUF=userBUF||'Cmp $(chatmode) SYSOP'||lf||'TrueJump forcechat'||lf
userBUF=userBUF||'Set RC $(bootuser)'||lf||'TrueJump freeline'||lf
if genmenufile then userBUF=userBUF||'SubJump SendMenu'||lf
else userBUF=userBUF||'SubJump 'l_mailer'menus!doormenu'||lf
userBUF=userBUF||'Set searchlist $(doorlist)'||lf||'SubJump menu_input'||lf||'TrueSubJump loaddoor'||lf
userBUF=userBUF||'Set RC $(inputerr)'||lf||'TrueJump freeline'||lf
userBUF=userBUF||'Set RC $(main)'||lf||'TrueJump do_menu'||lf
userBUF=userBUF||'Jump submenu.door'||lf
end

userBUF=userBUF||'loadshell:'||lf||'Set user TRUE username "$(host.sysop)"'||lf
userBUF=userBUF||'RexxMsg "RY,SY" REXX "Address COMMAND \"Execute Mail:Scripts/AUXCLI\""'||lf
userBUF=userBUF||'Jump do_menu'||lf
end /*POWER*/

if ~umbrella then do
userBUF=userBUF||'no_access:'||lf||'Set txt "'nl' $(notumh)'nl'"'||lf
userBUF=userBUF||'RexxMsg SY "return( (time(m)<(left(word(\"$(umh)\",1),2)*60+right(word(\"$(umh)\",1),2)))|(time(m)>(left(word(\"$(umh)\",2),2)*60+right(word(\"$(umh)\",2),2))) )"'||lf
userBUF=userBUF||'Set RC $(result1)'||lf||'FalseJump notzmh'||lf
userBUF=userBUF||'RexxMsg "SY,RY" REXX "return (((left(word(\"$(umh)\",2),2))*60)-time(m))"'||lf
if gazebo then userBUF=userBUF||'Set txt "'nl'  BBS is not available during Universal Mail Hour'nl'  Call back in $(result2) minutes.'nl'"'||lf
else userBUF=userBUF||'Set txt "'nl'  $(namebuf) is not available during Universal Mail Hour'nl'  Call back in $(result2) minutes.'nl'"'||lf
userBUF=userBUF||'notzmh:'||lf||'SubJump showtxt'||lf
if gazebo then do
userBUF=userBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Denied BBS access"'||lf
if ROOFLOG then userBUF=userBUF||'RexxMsg FY ROOFLOG "LOGLINE $<time> WPL$(line): Denied BBS access"'||lf
end;else do
userBUF=userBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Refused access $(namebuf)"'||lf
if ROOFLOG then userBUF=userBUF||'RexxMsg FY ROOFLOG "LOGLINE $<time> WPL$(line): $(username) denied access $(namebuf)"'||lf
end
userBUF=userBUF||'Jump do_menu'||lf
end

if sendbanner then do
userBUF=userBUF||'j_sendbanner:'||lf||'RexxMsg SY REXX "return exists(\"'bannerfile'\")"'||lf
userBUF=userBUF||'Set RC $(result1)'||lf||'FalseReturn'||lf
userBUF=userBUF||'SubJump ascii_start'||lf||'XprSetFile 'bannerfile' BANNER ""'||lf||'XprSend BANNER'||lf||'SubJump ascii_end'||lf||'Return'||lf
end
if sendbull then do
userBUF=userBUF||'j_sendbull:'||lf||'RexxMsg SY REXX "return exists(\"'bullfile'\")"'||lf
userBUF=userBUF||'Set RC $(result1)'||lf||'FalseReturn'||lf
userBUF=userBUF||'SubJump ascii_start'||lf||'XprSetFile 'bullfile' BULL ""'||lf||'XprSend BULL'||lf||'SubJump ascii_end'||lf||'Return'||lf
end

if power & genmenufile then do
userBUF=userBUF||'j_sendmenu:'||lf||'Set menufile "'menuvol'$(namebuf)'menuext'"'||lf
userBUF=userBUF||'SubJump ascii_start'||lf||'XprSetFile $(menufile) $(namebuf) ""'||lf||'XprSend $(namebuf)'||lf
userBUF=userBUF||'SubJump ascii_end'||lf||'clear menufile'||lf||'return'||lf
end

if power then do
userBUF=userBUF||'j_sendtext:'||lf||'SubJump ascii_start'||lf||'XprSetFile $($(namebuf)) $(namebuf) ""'||lf||'XprSend $(namebuf)'||lf||'SubJump ascii_end'||lf||'Return'||lf
userBUF=userBUF||'j_showmenu:'||lf||'SubJump get_user'||lf
if genmenufile then userBUF=userBUF||'Set namebuf MAIN'||lf||'TrueSubJump SendMenu'||lf
else userBUF=userBUF||'TrueSubJump 'l_mailer'menus!wplmenu'||lf
userBUF=userBUF||'Jump do_menu'||lf

userBUF=userBUF||'j_get_user:'||lf||'Set RC $(user)'||lf||'TrueReturn'||lf
userBUF=userBUF||'Set usrcmdbuf $(namebuf)'||lf
if ROOFLOG then userBUF=userBUF||'RexxMsg FY ROOFLOG "UPDATE_STAT $(humanin)"'||lf
if sendbull then userBUF=userBUF||'SubJump sendbull'||lf||'CheckCarrier'||lf||'FalseJump lost_carrier'||lf

userBUF=userBUF||'Set txt "'nl'  Please enter your name: "'||lf||'SubJump showtxt'||lf
userBUF=userBUF||'GetInbound E0 $(loginwait)'||lf||'Cmp $(event) LOGIN'||lf||'FalseReturn'||lf
userBUF=userBUF||'RexxMsg SY REXX "x=space(\"$(namebuf)\",1);return((index(x,\"_\")=0)&(index(x,\".\")=0)&(index(x,\"?\")=0)&(words(x)>1)&(length(x)>6))"'||lf
userBUF=userBUF||'Set RC $(result1)'||lf||'TrueJump set_it'||lf
userBUF=userBUF||'Set txt "  Your real name is required to access our services'nl'  There should be no punctuation marks,'nl'  dashs are permitted.'nl'""'||lf||'SubJump showtxt'||lf
userBUF=userBUF||'Set namebuf $(usrcmdbuf) user FALSE RC FALSE'||lf||'Return'||lf

userBUF=userBUF||'set_it:'||lf
userBUF=userBUF||'RexxMsg "SY,RY" REXX "x=BITOR(space(\"$(namebuf)\",1),\"20\"x);y=\"\";do z=1 to words(x);y=y||Upper(Left(Word(x,z),1))||SubStr(Word(x,z),2)||\"20\"x;end;return strip(y)"'||lf
userBUF=userBUF||'Set username $(result2)'||lf
if ROOFLOG then userBUF=userBUF||'RexxMsg FY ROOFLOG "LOGLINE $<time> WPL$(line): Inbound HUMAN Session $(username) @ $(baud)"'||lf
userBUF=userBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.inbound) USER"'||lf
userBUF=userBUF||'RexxMsg "SY,RY" REXX "return upper(translate(\"$(namebuf)\",\"_\",\" \"))" '||lf
userBUF=userBUF||'SetA remote "$(result2)#0:0/0.0"'||lf
userBUF=userBUF||'RexxMsg "SY,RY" REXX "return translate(\"$(remote.address)\",\"...\",\"#:/\")"'||lf
userBUF=userBUF||'Set YourMail "LOG:RFSacct/h/$(result2).m"'||lf
userBUF=userBUF||'Send "  Hello, $(username)'nl'"'||lf
userBUF=userBUF||'Set state "Inbound Session $(username)"'||lf
userBUF=userBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(state)"'||lf
if addspeech then do
userBUF=userBUF||'Set sl 70 speech $(state)'||lf||'SubJump sayit '||lf
end
userBUF=userBUF||'RexxMsg SY REXX "return exists(\"$(YourMail)\")"'||lf||'Set RC $(result1)'||lf||'TrueSubJump showmsg'||lf
userBUF=userBUF||'Clear YourMail'||lf
userBUF=userBUF||'Set namebuf "$(usrcmdbuf)" remote.network FIDO inbound $(userdir) user TRUE RC TRUE'||lf
userBUF=userBUF||'Return'||lf

userBUF=userBUF||'showmsg:'||lf
userBUF=userBUF||'Print "Sending sysop message to $(username)\n"'||lf
userBUF=userBUF||'Send "  The sysop left this message for you, $(username)'nl||nl'"'||lf
userBUF=userBUF||'SubJump ascii_start'||lf||'XprSetFile $(YourMail) "YourMail" ""'||lf||'XprSend "YourMail"'||lf
userBUF=userBUF||'SubJump ascii_end'||lf
if ROOFLOG then userBUF=userBUF||'RexxMsg FY ROOFLOG "UPDATE_STAT $(msgout)"'||lf
userBUF=userBUF||'CmpI $(usrcmdbuf) NOTE'||lf||'TrueReturn'||lf
userBUF=userBUF||'Print "Asking $(username) for reply to sysop message\n"'||lf
userBUF=userBUF||'Send "  If you missed the message, you can see it again on your next'nl'"'||lf
userBUF=userBUF||'Send "  call. It will be deleted after you reply to it.'nl||nl'"'||lf
userBUF=userBUF||'Send "  Do you wish to reply NOW? (y/N):"'||lf
userBUF=userBUF||'GetInbound E0 $(loginwait)'||lf
userBUF=userBUF||'Cmp $(event) LOGIN'||lf||'FalseReturn'||lf
userBUF=userBUF||'CmpI $(namebuf) Y'||lf||'FalseReturn'||lf
userBUF=userBUF||'Print "$(username) repling\n"'||lf||'Set session NOTE'||lf
userBUF=userBUF||'Set txt "'nl'  Please wait $(username), $(session) loading time depends on system load'nl'"'||lf
userBUF=userBUF||'SubJump showtxt'||lf
userBUF=userBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(session) loading for $(username)"'||lf
userBUF=userBUF||'Address REXX "$(rexxdir)$(session) $(baud) $(line) $(username)"'||lf
userBUF=userBUF||'Print "Reply completed\n"'||lf
if ROOFLOG then userBUF=userBUF||'RexxMsg FY ROOFLOG "UPDATE_STAT $(msgin)"'||lf
userBUF=userBUF||'Return'||lf

userBUF=userBUF||'forcechat:'||lf
userBUF=userBUF||'Print "Forcing chat with $(username)\n"'||lf||'Set session CHAT'||lf
userBUF=userBUF||'Set txt "'nl'  Please wait $(username), $(sysop) is coming online'nl'"'||lf
userBUF=userBUF||'SubJump showtxt'||lf
userBUF=userBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(session) loading for $(username)"'||lf
userBUF=userBUF||'Address REXX "$(rexxdir)$(session) $(baud) $(line) $(username) SYSOP"'||lf
userBUF=userBUF||'Print "Chat completed\n"'||lf
userBUF=userBUF||'Jump do_menu'||lf

userBUF=userBUF||'j_sendhelp:'||lf||'SubJump get_user'||lf||'FalseJump do_menu'||lf
userBUF=userBUF||'Print "Sending $(namebuf) help to $(username)\n"'||lf
userBUF=userBUF||'RexxMsg "SY,RY" REXX "if words(\"$(namebuf)\")=2 then return \"INFO:\"||subword(strip(\"$(namebuf)\"),2)||\".hlp\"; else return \"INFO:HELP.HLP\""'||lf
userBUF=userBUF||'Set helpfile $(result2)'||lf||'RexxMsg SY REXX "return exists(\"$(helpfile)\")"'||lf
userBUF=userBUF||'Set RC $(result1)'||lf||'FalseJump no_help'||lf
userBUF=userBUF||'SubJump ascii_start'||lf||'XprSetFile $(helpfile) "$(namebuf).HLP" ""'||lf
userBUF=userBUF||'XprSend "$(namebuf).HLP"'||lf||'SubJump ascii_end'||lf
userBUF=userBUF||'Jump do_menu'||lf

userBUF=userBUF||'no_help:'||lf||'Set txt "'nl'  Sorry, there is presently no help for $(namebuf)'nl'"'||lf||'SubJump showtxt'||lf||'Jump do_menu'||lf
  
userBUF=userBUF||'j_menu_input:'||lf||'Set inputerr FALSE main FALSE'||lf||'Clear event namebuf'||lf
userBUF=userBUF||'GetInbound E0 $(loginwait)'||lf
userBUF=userBUF||'Cmp $(event) TIMEOUT'||lf||'FalseJump menu_input.1'||lf
userBUF=userBUF||'Set txt $(timeout)'||lf||'SubJump showtxt'||lf
userBUF=userBUF||'Set inputerr TRUE RC FALSE'||lf||'Return'||lf

userBUF=userBUF||'menu_input.1:'||lf
userBUF=userBUF||'Cmp $(event) CARRIER'||lf||'FalseJump menu_input.2'||lf
userBUF=userBUF||'Set inputerr TRUE RC FALSE'||lf||'Return'||lf

userBUF=userBUF||'menu_input.2:'||lf
userBUF=userBUF||'Cmp $(event) LOGIN'||lf||'FalseReturn'||lf
userBUF=userBUF||'CmpI $(namebuf) ""'||lf||'FalseJump menu_input.3'||lf
userBUF=userBUF||'Set main TRUE RC FALSE'||lf||'Return'||lf

userBUF=userBUF||'menu_input.3:'||lf
userBUF=userBUF||'Pattern $(searchlist) #?$(namebuf)#?'||lf||'TrueReturn'||lf
userBUF=userBUF||'Send "  Sorry, selection $(namebuf) is unavailable.'nl'"'||lf
userBUF=userBUF||'Set RC FALSE'||lf||'Return'||lf

userBUF=userBUF||'j_loadwplrx:'||lf||'Set session $(namebuf)'||lf
userBUF=userBUF||'SubJump get_user'||lf||'FalseJump do_menu'||lf
userBUF=userBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.session) $(session) $(p.login) $(username) $<time>"'||lf
userBUF=userBUF||'Set txt "'nl'  Please wait $(username), $(session) loading time depends on system load'nl'"'||lf||'SubJump showtxt'||lf
userBUF=userBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(session) loading for $(username)"'||lf
userBUF=userBUF||'Address REXX "$(rexxdir)$(session) $(baud) $(line) $(username)"'||lf
userBUF=userBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(session) RC:$(RC)"'||lf
userBUF=userBUF||'Jump do_menu'||lf

if ~nodoor then do
userBUF=userBUF||'j_loaddoor:'||lf||'Set session "$(doorname.$(namebuf))" systemcmd "$(door.$(namebuf))"'||lf
userBUF=userBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.session) $(session) $(p.login) $(username) $<time>"'||lf
userBUF=userBUF||'Set txt "'nl'  Please wait $(username), $(session) loading time depends on system load'nl'"'||lf||'SubJump showtxt'||lf
userBUF=userBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(session) loading for $(username)"'||lf
userBUF=userBUF||'Address REXX "$(rexxdir)DOOR $(baud) $<port> \"$(username)\" $(systemcmd)"'||lf
userBUF=userBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(session) RC:$(RC)"'||lf
userBUF=userBUF||'Return'||lf
end

if ~nobbs then do
if escmode="BBS" then do
userBUF=userBUF||'loadbbs1:'||lf
userBUF=userBUF||'Set RC ${'envpath'BBS}'||lf||'TrueJump load1ok'||lf||'Send "Sorry, board access is temporarly disabled'nl'"'||lf||'Jump freeline'||lf
userBUF=userBUF||'load1ok:'||lf||'Set namebuf "1"'||lf||'Set exitbbs TRUE'||lf
end
userBUF=userBUF||'j_loadbbs:'||lf||'Set session "BBS $(bbsname.$(namebuf))" systemcmd "$(bbs.$(namebuf)) $(baud) $(line)"'||lf
userBUF=userBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.session) $(session) $(p.login) $(username) $<time>"'||lf
if ROOFLOG then userBUF=userBUF||'RexxMsg FY ROOFLOG "UPDATE_STAT $(bbsin)"'||lf
userBUF=userBUF||'Set txt "'nl'  Please wait $(username), $(session) loading time depends on system load'nl'"'||lf||'SubJump showtxt'||lf
userBUF=userBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(session) loading for $(username)"'||lf
userBUF=userBUF||'RexxMsg "SY,RY" REXX "Address COMMAND \"$(systemcmd)\""'||lf||'Set RC $(RESULT1)'||lf
userBUF=userBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(session) RC:$(RC)"'||lf
if escmode="BBS" then userBUF=userBUF'Set RC $(exitbbs)'||lf||'Clear exitbbs'||lf||'TrueJump freeline'||lf
userBUF=userBUF||'Return'||lf
end /*nobbs*/
end /*POWER*/
return

genloop:
loopBUF=loopBUF||'lost_carrier:'||lf||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Caller dropped carrier"'||lf
loopBUF=loopBUF||'ModemClear'||lf||'ModemInit'||lf
loopBUF=loopBUF||'freeline:'||lf
if ~sc_modem then loopBUF=loopBUF||'SetStatus NULL:'||lf
if power then loopBUF=loopBUF||'Clear bootuser'||lf
loopBUF=loopBUF||'ModemClear'||lf||'SetPri $(launchpri)'||lf
loopBUF=loopBUF||'Cmp $(exit) RESTART'||lf||'TrueJump closeslave'||lf
loopBUF=loopBUF||'Set RC $<abort>'||lf||'TrueJump closeslave'||lf
loopBUF=loopBUF||'Set State "BUSY MODEM CLOSE"'||lf||'ModemClose'||lf||'System "Wait 3"'||lf
loopBUF=loopBUF||'slaveloop:'||lf||'SubJump setglobals'||lf||'SubJump openslave'||lf
loopBUF=loopBUF||'TrueJump aftersession_end'||lf
loopBUF=loopBUF||'Set state "'u_mailer'$(line) MODEM DEAD on $(state)"'||lf
loopBUF=loopBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) $(state)"'||lf
loopBUF=loopBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) $(state)"'||lf

loopBUF=loopBUF||'ModemClose'||lf||'SubJump openslave'||lf||'TrueJump aftersession_end'||lf

if roof then loopBUF=loopBUF||'RexxMsg FY ROOFLOG "CLOSESTATUS WPL $(line)"'||lf
else loopBUF=loopBUF||'RexxMsg "" REXX "$(rexxdir)SHELTER.rexx CLOSESTATUS $(line)"'||lf

loopBUF=loopBUF||'Jump closelogs'||lf
loopBUF=loopBUF||'closeslave:'||lf||'Set state "MODEM CLOSE"'||lf
loopBUF=loopBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.status) $(state)"'||lf
loopBUF=loopBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Closing modem Slave$(line)"'||lf
loopBUF=loopBUF||'ModemClose'||lf

if roof then loopBUF=loopBUF||'RexxMsg FY ROOFLOG "CLOSESTATUS WPL $(line)"'||lf
else loopBUF=loopBUF||'RexxMsg "" REXX "$(rexxdir)SHELTER.rexx CLOSESTATUS $(line)"'

loopBUF=loopBUF||'Cmp $(exit) RESTART'||lf||'FalseJump closelogs'||lf
loopBUF=loopBUF||'recompile:'||lf||'Cmp $(line) 1'||lf||'FalseReturn'||lf
loopBUF=loopBUF||'Set state "RECOMPILING"'||lf
loopBUF=loopBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Re-compile requested Slave$(line)"'||lf
loopBUF=loopBUF||'closelogs:'||lf||'LoadScript xcache ""'||lf||'RexxMsg NY LOGPROC "FlushLog 'loggroup'"'||lf||'Return'||lf
loopBUF=loopBUF||'openslave:'||lf||'Set State "BUSY MODEM OPEN"'||lf||'ModemClear'||lf||'ModemClose'||lf
loopBUF=loopBUF||'ModemOpen'||lf||'FalseReturn'||lf||'SetBaud $(lockedrate)'||lf||'ModemInit'||lf||'Return'||lf
loopBUF=loopBUF||'idleloopinit:'||lf||'Cmp $(exit) CACHE'||lf||'FalseJump idl.1'||lf
loopBUF=loopBUF||'SubJump xcache!setcache'||lf
loopBUF=loopBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) ReLoaded Cache"'||lf
loopBUF=loopBUF||'RexxMsg NY LOGPROC "FlushLog 'loggroup'"'||lf
loopBUF=loopBUF||'Clear exit'||lf
loopBUF=loopBUF||'idl.1:'||lf
loopBUF=loopBUF||'; this commented section is suggested by Russ in order to'||lf
loopBUF=loopBUF||'; allow external REXX calls a safe window to call ModemOpen'||lf
loopBUF=loopBUF||';Set state "BUSY WAITEVENT"'||lf
loopBUF=loopBUF||';WaitEvent 5'||lf
loopBUF=loopBUF||';Print "WaitEvent:$(event)\n"'||lf
loopBUF=loopBUF||'RexxMsg "SY,RY" REXX "Return left(time(),5)"'||lf
loopBUF=loopBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' @1,55,6 @R $(result2)"'||lf
loopBUF=loopBUF||'Set state "BUSY MODEM INIT"'||lf||'SubJump 'l_mailer'modem!modeminit'||lf
loopBUF=loopBUF||';  ModemInit'||lf
loopBUF=loopBUF||'FalseJump freeline'||lf
loopBUF=loopBUF||'Set state "WAITING"'||lf||'CheckCall'||lf||'TrueJump dodial'||lf
loopBUF=loopBUF||'Set RC $<abort>'||lf||'TrueJump closeslave'||lf
loopBUF=loopBUF||'waitring:'||lf||'Set OwnDevUnit TRUE CallInterupt TRUE'||lf
loopBUF=loopBUF||'GetResponse $(wakeup)'||lf||'Set OwnDevUnit FALSE CallInterupt FALSE'||lf
loopBUF=loopBUF||'Cmp $(event) OWNDEVUNIT'||lf||'TrueJump freeline'||lf
if ~noanswer then loopBUF=loopBUF||'Cmp $(event) RING'||lf||'TrueJump answer'||lf
loopBUF=loopBUF||'Jump idleloopinit'||lf
return

genvars:
varBUF=varBUF||'j_setglobals:'||lf
if power then do
varBUF=varBUF||'Cmp $(user) TRUE'||lf||'FalseJump sg.1'||lf
varBUF=varBUF||'SetEnv VUSER'line' FALSE'||lf
varBUF=varBUF||'sg.1:'||lf||'Set send FALSE user FALSE'||lf
end
varBUF=varBUF||'SubJump clearglobals'||lf
varBUF=varBUF||'Set host.wzcap 13 host.wzprot "DietIFNA ZedZip ZedZap"'||lf 
if addfreq then varBUF=varBUF||'Set host.wzext "+Freq +Domain" host.freq "TRUE"'||lf
else varBUF=varBUF||'Set host.wzext "-Freq +Domain" host.freq "FALSE"'||lf
varBUF=varBUF||'SubJump 'l_mailer'!fidonethost'||lf
if addemsi then varBUF=varBUF||'Set host.flags $(emsi.flags) host.link $(emsi.link) host.compat $(emsi.compat) host.addresses "'strip(myakas)'"'||lf
varBUF=varBUF||'Set MaxSendPri 127 MinSendPri -127 crash FALSE nopickup FALSE'||lf
varBUF=varBUF||'Set baud 'lockbps' resume FALSE multihub FALSE issecure TRUE dial $(DialString) useline $(line)'||lf
varBUF=varBUF||'Set term FALSE fax FALSE'||lf||'SetMailerFlags "DY,PY"'||lf
varBUF=varBUF||'System "SetEnv WPLNAME \"'u_mailer smver vdate'\""'||lf
varBUF=varBUF||'Return'||lf

varBUF=varBUF||'j_clearglobals:'||lf
if ROOFLOG then varBUF=varBUF||'Clear calltask.$(remote.address) callcount.$(remote.address)'||lf
varBUF=varBUF||'Clear session protocol systemcmd dialrc host.wzext fts1 isoutbound'||lf
varBUF=varBUF||'Clear infile remfile localfile recfile filesize filestatus called'||lf
varBUF=varBUF||'Clear event lastresponse resp ENTRY NameBuf OwnDevUnit UserName temp'||lf
varBUF=varBUF||'Clear remote.text remote.network remote.address'||lf
varBUF=varBUF||'Clear remote.domain remote.zone remote.net remote.node remote.point'||lf
varBUF=varBUF||'Clear remote.number remote.cost remote.maxbaud remote.flags'||lf
varBUF=varBUF||'Clear remote.sitename remote.sysop remote.password'||lf
varBUF=varBUF||'Clear remote.wzcap remote.wzdomain remote.product remote.product_maj remote.product_min remote.freq'||lf
varBUF=varBUF||'Clear searchlist inputerr main usrcmdbuf tmpbaud tmpbuf RC Result1 Result2'||lf
if addemsi then varBUF=varBUF||'Clear emsireqsent remote.addresses remote.compat remote.baud remote.link remote.city remote.mailer remote.product remote.version remote.serial'||lf
varBUF=varBUF||'Return'||lf
if debug & log then address 'ROOFLOG' 'logline' left(time(),5) script': vaBUF:'length(varBUF)
return

set_sitetype: procedure
if left(upper(arg(1)),3)="BBS" then return 5
else if left(upper(arg(1)),3)="FAX" then return 4
else if left(upper(arg(1)),5)="CLOCK" then return 3
else if (left(upper(arg(1)),2)="UU"|datatype(right(arg(1),2),'MIXED')) then return 2
else return 1

gencache:
if ~open('cfg',cachecfg,'r') then call ERRORABORT('Cannot find 'cachecfg,10)
/* allowable keywords per site type */
dtype.5="BBS"
keys.5='number altnum line dial sitename sysop term predial termsess'
dtype.4="FAX"
keys.4='number altnum line dial sysop xprsetup predial'
dtype.3="CLOCK"
keys.3='number altnum line dial sitename baud xprsetup predial'
dtype.2="UUCP"
keys.2='number altnum line dial sitename sysop password uuoptions predial impsess'
dtype.1="FTN"
keys.1='number altnum line dial sitename sysop password multi useakasin useakasout handshake present predial presess impsess freqsess ticsess'
htype.3="EMSI" ;hoflag.3="GE,DE,"
htype.2="WAZOO";hoflag.2="G6,D6,"
htype.1="FTS1" ;hoflag.1="G1,D1,"
    say 'Parsing 'cachecfg
    i=1
    do while ~eof('cfg')
        call writech('STDOUT','.')
        line.i=readln('cfg')
        if line.i="" | left(line.i,2)='/*' | left(line.i,2)='*/' then iterate
        i=i+1
    end
    call close('cfg')
    drop cfg
    say;call writech('STDOUT','Compiling')
    end=i-1
    nodes=0;numbers=0;dohs=0
    houtflags=""
    lf='0a'x
    writebuf="setcache:"||lf
    do i=1 to end
        call writech('STDOUT','.')
        drop j k
        x=line.i;wplvar=word(x,1);wplvalue=strip(subword(x,2))

        if upper(wplvar)="NODE" then do
            if numberBUF~="NUMBERBUF" & akas > 1 then do
                numberbuf=strip(numberbuf)||lf
                if altnumbuf="Set " then altnumbuf=""
                    else altnumbuf=strip(altnumbuf)||lf
                sysopbuf=strip(sysopbuf)||lf
                sitenamebuf=strip(sitenamebuf)||lf
                passwordbuf=strip(passwordbuf)||lf
                if useakasinbuf="Set " then useakasinbuf=""
                    else useakasinbuf=strip(useakasinbuf)||lf
                if useakasoutbuf="Set " then useakasoutbuf=""
                    else useakasoutbuf=strip(useakasoutbuf)||lf
                if multibuf="Set " then multibuf=""
                    else multibuf=strip(multibuf)||lf
                writebuf=writebuf||numberbuf||altnumbuf||sysopbuf||sitenamebuf||passwordbuf
                drop numberbuf altnumbuf sysopbuf sitenamebuf passwordbuf
                writebuf=writebuf||useakasinbuf||useakasoutbuf||multibuf
                drop useakasinbuf useakasoutbuf multibuf
            end
            numberbuf="Set "
            altnumbuf="Set "
            sysopbuf="Set "
            sitenamebuf="Set "
            passwordbuf="Set "
            useakasinbuf="Set "
            useakasoutbuf="Set "
            multibuf="Set "
            if dohs then do
                do j=1 to akas
                    writebuf=writebuf||'Set outflags.'node.j '"'strip(houtflags,'T',',')'"'||lf
                end
                dohs=0
                houtflags=""
            end
            numbers=0;siteakalist=""
            akas=words(wplvalue)
            if akas > 1 then
            do j=1 to akas
                node.j=word(wplvalue,j)
                sitetype.j=set_sitetype(node.j)
                if debug then Say "Found "sitetype.j" AKA" node.j
                sitetype.j=set_sitetype(node.j)
                if sitetype.j=1 then do
                    if debug then say 'Adding 'node.j' to akalist'
                    siteakalist=siteakalist||" "||node.j
                end
                nodes=nodes+1
            end;else do
                j=1
                node.j=wplvalue
                sitetype.j=set_sitetype(node.j)
                if debug then Say "Found "sitetype.j" Site" node.j
                nodes=nodes+1
            end
        end;else do  /*not NODE entry */
            if wplvalue="" then iterate

            if upper(wplvar)="HANDSHAKE" then do
                dohs=1
                do h=1 to 3
                    if pos(htype.h,wplvalue) > 0 then do
                        houtflags=houtflags||hoflag.h
                    end
                end
                iterate
            end

            if upper(wplvar)="NUMBER" | upper(wplvar)="ALTNUM" then do
                numbers=numbers+1
                wplvalue=compress(wplvalue," -")
                node.j.numbers=wplvalue
            end

            if akas > 1 then
            do k=1 to akas
                stype=sitetype.k
                if debug then say sitetype.k keys.stype
                if index(keys.stype,wplvar)=0 then iterate
                akawplvar=wplvar||'.'||node.k
                if debug then Say "AKA:" node.k  akawplvar wplvalue   

                if upper(wplvar)="NUMBER" & words(siteakalist) >1 then do
                    writebuf=writebuf||'Set akalist.'wplvalue '"'strip(siteakalist)'"'||lf
                    siteakalist=""   
                end
                select
                    when wplvar='number' then numberbuf=numberbuf||akawplvar '"'wplvalue'" '
                    when wplvar='altnum' then altnumbuf=altnumbuf||akawplvar '"'wplvalue'" '
                    when wplvar='sitename' then sitenamebuf=sitenamebuf||akawplvar '"'wplvalue'" '
                    when wplvar='sysop' then sysopbuf=sysopbuf||akawplvar '"'wplvalue'" '
                    when wplvar='password' then passwordbuf=passwordbuf||akawplvar '"'wplvalue'" '
                    when wplvar='useakasin' then useakasinbuf=useakasinbuf||akawplvar '"'wplvalue'" '
                    when wplvar='useakasout' then useakasoutbuf=useakasoutbuf||akawplvar '"'wplvalue'" '
                    when wplvar='multi' then multibuf=multibuf||akawplvar '"'wplvalue'" '
                    otherwise writebuf=writebuf||'Set 'akawplvar '"'wplvalue'"'||lf
                end    
            end;else do
                k=1
                stype=sitetype.k
                if debug then say sitetype.k keys.stype
                if index(keys.stype,wplvar)=0 then do
                    say;say mwarn" Keyword" wplvar "invalid for "dtype.stype" site"
                    iterate
                end
                wplvar=wplvar||'.'||node.k
                if debug then Say "NO AKA:" node.k wplvar wplvalue
                writebuf=writebuf||'Set 'wplvar '"'wplvalue'"'||lf
            end
        end
    end

    writebuf=writebuf||"Return"||lf
    say
    call open('cw',cachewpl,"W")
    call writech('cw',writebuf)
    call close('cw')
    drop cw writebuf
    Say "Wrote "cachewpl

    if mode="CACHE" & show('P',u_mailer||"1") then do
        say "ReLoading "cachewpl
        address COMMAND 'LoadScript xcache' cachewpl
        if RC~=0 then CALL errorabort('Cannot load 'cachewpl,10)
        say "Cache loaded"
        if umbrella then ports=1
            else ports=GetClip('SLAVES')
        do i=ports to 1 by -1
            if show('p',u_mailer||i) then do
                address VALUE u_mailer||i
                'Set exit CACHE'
                say u_mailer||i 'activated new cache'
            end
        end
    end
    nocache=0
return nocache

gencallscript:
scriptbuf=""
if umbrella then scriptbuf=scriptbuf||'.key a,b,c,d,e'||lf||'RUN RX ${'envpath'REXXDIR}/Scall <a> <b> <c> <d> <e>'||lf
else scriptbuf=scriptbuf||'.key a,b,c,d,e'||lf||'RUN RX ${'envpath'REXXDIR}/Scall <a> <b> <c> <d> <e>'||lf
call open('cs',callscript,"W")
call writech('cs',scriptbuf)
call close('cs')
drop cs scriptbuf
Say "Wrote "callscript
address COMMAND "PROTECT" callscript "SWERD"
return

genbootuserscript:
scriptbuf='.key line/a'||lf||'RUN RX "Address 'u_mailer'<line> Set bootuser TRUE"'||lf
call open('bus',buscript,"W")
call writech('bus',scriptbuf)
call close('bus')
drop bus scriptbuf
Say "Wrote "buscript
address COMMAND "PROTECT" buscript "SWERD"
return

get_fn:
if LastPos('/',arg(1))~=0 then return SubStr(arg(1),LastPos('/',arg(1))+1)
else if LastPos(':',arg(1))~=0 then return SubStr(arg(1),LastPos(':',arg(1))+1)
else return arg(1)

/* align text to right of field  adding spaces or trucating on left to fit   */
right_justify:
if length(arg(1))>arg(2) then return (right(arg(1),arg(2)))
else return (copies(" ",arg(2)-length(arg(1)))||arg(1))

/* align text to left of field  adding spaces or trucating on right to fit   */
left_justify:
if length(arg(1))>arg(2) then return (left(arg(1),arg(2)))
else return (arg(1)||copies(" ",arg(2)-length(arg(1))))

/* Walt Sullivan */
expand: procedure expose debug BOLD AOFF
answer=arg(1)
lmatch='$'
rmatch=''
ndx=index(answer,lmatch)
rndx=index(answer,rmatch)
do while ndx ~= 0
    if rndx < ndx then CALL errorabort("Malformed string:" answer,10) 
    v=substr(answer,ndx+length(lmatch),rndx-(ndx+length(lmatch)))
    exp=ReadVar(v,"R")
    if exp="" then CALL errorabort('Environmental variable 'v' not set',10)
    answer=substr(answer,1,ndx+1-LENGTH(lmatch))||exp||substr(answer,rndx+length(rmatch))
    ndx=index(answer,lmatch)
    rndx=index(answer,rmatch)
end
return answer

undefer: procedure expose debug BOLD AOFF
answer=arg(1)
lmatch='$$('
rmatch=')'
ndx=index(answer,lmatch)
rndx=index(answer,rmatch)
do while ndx ~= 0
    if rndx < ndx then CALL errorabort("Malformed string:" answer,10)
    v=substr(answer,ndx+length(lmatch),rndx-(ndx+length(lmatch)))
    exp="$("v")"
    answer=substr(answer,1,ndx+2-LENGTH(lmatch))||exp||substr(answer,rndx+length(rmatch))
    ndx=index(answer,lmatch)
    rndx=index(answer,rmatch)
end
return answer

lower:
return(bitor(arg(1),'20'x))

addslash:
curr=arg(1)
select
when right(curr, 1)=":" then nop
when right(curr, 1)="/" then nop
otherwise curr=curr"/"
end
return(curr)

requote:
return('"'strip(arg(1))'"')

/* a useful procedure by Walt Sullivan */
dequote:
parse arg thing
parse var thing '"' unq_thing '"'
if unq_thing ~= "" then return unq_thing
return thing

SaveEnv:
if roof then return   
call writech('STDOUT',"Saving prefs to ENVARC:"envpath)
address COMMAND "Copy ENV:"envpath"#? ENVARC:"envpath" ALL CLONE QUIET"
call writech('STDOUT'," ..Done"||lf)
return

ReadVar: procedure expose ENVPATH
    if arg(2)~="R" then x=GetVar(envpath||arg(1),"G")
    else x=GetVar(arg(1),"G")
return x

SetVars:
if index(arg(3),"E")=0 then call SetClip(arg(1),arg(2))
if index(arg(3),"R")>0 then root=1
else root=0
    if root then call SetVar(arg(1),arg(2),"G")
    else call SetVar(envpath||arg(1),arg(2),"G")
    if root then address COMMAND 'Copy ENV:'arg(1)' ENVARC: CLONE QUIET'
return

join:
x=arg(1)' 'arg(2)' 'arg(3)
temp='arexxtempfile'
do i=1 to (words(x)-1)
    if word(x,i)=word(x,words(x)) then do
        oops=word(x,words(x))
        x=delword(x,words(x))||'TO '||temp
        address COMMAND 'Join' x
        address COMMAND 'Copy ' temp ' ' oops
        call delete(temp)
        return 0
    end
end
x=arg(1)' 'arg(2)' TO 'arg(3)
address COMMAND 'Join' x
return 0

setserial:
roofprod=1   /* wplemsi.library fixed for roof product code              */
vdate='('||translate(date("E"),'.','/')||')'
nq=date("NORMAL")
parse var nq dq' 'mq' 'yq .
parse var smver x '.' y
emsiserial=u_mailer x'.'y'/Beta' '['genver']' mq dq yq '('time()')'
drop x y nq dq mq yq
Say "Compiling "BOLD||mode||AOFF" for the "BOLD||u_mailer||AOFF" Mailer"
Say "["emsiserial"]"
return

roofusage:
say " The Roof Mailer, unlike the other Shelter Mailers, is NOT a standalone"
SAY " mailer, but is a  part of the Roof  System.  Configuration information"
SAY " is derived from an active Roof System's CFG:ROOF.CFG.  Keywords, ENVs,"
SAY " assigns, and Roof Function Hosts are assumed to be present and active."
say ""
if ~show('p',"ROOFLOG") then CALL errorabort("The ROOFLOG Function Host is not active, exiting",20)
return

usage:
say BOLD||"  Error:"||AOFF||arg(1)
usage1:
say BOLD||"         Usage: "script" Mailer Output InputPath"||AOFF
say ITALICS"   Mailer:"AOFF
say "               "BOLD"ROOF | PORTICUS | GAZEBO | UMBRELLA"||AOFF
say ITALICS"   OutPut:"AOFF
say ""
say BOLD||"       ALL"AOFF"     All output modules are generated"
say BOLD||"       EMSI"AOFF"    EMSI is added to ALL"
say BOLD||"       ALLNC"AOFF"   Cache, Clock, [Notify] are not regenerated"
say BOLD||"       EMSINC"AOFF"  Cache, Clock, [Notify] are not regenerated"
say BOLD||"       CACHE"AOFF"   Regenerate and Reload Site Cache"
say ITALICS"   InputPath:"AOFF
say "          path to "ITALICS"Mailer"AOFF"Gen.cfg, Cache.cfg and subdirs modems/ and src/"
say "          defaults to CFG:wpl/gen/"ITALICS"MailerName"AOFF
say
exit arg(2)

errorabort:
say;say BOLD||"ERROR:"||AOFF arg(1)
exit arg(2)
/**/

sizebuffers:
address 'ROOFLOG' 'logline' left(time(),5) script': MainBUF:'length(mainBUF)
address 'ROOFLOG' 'logline' left(time(),5) script': EmsiBUF:'length(emsiBUF)
address 'ROOFLOG' 'logline' left(time(),5) script': WzBUF  :'length(wzBUF)
address 'ROOFLOG' 'logline' left(time(),5) script': XprBUF :'length(xprBUF)
address 'ROOFLOG' 'logline' left(time(),5) script': uuBUF  :'length(uuBUF)
address 'ROOFLOG' 'logline' left(time(),5) script': aBUF   :'length(aBUF)
address 'ROOFLOG' 'logline' left(time(),5) script': dialBUF:'length(dialBUF)
address 'ROOFLOG' 'logline' left(time(),5) script': ansBUF :'length(ansBUF)
address 'ROOFLOG' 'logline' left(time(),5) script': userBUF:'length(userBUF)
address 'ROOFLOG' 'logline' left(time(),5) script': loopBUF:'length(loopBUF)
return

SetGlobal:
call SetClip(upper(arg(1)),arg(2))
address COMMAND "SetEnv "arg(1) arg(2)
address COMMAND "SetEnv ENVARC:"arg(1) arg(2)
return

genfax:
faxBUF=faxBUF||'faxconnect:'||lf
if ROOFLOG then faxBUF=faxBUF||'RexxMsg FY ROOFLOG "UPDATE_STAT $(callsout)"'||lf
faxBUF=faxBUF||'SubJump ckpresess'||lf||'Cmp dialrc 5'||lf||'TrueJump dodial_exit'||lf
faxBUF=faxBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.inbound) FAX"'||lf
faxBUF=faxBUF||'Set localfile "$(faxoutdir)$(remote.address)" faxrc 0'||lf
faxBUF=faxBUF||'RexxMsg SY REXX "return exists(\"$(localfile)\")"'||lf||'Set RC $(result1)'||lf||'FalseJump faxnofile'||lf
faxBUF=faxBUF||'SetStatus $(openstatus)'||lf
faxBUF=faxBUF||'RexxMsg "SY,RY" REXX "options failat 99;Address COMMAND \"$(faxsend)\";return RC"'||lf
faxBUF=faxBUF||'Set faxrc $(result2) tmprc 5'||lf
faxBUF=faxBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Fax Call $(remote.address) returned $(faxrc)"'||lf
faxBUF=faxBUF||'Cmp $(faxrc) 24'||lf||'TrueJump faxexit'||lf||'Set tmprc $(faxrc)'||lf
faxBUF=faxBUF||'faxexit:'||lf||'ReplyCall $(tmprc)'||lf
if ROOFLOG then faxBUF=faxBUF||'RexxMsg FY ROOFLOG "UPDATE_STAT $(faxsout)"'||lf
faxBUF=faxBUF||'Clear tmprc'||lf||'Jump freeline'||lf
faxBUF=faxBUF||'faxnofile:'||lf||'ReplyCall $(tmprc)'||lf
faxBUF=faxBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Call $(remote.address) aborted, nothing to send"'||lf
faxBUF=faxBUF||'Clear tmprc'||lf||'Jump freeline'||lf

faxBUF=faxBUF||'faxanswer:'||lf||'SetStatus $(openstatus)'||lf
faxBUF=faxBUF||'RexxMsg NY LOGPROC "PutLine 'statgroup' $(p.inbound) FAX"'||lf
if gpfax then faxBUF=faxBUF||'RexxMsg SY REXX_GPFAX "'openserial';'fconreceive';'closeserial'"'||lf
else faxBUF=faxBUF||'RexxMsg SY REXX "options failat 99;Address COMMAND \"$(faxrecv)\";return RC"'||lf
faxBUF=faxBUF||'Set faxrc $(result1)'||lf||'ReplyCall 0'||lf
faxBUF=faxBUF||'RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) Inbound Fax session returned $(faxrc)"'||lf
if ROOFLOG then faxBUF=faxBUF||'RexxMsg FY ROOFLOG "UPDATE_STAT $(faxsin)"'||lf
faxBUF=faxBUF||'Jump freeline'||lf
return

