/**/
v="$VER: X  Rexx  Automatic archive detection and extraction          50.00"
packer.     = ""        ; cmd.      = ""
packer.arc  = "pkxarc"  ; cmd.arc   = "-e"
packer.zoo  = "Zoo"     ; cmd.zoo   = "x.//"
packer.lha  = "lha"     ; cmd.lha   = "-x0 -M e"

packer.zip  = "unzip"   ; cmd.zip   = "-xjn "
packer.arj  = "unarj"   ; cmd.arj   = "e"
packer.ape  = "ape"     ; cmd.ape   = "x"

trace background
options failat 10

signal on halt
signal on ioerr
signal on break_c

log=show('P','ROOFLOG')
sv="v"||right(v,5)
script='X'

if arg() = 0 then exit 10

if GetClip('ASYNC') = 'TRUE' then do
wspec = 'RAW:0/10/640/30/ROOF 'script sv'/INACTIVE/AUTO/SCREEN'||GetClip('ASYNCSCREEN')
close('STDOUT');open('STDOUT',wspec,'w')
end
call close 'STDIN';call open 'STDIN','*','R'
parse upper arg file files
PutLog("Scanning "file "spec:"files,10,10)
if ~open('in', file, 'R') then do
PutLog("Can't open" file,10,10)
call cleanup
exit 20
end
buff = readch('in', 8)
call close('in')
select
when left(buff,4) == 'ZOO ' then type = zoo
when left(buff,4) == '$JGE' then type = ape
when substr(buff,3,3) == '-lh' then type = lha
when left(buff,2) == 'PK' then type = zip
when left(buff,2) == '60'x||'EA'x then type = arj
when left(buff,1) == '1A'x then type = arc
otherwise do
PutLog("Cannot handle" file,10,10)
call cleanup
exit 20
end;end

if cmd.type=="" then do
PutLog("Command unknown",10,10)
call cleanup
exit 20
end

PutLog('Un'type'ing' files 'from' file,10,10)
if GetClip('ASYNC') ~= 'TRUE' then address COMMAND packer.type cmd.type file files
else address COMMAND packer.type '>NIL:' cmd.type file files
arcode=RC
call cleanup
exit arcode

PutLog:  procedure expose log script
if arg(3) < GetClip('STATUSLEVEL') then say arg(1)
if arg(2) > GetClip('LOGLEVEL') then return 0
if log then address 'ROOFLOG' 'logline' left(time(),5) script': 'arg(1)
return 0

cleanup:
if GetClip('ASYNC') = 'TRUE' then do
aenum = GetCLip('ASYNCEVENT')
if (aenum <= 1) then call SetCLip('ASYNCEVENT',"")
else do
aenum=aenum-1; call SetCLip('ASYNCEVENT',aenum)
end;end
return 0

/* Error Handling */
halt:
ioerr:
break_c:
call cleanup
exit 10
