##
##   Sample source for a suitable RQUOTES.PMS for use in
##   Pegasus Mail v3.0/WinPmail variable signatures.
##
##   Compile this source using ResCom.exe, by issuing the
##   command "ResCom RQUOTES.R", then copy the resulting
##   RQUOTES.RSC file into your home mailbox as RQUOTES.PMS.
##
##   So, the sequence of commands looks like this:
##
##      C:\PMAIL> rescom rquotes.r
##      C:\PMAIL> copy rquotes.rsc f:\mail\9000001\rquotes.pms
##
##   The general format of this file is a collection of text
##   resources; each text resource is a multiline group of
##   quoted strings, ending with \n wherever you want a line
##   break.
##
##   To activate your variable signature, place the characters
##   ~! in your signature file at the point where you want the
##   substitution to occur.
##
##  I take no responsibility for the contents of this file. I
##  post it only for the convenience of Pegaus users. I URGE
##  you to check each quote in the file before putting it into use.
##
headers off       #  Ignore this command
symbols off       #  Ignore this command.

text x {
"After all is said and done, a lot more has been said than\n",
"done.\n"
}; text x {
"The journey of a thousand miles begins with one step.\n",
"\n",
"Lao-Tsze\n"
}; text x {
"Hindsight is an exact science.\n"
}; text x {
"Be wary of strong drink.\n",
"It can make you shoot at tax collectors, and miss.\n"
}; text x {
"If at first you don't succeed, redefine success.\n"
}; text x {
"If at first you don't succeed, give up, no use being a damn\n",
"fool.\n"
}; text x {
"If at first you don't succeed you're running about average.\n",
"\n",
"M.H. Alderson\n"
}; text x {
"The likelihood of a secret being disclosed\n",
"is proportional to the cube of the number\n",
"of people who know the secret\n"
}; text x {
"Even rats learn from experience.\n",
"\n",
"George Skarbek\n"
}; text x {
"Advertising may be described as the science of arresting the\n",
"human intelligence long enough to get money from it.\n"
}; text x {
"We are all special cases.\n",
"\n",
"Albert Camus\n"
}; text x {
"Man is a social animal who dislikes his fellow beings.\n"
}; text x {
"Money is the root of all evil, and man needs roots.\n"
}; text x {
"Clothes make the man.\n",
"\n",
"Naked people have little or no influence on society.\n",
"\n",
"Mark Twain\n"
}; text x {
"All animals are created equal,\n",
"but some are more equal than others.\n",
"\n",
"George Orwell\n"
}; text x {
"What attracts us in a woman rarely binds us to her.\n",
"\n",
"J.C. Collins\n"
}; text x {
"Luxury is a necessity that begins where necessity ends.\n",
"\n",
"Coco Channel\n"
}; text x {
"It is only when they go wrong that machines remind you how\n",
"powerful they are.\n",
"\n",
"Clive James\n"
}; text x {
"Prophecy is the wit of a fool.\n",
"\n",
"Vladimir Nabokov\n"
}; text x {
"An ounce of emotion is equal to a ton of facts.\n",
"\n",
"John Junor\n"
}; text x {
"There is no force so powerful as an idea whose time has\n",
"come.\n",
"\n",
"Everett Dirkson\n"
}; text x {
"The more times you run over a dead cat, the flatter it gets.\n"
}; text x {
"When I am sad, I sing,\n",
"and then the world is sad with me.\n",
"\n",
"Anon.\n"
}; text x {
"A child of five would understand this.\n",
"Send someone to fetch a child of five.\n",
"\n",
"Groucho Marx\n"
}; text x {
"A component selected at random from a group having 99%\n",
"reliability, will be a member of the 1% group.\n"
}; text x {
"Tolerances will accumulate unidirectionally toward maximum\n",
"difficulty of assembly.\n"
}; text x {
"A circuit protected by a fast acting fuse will protect the\n",
"fuse by blowing first.\n"
}; text x {
"A little help at the right time is better than\n",
"a lot of help at the wrong time.\n",
"\n",
"Teyve\n"
}; text x {
"""Anyone who uses the phrase 'easy as\n",
"taking candy from a baby' has never tried\n",
"taking candy from a baby.""\n"
}; text x {
"""Since prehistoric man, no battle has ever gone as planned.""\n",
"\n",
"D. Graeme\n"
}; text x {
"""A woman, like a good piece of music,\n",
"should have a solid end.""\n",
"\n",
"F. Schubert\n"
}; text x {
"A Woman is like a teabag -- you can't tell how strong she is\n",
"until you put her in hot water.\n",
"\n",
"Nancy Reagan\n"
}; text x {
"I'll worry about it tomorrow.\n",
"\n",
"S. O'Hara\n"
}; text x {
"If John F Kennedy was reading this sentence,\n",
"Lee Harvey Oswald would have missed.\n"
}; text x {
"Although this sentence begins with the word ""because"", it is\n",
"false.\n",
"\n",
"Douglas R Hofstadter\n"
}; text x {
"This line from Shakespeare has delusions of grandeur.\n",
"\n",
"Douglas R Hofstadter\n"
}; text x {
"If writers were bakers, this sentence would be exactly a\n",
"dozen words long.\n",
"\n",
"Douglas R Hofstadter\n"
}; text x {
"The whole point of this sentence is to make clear\n",
"what the whole point of this sentence is.\n",
"\n",
"Douglas R Hofstadter\n",
"If you can keep your head when all about you are losing\n",
"theirs, obviously you have no conception of the magnitude of\n",
"the problem.\n"
}; text x {
"If you can keep your head when all about you are losing\n",
"theirs, you must be at least a foot shorter than them.\n"
}; text x {
"If you can keep your head when all about you are losing\n",
"theirs, you'll be the tallest person in the room.\n"
}; text x {
"If you can keep your head when all about you are losing\n",
"theirs, obviously you must be the headsman.\n"
}; text x {
"""This must be Thursday. I never could get the hang of\n",
"Thursdays.""\n",
"\n",
"Arthur Dent\n"
}; text x {
"I'm sorry, sir, that line is busy till Monday.\n",
"Would you hold please?\n"
}; text x {
"How can they say my life isn't a success?\n",
"\n",
"Have I not for more than sixty years got enough to eat\n",
"and escaped being eaten?\n",
"\n",
"Cindy Adams\n"
}; text x {
"I find that a great part of the information I have was\n",
"acquired by looking up something and finding something else\n",
"on the way.\n",
"\n",
"Franklin P. Adams\n"
}; text x {
"A psychiatrist is a fellow who asks you a lot of expensive\n",
"questions your wife asks for nothing.\n",
"\n",
"Joey Adams\n"
}; text x {
"Be content with your lot; one cannot be first in everything.\n",
"\n",
"Aesop\n"
}; text x {
"The paper burns, but the words fly away.\n",
"\n",
"Ben Joseph Akiba\n"
}; text x {
"Cult: It just means not enough people to make a minority.\n",
"\n",
"Robert Altman\n"
}; text x {
"How can I prove that I'm not crazy to people who are?\n"
}; text x {
"ARE WE HAVING A RELATIONSHIP --\n",
"\n",
"Or just doing research on each other?\n"
}; text x {
"WONDERFUL!\n",
"\n",
"You have some of my favourite problems.\n"
}; text x {
"Our meetings are held\n",
"to discuss many problems\n",
"which would never arise\n",
"if we held fewer meetings.\n"
}; text x {
"I'm not getting paid much for staying alive\n",
"but it's good experience.\n"
}; text x {
"Use your own judgement then do as I say\n"
}; text x {
"Just when I was getting used to yesterday...\n",
"Along came today.\n"
}; text x {
"There's nothing wrong with growing older, but where does it\n",
"lead?\n"
}; text x {
"No wonder I feel so tired -\n",
"I'm older now than I've ever been before.\n"
}; text x {
"It's hard to face tomorrow,\n",
"but it's easier than facing no tomorrow.\n"
}; text x {
"Let's put the blame where it belongs:\n",
"On somebody else.\n"
}; text x {
"If only our great thinkers could learn to talk,\n",
"and our great talkers could learn to think!\n"
}; text x {
"I ALWAYS KNOW THE RIGHT THING TO SAY,\n",
"after the right time to say it has passed.\n"
}; text x {
"HOW CAN I FAIL WHEN I HAVE NO PURPOSE?\n"
}; text x {
"It's hard to remain true to a changing self.\n"
}; text x {
"When I find true wisdom, I'll let you know,\n",
"(if letting you know still seems important.)\n"
}; text x {
"I've learned to accept birth and death...\n",
"but sometimes I still worry about what lies between.\n"
}; text x {
"My life has a superb cast,\n",
"but I can't figure out the plot.\n"
}; text x {
"CAN THIS REALLY BE MY LIFE?\n",
"or has there been some mistake?\n"
}; text x {
"It's easier to see how funny life is\n",
"when somebody else is living it.\n"
}; text x {
"It's easy to come and go...\n",
"The hard thing is to remain.\n"
}; text x {
"History records no more gallant struggle\n",
"than that of humanity against the truth.\n"
}; text x {
"I'm looking for freedom\n",
"- can you direct me?\n"
}; text x {
"Diplomacy is the art of saying ""Nice doggie"" until you can\n",
"find a rock.\n"
}; text x {
"If Karl, instead of writing a lot about capital,\n",
"had made a lot of it ... it would have been much better.\n",
"\n",
"KARL MARX'S MOTHER\n"
}; text x {
"The end move in politics is always to pick up a gun.\n",
"\n",
"BUCKMINSTER FULLER\n"
}; text x {
"Politicians should read science fiction,\n",
"not westerns and detective stories.\n",
"\n",
"ARTHUR C CLARKE\n"
}; text x {
"Ketterling's Law:\n",
"Logic is an organized way of going wrong with confidence.\n"
}; text x {
"God runs electromagnetics by wave theory on Monday,\n",
"Wednesday,and Friday, and the Devil runs them by quantum\n",
"theory on Tuesday,Thursday, and Saturday.\n",
"\n",
"- William Bragg -\n"
}; text x {
"There are things that are so serious that you can only joke\n",
"about them.\n",
"\n",
"- Heisenberg -\n"
}; text x {
"If you don't care where you are, then you ain't lost.\n"
}; text x {
"I wish there was a knob on the TV to turn up the\n",
"intelligence.  There's a knob called ""brightness"", but it\n",
"doesn't work.\n",
"\n",
"Gallagher\n"
}; text x {
"To spot the expert, pick the one who predicts the job will\n",
"take the longest and cost the most.\n",
"\n",
"Warren's Rule\n"
}; text x {
"The trouble with the rat-race is that even if you win\n",
"you'r still a rat.\n",
"\n",
"Lily Tomlin\n"
}; text x {
"Experience - a comb life gives you after you loose your\n",
"hair.\n",
"\n",
"Judith Stern\n"
}; text x {
"A liberal is a person whose inerests aren't at stake,\n",
"at the moment.\n",
"\n",
"Willis Player\n"
}; text x {
"Psychiatry enables us to correct our faults by confessing\n",
"our parents' shortcomings.\n",
"\n",
"Laurence J Peter\n"
}; text x {
"Education is a method whereby one acquires a higher grade of\n",
"prejudices.\n",
"\n",
"Laurence J Peter\n"
}; text x {
"Democracy is a process by which people are free to choose\n",
"the man who will get the blame.\n",
"\n",
"Laurence J Peter\n"
}; text x {
"Bad officials are elected by good citizens who do not vote.\n",
"\n",
"G J Nathan\n"
}; text x {
"Enough research will tend to support your theory\n",
"\n",
"Murphy's Law of Research\n"
}; text x {
"No-one is completely unhappy at the failure of his best\n",
"friend.\n",
"\n",
"Groucho Marx\n"
}; text x {
"Every society honours its live conformists and its dead\n",
"troublemakers.\n",
"\n",
"Mignon Mclaughlin\n"
}; text x {
"When smashing monuments, save the pedestals -\n",
"they always come in handy.\n",
"\n",
"Stanislaw Lec\n"
}; text x {
"When you jump for joy, beware that no-one moves the ground\n",
"from beneath your feet.\n",
"\n",
"Stanislaw Lec\n"
}; text x {
"The telephone is a good way to talk to people without having\n",
"to offer them a drink.\n",
"\n",
"Fran Lebowitz\n"
}; text x {
"The man who smiles when things go wrong has thought of\n",
"someone he can blame it on.\n",
"\n",
"Jones' Law\n"
}; text x {
"Experience enables you to recognise a mistake when you make\n",
"it again.\n",
"\n",
"F P Jones\n"
}; text x {
"It is always good policy to tell the truth unless of course\n",
"you are an exceptionally good liar.\n",
"\n",
"Jerome K Jerome\n"
}; text x {
"Boys will be boys and so will a lot of middle aged men.\n",
"\n",
"Kin Hubbard\n"
}; text x {
"Death is nature's way of telling you to slow down.\n",
"\n",
"Graffiti\n"
}; text x {
"The secret of success is sincerity.\n",
"Once you can fake that you've got it made.\n",
"\n",
"Jean Giraudoux\n"
}; text x {
"Anyone who says he isn't going to resign, four times,\n",
"definitely will.\n",
"\n",
"John Kenneth Galbraith\n"
}; text x {
"For most men life is a search for the proper manilla\n",
"envelope in which to get themselves filed.\n",
"\n",
"Clifton Fadiman\n"
}; text x {
"Rowe's Rule: the odds are five to six that the light at the\n",
"end of the tunnel is the headlight of an oncoming train.\n",
"\n",
"Paul Dickson\n"
}; text x {
"If Presidents don't do it to their wives, they do it to the\n",
"country.\n",
"\n",
"Mel Brooks\n"
}; text x {
"If its good, they'll stop making it.\n",
"\n",
"Herbert Block\n"
}; text x {
"Buy old masters. They fetch a better price than old\n",
"mistresses.\n",
"\n",
"Lord Beaverbrook\n"
}; text x {
"People seem to enjoy things more when they know a lot of\n",
"other people have been left out of the pleasure.\n",
"\n",
"Russell Baker\n"
}; text x {
"When the lay public rallies round to an idea that is\n",
"denounced by distinguised but elderly scientists and supports\n",
"the idea with great fervour and emotion, the distinguised but\n",
"elderly scientists are then, after all, right.\n",
"\n",
"Isaac Asimov\n"
}; text x {
"What passes for optimism is most often the effect of\n",
"intellectual error.\n",
"\n",
"Raymond Aron\n"
}; text x {
"Experience is a good teacher, but she sends in terrific\n",
"bills.\n",
"\n",
"Minna Antrim\n"
}; text x {
"A good family is one that used to better.\n",
"\n",
"Cleveland Amory\n"
}; text x {
"A conference is a gathering of important people who singly\n",
"can do nothing but together can decide that nothing can be\n",
"done.\n",
"\n",
"Fred Allen\n"
}; text x {
"The most popular labour saving device today is still\n",
"a husband with money.\n",
"\n",
"Joey Adams\n"
}; text x {
"Politics, as a practice, whatever its professions, has\n",
"always been the systematic organization of hatreds.\n",
"\n",
"Henry Brooks Adams\n"
}; text x {
"Designed with your mind in mind by people who have in mind\n",
"what you should have in mind.\n"
}; text x {
"WEILER'S LAW: Nothing is impossible for the man who does not\n",
"have to do it himself.\n"
}; text x {
"FINAGLE'S LAW: Once a job is fouled up, anything done to\n",
"improve it makes it worse.\n"
}; text x {
"RUDIN'S LAW: In a crisis that forces a choice to be made\n",
"among alternative courses of action, most people will choose\n",
"the worst one possible.\n"
}; text x {
"UNNAMED LAW: If it happens, it must be possible.\n"
}; text x {
"THE ULTIMATE PRINCIPLE: By definition, when you are\n",
"investigating the unknown - you do not know what you will\n",
"find.\n"
}; text x {
"""One Galileo in two thousand years is enough.""\n",
"\n",
"Pope Pius XII\n"
}; text x {
"""QUIT is a four letter word!""\n",
"- PC-Hack v. 3.05\n"
}; text x {
"It figures. If there is Artificial Intelligence,\n",
"then there's bound to be some artificial stupidity.\n"
}; text x {
"""Just because something doesn't do what\n",
"you planned it to do doesn't mean it's useless.""\n",
"\n",
"-- T. Edison\n"
}; text x {
"Reality is for people who can't cope with drugs.\n"
}; text x {
"Reality is for people who can't cope with fantasy.\n"
}; text x {
"Reality is for people who can't cope with science fiction.\n"
}; text x {
"The way to a man's heart is through his veins.\n"
}; text x {
"Katz' Law:\n",
"Man and nations will act rationally when all other\n",
"possibilities have been exhausted.\n"
}; text x {
"Rule 1: The boss is always right.\n",
"Rule 2: When the boss is wrong, refer to rule 1.\n"
}; text x {
"Cynicism -- the intellectual cripple's substitute for\n",
"intelligence.\n",
"\n",
"Russell Lynes\n"
}; text x {
"If we could sell our experiences for what they cost us, we'd\n",
"all be millionaires.\n",
"\n",
"Abigail Van Buren\n"
}; text x {
"After all is said and done, sit down.\n",
"\n",
"Bill Copeland\n"
}; text x {
"Egotism is the drug that soothes the pain of stupidity.\n"
}; text x {
"A best-seller was a book which somehow sold well simpliy\n",
"because it was selling well.\n",
"\n",
"Daniel Boorstin\n"
}; text x {
"Nobody can be exactly like me. Even I have trouble doing it.\n",
"\n",
"TALLULAH BANKHEAD\n"
}; text x {
"It takes a long time to understand nothing.\n",
"\n",
"EDWARD DAHLBERG\n"
}; text x {
"He who wonders discovers that this in itself is wonder.\n",
"\n",
"M C ESCHER\n"
}; text x {
"The Swartzberg Test:\n",
"The validity of a science is its ability to predict.\n"
}; text x {
"How often I found where I should be going only by\n",
"setting out for somewhere else.\n",
"\n",
"R. Buckminster Fuller\n"
}; text x {
"PARKINSON'S LAW:\n",
"Work expands to fill the time available for its completion.\n"
}; text x {
"The world is full of willing people.\n",
"Some willing to work, the rest willing to let them.\n",
"\n",
"Robert Frost\n"
}; text x {
"Idealism is fine,\n",
"but as it approaches reality the cost becomes prohibitive.\n",
"\n",
"William Buckley.\n"
}; text x {
"No man is rich enough to buy back his past.\n",
"\n",
"Oscar Wilde\n"
}; text x {
"I think age is a very high price to pay for maturity.\n",
"\n",
"Tom Stoppard\n"
}; text x {
"The first step towards knowledge is to know\n",
"that we are ignorant.\n",
"\n",
"Richard Cecil\n"
}; text x {
"You cannot dream yourself into a character;\n",
"you must forge one for yourself.\n",
"\n",
"James Froude.\n"
}; text x {
"Diplomacy ... the art of restraining power.\n",
"\n",
"Henry Kissinger\n"
}; text x {
"The buck stops with the guy who signs the cheques.\n",
"\n",
"Rupert Murdoch\n"
}; text x {
"Strong reasons make strong actions.\n",
"\n",
"Shakespeare\n"
}; text x {
"It isn't what they say about you, it's what they whisper.\n",
"\n",
"Errol Flynn\n"
}; text x {
"Only the winners decide what were war crimes.\n",
"\n",
"Gary Willis\n"
}; text x {
"Genius not only diagnoses the situation but supplies the\n",
"answers.\n",
"\n",
"Robert Graves\n"
}; text x {
"To reform a man, you must begin with his grandmother.\n",
"\n",
"Victor Hugo\n"
}; text x {
"Distance lends enhancement to the view.\n",
"\n",
"Thomas Campbell\n"
}; text x {
"Procrastination is the art of keeping up with yesterday.\n",
"\n",
"Don Marquis\n"
}; text x {
"An ounce of mother is worth a ton of priest.\n",
"\n",
"Proverb\n"
}; text x {
"Nostalgia is a seductive liar.\n",
"\n",
"George Ball\n"
}; text x {
"It often shows a fine command of a language to say nothing.\n"
}; text x {
"An intelligence test often shows how smart one would have\n",
"been not to take it.\n"
}; text x {
"Wealth buys leisure, but not wisdom.\n"
}; text x {
"A short saying contains much wisdom.\n",
"\n",
"Sophocles.\n"
}; text x {
"Amid a multitude of projects, no plan is devised.\n",
"\n",
"Syrus\n"
}; text x {
"I was young and foolish then;\n",
"now I am old and foolisher.\n"
}; text x {
"Women like silent men. They think they're listening.\n",
"\n",
"Marcel Archard\n"
}; text x {
"There is no time like the pleasant.\n",
"\n",
"George Bergman\n"
}; text x {
"Willpower is the ability to eat one salted peanut.\n",
"\n",
"Anon\n"
}; text x {
"The Atomic Age is here to stay - but are we?\n",
"\n",
"Bennet Cerf\n"
}; text x {
"Examine what is said, not who speaks.\n",
"\n",
"Arabian Proverb\n"
}; text x {
"We have too many high sounding words,\n",
"and too few actions that correspond with them.\n",
"\n",
"Abigail Adams\n"
}; text x {
"Chaos often breeds life, when order breeds habit.\n",
"\n",
"Henry B. Adams\n"
}; text x {
"Marriage is give and take.\n",
"You'd better give it to her or she'll take it anyway.\n",
"\n",
"Joey Adams\n"
}; text x {
"Anybody can win, unless there happens to be a second entry.\n",
"\n",
"George Ade\n"
}; text x {
"If it were not for the presents, an elopement would be\n",
"preferable.\n",
"\n",
"George Ade\n"
}; text x {
"An infallible method of conciliating a tiger\n",
"is to allow oneself to be devoured.\n",
"\n",
"Konrad Adenauer\n"
}; text x {
"A house is not a home.\n",
"\n",
"Polly Adler. American madam.\n"
}; text x {
"I don't think my parents liked me.\n",
"They put a live teddy bear in my crib.\n",
"\n",
"Woody Allen\n"
}; text x {
"If the grass is greener in the other fellow's yard -\n",
"let him worry about cutting it.\n",
"\n",
"Fred Allen\n"
}; text x {
"Politicians are the same all over. They promise to build a\n",
"bridge even when there are no rivers.\n",
"\n",
"Nikita Khruschev\n"
}; text x {
"Only God can make random selections.\n"
}; text x {
"Far out in the uncharted backwaters of the unfashionable end\n",
"of the Western Spiral arm of the Galaxy lies a small\n",
"unregarded yellow sun. Orbiting this at a distance of roughly\n",
"ninety-eight million miles is an utterly insignificant little\n",
"blue-green planet whose ape-descended life forms are so\n",
"amazingly primitive that they still think digital watches are\n",
"a pretty neat idea...\n",
"\n",
"Douglas Adams\n",
"\n",
"""The Hitchhiker's Guide to the Galaxy""\n"
}; text x {
"Don't panic!\n",
"\n",
"""The Hitchhiker's Guide to the Galaxy""\n"
}; text x {
"Justice: A decision in your favour.\n"
}; text x {
"The decision is maybe\n",
"and that's final.\n"
}; text x {
"It is generally agreed that ""Hello"" is an appropriate\n",
"greeting because if you entered a room and said ""Goodbye,"" it\n",
"could confuse a lot of people.\n",
"\n",
"-- Dolph Sharp\n"
}; text x {
"Impartial: Unable to perceive any promise of personal\n",
"advantage from espousing either side of a controversy or\n",
"adopting either of two conflicting opinions.\n"
}; text x {
"Bacchus: A convenient deity invented by the ancients as an\n",
"excuse for getting drunk.\n"
}; text x {
"One nice thing about egotists: they don't talk about other\n",
"people.\n"
}; text x {
"Man is the only animal that blushes -- or needs to.\n",
"\n",
"-- Mark Twain\n"
}; text x {
"Ninety-Ninety Rule of Project Schedules:\n",
"The first ninety percent of the task takes ninety percent of\n",
"the time, and the last ten percent takes the other ninety\n",
"percent.\n"
}; text x {
"Love at first sight is one of the greatest labour-saving\n",
"devices the world has ever seen.\n"
}; text x {
"O'Toole's commentary on Murphy's Law:\n",
"""Murphy was an optimist.""\n"
}; text x {
"The three laws of thermodynamics:\n",
"The First Law:\n",
"You can't get anything without working for it.\n",
"The Second Law:\n",
"The most you can accomplish by working is to break even.\n",
"The Third Law:\n",
"You can only break even at absolute zero.\n"
}; text x {
"Some do, some don't.\n",
"Some will, some won't.\n",
"I might.\n"
}; text x {
"Flappity, floppity, flip, The mouse on the mobius strip; The\n",
"strip revolved, The mouse dissolved\n",
"In a chronodimensional skip.\n"
}; text x {
"Don't worry over what other people are thinking about you.\n",
"They're too busy worrying over what you are thinking about\n",
"them.\n"
}; text x {
"According to the latest official figures,\n",
"43% of all statistics are totally worthless.\n"
}; text x {
"To be intoxicated is to feel sophisticated\n",
"but not be able to say it.\n"
}; text x {
"Some people in this department wouldn't recognize subtlety\n",
"if it hit them on the head.\n"
}; text x {
"Cole's Law:\n",
"Thinly sliced cabbage.\n"
}; text x {
"I would rather suffer defeat than have cause to be ashamed\n",
"of victory.\n",
"\n",
"Quintus Curtius\n"
}; text x {
"Dignity is like a top hat.\n",
"Neither is very much use when you are standing on it.\n",
"\n",
"Chistopher Hollis\n"
}; text x {
"Pick battles big enough to matter, small enough to win.\n",
"\n",
"Jonathan Kozol\n"
}; text x {
"If you pay peanuts, you get monkeys.\n",
"\n",
"James Goldsmith\n"
}; text x {
"Silence is better than unmeaning words.\n",
"\n",
"Pythagoras\n"
}; text x {
"The bitterest tears shed over graves are for words left\n",
"unsaid and for deeds left undone.\n",
"\n",
"Harriet Beecher Stowe\n"
}; text x {
"Swipple's Rule of Order:\n",
"\n",
"He who shouts the loudest has the floor.\n"
}; text x {
"Why isn't there a special name for the tops of your feet?\n",
"\n",
"Lily Tomlin\n"
}; text x {
"There are those that say, and those that do.\n",
"\n",
"Andrew Campbell\n"
}; text x {
"""Would you tell me, please, which way I ought to go from\n",
"here?"" ""That depends a good deal on where you want to get\n",
"to,"" said the Cat.\n",
"\n",
"Lewis Carrol\n"
}; text x {
"A student who changes the course of history\n",
"is probably taking an exam.\n"
}; text x {
"Abstainer: A weak person who yields to the temptation of\n",
"denying himself a pleasure.\n"
}; text x {
"Goldenstern's Rules:\n",
"1. Always hire a rich attorney\n",
"2. Never buy from a rich salesman.\n"
}; text x {
"First Rule of History:\n",
"History doesn't repeat itself -- historians merely repeat\n",
"each other.\n"
}; text x {
"Issawi's Laws of Progress:\n",
"The Course of Progress:\n",
"Most things get steadily worse.\n",
"The Path of Progress:\n",
"A shortcut is the longest distance between two points.\n"
}; text x {
"The world is coming to an end!\n",
"Repent and return those library books!\n"
}; text x {
"Fourth Law of Revision:\n",
"It is usually impractical to worry beforehand about\n",
"interferences -- if you have none, someone will make one for\n",
"you.\n"
}; text x {
"Genetics explains why you look like your father, and if you\n",
"don't, why you should.\n"
}; text x {
"""Humour is a drug which it's the fashion to abuse.""\n",
"\n",
"-- William Gilbert\n"
}; text x {
"Pohl's law: Nothing is so good that somebody,\n",
"somewhere, will not hate it.\n"
}; text x {
"Finagle's third Law:\n",
"In any collection of data, the figure most obviously correct,\n",
"beyond all need of checking, is the mistake.\n",
"\n",
"Corollaries:\n",
"1. Nobody whom you ask for help will see it.\n",
"2. The first person who stops by, whose advice you\n",
"   really don't want to hear, will see it immediately.\n"
}; text x {
"Chicken Little was right.\n"
}; text x {
"Air is water with holes in it\n"
}; text x {
"POLITICIAN: From the Greek 'poly' (""many"") and the French\n",
"'tete' (""head"" or ""face,"" as in 'tete-a-tete': head to head\n",
"or face to face).\n",
"\n",
"Hence 'polytetien', a person of two or more faces.\n",
"\n",
"Martin Pitt\n"
}; text x {
"I like work...\n",
"I can sit and watch it for hours.\n"
}; text x {
"Everything should be built top-down, except the first time.\n"
}; text x {
"The Law, in its majestic equality, forbids the rich, as well\n",
"as the poor, to sleep under the bridges,\n",
"to beg in the streets, and to steal bread.\n",
"\n",
"Anatole France\n"
}; text x {
"If you explain so clearly that nobody can misunderstand,\n",
"somebody will.\n"
}; text x {
"Dealing with failure is easy: Work hard to improve. Success\n",
"is also easy to handle: You've solved the wrong problem. Work\n",
"hard to improve.\n"
}; text x {
"After the first death, there is no other.\n",
"\n",
"Dylan Thomas\n"
}; text x {
"Death is all in the mind.\n",
"Once you're dead you forget all about it.\n",
"Jack Storey\n"
}; text x {
"Everybody wants to go to heaven, but nobody wants to die.\n"
}; text x {
"It's not that I'm afraid to die.\n",
"I just don't want to be there when it happens.\n",
"\n",
"-- Woody Allen.\n"
}; text x {
"Suicide stunts your growth.\n",
"\n",
"-- Vila Restal\n"
}; text x {
"Old chemists never die - they just fail to react.\n"
}; text x {
"Frisbeetarianism: The belief that when you die, your soul\n",
"goes up the on roof and gets stuck.\n"
}; text x {
"A cynic is a man who, when he smells\n",
"flowers, looks around for a coffin.\n",
"\n",
"H. L. Mencken\n"
}; text x {
"Dying is a wild night and a new road.\n",
"\n",
"Emily Dickinsom\n"
}; text x {
"The reports of my death are greatly exaggerated.\n",
"\n",
"Mark Twain\n"
}; text x {
"We die only once, and for such a long time.\n",
"\n",
"Moliere\n"
}; text x {
"Life is a great sunrise.\n",
"I do not see why death should not be an even greater one.\n",
"\n",
"Vladimir Nobokov\n"
}; text x {
"If life must not be taken too seriously--\n",
"then so neither must death.\n",
"\n",
"Samuel Butler\n"
}; text x {
"If we don't know life, how can we know death?\n",
"\n",
"Confucius\n"
}; text x {
"Everything comes to him who waits,\n",
"among other things, death.\n",
"\n",
"Francis Bradley\n"
}; text x {
"If I must go into eternity,\n",
"I'd prefer to go by the scenic route.\n"
}; text x {
"Eventually, I hope I'll learn to face death\n",
"- if I live long enough.\n"
}; text x {
"The crash of the whole solar and stellar\n",
"systems could only kill you once.\n",
"\n",
"Thomas Carlyle\n"
}; text x {
"Life is hard and then you die.\n",
"\n",
"-- Record Title\n"
}; text x {
"Do not take life too seriously; you will never get out if\n",
"it alive.\n"
}; text x {
"Death is Nature's way of recycling human beings.\n"
}; text x {
"People will buy anything that's one to a customer.\n"
}; text x {
"""I just need enough to tide me over until I need more.""\n",
"\n",
"Bill Hoest\n"
}; text x {
"Whenever people agree with me I always feel I must be wrong.\n",
"\n",
"Oscar Wilde\n"
}; text x {
"Every solution breeds new problems.\n"
}; text x {
"Law of the Perversity of Nature:\n",
"You cannot successfully determine beforehand which side of\n",
"the bread to butter.\n"
}; text x {
"A diplomat is a man who can convince his wife she'd look\n",
"stout in a fur coat.\n"
}; text x {
"Anything is good if it's made of chocolate.\n"
}; text x {
"You couldn't even prove the White House staff sane beyond a\n",
"reasonable doubt.\n",
"\n",
"Ed Meese, on the Hinckley verdict\n"
}; text x {
"What makes the universe so hard to comprehend is that\n",
"there's nothing to compare it with.\n"
}; text x {
"Corrupt: In politics, holding an office of trust or profit.\n"
}; text x {
"You can't judge a book by the way it wears its hair.\n"
}; text x {
"""She is descended from a long line that her mother listened\n",
"to.""\n",
"\n",
"-- Gypsy Rose Lee\n"
}; text x {
"Do not drink coffee in early A.M.\n",
"It will keep you awake until noon.\n"
}; text x {
"Meskimen's Law:\n",
"There's never time to do it right,\n",
"but there's always time to do it over.\n"
}; text x {
"Only adults have difficulty with childproof caps.\n"
}; text x {
"""All my friends and I are crazy.\n",
"That's the only thing that keeps us sane.""\n"
}; text x {
"Necessity is a mother.\n"
}; text x {
"Life was not meant to be easy.\n",
"\n",
"Malcom Fraser\n"
}; text x {
"Mitchell's Law of Committees:\n",
"Any simple problem can be made insoluble if enough meetings\n",
"are held to discuss it.\n"
}; text x {
"The best thing about growing older is that it takes such a\n",
"long time.\n"
}; text x {
"A real person has two reasons for doing anything...\n",
"a good reason and the real reason.\n"
}; text x {
"The cost of living is going up,\n",
"and the chance of living is going down.\n"
}; text x {
"Velilind's Laws of Experimentation:\n",
"1. If reproducibility may be a problem, conduct the test only\n",
"once.\n",
"2. If a straight line fit is required, obtain only two\n",
"data points.\n"
}; text x {
"""One planet is all you get.""\n"
}; text x {
"Ink: A villainous compound of tannogallate of iron, gum-\n",
"arabic, and water, chiefly used to facilitate the infection\n",
"of idiocy and promote intellectual crime.\n"
}; text x {
"""If you have to hate, hate gently""\n"
}; text x {
"Don't tell any big lies today. Small ones can be just as\n",
"effective.\n"
}; text x {
"Birth: The first and direst of all disasters.\n"
}; text x {
"Peter's Law of Substitution:\n",
"Look after the molehills, and the mountains will look after\n",
"themselves.\n"
}; text x {
"What the hell, go ahead and put all your eggs in one basket.\n"
}; text x {
"NAPOLEON: What shall we do with this soldier, Guiseppe?\n",
"Everything he says is wrong.\n",
"GUISEPPE: Make him a general, Excellency, and then everything\n",
"he says will be right.\n",
"\n",
"G. B. Shaw\n"
}; text x {
"""He was so narrow minded he could see through a keyhole with\n",
"both eyes...""\n"
}; text x {
"A penny saved is ridiculous.\n"
}; text x {
"Harvard Law:\n",
"Under the most rigorously controlled conditions of\n",
"pressure, temperature, volume, humidity, and other\n",
"variables, the organism will do as it damn well pleases.\n"
}; text x {
"Ginsberg's Theorem:\n",
"1. You can't win.\n",
"2. You can't break even.\n",
"3. You can't even quit the game....\n",
"\n",
"Freeman's Commentary on Ginsberg's theorem:\n",
"Every major philosophy that attempts to make life seem\n",
"meaningful is based on the negation of one part of Ginsberg's\n",
"Theorem. To wit:\n",
"1. Capitalism is based on the assumption that you can win.\n",
"2. Socialism is based on the assumption that you can break\n",
"even.\n",
"3. Mysticism is based on the assumption that you can quit the\n",
"game.\n"
}; text x {
"I can't complain, but sometimes I still do.\n"
}; text x {
"Paul's Law:\n",
"You can't fall off the floor.\n"
}; text x {
"Don't order a drink for the road,\n",
"because the road is already laid out.\n",
"\n",
"Flip Wilson\n"
}; text x {
"Don't let your mouth write no check that your tail can't\n",
"cash.\n",
"\n",
"BO DIDDLEY\n"
}; text x {
"The opposite of a correct statement is a false statement.\n",
"But the opposite of a profound truth may well be another\n",
"profound truth.\n",
"\n",
"NIELS BOHR\n"
}; text x {
"Just because everything is different doesn't mean anything\n",
"has changed.\n",
"\n",
"SOUTHERN CALIFORNIA ORACLE\n"
}; text x {
"Discovery consists in seeing what everyone else has seen and\n",
"thinking what no one else has thought.\n",
"\n",
"- Albert Szent-Gyorgi -\n"
}; text x {
"It is impossible to make anything foolproof because fools\n",
"are so ingenious.\n",
"\n",
"Edsel Murphy, dec.\n"
}; text x {
"Fantasy, abandoned by reason, produces impossible monsters;\n",
"united with it, she is the mother of the arts and the origin\n",
"of marvels.\n",
"\n",
"- Goya -\n"
}; text x {
"Some people like my advice so much that they frame it upon\n",
"the wall instead of using it.\n",
"\n",
"- Gordon R. Dickson -\n"
}; text x {
"Civilization is a movement, not a condition;\n",
"it is a voyage, not a harbor.\n",
"\n",
"- Toynbee -\n"
}; text x {
"Take what you can use and let the rest go by.\n",
"\n",
"KEN KESEY\n"
}; text x {
"The first sign of a nervous breakdown is when you start\n",
"thinking your work is terribly important.\n",
"\n",
"Milo Bloom\n"
}; text x {
"When choosing between two evils I always like to take the\n",
"one I've never tried before.\n",
"\n",
"MAE WEST\n"
}; text x {
"It's not whether you win or lose,\n",
"it's how good you look playing!\n",
"\n",
"David Lee Roth\n"
}; text x {
"College isn't the place to go for ideas.\n",
"\n",
"HELLEN KELLER\n"
}; text x {
"It is necessary for me to establish a winner image.\n",
"Therefore, I have to beat somebody.\n",
"\n",
"RICHARD M NIXON\n"
}; text x {
"The important thing is not to stop questioning. Curiosity\n",
"has its own reason for existing.\n",
"\n",
"Albert Einstein\n"
}; text x {
"Any smoothly functioning technology will have the appearance\n",
"of magic.\n",
"\n",
"ARTHUR C CLARKE\n"
}; text x {
"You can't underestimate the power of fear.\n",
"\n",
"TRICIA NIXON\n"
}; text x {
"Military intelligence is a contradiction in terms.\n",
"\n",
"GROUCHO MARX\n"
}; text x {
"Here I am, fifty-eight, and I still don't know what I want\n",
"to be when I grow up.\n",
"\n",
"PETER DRUCKER\n"
}; text x {
"Anyone can hate. It costs to love.\n",
"\n",
"JOHN WILLIAMSON\n"
}; text x {
"The expert is a person who avoids the small errors as he\n",
"sweeps on to the grand fallacy.\n",
"\n",
"Anonymous\n"
}; text x {
"We are what we pretend to be.\n",
"\n",
"KURT VONNEGUT, JR\n"
}; text x {
"We are all in the gutter, but some of us are looking at the\n",
"stars.\n",
"\n",
"OSCAR WILDE\n"
}; text x {
"The race is not always to the swift, nor the battle to the\n",
"strong -but thats the way to bet.\n",
"\n",
"DAMON RUNYON\n"
}; text x {
"Time is an illusion perpetrated by the manufacturers of\n",
"space.\n",
"\n",
"GRAFFITI\n"
}; text x {
"The most incomprehensible thing about the world is\n",
"that it is comprehensible.\n",
"\n",
"ALBERT EINSTEIN\n"
}; text x {
"I either want less corruption, or more chance to participate\n",
"in it.\n"
}; text x {
"If you can't learn to do it well, learn to enjoy doing it\n",
"badly.\n"
}; text x {
"I don't have any solution, but I certainly admire the\n",
"problem.\n"
}; text x {
"Maybe I'm lucky to be going so slowly,\n",
"because I may be going in the wrong direction.\n"
}; text x {
"By doing just a little every day, I can gradually let the\n",
"task completely overwhelm me.\n"
}; text x {
"To be sure of hitting the target, shoot first,\n",
"and call whatever you hit the target.\n"
}; text x {
"America is the only country that went from barbarism to\n",
"decadence without civilization in between.\n",
"\n",
"OSCAR WILDE\n"
}; text x {
"America may be unique in being a country which has leapt\n",
"from barbarism to decadence without touching civilization.\n",
"\n",
"John O'Hara\n"
}; text x {
"Try to be the best of what you are, even if what you are is\n",
"no good.\n"
}; text x {
"A ship on the beach is a lighthouse to the sea.\n",
"\n",
"Dutch proverb\n"
}; text x {
"If the aborigine drafted an IQ test, all of Western\n",
"civilization would presumably flunk it.\n",
"\n",
"STANLEY GARN\n"
}; text x {
"We are going to have peace even if we have to fight for it.\n",
"\n",
"DWIGHT D EISENHOWER\n"
}; text x {
"Law of Computability Applied to Social Sciences:\n",
"If at first you don't succeed, transform your data set.\n"
}; text x {
"The first rule of intelligent tinkering is to save all the\n",
"parts.\n",
"\n",
"PAUL ERLICH\n"
}; text x {
"Frouds Law:\n",
"A transistor protected by a fast acting fuse will protect the\n",
"fuse by blowing first.\n"
}; text x {
"Under any conditions, anywhere, whatever you are doing,\n",
"there is some ordinance under which you can be booked.\n",
"\n",
"ROBERT D SPRECHT (RAND CORP)\n"
}; text x {
"Thoreau's Law:\n",
"\n",
"If you see a man approaching you with the obvious intent of\n",
"doing you good, you should run for your life.\n"
}; text x {
"Vique's Law:\n",
"\n",
"A man without religion is like a fish without a bicycle.\n"
}; text x {
"Zimmerman's Law of Complaints:\n",
"\n",
"Nobody notices when things go right.\n"
}; text x {
"Real knowledge is to know the extent of one's ignorance.\n",
"\n",
"CONFUCIUS\n"
}; text x {
"It usually takes more than three weeks to prepare a good\n",
"impromptu speech.\n",
"\n",
"MARK TWAIN\n"
}; text x {
"I used to be indecisive; now I'm not sure.\n",
"\n",
"GRAFFITI\n"
}; text x {
"'Martyrdom' is the only way a person can become famous\n",
"without ability.\n",
"\n",
"- George Bernard Shaw -\n"
}; text x {
"Birth, Copulation, and Death. That's all the facts when you\n",
"come to brass tacks.\n",
"\n",
"T. S. Elliot\n"
}; text x {
"In every country and every age,\n",
"the priest has been hostile to Liberty.\n",
"\n",
"- Thomas Jefferson -\n"
}; text x {
"Money, not morality, is the principle commerce of civilized\n",
"nations.\n",
"\n",
"- Thomas Jefferson -\n"
}; text x {
"You don't have to explain something you never said.\n",
"\n",
"- Calvin Coolidge -\n"
}; text x {
"I hear and I forget.\n",
"I see and I remember.\n",
"I do and I understand.\n",
"\n",
"Confucius\n"
}; text x {
"History repeats itself. That's one thing wrong with history.\n"
}; text x {
"X-rated movies are all alike...the only thing they leave to\n",
"the imagination is the plot.\n"
}; text x {
"Never be led astray onto the path of virtue.\n"
}; text x {
"The trouble with being punctual is that people think you\n",
"have nothing more important to do.\n"
}; text x {
"Horngren's Observation:\n",
"\n",
"Among economists, the real world is often a special case.\n"
}; text x {
"Things are more like they used to be than they are now.\n"
}; text x {
"Major Premise: Sixty men can do a piece of work sixty times\n",
"as quickly as one man.\n",
"Minor Premise: One man can dig a posthole in sixty seconds;\n",
"Conclusion: Sixty men can dig a posthole in one second.\n"
}; text x {
"A baby is an alimentary canal with a loud voice at one end\n",
"and no responsibility at the other.\n"
}; text x {
"Reporter (to Mahatma Gandhi): Mr Gandhi, what do you think\n",
"of Western Civilization?\n",
"Gandhi: I think it would be a good idea.\n"
}; text x {
"It is easier to get forgiveness than permission.\n"
}; text x {
"Left to themselves, things tend to go from bad to worse.\n"
}; text x {
"""He's just a politician trying to save both his faces...""\n"
}; text x {
"In Dr. Johnson's famous dictionary patriotism is defined as\n",
"the last resort of the scoundrel. With all due respect to an\n",
"enlightened but inferior lexicographer I beg to submit that\n",
"it is the first. -- Ambrose Bierce\n"
}; text x {
"Due to a shortage of devoted followers, the production of\n",
"great leaders has been discontinued.\n"
}; text x {
"Alliance: In international politics, the union of two\n",
"thieves who have their hands so deeply inserted in each\n",
"other's pocket that they cannot separately plunder a third.\n"
}; text x {
"Conversation: A vocal competition in which the one who is\n",
"catching his breath is called the listener.\n"
}; text x {
"Anthony's Law of Force:\n",
"Don't force it; get a larger hammer.\n"
}; text x {
"Hatred:\n",
"A sentiment appropriate to the occasion of another's\n",
"superiority.\n"
}; text x {
"Rudin's Law:\n",
"If there is a wrong way to do something,\n",
"most people will do it every time.\n"
}; text x {
"Hacker's Law:\n",
"The belief that enhanced understanding will necessarily stir\n",
"a nation to action is one of mankind's oldest illusions.\n"
}; text x {
"Murphy's Law is recursive.\n",
"\n",
"Washing your car to make it rain doesn't work.\n"
}; text x {
"Absentee: A person with an income who has had the\n",
"forethought to remove himself from the sphere of exaction.\n"
}; text x {
"Happiness: An agreeable sensation arising from contemplating\n",
"the misery of another.\n"
}; text x {
"Armadillo: to provide weapons to a Spanish pickle.\n"
}; text x {
"It is one of the superstitions of the human mind to have\n",
"imagined that virginity could be a virtue.\n",
"\n",
"Voltaire\n"
}; text x {
"Oh don't the days seem lank and long\n",
"When all goes right and none goes wrong,\n",
"And isn't your life extremely flat\n",
"With nothing whatever to grumble at!\n"
}; text x {
"First Law of Bicycling:\n",
"No matter which way you ride, it's uphill and against the\n",
"wind.\n"
}; text x {
"Certainly there are things in life that money can't buy, but\n",
"it's very funny -- Did you ever try buying then without\n",
"money?\n",
"\n",
"Ogden Nash\n"
}; text x {
"Where there's a will, there's an Inheritance Tax.\n"
}; text x {
"Democracy is a form of government in which it is permitted\n",
"to wonder aloud what the country could do under first-class\n",
"management.\n",
"\n",
"Senator Soaper\n"
}; text x {
"Lie: A very poor substitute for the truth, but the only one\n",
"discovered to date.\n"
}; text x {
"If you wants to get elected president, you've got to think\n",
"up some memorable homily so's school kids can be pestered\n",
"into memorizin' it, even if they don't know what it means.\n",
"\n",
"Walt Kelly\n"
}; text x {
"There's no point in being grown up if you can't be childish\n",
"sometimes.\n",
"\n",
"Dr. Who\n"
}; text x {
"Bumper sticker: ""All the parts falling off this car are of\n",
"the very finest British manufacture""\n"
}; text x {
"Enzymes are things invented by biologists that explain\n",
"things which otherwise require harder thinking.\n",
"\n",
"Jerome Lettvin\n"
}; text x {
"The Kennedy Constant:\n",
"\n",
"Don't get mad -- get even.\n"
}; text x {
"A diplomat is someone who can tell you to go to hell in such\n",
"a way that you will look forward to the trip.\n"
}; text x {
"I'd rather have a bottle in front of me than a frontal\n",
"lobotomy.\n"
}; text x {
"It is the business of the future to be dangerous.\n",
"\n",
"Hawkwind\n"
}; text x {
"Lysistrata had a good idea.\n"
}; text x {
"Parker's Law:\n",
"\n",
"Beauty is only skin deep, but ugly goes clean to the bone.\n"
}; text x {
"As the trials of life continue to take their toll, remember\n",
"that there is always a future in Computer Maintenance.\n"
}; text x {
"Fairy Tale: A horror story to prepare children for the\n",
"newspapers.\n"
}; text x {
"Down with categorical imperative!\n"
}; text x {
"As far as the laws of mathematics refer to reality, they are\n",
"not certain; and as far as they are certain, they do not\n",
"refer to reality.\n",
"\n",
"Albert Einstein\n"
}; text x {
"Maybe you can't buy happiness, but these days you can\n",
"certainly charge it.\n"
}; text x {
"DeVries' Dilemma:\n",
"\n",
"If you hit two keys on the typewriter, the one you don't want\n",
"hits the paper.\n"
}; text x {
"$100 invested at 7% interest for 100 years will become\n",
"$100,000, at which time it will be worth absolutely nothing.\n"
}; text x {
"Anybody who doesn't cut his speed at the sight of a police\n",
"car is probably parked.\n"
}; text x {
"There are three kinds of lies: Lies, Damn Lies, and\n",
"Statistics.\n",
"\n",
"Disraeli\n"
}; text x {
"Majority: That quality that distinguishes a crime from a\n",
"law.\n"
}; text x {
"H. L. Mencken's Law:\n",
"Those who can -- do.\n",
"Those who can't -- teach.\n",
"\n",
"Martin's Extension:\n",
"Those who cannot teach -- administrate.\n"
}; text x {
"Shaw's Principle:\n",
"Build a system that even a fool can use, and only a fool\n",
"will want to use it.\n"
}; text x {
"A well adjusted person is one who makes the same mistake\n",
"twice without getting nervous.\n"
}; text x {
"A real patriot is the fellow who gets a parking ticket and\n",
"rejoices that the system works.\n"
}; text x {
"There is a theory which states that if ever anyone discovers\n",
"exactly what the Universe is for and why it is here, it will\n",
"instantly disappear and be replaced by something even more\n",
"bizarre and inexplicable.\n",
"\n",
"There is another theory which states that this has already\n",
"happened.\n",
"\n",
"The Hitchhiker's Guide to the Galaxy\n"
}; text x {
"The generation of random numbers is too important to be left\n",
"to chance.\n",
"\n",
"Robert R. Coveyou\n",
"Oak Ridge National Laboratory\n"
}; text x {
"There's a fine line between courage and foolishness.\n",
"Too bad its not a fence.\n"
}; text x {
"""The warning message we sent the Russians was a calculated\n",
"ambiguity that would be clearly understood.""\n",
"\n",
"Alexander Haig\n"
}; text x {
"Lackland's Laws:\n",
"1. Never be first.\n",
"2. Never be last.\n",
"3. Never volunteer for anything\n"
}; text x {
"Coward: One who in a perilous emergency thinks with his\n",
"legs.\n"
}; text x {
"Sometimes I worry about being a success in a mediocre world.\n"
}; text x {
"Human beings were created by water to transport it uphill.\n"
}; text x {
"SEMINARS: From 'semi' and 'arse', hence, any half-assed\n",
"discussion.\n"
}; text x {
"Don't believe everything you hear or anything you say.\n"
}; text x {
"Marriage is the only adventure open to the cowardly.\n",
"\n",
"Voltaire\n"
}; text x {
"You worry too much about your job. Stop it.\n",
"You are not paid enough to worry.\n"
}; text x {
"Incumbent: Person of liveliest interest to the outcumbents.\n"
}; text x {
"One can't proceed from the informal to the formal by formal\n",
"means.\n"
}; text x {
"He is now rising from affluence to poverty.\n",
"\n",
"Mark Twain\n"
}; text x {
"Malek's Law:\n",
"Any simple idea will be worded in the most complicated way.\n"
}; text x {
"If you pick up a starving dog and make him prosperous, he\n",
"will not bite you. This is the principal difference between\n",
"a dog and a man.\n",
"\n",
"Mark Twain\n"
}; text x {
"Always borrow money from a pessimist; he doesn't expect to\n",
"be paid back.\n"
}; text x {
"There has been an alarming increase in the number of things\n",
"you know nothing about.\n"
}; text x {
"The human animal differs from the lesser primates in his\n",
"passion for lists of ""Ten Best"".\n",
"\n",
"H. Allen Smith\n"
}; text x {
"Afternoon: That part of the day we spend worrying about how\n",
"we wasted the morning.\n"
}; text x {
"One difference between a man and a machine is that a machine\n",
"is quiet when well oiled.\n"
}; text x {
"Maturity is only a short break in adolescence.\n",
"\n",
"Jules Feiffer\n"
}; text x {
"Anarchy may not be the best form of government, but it's\n",
"better than no government at all.\n"
}; text x {
"Adult: One old enough to know better.\n"
}; text x {
"Oliver's Law:\n",
"Experience is something you don't get until just after you\n",
"need it.\n"
}; text x {
"Hanlon's Razor:\n",
"Never attribute to malice\n",
"that which is adequately explained by stupidity.\n"
}; text x {
"The Roman Rule\n",
"The one who says it cannot be done should never interrupt\n",
"the one who is doing it.\n"
}; text x {
"We are confronted with insurmountable opportunities.\n",
"\n",
"Pogo\n"
}; text x {
"The goal of science is to build better mousetraps.\n",
"The goal of nature is to build better mice.\n"
}; text x {
"The number of licorice gumballs you get out of a gumball\n",
"machine increases in direct proportion to how much you hate\n",
"licorice.\n"
}; text x {
"When you are in it up to your ears, keep your mouth shut.\n"
}; text x {
"Cabbage: A familiar kitchen-garden vegetable about as large\n",
"and wise as a man's head.\n"
}; text x {
"Nothing astonishes men so much as common sense and plain\n",
"dealing.\n"
}; text x {
"Man is a rational animal who always loses his temper when he\n",
"is called upon to act in accordance with the dictates of\n",
"reason.\n",
"\n",
"Oscar Wilde\n"
}; text x {
"Arithmetic is being able to count up to twenty without\n",
"taking off your shoes.\n",
"\n",
"Mickey Mouse\n"
}; text x {
"Passionate hatred can give meaning and purpose to an empty\n",
"life.\n",
"\n",
"Eric Hoffer\n"
}; text x {
"Quia Costodiet Ipsos Custodes.\n",
"(Who will watch the Guardians)\n"
}; text x {
"Hanging is too good for a man who makes puns...\n",
"He should be drawn and quoted!\n"
}; text x {
"When one does not know what to say, it is a time to be\n",
"silent.\n"
}; text x {
"When I am right nobody remembers...\n",
"When I am wrong nobody forgets!\n"
}; text x {
"If you can't tie good knots... tie many.\n"
}; text x {
"A lack of planning on your part\n",
"does not constitute an emergency on my part.\n"
}; text x {
"Your not knowing a mans purpose\n",
"does not mean he is confused.\n"
}; text x {
"What you can not avoid, Welcome.\n"
}; text x {
"Think much, Speak little, Write less.\n"
}; text x {
"Listening gives wisdom, Speaking gives repentance.\n"
}; text x {
"Yesterday is a dream,\n",
"Tomorrow is a vision,\n",
"Today is a bitch.\n"
}; text x {
"Failure teaches success.\n"
}; text x {
"It is better to keep your mouth closed\n",
"and let people think you are a fool\n",
"Than to open it an remove all doubt.\n",
"\n",
"Samual Clemmens\n"
}; text x {
"Give him a fish, he eats today\n",
"teach him to fish, he eats for the rest of his life.\n"
}; text x {
"Money wouldn't be so important if everybody didn't want some\n"
}; text x {
"Murphys Law: If something can go wrong...\n",
"It will, and at the worst possible time.\n"
}; text x {
"TO DO IS TO BE\n",
"Socrates\n",
"TO BE IS TO DO\n",
"Sartre\n",
"DO BE DO BE DO\n",
"Sinatra\n"
}; text x {
"Walk softly but carry a big stick.\n"
}; text x {
"God may give you seeds but he won't plant them for you.\n"
}; text x {
"When I rest, I rust.\n"
}; text x {
"A Wise Man can see more from the bottom of a well\n",
"than a Fool can see from the top of a mountain.\n"
}; text x {
"If they throw lemons, Make lemonade.\n"
}; text x {
"Money is round and rolls away.\n"
}; text x {
"Revenge is a dish best served cold - Klingon\n"
}; text x {
"Fool me once, shame on you\n",
"Fool me twice, shame on me!\n"
}; text x {
"Moderate riches will carry you..\n",
"if you have more, you must carry them.\n"
}; text x {
"Don't insult the alligator until after you have crossed\n",
"the river.\n"
}; text x {
"Remember when you point a finger\n",
"Three fingers are pointing at you.\n"
}; text x {
"If you do not wish a thing heard, do not say it. \n",
"\n",
"Klingon\n"
}; text x {
"Too many cookies will make you fat!!!\n"
}; text x {
"... The beginning of knowledge is the discovery\n",
"of something we do not understand ...\n",
"\n",
"Frank Herbert\n"
}; text x {
"Invention is the mother of necessity.\n"
}; text x {
"In nature there are neither rewards.\n",
"nor punishments -- there are consequences.\n",
"\n",
"Robert G.Ingersoll\n"
}; text x {
"We have met the enemy, and he is us.\n",
"\n",
"Walt Kelly\n"
}; text x {
"Sloppy, raggedy-assed old life.\n",
"I love it. I never want to die.\n",
"\n",
"Dennis Trudell\n"
}; text x {
"The wind and waves are always on the side of the ablest\n",
"navigators.\n",
"\n",
"Edward Gibbon\n"
}; text x {
"The biggest things are always the easiest\n",
"to do because there is no competition.\n",
"\n",
"William Van Horne\n"
}; text x {
"Only those who dare to fail greatly can ever achieve\n",
"greatly.\n",
"\n",
"Robert F. Kennedy\n"
}; text x {
"Back of every achievement is a proud wife,\n",
"and a surprised mother-in-law.\n",
"\n",
"Brooks Hays\n"
}; text x {
"Noise proves nothing. Often a hen who has\n",
"merely laid an egg cackles as if she had laid an asteroid.\n",
"\n",
"Mark Twain\n"
}; text x {
"We judge ourselves by what we feel capable\n",
"of doing, while others judge us by what we have done.\n",
"\n",
"Henry Wadsworth Longfellow\n"
}; text x {
"Do what you can, with what you have, where you are.\n",
"\n",
"Theodore Roosevelt\n"
}; text x {
"He has half the deed done who has made a beginning.\n",
"\n",
"Horace\n"
}; text x {
"The only way round is through.\n",
"\n",
"Robert Frost\n"
}; text x {
"Is there anything in life so disenchanting as attainment?\n",
"\n",
"Robert Louis Stevenson\n"
}; text x {
"I'm a slow walker, but I never walk back.\n",
"\n",
"Abraham Lincoln\n"
}; text x {
"We promise according to our hopes and perform according to\n",
"our fears.\n",
"\n",
"La Rochefoucald\n"
}; text x {
"For a man to achieve all that is demanded\n",
"of him he must regard himself as greater than he is.\n",
"\n",
"Johann von Goethe\n"
}; text x {
"He that leaveth nothing to Chance will do\n",
"few things ill, but he will do very few things.\n",
"\n",
"George, Lord Halifax\n"
}; text x {
"When spider webs unite, they can tie up a lion.\n",
"\n",
"Ethiopian proverb\n"
}; text x {
"Everyone must row with the oars he has.\n",
"\n",
"English proverb\n"
}; text x {
"God gives the nuts, but he does not crack them.\n",
"\n",
"German proverb\n"
}; text x {
"The world is all gates, all opportunities,\n",
"strings of tension waiting to be struck.\n",
"\n",
"Ralph Waldo Emerson\n"
}; text x {
"Don't be afraid to take a big step if one is indicated. You\n",
"can't cross a chasm in two small jumps.\n",
"\n",
"David Lloyd George\n"
}; text x {
"There is nothing so useless as doing efficiently that\n",
"which should not be done at all.\n",
"\n",
"Peter F. Drucker\n"
}; text x {
"The reward of a thing well done, is to have done it.\n",
"\n",
"Ralph Waldo Emerson\n"
}; text x {
"He who desires, but acts not, breeds pestilence.\n",
"\n",
"William Blake\n"
}; text x {
"Do not show your wounded finger, for\n",
"everything will knock up against it.\n",
"\n",
"Baltasar Gracian\n"
}; text x {
"Trouble is only an opportunity in work clothes.\n",
"\n",
"Henry J. Kaiser\n"
}; text x {
"The man who is swimming against the\n",
"stream knows the strength of it.\n",
"\n",
"Woodrow Wilson\n"
}; text x {
"The ultimate measure of a man is not where he stands in\n",
"moments of comfort and convenience, but where he stands at\n",
"times of challenge and controversy.\n",
"\n",
"Martin Luther King, Jr.\n"
}; text x {
"What does not destroy me,\n",
"makes me strong.\n",
"\n",
"Friedrich Nietzsche\n"
}; text x {
"From a fallen tree, all make kindling.\n",
"\n",
"Spanish proverb\n"
}; text x {
"They say a reasonable amount o' fleas is good for a dog --\n",
"keeps him from broodin' over bein' a dog mebbe.\n",
"\n",
"Edward Noyes Westcott\n"
}; text x {
"The burden is equal to the horses strength.\n",
"\n",
"The Talmud\n"
}; text x {
"Nothing befalls a man except what is in his nature to\n",
"endure.\n",
"\n",
"Marcus Aurelius\n"
}; text x {
"Prosperity tries the fortunate: adversity the great.\n",
"\n",
"Pliny the Younger\n"
}; text x {
"Forty is the old age of youth; fifty is the youth of old\n",
"age.\n",
"\n",
"Victor Hugo\n"
}; text x {
"Middle age is youth without it's levity. And old age without\n",
"decay.\n",
"\n",
"Daniel Defoe\n"
}; text x {
"First you forget names, then you forget\n",
"faces, then you forget to pull your\n",
"zipper up, then you forget to pull your\n",
"zipper down.\n",
"\n",
"Leo Rosenberg\n"
}; text x {
"What makes old age so sad is not that\n",
"our joys but our hopes cease.\n",
"\n",
"Jean Paul Richter\n"
}; text x {
"Old age is not so bad when you consider the alternatives.\n",
"\n",
"Maurice Chevalier\n"
}; text x {
"Anxiety is the dizziness of freedom.\n",
"\n",
"Soren Kierkegaard\n"
}; text x {
"Anxiety is interest paid on trouble before it is due.\n",
"\n",
"Dean Inge\n"
}; text x {
"Anxiety is fear of one's self.\n",
"\n",
"Wilhelm Stekel\n"
}; text x {
"Anxiety is a thin stream of fear trickling\n",
"through the mind.  If encouraged, it cuts\n",
"a channel into which all other thoughts are drained.\n",
"\n",
"Arthur Somers Roche\n"
}; text x {
"I learned long ago, never to wrestle with a\n",
"pig. You get dirty, and besides, the pig likes it.\n",
"\n",
"George Bernard Shaw\n"
}; text x {
"Grace is the absence of everything that\n",
"indicates pain or difficulty, hesitation\n",
"or incongruity.\n",
"\n",
"William Hazlitt\n"
}; text x {
"Though we travel the world over to find the beautiful, we\n",
"must carry it with us or we find it not.\n",
"\n",
"Ralph Waldo Emerson\n"
}; text x {
"Beauty is everlasting, And dust is for a time.\n",
"\n",
"Marianne Moore\n"
}; text x {
"There is no excellent beauty that hath not\n",
"some strangeness in the proportion.\n",
"\n",
"Francis Bacon\n"
}; text x {
"A book is a mirror: if an ass peers into it,\n",
"you can't expect an apostle to look out.\n",
"\n",
"G. C. Lichtenberg\n"
}; text x {
"Some people can stay longer in an hour than others can in a\n",
"week.\n",
"\n",
"William Dean Howells\n"
}; text x {
"A bore is a man who, when you ask him how he is, tells you.\n",
"\n",
"Bert Leston Taylor\n"
}; text x {
"A bore is a man who deprives you of solitude\n",
"without providing you with company.\n",
"\n",
"Gian Vincenzo Gravina\n"
}; text x {
"Uncertainty and mystery are energies of\n",
"life. Don't let them scare you unduly,\n",
"for they keep boredom at bay and spark creativity.\n",
"\n",
"R. I. Fitzhenry\n"
}; text x {
"A holding company is the people you give\n",
"your money to while you're being searched.\n",
"\n",
"Will Rogers\n"
}; text x {
"A company is judged by the president it keeps.\n",
"\n",
"James Hulbert\n"
}; text x {
"The harder you work, the luckier you get.\n",
"\n",
"Gary Player\n"
}; text x {
"Chance is always powerful. Let your hook\n",
"be always cast.  In the pool where you\n",
"least expect it, will be a fish.\n",
"\n",
"Ovid\n"
}; text x {
"I see gr-reat changes takin' place ivry day,\n",
"but no change at all ivry fifty years.\n",
"\n",
"Finley Peter Dunne\n"
}; text x {
"'Change' is scientific, 'progress' is ethical;\n",
"change is indubitable, whereas progress is a\n",
"matter of controversy.\n",
"\n",
"Bertrand Russell\n"
}; text x {
"Character is what God and the angels know of\n",
"us; reputation is what men and women think of us.\n",
"\n",
"Horace Mann\n"
}; text x {
"There are only two things a child will share\n",
"willingly--communicable diseases and his mother's age.\n",
"\n",
"Benjamin Spock\n"
}; text x {
"If Columbus had an advisory committee he\n",
"would probably still be at the dock.\n",
"\n",
"Justice Arthur Goldberg\n"
}; text x {
"She had lost the art of conversation, but\n",
"not, unfortunately, the power of speech.\n",
"\n",
"George Bernard Shaw\n"
}; text x {
"I often quote myself. It adds spice to my conversation.\n",
"\n",
"George Benard Shaw\n"
}; text x {
"Courage is fear holding on a minute longer.\n",
"\n",
"Harry Emerson Fosdick\n"
}; text x {
"Watch what people are cynical about,\n",
"and one can often discover what they lack.\n",
"\n",
"George S. Patton\n"
}; text x {
"One man with courage makes a majority.\n",
"\n",
"Andrew Jackson\n"
}; text x {
"He has a right to criticize, who has a heart to help.\n",
"\n",
"Abraham Lincoln\n"
}; text x {
"In judging others, folks will work overtime for no pay.\n",
"\n",
"Charles Edwin Carruthers\n"
}; text x {
"To escape criticism -- do nothing,\n",
"say nothing, be nothing.\n",
"\n",
"Elbert Hubbard\n"
}; text x {
"When a hundred men stand together, each\n",
"of them loses his mind and gets another one.\n",
"\n",
"Friedrich Nietzsche\n"
}; text x {
"We are never deceived; we deceive ourselves.\n",
"\n",
"Johann von Goethe\n"
}; text x {
"Half the work that is done in the world is\n",
"to make things appear what they are not.\n",
"\n",
"E. R. Beadle\n"
}; text x {
"I give you bitter pills in sugar coating.\n",
"The pills are harmless: the poison is in the sugar.\n",
"\n",
"Stanislaw Lec\n"
}; text x {
"To lose\n",
"Is to learn.\n",
"\n",
"Anon.\n"
}; text x {
"What is defeat? Nothing but education,\n",
"nothing but the first step toward something better.\n",
"\n",
"Wendell Phillips\n"
}; text x {
"Intelligence appears to be the thing that\n",
"enables a man to get along without an\n",
"education. Education appears to be the\n",
"thing that enables a man to get along\n",
"without the use of his intelligence.\n",
"\n",
"A. E. Wiggan\n"
}; text x {
"A university is what a college becomes when\n",
"the faculty loses interest in students.\n",
"\n",
"John Ciardi\n"
}; text x {
"Education with inert ideas is not only\n",
"useless; it is above all things harmful.\n",
"\n",
"Alfred North Whitehead\n"
}; text x {
"A child educated only at school is an uneducated child.\n",
"\n",
"George Santayana\n"
}; text x {
"Education is not the filling of a pail, but the lighting\n",
"of a fire.\n",
"\n",
"William Butler Yeats\n"
}; text x {
"The ultimate goal of the educational system\n",
"is to shift to the individual the burden of\n",
"pursuing his education.\n",
"\n",
"John W. Gardner\n"
}; text x {
"A wise man gets more use from his enemies than a fool from\n",
"his friends.\n",
"\n",
"Baltasar Gracian\n"
}; text x {
"You can discover what your enemy fears most\n",
"by observing the means he uses to frighten you.\n",
"\n",
"Eric Hoffer\n"
}; text x {
"There is nothing I'm afraid of like scared people.\n",
"\n",
"Robert Frost\n"
}; text x {
"The scalded cat fears even cold water.\n",
"\n",
"Thomas Fuller\n"
}; text x {
"An adult is a deteriorated child.\n",
"\n",
"Anon.\n"
}; text x {
"Too much of a good thing is wonderful.\n",
"\n",
"Mae West\n"
}; text x {
"Power tends to corrupt; absolute power corrupts absolutely.\n",
"\n",
"Lord Acton\n"
}; text x {
"A genius is one who can do anything except make a living.\n",
"\n",
"Joey Adams\n"
}; text x {
"Success has made failures of many men.\n",
"\n",
"Cindy Adams\n"
}; text x {
"It is easier to fight for one's principles than live up to\n",
"them.\n",
"\n",
"Alfred Adler\n"
}; text x {
"I have a fine sense of the ridiculous, but no sense of\n",
"humour.\n",
"\n",
"Edward Albee\n"
}; text x {
"Often the test of courage is not to die but to live.\n",
"\n",
"Conte Vittorio Alfieri\n"
}; text x {
"A conference is\n",
"a gathering of important people who singly can do nothing,\n",
"but together can decide that nothing can be done.\n",
"\n",
"Fred Allen\n"
}; text x {
"A study of economics usually reveals that the best time to\n",
"buy anything is last year.\n",
"\n",
"Marty Allen\n"
}; text x {
"When policy fails try thinking.\n",
"\n",
"American Business Maxim\n"
}; text x {
"Nothing is ever accomplished by a reasonable man.\n",
"\n",
"American Proverb\n"
}; text x {
"Every nation sincerely desires peace;\n",
"and all nations pursue courses which if persisted in,\n",
"must make peace impossible.\n",
"\n",
"Sir Norman Angell\n"
}; text x {
"A synonym is the word you use when you can't spell the right\n",
"one and therefore can't find it in the dictionary.\n",
"\n",
"Anon\n"
}; text x {
"Among civilized nations reason has always been an\n",
"occupational hazard.\n",
"\n",
"Anon\n"
}; text x {
"Wisdom is knowing when you cannot be wise.\n",
"\n",
"Anon\n"
}; text x {
"Wise people think all they say; fools say all they think.\n",
"\n",
"Anon\n"
}; text x {
"Wit is cultured insolence.\n",
"\n",
"Aristotle\n"
}; text x {
"The ultimate value of life depends upon awareness,\n",
"and the power of contemplation rather than upon mere\n",
"survival.\n",
"\n",
"Aristotle\n"
}; text x {
"That's one small step for a man, one giant leap for mankind.\n",
"\n",
"Neil Armstrong\n"
}; text x {
"Lord give me chastity - but not yet.\n",
"\n",
"Saint Augustine\n"
}; text x {
"Rebellions of the belly are the worst.\n",
"\n",
"Francis Bacon\n"
}; text x {
"Virtue, perhaps, is nothing more than politeness of soul.\n",
"\n",
"Honore de Balzac\n"
}; text x {
"Every man has a right to be wrong in his opinions.\n",
"But no man has a right to be wrong in his facts.\n",
"\n",
"Bernard Baruch\n"
}; text x {
"To catch a husband is an art; to hold him is a job.\n",
"\n",
"Simone de Beauvoir\n"
}; text x {
"For those who like this sort of thing,\n",
"this is the sort of thing they like.\n",
"\n",
"Max Beerbohm\n"
}; text x {
"Anyone can do any amount of work provided it isn't the work\n",
"he is supposed to be doing at that moment.\n",
"\n",
"Robert Benchley\n"
}; text x {
"Defining and analyzing humour is a pastime of humorless\n",
"people.\n",
"\n",
"Robert Benchley\n"
}; text x {
"Religion: A daughter of Hope and Fear, explaining to\n",
"Ignorance the nature of the Unknowable.\n",
"\n",
"Ambrose Bierce\n"
}; text x {
"Saint: A dead sinner revised and edited.\n",
"\n",
"Ambrose Bierce\n"
}; text x {
"Cynic: A blackguard whose faulty vision sees things as they\n",
"are, not as they ought to be.\n",
"\n",
"Ambrose Bierce\n"
}; text x {
"Love: A temporary insanity curable by marriage.\n",
"\n",
"Ambrose Bierce\n"
}; text x {
"Prophecy: The art and practice of selling one's credibility\n",
"for future delivery.\n",
"\n",
"Ambrose Bierce\n"
}; text x {
"Quotation: The act of repeating erroneously the words of\n",
"another.\n",
"\n",
"Ambrose Bierce\n"
}; text x {
"Don't put off till tomorrow what can be enjoyed today.\n",
"\n",
"Josh Billings\n"
}; text x {
"Remember the poor - it costs nothing.\n",
"\n",
"Josh Billings\n"
}; text x {
"Solitude: A good place to visit, but a poor place to stay.\n",
"\n",
"Josh Billings. (Henry Wheeler Shaw)\n"
}; text x {
"A conclusion is the place where you get tired of thinking.\n",
"\n",
"Arthur Bloch\n"
}; text x {
"Prediction is very difficult, especially about the future.\n",
"\n",
"Neils Bohr\n"
}; text x {
"An expert is a man who has made all the mistakes which can\n",
"be made, in a narrow field.\n",
"\n",
"Niels Bohr. Danish physicist\n"
}; text x {
"An atheist is a man who has no invisible means of support.\n",
"\n",
"John Buchan\n"
}; text x {
"Never do today what you can do tomorrow. Something may occur\n",
"to make you regret your premature action.\n",
"\n",
"Aaron Burr\n"
}; text x {
"Friendship is like money, easier made than kept.\n",
"\n",
"Samuel Butler\n"
}; text x {
"Life is the art of drawing sufficient conclusions from\n",
"insufficient premises.\n",
"\n",
"Samuel Butler\n"
}; text x {
"In time of war the first casualty is truth.\n",
"\n",
"Boake Carter\n"
}; text x {
"A proverb is a short sentence based on long experience.\n",
"\n",
"M. de Cervantes\n"
}; text x {
"Chess is about as elaborate a waste of human intelligence as\n",
"you could find anywhere outside an advertising agency.\n",
"\n",
"Raymond Chandler\n"
}; text x {
"A puritan is a person who pours righteous indignation into\n",
"the wrong things.\n",
"\n",
"G.K. Chesterton\n"
}; text x {
"I prefer old age to the alternative.\n",
"\n",
"Maurice Chevalier\n"
}; text x {
"I hear and I forget. I see and I remember. I do and I\n",
"understand.\n",
"\n",
"Chinese Proverb\n"
}; text x {
"How pleasant it is to have money.\n",
"\n",
"Arthur Hugh Clough\n"
}; text x {
"Common sense in an uncommon degree is what the world calls\n",
"wisdom.\n",
"\n",
"Samuel Taylor Coleridge\n"
}; text x {
"When you have nothing to say, say nothing.\n",
"\n",
"Charles Caleb Colton\n"
}; text x {
"What you do not want done to yourself, do not do to others.\n",
"\n",
"Confucius\n"
}; text x {
"Co-existence - what the farmer does with the turkey\n",
"until Thanksgiving.\n",
"\n",
"Mike Connolly\n"
}; text x {
"A good memory is needed after one has lied.\n",
"\n",
"Pierre Corneille\n"
}; text x {
"We triumph without glory when we conquer without danger.\n",
"\n",
"Pierre Corneille\n"
}; text x {
"No man is a hero to his valet.\n",
"\n",
"Anne-Marie Bigot de Cornuel\n"
}; text x {
"Life is an incurable disease.\n",
"\n",
"Abraham Cowley\n"
}; text x {
"I love you, not only for what you are,\n",
"but for what I am when I am with you.\n",
"\n",
"Roy Croft\n"
}; text x {
"Cogito, ergo sum: I think, therefore I am.\n",
"\n",
"Rene Descartes\n"
}; text x {
"We spend the first twelve months of our children's lives\n",
"teaching them to walk and talk\n",
"and the next twelve telling them to sit down and shut up.\n",
"\n",
"Phyllis Diller\n"
}; text x {
"Everything that can be invented has been invented.\n",
"\n",
"Director of the US Patent Office 1899\n"
}; text x {
"My idea of an agreeable person, is a person who agrees with\n",
"me.\n",
"\n",
"Benjamin Disraeli\n"
}; text x {
"A poet in history is divine, but a poet in the next room is\n",
"a joke.\n",
"\n",
"Max Eastman\n"
}; text x {
"Genius is one per cent inspiration and ninety-nine per cent\n",
"perspiration.\n",
"\n",
"Thomas A. Edison\n"
}; text x {
"I never think of the future. It comes soon enough.\n",
"\n",
"Albert Einstein\n"
}; text x {
"Do not needlessly endanger your lives until I give you the\n",
"signal.\n",
"\n",
"Dwight D. Eisenhower\n"
}; text x {
"Humankind cannot bear very much reality.\n",
"\n",
"T.S. Eliot\n"
}; text x {
"All mankind love a lover.\n",
"\n",
"Ralph Waldo Emerson\n"
}; text x {
"A great part of courage is the courage\n",
"of having done the thing before.\n",
"\n",
"R.W. Emerson\n"
}; text x {
"Commit a crime, and the earth is made of glass.\n",
"There is no such thing as concealment.\n",
"\n",
"R.W. Emerson\n"
}; text x {
"In skating over thin ice, our safety is in our speed.\n",
"\n",
"R.W. Emerson\n"
}; text x {
"When it is dark enough you can see the stars.\n",
"\n",
"R.W. Emerson\n"
}; text x {
"Love of beauty is Taste...The creation of beauty is Art.\n",
"\n",
"R.W. Emerson\n"
}; text x {
"The end of the human race is that it will die of\n",
"civilization.\n",
"\n",
"R.W. Emerson\n"
}; text x {
"Weed - a plant whose virtues have not yet been discovered.\n",
"\n",
"R.W. Emerson\n"
}; text x {
"There never was a child so lovely but his mother was glad to\n",
"get him asleep.\n",
"\n",
"R.W. Emerson\n"
}; text x {
"He that would the daughter win, Must with the mother first\n",
"begin.\n",
"\n",
"English Proverb\n"
}; text x {
"In the country of the blind the one-eyed man is king.\n",
"\n",
"Desiderius Erasmus\n"
}; text x {
"There's a difference between beauty and charm.  A beautiful\n",
"woman is one I notice. A charming woman is one who notices\n",
"me.\n",
"\n",
"John Erskine\n"
}; text x {
"He talked with more claret than clarity.\n",
"\n",
"Susan Ertz\n"
}; text x {
"Zoo: An excellent place to study the habits of human beings.\n",
"\n",
"E. Esar\n"
}; text x {
"All work and no play makes Jack a dull boy - and Jill a\n",
"wealthy widow.\n",
"\n",
"E. Esar\n"
}; text x {
"Those whom God wishes to destroy, he first makes mad.\n",
"\n",
"Euripides\n"
}; text x {
"When a woman behaves like a man why doesn't she behave like\n",
"a nice man.\n",
"\n",
"Dame Edith Evans\n"
}; text x {
"Tall oaks from little acorns grow.\n",
"\n",
"David Everett\n"
}; text x {
"Passions are fashions.\n",
"\n",
"Clifton Fadiman\n"
}; text x {
"...the difference between town and country is mostly the\n",
"view.\n",
"\n",
"Nan Fairbrother\n"
}; text x {
"The people came to realize that wealth is not the fruit of\n",
"labour but the result of organized protected robbery.\n",
"\n",
"Frantz Fanon\n"
}; text x {
"The reward of energy, enterprise and thrift - is taxes.\n",
"\n",
"W. Feather\n"
}; text x {
"Men just don't seem to jump off the bridge for big reasons;\n",
"they usually do so for little ones.\n",
"\n",
"W.H. Ferry\n"
}; text x {
"I used to worry about what life was for - now being alive\n",
"seems sufficient reason.\n",
"\n",
"Joanna Field\n"
}; text x {
"Anybody who hates children and dogs can't be all bad.\n",
"\n",
"W.C. Fields\n"
}; text x {
"I am free of all prejudice. I hate everyone equally.\n",
"\n",
"W.C. Fields\n"
}; text x {
"The cost of living has gone up another dollar a quart.\n",
"\n",
"W.C. Fields\n"
}; text x {
"Stop the world...Nixon wants to get back on!\n",
"\n",
"David Fisher\n"
}; text x {
"An author ought to write for the youth of his own\n",
"generation, the critics of the next, and the schoolmaster of\n",
"ever afterwards.\n",
"\n",
"F. Scott Fitzgerald\n"
}; text x {
"A big man has no time really to do anything but just sit and\n",
"be big.\n",
"\n",
"Francis Scott Fitzgerald\n"
}; text x {
"The victor belongs to the spoils.\n",
"\n",
"F. Scott Fitzgerald\n"
}; text x {
"Fitzgerald: The rich are different from us.\n",
"Hemingway: Yes, they have more money.\n",
"\n",
"F.Scott Fitzgerald\n"
}; text x {
"The bigger they come the harder they fall.\n",
"\n",
"Robert Prometheus Fitzsimmons\n"
}; text x {
"Nothing is particularly hard if you divide it into small\n",
"jobs.\n",
"\n",
"Henry Ford\n"
}; text x {
"One of the greatest labour-saving inventions of today is\n",
"tomorrow.\n",
"\n",
"Vincent T. Foss\n"
}; text x {
"In every well-governed state wealth is a sacred thing; in\n",
"democracies it is the ONLY sacred thing.\n",
"\n",
"Anatole France\n"
}; text x {
"In this world nothing is certain but death and taxes.\n",
"\n",
"Benjamin Franklin\n"
}; text x {
"All a man needs to be elected President is the kind of\n",
"profile that looks good on a postage stamp.\n",
"\n",
"B.B. Franklin\n"
}; text x {
"If a lie is repeated often enough all the dumb jackasses in\n",
"the world not only get to believe it, they even swear by it.\n",
"\n",
"B.B. Franklin\n"
}; text x {
"Clothe an idea in words and it loses its freedom of\n",
"movement.\n",
"\n",
"Egon Friedell\n"
}; text x {
"As we ascend the social ladder, viciousness wears a thicker\n",
"mask.\n",
"\n",
"Erich Fromm\n"
}; text x {
"The successful revolutionary is a statesman,\n",
"the unsuccessful one a criminal.\n",
"\n",
"Erich Fromm\n"
}; text x {
"A diplomat is a man who always remembers a woman's birthday\n",
"but never remembers her age.\n",
"\n",
"Robert Frost\n"
}; text x {
"A jury consists of twelve persons chosen to decide who has\n",
"the better lawyer.\n",
"\n",
"Robert Frost\n"
}; text x {
"The reason why worry kills more people than work is that\n",
"more people worry than work.\n",
"\n",
"Robert Frost\n"
}; text x {
"The world is full of willing people; some willing to work,\n",
"the rest willing to let them.\n",
"\n",
"Robert Frost\n"
}; text x {
"Faith is much better than belief.\n",
"Belief is when someone ELSE does the thinking.\n",
"\n",
"R. Buckminster Fuller\n"
}; text x {
"Getting divorced just because you don't love a man is\n",
"almost as silly as getting married just because you do.\n",
"\n",
"Zsa Zsa Gabor\n"
}; text x {
"Husbands are like fires - they go out when unattended.\n",
"\n",
"Zsa Zsa Gabor\n"
}; text x {
"I am a marvellous housekeeper.\n",
"Every time I leave a man, I keep his house.\n",
"\n",
"Zsa Zsa Gabor\n"
}; text x {
"Talk of revolution is one of avoiding reality.\n",
"\n",
"J.K. Galbraith\n"
}; text x {
"There is nothing so fatal to character as half-finished\n",
"tasks.\n",
"\n",
"David Lloyd George\n"
}; text x {
"A country can be judged by the quality of its proverbs.\n",
"\n",
"German Proverb\n"
}; text x {
"If you can actually count your money\n",
"then you are not really a rich man.\n",
"\n",
"Paul Getty\n"
}; text x {
"Expecting something for nothing is the most popular form of\n",
"hope.\n",
"\n",
"Arnold Glasow\n"
}; text x {
"All things are only transitory.\n",
"\n",
"Goethe\n"
}; text x {
"When an idea is wanting a word can always be found to take\n",
"its place.\n",
"\n",
"J.W. von Goethe\n"
}; text x {
"Everything in the world may be endured except continual\n",
"prosperity.\n",
"\n",
"Johann Wolfgang von Goethe\n"
}; text x {
"A verbal contract isn't worth the paper it's written on.\n",
"\n",
"Samuel Goldwyn\n"
}; text x {
"If you steal something small you are a petty thief,\n",
"but if you steal millions you are a gentleman of society.\n",
"\n",
"Greek Proverb\n"
}; text x {
"By the act of marriage you endorse all the ancient and dead\n",
"values. You endorse things like monogamy. Lifelong monogamy\n",
"is a maniacal idea.\n",
"\n",
"Germaine Greer\n"
}; text x {
"Nature didn't make us perfect so she did the next best\n",
"thing. She made us blind to our faults.\n",
"\n",
"Grit\n"
}; text x {
"Figures won't lie, but liars will figure.\n",
"\n",
"Charles H. Grosvenor\n"
}; text x {
"There are some who start their retirement long before they\n",
"stop working.\n",
"\n",
"Robert Half\n"
}; text x {
"Actually, I'm an overnight success. But it took twenty\n",
"years.\n",
"\n",
"Monty Hall\n"
}; text x {
"Nobody can be so amusingly arrogant as a young man who has\n",
"just discovered an old idea and thinks it is his own.\n",
"\n",
"Sydney Harris\n"
}; text x {
"Wit is the salt of conversation, not the food.\n",
"\n",
"William Hazlitt\n"
}; text x {
"Prosperity is a great teacher; adversity a greater.\n",
"\n",
"William Hazlitt\n"
}; text x {
"What's not worth doing is not worth doing well.\n",
"\n",
"Don Hebb\n"
}; text x {
"Opinions founded on prejudice are always sustained with the\n",
"greatest violence.\n",
"\n",
"Hebrew Proverb\n"
}; text x {
"They told me it would disrupt my life less if I got killed\n",
"sooner.\n",
"\n",
"Joseph Heller\n"
}; text x {
"Courage is grace under pressure.\n",
"\n",
"Ernest Hemingway\n"
}; text x {
"But in modern war...you will die like a dog for no good\n",
"reason.\n",
"\n",
"Ernest Hemingway\n"
}; text x {
"All good books are alike in that they are truer than if they\n",
"had really happened.\n",
"\n",
"Ernest Hemingway\n"
}; text x {
"Plain women know more about men than beautiful ones do. But\n",
"beautiful women don't need to know about men.\n",
"It's the men who have to know about beautiful women.\n",
"\n",
"Katherine Hepburn\n"
}; text x {
"Only the young die good.\n",
"\n",
"Oliver Herford\n"
}; text x {
"Manuscript: Something submitted in haste and returned at\n",
"leisure.\n",
"\n",
"Oliver Herford\n"
}; text x {
"Racism is man's gravest threat to man -\n",
"the maximum of hatred for a minimum of reason.\n",
"\n",
"Abraham Joshua Heschel\n"
}; text x {
"Many people have played themselves to death.\n",
"Many people have eaten and drunk themselves to death.\n",
"Nobody ever thought himself to death.\n",
"\n",
"Gilbert Highet\n"
}; text x {
"There is nothing women hate so much as to see men\n",
"selfishly enjoying themselves without the solace of feminine\n",
"society.\n",
"\n",
"Katharine Tynan Hinkson\n"
}; text x {
"To do nothing is also a good remedy.\n",
"\n",
"Hippocrates\n"
}; text x {
"A good film is when the price of the dinner,\n",
"the theatre admission and the babysitter were worth it.\n",
"\n",
"Alfred Hitchcock\n"
}; text x {
"We stand for the maintenance of private property.\n",
"\n",
"Adolf Hitler\n"
}; text x {
"The victor will never be asked if he told the truth.\n",
"\n",
"Adolf Hitler\n"
}; text x {
"The day of individual happiness has passed.\n",
"\n",
"Adolf Hitler\n"
}; text x {
"The great masses of the people will more easily fall victims\n",
"to a big lie than to a small one.\n",
"\n",
"Adolf Hitler\n"
}; text x {
"Truth is with the victor -\n",
"who, as you know, also controls the historians.\n",
"\n",
"Rolf Hochhuth\n"
}; text x {
"The best way I know of to win an argument is\n",
"to start by being in the right.\n",
"\n",
"Quentin Hogg\n"
}; text x {
"Every calling is great when greatly pursued.\n",
"\n",
"Oliver Wendell Holmes Jr.\n"
}; text x {
"I think I am better than the people who are trying to reform\n",
"me.\n",
"\n",
"E.W. Howe\n"
}; text x {
"If you suffer, thank God! - it is a sure sign that you are\n",
"alive.\n",
"\n",
"Elbert Hubbard\n"
}; text x {
"An optimist is a fellow who believes what's going to be will\n",
"be postponed.\n",
"\n",
"Kin Hubbard\n"
}; text x {
"A man is as good as he has to be, and a woman as bad as she\n",
"dares.\n",
"\n",
"Elbert Hubbard\n"
}; text x {
"Polygamy: An endeavour to get more out of life than there is\n",
"in it.\n",
"\n",
"Elbert Hubbard\n"
}; text x {
"If there is anything a public servant hates to do\n",
"it's something for the public.\n",
"\n",
"Kin Hubbard\n"
}; text x {
"When a fellow says it ain't the money but the principle of\n",
"the thing, it's the money.\n",
"\n",
"Kin Hubbard\n"
}; text x {
"Humour is laughing at what you haven't got when you ought to\n",
"have it.\n",
"\n",
"Langston Hughes\n"
}; text x {
"Habit is the nursery of errors.\n",
"\n",
"Victor Hugo\n"
}; text x {
"A woman has to be twice as good as a man to go half as far.\n",
"\n",
"Fannie Hurst\n"
}; text x {
"The rung of a ladder was never meant to rest upon,\n",
"but only to hold a man's foot long enough to put the other\n",
"somewhat higher.\n",
"\n",
"Thomas Huxley\n"
}; text x {
"I am ignorant and impotent and yet, somehow or other,\n",
"here I am unhappy, no doubt, profoundly dissatisfied... In\n",
"spite of everything I survive.\n",
"\n",
"Aldous Huxley\n"
}; text x {
"Science commits suicide when it adopts a creed.\n",
"\n",
"Thomas Henry Huxley\n"
}; text x {
"Several excuses are always less convincing than one.\n",
"\n",
"Aldous Huxley\n"
}; text x {
"In practical life, the woman is judged by man's law,\n",
"as if she were a man, not a woman.\n",
"\n",
"Henrik Ibsen\n"
}; text x {
"Originality is undetected plagiarism.\n",
"\n",
"Dean W.R. Inge\n"
}; text x {
"Few rich men own their own property. The property owns them.\n",
"\n",
"Robert G. Ingersoll\n"
}; text x {
"The nation that is richest in proverbs (Spain) is the one\n",
"that has proved itself the least wise in action.\n",
"\n",
"Joseph Jacobs\n"
}; text x {
"The art of being wise is the art of knowing what to\n",
"overlook.\n",
"\n",
"William James\n"
}; text x {
"For a man to pretend to understand women is bad manners; for\n",
"him really to understand them is bad morals.\n",
"\n",
"Henry James\n"
}; text x {
"The deepest principle in human nature is the craving to be\n",
"appreciated.\n",
"\n",
"William James\n"
}; text x {
"To teach is to learn.\n",
"\n",
"Japanese Proverb\n"
}; text x {
"If you understand everything, you must be misinformed.\n",
"\n",
"Japanese Proverb\n"
}; text x {
"Put three grains of sand inside a vast cathedral,\n",
"and the cathedral will be more closely packed with sand than\n",
"space is with stars.\n",
"\n",
"Sir James Jeans\n"
}; text x {
"Your manuscript is both good and original;\n",
"but the part that is good is not original,\n",
"and the part that is original is not good.\n",
"\n",
"Samuel Johnson\n"
}; text x {
"What is written without effort is in general read without\n",
"pleasure.\n",
"\n",
"Samuel Johnson\n"
}; text x {
"Classical quotation is the parole of literary men all over\n",
"the world.\n",
"\n",
"Samuel Johnson\n"
}; text x {
"The applause of a single human being is of great\n",
"consequence.\n",
"\n",
"Samuel Johnson\n"
}; text x {
"He knows not his own strength that hath not met adversity.\n",
"Ben Jonson\n"
}; text x {
"In the fight between you and the world, back the world.\n",
"\n",
"Franz Kafka\n"
}; text x {
"You do not destroy an idea by killing people;\n",
"you replace it with a better one.\n",
"\n",
"Edward Keating\n"
}; text x {
"Beauty is truth, truth beauty.\n",
"\n",
"John Keats\n"
}; text x {
"It is much safer to obey than to rule.\n",
"\n",
"Thomas A. Kempis\n"
}; text x {
"Verily, when the day of judgment comes,\n",
"we shall not be asked what we have read, but what we have\n",
"done.\n",
"\n",
"Thomas A. Kempis\n"
}; text x {
"We have the power to make this the best generation of\n",
"mankind in the history of the world - or to make it the last.\n",
"\n",
"John F. Kennedy\n"
}; text x {
"Those who make peaceful revolution impossible will make\n",
"violent revolution inevitable.\n",
"\n",
"John F. Kennedy\n"
}; text x {
"There are three sides to every story -\n",
"yours, mine, and all that lie between.\n",
"\n",
"Jody Kern\n"
}; text x {
"Words are, of course, the most powerful drug used by\n",
"mankind.\n",
"\n",
"Rudyard Kipling\n"
}; text x {
"For the female of the species is more deadly than the male.\n",
"\n",
"Rudyard Kipling\n"
}; text x {
"He travels the fastest who travels alone.\n",
"\n",
"Rudyard Kipling\n"
}; text x {
"The silliest woman can manage a clever man;\n",
"but it needs a very clever woman to manage a fool.\n",
"\n",
"Rudyard Kipling\n"
}; text x {
"We cannot unthink unless we are insane.\n",
"\n",
"Arthur Koestler\n"
}; text x {
"Scientists are Peeping Toms at the keyhole of eternity.\n",
"\n",
"Arthur Koestler\n"
}; text x {
"Television:\n",
"A medium. So called because it is neither rare nor well done.\n",
"\n",
"Ernie Kovacs\n"
}; text x {
"Logic is the art of going wrong with confidence.\n",
"\n",
"Joseph Wood Krutch\n"
}; text x {
"Credulity is the man's weakness, but the child's strength.\n",
"Charles Lamb\n"
}; text x {
"Nothing puzzles me more than time and space,\n",
"and yet nothing puzzles me less, for I never think about\n",
"them.\n",
"\n",
"Charles Lamb\n"
}; text x {
"Levity is the soul of wit.\n",
"\n",
"Melville D. Landon. (Eli Perkins)\n"
}; text x {
"By 1960 work will be limited to three hours a day.\n",
"\n",
"John Langdon-Davies. A Short History of the Future 1936\n"
}; text x {
"People don't ask for facts in making up their minds.\n",
"They would rather have one good, soul-satisfying emotion than\n",
"a dozen facts.\n",
"\n",
"Robert Keith Leavitt\n"
}; text x {
"At the beginning there was the Word - at the end just the\n",
"Cliche.\n",
"\n",
"Stanislaw J. Lec\n"
}; text x {
"Not all women give most of their waking thoughts to the\n",
"problem of pleasing men. Some are married.\n",
"\n",
"Emma Lee\n"
}; text x {
"It's easier to be original and foolish than original and\n",
"wise.\n",
"\n",
"Gottfried Wilhelm Leibniz\n"
}; text x {
"A pun is the lowest form of humour -\n",
"when you don't think of it first.\n",
"\n",
"Oscar Levant\n"
}; text x {
"Statistics are like a bikini. What they reveal is\n",
"suggestive, but what they conceal is vital.\n",
"\n",
"Aaron Levenstein\n"
}; text x {
"Statistics - figures used as arguments.\n",
"\n",
"Leonard Louis Levinson\n"
}; text x {
"A person reveals his character by nothing so clearly\n",
"as the joke he resents.\n",
"\n",
"G.C. Lichtenberg\n"
}; text x {
"Freedom of the press is limited to those who own one.\n",
"\n",
"A.J. Liebling\n"
}; text x {
"Tact is the ability to describe others as they see\n",
"themselves.\n",
"\n",
"Abraham Lincoln\n"
}; text x {
"What kills a skunk is the publicity it gives itself.\n",
"\n",
"Abraham Lincoln\n"
}; text x {
"The ballot is stronger than the bullet.\n",
"\n",
"Abraham Lincoln\n"
}; text x {
"You can fool all the people some of the time,\n",
"and some of the people all the time,\n",
"but you cannot fool all the people all the time.\n",
"\n",
"Abraham Lincoln\n"
}; text x {
"Where all men think alike, no one thinks very much.\n",
"\n",
"Walter Lippmann\n"
}; text x {
"I have always thought the actions of men the best\n",
"interpreters of their thoughts.\n",
"\n",
"John Locke\n"
}; text x {
"This organization (the United Nations) is created to prevent\n",
"you from going to hell.\n",
"It isn't created to take you to heaven.\n",
"\n",
"Henry Cabot Lodge\n"
}; text x {
"The ignorant man always adores what he cannot understand.\n",
"\n",
"Cesare Lombroso\n"
}; text x {
"Truth in science can be defined as the working hypothesis\n",
"best suited to open the way to the next better one.\n",
"\n",
"Konrad Lorenz\n"
}; text x {
"While doubt stands still, confidence can erect a skyscraper.\n",
"George Lorimer\n"
}; text x {
"By virtue we merely mean the avoidance of the vices that do\n",
"not attract us.\n",
"\n",
"Robert Lynd\n"
}; text x {
"In war there is no substitute for victory.\n",
"\n",
"Douglas MacArthur\n"
}; text x {
"It is much more secure to be feared than to be loved.\n",
"\n",
"Niccolo Machiavelli\n"
}; text x {
"An optimist is a guy who has never had much experience.\n",
"\n",
"Don Marquis\n"
}; text x {
"From each according to his abilities,\n",
"to each according to his needs.\n",
"\n",
"Karl Marx\n"
}; text x {
"Religion is the opiate of the masses.\n",
"\n",
"Karl Marx\n"
}; text x {
"Impropriety is the soul of wit.\n",
"\n",
"Somerset Maugham\n"
}; text x {
"It is impossible to defeat an ignorant man in argument.\n",
"\n",
"William G. McAdoo\n"
}; text x {
"A satirist is a man who discovers unpleasant things about\n",
"himself and then says them about other people.\n",
"\n",
"Peter McArthur\n"
}; text x {
"Many are saved from sin by being so inept at it.\n",
"\n",
"Mignon McLaughlin\n"
}; text x {
"If I knew what I was so anxious about, I wouldn't be so\n",
"anxious.\n",
"\n",
"Mignon McLaughlin\n"
}; text x {
"Having two bathrooms ruined the capacity to co-operate.\n",
"\n",
"Margaret Mead. American anthropologist\n"
}; text x {
"I try all things; I achieve what I can.\n",
"\n",
"Herman Melville\n"
}; text x {
"In adversity a man is saved by hope.\n",
"\n",
"Menander\n"
}; text x {
"Conscience\n",
"is the inner voice which warns us that someone might be\n",
"looking.\n",
"\n",
"H.L. Mencken\n"
}; text x {
"When women kiss it always reminds one of prize fighters\n",
"shaking hands.\n",
"\n",
"H.L. Mencken\n"
}; text x {
"No one ever went broke\n",
"underestimating the taste of the American public.\n",
"\n",
"H.L. Mencken\n"
}; text x {
"Men have a much better time of it than women: for one thing,\n",
"they marry later; for another thing they die earlier.\n",
"\n",
"H.L. Mencken\n"
}; text x {
"Don't overestimate the decency of the human race.\n",
"\n",
"H.L. Mencken\n"
}; text x {
"On one issue at least, men and women agree; they both\n",
"distrust women.\n",
"\n",
"H.L. Mencken\n"
}; text x {
"Puritanism: The haunting fear that someone, somewhere, may\n",
"be happy.\n",
"\n",
"H.L. Mencken\n"
}; text x {
"A politician is an animal which can sit on a fence\n",
"and yet keep both ears to the ground.\n",
"\n",
"H.L. Mencken\n"
}; text x {
"Lord, grant that I may always desire more than I can\n",
"accomplish.\n",
"\n",
"Michelangelo\n"
}; text x {
"He who knows only his own side of the case knows little of\n",
"that.\n",
"\n",
"J.S. Mill\n"
}; text x {
"We do not talk - we bludgeon one another with facts\n",
"and theories gleaned from cursory readings of newspapers,\n",
"magazines and digests.\n",
"\n",
"Henry Miller\n"
}; text x {
"Better to reign in hell than serve in heav'n.\n",
"\n",
"John Milton\n"
}; text x {
"Gambling: The sure way of getting nothing for something.\n",
"\n",
"Wilson Mizner\n"
}; text x {
"When you take stuff from one writer it's plagiarism;\n",
"but when you take it from many writers, it's research.\n",
"\n",
"Wilson Mizner\n"
}; text x {
"Having a daughter is like riding a young horse\n",
"over an unknown steeplechase course.\n",
"You don't know when to pull up the reins,\n",
"when to let the horse have the head ... or what.\n",
"\n",
"Princess Grace of Monaco\n"
}; text x {
"I don't mind living in a man's world as long as I can be a\n",
"woman in it.\n",
"\n",
"Marilyn Monroe\n"
}; text x {
"I give myself sometimes admirable advice,\n",
"but I am incapable of taking it.\n",
"\n",
"Lady Mary Wortley Montagu\n"
}; text x {
"Civility costs nothing, and buys everything.\n",
"\n",
"Mary Wortley Montagu\n"
}; text x {
"War hath no fury like a non-combatant.\n",
"\n",
"C.E. Montague\n"
}; text x {
"We can be knowledgeable with other men's knowledge,\n",
"but we cannot be wise with other men's wisdom.\n",
"\n",
"Michel de Montaigne\n"
}; text x {
"Marriage is like a cage;\n",
"one sees the birds outside desperate to get in,\n",
"and those inside equally desperate to get out.\n",
"\n",
"Michel de Montaigne. French writer\n"
}; text x {
"Every man who possesses power is impelled to abuse it.\n",
"\n",
"Baron de La Brede et de Montesquieu\n"
}; text x {
"After all there is but one race - humanity.\n",
"\n",
"George Moore\n"
}; text x {
"Obstacles are those frightful things you see when\n",
"you take your eyes off the goal.\n",
"\n",
"Hannah More\n"
}; text x {
"There is only one success,\n",
"to be able to spend your life in your own way.\n",
"\n",
"Christopher Morley\n"
}; text x {
"You have not converted a man because you have silenced him.\n",
"\n",
"John Viscount Morley\n"
}; text x {
"Economy: Cutting down other people's wages.\n",
"\n",
"J.B. Morton\n"
}; text x {
"If the nation's economists were laid end to end,\n",
"they would point in all directions.\n",
"\n",
"Arthur H. Motley\n"
}; text x {
"Our major obligation is not to mistake slogans for\n",
"solutions.\n",
"\n",
"Edward R. Murrow\n"
}; text x {
"When you win, nothing hurts.\n",
"\n",
"Joe Namath\n"
}; text x {
"If you wish to be a success in the world,\n",
"promise everything, deliver nothing.\n",
"\n",
"Napoleon\n"
}; text x {
"In politics stupidity is not a handicap.\n",
"\n",
"Napoleon\n"
}; text x {
"Lack of will power has caused more failure than lack of\n",
"intelligence or ability.\n",
"\n",
"Flower A. Newhouse\n"
}; text x {
"Tact is the art of making a point without making an enemy.\n",
"\n",
"Howard W. Newton\n"
}; text x {
"The thoughtless are rarely wordless.\n",
"\n",
"Howard W. Newton\n"
}; text x {
"If I have been able to see farther than others,\n",
"it was because I stood on the shoulders of giants.\n",
"\n",
"Sir Isaac Newton\n"
}; text x {
"One should die proudly when it is no longer possible to live\n",
"proudly.\n",
"\n",
"F. Nietzsche\n"
}; text x {
"He who has a why to live can bear almost any how.\n",
"\n",
"F. Nietzsche\n"
}; text x {
"Let us begin by committing ourselves to the truth -\n",
"to see it like it is, and tell it like it is -\n",
"to find the truth, to speak the truth, and live the truth.\n",
"\n",
"Richard M. Nixon. Accepting the presidential nomination in\n",
"1968\n"
}; text x {
"The right man, in the right place, at the right time -\n",
"can steal millions.\n",
"\n",
"Gregory Nunn\n"
}; text x {
"The man who has not anything to boast of but\n",
"his illustrious ancestors is like a potato -\n",
"the only good belonging to him is underground.\n",
"\n",
"Sir Thomas Overbury\n"
}; text x {
"The two most beautiful words in the English language are:\n",
"'Cheque enclosed.'\n",
"\n",
"Dorothy Parker\n"
}; text x {
"The cure for boredom is curiosity. There is no cure for\n",
"curiosity.\n",
"\n",
"Ellen Parr\n"
}; text x {
"Justice without force is powerless;\n",
"force without justice is tyrannical.\n",
"\n",
"Blaise Pascal\n"
}; text x {
"Never tell people 'how' to do things.\n",
"Tell them 'what' to do\n",
"and they will surprise you with their ingenuity.\n",
"\n",
"General George S. Patton\n"
}; text x {
"Always be sincere, even when you don't mean it.\n",
"\n",
"Irene Peter\n"
}; text x {
"An economist is an expert who will know tomorrow\n",
"why the things he predicted yesterday didn't happen today.\n",
"\n",
"Laurence J. Peter\n"
}; text x {
"Originality is the fine art of remembering what you hear but\n",
"forgetting where you heard it.\n",
"\n",
"Laurence Peter. Canadian writer\n"
}; text x {
"Exigencies create the necessary ability to meet and conquer\n",
"them.\n",
"\n",
"Wendell Phillips\n"
}; text x {
"Necessity is the argument of tyrants, it is the creed of\n",
"slaves.\n",
"\n",
"William Pitt the Younger\n"
}; text x {
"I don't need a friend who changes when I change\n",
"and who nods when I nod;\n",
"my shadow does that much better.\n",
"\n",
"Plutarch\n"
}; text x {
"Amusement is the happiness of those who cannot think.\n",
"\n",
"Alexander Pope\n"
}; text x {
"To attack a man for talking nonsense\n",
"is like finding your mortal enemy drowning in a swamp\n",
"and jumping in after him with a knife.\n",
"\n",
"Karl Popper\n"
}; text x {
"There is a remedy for everything; it is called death.\n",
"\n",
"Portuguese Proverb\n"
}; text x {
"They talk most who have the least to say.\n",
"\n",
"Matthew Prior\n"
}; text x {
"Be happy while you're living, for you're a long time dead.\n",
"\n",
"Scottish Proverb\n"
}; text x {
"Actions speak louder than words.\n",
"\n",
"Proverb\n"
}; text x {
"Advice is least heeded when most needed.\n",
"\n",
"Proverb\n"
}; text x {
"He who would leap high must take a long run.\n",
"\n",
"Proverb\n"
}; text x {
"Never advise anyone to go to war or to marry.\n",
"\n",
"Proverb\n"
}; text x {
"Take off your hat to your yesterdays;\n",
"take off your coat for your tomorrows.\n",
"\n",
"Proverb\n"
}; text x {
"The world is divided into men who accomplish things and\n",
"those who get all the credit.\n",
"\n",
"Proverb\n"
}; text x {
"What worth has beauty if it be not seen?\n",
"\n",
"Proverb\n"
}; text x {
"When saving for old age, be sure to put away a few pleasant\n",
"thoughts.\n",
"\n",
"Proverb\n"
}; text x {
"Courage is being afraid but going on anyhow.\n",
"\n",
"Dan Rather\n"
}; text x {
"Politics is not a bad profession.\n",
"If you succeed there are many rewards,\n",
"if you disgrace yourself you can always write a book.\n",
"\n",
"Ronald Reagan\n"
}; text x {
"Acting is not being emotional, but being able to express\n",
"emotion.\n",
"\n",
"Kate Reid\n"
}; text x {
"My father, a good man, told me, 'Never lose your ignorance;\n",
"you cannot replace it.'\n",
"\n",
"Erich Maria Remarque\n"
}; text x {
"I am not sincere, not even when I say I am not.\n",
"\n",
"Jules Renard\n"
}; text x {
"Writing is the only profession\n",
"where no one considers you ridiculous if you earn no money.\n",
"\n",
"Jules Renard\n"
}; text x {
"Oh, to be only half as wonderful as my child thought I was\n",
"when he was small,\n",
"and only half as stupid as my teenager now thinks I am.\n",
"\n",
"Rebecca Richards\n"
}; text x {
"The art of acting consists in keeping people from coughing.\n",
"\n",
"Sir Ralph Richardson\n"
}; text x {
"Men, like bullets, go farthest when they are smoothest.\n",
"\n",
"Jean Paul Richter\n"
}; text x {
"If it takes a lot of words to say what you have in mind,\n",
"give it more thought.\n",
"\n",
"Dennis Roch\n"
}; text x {
"It's easier to be wise for others than for ourselves.\n",
"\n",
"Francois Duc de La Rochefoucauld\n"
}; text x {
"We wish to attract praise to ourselves even as we seem to be\n",
"praising others.\n",
"\n",
"Duc de La Rochefoucauld\n"
}; text x {
"We give advice, but we cannot give the wisdom to profit by\n",
"it.\n",
"\n",
"Duc de La Rochefoucauld\n"
}; text x {
"It is easier to appear worthy of a position one does not\n",
"hold, than of the office which one fills.\n",
"\n",
"Duc de La Rochefoucauld\n"
}; text x {
"Wit sometimes enables us to act rudely with impunity.\n",
"\n",
"Duc de La Rochefoucauld\n"
}; text x {
"We always love those who admire us,\n",
"but we do not always love those whom we admire.\n",
"\n",
"Duc de La Rochefoucauld\n"
}; text x {
"There's no trick to being a humorist when\n",
"you have the whole government working for you.\n",
"\n",
"Will Rogers\n"
}; text x {
"Politics ain't worrying this country one-tenth as much as\n",
"where to find a parking space.\n",
"\n",
"Will Rogers\n"
}; text x {
"The most successful politician is he who says what everybody\n",
"is thinking most often and in the loudest voice.\n",
"\n",
"Theodore Roosevelt\n"
}; text x {
"Foreign Aid - taxing poor people in rich countries\n",
"for the benefit of rich people in poor countries.\n",
"\n",
"Bernard Rosenberg\n"
}; text x {
"A Bachelor of Arts is one who makes love to a lot of women\n",
"and yet has the art to remain a bachelor.\n",
"\n",
"Helen Rowland. American journalist\n"
}; text x {
"The saying that beauty is but skin deep is but a skin deep\n",
"saying.\n",
"\n",
"John Ruskin\n"
}; text x {
"A dress makes no sense\n",
"unless it inspires men to want to take it off you.\n",
"\n",
"Francoise Sagan\n"
}; text x {
"Skepticism, like chastity should not be relinquished too\n",
"readily.\n",
"\n",
"George Santayana\n"
}; text x {
"There's a difference between a philosophy and a bumper\n",
"sticker.\n",
"\n",
"Charles M. Schulz\n"
}; text x {
"The true worth of a man is not to be found in man himself,\n",
"but in the colours and textures that come alive in others.\n",
"\n",
"Albert Schweitzer\n"
}; text x {
"Life without the courage for death is slavery.\n",
"\n",
"Seneca\n"
}; text x {
"Sometimes even to live is an act of courage.\n",
"\n",
"Seneca\n"
}; text x {
"When I'm good, I'm very good, but when I'm bad, I'm even\n",
"better.\n",
"\n",
"Mae West\n"
}; text x {
"Brevity is the soul of wit.\n",
"\n",
"William Shakespeare\n"
}; text x {
"The fault, dear Brutus, is not in our stars\n",
"but in ourselves.\n",
"\n",
"William Shakespeare\n"
}; text x {
"My method is to take the utmost trouble\n",
"to find the right thing to say,\n",
"and then to say it with the utmost levity.\n",
"\n",
"George Bernard Shaw\n"
}; text x {
"Peace is not only better than war, but infinitely more\n",
"arduous.\n",
"\n",
"George Bernard Shaw\n"
}; text x {
"A government that robs Peter to pay Paul\n",
"can always depend upon the support of Paul.\n",
"\n",
"George Bernard Shaw\n"
}; text x {
"Every person who has mastered a profession is a skeptic\n",
"concerning it.\n",
"\n",
"George Bernard Shaw\n"
}; text x {
"Do not do unto others as you would that they should do unto\n",
"you. Their tastes may not be the same.\n",
"\n",
"George Bernard Shaw\n"
}; text x {
"Men have to do some awfully mean things\n",
"to keep up their respectability.\n",
"\n",
"George Bernard Shaw\n"
}; text x {
"Patriotism is your conviction that this country is superior\n",
"to all others because you were born in it.\n",
"\n",
"George Bernard Shaw\n"
}; text x {
"The fact that a believer is happier than a skeptic\n",
"is no more to the point than the fact than\n",
"a drunken man is happier than a sober one.\n",
"\n",
"George Bernard Shaw\n"
}; text x {
"It is dangerous to be sincere unless you are also stupid.\n",
"\n",
"George Bernard Shaw\n"
}; text x {
"Any event, once it has occurred,\n",
"can be made to appear inevitable by a competent historian.\n",
"\n",
"Lee Simonson\n"
}; text x {
"Woman's virtue is man's greatest invention.\n",
"\n",
"Cornelia Otis Skinner\n"
}; text x {
"It is the greatest of all mistakes to do nothing\n",
"because you can do only a little. Do what you can.\n",
"\n",
"Sydney Smith\n"
}; text x {
"The ability to accept responsibility is the measure of the\n",
"man.\n",
"\n",
"Roy L. Smith\n"
}; text x {
"Remember when we all wanted to look like Elizabeth Taylor?\n",
"Well, now I do.\n",
"\n",
"Carrie Snow\n"
}; text x {
"Science is the refusal to believe on the basis of hope.\n",
"\n",
"C.P. Snow\n"
}; text x {
"Once made equal to man, woman becomes his superior.\n",
"\n",
"Socrates\n"
}; text x {
"Wonder is the feeling of a philosopher,\n",
"and philosophy begins in wonder.\n",
"\n",
"Socrates\n"
}; text x {
"Time: That which man is always trying to kill,\n",
"but which ends in killing him.\n",
"\n",
"Herbert Spencer\n"
}; text x {
"Rest: Death after life.\n",
"\n",
"Edmund Spenser\n"
}; text x {
"If you want a thing well done, do it yourself.\n",
"Charles Haddon Spurgeon\n"
}; text x {
"Power, after love, is the first source of happiness.\n",
"\n",
"Stendhal\n"
}; text x {
"Man does not live by words alone,\n",
"despite the fact that sometimes he has to eat them.\n",
"\n",
"Adlai Stevenson\n"
}; text x {
"An editor is one who separates the wheat from the chaff\n",
"and prints the chaff.\n",
"\n",
"Adlai Stevenson\n"
}; text x {
"The moon may be smaller than Earth, but it's further away.\n"
}; text x {
"It is the business of little minds to shrink.\n",
"-- Carl Sandburg\n"
}; text x {
"(1) Everything depends.\n",
"(2) Nothing is always.\n",
"(3) Everything is sometimes.\n"
}; text x {
"Pecor's Health-Food Principle:\n",
"Never eat rutabaga on any day of the week that has a ""y""\n",
"in it.\n"
}; text x {
"""He's the kind of man for the times that need the kind of\n",
"man he is ...""\n"
}; text x {
"The optimum committee has no members.\n",
"-- Norman Augustine\n"
}; text x {
"LIBRA (Sept 23 - Oct 22)\n",
"You are the artistic type and have a difficult time with\n",
"reality. If you are a man, you are more than likely gay.\n",
"Chances for employment and monetary gains are excellent. Most\n",
"Libra women are prostitutes. All Libra people die of Venereal\n",
"disease.\n"
}; text x {
"A bird in the hand is worth what it will bring.\n"
}; text x {
"First Law of Socio-Genetics:\n",
"Celibacy is not hereditary.\n"
}; text x {
"The climate of Bombay is such that its inhabitants have to\n",
"live elsewhere.\n"
}; text x {
"Uncle Ed's Rule of Thumb:\n",
"Never use your thumb for a rule. You'll either hit it with a\n",
"hammer or get a splinter in it.\n"
}; text x {
"To be intoxicated is to feel sophisticated but not be able\n",
"to say it.\n"
}; text x {
"Aquadextrous, adj.:\n",
"Possessing the ability to turn the bathtub faucet on and off\n",
"with your toes.\n",
"\n",
"Rich Hall, ""Sniglets""\n"
}; text x {
"Impartial, adj.:\n",
"Unable to perceive any promise of personal advantage from\n",
"espousing either side of a controversy or adopting either of\n",
"two conflicting opinions.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"Critic, n.:\n",
"A person who boasts himself hard to please because nobody\n",
"tries to please him.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"Harrisberger's Fourth Law of the Lab:\n",
"\n",
"Experience is directly proportional to the amount of\n",
"equipment ruined.\n"
}; text x {
"Bell Labs Unix -- Reach out and grep someone.\n"
}; text x {
"Keep America beautiful. Swallow your beer cans.\n"
}; text x {
"A long-forgotten loved one will appear soon. Buy the\n",
"negatives at any price.\n"
}; text x {
"Miksch's Law:\n",
"If a string has one end, then it has another end.\n"
}; text x {
"""Earth is a great, big funhouse without the fun.""\n",
"\n",
"Jeff Berner\n"
}; text x {
"Don't be humble, you're not that great.\n",
"\n",
"Golda Meir\n"
}; text x {
"Etymology, n.:\n",
"Some early etymological scholars come up with\n",
"derivations that were hard for the public to believe. The\n",
"term ""etymology"" was formed from the Latin ""etus"" (""eaten""),\n",
"the root ""mal"" (""bad""), and ""logy"" (""study of""). It meant\n",
"""the study of things that are hard to swallow.""\n",
"\n",
"Mike Kellen\n"
}; text x {
"""I must have a prodigious quantity of mind; it takes me as\n",
"much as a week sometimes to make it up.""\n",
"\n",
"Mark Twain, ""The Innocents Abroad""\n"
}; text x {
"Do you realize how many holes there could be if people would\n",
"just take the time to take the dirt out of them?\n"
}; text x {
"A chubby man with a white beard and a red suit will approach\n",
"you soon. Avoid him. He's a Commie.\n"
}; text x {
"At a recent meeting in Snowmass, Colorado, a participant\n",
"from Los Angeles fainted from hyperoxygenation, and we had to\n",
"hold his head under the exhaust of a bus until he revived.\n"
}; text x {
"If ignorance is bliss, why aren't there more happy people?\n"
}; text x {
"""It's bad luck to be superstitious.""\n",
"\n",
"Andrew W. Mathis\n"
}; text x {
"You could get a new lease on life -- if only you didn't need\n",
"the first and last month in advance.\n"
}; text x {
"""If the King's English was good enough for Jesus, it's good\n",
"enough for me!""\n",
"-- ""Ma"" Ferguson, Governor of Texas (circa 1920)\n"
}; text x {
"Chisolm's First Corollary to Murphy's Second Law:\n",
"When things just can't possibly get any worse, they will.\n"
}; text x {
"Don't look back, the lemmings are gaining on you.\n"
}; text x {
"When two people are under the influence of the most violent,\n",
"most insane, most delusive, and most transient of passions,\n",
"they are required to swear that they will remain in that\n",
"excited, abnormal, and exhausting condition continuously\n",
"until death do them part. -- George Bernard Shaw\n"
}; text x {
"If anything can go wrong, it will.\n"
}; text x {
"You can't start worrying about what's going to happen. You\n",
"get spastic enough worrying about what's happening now.\n",
"\n",
"Lauren Bacall\n"
}; text x {
"I'm all for computer dating, but I wouldn't want one to\n",
"marry my sister.\n"
}; text x {
"Slick's Three Laws of the Universe:\n",
"1. Nothing in the known universe travels faster than a\n",
"bad check.\n",
"2. A quarter-ounce of chocolate = four pounds of fat.\n",
"3. There are two types of dirt: the dark kind, which is\n",
"attracted to light objects, and the light kind, which\n",
"is attracted to dark objects.\n"
}; text x {
"At Group L, Stoffel oversees six first-rate programmers, a\n",
"managerial challenge roughly comparable to herding cats.--\n",
"The Washington Post Magazine, June 9, 1985\n"
}; text x {
"If you're happy, you're successful.\n"
}; text x {
"Actor:""I'm a smash hit. Why, yesterday during the last act,\n",
"I had everyone glued in their seats!""\n",
"Oliver Herford: ""Wonderful! Wonderful! Clever of you to think\n",
"of it!""\n"
}; text x {
"Next to being shot at and missed, nothing is really quite as\n",
"satisfying as an income tax refund.\n",
"-- F. J. Raymond\n"
}; text x {
"f u cn rd ths, u cn gt a gd jb n cmptr prgrmmng.\n"
}; text x {
"The hardest thing in the world to understand is the income\n",
"tax.\n",
"\n",
"Albert Einstein\n"
}; text x {
"He looked at me as if I was a side dish he hadn't ordered.\n"
}; text x {
"""We don't care. We don't have to. We're the Phone Company.""\n"
}; text x {
"A CONS is an object which cares.\n",
"\n",
"Bernie Greenberg.\n"
}; text x {
"I like your game but we have to change the rules.\n"
}; text x {
"The more things change, the more they stay insane.\n"
}; text x {
"All programmers are playwrights and all computers are lousy\n",
"actors.\n"
}; text x {
"The English have no respect for their language, and will not\n",
"teach their children to speak it.\n",
"\n",
"G. B. Shaw\n"
}; text x {
"SCORPIO (Oct 23 - Nov 21)\n",
"You are shrewd in business and cannot be trusted. You will\n",
"achieve the pinnacle of success because of your total lack of\n",
"ethics. Most Scorpio people are murdered.\n"
}; text x {
"A countryman between two lawyers is like a fish between two\n",
"cats. -- Ben Franklin\n"
}; text x {
"""God gives burdens; also shoulders""\n"
}; text x {
"It is always preferable to visit home with a friend. Your\n",
"parents will not be pleased with this plan, because they want\n",
"you all to themselves and because in the presence of your\n",
"friend, they will have to act like mature human beings ...\n",
"\n",
"Playboy, January 1983\n"
}; text x {
"Ban the bomb. Save the world for conventional warfare.\n"
}; text x {
"Laugh at your problems; everybody else does.\n"
}; text x {
"Hofstadter's Law:\n",
"It always takes longer than you expect, even when you take\n",
"Hofstadter's Law into account.\n"
}; text x {
"Idiot, n.:\n",
"A member of a large and powerful tribe whose influence in\n",
"human affairs has always been dominant and controlling.--\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"Klein bottle for rent -- inquire within.\n"
}; text x {
"Nothing recedes like success.\n",
"\n",
"Walter Winchell\n"
}; text x {
"First Law of Procrastination:\n",
"Procrastination shortens the job and places the\n",
"responsibility for its termination on someone else\n",
"(i.e., the authority who imposed the deadline).\n"
}; text x {
"It seems like the less a statesman amounts to, the more he\n",
"loves the flag.\n"
}; text x {
"Love your enemies: they'll go crazy trying to figure out\n",
"what you're up to.\n"
}; text x {
"I don't believe in astrology. But then I'm an Aquarius, and\n",
"Aquarians don't believe in astrology.\n",
"\n",
"James R. F. Quirk\n"
}; text x {
"The marvels of today's modern technology include the\n",
"development of a soda can, when discarded will last forever\n",
"... and a $7,000 car which when properly cared for will rust\n",
"out in two or three years.\n"
}; text x {
"All the world's a stage and most of us are desperately\n",
"unrehearsed.\n",
"\n",
"Sean O'Casey\n"
}; text x {
"Receiving a million dollars tax free will make you feel\n",
"better than being flat broke and having a stomach ache.--\n",
"\n",
"Dolph Sharp, ""I'm O.K., You're Not So Hot""\n"
}; text x {
"Behold the warranty ... the bold print giveth and the fine\n",
"print taketh away.\n"
}; text x {
"""Why was I born with such contemporaries?""\n",
"\n",
"Oscar Wilde\n"
}; text x {
"Economics is extremely useful as a form of employment for\n",
"economists.\n",
"\n",
"John Kenneth Galbraith\n"
}; text x {
"Weinberg's Second Law:\n",
"If builders built buildings the way programmers wrote\n",
"programs, then the first woodpecker that came along would\n",
"destroy civilization.\n"
}; text x {
"I was gratified to be able to answer promptly, and I did. I\n",
"said I didn't know.\n",
"\n",
"Mark Twain\n"
}; text x {
"All true wisdom is found on T-shirts.\n"
}; text x {
"Nothing cures insomnia like the realization that it's time\n",
"to get up.\n"
}; text x {
"Measure with a micrometer. Mark with chalk. Cut with an axe.\n"
}; text x {
"Endless Loop: n., see Loop, Endless.\n",
"Loop, Endless: n., see Endless Loop.\n",
"\n",
"Random Shack Data Processing Dictionary\n"
}; text x {
"I can't complain, but sometimes I still do.\n",
"\n",
"Joe Walsh\n"
}; text x {
"That secret you've been guarding, isn't.\n"
}; text x {
"They spell it ""da Vinci"" and pronounce it ""da Vinchy"".\n",
"Foreigners always spell better than they pronounce.\n",
"\n",
"Mark Twain\n"
}; text x {
"""I'd love to go out with you, but I'm converting my calendar\n",
"watch from Julian to Gregorian.""\n"
}; text x {
"The moving cursor writes, and having written, blinks on.\n"
}; text x {
"In case of atomic attack, the federal ruling against prayer\n",
"in schools will be temporarily canceled.\n"
}; text x {
"If only one could get that wonderful feeling of\n",
"accomplishment without having to accomplish anything.\n"
}; text x {
"If it's Tuesday, this must be someone else's fortune.\n"
}; text x {
"San Francisco isn't what it used to be, and it never was. --\n",
"Herb Caen\n"
}; text x {
"Boob's Law:\n",
"You always find something in the last place you look.\n"
}; text x {
"While anyone can admit to themselves they were wrong, the\n",
"true test is admission to someone else.\n"
}; text x {
"Emersons' Law of Contrariness:\n",
"Our chief want in life is somebody who shall make us do what\n",
"we can. Having found them, we shall then hate them for it.\n"
}; text x {
"If God had intended Man to Smoke, He would have set him on\n",
"Fire.\n"
}; text x {
"Democracy is a form of government that substitutes election\n",
"by the incompetent many for appointment by the corrupt few.\n",
"\n",
"G.B. Shaw\n"
}; text x {
"It looks like blind screaming hedonism won out.\n"
}; text x {
"Garter, n.:\n",
"An elastic band intended to keep a woman from coming out of\n",
"her stockings and desolating the country.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"If you can't be good, be careful. If you can't be careful,\n",
"give me a call.\n"
}; text x {
"Think honk if you're a telepath.\n"
}; text x {
"Your life would be very empty if you had nothing to regret.\n"
}; text x {
"You've been leading a dog's life. Stay off the furniture.\n"
}; text x {
"Every man is as God made him, ay, and often worse.\n",
"-- Miguel de Cervantes\n"
}; text x {
"You're at the end of the road again.\n"
}; text x {
"There is something fascinating about science. One gets such\n",
"wholesale returns of conjecture out of such a trifling\n",
"investment of fact.\n",
"\n",
"Mark Twain\n"
}; text x {
"TAURUS (Apr 20 - May 20)\n",
"You are practical and persistent. You have a dogged\n",
"determination and work like hell. Most people think you are\n",
"stubborn and bull headed. You are a Communist.\n"
}; text x {
"Don't put off for tomorrow what you can do today, because if\n",
"you enjoy it today you can do it again tomorrow.\n"
}; text x {
"There is a great discovery still to be made in Literature:\n",
"that of paying literary men by the quantity they do NOT\n",
"write.\n"
}; text x {
"The human mind treats a new idea the way the body treats a\n",
"strange protein -- it rejects it.\n",
"\n",
"P. Medawar\n"
}; text x {
"I'd give my right arm to be ambidextrous.\n"
}; text x {
"Lieberman's Law:\n",
"Everybody lies, but it doesn't matter since nobody listens.\n"
}; text x {
"If I had a plantation in Georgia and a home in Hell, I'd\n",
"sell the plantation and go home.\n",
"-- Eugene P. Gallagher\n"
}; text x {
"Chicago, n.:\n",
"Where the dead still vote ... early and often!\n"
}; text x {
"Character Density: the number of very weird people in the\n",
"office.\n"
}; text x {
"A person is just about as big as the things that make them\n",
"angry.\n"
}; text x {
"Never call a man a fool. Borrow from him.\n"
}; text x {
"I believe in getting into hot water; it keeps you clean. --\n",
"G. K. Chesterton\n"
}; text x {
"Truthful, adj.:\n",
"Dumb and illiterate.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"God made the integers; all else is the work of Man.\n",
"\n",
"Kronecker\n"
}; text x {
"""A witty saying proves nothing.""\n",
"\n",
"Voltaire\n"
}; text x {
"The reason computer chips are so small is computers don't\n",
"eat much.\n"
}; text x {
"It's easier to get forgiveness for being wrong than\n",
"forgiveness for being right.\n"
}; text x {
"Life is a whim of several billion cells to be you for a\n",
"while.\n"
}; text x {
"Give me the Luxuries, and the Hell with the Necessities!\n"
}; text x {
"Zymurgy's Law of Volunteer Labor:\n",
"People are always available for work in the past tense.\n"
}; text x {
"It may be that your whole purpose in life is simply to serve\n",
"as a warning to others.\n"
}; text x {
"You can make it illegal, but you can't make it unpopular.\n"
}; text x {
"Immortality -- a fate worse than death.\n",
"-- Edgar A. Shoaff\n"
}; text x {
"Pig, n.:\n",
"An animal (Porcus omnivorous) closely allied to the human\n",
"race by the splendor and vivacity of its appetite, which,\n",
"however, is inferior in scope, for it balks at pig.\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"Genius, n.:\n",
"A chemist who discovers a laundry additive that rhymes with\n",
"""bright"".\n"
}; text x {
"Politics is like coaching a football team.  You have to be\n",
"smart enough to understand the game but not smart enough to\n",
"lose interest.\n"
}; text x {
"Gold, n.:\n",
"A soft malleable metal relatively scarce in distribution.\n",
"It is mined deep in the earth by poor men who then give it\n",
"to rich men who immediately bury it back in the earth in\n",
"great prisons, although gold hasn't done anything to them.\n",
"\n",
"Mike Harding, ""The Armchair Anarchist's Almanac""\n"
}; text x {
"Health is merely the slowest possible rate at which one can\n",
"die.\n"
}; text x {
"The nice thing about standards is that there are so many of\n",
"them to choose from.\n",
"\n",
"Andrew S. Tanenbaum\n"
}; text x {
"""Uncle Cosmo ... why do they call this a word processor?""\n",
"\n",
"""It's simple, Skyler ... you've seen what food processors do\n",
"to food, right?""\n",
"\n",
"MacNelley, ""Shoe""\n"
}; text x {
"Brady's First Law of Problem Solving:\n",
"When confronted by a difficult problem, you can solve it more\n",
"easily by reducing it to the question, ""How would the Lone\n",
"Ranger have handled this?""\n"
}; text x {
"What I want is all of the power and none of the\n",
"responsibility.\n"
}; text x {
"As soon as we started programming, we found to our surprise\n",
"that it wasn't as easy to get programs right as we had\n",
"thought. Debugging had to be discovered. I can remember the\n",
"exact instant when I realized that a large part of my life\n",
"from then on was going to be spent in finding mistakes in my\n",
"own programs.\n",
"\n",
"Maurice Wilkes discovers debugging, 1949\n"
}; text x {
"Important letters which contain no errors will develop\n",
"errors in the mail. Corresponding errors will show up in the\n",
"duplicate while the Boss is reading it.\n"
}; text x {
"No good deed goes unpunished.\n",
"-- Clare Boothe Luce\n"
}; text x {
"You can get more of what you want with a kind word and a gun\n",
"than you can with just a kind word.\n",
"\n",
"Bumper Sticker\n"
}; text x {
"Drew's Law of Highway Biology:\n",
"The first bug to hit a clean windshield lands directly in\n",
"front of your eyes.\n"
}; text x {
"Very few profundities can be expressed in less than 80\n",
"characters.\n"
}; text x {
"As Zeus said to Narcissus, ""Watch yourself.""\n"
}; text x {
"Talking much about oneself can also be a means to conceal\n",
"oneself.\n",
"\n",
"Friedrich Nietzsche\n"
}; text x {
"You're being followed. Cut out the hanky-panky for a few\n",
"days.\n"
}; text x {
"You can measure a programmer's perspective by noting his\n",
"attitude on the continuing viability of FORTRAN.\n",
"\n",
"Alan Perlis\n"
}; text x {
"Grandpa Charnock's Law:\n",
"You never really learn to swear until you learn to drive.\n"
}; text x {
"A rock pile ceases to be a rock pile the moment a single man\n",
"contemplates it, bearing within him the image of a cathedral.\n",
"\n",
"Antoine de Saint-Exupery\n"
}; text x {
"If you're not very clever you should be conciliatory.\n",
"Benjamin Disraeli\n"
}; text x {
"When you have shot and killed a man you have in some measure\n",
"clarified your attitude toward him. You have given a definite\n",
"answer to a definite problem. For better or worse you have\n",
"acted decisively. In a way, the next move is up to him.\n",
"\n",
"R. A. Lafferty\n"
}; text x {
"He who Laughs, Lasts.\n"
}; text x {
"No one can make you feel inferior without your consent.\n",
"\n",
"Eleanor Roosevelt\n"
}; text x {
"Never eat more than you can lift.\n",
"\n",
"Miss Piggy\n"
}; text x {
"Numeric stability is probably not all that important when\n",
"you're guessing.\n"
}; text x {
"A fool must now and then be right by chance.\n"
}; text x {
"You should never wear your best trousers when you go out to\n",
"fight for freedom and liberty.\n",
"\n",
"Henrick Ibson\n"
}; text x {
"Manual, n.:\n",
"A unit of documentation. There are always three or more on a\n",
"given item. One is on the shelf; someone has the others. The\n",
"information you need in in the others.\n",
"Ray Simard\n"
}; text x {
"If money can't buy happiness, I guess you'll just have to\n",
"rent it.\n"
}; text x {
"Cocaine -- the thinking man's Dristan.\n"
}; text x {
"Nothing takes the taste out of peanut butter quite like\n",
"unrequited love.\n",
"\n",
"Charlie Brown\n"
}; text x {
"Tax reform means ""Don't tax you, don't tax me, tax that\n",
"fellow behind the tree.""\n",
"Russell Long\n"
}; text x {
"As long as war is regarded as wicked, it will always have\n",
"its fascination. When it is looked upon as vulgar, it will\n",
"cease to be popular.\n",
"\n",
"Oscar Wilde\n"
}; text x {
"Good night to spend with family, but avoid arguments with\n",
"your mate's new lover.\n"
}; text x {
"There is no realizable power that man cannot, in time,\n",
"fashion the tools to attain, nor any power so secure that the\n",
"naked ape will not abuse it. So it is written in the genetic\n",
"cards -- only physics and war hold him in check. And also the\n",
"wife who wants him home by five, of course.\n",
"\n",
"Encyclopadia Apocryphia, 1990 ed.\n"
}; text x {
"It is better to kiss an avocado than to get in a fight with\n",
"an aardvark\n"
}; text x {
"Fudd's First Law of Opposition:\n",
"\n",
"Push something hard enough and it will fall over.\n"
}; text x {
"It was a book to kill time for those who liked it better\n",
"dead.\n"
}; text x {
"The fact that it works is immaterial.\n",
"\n",
"L. Ogborn\n"
}; text x {
"ADA, n.:\n",
"Something you need only know the name of to be an Expert in\n",
"Computing. Useful in sentences like, ""We had better\n",
"develop an ADA awareness.""\n"
}; text x {
"Mosher's Law of Software Engineering:\n",
"Don't worry if it doesn't work right. If everything did,\n",
"you'd be out of a job.\n"
}; text x {
"Overload -- core meltdown sequence initiated.\n"
}; text x {
"Confidence is the feeling you have before you understand the\n",
"situation.\n"
}; text x {
"If you think nobody cares if you're alive, try missing a\n",
"couple of car payments.\n",
"Earl Wilson\n"
}; text x {
"Be a better psychiatrist and the world will beat a\n",
"psychopath to your door.\n"
}; text x {
"What does it mean if there is no fortune for you?\n"
}; text x {
"""Die? I should say not, dear fellow. No Barrymore would\n",
"allow such a conventional thing to happen to him.""\n",
"\n",
"John Barrymore's dying words\n"
}; text x {
"Real Programmers think better when playing Adventure or\n",
"Rogue.\n"
}; text x {
"What I tell you three times is true.\n"
}; text x {
"A door is what a dog is perpetually on the wrong side of.\n",
"\n",
"Ogden Nash\n"
}; text x {
"Ten years of rejection slips is nature's way of telling you\n",
"to stop writing.\n",
"\n",
"R. Geis\n"
}; text x {
"Everything you know is wrong!\n"
}; text x {
"""Now is the time for all good men to come to.""\n",
"Walt Kelly\n"
}; text x {
"Mr. Cole's Axiom:\n",
"The sum of the intelligence on the planet is a constant; the\n",
"population is growing.\n"
}; text x {
"If you can lead it to water and force it to drink, it isn't\n",
"a horse.\n"
}; text x {
"Hoare's Law of Large Problems:\n",
"Inside every large problem is a small problem struggling to\n",
"get out.\n"
}; text x {
"A language that doesn't have everything is actually easier\n",
"to program in than some that do.\n",
"Dennis M. Ritchie\n"
}; text x {
"The Abrams' Principle:\n",
"The shortest distance between two points is off the wall.\n"
}; text x {
"... The Anarchists' [national] anthem is an international\n",
"anthem that consists of 365 raspberries blown in very quick\n",
"succession to the tune of ""Camptown Races"". Nobody has to\n",
"stand up for it, nobody has to listen to it, and, even\n",
"better, nobody has to play it.\n",
"Mike Harding, ""The Armchair Anarchist's Almanac""\n"
}; text x {
"What this country needs is a good five cent ANYTHING!\n"
}; text x {
"The herd instinct among economists makes sheep look like\n",
"independent thinkers.\n"
}; text x {
"Kin, n.:\n",
"An affliction of the blood\n"
}; text x {
"God made machine language; all the rest is the work of man.\n"
}; text x {
"Go placidly amid the noise and waste, and remember what\n",
"value there may be in owning a piece thereof.\n",
"\n",
"National Lampoon, ""Deteriorada""\n"
}; text x {
"Anything that is good and useful is made of chocolate.\n"
}; text x {
"Bringing computers into the home won't change either one,\n",
"but may revitalize the corner saloon.\n"
}; text x {
"Optimization hinders evolution.\n"
}; text x {
"Some points to remember [about animals]:\n",
"\n",
"1. Don't go to sleep under big animals, e.g., elephants,\n",
"rhinoceri, hippopotamuses;\n",
"2. Don't put animals with sharp teeth or poisonous fangs down\n",
"the front of your clothes;\n",
"3. Don't pat certain animals, e.g., crocodiles and\n",
"scorpions ordogs you have just kicked.\n",
"Mike Harding, ""The Armchair Anarchist's Almanac""\n"
}; text x {
"Bradley's Bromide:\n",
"If computers get too powerful, we can organize them into\n",
"a committee -- that will do them in.\n"
}; text x {
"Egotist, n.:\n",
"A person of low taste, more interested in himself than me.\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"When a place gets crowded enough to require ID's, social\n",
"collapse is not far away. It is time to go elsewhere. The\n",
"best thing about space travel is that it made it possible to\n",
"go elsewhere.\n",
"Robert Heinlein\n"
}; text x {
"PISCES (Feb. 19 to Mar. 20)\n",
"Take the high road, look for the good things, carry the\n",
"American Express card and a weapon. The world is yours\n",
"today, as nobody else wants it. Your mortgage will be\n",
"foreclosed. You will probably get run over by a bus.\n"
}; text x {
"There's no real need to do housework -- after four years it\n",
"doesn't get any worse.\n"
}; text x {
"You may be recognized soon. Hide.\n"
}; text x {
"Show me a man who is a good loser and I'll show you a man\n",
"who is playing golf with his boss.\n"
}; text x {
"A closed mouth gathers no foot.\n"
}; text x {
"If someone had told me I would be Pope one day, I would have\n",
"studied harder.\n",
"\n",
"Pope John Paul I\n"
}; text x {
"""That must be wonderful! I don't understand it at all.""\n"
}; text x {
"Watson's Law:\n",
"The reliability of machinery is inversely proportional to\n",
"the number and significance of any persons watching it.\n"
}; text x {
"Everybody is somebody else's weirdo.\n",
"Dykstra\n"
}; text x {
"O give me a home,\n",
"Where the buffalo roam,\n",
"Where the deer and the antelope play,\n",
"Where seldom is heard\n",
"A discouraging word,\n",
"'Cause what can an antelope say?\n"
}; text x {
"There are very few personal problems that cannot be solved\n",
"through a suitable application of high explosives.\n"
}; text x {
"Parkinson's Fourth Law:\n",
"The number of people in any working group tends to increase\n",
"regardless of the amount of work to be done.\n"
}; text x {
"""You'll never be the man your mother was!""\n"
}; text x {
"The correct way to punctuate a sentence that starts: ""Of\n",
"course it is none of my business, but --"" is to place a\n",
"period after the word ""but."" Don't use excessive force in\n",
"supplying such a moron with a period. Cutting his throat is\n",
"only a momentary pleasure and is bound to get you talked\n",
"about.\n",
"Lazarus Long, ""Time Enough for Love""\n"
}; text x {
"Drive defensively. Buy a tank.\n"
}; text x {
"Actor: So what do you do for a living?\n",
"Doris:  I work for a company that makes deceptively shallow\n",
"serving dishes for Chinese restaurants.\n",
"Woody Allen, ""Without Feathers""\n"
}; text x {
"The computing field is always in need of new cliches.\n",
"Alan Perlis\n"
}; text x {
"Left to themselves, things tend to go from bad to worse.\n"
}; text x {
"Commitment, n.:\n",
"Commitment can be illustrated by a breakfast of ham and eggs.\n",
"The chicken was involved, the pig was committed.\n"
}; text x {
"Don't hate yourself in the morning -- sleep till noon.\n"
}; text x {
"The problem with people who have no vices is that generally\n",
"you can be pretty sure they're going to have some pretty\n",
"annoying virtues.\n",
"\n",
"Elizabeth Taylor\n"
}; text x {
"""Benson, you are so free of the ravages of intelligence""\n",
"\n",
"Time Bandits\n"
}; text x {
"Good news is just life's way of keeping you off balance.\n"
}; text x {
"Horse sense is the thing a horse has which keeps it from\n",
"betting on people.\n",
"\n",
"W. C. Fields\n"
}; text x {
"When I was in school, I cheated on my metaphysics exam: I\n",
"looked into the soul of the boy sitting next to me.\n",
"\n",
"Woody Allen\n"
}; text x {
"A total abstainer is one who abstains from everything but\n",
"abstention, and especially from inactivity in the affairs of\n",
"others.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"The individual choice of garnishment of a burger can be an\n",
"important point to the consumer in this day when\n",
"individualism is an increasingly important thing to people.\n",
"Donald N. Smith, president of Burger King\n"
}; text x {
"Carelessly planned projects take three times longer to\n",
"complete than expected. Carefully planned projects take four\n",
"times longer to complete than expected, mostly because the\n",
"planners expect their planning to reduce the time it takes.\n"
}; text x {
"SOFTWARE -- formal evening attire for female computer\n",
"analysts.\n"
}; text x {
"""My weight is perfect for my height -- which varies""\n"
}; text x {
"She is not refined. She is not unrefined. She keeps a\n",
"parrot.\n",
"\n",
"Mark Twain\n"
}; text x {
"Don't cook tonight -- starve a rat today!\n"
}; text x {
"Grelb's Reminder:\n",
"\n",
"Eighty percent of all people consider themselves to be above\n",
"average drivers.\n"
}; text x {
"We've sent a man to the moon, and that's 29,000 miles away.\n",
"The center of the Earth is only 4,000 miles away. You could\n",
"drive that in a week, but for some reason nobody's ever done\n",
"it.\n",
"\n",
"Andy Rooney\n"
}; text x {
"Perfect day for scrubbing the floor and other exciting\n",
"things.\n"
}; text x {
"Do what comes naturally now. Seethe and fume and throw a\n",
"tantrum.\n"
}; text x {
"The first duty of a revolutionary is to get away with it.\n",
"\n",
"Abbie Hoffman\n"
}; text x {
"Dimensions will always be expressed in the least usable\n",
"term. Velocity, for example, will be expressed in furlongs\n",
"per fortnight.\n"
}; text x {
"God did not create the world in 7 days; he screwed around\n",
"for 6 days and then pulled an all-nighter.\n"
}; text x {
"That woman speaks eight languages and can't say ""no"" in any\n",
"of them.\n",
"\n",
"Dorothy Parker\n"
}; text x {
"""Calling J-Man Kink. Calling J-Man Kink. Hash missle\n",
"sighted, target Los Angeles. Disregard personal feelings\n",
"about city and intercept.""\n"
}; text x {
"I dread success. To have succeeded is to have finished one's\n",
"business on earth, like the male spider, who is killed by the\n",
"female the moment he has succeeded in his courtship. I like\n",
"a state of continual becoming, with a goal in front and not\n",
"behind.\n",
"\n",
"George Bernard Shaw\n"
}; text x {
"You don't sew with a fork, so I see no reason to eat with\n",
"knitting needles.\n",
"\n",
"Miss Piggy, on eating Chinese Food\n"
}; text x {
"Collaboration, n.:\n",
"A literary partnership based on the false assumption that the\n",
"other fellow can spell.\n"
}; text x {
"How much does it cost to entice a dope-smoking UNIX system\n",
"guru to Dayton?\n",
"Brian Boyle, UNIX/WORLD's First Annual Salary Survey\n"
}; text x {
"Whenever I hear anyone arguing for slavery, I feel a strong\n",
"impulse to see it tried on him personally.\n",
"A. Lincoln\n"
}; text x {
"As far as the laws of mathematics refer to reality, they are\n",
"not certain; and as far as they are certain, they do not\n",
"refer to reality.\n",
"\n",
"Albert Einstein\n"
}; text x {
"The difference between science and the fuzzy subjects is\n",
"that science requires reasoning while those other subjects\n",
"merely require scholarship.\n",
"\n",
"Robert Heinlein\n"
}; text x {
"Whom computers would destroy, they must first drive mad.\n"
}; text x {
"Non-Reciprocal Laws of Expectations:\n",
"Negative expectations yield negative results.\n",
"Positive expectations yield negative results.\n"
}; text x {
"Harris's Lament:\n",
"All the good ones are taken.\n"
}; text x {
"CANCER (June 21 - July 22)\n",
"You are sympathetic and understanding to other people's\n",
"problems. They think you are a sucker. You are always putting\n",
"things off. That's why you'll never make anything of\n",
"yourself. Most welfare recipients are Cancer people.\n"
}; text x {
"Krogt, n. (chemical symbol: Kr):\n",
"The metallic silver coating found on fast-food game cards. --\n",
"Rich Hall, ""Sniglets""\n"
}; text x {
"To iterate is human, to recurse, divine.\n"
}; text x {
"If God had intended Man to Walk, He would have given him\n",
"Feet.\n"
}; text x {
"What if everything is an illusion and nothing exists? In\n",
"that case, I definitely overpaid for my carpet.\n",
"\n",
"Woody Allen, ""Without Feathers""\n"
}; text x {
"Real Programmers don't write in PL/I. PL/I is for\n",
"programmers who can't decide whether to write in COBOL or\n",
"FORTRAN.\n"
}; text x {
"Talk sense to a fool and he calls you foolish.\n",
"Euripides\n"
}; text x {
"An American's a person who isn't afraid to criticize the\n",
"President but is always polite to traffic cops.\n"
}; text x {
"Mencken and Nathan's Ninth Law of The Average American: The\n",
"quality of a champagne is judged by the amount of noise the\n",
"cork makes when it is popped.\n"
}; text x {
"Graduate life -- it's not just a job, it's an indenture.\n"
}; text x {
"Philogyny recapitulates erogeny; erogeny recapitulates\n",
"philogyny.\n"
}; text x {
"A fool-proof method for sculpting an elephant: first, get a\n",
"huge block of marble; then you chip away everything that\n",
"doesn't look like an elephant.\n"
}; text x {
"A professor is one who talks in someone else's sleep.\n"
}; text x {
"Any clod can have the facts, but having opinions is an art.-\n",
"\n",
"Charles McCabe\n"
}; text x {
"Hlade's Law:\n",
"If you have a difficult task, give it to a lazy person --\n",
"they will find an easier way to do it.\n"
}; text x {
"If only I could be respected without having to be\n",
"respectable.\n"
}; text x {
"Real Programs don't use shared text. Otherwise, how can they\n",
"use functions for scratch space after they are finished\n",
"calling them?\n"
}; text x {
"Cleanliness is next to impossible.\n"
}; text x {
"May Euell Gibbons eat your only copy of the manual!\n"
}; text x {
"With a rubber duck, one's never alone.\n",
"\n",
"""The Hitchhiker's Guide to the Galaxy""\n"
}; text x {
"There is no time like the present for postponing what you\n",
"ought to be doing.\n"
}; text x {
"Law of Communications:\n",
"The inevitable result of improved and enlarged\n",
"communications between different levels in a hierarchy is a\n",
"vastly increased area of misunderstanding.\n"
}; text x {
"The Ruffed Pandanga of Borneo and Rotherham spreads out his\n",
"feathers in his courtship dance and imitates Winston\n",
"Churchill and Tommy Cooper on one leg. The padanga is dying\n",
"out because the female padanga doesn't take it too\n",
"seriously.\n",
"\n",
"Mike Harding, ""The Armchair Anarchist's Almanac""\n"
}; text x {
"Taxes, n.:\n",
"Of life's two certainties, the only one for which you can get\n",
"an extension.\n"
}; text x {
"Paul's Law:\n",
"In America, it's not how much an item costs, it's how much\n",
"you save.\n"
}; text x {
"If only God would give me some clear sign! Like making a\n",
"large deposit in my name at a Swiss bank.\n",
"\n",
"Woody Allen, ""Without Feathers""\n"
}; text x {
"Birth, n.:\n",
"The first and direst of all disasters.\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"The best book on programming for the layman is ""Alice in\n",
"Wonderland""; but that's because it's the best book on\n",
"anything for the layman.\n"
}; text x {
"At the source of every error which is blamed on the computer\n",
"you will find at least two human errors, including the error\n",
"of blaming it on the computer.\n"
}; text x {
"Goto, n.:\n",
"A programming tool that exists to allow structured\n",
"programmers to complain about unstructured programmers.\n",
"\n",
"Ray Simard\n"
}; text x {
"In English, every word can be verbed. Would that it were so\n",
"in our programming languages.\n"
}; text x {
"There are three ways to get something done:\n",
"1. Do it yourself.\n",
"2. Hire someone to do it for you.\n",
"3. Forbid your kids to do it.\n"
}; text x {
"Teamwork is essential -- it allows you to blame someone\n",
"else.\n"
}; text x {
"A budget is just a method of worrying before you spend\n",
"money, as well as afterward.\n"
}; text x {
"""There was a boy called Eustace Clarence Scrubb, and he\n",
"almost deserved it.""\n",
"C. S. Lewis, The Chronicles of Narnia\n"
}; text x {
"A computer, to print out a fact,\n",
"Will divide, multiply, and subtract.\n",
"But this output can be\n",
"No more than debris,\n",
"If the input was short of exact.\n",
"\n",
"Gigo\n"
}; text x {
"Eggnog is a traditional holiday drink invented by the\n",
"English. Many people wonder where the word ""eggnog"" comes\n",
"from. The first syllable comes from the English word ""egg"",\n",
"meaning ""egg"". I don't know where the ""nog"" comes from.\n",
"\n",
"To make eggnog, you'll need rum, whiskey, wine gin and, if\n",
"they are in season, eggs...\n"
}; text x {
"""We have reason to believe that man first walked upright to\n",
"free his hands for masturbation.""\n",
"\n",
"Lily Tomlin\n"
}; text x {
"Mother told me to be good, but she's been wrong before.\n"
}; text x {
"Schapiro's Explanation:\n",
"The grass is always greener on the other side -- but\n",
"that's because they use more manure.\n"
}; text x {
"Abandon the search for Truth; settle for a good fantasy.\n"
}; text x {
"I like being single. I'm always there when I need me.\n",
"\n",
"Art Leo\n"
}; text x {
"Experience is what causes a person to make new mistakes\n",
"instead of old ones.\n"
}; text x {
"The lion and the calf shall lie down together but the calf\n",
"won't get much sleep.\n",
"\n",
"Woody Allen\n"
}; text x {
"Good day for a change of scene. Repaper the bedroom wall.\n"
}; text x {
"There's no future in time travel.\n"
}; text x {
"One way to stop a runaway horse is to bet on him.\n"
}; text x {
"It's lucky you're going so slowly, because you're going in\n",
"the wrong direction.\n"
}; text x {
"GEMINI (May 21 to Jun. 20)\n",
"Good news and bad news highlighted. Enjoy the good news while\n",
"you can; the bad news will make you forget it. You will enjoy\n",
"praise and respect from those around you; everybody loves\n",
"a sucker. A short trip is in the stars, possibly to the\n",
"men's room.\n"
}; text x {
"Hardware, n.:\n",
"The parts of a computer system that can be kicked.\n"
}; text x {
"For an idea to be fashionable is ominous, since it must\n",
"afterwards be always old-fashioned.\n"
}; text x {
"Try not to have a good time ... This is supposed to be\n",
"educational.\n",
"\n",
"Charles Schulz\n"
}; text x {
"This life is a test. It is only a test. Had this been an\n",
"actual life, you would have received further instructions as\n",
"to what to do and where to go.\n"
}; text x {
"Kleptomaniac, n.: A rich thief.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"Mistakes are often the stepping stones to utter failure.\n"
}; text x {
"... And malt does more than Milton can\n",
"To justify God's ways to man\n",
"\n",
"A. E. Housman\n"
}; text x {
"... if forced to travel on an airplane, try and get in the\n",
"cabin with the Captain, so you can keep an eye on him and\n",
"nudge him if he falls asleep or point out any mountains\n",
"looming up ahead ...\n",
"\n",
"Mike Harding, ""The Armchair Anarchist's Almanac""\n"
}; text x {
"A recent study has found that concentrating on difficult\n",
"off-screen objects, such as the faces of loved ones, causes\n",
"eye strain in computer scientists. Researchers into the\n",
"phenomenon cite the added concentration needed to ""make\n",
"sense"" of such unnatural three dimensional objects ...\n"
}; text x {
"Colvard's Logical Premises:\n",
"All probabilities are 50%. Either a thing will happen or it\n",
"won't.\n",
"Colvard's Unconscionable Commentary:\n",
"This is especially true when dealing with someone you're\n",
"attracted to.\n",
"Grelb's Commentary\n",
"Likelihoods, however, are 90% against you.\n"
}; text x {
"Teach children to be polite and courteous in the home, and,\n",
"when he grows up, he will never be able to edge his car onto\n",
"a freeway.\n"
}; text x {
"The only way to get rid of a temptation is to yield to it.\n",
"\n",
"Oscar Wilde\n"
}; text x {
"Stult's Report:\n",
"Our problems are mostly behind us. What we have to do now\n",
"is fight the solutions.\n"
}; text x {
"When a fly lands on the ceiling, does it do a half roll or\n",
"a half loop?\n"
}; text x {
"Political T.V. commercials prove one thing: some candidates\n",
"can tell all their good points and qualifications in just 30\n",
"seconds.\n"
}; text x {
"The world is coming to an end. Please log off.\n"
}; text x {
"The Official MBA Handbook on business cards:\n",
"\n",
"Avoid overly pretentious job titles such as ""Lord of the\n",
"Realm, Defender of the Faith, Emperor of India"" or\n",
"""Director of Corporate Planning.""\n"
}; text x {
"Any sufficiently advanced technology is indistinguishable\n",
"from a rigged demo.\n"
}; text x {
"People who claim they don't let little things bother them\n",
"have never slept in a room with a single mosquito.\n"
}; text x {
"May a Misguided Platypus lay its Eggs in your Jockey Shorts\n"
}; text x {
"Substitute ""damn"" every time you're inclined to write\n",
"""very""; your editor will delete it and the writing will be\n",
"just as it should be.\n",
"\n",
"Mark Twain\n"
}; text x {
"If all else fails, immortality can always be assured by\n",
"spectacular error.\n",
"\n",
"John Kenneth Galbraith\n"
}; text x {
"Hurewitz's Memory Principle:\n",
"The chance of forgetting something is directly\n",
"proportional to ..... to ........ uh ..............\n"
}; text x {
"Never drink coke in a moving elevator. The elevator's motion\n",
"coupled with the chemicals in coke produce hallucinations.\n",
"People tend to change into lizards and attack without\n",
"warning, and large bats usually fly in the window.\n",
"Additionally, you begin to believe that elevators have\n",
"windows.\n"
}; text x {
"The probability of someone watching you is proportional to\n",
"the stupidity of your action.\n"
}; text x {
"Insanity is hereditary. You get it from your kids.\n"
}; text x {
"Have you ever noticed that the people who are always trying\n",
"to tell you, ""There's a time for work and a time for play,""\n",
"never find the time for play?\n"
}; text x {
"Bug:\n",
"Small living things that small living boys throw on small\n",
"living girls.\n"
}; text x {
"It is said that the lonely eagle flies to the mountain peaks\n",
"while the lowly ant crawls the ground, but cannot the soul of\n",
"the ant soar as high as the eagle?\n"
}; text x {
"Spark's Sixth Rule for Managers:\n",
"If a subordinate asks you a pertinent question, look at him\n",
"as if he had lost his senses. When he looks down, paraphrase\n",
"the question back at him.\n"
}; text x {
"Q: Why do mountain climbers rope themselves together?\n",
"A:To prevent the sensible ones from going home.\n"
}; text x {
"Insanity is the final defense ... It's hard to get a refund\n",
"when the salesman is sniffing your crotch and baying at the\n",
"moon.\n"
}; text x {
"Try to be the best of whatever you are, even if what you are\n",
"is no good.\n"
}; text x {
"""Why be a man when you can be a success?""\n",
"\n",
"Bertold Brecht\n"
}; text x {
"A celebrity is a person who is known for his well-knownness.\n"
}; text x {
"If a listener nods his head when you're explaining your\n",
"program, wake him up.\n"
}; text x {
"On Monday mornings I am dedicated to the proposition that\n",
"all men are created jerks.\n",
"\n",
"H. Allen Smith, ""Let the Crabgrass Grow""\n"
}; text x {
"Genius may have its limitations, but stupidity is not thus\n",
"handicapped.\n",
"\n",
"Elbert Hubbard\n"
}; text x {
"The years of peak mental activity are undoubtedly between\n",
"the ages of four and eighteen. At four we know all the\n",
"questions, at eighteen all the answers.\n"
}; text x {
"Bagdikian's Observation:\n",
"Trying to be a first-rate reporter on the average\n",
"American newspaper is like trying to play Bach's ""St.\n",
"Matthew Passion"" on a ukelele.\n"
}; text x {
"A language that doesn't affect the way you think about\n",
"programming is not worth knowing.\n"
}; text x {
"The earth is like a tiny grain of sand, only much, much\n",
"heavier.\n"
}; text x {
"Pretend to spank me -- I'm a pseudo-masochist!\n"
}; text x {
"Organic chemistry is the chemistry of carbon compounds.\n",
"Biochemistry is the study of carbon compounds that crawl.\n",
"\n",
"Mike Adams\n"
}; text x {
"When the government bureau's remedies do not match your\n",
"problem, you modify the problem, not the remedy.\n"
}; text x {
"Our policy is, when in doubt, do the right thing.\n",
"\n",
"Roy L. Ash, ex-president Litton Industries\n"
}; text x {
"A large number of installed systems work by fiat. That is,\n",
"they work by being declared to work.\n",
"\n",
"Anatol Holt\n"
}; text x {
"I am ready to meet my Maker. Whether my Maker is prepared\n",
"for the great ordeal of meeting me is another matter.\n",
"\n",
"Winston Churchill\n"
}; text x {
"An Englishman never enjoys himself, except for a noble\n",
"purpose.\n",
"\n",
"A. P. Herbert\n"
}; text x {
"Bubble Memory, n.:\n",
"A derogatory term, usually referring to a person's\n",
"intelligence. See also ""vacuum tube"".\n"
}; text x {
"ARIES (Mar 21 - Apr 19)\n",
"You are the pioneer type and hold most people in contempt.\n",
"You are quick tempered, impatient, and scornful of advice.\n",
"You are not very nice.\n"
}; text x {
"Life is like an onion: you peel off layer after layer, then\n",
"you find there is nothing in it.\n"
}; text x {
"Don't kiss an elephant on the lips today.\n"
}; text x {
"A successful tool is one that was used to do something\n",
"undreamed of by its author.\n",
"-- S. C. Johnson\n"
}; text x {
"Take your dying with some seriousness, however. Laughing on\n",
"the way to your execution is not generally understood by less\n",
"advanced life forms, and they'll call you crazy.\n",
"\n",
"""Messiah's Handbook: Reminders for the Advanced Soul""\n"
}; text x {
"Brain, v. [as in ""to brain""]:\n",
"To rebuke bluntly, but not pointedly; to dispel a source of\n",
"error in an opponent.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"Winter is the season in which people try to keep the house\n",
"as warm as it was in the summer, when they complained about\n",
"the heat.\n"
}; text x {
"Bizarreness is the essence of the exotic\n"
}; text x {
"""You know, it's at times like this when I'm trapped in a\n",
"Vogon airlock with a man from Betelgeuse and about to die of\n",
"asphyxiation in deep space that I really wish I'd listened to\n",
"what my mother told me when I was young!""\n",
"""Why, what did she tell you?""\n",
"""I don't know, I didn't listen!""\n",
"Douglas Adams, ""Hitchhiker's Guide to the Galaxy""\n"
}; text x {
"Angels we have heard on High\n",
"Tell us to go out and Buy.\n",
"\n",
"Tom Leher\n"
}; text x {
"A straw vote only shows which way the hot air blows.\n",
"\n",
"O'Henry\n"
}; text x {
"VIRGO (Aug 23 - Sept 22)\n",
"Learn something new today, like how to spell or how to count\n",
"to ten without using your fingers. Be careful dressing this\n",
"morning. You may be hit by a car later in the day and you\n",
"wouldn't want to be taken to the doctor's office in some of\n",
"that old underwear you own.\n"
}; text x {
"There are some micro-organisms that exhibit characteristics\n",
"of both plants and animals. When exposed to light they\n",
"undergo photosynthesis; and when the lights go out, they turn\n",
"into animals. But then again, don't we all?\n"
}; text x {
"Due to circumstances beyond your control, you are master of\n",
"your fate and captain of your soul.\n"
}; text x {
"Think twice before speaking, but don't say ""think think\n",
"click click"".\n"
}; text x {
"A disciple of another sect once came to Drescher as he was\n",
"eating his morning meal. ""I would like to give you this\n",
"personality test"", said the outsider, ""because I want you to\n",
"be happy."" Drescher took the paper that was offered him and\n",
"put it into the toaster -- ""I wish the toaster to be happy\n",
"too"".\n"
}; text x {
"If you only have a hammer, you tend to see every problem as\n",
"a nail.-- Maslow\n"
}; text x {
"Everything you've learned in school as ""obvious"" becomes\n",
"less and less obvious as you begin to study the universe. For\n",
"example, there are no solids in the universe. There's not\n",
"even a suggestion of a solid. There are no absolute\n",
"continuums. There are no surfaces. There are no straight\n",
"lines.\n",
"\n",
"R. Buckminster Fuller\n"
}; text x {
"The past always looks better than it was. It's only pleasant\n",
"because it isn't here.\n",
"\n",
"Finley Peter Dunne (Mr. Dooley)\n"
}; text x {
"The Schwine-Kitzenger Institute study of 47 men over the age\n",
"of 100 showed that all had these things in common:\n",
"\n",
"1. They all had moderate appetites.\n",
"2. They all came from middle class homes\n",
"3. All but two of them were dead.\n"
}; text x {
"Brook's Law:\n",
"Adding manpower to a late software project makes it later.\n"
}; text x {
"Anytime things appear to be going better, you have\n",
"overlooked something.\n"
}; text x {
"Shaw's Principle:\n",
"Build a system that even a fool can use, and only a fool will\n",
"want to use it.\n"
}; text x {
"Be careful of reading health books, you might die of a\n",
"misprint.\n",
"\n",
"Mark Twain\n"
}; text x {
"In the force if Yoda's so strong, construct a sentence with\n",
"words in the proper order then why can't he?\n"
}; text x {
"Skinner's Constant (or Flannagan's Finagling Factor):\n",
"That quantity which, when multiplied by, divided by, added\n",
"to, or subtracted from the answer you get, gives you the\n",
"answer you should have gotten.\n"
}; text x {
"Disco is to music what Etch-A-Sketch is to art.\n"
}; text x {
"What good is having someone who can walk on water if you\n",
"don't follow in his footsteps?\n"
}; text x {
"Worst Vegetable of the Year:\n",
"The brussels sprout. This is also the worst vegetable of next\n",
"year.\n",
"Steve Rubenstein\n"
}; text x {
"... Had this been an actual emergency, we would have fled in\n",
"terror, and you would not have been informed.\n"
}; text x {
"Overdrawn? But I still have checks left!\n"
}; text x {
"Never offend people with style when you can offend them with\n",
"substance.\n",
"Sam Brown, ""The Washington Post"", January 26, 1977\n"
}; text x {
"Nondeterminism means never having to say you are wrong.\n"
}; text x {
"Brooke's Law:\n",
"Whenever a system becomes completely defined, some damn fool\n",
"discovers something which either abolishes the system or\n",
"expands it beyond recognition.\n"
}; text x {
"Flon's Law:\n",
"There is not now, and never will be, a language in which it\n",
"is the least bit difficult to write bad programs.\n"
}; text x {
"Preudhomme's Law of Window Cleaning:\n",
"It's on the other side.\n"
}; text x {
"The meek shall inherit the earth -- they are too weak to\n",
"refuse.\n"
}; text x {
"There is no distinctly native American criminal class except\n",
"Congress.\n",
"\n",
"Mark Twain\n"
}; text x {
"If you're not part of the solution, you're part of the\n",
"precipitate.\n"
}; text x {
"Love is sentimental measles.\n"
}; text x {
"Put your Nose to the Grindstone!\n",
"\n",
"Amalgamated Plastic Surgeons and Toolmakers, Ltd.\n"
}; text x {
"New Year's Eve is the time of year when a man most feels his\n",
"age, and his wife most often reminds him to act it.\n",
"\n",
"Webster's Unafraid Dictionary\n"
}; text x {
"Anything free is worth what you pay for it.\n"
}; text x {
"The more we disagree, the more chance there is that at least\n",
"one of us is right.\n"
}; text x {
"""In defeat, unbeatable; in victory, unbearable.""\n",
"Winston Curchill, of Montgomery\n"
}; text x {
"May your Tongue stick to the Roof of your Mouth with the\n",
"Force of a Thousand Caramels.\n"
}; text x {
"Children seldom misquote you. In fact, they usually repeat\n",
"word for word what you shouldn't have said.\n"
}; text x {
"We really don't have any enemies. It's just that some of our\n",
"best friends are trying to kill us.\n"
}; text x {
"If you're going to do something tonight that you'll be sorry\n",
"for tomorrow morning, sleep late.\n",
"\n",
"Henny Youngman\n"
}; text x {
"Interpreter, n.:\n",
"One who enables two persons of different languages to\n",
"understand each other by repeating to each what it would have\n",
"been to the interpreter's advantage for the other to have\n",
"said.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"Truth will be out this morning. (Which may really mess\n",
"things up.)\n"
}; text x {
"Where humor is concerned there are no standards -- no one\n",
"can say what is good or bad, although you can be sure that\n",
"everyone will.\n",
"\n",
"John Kenneth Galbraith\n"
}; text x {
"Absurdity, n.:\n",
"A statement or belief manifestly inconsistent with one's own\n",
"opinion.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"Justice is incidental to law and order.\n",
"\n",
"J. Edgar Hoover\n"
}; text x {
"What is a magician but a practising theorist?\n",
"\n",
"Obi-Wan Kenobi\n"
}; text x {
"Sooner or later you must pay for your sins. (Those who have\n",
"already paid may disregard this fortune).\n"
}; text x {
"Don't let people drive you crazy when you know it's in\n",
"walking distance.\n"
}; text x {
"Try to get all of your posthumous medals in advance.\n"
}; text x {
"A man said to the Universe: ""Sir, I exist!""\n",
"\n",
"""However,"" replied the Universe, ""the fact has not created in\n",
"me a sense of obligation.""\n",
"\n",
"Stephen Crane\n"
}; text x {
"Caution: breathing may be hazardous to your health.\n"
}; text x {
"If you think the United States has stood still, who built\n",
"the largest shopping center in the world?\n",
"\n",
"Richard Nixon\n"
}; text x {
"Modern man is the missing link between apes and human\n",
"beings.\n"
}; text x {
"Laws of Serendipity:\n",
"\n",
"1. In order to discover anything, you must be looking\n",
"for something.\n",
"2. If you wish to make an improved product, you must already\n",
"be engaged in making an inferior one.\n"
}; text x {
"Why did the Lord give us so much quickness of movement\n",
"unless it was to avoid responsibility with?\n"
}; text x {
"If mathematically you end up with the wrong answer, try\n",
"multiplying by the page number.\n"
}; text x {
"Surprise due today. Also the rent.\n"
}; text x {
"Silverman's Law:\n",
"If Murphy's Law can go wrong, it will.\n"
}; text x {
"Blood is thicker than water, and much tastier.\n"
}; text x {
"In case of injury notify your superior immediately. He'll\n",
"kiss it and make it better.\n"
}; text x {
"Your analyst has you mixed up with another patient. Don't\n",
"believe a thing he tells you.\n"
}; text x {
"""It's easier said than done.""\n",
"\n",
"... and if you don't believe it, try proving that it's easier\n",
"done than said, and you'll see that ""it's easier said that\n",
"`it's easier done than said' than it is done"", which really\n",
"proves that ""it's easier said than done"".\n"
}; text x {
"The National Short-Sleeved Shirt Association says:\n",
"Support your right to bare arms!\n"
}; text x {
"Honk if you hate bumper stickers that say ""Honk if ...""\n"
}; text x {
"Famous last words:\n",
"1. Don't unplug it, it will just take a moment to fix.\n",
"2. Let's take the shortcut, he can't see us from there.\n",
"3. What happens if you touch these two wires tog\n",
"4. We won't need reservations.\n",
"5. It's always sunny there this time of the year.\n",
"6. Don't worry, it's not loaded.\n",
"7. They'd never (be stupid enough to) make him a manager.\n"
}; text x {
"The trouble with a kitten is that\n",
"When it grows up, it's always a cat\n",
"\n",
"Ogden Nash.\n"
}; text x {
"Without ice cream life and fame are meaningless.\n"
}; text x {
"Be free and open and breezy! Enjoy! Things won't get any\n",
"better so get used to it.\n"
}; text x {
"Tact is the ability to tell a man he has an open mind when\n",
"he has a hole in his head.\n"
}; text x {
"Speak softly and carry a +6 two-handed sword.\n"
}; text x {
"I have seen the future and it is just like the present, only\n",
"longer.-- Kehlog Albran, ""The Profit""\n"
}; text x {
"""The C Programming Language -- A language which combines the\n",
"flexibility of assembly language with the power of assembly\n",
"language.""\n"
}; text x {
"President Thieu says he'll quit if he doesn't get more than\n",
"50% of the vote. In a democracy, that's not called quitting.-\n",
"\n",
"The Washington Post\n"
}; text x {
"Stop searching. Happiness is right next to you.\n"
}; text x {
"Reality is an obstacle to hallucination.\n"
}; text x {
"Is it possible that software is not like anything else, that\n",
"it is meant to be discarded: that the whole point is to\n",
"always see it as a soap bubble?\n"
}; text x {
"Everyone can be taught to sculpt: Michelangelo would have\n",
"had to be taught how not to. So it is with the great\n",
"programmers.\n"
}; text x {
"The light at the end of the tunnel is the headlight of an\n",
"approaching train.\n"
}; text x {
"College football is a game which would be much more\n",
"interesting if the faculty played instead of the students,\n",
"and even more interesting if the trustees played. There would\n",
"be a great increase in broken arms, legs, and necks, and\n",
"simultaneously an appreciable diminution in the loss to\n",
"humanity.\n",
"\n",
"H. L. Mencken\n"
}; text x {
"""Contrariwise,"" continued Tweedledee, ""if it was so, it\n",
"might be, and if it were so, it would be; but as it isn't, it\n",
"ain't. That's logic!""\n",
"\n",
"Lewis Carroll, ""Through the Looking Glass""\n"
}; text x {
"""Humor is a drug which it's the fashion to abuse.""\n",
"\n",
"William Gilbert\n"
}; text x {
"A day for firm decisions!!!!! Or is it?\n"
}; text x {
"LEO (July 23 - Aug 22)\n",
"Your determination and sense of humor will come to the fore.\n",
"Your ability to laugh at adversity will be a blessing because\n",
"you've got a day coming you wouldn't believe.\n",
"As a matter of fact, if you can laugh at what happens to you\n",
"today, you've got a sick sense of humor.\n"
}; text x {
"Anoint, v.:\n",
"To grease a king or other great functionary already\n",
"sufficiently slippery.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"The revolution will not be televised.\n"
}; text x {
"No problem is so large it can't be fit in somewhere.\n"
}; text x {
"Elevators smell different to midgets\n"
}; text x {
"Noncombatant, n.: A dead Quaker.\n",
"\n",
"Ambrose Bierce\n"
}; text x {
"Life is a yo-yo, and mankind ties knots in the string.\n"
}; text x {
"Trying to be happy is like trying to build a machine for\n",
"which the only specification is that it should run\n",
"noiselessly.\n"
}; text x {
"Basic, n.:\n",
"A programming language. Related to certain social\n",
"diseases in that those who have it will not admit it in\n",
"polite company.\n"
}; text x {
"If I kiss you, that is a psychological interaction.\n",
"\n",
"On the other hand, if I hit you over the head with a brick,\n",
"that is also a psychological interaction.\n",
"\n",
"The difference is that one is friendly and the other is not\n",
"so friendly.\n",
"\n",
"The crucial point is if you can tell which is which.\n",
"\n",
"Dolph Sharp, ""I'm O.K., You're Not So Hot""\n"
}; text x {
"Children aren't happy without something to ignore,\n",
"And that's what parents were created for.\n",
"\n",
"Ogden Nash\n"
}; text x {
"Did you know ...\n",
"\n",
"That no-one ever reads these things?\n"
}; text x {
"UFO's are for real: the Air Force doesn't exist.\n"
}; text x {
"The trouble with being poor is that it takes up all your\n",
"time.\n"
}; text x {
"""The difference between a misfortune and a calamity? If\n",
"Gladstone fell into the Thames, it would be a misfortune. But\n",
"if someone dragged him out again, it would be a calamity.""\n",
"\n",
"Benjamin Disraeli\n"
}; text x {
"Who made the world I cannot tell;\n",
"'Tis made, and here am I in hell.\n",
"My hand, though now my knuckles bleed,\n",
"I never soiled with such a deed.\n",
"\n",
"A. E. Housman\n"
}; text x {
"Today is the first day of the rest of the mess.\n"
}; text x {
"""Really ?? What a coincidence, I'm shallow too!!""\n"
}; text x {
"""One planet is all you get.""\n"
}; text x {
"Jones's First Law:\n",
"Anyone who makes a significant contribution to any field\n",
"ofendeavor, and stays in that field long enough, becomes\n",
"an obstruction to its progress -- in direct proportion to the\n",
"importance of their original contribution.\n"
}; text x {
"The right half of the brain controls the left half of the\n",
"body. This means that only left handed people are in their\n",
"right mind.\n"
}; text x {
"Honesty pays, but it doesn't seem to pay enough to suit some\n",
"people.\n",
"\n",
"F. M. Hubbard\n"
}; text x {
"Do molecular biologists wear designer genes?\n"
}; text x {
"Violence is the last refuge of the incompetent.\n",
"\n",
"Salvor Hardin\n"
}; text x {
"Laetrile is the pits\n"
}; text x {
"You possess a mind not merely twisted, but actually\n",
"sprained.\n"
}; text x {
"According to my best recollection, I don't remember.\n",
"\n",
"Vincent ""Jimmy Blue Eyes"" Alo\n"
}; text x {
"User n.: A programmer who will believe anything you tell\n",
"him.\n"
}; text x {
"They're only trying to make me LOOK paranoid!\n"
}; text x {
"The Fifth Rule:\n",
"You have taken yourself too seriously.\n"
}; text x {
"""The pyramid is opening!""\n",
"""Which one?""\n",
"""The one with the ever-widening hole in it!""\n",
"Firesign Theater, ""How Can You Be In Two Places At Once\n",
"When You're Not Anywhere At All""\n"
}; text x {
"Washington [D.C.] is a city of Southern efficiency and\n",
"Northern charm. -- John F. Kennedy\n"
}; text x {
"Things will be bright in P.M. A cop will shine a light in\n",
"your face.\n"
}; text x {
"Succumb to natural tendencies. Be hateful and boring.\n"
}; text x {
"If all the world's a stage, I want to operate the trap\n",
"door.\n",
"\n",
"Paul Beatty\n"
}; text x {
"If you want your spouse to listen and pay strict attention\n",
"to every word you say, talk in your sleep.\n"
}; text x {
"Nothing is illegal if one hundred businessmen decide to do\n",
"it.\n",
"\n",
"Andrew Young\n"
}; text x {
"An elephant is a mouse with an operating system.\n"
}; text x {
"Isn't it strange that the same people that laugh at gypsy\n",
"fortune tellers take economists seriously?\n"
}; text x {
"Adore, v.:\n",
"To venerate expectantly.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"You are wise, witty, and wonderful, but you spend too much\n",
"time reading this sort of trash.\n"
}; text x {
"When you make your mark in the world, watch out for guys\n",
"with erasers.\n",
"\n",
"The Wall Street Journal\n"
}; text x {
"Scott's first Law:\n",
"No matter what goes wrong, it will probably look right.\n"
}; text x {
"Beware of low-flying butterflies.\n"
}; text x {
"Fifth Law of Procrastination:\n",
"Procrastination avoids boredom; one never has the\n",
"feeling thatthere is nothing important to do.\n"
}; text x {
"Confession is good for the soul only in the sense that a\n",
"tweed coat is good for dandruff.\n",
"\n",
"Peter de Vries\n"
}; text x {
"Even if you do learn to speak correct English, whom are you\n",
"going to speak it to?\n",
"\n",
"Clarence Darrow\n"
}; text x {
"All I ask is a chance to prove that money can't make me\n",
"happy.\n"
}; text x {
"You cannot kill time without injuring eternity.\n"
}; text x {
"On-line, adj.:\n",
"The idea that a human being should always be accessible to a\n",
"computer.\n"
}; text x {
"Screw up your courage! You've screwed up everything else.\n"
}; text x {
"Cloning is the sincerest form of flattery.\n"
}; text x {
"The best defense against logic is ignorance.\n"
}; text x {
"Democracy is the recurrent suspicion that more than half of\n",
"the people are right more than half of the time.\n",
"\n",
"E. B. White\n"
}; text x {
"I don't like spinach, and I'm glad I don't, because if I\n",
"liked it I'd eat it, and I just hate it.\n",
"\n",
"Clarence Darrow\n"
}; text x {
"Tonight's the night: Sleep in a eucalyptus tree.\n"
}; text x {
"Greener's Law:\n",
"Never argue with a man who buys ink by the barrel.\n"
}; text x {
"He had that rare weird electricity about him -- that\n",
"extremely wild and heavy presence that you only see in a\n",
"person who has abandoned all hope of ever behaving\n",
"""normally.""\n",
"\n",
"Hunter S. Thompson, ""Fear and Loathing '72""\n"
}; text x {
"Artistic ventures highlighted. Rob a museum.\n"
}; text x {
"If God had not given us sticky tape, it would have been\n",
"necessary to invent it.\n"
}; text x {
"Snacktrek, n.:\n",
"The peculiar habit, when searching for a snack, of constantly\n",
"returning to the refrigerator in hopes that something new\n",
"will have materialized.\n",
"\n",
"Rich Hall, ""Sniglets""\n"
}; text x {
"I have a simple philosophy:\n",
"\n",
"Fill what's empty.\n",
"Empty what's full.\n",
"Scratch where it itches.\n",
"\n",
"A. R. Longworth\n"
}; text x {
"God is a comic playing to an audience that's afraid to laugh\n"
}; text x {
"Alexander Graham Bell is alive and well in New York, and\n",
"still waiting for a dial tone.\n"
}; text x {
"Eisenhower was very nice,\n",
"Nixon was his only vice.\n",
"C. Degen\n"
}; text x {
"You're never too old to become younger.\n",
"Mae West\n"
}; text x {
"Millions long for immortality who do not know what to do\n",
"with themselves on a rainy Sunday afternoon.\n",
"\n",
"Susan Ertz\n"
}; text x {
"Injustice anywhere is a threat to justice everywhere.\n",
"\n",
"Martin Luther King, Jr.\n"
}; text x {
"The more laws and order are made prominent, the more thieves\n",
"and robbers there will be.\n",
"\n",
"Lao Tsu\n"
}; text x {
"Ken Thompson has an automobile which he helped design.\n",
"Unlike most automobiles, it has neither speedometer, nor gas\n",
"gage, nor any of the numerous idiot lights which plague the\n",
"modern driver. Rather, if the driver makes any mistake, a\n",
"giant ""?"" lights up in the center of the dashboard. ""The\n",
"experienced driver"", he says, ""will usually know what's\n",
"wrong.""\n"
}; text x {
"F u cn rd ths u cnt spl wrth a dm!\n"
}; text x {
"""Cleveland? Yes, I spent a week there one day.""\n"
}; text x {
"I must have slipped a disk -- my pack hurts\n"
}; text x {
"NOBODY EXPECTS THE SPANISH INQUISITION\n"
}; text x {
"It is not true that life is one damn thing after another --\n",
"it's one damn thing over and over.\n",
"\n",
"Edna St. Vincent Millay\n"
}; text x {
"Canada Bill Jone's Motto:\n",
"It's morally wrong to allow suckers to keep their money.\n",
"\n",
"Supplement:\n",
"A .44 magnum beats four aces.\n"
}; text x {
"Bolub's Fourth Law of Computerdom:\n",
"Project teams detest weekly progress reporting because it so\n",
"vividly manifests their lack of progress.\n"
}; text x {
"A banker is a fellow who lends you his umbrella when the sun\n",
"is shining and wants it back the minute it begins to rain.--\n",
"\n",
"Mark Twain\n"
}; text x {
"Any woman is a volume if one knows how to read her.\n"
}; text x {
"Adolescence, n.:\n",
"The stage between puberty and adultery.\n"
}; text x {
"""I drink to make other people interesting.""\n",
"-- George Jean Nathan\n"
}; text x {
"Distress, n.:\n",
"A disease incurred by exposure to the prosperity of a\n",
"friend.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"Monday is an awful way to spend one seventh of your life.\n"
}; text x {
"People who have what they want are very fond of telling\n",
"people who haven't what they want that they don't want it.\n",
"\n",
"Ogden Nash\n"
}; text x {
"This login session: $13.99, but for you $11.88\n"
}; text x {
"Carperpetuation (kar' pur pet u a shun), n.:\n",
"The act, when vacuuming, of running over a string at least a\n",
"dozen times, reaching over and picking it up, examining it,\n",
"then putting it back down to give the vacuum one more chance.\n",
"\n",
"Rich Hall, ""Sniglets""\n"
}; text x {
"Children are natural mimic who act like their parents\n",
"despite every effort to teach them good manners.\n"
}; text x {
"Accident, n.:\n",
"A condition in which presence of mind is good, but absence of\n",
"body is better.\n"
}; text x {
"When in doubt, use brute force.\n",
"\n",
"Ken Thompson\n"
}; text x {
"Happiness isn't something you experience; it's something you\n",
"remember.\n",
"\n",
"Oscar Levant\n"
}; text x {
"An idea is not responsible for the people who believe in it.\n"
}; text x {
"If you've seen one redwood, you've seen them all.\n",
"\n",
"Ronald Reagan\n"
}; text x {
"""It took me fifteen years to discover that I had no talent\n",
"for writing, but I couldn't give up because by that time I\n",
"was too famous.""\n"
}; text x {
"A mathematician is a machine for converting coffee into\n",
"theorems.\n"
}; text x {
"The best cure for insomnia is to get a lot of sleep.\n",
"\n",
"W. C. Fields\n"
}; text x {
"Office Automation, n.:\n",
"The use of computers to improve efficiency by removing anyone\n",
"you would want to talk with over coffee.\n"
}; text x {
"You cannot propel yourself forward by patting yourself on\n",
"the back.\n"
}; text x {
"Man is the best computer we can put aboard a spacecraft ...\n",
"and the only one that can be mass produced with unskilled\n",
"labor.\n",
"\n",
"Wernher von Braun\n"
}; text x {
"Excess on occasion is exhilarating. It prevents moderation\n",
"from acquiring the deadening effect of a habit.\n",
"\n",
"W. Somerset Maugham\n"
}; text x {
"Good leaders being scarce, following yourself is allowed.\n"
}; text x {
"A billion here, a couple of billion there -- first thing you\n",
"know it adds up to be real money.\n",
"\n",
"Everett McKinley Dirksen\n"
}; text x {
"Notes for a ballet, ""The Spell"": ... Suddenly Sigmund hears\n",
"the flutter of wings, and a group of wild swans flies across\n",
"the moon ... Sigmund is astounded to see that their leader is\n",
"part swan and part woman --unfortunately, divided lengthwise.\n",
"She enchants Sigmund, who is careful not to make any poultry\n",
"jokes ...\n",
"\n",
"Woody Allen\n"
}; text x {
"Most people wouldn't know music if it came up and bit them\n",
"on the ass. -- Frank Zappa\n"
}; text x {
"A solemn, unsmiling, sanctimonious old iceberg who looked\n",
"like he was waiting for a vacancy in the Trinity.\n",
"\n",
"Mark Twain\n"
}; text x {
"What good is a ticket to the good life, if you can't find\n",
"the entrance?\n"
}; text x {
"Finagle's Creed:\n",
"Science is true. Don't be misled by facts.\n"
}; text x {
"Surprise your boss. Get to work on time.\n"
}; text x {
"Line Printer paper is strongest at the perforations.\n"
}; text x {
"In India, ""cold weather"" is merely a conventional phrase and\n",
"has come into use through the necessity of having some way to\n",
"distinguish between weather which will melt a brass door-knob\n",
"and weather which will only make it mushy.\n",
"\n",
"Mark Twain\n"
}; text x {
"May the Fleas of a Thousand Camels infest one of your\n",
"Erogenous Zones.\n"
}; text x {
"Boy, n.:\n",
"A noise with dirt on it.\n"
}; text x {
"After the last of 16 mounting screws has been removed from\n",
"an access cover, it will be discovered that the wrong access\n",
"cover has been removed.\n"
}; text x {
"Pascal, n.:\n",
"A programming language named after a man who would turn over\n",
"in his grave if he knew about it.\n"
}; text x {
"Wit, n.:\n",
"The salt with which the American Humorist spoils his cookery\n",
"... by leaving it out.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"Passionate hatred can give meaning and purpose to an empty\n",
"life.\n",
"\n",
"Eric Hoffer\n"
}; text x {
"Law of Probable Dispersal:\n",
"Whatever it is that hits the fan will not be evenly\n",
"distributed.\n"
}; text x {
"Illinois isn't exactly the land that God forgot -- it's more\n",
"like the land He's trying to ignore.\n"
}; text x {
"I never fail to convince an audience that the best thing\n",
"they could do was to go away.\n"
}; text x {
"While most peoples' opinions change, the conviction of their\n",
"correctness never does.\n"
}; text x {
"If little green men land in your back yard, hide any little\n",
"green women you've got in the house.\n",
"\n",
"Mike Harding, ""The Armchair Anarchist's Almanac""\n"
}; text x {
"Youth is when you blame all your troubles on your parents;\n",
"maturity is when you learn that everything is the fault of\n",
"the younger generation.\n"
}; text x {
"""Grub first, then ethics.""\n",
"\n",
"Bertolt Brecht\n"
}; text x {
"Ass, n.: The masculine of ""lass"".\n"
}; text x {
"""If I had only known, I would have been a locksmith.""\n",
"\n",
"Albert Einstein\n"
}; text x {
"As Will Rogers would have said, ""There is no such things as\n",
"a free variable.""\n"
}; text x {
"Osborn's Law:\n",
"Variables won't; constants aren't.\n"
}; text x {
"Give thought to your reputation. Consider changing name and\n",
"moving to a new town.\n"
}; text x {
"It is the business of the future to be dangerous.\n",
"\n",
"Hawkwind\n"
}; text x {
"The goal of Computer Science is to build something that will\n",
"last at least until we've finished building it.\n"
}; text x {
"Rule of the Great:\n",
"When people you greatly admire appear to be thinking deep\n",
"thoughts, they probably are thinking about lunch.\n"
}; text x {
"Cahn's Axiom:\n",
"When all else fails, read the instructions.\n"
}; text x {
"... at least I thought I was dancing, 'til somebody stepped\n",
"on my hand.\n",
"\n",
"J. B. White\n"
}; text x {
"If two men agree on everything, you may be sure that one of\n",
"them is doing the thinking.\n",
"\n",
"Lyndon Baines Johnson\n"
}; text x {
"He played the king as if afraid someone else would play the\n",
"ace.\n",
"\n",
"John Mason Brown, drama critic\n"
}; text x {
"""Might as well be frank, monsieur. It would take a miracle\n",
"to get you out of Casablanca and the Germans have outlawed\n",
"miracles.""\n"
}; text x {
"""The way to make a small fortune in the commodities market\n",
"is to start with a large fortune.""\n"
}; text x {
"Justice, n.:\n",
"A decision in your favor.\n"
}; text x {
"Mayor Vincent J. `Buddy' Cianci on the ACLU's suit to have\n",
"a city nativity scene removed:\n",
"""They're just jealous because they don't have three wise men\n",
"and a virgin in the whole organization.""\n"
}; text x {
"A man wrapped up in himself makes a very small package.\n"
}; text x {
"Pardo's First Postulate:\n",
"Anything good in life is either illegal, immoral, or\n",
"fattening.\n",
"\n",
"Arnold's Addendum:\n",
"Anything not fitting into these categories causes cancer\n",
"in rats.\n"
}; text x {
"Lactomangulation, n.:\n",
"Manhandling the ""open here"" spout on a milk carton so badly\n",
"that one has to resort to using the ""illegal"" side.\n",
"\n",
"Rich Hall, ""Sniglets""\n"
}; text x {
"""Arguments with furniture are rarely productive.""\n",
"\n",
"Kehlog Albran, ""The Profit""\n"
}; text x {
"Love is the triumph of imagination over intelligence.\n",
"\n",
"H. L. Mencken\n"
}; text x {
"Nearly all men can stand adversity, but if you want to test\n",
"a man's character, give him power.\n",
"\n",
"Abraham Lincoln\n"
}; text x {
"I am the mother of all things, and all things should wear a\n",
"sweater.\n"
}; text x {
"Those who in quarrels interpose, must often wipe a bloody\n",
"nose.\n"
}; text x {
"Fashion is a form of ugliness so intolerable that we have to\n",
"alter it every six months.\n",
"\n",
"Oscar Wilde\n"
}; text x {
"Your lucky number has been disconnected.\n"
}; text x {
"When I said ""we"", officer, I was referring to myself, the\n",
"four young ladies, and, of course, the goat.\n"
}; text x {
"Lubarsky's Law of Cybernetic Entomology:\n",
"There's always one more bug.\n"
}; text x {
"Stupid, n.:\n",
"Losing $25 on the game and $25 on the instant replay.\n"
}; text x {
"Eternal nothingness is fine if you happen to be dressed for\n",
"it.\n",
"\n",
"Woody Allen\n"
}; text x {
"It's not an optical illusion, it just looks like one.\n",
"\n",
"Phil White\n"
}; text x {
"Death is life's way of telling you you've been fired.\n",
"\n",
"R. Geis\n"
}; text x {
"The Army needs leaders the way a foot needs a big toe.\n",
"\n",
"Bill Murray\n"
}; text x {
"SAGITTARIUS (Nov 22 - Dec 21)\n",
"You are optimistic and enthusiastic. You have a reckless\n",
"tendency to rely on luck since you lack talent. The majority\n",
"of Sagittarians are drunks or dope fiends or both. People\n",
"laugh at you a great deal.\n"
}; text x {
"Xerox never comes up with anything original.\n"
}; text x {
"An effective way to deal with predators is to taste\n",
"terrible.\n"
}; text x {
"Xerox does it again and again and again and ...\n"
}; text x {
"""Every time I think I know where it's at, they move it.""\n"
}; text x {
"San Francisco, n.:\n",
"Marcel Proust editing an issue of Penthouse.\n"
}; text x {
"Every 4 seconds a woman has a baby. Our problem is to find\n",
"this woman and stop her.\n"
}; text x {
"A great many people think they are thinking when they are\n",
"merely rearranging their prejudices.\n",
"William James\n"
}; text x {
"Today is the tomorrow you worried about yesterday\n"
}; text x {
"The generation of random numbers is too important to be left\n",
"to chance.\n"
}; text x {
"While your friend holds you affectionately by both your\n",
"hands you are safe, for you can watch both of his.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"Hartley's First Law:\n",
"You can lead a horse to water, but if you can get him to\n",
"float on his back, you've got something.\n"
}; text x {
"Vail's Second Axiom:\n",
"The amount of work to be done increases in proportion to the\n",
"amount of work already completed.\n"
}; text x {
"Next Friday will not be your lucky day. As a matter of fact,\n",
"you don't have a lucky day this year.\n"
}; text x {
"""I am not sure what this is, but an `F' would only dignify\n",
"it.""\n",
"\n",
"English Professor\n"
}; text x {
"Slurm, n.:\n",
"The slime that accumulates on the underside of a soap bar\n",
"when it sits in the dish too long.\n",
"\n",
"Rich Hall, ""Sniglets""\n"
}; text x {
"The average woman would rather have beauty than brains,\n",
"because the average man can see better than he can think.\n"
}; text x {
"I'm prepared for all emergencies but totally unprepared for\n",
"everyday life.\n"
}; text x {
"There is a green, multi-legged creature crawling on your\n",
"shoulder.\n"
}; text x {
"I'm not under the alkafluence of inkahol that some thinkle\n",
"peep I am. It's just the drunker I sit here the longer I get.\n"
}; text x {
"Yes, but every time I try to see things your way, I get a\n",
"headache.\n"
}; text x {
"When you do not know what you are doing, do it neatly.\n"
}; text x {
"Weiler's Law:\n",
"Nothing is impossible for the man who doesn't have to do\n",
"it himself.\n"
}; text x {
"Space is big. You just won't believe how vastly, hugely,\n",
"mind-bogglingly big it is. I mean, you may think it's a long\n",
"way down the road to the drug store, but that's just peanuts\n",
"to space.\n",
"\n",
"""The Hitchhiker's Guide to the Galaxy""\n"
}; text x {
"The most exciting phrase to hear in science, the one that\n",
"heralds new discoveries, is not ""Eureka!"" (I found it!) but\n",
"""That's funny ...""\n",
"\n",
"Isaac Asimov\n"
}; text x {
"If the weather is extremely bad, church attendance will be\n",
"down. If the weather is extremely good, church attendance\n",
"will be down. If the bulletin covers are in short supply,\n",
"however, church attendance will exceed all expectations.\n",
"\n",
"Reverend Chichester\n"
}; text x {
"But in our enthusiasm, we could not resist a radical\n",
"overhaul of the system, in which all of its major weaknesses\n",
"have been exposed, analyzed, and replaced with new\n",
"weaknesses.\n",
"Bruce Leverett, ""Register Allocation in Optimizing Compilers""\n"
}; text x {
"Weinberg's First Law:\n",
"Progress is made on alternate Fridays.\n"
}; text x {
"Genderplex, n.:\n",
"The predicament of a person in a restaurant who is unable to\n",
"determine his or her designated restroom (e.g., turtles and\n",
"tortoises).\n",
"Rich Hall, ""Sniglets""\n"
}; text x {
"What sane person could live in this world and not be crazy?-\n",
"\n",
"Ursula K. LeGuin\n"
}; text x {
"Jone's Motto:\n",
"Friends come and go, but enemies accumulate.\n"
}; text x {
"Of all the animals, the boy is the most unmanageable.\n",
"\n",
"Plato\n"
}; text x {
"Census Taker to Housewife: Did you ever have the measles,\n",
"and, if so, how many?\n"
}; text x {
"You're not drunk if you can lie on the floor without holding\n",
"on.\n",
"\n",
"Dean Martin\n"
}; text x {
"The New Testament offers the basis for modern computer\n",
"coding theory, in the form of an affirmation of the binary\n",
"number system.\n",
"\n",
"But let your communication be Yea, yea; nay, nay: for\n",
"whatsoever is more than these cometh of evil.\n",
"\n",
"Matthew 5:37\n"
}; text x {
"Rocky's Lemma of Innovation Prevention\n",
"Unless the results are known in advance, funding\n",
"agencies will reject the proposal.\n"
}; text x {
"The brain is a wonderful organ; it starts working the moment\n",
"you get up in the morning, and does not stop until you get to\n",
"school.\n"
}; text x {
"I have the simplest tastes. I am always satisfied with the\n",
"best.\n",
"\n",
"Oscar Wilde\n"
}; text x {
"If the odds are a million to one against something\n",
"occurring, chances are 50-50 it will.\n"
}; text x {
"These days the necessities of life cost you about three\n",
"times what they used to, and half the time they aren't even\n",
"fit to drink.\n"
}; text x {
"Consultants are mystical people who ask a company for a\n",
"number and then give it back to them.\n"
}; text x {
"Of course there's no reason for it, it's just our policy.\n"
}; text x {
"The truth of a proposition has nothing to do with its\n",
"credibility. And vice versa.\n"
}; text x {
"The Briggs/Chase Law of Program Development:\n",
"To determine how long it will take to write and debug a\n",
"program, take your best estimate, multiply that by two, add\n",
"one, and convert to the next higher units.\n"
}; text x {
"Furbling, v.:\n",
"Having to wander through a maze of ropes at an airport or\n",
"bank even when you are the only person in line.\n",
"\n",
"Rich Hall, ""Sniglets""\n"
}; text x {
"Forgetfulness, n.:\n",
"A gift of God bestowed upon debtors in compensation for their\n",
"destitution of conscience.\n"
}; text x {
"Corruption is not the No.1 priority of the Police\n",
"Commissioner. His job is to enforce the law and fight crime.-\n",
"P.B.A. President E. J. Kiernan\n"
}; text x {
"If you give Congress a chance to vote on both sides of an\n",
"issue, it will always do it.\n",
"\n",
"Les Aspin, D., Wisconsin\n"
}; text x {
"Reporter, n.:\n",
"\n",
"A writer who guesses his way to the truth and dispels it with\n",
"a tempest of words.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"""The illegal we do immediately. The unconstitutional takes\n",
"a bit longer.""\n",
"\n",
"Henry Kissinger\n"
}; text x {
"[Nuclear war] ... may not be desirable.\n",
"\n",
"Edwin Meese III\n"
}; text x {
"Tired of finding that other people are helping themselves to\n",
"your good liquor at BYOB parties? Take along a candle, which\n",
"you insert and light after you've opened the bottle. No one\n",
"ever expects anything drinkable to be in a bottle which has\n",
"a candle stuck in its neck.\n"
}; text x {
"Dentist, n.:\n",
"A Prestidigitator who, putting metal in one's mouth, pulls\n",
"coins out of one's pockets.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"One of the oldest problems puzzled over in the Talmud is:\n",
"""Why did God create goyim?"" The generally accepted answer is\n",
"""SOMEBODY somebody has to buy retail.""\n",
"\n",
"Arthur Naiman, ""Every Goy's Guide to Yiddish""\n"
}; text x {
"When we are planning for posterity, we ought to remember\n",
"that virtue is not hereditary.\n",
"\n",
"Thomas Paine\n"
}; text x {
"Like so many Americans, she was trying to construct a life\n",
"that made sense from things she found in gift shops.\n",
"\n",
"Kurt Vonnegut, Jr.\n"
}; text x {
"How many Zen masters does it take to screw in a light bulb?\n",
"\n",
"None. The Universe spines the bulb, and the Zen master stays\n",
"out of the way.\n"
}; text x {
"""Deliver yesterday, code today, think tomorrow.""\n"
}; text x {
"However, never daunted, I will cope with adversity in my\n",
"traditional manner ... sulking and nausea.\n",
"\n",
"Tom K. Ryan\n"
}; text x {
"We have met the enemy, and he is us.\n",
"-- Walt Kelly\n"
}; text x {
"It has just been discovered that research causes cancer in\n",
"rats.\n"
}; text x {
"Idiot Box, n.:\n",
"The part of the envelope that tells a person where to place\n",
"the stamp when they can't quite figure it out for themselves.\n",
"\n",
"Rich Hall, ""Sniglets""\n"
}; text x {
"The advertisement is the most truthful part of a newspaper--\n",
"Thomas Jefferson\n"
}; text x {
"Kerr's Three Rules for a Successful College:\n",
"Have plenty of football for the alumni, fun for the students,\n",
"and parking for the faculty.\n"
}; text x {
"President Reagan has noted that there are too many economic\n",
"pundits and forecasters and has decided on an excess prophets\n",
"tax.\n"
}; text x {
"Atlee is a very modest man. And with reason.\n",
"Winston Churchill\n"
}; text x {
"When does summertime come to Minnesota, you ask? Well, last\n",
"year, I think it was a Tuesday.\n"
}; text x {
"AMAZING BUT TRUE ...\n",
"\n",
"There is so much sand in Northern Africa that if it were\n",
"spread out it would completely cover the Sahara Desert.\n"
}; text x {
"Alimony is a system by which, when two people make a\n",
"mistake, one of them keeps paying for it.\n",
"\n",
"Peggy Joyce\n"
}; text x {
"""This is a country where people are free to practice their\n",
"religion, regardless of race, creed, color, obesity, or\n",
"number of dangling keys ...""\n"
}; text x {
"A fanatic is one who can't change his mind and won't change\n",
"the subject.\n",
"Winston Churchill\n"
}; text x {
"""You must realize that the computer has it in for you. The\n",
"irrefutable proof of this is that the computer always does\n",
"what you tell it to do.""\n"
}; text x {
"""The Lord gave us farmers two strong hands so we could grab\n",
"as much as we could with both of them.""\n",
"\n",
"Joseph Heller, ""Catch-22""\n"
}; text x {
"If God had meant for us to be naked, we would have been born\n",
"that way.\n"
}; text x {
"Wiker's Law:\n",
"Government expands to absorb revenue and then some.\n"
}; text x {
"Going to church does not make a person religious, nor does\n",
"going to school make a person educated, any more than going\n",
"to a garage makes a person a car.\n"
}; text x {
"""Honesty is the best policy, but insanity is a better\n",
"defense""\n"
}; text x {
"You cannot achieve the impossible without attempting the\n",
"absurd.\n"
}; text x {
"Boren's Laws:\n",
"(1) When in charge, ponder.\n",
"(2) When in trouble, delegate.\n",
"(3) When in doubt, mumble.\n"
}; text x {
"Hartley's Second Law:\n",
"Never sleep with anyone crazier than yourself.\n"
}; text x {
"Cold, adj.:\n",
"When the politicians walk around with their hands in their\n",
"own pockets.\n"
}; text x {
"Hacking's just another word for nothing left to kludge.\n"
}; text x {
"You have the capacity to learn from mistakes. You'll learn\n",
"a lot today.\n"
}; text x {
"How come wrong numbers are never busy?\n"
}; text x {
"Lunatic Asylum, n.:\n",
"The place where optimism most flourishes.\n"
}; text x {
"Meader's Law:\n",
"Whatever happens to you, it will previously have\n",
"happened toevery one you know, only more so.\n"
}; text x {
"Rule of Creative Research:\n",
"1) Never draw what you can copy.\n",
"2) Never copy what you can trace.\n",
"3) Never trace what you can cut out and paste down.\n"
}; text x {
"Magpie, n.:\n",
"A bird whose theivish disposition suggested to someone that\n",
"it might be taught to talk.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"Maier's Law:\n",
"If the facts do not conform to the theory, they must be\n",
"disposed of.\n",
"\n",
"Corollaries:\n",
"1. The bigger the theory, the better.\n",
"2. The experiment may be considered a success if no more\n",
"than 50% of the observed measurements must be\n",
"discarded to obtain a correspondence with the theory.\n"
}; text x {
"The primary purpose of the DATA statement is to give names\n",
"to constants; instead of referring to pi as 3.141592653589793\n",
"at every appearance, the variable PI can be given that value\n",
"with a DATA statement and used instead of the longer form of\n",
"the constant. This also simplifies modifying the program,\n",
"should the value of pi change.\n",
"\n",
"FORTRAN manual for Xerox Computers\n"
}; text x {
"Democracy is also a form of worship. It is the worship of\n",
"Jackals by Jackasses.\n",
"\n",
"H. L. Mencken\n"
}; text x {
"Fifth Law of Applied Terror:\n",
"\n",
"If you are given an open-book exam, you will forget your\n",
"book. Corollary:\n",
"If you are given a take-home exam, you will forget where you\n",
"live.\n"
}; text x {
"While you don't greatly need the outside world, it's still\n",
"very reassuring to know that it's still there.\n"
}; text x {
"Majority, n.:\n",
"That quality that distinguishes a crime from a law.\n"
}; text x {
"In an organization, each person rises to the level of his\n",
"own incompetency\n",
"\n",
"The Peter Principle\n"
}; text x {
"The Killer Ducks are coming!!!\n"
}; text x {
"""And what will you do when you grow up to be as big as me?""\n",
"asked the father of his little son.\n",
"\n",
"""Diet.""\n"
}; text x {
"Others will look to you for stability, so hide when you bite\n",
"your nails.\n"
}; text x {
"Accuracy, n.:\n",
"The vice of being right\n"
}; text x {
"How can you be in two places at once when you're not\n",
"anywhere at all?\n"
}; text x {
"Pro is to con as progress is to Congress.\n"
}; text x {
"Conscience is what hurts when everything else feels so good.\n"
}; text x {
"You are only young once, but you can stay immature\n",
"indefinitely.\n"
}; text x {
"Old soldiers never die. Young ones do.\n"
}; text x {
"Resisting temptation is easier when you think you'll\n",
"probably get another chance later on.\n"
}; text x {
"""Wagner's music is better than it sounds.""\n",
"\n",
"Mark Twain\n"
}; text x {
"""It's not Camelot, but it's not Cleveland, either.""\n",
"\n",
"Kevin White, mayor of Boston\n"
}; text x {
"Research is what I'm doing when I don't know what I'm\n",
"doing.\n",
"\n",
"Wernher von Braun\n"
}; text x {
"In the land of the dark, the Ship of the Sun is driven by\n",
"the Grateful Dead.\n",
"\n",
"Egyptian Book of the Dead\n"
}; text x {
"VIRGO (Aug 23 - Sept 22)\n",
"You are the logical type and hate disorder. This nitpicking\n",
"is sickening to your friends. You are cold and unemotional\n",
"and sometimes fall asleep while making love. Virgos make good\n",
"bus drivers.\n"
}; text x {
"If you explain so clearly that nobody can misunderstand,\n",
"somebody will.\n"
}; text x {
"While money doesn't buy love, it puts you in a great\n",
"bargaining position.\n"
}; text x {
"God is real, unless declared integer.\n"
}; text x {
"Every program is a part of some other program, and rarely\n",
"fits.\n"
}; text x {
"The human mind ordinarily operates at only ten percent of\n",
"its capacity -- the rest is overhead for the operating\n",
"system.\n"
}; text x {
"Call on God, but row away from the rocks.\n",
"\n",
"Indian proverb\n"
}; text x {
"Cogito cogito ergo cogito sum\n",
"\n",
"""I think that I think, therefore I think that I am.""\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"Admiration, n.:\n",
"Our polite recognition of another's resemblance to ourselves.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"Q: Why do ducks have flat feet?\n",
"A:To stamp out forest fires.\n",
"\n",
"Q:Why do elephants have flat feet?\n",
"A:To stamp out flaming ducks.\n"
}; text x {
"How long a minute is depends on which side of the bathroom\n",
"door you're on.\n"
}; text x {
"""What do you give a man who has everything?"" the pretty\n",
"teenager asked her mother.\n",
"\n",
"""Encouragement, dear,"" she replied.\n"
}; text x {
"Zounds! I was never so bethumped with words\n",
"since I first called my brother's father dad.\n",
"\n",
"William Shakespeare, ""King John""\n"
}; text x {
"Naeser's Law:\n",
"You can make it foolproof, but you can't make it\n",
"damnfoolproof.\n"
}; text x {
"THE GOLDEN RULE OF ARTS AND SCIENCES\n",
"The one who has the gold makes the rules.\n"
}; text x {
"Please, won't somebody tell me what diddie-wa-diddie means?\n"
}; text x {
"[Prime Minister Joseph] Chamberlain loves the working man --\n",
"he loves to see him work.\n",
"\n",
"Winston Churchill\n"
}; text x {
"Satellite Safety Tip No.14:\n",
"\n",
"If you see a bright streak in the sky coming at you, duck.\n"
}; text x {
"Chemicals, n.:\n",
"\n",
"Noxious substances from which modern foods are made.\n"
}; text x {
"If entropy is increasing, where is it coming from?\n"
}; text x {
"If you didn't get caught, did you really do it?\n"
}; text x {
"Documentation is the castor oil of programming. Managers\n",
"know it must be good because the programmers hate it so much.\n"
}; text x {
"Virtue is its own punishment.\n"
}; text x {
"Computer Science is merely the post-Turing decline in formal\n",
"systems theory.\n"
}; text x {
"Oh, wow! Look at the moon!\n"
}; text x {
"Cinemuck, n.:\n",
"The combination of popcorn, soda, and melted chocolate which\n",
"covers the floors of movie theaters.\n",
"\n",
"Rich Hall, ""Sniglets""\n"
}; text x {
"Finagle's Second Law:\n",
"No matter what the anticipated result, there will always\n",
"besomeone eager to (a) misinterpret it, (b) fake it, or (c)\n",
"believe it happened according to his own pet theory.\n"
}; text x {
"The notion of a ""record"" is an obsolete remnant of the days\n",
"of the 80-column card.\n",
"\n",
"Dennis M. Ritchie\n"
}; text x {
"Computers are not intelligent. They only think they are.\n"
}; text x {
"The rain it raineth on the just\n",
"And also on the unjust fella,\n",
"But chiefly on the just, because\n",
"The unjust steals the just's umbrella.\n"
}; text x {
"Spirtle, n.:\n",
"The fine stream from a grapefruit that always lands right in\n",
"your eye.\n",
"\n",
"Sniglets, ""Rich Hall & Friends""\n"
}; text x {
"Concept, n.:\n",
"Any ""idea"" for which an outside consultant billed you more\n",
"than $25,000.\n"
}; text x {
"Sodd's Second Law:\n",
"Sooner or later, the worst possible set of circumstances\n",
"is bound to occur.\n"
}; text x {
"It is easier to change the specification to fit the program\n",
"than vice versa.\n"
}; text x {
"""I am returning this otherwise good typing paper to you\n",
"because someone has printed gibberish all over it and put\n",
"your name at the top.""\n",
"\n",
"English Professor, Ohio University\n"
}; text x {
"Crash programs fail because they are based on the theory\n",
"that, with nine women pregnant, you can get a baby a month.--\n",
"Wernher von Braun\n"
}; text x {
"Heavy, adj.:\n",
"Seduced by the chocolate side of the force.\n"
}; text x {
"Never make anything simple and efficient when a way can be\n",
"found to make it complex and wonderful.\n"
}; text x {
"Nudists are people who wear one-button suits.\n"
}; text x {
"186,282 miles per second:\n",
"\n",
"It isn't just a good idea, it's the law!\n"
}; text x {
"Murphy's Law of Research:\n",
"Enough research will tend to support your theory.\n"
}; text x {
"Heller's Law:\n",
"The first myth of management is that it exists.\n",
"\n",
"Johnson's Corollary:\n",
"Nobody really knows what is going on anywhere within the\n",
"organization.\n"
}; text x {
"Spouse, n.:\n",
"Someone who'll stand by you through all the trouble you\n",
"wouldn't have had if you'd stayed single.\n"
}; text x {
"Die, v.:\n",
"To stop sinning suddenly.\n",
"\n",
"Elbert Hubbard\n"
}; text x {
"Those who educate children well are more to be honored than\n",
"parents, for these only gave life, those the art of living\n",
"well. -- Aristotle\n"
}; text x {
"Keep emotionally active. Cater to your favorite neurosis.\n"
}; text x {
"More than any time in history, mankind now faces a\n",
"crossroads. One path leads to despair and utter hopelessness,\n",
"the other to total extinction. Let us pray that we have the\n",
"wisdom to choose correctly.\n",
"\n",
"Woody Allen\n"
}; text x {
"Reisner's Rule of Conceptual Inertia:\n",
"If you think big enough, you'll never have to do it.\n"
}; text x {
"One seldom sees a monument to a committee.\n"
}; text x {
"If life is a stage, I want some better lighting.\n"
}; text x {
"Well, I would -- if they realized that we -- again if -- if\n",
"we led them back to that stalemate only because our\n",
"retaliatory power, our seconds, or strike at them after our\n",
"first strike, would be so destructive they they couldn't\n",
"afford it, that would hold them off.\n",
"\n",
"President Ronald Reagan, on the MX missile\n"
}; text x {
"Nature and nature's laws lay hid in night,\n",
"God said, ""Let Newton be,"" and all was light.\n",
"\n",
"It did not last; the devil howling ""Ho!\n",
"Let Einstein be!"" restored the status quo.\n"
}; text x {
"Man usually avoids attributing cleverness to somebody else,\n",
"unless it is an enemy.\n",
"\n",
"A. Einstein\n"
}; text x {
"If bankers can count, how come they have eight windows and\n",
"only four tellers?\n"
}; text x {
"""The society which scorns excellence in plumbing as a humble\n",
"activity and tolerates shoddiness in philosophy because it is\n",
"an exaulted activity will have neither good plumbing nor good\n",
"philosophy ... neither its pipes nor its theories will hold\n",
"water.""\n"
}; text x {
"Maintainer's Motto:\n",
"If we can't fix it, it ain't broke.\n"
}; text x {
"""We'll cross out that bridge when we come back to it later.""\n"
}; text x {
"Ehrman's Commentary:\n",
"1. Things will get worse before they get better.\n",
"2. Who said things would get better?\n"
}; text x {
"Vital papers will demonstrate their vitality by\n",
"spontaneously moving from where you left them to where you\n",
"can't find them.\n"
}; text x {
"Rule of Feline Frustration:\n",
"When your cat has fallen asleep on your lap and looks\n",
"utterly content and adorable, you will suddenly have to go to\n",
"the bathroom.\n"
}; text x {
"If scientific reasoning were limited to the logical\n",
"processes of arithmetic, we should not get very far in our\n",
"understanding of the physical world. One might as well\n",
"attempt to grasp the game of poker entirely by the use of the\n",
"mathematics of probability.\n",
"\n",
"Vannevar Bush\n"
}; text x {
"Once the realization is accepted that even between the\n",
"closest human beings infinite distances continue to exist, a\n",
"wonderful living side by side can grow up, if they succeed in\n",
"loving the distance between them which makes it possible for\n",
"each to see each other whole against the sky.\n",
"\n",
"Rainer Rilke\n"
}; text x {
"When a Banker jumps out of a window, jump after him,\n",
"that's where the money is.\n",
"\n",
"Robespierre\n"
}; text x {
"The only thing to do with good advice is pass it on. It is\n",
"never any use to oneself.\n",
"\n",
"Oscar Wilde\n"
}; text x {
"If we do not change our direction we are likely to end up\n",
"where we are headed.\n"
}; text x {
"The human race has one really effective weapon, and that is\n",
"laughter.\n",
"\n",
"Mark Twain\n"
}; text x {
"The only problem with being a man of leisure is that you can\n",
"never stop and take a rest.\n"
}; text x {
"Barach's Rule:\n",
"An alcoholic is a person who drinks more than his own\n",
"physician.\n"
}; text x {
"If there are epigrams, there must be meta-epigrams.\n"
}; text x {
"Oh don't the days seem lank and long\n",
"When all goes right and none goes wrong,\n",
"And isn't your life extremely flat\n",
"With nothing whatever to grumble at!\n"
}; text x {
"Your conscience never stops you from doing anything. It just\n",
"stops you from enjoying it.\n"
}; text x {
"""You can't teach people to be lazy - either they have it, or\n",
"they don't.""\n",
"Dagwood Bumstead\n"
}; text x {
"Science is what happens when preconception meets\n",
"verification.\n"
}; text x {
"Mencken and Nathan's Second Law of The Average American: All\n",
"the postmasters in small towns read all the postcards.\n"
}; text x {
"A candidate is a person who gets money from the rich and\n",
"votes from the poor to protect them from each other.\n"
}; text x {
"I profoundly believe it takes a lot of practice to become a\n",
"moral slob.\n",
"\n",
"William F. Buckley\n"
}; text x {
"You or I must yield up his life to Ahrimanes. I would rather\n",
"it were you. I should have no hesitation in sacrificing my\n",
"own life to spare yours, but we take stock next week, and it\n",
"would not be fair on the company.\n",
"\n",
"J. Wellington Wells\n"
}; text x {
"Furious activity is no substitute for understanding.\n",
"-- H. H. Williams\n"
}; text x {
"After I run your program, let's make love like crazed\n",
"weasels, OK?\n"
}; text x {
"As of next week, passwords will be entered in Morse code.\n"
}; text x {
"Travel important today; Internal Revenue men arrive\n",
"tomorrow.\n"
}; text x {
"Old age is the most unexpected of things that can happen to\n",
"a man.\n",
"\n",
"Trotsky\n"
}; text x {
"""All flesh is grass""\n",
"\n",
"Isaiah\n",
"\n",
"Smoke a friend today.\n"
}; text x {
"You may have heard that a dean is to faculty as a hydrant is\n",
"to a dog.\n",
"\n",
"Alfred Kahn\n"
}; text x {
"Know what I hate most? Rhetorical questions.\n",
"\n",
"Henry N. Camp\n"
}; text x {
"What if nothing exists and we're all in somebody's dream? Or\n",
"what's worse, what if only that fat guy in the third row\n",
"exists?\n",
"\n",
"Woody Allen, ""Without Feathers""\n"
}; text x {
"A bachelor is a selfish, undeserving guy who has cheated\n",
"some woman out of a divorce.\n",
"\n",
"Don Quinn\n"
}; text x {
"Take heart amid the deepening gloom that your dog is finally\n",
"getting enough cheese.\n",
"\n",
"National Lampoon, ""Deteriorada""\n"
}; text x {
"For every credibility gap, there is a gullibility fill.\n",
"\n",
"R. Clopton\n"
}; text x {
"If God had wanted you to go around nude, He would have given\n",
"you bigger hands.\n"
}; text x {
"Duct tape is like the force. It has a light side, and a dark\n",
"side, and it holds the universe together ...\n",
"\n",
"Carl Zwanzig\n"
}; text x {
"You will be a winner today. Pick a fight with a four-year-\n",
"old.\n"
}; text x {
"Dying is a very dull, dreary affair. And my advice to you is\n",
"to have nothing whatever to do with it.\n",
"\n",
"W. Somerset Maughm\n"
}; text x {
"What is worth doing is worth the trouble of asking somebody\n",
"to do.\n"
}; text x {
"Antonym, n.:\n",
"\n",
"The opposite of the word you're trying to think of.\n"
}; text x {
"Alas, I am dying beyond my means.\n",
"\n",
"Oscar Wilde, as he sipped champagne on his deathbed\n"
}; text x {
"All science is either physics or stamp collecting.\n",
"\n",
"E. Rutherford (who later won a Nobel prize in Chemistry)\n"
}; text x {
"If you can survive death, you can probably survive anything.\n"
}; text x {
"Boss, n.:\n",
"According to the Oxford English Dictionary, in the Middle\n",
"Ages the words ""boss"" and ""botch"" were largely\n",
"synonymous, except that boss, in addition to meaning ""a\n",
"supervisor of workers"" also meant ""an ornamental stud.""\n"
}; text x {
"Take everything in stride. Trample anyone who gets in your\n",
"way.\n"
}; text x {
"Whenever you find that you are on the side of the majority,\n",
"it is time to reform.\n",
"\n",
"Mark Twain\n"
}; text x {
"""I know not with what weapons World War III will be fought,\n",
"but World War IV will be fought with sticks and stones.""\n",
"\n",
"Albert Einstein\n"
}; text x {
"When more and more people are thrown out of work,\n",
"unemployment results.\n",
"\n",
"Calvin Coolidge\n"
}; text x {
"Hand, n.:\n",
"A singular instrument worn at the end of a human arm and\n",
"commonly thrust into somebody's pocket.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"Save energy: be apathetic.\n"
}; text x {
"Encyclopedia Salesmen:\n",
"Invite them all in. Nip out the back door. Phone the police\n",
"and tell them your house is being burgled.\n",
"Mike Harding, ""The Armchair Anarchist's Almanac""\n"
}; text x {
"Avoid reality at all costs.\n"
}; text x {
"I haven't lost my mind; I know exactly where I left it.\n"
}; text x {
"No man is an island, but some of us are long peninsulas.\n"
}; text x {
"""When in doubt, tell the truth.""\n",
"\n",
"Mark Twain\n"
}; text x {
"Famous last words:\n",
"1) ""Don't worry, I can handle it.""\n",
"2) ""You and what army?""\n",
"3) ""If you were as smart as you think you are, you wouldn't\n",
"be a cop.""\n"
}; text x {
"During the next two hours, the network will be going up and\n",
"down several times, often with lin~po_~{po~poz~ppo\~{ o\n",
"n~po_~{o[po~y\n",
"oodsou>No.w4k**n~po_~{ol;lkld;f;g;dd;po\~{o\n"
}; text x {
"LEO (July 23 - Aug 22)\n",
"You consider yourself a born leader. Others think you are\n",
"pushy. Most Leo people are bullies. You are vain and dislike\n",
"honest criticism. Your arrogance is disgusting. Leo people\n",
"are thieves.\n"
}; text x {
"I think that I shall never see\n",
"A billboard lovely as a tree.\n",
"Perhaps, unless the billboards fall\n",
"I'll never see a tree at all.\n",
"\n",
"Ogden Nash\n"
}; text x {
"Absence makes the heart go wander.\n"
}; text x {
"Afternoon very favorable for romance. Try a single person\n",
"for a change.\n"
}; text x {
"Someone will try to honk your nose today.\n"
}; text x {
"Q: Do you know what the death rate around here is?\n",
"A:One per person.\n"
}; text x {
"""I am not an Economist. I am an honest man!""\n",
"\n",
"Paul McCracken\n"
}; text x {
"The end of the world will occur at 3:00 p.m., this Friday,\n",
"with symposium to follow.\n"
}; text x {
"Human cardiac catheterization was introduced by Werner\n",
"Forssman in 1929. Ignoring his department chief, and tying\n",
"his assistant to an operating table to prevent his\n",
"interference, he placed a uretheral catheter into a vein in\n",
"his arm, advanced it to the right atrium [of his heart], and\n",
"walked upstairs to the x-ray department where he took the\n",
"confirmatory x-ray film. In 1956, Dr. Forssman was awarded\n",
"the Nobel Prize.\n"
}; text x {
"AMAZING BUT TRUE ...\n",
"\n",
"If all the salmon caught in Canada in one year were laid end\n",
"to end across the Sahara Desert, the smell would be\n",
"absolutely awful.\n"
}; text x {
"The Pig, if I am not mistaken,\n",
"Gives us ham and pork and Bacon.\n",
"Let others think his heart is big,\n",
"I think it stupid of the Pig.\n",
"\n",
"Ogden Nash\n"
}; text x {
"Chicken Soup, n.:\n",
"An ancient miracle drug containing equal parts of\n",
"aureomycin, cocaine, interferon, and TLC. The only ailment\n",
"chicken soup can't cure is neurotic dependence on one's\n",
"mother.\n",
"Arthur Naiman, ""Every Goy's Guide to Yiddish""\n"
}; text x {
"Beifeld's Principle:\n",
"The probability of a young man meeting a desirable and\n",
"receptive young female increases by pyramidal\n",
"progression when he is already in the company of: (1) a date,\n",
"(2) his wife, (3) a better looking and richer male friend.\n"
}; text x {
"Everything is controlled by a small evil group to which,\n",
"unfortunately, no one we know belongs.\n"
}; text x {
"Don't believe everything you hear or anything you say.\n"
}; text x {
"Barometer, n.:\n",
"An ingenious instrument which indicates what kind of weather\n",
"we are having.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"Every word is like an unnecessary stain on silence and\n",
"nothingness.\n",
"\n",
"Beckett\n"
}; text x {
"Think of your family tonight. Try to crawl home after the\n",
"computer crashes.\n"
}; text x {
"Tact, n.:\n",
"The unsaid part of what you're thinking.\n"
}; text x {
"It is against the grain of modern education to teach\n",
"children to program. What fun is there in making plans,\n",
"acquiring discipline in organizing thoughts, devoting\n",
"attention to detail, and learning to be self-critical?\n",
"\n",
"Alan Perlis\n"
}; text x {
"Gauls! We have nothing to fear; except perhaps that the sky\n",
"may fall on our heads tomorrow. But as we all know, tomorrow\n",
"never comes!!\n",
"\n",
"Adventures of Asterix.\n"
}; text x {
"Serocki's Stricture:\n",
"Marriage is always a bachelor's last option.\n"
}; text x {
"How many hardware engineers does it take to change a\n",
"lightbulb? None: ""We'll fix it in software.""\n",
"\n",
"How many software engineers does it take to change a\n",
"lightbulb? None: ""We'll document it in the manual.""\n",
"\n",
"How many tech writers does it take to change a lightbulb?\n",
"None: ""The user can work it out.""\n"
}; text x {
"Q: Why did the tachyon cross the road?\n",
"A: Because it was on the other side.\n"
}; text x {
"It is difficult to produce a television documentary that is\n",
"both incisive and probing when every twelve minutes one is\n",
"interrupted by twelve dancing rabbits singing about toilet\n",
"paper.\n",
"\n",
"R. Serling\n"
}; text x {
"How wonderful opera would be if there were no singers.\n"
}; text x {
"Your true value depends entirely on what you are compared\n",
"with.\n"
}; text x {
"Just because your doctor has a name for your condition\n",
"doesn't mean he knows what it is.\n"
}; text x {
"The Army has carried the American ... ideal to its logical\n",
"conclusion. Not only do they prohibit discrimination on the\n",
"grounds of race, creed and color, but also on ability.\n",
"\n",
"T. Lehrer\n"
}; text x {
"One thing the inventors can't seem to get the bugs out of is\n",
"fresh paint.\n"
}; text x {
"This planet has -- or rather had -- a problem, which was\n",
"this: most of the people living on it were unhappy for pretty\n",
"much of the time. Many solutions were suggested for this\n",
"problem, but most of these were largely concerned with the\n",
"movements of small green pieces of paper, which is odd\n",
"because on the whole it wasn't the small green pieces of\n",
"paper that were unhappy.\n",
"\n",
"Douglas Adams\n"
}; text x {
"Real Programmers don't play tennis, or any other sport that\n",
"requires you to change clothes. Mountain climbing is OK, and\n",
"real programmers wear their climbing boots to work in case a\n",
"mountain should suddenly spring up in the middle of the\n",
"machine room.\n"
}; text x {
"Mencken and Nathan's Fifteenth Law of The Average American:\n",
"The worst actress in the company is always the manager's\n",
"wife.\n"
}; text x {
"Those who can, do. Those who can't, simulate.\n"
}; text x {
"Two percent of zero is almost nothing.\n"
}; text x {
"The mosquito is the state bird of New Jersey.\n",
"\n",
"Andy Warhol\n"
}; text x {
"Practical people would be more practical if they would take\n",
"a little more time for dreaming.\n",
"\n",
"J. P. McEvoy\n"
}; text x {
"Do not sleep in a eucalyptus tree tonight.\n"
}; text x {
"The reasonable man adapts himself to the world; the\n",
"unreasonable one persists in trying to adapt the world to\n",
"himself. Therefore all progress depends on the unreasonable\n",
"man.\n",
"\n",
"George Bernard Shaw\n"
}; text x {
"Matter cannot be created or destroyed, nor can it be\n",
"returned without a receipt.\n"
}; text x {
"Who needs friends when you can sit alone in your room and\n",
"drink?\n"
}; text x {
"The chief cause of problems is solutions.\n"
}; text x {
"""Don't tell me I'm burning the candle at both ends -- tell\n",
"me where to get more wax!!""\n"
}; text x {
"Accordion, n.:\n",
"A bagpipe with pleats.\n"
}; text x {
"Good-bye. I am leaving because I am bored.\n",
"\n",
"George Saunders' dying words\n"
}; text x {
"We may not return the affection of those who like us, but we\n",
"always respect their good judgement.\n"
}; text x {
"Stay away from hurricanes for a while.\n"
}; text x {
"A vacuum is a hell of a lot better than some of the stuff\n",
"that nature replaces it with.\n",
"\n",
"Tenessee Williams\n"
}; text x {
"I never met a piece of chocolate I didn't like.\n"
}; text x {
"Honorable, adj.:\n",
"Afflicted with an impediment in one's reach. In\n",
"legislative bodies, it is customary to mention all members as\n",
"honorable; as, ""the honorable gentleman is a scurvy cur.""--\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"Q: How many surrealists does it take to change a light bulb?\n",
"A: Two. One to hold the girrafe and the other to fill the\n",
"bathtub with brightly colored machine tools.\n"
}; text x {
"Van Roy's Law:\n",
"An unbreakable toy is useful for breaking other toys.\n"
}; text x {
"A physicist is an atom's way of knowing about atoms.\n",
"-- George Wald\n"
}; text x {
"Malek's Law:\n",
"Any simple idea will be worded in the most complicated way.\n"
}; text x {
"When God endowed human beings with brains, He did not intend\n",
"to guarantee them.\n"
}; text x {
"I haven't lost my mind -- it's backed up on tape somewhere.\n"
}; text x {
"""There are two ways of disliking poetry; one way is to\n",
"dislike it, the other is to read Pope.""\n",
"\n",
"Oscar Wilde\n"
}; text x {
"The Third Law of Photography:\n",
"If you did manage to get any good shots, they will be\n",
"ruined when someone inadvertently opens the darkroom door and\n",
"all of the dark leaks out.\n"
}; text x {
"If Jesus Christ were to come today, people would not even\n",
"crucify him. They would ask him to dinner, and hear what he\n",
"had to say, and make fun of it.\n",
"\n",
"Thomas Carlyle\n"
}; text x {
"We will have solar energy as soon as the utility companies\n",
"solve one technical problem -- how to run a sunbeam through\n",
"a meter.\n"
}; text x {
"Good day for overcoming obstacles. Try a steeplechase.\n"
}; text x {
"Nostalgia isn't what it used to be.\n"
}; text x {
"Every gun that is made, every warship launched, every rocket\n",
"fired signifies in the final sense, a theft from those who\n",
"hunger and are not fed, those who are cold and are not\n",
"clothed. This world in arms is not spending money alone. It\n",
"is spending the sweat of its laborers, the genius of its\n",
"scientists, the hopes of its children. This is not a way of\n",
"life at all in any true sense. Under the clouds of war, it is\n",
"humanity hanging on a cross of iron.\n",
"\n",
"Dwight Eisenhower, April 16, 1953\n"
}; text x {
"If you think education is expensive, try ignorance.\n",
"\n",
"Derek Bok, president of Harvard\n"
}; text x {
"Alliance, n.:\n",
"In international politics, the union of two thieves who have\n",
"their hands so deeply inserted in each other's pocket that\n",
"they cannot separately plunder a third.\n",
"-- Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"Everyone talks about apathy, but no one does\n",
"anything about it.\n"
}; text x {
"""Life may have no meaning -- or even worse, it may have a\n",
"meaning of which I disapprove.""\n"
}; text x {
"It is now pitch dark. If you proceed, you will likely fall\n",
"into a pit.\n"
}; text x {
"Amnesia used to be my favorite word, but then I forgot it.\n"
}; text x {
"Living on Earth may be expensive, but it includes an annual\n",
"free trip around the Sun.\n"
}; text x {
"Anyone who cannot cope with mathematics is not fully human.\n",
"At best he is a tolerable subhuman who has learned to wear\n",
"shoes, bathe and not make messes in the house.\n",
"\n",
"Lazarus Long, ""Time Enough for Love""\n"
}; text x {
"Heaven, n.:\n",
"A place where the wicked cease from troubling you with talk\n",
"of their personal affairs, and the good listen with attention\n",
"while you expound your own.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"Information Center, n.:\n",
"A room staffed by professional computer people whose job it\n",
"is to tell you why you cannot have the information you\n",
"require.\n"
}; text x {
"Shamus, n.:\n",
"A shamus is a guy who takes care of handyman tasks around the\n",
"temple, and makes sure everything is in working order.\n",
"A shamus is at the bottom of the pecking order of\n",
"synagog functionaries, and there's a joke about that:\n",
"\n",
"A rabbi, to show his humility before God, cries out in the\n",
"middle of a service, ""Oh, Lord, I am nobody!"" The cantor, not\n",
"to be bested, also cries out, ""Oh, Lord, I am nobody!"" The\n",
"shamus, deeply moved, follows suit and cries, ""Oh, Lord, I am\n",
"nobody!"" The rabbi turns to the cantor and says, ""Now look\n",
"who\n",
"thinks he's nobody!""\n",
"\n",
"Arthur Naiman, ""Every Goy's Guide to Yiddish""\n"
}; text x {
"Positive, adj.: Mistaken at the top of one's voice.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"Sweater, n.:\n",
"A garment worn by a child when its mother feels chilly.\n"
}; text x {
"Once ... in the wilds of Afghanistan, I lost my corkscrew,\n",
"and we were forced to live on nothing but food and water for\n",
"days.\n",
"\n",
"W. C. Fields, ""My Little Chickadee""\n"
}; text x {
"You will be surprised by a loud noise.\n"
}; text x {
"There's so much plastic in this culture that vinyl leopard\n",
"skin is becoming an endangered synthetic.\n",
"\n",
"Lily Tomlin\n"
}; text x {
"Williams and Holland's Law:\n",
"If enough data is collected, anything may be proven by\n",
"statistical methods.\n"
}; text x {
"In America, any boy may become president and I suppose\n",
"that's just one of the risks he takes.\n",
"\n",
"Adlai Stevenson\n"
}; text x {
"Hell hath no fury like a bureaucrat scorned.\n",
"\n",
"Milton Friedman\n"
}; text x {
"Good advice is something a man gives when he is too old to\n",
"set a bad example.\n",
"\n",
"La Rouchefoucauld\n"
}; text x {
"The typewriting machine, when played with expression, is no\n",
"more annoying than the piano when played by a sister or near\n",
"relation.\n",
"\n",
"Oscar Wilde\n"
}; text x {
"Technological progress has merely provided us with more\n",
"efficient means for going backwards.\n",
"\n",
"Aldous Huxley\n"
}; text x {
"Quick!! Act as if nothing has happened!\n"
}; text x {
"Never worry about theory as long as the machinery does what\n",
"it's supposed to do.\n",
"\n",
"R. A. Heinlein\n"
}; text x {
"Another good night not to sleep in a eucalyptus tree.\n"
}; text x {
"I hate quotations.\n",
"Ralph Waldo Emerson\n"
}; text x {
"Any two philosophers can tell each other all they know in\n",
"two hours.\n",
"\n",
"Oliver Wendell Holmes, Jr.\n"
}; text x {
"Just because you're paranoid doesn't mean they AREN'T after\n",
"you.\n"
}; text x {
"Take it easy, we're in a hurry.\n"
}; text x {
"As with most fine things, chocolate has its season. There is\n",
"a simple memory aid that you can use to determine whether it\n",
"is the correct time to order chocolate dishes: any month\n",
"whose name contains the letter A, E, or U is the proper time\n",
"for chocolate.\n",
"\n",
"Sandra Boynton, ""Chocolate: The Consuming Passion""\n"
}; text x {
"Acquaintance, n.:\n",
"A person whom we know well enough to borrow from, but not\n",
"well enough to lend to.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"Get Revenge! Live long enough to be a problem for your\n",
"children!\n"
}; text x {
"Keep grandma off the streets -- legalize bingo.\n"
}; text x {
"Good day to let down old friends who need help.\n"
}; text x {
"Some people are born mediocre, some people achieve\n",
"mediocrity, and some people have mediocrity thrust upon\n",
"them.\n",
"\n",
"Joseph Heller, ""Catch-22""\n"
}; text x {
"Anything is good and useful if it's made of chocolate.\n"
}; text x {
"Green light in A.M. for new projects. Red light in P.M. for\n",
"traffic tickets.\n"
}; text x {
"Good news. Ten weeks from Friday will be a pretty good day.\n"
}; text x {
"Liar, n.:\n",
"A lawyer with a roving commission.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"Real Time, adj.:\n",
"Here and now, as opposed to fake time, which only occurs\n",
"there and then.\n"
}; text x {
"Magnocartic, adj.:\n",
"Any automobile that, when left unattended, attracts shopping\n",
"carts.\n",
"\n",
"Sniglets, ""Rich Hall & Friends""\n"
}; text x {
"A bore is someone who persists in holding his own views\n",
"after we have enlightened him with ours.\n"
}; text x {
"Condense soup, not books!\n"
}; text x {
"People usually get what's coming to them ... unless it's\n",
"been mailed.\n"
}; text x {
"Go 'way! You're bothering me!\n"
}; text x {
"Command, n.:\n",
"Statement presented by a human and accepted by a computer\n",
"in such a manner as to make the human feel as if he is in\n",
"control.\n"
}; text x {
"A lack of leadership is no substitute for inaction.\n"
}; text x {
"After all, what is your hosts' purpose in having a party?\n",
"Surely not for you to enjoy yourself; if that were their sole\n",
"purpose, they'd have simply sent champagne and women over to\n",
"your place by taxi.\n",
"\n",
"P. J. O'Rourke\n"
}; text x {
"Celebrate Hannibal Day this year. Take an elephant to lunch.\n"
}; text x {
"The older a man gets, the farther he had to walk to school\n",
"as a boy.\n"
}; text x {
"Newton's Little-Known Seventh Law:\n",
"A bird in the hand is safer than one overhead.\n"
}; text x {
"Whistler's Law:\n",
"You never know who is right, but you always know who is\n",
"in charge.\n"
}; text x {
"It's really quite a simple choice: Life, Death, or Los\n",
"Angeles.\n"
}; text x {
"Bank error in your favor. Collect $200.\n"
}; text x {
"Linus:I guess it's wrong always to be worrying about\n",
"tomorrow. Maybe we should think only about today.\n",
"Charlie Brown: No, that's giving up. I'm still hoping that\n",
"yesterday will get better.\n"
}; text x {
"Keep you Eye on the Ball,\n",
"Your Shoulder to the Wheel,\n",
"Your Nose to the Grindstone,\n",
"Your Feet on the Ground,\n",
"Your Head on your Shoulders.\n",
"Now ... try to get something DONE!\n"
}; text x {
"Absent, adj.:\n",
"Exposed to the attacks of friends and acquaintances; defamed;\n",
"slandered.\n"
}; text x {
"Truly great madness can not be achieved without significant\n",
"intelligence.\n",
"\n",
"Henrik Tikkanen\n"
}; text x {
"Simon's Law:\n",
"Everything put together falls apart sooner or later.\n"
}; text x {
"Has everyone noticed that all the letters of the word\n",
"""database"" are typed with the left hand? Now the layout of\n",
"the QWERTYUIOP typewriter keyboard was designed, among other\n",
"things, to facilitate the even use of both hands. It follows,\n",
"therefore, that writing about databases is not only\n",
"unnatural, but a lot harder than it appears.\n"
}; text x {
"Lewis's Law of Travel:\n",
"The first piece of luggage out of the chute doesn't belong to\n",
"anyone, ever.\n"
}; text x {
"You can tell how far we have to go, when FORTRAN is the\n",
"language of supercomputers.\n",
"\n",
"Steven Feiner\n"
}; text x {
"Whatever became of eternal truth?\n"
}; text x {
"A lot of people I know believe in positive thinking, and so\n",
"do I. I believe everything positively stinks.\n",
"\n",
"Lew Col\n"
}; text x {
"""If you go on with this nuclear arms race, all you are going\n",
"to do is make the rubble bounce""\n",
"\n",
"Winston Churchill\n"
}; text x {
"Recession is when your neighbor loses his job. Depression is\n",
"when you lose your job. These economic downturns are very\n",
"difficult to predict, but sophisticated econometric modeling\n",
"houses like Data Resources and Chase Econometrics have\n",
"successfully predicted 14 of the last 3 recessions.\n"
}; text x {
"God is really only another artist. He invented the giraffe,\n",
"the elephant and the cat. He has no real style, He just goes\n",
"on trying other things.\n",
"\n",
"Pablo Picasso\n"
}; text x {
"""If dolphins are so smart, why did Flipper work for\n",
"television?""\n"
}; text x {
"Pereant, inquit, qui ante nos nostra dixerunt.\n",
"""Confound those who have said our remarks before us.""\n",
"\n",
"Aelius Donatus\n"
}; text x {
"There is no satisfaction in hanging a man who does not\n",
"object to it\n",
"\n",
"G. B. Shaw\n"
}; text x {
"Nihilism should commence with oneself.\n"
}; text x {
"Yes, but which self do you want to be?\n"
}; text x {
"""What is the robbing of a bank compared to the FOUNDING of\n",
"a bank?""\n",
"\n",
"Bertold Brecht\n"
}; text x {
"The man who follows the crowd will usually get no further\n",
"than the crowd. The man who walks alone is likely to find\n",
"himself in places no one has ever been.\n",
"\n",
"Alan Ashley-Pitt\n"
}; text x {
"I used to get high on life but lately I've built up a\n",
"resistance.\n"
}; text x {
"Rudin's Law:\n",
"If there is a wrong way to do something, most people will do\n",
"it every time.\n"
}; text x {
"Dawn, n.:\n",
"The time when men of reason go to bed.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"Common sense is the collection of prejudices acquired by age\n",
"eighteen.\n",
"\n",
"Albert Einstein\n"
}; text x {
"Peace, n.:\n",
"In international affairs, a period of cheating between two\n",
"periods of fighting.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"""To vacillate or not to vacillate, that is the question ...\n",
"or is it?""\n"
}; text x {
"Only God can make random selections.\n"
}; text x {
"I'm in Pittsburgh. Why am I here?\n",
"\n",
"Harold Urey, Nobel Laureate\n"
}; text x {
"Automobile, n.:\n",
"A four-wheeled vehicle that runs up hills and down\n",
"pedestrians.\n"
}; text x {
"""For that matter, compare your pocket computer with the\n",
"massive jobs of a thousand years ago. Why not, then, the last\n",
"step of doing away with computers altogether?""\n",
"\n",
"Jehan Shuman\n"
}; text x {
"Living your life is a task so difficult, it has never been\n",
"attempted before.\n"
}; text x {
"There cannot be a crisis next week. My schedule is already\n",
"full.\n",
"\n",
"Henry Kissinger\n"
}; text x {
"Any excuse will serve a tyrant.\n",
"\n",
"Aesop\n"
}; text x {
"""Kirk to Enterprise -- beam down yeoman Rand and a six-\n",
"pack.""\n"
}; text x {
"""Hey! Who took the cork off my lunch??!""\n",
"\n",
"W. C. Fields\n"
}; text x {
"She's genuinely bogus.\n"
}; text x {
"""His mind is like a steel trap -- full of mice""\n",
"-- Foghorn Leghorn\n"
}; text x {
"Mencken and Nathan's Sixteenth Law of The Average American:\n",
"Milking a cow is an operation demanding a special talent that\n",
"is possessed only by yokels, and no person born in a large\n",
"city can never hope to acquire it.\n"
}; text x {
"Whenever anyone says, ""theoretically"", they really mean,\n",
"""not really"".\n",
"\n",
"Dave Parnas\n"
}; text x {
"Be different: conform.\n"
}; text x {
"You will be Told about it Tomorrow. Go Home and Prepare\n",
"Thyself.\n"
}; text x {
"Sattinger's Law:\n",
"It works better if you plug it in.\n"
}; text x {
"About the time we think we can make ends meet, somebody\n",
"moves the ends.\n",
"\n",
"Herbert Hoover\n"
}; text x {
"It has been observed that one's nose is never so happy as\n",
"when it is thrust into the affairs of another, from which\n",
"some physiologists have drawn the inference that the nose is\n",
"devoid of the sense of smell.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"McGowan's Madison Avenue Axiom:\n",
"If an item is advertised as ""under $50"", you can bet it's\n",
"not $19.95.\n"
}; text x {
"While money can't buy happiness, it certainly lets you\n",
"choose your own form of misery.\n"
}; text x {
"Fakir, n:\n",
"A psychologist whose charismatic data have inspired almost\n",
"religious devotion in his followers, even though the sources\n",
"seem to have shinnied up a rope and vanished.\n"
}; text x {
"Don't worry about the world coming to an end today. It's\n",
"already tomorrow in Australia.\n",
"\n",
"Charles Schultz\n"
}; text x {
"I really hate this damned machine\n",
"I wish that they would sell it.\n",
"It never does quite what I want\n",
"But only what I tell it.\n"
}; text x {
"PISCES (Feb. 19 - Mar. 20)\n",
"You have a vivid imagination and often think you are being\n",
"followed by the CIA or FBI. You have minor influence over\n",
"your associates and people resent your flaunting of your\n",
"power. You lack confidence and you are generally a coward.\n",
"Pisces people do terrible things to small animals.\n"
}; text x {
"Time flies like an arrow\n",
"Fruit flies like a banana\n"
}; text x {
"If there is no God, who pops up the next Kleenex?\n",
"\n",
"Art Hoppe\n"
}; text x {
"Eighty percent of air pollution comes from plants and\n",
"trees.\n",
"\n",
"Ronald Reagan, famous movie star\n"
}; text x {
"Rule 46, Oxford Union Society, London:\n",
"Any member introducing a dog into the Society's premises\n",
"shall be liable to a fine of one pound. Any animal\n",
"leading a blind person shall be deemed to be a cat.\n"
}; text x {
"Churchill's Commentary on Man:\n",
"Man will occasionally stumble over the truth, but most of\n",
"the time he will pick himself up and continue on.\n"
}; text x {
"Steinbach's Guideline for Systems Programming\n",
"Never test for an error condition you don't know how to\n",
"handle.\n"
}; text x {
"Money is the root of all evil, and man needs roots\n"
}; text x {
"Albert Einstein, when asked to describe radio, replied: ""You\n",
"see, wire telegraph is a kind of a very, very long cat. You\n",
"pull his tail in New York and his head is meowing in Los\n",
"Angeles. Do you understand this? And radio operates exactly\n",
"the same way: you send signals here, they receive them there.\n",
"The only difference is that there is no cat.""\n"
}; text x {
"How come only your friends step on your new white sneakers?\n"
}; text x {
"Arnold's Laws of Documentation:\n",
"(1) If it should exist, it doesn't.\n",
"(2) If it does exist, it's out of date.\n",
"(3) Only documentation for useless programs transcends\n",
"the first two laws.\n"
}; text x {
"We can defeat gravity. The problem is the paperwork\n",
"involved.\n"
}; text x {
"The opossum is a very sophisticated animal. It doesn't even\n",
"get up until 5 or 6 pm.\n"
}; text x {
"Putt's Law:\n",
"Technology is dominated by two types of people:\n",
"Those who understand what they do not manage. Those who\n",
"manage what they do not understand.\n"
}; text x {
"Know thyself. If you need help, call the C.I.A.\n"
}; text x {
"Labor, n.:\n",
"One of the processes by which A acquires property for B.--\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"CAPRICORN (Dec 23 - Jan 19)\n",
"You are conservative and afraid of taking risks. You don't do\n",
"much of anything and are lazy. There has never been a\n",
"Capricorn of any importance. Capricorns should avoid standing\n",
"still for too long as they take root and become trees.\n"
}; text x {
"All progress is based upon a universal innate desire on the\n",
"part of every organism to live beyond its income.\n",
"\n",
"Samuel Butler\n"
}; text x {
"Micro Credo:\n",
"Never trust a computer bigger than you can lift.\n"
}; text x {
"Conceit causes more conversation than wit.\n",
"\n",
"LaRouchefoucauld\n"
}; text x {
"BLISS is ignorance\n"
}; text x {
"Mollison's Bureaucracy Hypothesis:\n",
"If an idea can survive a bureaucratic review and be\n",
"implementedit wasn't worth doing.\n"
}; text x {
"He hadn't a single redeeming vice.\n",
"\n",
"Oscar Wilde\n"
}; text x {
"Unquestionably, there is progress. The average American now\n",
"pays out twice as much in taxes as he formerly got in wages.-\n",
"\n",
"H. L. Mencken\n"
}; text x {
"Ducharm's Axiom:\n",
"\n",
"If you view your problem closely enough you will\n",
"recognize yourself as part of the problem.\n"
}; text x {
"It is easier to write an incorrect program than understand\n",
"a correct one.\n"
}; text x {
"It is not enough to succeed. Others must fail.\n",
"Gore Vidal\n"
}; text x {
"Nothing is faster than the speed of light ...\n",
"\n",
"To prove this to yourself, try opening the refrigerator door\n",
"before the light comes on.\n"
}; text x {
"Do not try to solve all life's problems at once -- learn to\n",
"dread each day as it comes.\n",
"\n",
"Donald Kaul\n"
}; text x {
"Vote anarchist\n"
}; text x {
"Tussman's Law:\n",
"Nothing is as inevitable as a mistake whose time has come.\n"
}; text x {
"The trouble with doing something right the first time is\n",
"that nobody appreciates how difficult it was.\n"
}; text x {
"Madam, there's no such thing as a tough child -- if you\n",
"parboil them first for seven hours, they always come out\n",
"tender.\n",
"\n",
"W. C. Fields\n"
}; text x {
"Sturgeon's Law:\n",
"90% of everything is crud.\n"
}; text x {
"Polymer physicists are into chains.\n"
}; text x {
"When Marriage is Outlawed,\n",
"Only Outlaws will have Inlaws.\n"
}; text x {
"BE ALERT!!!! (The world needs more lerts ...)\n"
}; text x {
"One can't proceed from the informal to the formal by formal\n",
"means.\n"
}; text x {
"Like the ski resort of girls looking for husbands and\n",
"husbands looking for girls, the situation is not as\n",
"symmetrical as it might seem.\n",
"\n",
"Alan McKay\n"
}; text x {
"Larkinson's Law:\n",
"All laws are basically false.\n"
}; text x {
"""Don't say yes until I finish talking.""\n",
"\n",
"Darryl F. Zanuck\n"
}; text x {
"A city is a large community where people are lonesome\n",
"together\n",
"\n",
"Herbert Prochnow\n"
}; text x {
"[Sir Stafford Cripps] has all the virtues I dislike and none\n",
"of the vices I admire.\n",
"\n",
"Winston Churchill\n"
}; text x {
"Let us live!!!\n",
"Let us love!!!\n",
"Let us share the deepest secrets of our souls!!!\n",
"\n",
"You first.\n"
}; text x {
"One Page Principle:\n",
"A specification that will not fit on one page of 8.5x11 inch\n",
"paper cannot be understood.\n",
"\n",
"Mark Ardis\n"
}; text x {
"""The warning message we sent the Russians was a calculated\n",
"ambiguity that would be clearly understood.""\n",
"\n",
"Alexander Haig\n"
}; text x {
"If you perceive that there are four possible ways in which\n",
"a procedure can go wrong, and circumvent these, then a fifth\n",
"way will promptly develop.\n"
}; text x {
"""Man invented language to satisfy his deep need to\n",
"complain.""\n",
"\n",
"Lily Tomlin\n"
}; text x {
"All I ask of life is a constant and exaggerated sense of my\n",
"own importance.\n"
}; text x {
"Bore, n.:\n",
"A person who talks when you wish him to listen.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"If you make people think they're thinking, they'll love you;\n",
"but if you really make them think they'll hate you.\n"
}; text x {
"The problem with any unwritten law is that you don't know\n",
"where to go to erase it.\n",
"\n",
"Glaser and Way\n"
}; text x {
"I do not fear computers. I fear the lack of them.\n",
"\n",
"Isaac Asimov\n"
}; text x {
"Jenkinson's Law:\n",
"It won't work.\n"
}; text x {
"Every successful person has had failures but repeated\n",
"failure is no guarantee of eventual success.\n"
}; text x {
"Men were real men, women were real women, and small, furry\n",
"creatures from Alpha Centauri were REAL small, furry\n",
"creatures from Alpha Centauri. Spirits were brave, men boldly\n",
"split infinitives that no man had split before. Thus was the\n",
"Empire forged.\n",
"""The Hitchhiker's Guide to the Galaxy"", Douglas Adams\n"
}; text x {
"""Just once, I wish we would encounter an alien menace that\n",
"wasn't immune to bullets""\n",
"\n",
"The Brigader, ""Dr. Who""\n"
}; text x {
"There's an old proverb that says just about whatever you\n",
"want it to.\n"
}; text x {
"Don't go around saying the world owes you a living. The\n",
"world owes you nothing. It was here first.\n",
"\n",
"Mark Twain\n"
}; text x {
"My opinions may have changed, but not the fact that I am\n",
"right.\n"
}; text x {
"Question:\n",
"Man Invented Alcohol,\n",
"God Invented Grass.\n",
"Who do you trust?\n"
}; text x {
"Weiner's Law of Libraries:\n",
"There are no answers, only cross references.\n"
}; text x {
"""The sooner you fall behind, the more time you'll have to\n",
"catch up!""\n"
}; text x {
"For every complex problem, there is a solution that is\n",
"simple, neat, and wrong.\n",
"\n",
"H. L. Mencken\n"
}; text x {
"As far as we know, our computer has never had an undetected\n",
"error.\n",
"\n",
"Weisert\n"
}; text x {
"The problem with the gene pool is that there is no\n",
"lifeguard.\n"
}; text x {
"Mad, adj.:\n",
"Affected with a high degree of intellectual independence ...\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"Conway's Law:\n",
"In any organization there will always be one person who knows\n",
"what is going on.\n",
"\n",
"This person must be fired.\n"
}; text x {
"To invent, you need a good imagination and a pile of junk.\n",
"\n",
"Thomas Edison\n"
}; text x {
"Predestination was doomed from the start.\n"
}; text x {
"Even though they raised the rate for first class mail in the\n",
"United States we really shouldn't complain -- it's still only\n",
"2 cents a day.\n"
}; text x {
"What use is magic if it can't save a unicorn?\n",
"\n",
"Peter S. Beagle, ""The Last Unicorn""\n"
}; text x {
"TV is chewing gum for the eyes.\n",
"\n",
"Frank Lloyd Wright\n"
}; text x {
"""These are DARK TIMES for all mankind's HIGHEST VALUES!""\n",
"""These are DARK TIMES for FREEDOM and PROSPERITY!""\n",
"""These are GREAT TIMES to put your money on BAD GUY to kick\n",
"the CRAP out of MEGATON MAN!""\n"
}; text x {
"If the code and the comments disagree, then both are\n",
"probably wrong. -- Norm Schryer\n"
}; text x {
"Mythology, n.:\n",
"The body of a primitive people's beliefs concerning its\n",
"origin, early history, heroes, deities and so forth, as\n",
"distinguished from the true accounts which it invents later.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"The shortest distance between two points is under\n",
"construction.\n",
"\n",
"Noelie Altito\n"
}; text x {
"Optimization hinders evolution.\n"
}; text x {
"Ducharme's Precept:\n",
"Opportunity always knocks at the least opportune moment.\n"
}; text x {
"When all other means of communication fail, try words.\n"
}; text x {
"When a shepherd goes to kill a wolf, and takes his dog along\n",
"to see the sport, he should take care to avoid mistakes. The\n",
"dog has certain relationships to the wolf the shepherd may\n",
"have forgotten. -- Robert Pirsig, ""Zen and the Art of\n",
"Motorcycle Maintenance""\n"
}; text x {
"Every program has at least one bug and can be shortened by\n",
"at least one instruction -- from which, by induction, one can\n",
"deduce that every program can be reduced to one instruction\n",
"which doesn't work.\n"
}; text x {
"Show respect for age. Drink good Scotch for a change.\n"
}; text x {
"Fresco's Discovery:\n",
"If you knew what you were doing you'd probably be bored.\n"
}; text x {
"There's only one way to have a happy marriage and as soon as\n",
"I learn what it is I'll get married again.\n",
"\n",
"Clint Eastwood\n"
}; text x {
"Anything labeled ""NEW"" and/or ""IMPROVED"" isn't. The label\n",
"means the price went up. The label ""ALL NEW"", ""COMPLETELY\n",
"NEW"", or ""GREAT NEW"" means the price went way up.\n"
}; text x {
"Miss, n.:\n",
"A title with which we brand unmarried women to indicate that\n",
"they are in the market.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"""The voters have spoken, the bastards ...""\n"
}; text x {
"Self Test for Paranoia:\n",
"You know you have it when you can't think of anything\n",
"that's your own fault.\n"
}; text x {
"""Not only is this incomprehensible, but the ink is ugly and\n",
"the paper is from the wrong kind of tree.""\n",
"\n",
"Profesoor W.\n"
}; text x {
"Easiest Color to Solve on a Rubik's Cube:\n",
"Black. Simply remove all the little colored stickers on the\n",
"cube, and each of side of the cube will now be the\n",
"original color of the plastic underneath -- black. According\n",
"to the instructions, this means the puzzle is solved.\n",
"\n",
"Steve Rubenstein\n"
}; text x {
"""Matrimony isn't a word, it's a sentence.""\n"
}; text x {
"In our civilization, and under our republican form of\n",
"government, intelligence is so highly honored that it is\n",
"rewarded by exemption from the cares of office.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"Menu, n.:\n",
"A list of dishes which the restaurant has just run out of.\n"
}; text x {
"Ingrate, n.:\n",
"A man who bites the hand that feeds him, and then\n",
"complains of indigestion.\n"
}; text x {
"Underlying Principle of Socio-Genetics:\n",
"Superiority is recessive.\n"
}; text x {
"It's a damn poor mind that can only think of one way to\n",
"spell a word.\n",
"\n",
"Andrew Jackson\n"
}; text x {
"You never know how many friends you have until you rent a\n",
"house on the beach.\n"
}; text x {
"To be sure of hitting the target, shoot first and, whatever\n",
"you hit, call it the target.\n"
}; text x {
"United Nations, New York, December 25. The peace and joy of\n",
"the Christmas season was marred by a proclamation of a\n",
"general strike of all the military forces of the world. Panic\n",
"reigns in the hearts of all the patriots of every persuasion.\n",
"\n",
"Meanwhile, fears of universal disaster sank to an all-time\n",
"low over the world.\n",
"\n",
"Isaac Asimov\n"
}; text x {
"Honk if you love peace and quiet.\n"
}; text x {
"The cow is nothing but a machine with makes grass fit for us\n",
"people to eat.\n",
"\n",
"John McNulty\n"
}; text x {
"Experience is what you get when you were expecting something\n",
"else.\n"
}; text x {
"Ask not for whom the telephone bell tolls ... if thou art in\n",
"the bathtub, it tolls for thee.\n"
}; text x {
"Broad-mindedness, n.:\n",
"The result of flattening high-mindedness out.\n"
}; text x {
"BULLWINKLE: ""You just leave that to my pal. He's the brains\n",
"of the outfit.""\n",
"GENERAL: ""What does that make YOU?""\n",
"BULLWINKLE: ""What else? An executive...""\n",
"\n",
"Jay Ward\n"
}; text x {
"Imagination is the one weapon in the war against reality.\n",
"\n",
"Jules de Gaultier\n"
}; text x {
"Today's scientific question is: What in the world is\n",
"electricity?\n",
"\n",
"And where does it go after it leaves the toaster?\n",
"\n",
"Dave Barry, ""What is Electricity?""\n"
}; text x {
"Glib's Fourth Law of Unreliability:\n",
"Investment in reliability will increase until it exceeds the\n",
"probable cost of errors, or until someone insists on\n",
"gettingsome useful work done.\n"
}; text x {
"Serving coffee on aircraft causes turbulence.\n"
}; text x {
"Electrocution, n.:\n",
"Burning at the stake with all the modern improvements.\n"
}; text x {
"Let He who taketh the Plunge Remember to return it by\n",
"Tuesday.\n"
}; text x {
"Mark's Dental-Chair Discovery:\n",
"Dentists are incapable of asking questions that require\n",
"a simple yes or no answer.\n"
}; text x {
"""Why is it that we rejoice at a birth and grieve at a\n",
"funeral? It is because we are not the person involved""\n",
"\n",
"Mark Twain\n"
}; text x {
"""Stealing a rhinoceros should not be attempted lightly.""\n"
}; text x {
"If you cannot convince them, confuse them.\n",
"\n",
"Harry S Truman\n"
}; text x {
"The one good thing about repeating your mistakes is that you\n",
"know when to cringe.\n"
}; text x {
"If you put garbage in a computer nothing comes out but\n",
"garbage. But this garbage, having passed through a very\n",
"expensive machine, is somehow enobled and none dare criticize\n",
"it.\n"
}; text x {
"It is much easier to suggest solutions when you know nothing\n",
"about the problem.\n"
}; text x {
"""I refuse to have a battle of wits with an unarmed person.""\n"
}; text x {
"""Heisenberg may have slept here""\n"
}; text x {
"If I had any humility I would be perfect.\n",
"\n",
"Ted Turner\n"
}; text x {
"He's the kind of guy, that, well, if you were ever in a jam\n",
"he'd be there ... with two slices of bread and some chunky\n",
"peanut butter.\n"
}; text x {
"Bucy's Law:\n",
"Nothing is ever accomplished by a reasonable man.\n"
}; text x {
"What is the difference between a Turing machine and the\n",
"modern computer? It's the same as that between Hillary's\n",
"ascent of Everest and the establishment of a Hilton on its\n",
"peak.\n"
}; text x {
"Psychiatrists say that one out of four people are mentally\n",
"ill. Check three friends. If they're ok, you're it.\n"
}; text x {
"The longer I am out of office, the more infallible I appear\n",
"to myself.\n",
"\n",
"Henry Kissinger\n"
}; text x {
"Never hit a man with glasses. Hit him with a baseball bat.\n"
}; text x {
"Chism's Law of Completion:\n",
"The amount of time required to complete a government project\n",
"is precisely equal to the length of time already spent on it.\n"
}; text x {
"Just remember: when you go to court, you are trusting your\n",
"fate to twelve people that weren't smart enough to get out of\n",
"jury duty!\n"
}; text x {
"The biggest difference between time and space is that you\n",
"can't reuse time.\n",
"\n",
"Merrick Furst\n"
}; text x {
"Oh, well, I guess this is just going to be one of those\n",
"lifetimes.\n"
}; text x {
"AQUARIUS (Jan 20 - Feb 18)\n",
"You have an inventive mind and are inclined to be\n",
"progressive. You lie a great deal. On the other hand, you are\n",
"inclined to be careless and impractical, causing you to make\n",
"the same mistakes over and over again. People think you are\n",
"stupid.\n"
}; text x {
"There is only one thing in the world worse than being talked\n",
"about, and that is not being talked about.\n",
"\n",
"Oscar Wilde\n"
}; text x {
"Newlan's Truism:\n",
"An ""acceptable"" level of unemployment means that the\n",
"government economist to whom it is acceptable still has a\n",
"job.\n"
}; text x {
"Anarchy may not be the best form of government, but it's\n",
"better than no government at all.\n"
}; text x {
"Death is God's way of telling you not to be such a wise guy.\n"
}; text x {
"Hacker's Law:\n",
"The belief that enhanced understanding will necessarily stir\n",
"a nation to action is one of mankind's oldest illusions.\n"
}; text x {
"Turnaucka's Law:\n",
"The attention span of a computer is only as long as its\n",
"electrical cord.\n"
}; text x {
"Leibowitz's Rule:\n",
"When hammering a nail, you will never hit your finger if you\n",
"hold the hammer with both hands.\n"
}; text x {
"Bureaucrat, n.:\n",
"A politician who has tenure.\n"
}; text x {
"Feel disillusioned? I've got some great new illusions ...\n"
}; text x {
"On a paper submitted by a physicist colleague:\n",
"\n",
"""This isn't right. This isn't even wrong.""\n",
"\n",
"Wolfgang Pauli\n"
}; text x {
"Hanson's Treatment of Time:\n",
"There are never enough hours in a day, but always too many\n",
"days before Saturday.\n"
}; text x {
"LIBRA (Sep. 23 to Oct. 22)\n",
"Your desire for justice and truth will be overshadowed by\n",
"your desire for filthy lucre and a decent meal. Be gracious\n",
"and polite. Someone is watching you, so stop staring like\n",
"that.\n"
}; text x {
"If everything is coming your way then you're in the wrong\n",
"lane.\n"
}; text x {
"Grabel's Law:\n",
"2 is not equal to 3 -- not even for large values of 2.\n"
}; text x {
"If you live in a country run by committee, be on the\n",
"committee.\n",
"\n",
"Graham Summer\n"
}; text x {
"Rule of Defactualization:\n",
"Information deteriorates upward through bureaucracies.\n"
}; text x {
"Oliver's Law:\n",
"Experience is something you don't get until just after you\n",
"need it.\n"
}; text x {
"In any formula, constants (especially those obtained from\n",
"handbooks) are to be treated as variables.\n"
}; text x {
"You can't carve your way to success without cutting remarks.\n"
}; text x {
"The Heineken Uncertainty Principle:\n",
"You can never be sure how many beers you had last night.\n"
}; text x {
"Boling's postulate:\n",
"If you're feeling good, don't worry. You'll get over it.\n"
}; text x {
"Faith is the quality that enables you to eat blackberry jam\n",
"on a picnic without looking to see whether the seeds move.\n"
}; text x {
"Quality Control, n.:\n",
"The process of testing one out of every 1,000 units coming\n",
"off a production line to make sure that at least one out of\n",
"100 works.\n"
}; text x {
"I cannot and will not cut my conscience to fit this year's\n",
"fashions.\n",
"\n",
"Lillian Hellman\n"
}; text x {
"Crime does not pay ... as well as politics.\n",
"\n",
"A. E. Newman\n"
}; text x {
"People often find it easier to be a result of the past than\n",
"a cause of the future.\n"
}; text x {
"Bombeck's Rule of Medicine:\n",
"Never go to a doctor whose office plants have died.\n"
}; text x {
"Whenever people agree with me I always feel I must be\n",
"wrong.\n",
"\n",
"Oscar Wilde\n"
}; text x {
"Mustgo, n.:\n",
"Any item of food that has been sitting in the\n",
"refrigerator so long it has become a science project.\n",
"\n",
"Sniglets, ""Rich Hall & Friends""\n"
}; text x {
"Never let your sense of morals prevent you from doing what\n",
"is right.\n",
"\n",
"Salvor Hardin, ""Foundation""\n"
}; text x {
"Cigarette, n.:\n",
"A fire at one end, a fool at the other, and a bit of tobacco\n",
"in between.\n"
}; text x {
"Anybody with money to burn will easily find someone to tend\n",
"the fire.\n"
}; text x {
"They also surf who only stand on waves.\n"
}; text x {
"Your lucky number is 3552664958674928. Watch for it\n",
"everywhere.\n"
}; text x {
"""Even the best of friends cannot attend each other's\n",
"funeral.""\n",
"Kehlog Albran, ""The Profit""\n"
}; text x {
"I'm fed up to the ears with old men dreaming up wars for\n",
"young men to die in.\n",
"\n",
"George McGovern\n"
}; text x {
"You can take all the impact that science considerations have\n",
"on funding decisions at NASA, put them in the navel of a\n",
"flea, and have room left over for a caraway seed and Tony\n",
"Calio's heart.\n",
"\n",
"F. Allen\n"
}; text x {
"Every absurdity has a champion who will defend it.\n"
}; text x {
"Every creature has within him the wild, uncontrollable urge\n",
"to punt.\n"
}; text x {
"It is impossible to make anything foolproof because fools\n",
"are so ingenious.\n"
}; text x {
"Nobody wants constructive criticism. It's all we can do to\n",
"put up with constructive praise.\n"
}; text x {
"Canada Post doesn't really charge 32 cents for a stamp. It's\n",
"2 cents for postage and 30 cents for storage.\n",
"Gerald Regan, Cabinet Minister, 12/31/83, Financial Post\n"
}; text x {
"Flugg's Law:\n",
"When you need to knock on wood is when you realize that the\n",
"world is composed of vinyl, naugahyde and aluminum.\n"
}; text x {
"Never try to outstubborn a cat.\n",
"\n",
"Lazarus Long, ""Time Enough for Love""\n"
}; text x {
"How do you explain school to a higher intelligence?\n",
"\n",
"Elliot, ""E.T.""\n"
}; text x {
"Westheimer's Discovery:\n",
"A couple of months in the laboratory can frequently save\n",
"a couple of hours in the library.\n"
}; text x {
"I do not feel obliged to believe that the same God who has\n",
"endowed us with sense, reason, and intellect has intended us\n",
"to forgo their use.\n",
"\n",
"Galileo Galilei\n"
}; text x {
"Barth's Distinction:\n",
"There are two types of people: those who divide people into\n",
"two types, and those who don't.\n"
}; text x {
"Somebody ought to cross ball point pens with coat hangers so\n",
"that the pens will multiply instead of disappear.\n"
}; text x {
"Losing your drivers' license is just God's way of saying\n",
"""BOOGA, BOOGA!""\n"
}; text x {
"Accidents cause History.\n",
"\n",
"If Sigismund Unbuckle had taken a walk in 1426 and met Wat\n",
"Tyler, the Peasant's Revolt would never have happened and the\n",
"motor car would not have been invented until 2026, which\n",
"would have meant that all the oil could have been used for\n",
"lamps, thus saving the electric light bulb and the whale, and\n",
"nobody would have caught Moby Dick or Billy Budd.\n",
"\n",
"Mike Harding, ""The Armchair Anarchist's Almanac""\n"
}; text x {
"The cost of living hasn't affected its popularity.\n"
}; text x {
"Happiness is having a scratch for every itch.\n",
"\n",
"Ogden Nash\n"
}; text x {
"Anyone who is capable of getting themselves made President\n",
"should on no account be allowed to do the job.\n",
"\n",
"Douglas Adams, ""The Hitchhiker's Guide to the Galaxy""\n"
}; text x {
"God may be subtle, but He isn't plain mean.\n",
"\n",
"Albert Einstein\n"
}; text x {
"Anything worth doing is worth overdoing.\n"
}; text x {
"Iron Law of Distribution:\n",
"Them that has, gets.\n"
}; text x {
"""MacDonald has the gift on compressing the largest amount of\n",
"words into the smallest amount of thoughts.""\n",
"\n",
"Winston Churchill\n"
}; text x {
"Yesterday I was a dog. Today I'm a dog. Tomorrow I'll\n",
"probably still be a dog. Sigh! There's so little hope for\n",
"advancement.\n",
"\n",
"Snoopy\n"
}; text x {
"Monday, n.:\n",
"In Christian countries, the day after the baseball game.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"There is no substitute for good manners, except, perhaps,\n",
"fast reflexes.\n"
}; text x {
"The IQ of the group is the lowest IQ of a member of the\n",
"group divided by the number of people in the group.\n"
}; text x {
"""Beware of the man who works hard to learn something, learns\n",
"it, and finds himself no wiser than before,"" Bokonon tells\n",
"us. ""He is full of murderous resentment of people who are\n",
"ignorant without having come by their ignorance the hard\n",
"way.""\n",
"\n",
"Kurt Vonnegut, ""Cat's Cradle""\n"
}; text x {
"I do not know myself, and God forbid that I should.\n",
"\n",
"Johann Wolfgang von Goethe\n"
}; text x {
"The steady state of disks is full.\n",
"\n",
"Ken Thompson\n"
}; text x {
"And on the seventh day, He exited from append mode.\n"
}; text x {
"Once, adv.: Enough.\n",
"\n",
"Ambrose Bierce, ""The Devil's Dictionary""\n"
}; text x {
"Workers of the world, arise! You have nothing to lose but\n",
"your chairs.\n"
}; text x {
"Trust everybody ... then cut the cards.\n"
}; text x {
"Two wrongs are only the beginning.\n"
}; text x {
"If at first you don't succeed, destroy all evidence that you\n",
"tried.\n"
}; text x {
"To succeed in politics, it is often necessary to rise above\n",
"your principles.\n"
}; text x {
"Exceptions prove the rule ... and wreck the budget.\n"
}; text x {
"Success always occurs in private, and failure in full view.\n"
}; text x {
"Quality assurance dosen't.\n"
}; text x {
"The tough part of a Data Processing Manager's job is that\n",
"users don't really know what they want, but they know for\n",
"certain what they don't want.\n"
}; text x {
"Exceptions always outnumber rules.\n"
}; text x {
"To steal ideas from one person is plagiarism; to steal from\n",
"many is research\n"
}; text x {
"No one is listening until you make a mistake.\n"
}; text x {
"He who hesitates is probably right.\n"
}; text x {
"The ideal resume will turn up one day after the position is\n",
"filled.\n"
}; text x {
"If somthing is confidential, it will be left in the copier\n",
"machine.\n"
}; text x {
"One child is not enough, but two children are far too many.\n"
}; text x {
"A clean tie attracts the soup of the day.\n"
}; text x {
"The hardness of the butter is in direct proportion to the\n",
"softness of the butter.\n"
}; text x {
"The bag that breaks is the one with the eggs.\n"
}; text x {
"When there are sufficient funds in the checking account,\n",
"checks take two weeks to clear.  When there are insufficient\n",
"funds, checks clear overnight.\n"
}; text x {
"The book you spent $20.95 for today will come out in\n",
"paperback tomorrow.\n"
}; text x {
"The more an item costs, the farther you have to send it for\n",
"repairs.\n"
}; text x {
"You never want the one you can afford.\n"
}; text x {
"Never ask the barber if you need a haircut or a salesman if\n",
"his is a good price.\n"
}; text x {
"If it says ""one size fits all,"" it dosen't fit anyone.\n"
}; text x {
"You never really learn to swear until you learn to drive.\n"
}; text x {
"The colder the X-ray table, the more of your body is\n",
"required on it.\n"
}; text x {
"Love letters, business contracts and money due you always\n",
"arrive three weeks late, whereas junk mail arrives the day it\n",
"was sent.\n"
}; text x {
"When you drop change at a vending machine, the pennies will\n",
"fall nearby, while all other coins will roll out of sight.\n"
}; text x {
"The severity of the itch is inversely proportional to the\n",
"reach.\n"
}; text x {
"Experience is somthing you don't get until just after you\n",
"need it.\n"
}; text x {
"Life can be only understood backwards, but it must be lived\n",
"forwards.\n"
}; text x {
"Interchangable parts won't.\n"
}; text x {
"No matter which way you go, it's uphill and against the\n",
"wind.\n"
}; text x {
"If enough data is collected, anything may be proven by \n",
"statistical methods.\n"
}; text x {
"Work is accomplished by those employees who have not reached\n",
"their level of incompetence.\n"
}; text x {
"Progress is made on alternative Fridays.\n"
}; text x {
"No man's life, liberty, or property is safe while the\n",
"legislature is in session.\n"
}; text x {
"The hidden flaw never remains hidden.\n"
}; text x {
"For every action, there is an equal and opposite criticism.\n"
}; text x {
"People who love sausage and respect the law should never\n",
"watch either of them being made.\n"
}; text x {
"A conclusion is the place where you got tired of thinking.\n"
}; text x {
"When reviewing your notes for a test, the most important\n",
"ones will be illegible.\n"
}; text x {
"A free agent is anything but.\n"
}; text x {
"The least experienced fisherman always catches the biggest\n",
"fish.\n"
}; text x {
"Never do card tricks for the group you play poker with.\n"
}; text x {
"The one item you want is never the one on sale.\n"
}; text x {
"The telephone will ring when you are outside the door,\n",
"fumbling for your keys.\n"
}; text x {
"If only one price can be obtained for a quotation, the price\n",
"will be unreasonable.\n"
}; text x {
"All you can do is all you can do, but all you\n",
"can do is enough.\n"
};
