DEFINT A-Z

    CONST BPORT = &H220  'Base Port address
    CONST XPORT = &H226  'Reset port address
    CONST WPORT = &H22C  'Write port address
    CONST RPORT = &H22A  'Read port address
    CONST APORT = &H22E  'Data Available port address

    DIM peakarray(30)    'peak leng
    lenp = 0
    lastd = 0   'last direction
    lastgot = 128

    DEF SEG = &HA000
    SCREEN 13
    
    DO
        OUT WPORT, &H20           'Tell SoundBlaster you wanna read a byte.
        gotit = INP(RPORT)
        dir = gotit - lastgot
        
        IF dir > 1 THEN currentd = 1 ELSE IF dir < -1 THEN currentd = -1 ELSE currentd = lastd

        IF currentd <> lastd THEN
            IF lenp > 309 THEN lenp = 309
            lenp = lenp \ 10
            peakarray(lenp) = peakarray(lenp) + (lenp \ 2)
            lenp = 0
        ELSE
            lenp = lenp + 1
        END IF
        
        atp = atp + 1

        lastd = currentd
        lastgot = gotit
        
        IF atp = 2500 THEN
            atp = 0
            FOR r = 0 TO 30
                xx = peakarray(30 - r)
                peakarray(30 - r) = 0
                IF xx > 94 THEN xx = 94

                    IF xx < 94 THEN
                        FOR rr = xx + 1 TO 94
                            POKE (((94 - rr) * 320) + r) * 2 + 1, &H0
                        NEXT
                    END IF

                    FOR rr = 0 TO xx
                        POKE (((94 - rr) * 320) + r) * 2 + 1, &HF
                    NEXT
            NEXT
        END IF
    LOOP UNTIL INP(&H60) = 1    'esc pressed

    SCREEN 0
    PRINT "Realtime Frequency Analysis"
    PRINT
    PRINT " -based on time between wave peaks"
    PRINT " -ie: high frequency / complex frequency --> high peakrate"
    PRINT "      low frequency / simple frequency ----> low peakrate"
    END

