/****************************************************************************
*                                                                           *
*   simulaton program for the evolutionary optimizer:                       *
*   target function is to be included in this source                        *
*   Version 0.5                                                             *
*   19.4.94            (C) Petra Roosen                                     *
*                                                                           *
****************************************************************************/

#define UNIX            /* put as comment if preparing for OS/2! */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "epo.h"


/**** global variables: ****/

Paraset Indi;
int     Parazahl, Runde;
Iniset  Limits[5];
FILE    *infile, *outfile, *flagfile;
char    Transdir[250];
int     sleeptime=1;


/**** function prototypes: ****/

void    main(void);
void    init(void);
bool    empfange(void);
void    rechne(void);
bool    verschicke(void);


/**************************************************************************/
/**************************************************************************/
/******************* Begin of target function determination ***************/

void rechne()  /* Example: Minimal fct. value of a hyper-paraboloid */
{
  double  Ergebnis;
  int     i;


  Ergebnis = 0;
  for (i=0; i<Parazahl; i++)
  {
    Ergebnis += Indi.koeff[i] * Indi.koeff[i];
  }

  Indi.Ergebnis = Ergebnis;
}

/******************** End of target function determination *****************/
/***************************************************************************/
/***************************************************************************/

void main()
{
  bool klappt;

  init();               /* for transfer directory determination only */

  forever
  {
    Runde++;
    klappt = empfange();
    rechne();
    printf("%d. simulator result: %G,          sleep time: %d\n",
           Runde, Indi.Ergebnis, sleeptime);
    klappt = verschicke();
  }
}


void init()
{
  FILE    *fp;
  char    dummy[250];

  printf("\n\n");
  printf("  **************************************************\n");
  printf("  * Simulator module for co-operation with the     *\n");
  printf("  * evolutionary parameter optimizer               *\n");
  printf("  * for general optimization problems              *\n");
  printf("  *                                                *\n");
  printf("  * Shareware version 0.5    (C)3/94  Petra Roosen *\n");
  printf("  **************************************************\n\n");


  /******* Einlesen des Transfer-Directories ******/
  if ( (fp=fopen("strateg.dat","r")) )
    {
      fscanf(fp, "%s", dummy);
      if ( strcmp(dummy, "EPO-0.5") )
      {
        printf("\007\007Wrong initialization file at the identification header!\n");
        sleep(5);
        exit(0);
      }
      fscanf(fp, "%*s");
      fscanf(fp, "%*s %*s");
      fscanf(fp, "%*s %*d");
      fscanf(fp, "%*s %*d");
      fscanf(fp, "%*s %*d");
      fscanf(fp, "%*s %*d");
      fscanf(fp, "%*s %*d");
      fscanf(fp, "%*s %*s");
      fscanf(fp, "%*s %*s");
      fscanf(fp, "%s %s", dummy, Transdir);
      if ( strcmp(dummy, "transfer_dir") )
      {
        printf("\007Faulty initialization file at \"transfer_dir\"!\n");
        sleep(5);
        exit(0);
      }
      fclose(fp);
    }
}


bool empfange()
{
  int i, gelesen;
  char aktFile[250];


  sprintf(aktFile, "%so2s.msg", Transdir);

  do    /** auf die Existenz des Message-Files warten **/
  {
#ifdef UNIX
    sleep(1);
#else
    _sleep2(400);
#endif
    flagfile = fopen(aktFile, "r");
  }
    while (flagfile == NULL);
  fclose(flagfile);
  remove(aktFile);

  sprintf(aktFile, "%so2s.dat", Transdir);

lies_Daten:
#ifdef UNIX
    sleep(sleeptime);
#else
    _sleep2(sleeptime);
#endif
  infile = fopen(aktFile, "r");

  if (infile == NULL)
    {
      printf("\007\007");
      printf("There is no data file, although the message file was found.\n");
      printf("Is there another program interfering with the file transfer\n");
      printf("between optimizer and simulator??\n");
      printf("Program dies because of error state!\n");
      sleep(5);
      exit(0);
    }

  fscanf(infile, "%*s %*s %d %*s", &Parazahl);
  if (Parazahl == 0)
    {
      printf("Stop message received from optimizer: simulator dies.\n");
      fclose(infile);
      sleep(5);
      remove(aktFile);
      exit(0);
    }

  for (i=0; i<Parazahl; i++)
  {
    gelesen = fscanf(infile, "%s %lf %lf",
                     Limits[i].Name, &(Indi.koeff[i]), &(Indi.dkoeff[i]) );
    if (gelesen != 3)
      {
        fclose(infile);
        sleeptime += 2;
        goto lies_Daten;
      }
    sleeptime--;
    sleeptime = max(sleeptime, 0);
  }
  fscanf(infile, "%*s %d %*s %d %*s %d %*s %d",
         &(Indi.Kennzahl), &(Indi.Mama), &(Indi.Papa), &(Indi.Alter) );
  fclose(infile);

  remove("o2s.dat");
  remove("o2s.msg");

  return TRUE;
}


bool verschicke()
{
  int  i;
  char aktFile[250];


  sprintf(aktFile, "%ss2o.dat", Transdir);
  outfile = fopen(aktFile, "w");

  if (outfile != NULL)
    {
      fprintf(outfile, "Ergebnis zu Kennzahl %d mit %d Parametern\n\n",
              Indi.Kennzahl, Parazahl);
      for (i=0; i<Parazahl; i++)
      {
        fprintf(outfile, "%s %G %G\n",
                Limits[i].Name, Indi.koeff[i], Indi.dkoeff[i]);
      }
      fprintf(outfile, "Mama     %d\n", Indi.Mama);
      fprintf(outfile, "Papa     %d\n", Indi.Papa);
      fprintf(outfile, "Alter    %d\n", Indi.Alter);
      fprintf(outfile, "Ergebnis %G\n", Indi.Ergebnis);
      fclose(outfile);
      sprintf(aktFile, "%ss2o.msg", Transdir);
      flagfile = fopen(aktFile, "w");
      fclose(flagfile);

      return TRUE;
		}
		else
			return FALSE;
}

