/********************************************************copyrite.xic***/
/*                                                                     */
/*   Licensed Materials - Property of IBM                              */
/*                                                                     */
/*   This product contains "Restricted Materials of IBM":              */
/*      Program Number:   5798RXW                                      */
/*      Program Name:     IBM TCP/IP Version 1.2 for OS/2              */
/*   (C) Copyright IBM Corporation. 1990, 1991.                        */
/*                                                                     */
/*   All rights reserved.                                              */
/*                                                                     */
/*   US Government Users Restricted Rights -                           */
/*   Use, duplication or disclosure restricted by GSA ADP Schedule     */
/*   Contract with IBM Corp.                                           */
/*                                                                     */
/*   See IBM Copyright Instructions.                                   */
/*                                                                     */
/********************************************************copyrite.xic***/
/*
 * Include Files.
 */
#include <types.h>
#include <netinet\in.h>
#include <sys\socket.h>
#include <stdio.h>
#include <netdb.h>


void usage(char *program)
{
  fprintf(stderr, "Usage: %s -f responsefile [-s port|service] [-p protocol] [-d]\n", program);
  fprintf(stderr, "\t-f specifies the data file to be displayed\n");
  fprintf(stderr, "\t-s specifies the service to be used (default is finger)\n");
  fprintf(stderr, "\t   A port number may also be specified.\n");
  fprintf(stderr, "\t-p specifies the protocol used (default is tcp)\n");
  fprintf(stderr, "\t-d specifies debugging info is to be displayed\n");
  exit(1);
}


/*
 * Server Main.
 */
main(argc, argv)
int argc;
char **argv;
{
    unsigned short port;       /* port server binds to                  */
    char buf[512];             /* buffer for sending and receiving data */
    struct sockaddr_in client; /* client address information            */
    struct sockaddr_in server; /* server address information            */
    struct servent *ser;
    int s;                     /* socket for accepting connections      */
    int ns;                    /* socket connected to client            */
    int namelen;               /* length of client name                 */
    char *servicename;
    char *protocol;
    char *filename;
    int i;
    int bufsize;
    int debugging = 0;
    FILE *finger_data;

    /*
     * Check arguments. Should be only one: the port number to bind to.
     */

    servicename = "finger";
    protocol = "tcp";

    if (argc < 3)
      usage(argv[0]);
    i = 1;
    while (i < argc)
      {
	if (!strcmp(argv[i], "-f"))
	  {
	    i++;
	    if (i >= argc)
	      {
		fprintf(stderr, "Error: Filename missing!\n");
		usage(argv[0]);
	      }
	    filename = argv[i];
	    fprintf(stdout, "Finger file = %s\n", filename);
	    finger_data = fopen(filename, "r");
	    if (finger_data == NULL)
	      {
		fprintf(stderr, "Error:  Cannot open finger data file!\n");
		exit(-1);
	      }
	    fclose(finger_data);
	    i++;
	    continue;
	  }
	if (!strcmp(argv[i], "-s"))
	  {
	    i++;
	    if (i >= argc)
	      {
		fprintf(stderr, "Error:  Missing service name!\n");
		usage(argv[0]);
	      }
	    servicename = argv[i];
	    if (!isdigit(servicename[0]))
	      printf("Using %s service\n", servicename);
	    else
	      printf("Using port %s\n", servicename);
	    i++;
	    continue;
	  }
	if (!strcmp(argv[i], "-p"))
	  {
	    i++;
	    if (i >= argc)
	      {
		fprintf(stderr, "Error:  Missing protocol!\n");
		usage(argv[0]);
	      }
	    protocol = argv[i];
	    if (strcmp(protocol, "tcp") && strcmp(protocol, "udp"))
	      {
		fprintf(stderr, "Error: Invalid protocol!  Must be tcp or udp!\n");
		usage(argv[0]);
	      }
	    printf("Using %s protocol\n", protocol);
	    i++;
	    continue;
	  }
	if (!strcmp(argv[i], "-d"))
	  {
	    i++;
	    debugging = 1;
	    printf("Debugging info is enabled.\n");
	    continue;
	  }
	fprintf(stderr, "Unknown option %s\n", argv[i]);
	usage(argv[0]);
      }
    printf("\nFinger Daemon for OS/2\n");
    printf("Brought to you by Aaron Williams\n");
    printf("This program is provided as-is, and no warrenties exist!\n");
    printf("If you make improvements or find any bugs, let me know.\n");
    printf("\nI can be reached via snail mail at:\n\n\tAaron Williams\n");
    printf("\t35900 Turpin Way\n\tFremont, CA. 94536-2666\n");
    printf("\nEmail: aaronw@cats.ucsc.edu (subject to change on June 18, 1994)\n\n");
    /*
     * Initialize with sockets.
     */
    sock_init();
    /*
     * First argument should be the port.
     */
    if (isdigit(servicename[0]))
      port = (unsigned short) atoi(servicename);
    else
      {
	ser = getservbyname(servicename, protocol);
	if (ser == NULL)
	  {
	    fprintf(stderr, "Error:  Service %s is not available!\n", servicename);
	    exit(-1);
	  }
	port = ser->s_port >> 8;
	if (debugging)
	  printf("Service %s using port #%d\n", ser->s_name, port);
      }

    /*
     * Get a socket for accepting connections.
     */
    if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0)
    {
        psock_errno("Socket()");
        exit(2);
    }

    /*
     * Bind the socket to the server address.
     */
    server.sin_family = AF_INET;
    server.sin_port   = htons(port);
    server.sin_addr.s_addr = INADDR_ANY;
    
    if (bind(s, (struct sockaddr *)&server, sizeof(server)) < 0)
    {
       psock_errno("Bind()");
       soclose(s);
       exit(3);
    }

    while (1)
      {
	/*
	 * Listen for connections. Specify the backlog as 1.
	 */
	if (listen(s, 1) != 0)
	  {
	    psock_errno("Listen()");
	    exit(4);
	  }
	
	/*
	 * Accept a connection.
	 */
	namelen = sizeof(client);
	if ((ns = accept(s, (struct sockaddr *)&client, &namelen)) == -1)
	  {
	    psock_errno("Accept()");
	    exit(5);
	  }
	
	/*
	 * Receive the message on the newly connected socket.
	 */
	for (i=0; i<sizeof(buf); i++)
	  buf[i] = 0;

	if ((bufsize=recv(ns, buf, sizeof(buf), 0)) == -1)
	  {
	    psock_errno("Recv()");
	    exit(6);
	  }
	if ((debugging) && (bufsize > 0))
	  {
	    if (buf[0] < 32)
	      printf("Recv [%d]: [\\%d]\n", bufsize, (int)buf[0]);
	    else
	      printf("Recv: %s\n", buf);
	  }
	
	/*
	 * Send the message back to the client.
	 */
	finger_data = fopen(filename, "r");
	if (finger_data == NULL)
	  {
	    fprintf(stderr, "Error: Cannot open finger data file!");
	    exit(7);
	  }
	for (i=0; i<sizeof(buf); i++)
	  buf[i] = 0;
	while (bufsize=fread(buf, 1, sizeof(buf), finger_data))
	  {
	    
	    if (send(ns, buf, bufsize, 0) < 0)
	      {
		psock_errno("Send()");
		exit(7);
	      }
	  }
	fclose (finger_data);
	soclose(ns);
    
      }
    soclose(s);

    printf("Server ended successfully\n");
    exit(0);
}


