unit ApiInt;

interface
uses
  types;

{----------------------------------------------------------------------------}
function  apiVersion : String; far;
procedure apiInitDLL(path : String); far; { path = FOSS/2-root path }
{----------------------------------------------------------------------------}
function  fioReadMainCfg(var cfg : SysCfgT) : Boolean; far;
procedure fioWriteMainCfg(var cfg : SysCfgT); far;
{----------------------------------------------------------------------------}
function  fioReadNodeCfg(var cfg : ModCfgT; pos : LongInt) : Boolean; far;
procedure fioWriteNodeCfg(var cfg : ModCfgT; var pos : LongInt); far;
procedure fioDelNodeCfg; far;
function  fioGetNodeCnt : LongInt; far;
{----------------------------------------------------------------------------}
function  fioReadAreaCfg(var cfg : Area_Config_Record; pos : LongInt) : Boolean; far;
function  fioFindAreaCode(var cfg : Area_Config_Record; code : String; pos : LongInt) : Boolean; far;
function  fioFindAreaName(var cfg : Area_Config_Record; name : String; pos : LongInt) : Boolean; far;
procedure fioWriteAreaCfg(var cfg : Area_Config_Record; var pos : LongInt); far;
{----------------------------------------------------------------------------}
function  fioReadLocalUsr(var usr : LocUsers; pos : LongInt) : Boolean; far;
function  fioFindLocalUsr(var usr : LocUsers; name : String; var pos : LongInt)
                          : Boolean; far;
{----------------------------------------------------------------------------}
procedure fioWriteLocalUsr(var usr : LocUsers; var pos : LongInt); far;
function  fioGetLocalUsrCnt : LongInt; far;
{----------------------------------------------------------------------------}
function  fioReadNetUsr(var usr : NetUsers; pos : LongInt) : Boolean; far;
function  fioFindNetUsr(var usr : NetUsers; var pos : LongInt) : Boolean; far;
{----------------------------------------------------------------------------}
function  fioReadUsrAreaReg(var reg : Area_Reg; var area : Area_Config_Record;
                            pos : LongInt) : Boolean; far;
procedure fioWriteUsrAreaReg(var reg : Area_Reg; var area : Area_Config_Record;
                             var pos : LongInt); far;
{----------------------------------------------------------------------------}
function  fioReadMsgHeader(var mhd : Area_Mhd; var area : Area_Config_Record;
                           pos : LongInt) : Boolean; far;
function  fioFindMsgNo(var mhd : Area_Mhd; var area : Area_Config_Record;
                       no : LongInt) : Boolean; far;
function  fioFindNextMsg(var mhd : Area_Mhd; var area : Area_Config_Record)
                         : Boolean; far;
procedure fioReadMsgBuf(var mhd : Area_Mhd; var area : Area_Config_Record;
                        ptr : PMsgBuffer);
procedure fioReadMsgStatus(var area : Area_Config_Record; var reg : Area_Reg;
                           usrpos : LongInt; var last, newall, newyou : LongInt); far;
procedure fioWriteMsgHeader(var mhd : Area_Mhd; var area : Area_Config_Record;
                            var pos : LongInt); far;
procedure fioUpdateMsgHeader(var mhd : Area_Mhd; var area : Area_Config_Record); far;
procedure fioWriteMsg(var mhd : Area_Mhd; var area : Area_Config_Record;
                      ptr : PMsgBuffer); far;
{----------------------------------------------------------------------------}
function  fioReadDirCfg(var cfg : Area_Directory_Record;
                        var area : Area_Config_Record; pos : LongInt) : Boolean; far;
function  fioFindDirNo(var cfg : Area_Directory_Record; no : LongInt;
                       var area : Area_Config_Record; pos : LongInt) : Boolean; far;
function  fioFindDirName(var cfg : Area_Directory_Record; name : String;
                         var area : Area_Config_Record; pos : LongInt) : Boolean; far;
procedure fioWriteDirCfg(var cfg : Area_Directory_Record;
                         var area : Area_Config_Record; var pos : LongInt); far;
{----------------------------------------------------------------------------}
function  strUpCase(S : string) : string; far;
function  strNiceCase(S : string) : string; far;
function  strInsertIdx(org, ins, idx : String) : String; far;
{----------------------------------------------------------------------------}
function  usrHaveAccess(acc : AccessT; var area : Area_Config_Record;
                        var reg : Area_Reg; var usr : LocUsers) : Boolean; far;
{----------------------------------------------------------------------------}

implementation

function  apiVersion;          external 'FOSS16' index   1;
procedure apiInitDLL;          external 'FOSS16' index   2;

function  fioReadMainCfg;      external 'FOSS16' index   3;
procedure fioWriteMainCfg;     external 'FOSS16' index   4;

function  fioReadNodeCfg;      external 'FOSS16' index   5;
procedure fioWriteNodeCfg;     external 'FOSS16' index   6;
procedure fioDelNodeCfg;       external 'FOSS16' index   7;
function  fioGetNodeCnt;       external 'FOSS16' index   8;

function  fioReadAreaCfg;      external 'FOSS16' index   9;
function  fioFindAreaCode;     external 'FOSS16' index  22;
function  fioFindAreaName;     external 'FOSS16' index  23;
procedure fioWriteAreaCfg;     external 'FOSS16' index  10;

function  fioReadLocalUsr;     external 'FOSS16' index  11;
function  fioFindLocalUsr;     external 'FOSS16' index  14;
procedure fioWriteLocalUsr;    external 'FOSS16' index  12;
function  fioGetLocalUsrCnt;   external 'FOSS16' index  13;

function  fioReadNetUsr;       external 'FOSS16' index  35;
function  fioFindNetUsr;       external 'FOSS16' index  36;

function  fioReadUsrAreaReg;   external 'FOSS16' index  15;
procedure fioWriteUsrAreaReg;  external 'FOSS16' index  16;

function  fioReadMsgHeader;    external 'FOSS16' index  17;
function  fioFindMsgNo;        external 'FOSS16' index  18;
function  fioFindNextMsg;      external 'FOSS16' index  19;
procedure fioReadMsgBuf;       external 'FOSS16' index  20;
procedure fioReadMsgStatus;    external 'FOSS16' index  21;
procedure fioWriteMsgHeader;   external 'FOSS16' index  34;
procedure fioUpdateMsgHeader;  external 'FOSS16' index  29;
procedure fioWriteMsg;         external 'FOSS16' index  28;

function  fioReadDirCfg;       external 'FOSS16' index  30;
function  fioFindDirNo;        external 'FOSS16' index  33;
function  fioFindDirName;      external 'FOSS16' index  31;
procedure fioWriteDirCfg;      external 'FOSS16' index  32;

function  strUpCase;           external 'FOSS16' index  24;
function  strNiceCase;         external 'FOSS16' index  25;
function  strInsertIdx;        external 'FOSS16' index  26;
function  usrHaveAccess;       external 'FOSS16' index  27;

end.