/* OS/2 REXX Procedure to make diskettes out of disk images *
 * using the loaddskf utility from IBM.                     *
 *                                                          *
 * This is a generic utility that will prompt the user      *
 * for every .dsk file found in the current directory and   *
 * invoke LOADDSKF to create that diskette from the image.  *
 *                                                          *
 * Execution syntax is:                                     *
 *                                                          *
 * makedsks images drive ( loaddsks_options                 *
 *                                                          *
 * where images is the file names to use (e.g. *.dsk)       *
 *       (path is not supported as current dir is assumed)  *
 *       drive is the drive name (e.g. a:)                  *
 *       loaddskf_options may be:                           *
 *                 /f = format                              *
 *                 /y = don't prompt for format ok          *
 *                                                          *
 * defaults:  images: *.dsk                                 *
 *            drive: a:                                     *
 *                                                          *
 * Prompting is once per disk image:                        *
 *                                                          *
 * "Q" - quits this process                                 *
 * "S" - skips the specific disk image                      *
 * any key invokes loaddskf with /F (format)                *
 *                          and  /Y (don't prompt)          *
 *                                                          *
 * Author:     Lionel B. Dyck                               *
 *             Rockwell International                       *
 *             P.O. Box 2515                                *
 *             Seal Beach, California 90740                 *
 *             (310) 797-1125                               *
 *             IBMMail:  USROKNTN                           *
 *             Internet: lbd@osreq48.rockwell.com           *
 *             IBMLINK:  ROK2027                            *
 *                                                          *
 * History:                                                 *
 * 02/28/94 - created                                       *
 * 02/28/94 - updated w/sugg by Gerald Meazell              *
 *                                                          *
 * -------------------------------------------------------- */

arg images drive "(" ld_opts

if strip(ld_opts) = "" then
   ld_opts = "/f /y"

if length(images) = 0 then do
   images = "*.dsk"
   drive = "a:"
   end

if length(drive) = 0 then drive = "a:"

if length(drive) = 1 then drive = drive":"

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

current_dir = directory()
lc = length(current_dir)+2
x  = SysFileTree(images,'files','f')

do  fi = 1 to files.0
    parse value files.fi with id1 id2 size at name
    dsk.fi = substr(strip(name),lc)
    call make_disk dsk.fi
    end

exit

make_disk:
arg disk_image

call beep 125,100
call beep 150,100
call beep 175,100
Say " "
Say "Insert new diskette into drive" drive "for disk image:" disk_image
Say "Press 'S' to skip, 'Q' to quit, or any key to make the disk"
key = sysgetkey()
key = translate(key)

Select
  when key = "Q" then exit
  when key = "S" then return
  otherwise "Loaddskf" disk_image drive ld_opts
  end
return

