/***************************************/
/* Pegasus Log Rexx Extension          */
/* Version 1.0                         */
/* (c) 1993,1994 C.O.L. Systems Inc.   */
/* All Rights Reserved                 */
/* Data Dictionary Proc Proc           */
/*                                     */
/* This proc shows how to build a      */
/* reference of group metric counts,   */
/* items to use in data reference and  */
/* a small description of each item.   */
/***************************************/

Parse Arg  SpecificGroup;

/************************/
/* Load the extension   */
/************************/

if RxFuncQuery('PegLoadFunctions') <> 0 then do
   rcy = RxFuncAdd('PegLoadFunctions','PEGREXX','PegLoadFunctions')
   if rcy = 0 then do
      rcy = PegLoadFunctions()
      if rcy > 0 then
         signal BadLoad;
      end;
   else do
      signal BadAdd;
      end;
   end;

/************************/
/* Display title info   */
/************************/

say;
do count = 1 to 12
   say   sourceline(count);
   end;

/************************/
/* If the user has input*/
/* a particular metric  */
/* group to display     */
/************************/

if SpecificGroup <> '' then do
   count = PegMetric(SpecificGroup);

   if count == 'UNKNOWN' then 
      signal BadMetric;

   say ;
   say 'Metrics for the 'SpecificGroup' group. Number of metrics = 'count;
   say;

   do items = 1 to count
      say   left(PegMetric(SpecificGroup,items),14)' ',
            PegMetric(SpecificGroup,items,'D');
      end;

   rcx = PegDropFunctions();
   call RXFUNCDROP 'PEGLOADFUNCTIONS';
   exit;
   end  /* Do */

/* Here is the CPU group   */

count = PegMetric('CPU');
say;
say   'CPU metrics and descriptions. Number of metrics = 'count;
say;

do items = 1 to count
   say   left(PegMetric('CPU',items),14)' 'PegMetric('CPU',items,'D');
   end;

/* Here is the Memory and Paging group   */

count = PegMetric('MEM');
say;
say   'Memory metrics and descriptions. Number of metrics = 'count;
say;

do items = 1 to count
   say   left(PegMetric('MEM',items),14)' 'PegMetric('MEM',items,'D');
   end;

/* Here is the FAT Cache group   */

count = PegMetric('FC');
say;
say   'FAT Cache metrics and descriptions. Number of metrics = 'count;
say;

do items = 1 to count
   say   left(PegMetric('FC',items),14)' 'PegMetric('FC',items,'D');
   end;

/* Here is the HPFS Cache group   */

count = PegMetric('HC');
say;
say   'HPFS Cache metrics and descriptions. Number of metrics = 'count;
say;

do items = 1 to count
   say   left(PegMetric('HC',items),14)' 'PegMetric('HC',items,'D');
   end;

/* Here is the Physical Disk group   */

count = PegMetric('DSK');
say;
say   'Physical Disk metrics and descriptions. Number of metrics = 'count;
say;

do items = 1 to count
   say   left(PegMetric('DSK',items),14)' 'PegMetric('DSK',items,'D');
   end;

/* Here is the Logical File group   */

count = PegMetric('FIL');
say;
say   'Logical File metrics and descriptions. Number of metrics = 'count;
say;

do items = 1 to count
   say   left(PegMetric('FIL',items),14)' 'PegMetric('FIL',items,'D');
   end;

/* Here is the Thread group   */

count = PegMetric('THD');
say;
say   'Thread metrics and descriptions. Number of metrics = 'count;
say;

do items = 1 to count
   say   left(PegMetric('THD',items),14)' 'PegMetric('THD',items,'D');
   end;

/* Release the extension   */

rcx = PegDropFunctions();
call RXFUNCDROP 'PEGLOADFUNCTIONS';

exit;

/****************************************************/
/*  Error in syntax occured somewhere here          */
/****************************************************/

BadAdd:

   say   'Error Adding Pegasus Rexx Function Loader';

exit;

BadLoad:

   say   'Error Loading Pegasus Rexx Functions';

exit;

BadMetric:

   say;
   say   'Invalid metric entered as argument';
   say   'Valid metrics include:';
   say   ;
   say   '  cpu   dsk   thd   mem   fil   ';
   say   '  fc    hc ';
   say;

   rcx = PegDropFunctions();
   call RXFUNCDROP 'PEGLOADFUNCTIONS';

exit;
