/***************************************/
/* Pegasus Log Rexx Extension          */
/* Version 1.0                         */
/* (c) 1993,1994 C.O.L. Systems Inc.   */
/* All Rights Reserved                 */
/* FAT Cache Sample Proc               */
/***************************************/

Data1. = "";         /* This is our data stem. Assumes one file input*/

Parse Arg   MyFile   /* Parse the file name on input to the proc     */

/************************/
/* Load the extension   */
/************************/

if RxFuncQuery('PegLoadFunctions') <> 0 then do
   rcy = RxFuncAdd('PegLoadFunctions','PEGREXX','PegLoadFunctions')
   if rcy = 0 then do
      rcy = PegLoadFunctions()
      if rcy > 0 then
         signal BadLoad;
      end;
   else do
      signal BadAdd;
      end;
   end;

/**************************/
/* Load the file and stem */
/**************************/

rcx = PegLoadFile(MyFile,"Data1.");

/***************************/
/* Check that the file was */
/* loaded ok and the app   */
/* that created the log    */
/* is CacheMon             */
/***************************/

if rcx == 0 & Data1.Creator == 3 then do

   /* Copyright information   */

   say;
   do count = 1 to 7
      say   sourceline(count);
      end;

   /* Supplied by originator  */

   say;
   say "Data was created by "Data1.Title;   

   /* For each resource found flag, display the name  */

   say "Res # = "Data1.Resources;   

   do count = 1 to Data1.Resources  /* Display each on in list */
      say   "Resource "count" = "Data1.Resources.count;
      end

   /* Display the number of records */
   say   "Records = "Data1.Records; 

   /* Loop through record count and show fat cache information */

   if( Data1.Records > 0 ) then do
      do count = 1 to Data1.Records
         if Data1.Records.count.FC then do
            say   PegDate('U',Data1.Records.count.TDS)" ",
                  PegTime('N',Data1.Records.count.TDS),
                  "R-Hit  = "format(Data1.Records.count.FC.ctReadHit,4),
                  "R-Miss = "format(Data1.Records.count.FC.ctReadMiss,4),
                  "W-Hit  = "format(Data1.Records.count.FC.ctWriteHit,4),
                  "W-Miss = "format(Data1.Records.count.FC.ctWriteMiss,4);
            end;
         end;
      end;
   end;

/* Report a file access error  */

else do
   if rcx > 0 then
      say "Error in file set = "rcx;
   else
      say "This log file was not created with CacheMon!";
   end;

/* Release the extension   */

rcx = PegDropFunctions();
call RXFUNCDROP 'PEGLOADFUNCTIONS';

exit;

/****************************************************/
/*  Error in syntax occured somewhere here          */
/****************************************************/

BadAdd:

   say   'Error Adding Pegasus Rexx Function Loader';

exit;

BadLoad:

   say   'Error Loading Pegasus Rexx Functions';

exit;
