/***************************************/
/* Pegasus Log Rexx Extension          */
/* Version 1.10                        */
/* (c) 1993,1994 C.O.L. Systems Inc.   */
/* All Rights Reserved                 */
/* Time Stamp Sample Proc              */
/***************************************/

Data1. = "";         /* This is our data stem. Assumes one file input*/

Parse Arg   MyFile   /* Parse the file name on input to the proc     */

/************************/
/* Load the extension   */
/************************/

if RxFuncQuery('PegLoadFunctions') <> 0 then do
   rcy = RxFuncAdd('PegLoadFunctions','PEGREXX','PegLoadFunctions')
   if rcy = 0 then do
      rcy = PegLoadFunctions()
      if rcy > 0 then
         signal BadLoad;
      end;
   else do
      signal BadAdd;
      end;
   end;

/**************************/
/* Load the file and stem */
/**************************/

rcx = PegLoadFile(MyFile,"Data1.");

if rcx = 0 then do                  /* If there are no errors  */

   /* Copyright information   */

   say;
   do count = 1 to 7
      say   sourceline(count);
      end;

   /* Supplied by originator  */

   say;
   say "Data was created by "Data1.Title;   

   /* For each resource found flag, display the name  */

   say "Res # = "Data1.Resources;   

   do count = 1 to Data1.Resources  /* Display each on in list */
      say   "Resource "count" = "Data1.Resources.count;
      end

   /* Display the number of records */
   say   "Records = "Data1.Records; 

   /* Display the number of apps  from APPMON or FILEMON */
   say   "Apps    = "Data1.Records.Applications;

   /* Display the number of files from APPMON or FILEMON */
   say   "Files   = "Data1.Records.Files;

   /* Loop through record count and calculate cpu busy   */

   if( Data1.Records > 0 ) then do
      do count = 1 to Data1.Records
        say PegDate(,Data1.Records.count.TDS);
        end;
      end;
   end;

/* Report a file access error  */

else do
   say "Error in file set = "rcx;
   end;

/* Release the extension   */

rcx = PegDropFunctions();
call RXFUNCDROP 'PEGLOADFUNCTIONS';

exit;

/****************************************************/
/*  Error in syntax occured somewhere here          */
/****************************************************/

BadAdd:

   say   'Error Adding Pegasus Rexx Function Loader';

exit;

BadLoad:

   say   'Error Loading Pegasus Rexx Functions';

exit;
