/* ghline.c (emx/gcc) --- Copyright (c) 1993 Johannes Martin */
#include <string.h>

#include <sys/hw.h>
#include <vesa.h>

#include "vgaports.h"
#include "jmgraph.h"
#include "graph2.h"
#include "graph3.h"

void FLAT16_hline(int y, int x0, int x1, int color)
{
  int offset0, offset1;
  int size, i;

  offset0  = y * _g_linesize / 4;
  offset1  = offset0 + x1 / 8;
  offset0 += x0 / 8;
  size     = g_memsize / 4;

  if (offset0 == offset1)
    {
      int mask = (0xFF >> (x0 & 7)) & (0xFF << (7 - (x1 & 7)));

      for (i = 0; i < 4; i++)
        {
          if (color & 1)
            _g_wmem[offset0] |= mask;
          else
            _g_wmem[offset0] &= ~mask;
          color >>= 1;
          offset0 += size;
        }
    }
  else
    {
      int mask1 = 0xFF >> (x0 & 7);
      int mask2 = 0xFF << (7 - (x1 & 7));

      for (i = 0; i < 4; i++)
        {
          if (color & 1)
            {
              _g_wmem[offset0] |= mask1;
              offset0++;
              memset(_g_wmem + offset0, 0xFF, offset1 - offset0);
              _g_wmem[offset1] |= mask2;
            }
          else
            {
              _g_wmem[offset0] &= ~mask1;
              offset0++;
              memset(_g_wmem + offset0, 0, offset1 - offset0);
              _g_wmem[offset1] &= ~mask2;
            }
          color >>= 1;
          offset0 += size - 1;
          offset1 += size;
        }
    }
}

void FLAT256_hline(int y, int x0, int x1, int color)
{
  memset(_g_wmem + y * _g_linesize + x0, color, x1 - x0 + 1);
}

void FLAT32k_hline(int y, int x0, int x1, int color)
{
  memsetw(_g_wmem + y * _g_linesize + x0 * 2, color, x1 - x0 + 1);
}

void FLAT16m_hline(int y, int x0, int x1, int color)
{
  memset3(_g_wmem + y * _g_linesize + x0 * 3, color, x1 - x0 + 1);
}

void SEG16_hline(int y, int x0, int x1, int color)
{
  int offset0, offset1, win0, win1;

  offset0  = y * _g_linesize;
  offset1  = offset0 + x1 / 8;
  offset0 += x0 / 8;
  win0     = offset0 / _g_wingran;
  win1     = offset1 / _g_wingran;

  GSETWWIN(win0);
  GSETRWIN(win0);

  _outp16(GRA_I, color << 8);

  if (offset0 == offset1)
    {
      _outp16(GRA_I, ((0xFF00 >> (x0 & 7)) & (0xFF00 << (7 - (x1 & 7)))) | 8);
      _g_wmem[offset0 & (_g_wingran - 1)] = _g_rmem[offset0 & (_g_wingran - 1)];
    }
  else
    {
      _outp16(GRA_I, ((0xFF00 >> (x0 & 7)) & 0xFF00) | 8);
      _g_wmem[offset0 & (_g_wingran - 1)] = _g_rmem[offset0 & (_g_wingran - 1)];
      offset0++;

      _outp16(GRA_I, 0xFF08);
      if (win0 == win1)
        memcpy(_g_wmem + (offset0 & (_g_wingran - 1)),
               _g_rmem + (offset0 & (_g_wingran - 1)), offset1 - offset0);
      else
        {
          int offset2;

          offset2 = win1 * _g_wingran;
          memcpy(_g_wmem + (offset0 & (_g_wingran - 1)),
                 _g_rmem + (offset0 & (_g_wingran - 1)), offset2 - offset0);

          GSETWWIN(win1);

          memcpy(_g_wmem, _g_rmem, offset1 - offset2);
        }

      _outp16(GRA_I, (0xFF00 << (7 - (x1 & 7))) | 8);
      _g_wmem[offset1 & (_g_wingran - 1)] = _g_rmem[offset1 & (_g_wingran - 1)];
    }
}

void SEG256_hline(int y, int x0, int x1, int color)
{
  int offset0, offset1, win0, win1;

  offset0  = y * _g_linesize;
  offset1  = offset0 + x1;
  offset0 += x0;
  win0     = offset0 / _g_wingran;
  win1     = offset1 / _g_wingran;

  GSETWWIN(win0);

  if (win0 == win1)
    memset(_g_wmem + (offset0 & (_g_wingran - 1)), color, x1 - x0 + 1);
  else
    {
      int offset2;

      offset2 = win1 * _g_wingran;
      memset(_g_wmem + (offset0 & (_g_wingran - 1)), color, offset2 - offset0);

      GSETWWIN(win1);

      memset(_g_wmem, color, offset1 - offset2 + 1);
    }
}

void SEG32k_hline(int y, int x0, int x1, int color)
{
  int offset0, offset1, win0, win1;

  offset0  = y * _g_linesize;
  offset1  = offset0 + x1 * 2;
  offset0 += x0 * 2;
  win0     = offset0 / _g_wingran;
  win1     = offset1 / _g_wingran;

  GSETWWIN(win0);

  if (win0 == win1)
    memsetw(_g_wmem + (offset0 & (_g_wingran - 1)), color, x1 - x0 + 1);
  else
    {
      int offset2;

      offset2 = win1 * _g_wingran;
      memsetw(_g_wmem + (offset0 & (_g_wingran - 1)), color, (offset2 - offset0) / 2);

      GSETWWIN(win1);

      memsetw(_g_wmem, color, (offset1 - offset2) / 2+ 1);
    }
}

void SEG16m_hline(int y, int x0, int x1, int color)
{
  int offset0, offset1, win0, win1;

  offset0  = y * _g_linesize;
  offset1  = offset0 + x1 * 3;
  offset0 += x0 * 3;
  win0     = offset0 / _g_wingran;
  win1     = offset1 / _g_wingran;

  GSETWWIN(win0);

  if (win0 == win1)
    memset3(_g_wmem + (offset0 & (_g_wingran - 1)), color, x1 - x0 + 1);
  else
    {
      int offset2;

      offset2 = win1 * _g_wingran;
      memset3(_g_wmem + (offset0 & (_g_wingran - 1)), color, (offset2 - offset0) / 3);

      GSETWWIN(win1);

      memset3(_g_wmem, color, (offset1 - offset2) / 3 + 1);
    }
}

void ALT256_hline(int y, int x0, int x1, int color)
{
  int first, last, plane;
  char *base;

  _outp8(SEQ_I, 0x02);

  base = _g_wmem + y * _g_linesize;

  for(plane = 0; plane < 4; plane++)
    {
      _outp8(SEQ_D, 1 << plane);

      first = (x0 >> 2) + ((x0 & 3) > plane);
      last  = (x1 >> 2) - ((x1 & 3) < plane);
      if (last >= first)
        memset(base + first, color, last - first + 1);
    }
}

void g_hline(int y, int x0, int x1, int color)
{
  int x;

  if (x0 > x1)
    {
      x  = x0;
      x0 = x1;
      x1 = x;
    }
  if ((x1 < _g_clipx0) || (x0 > _g_clipx1) || (y > _g_clipy1) || (y < _g_clipy0))
    return;
  if (x0 < _g_clipx0)
    x0 = _g_clipx0;
  if (x1 > _g_clipx1)
    x1 = _g_clipx1;
  GLOCK;
  _g_hline(y, x0, x1, color);
  GUNLOCK;
}
