/* gset.c (emx/gcc) --- Copyright (c) 1993 by Johannes Martin */

#include <sys/hw.h>
#include <vesa.h>

#include "vgaports.h"
#include "jmgraph.h"
#include "graph2.h"
#include "graph3.h"

void FLAT16_set(int x, int y, int color)
{
  int offset, mask, size, i;

  offset = y * _g_linesize / 4 + x / 8;
  mask   = 0x80 >> (x % 8);
  size   = g_memsize / 4;

  for (i = 0; i < 4; i++)
    {
      if (color & 1)
        _g_wmem[i * size + offset] |= mask;
      else
        _g_wmem[i * size + offset] &= ~mask;
      color >>= 1;
    }
}

void FLAT256_set(int x, int y, int color)
{
  _g_wmem[y * _g_linesize + x] = color;
}

void FLAT32k_set(int x, int y, int color)
{
  *(short *) (_g_wmem + y * _g_linesize + x * 2) = color;
}

void FLAT16m_set(int x, int y, int color)
{
  int offset = y * _g_linesize + x * 3;

  _g_wmem[offset    ] = color;
  _g_wmem[offset + 1] = color >> 8;
  _g_wmem[offset + 2] = color >> 16;
}

void SEG16_set(int x, int y, int color)
{
  int offset, win;

  _outp16(GRA_I, color << 8);
  _outp16(GRA_I, (0x8000 >> (x & 7)) | 8);

  offset  = y * _g_linesize + x / 8;
  win     = offset / _g_wingran;
  offset &= _g_wingran - 1;

  GSETWWIN(win);
  GSETRWIN(win);
  _g_wmem[offset] = _g_rmem[offset];
}

void SEG256_set(int x, int y, int color)
{
  int offset, win;

  offset = y * _g_linesize + x;
  win    = offset / _g_wingran;

  GSETWWIN(win);

  _g_wmem[offset & (_g_wingran - 1)] = color;
}

void SEG32k_set(int x, int y, int color)
{
  int offset, win;

  offset = y * _g_linesize + x * 2;
  win    = offset / _g_wingran;

  GSETWWIN(win);

  *(short *) (_g_wmem + (offset & (_g_wingran - 1))) = color;
}

void SEG16m_set(int x, int y, int color)
{
  int offset, win;

  offset = y * _g_linesize + x * 3;
  win    = offset / _g_wingran;

  GSETWWIN(win);

  offset &= _g_wingran - 1;

  _g_wmem[offset    ] = color;
  _g_wmem[offset + 1] = color >> 8;
  _g_wmem[offset + 2] = color >> 16;
}

void ALT256_set(int x, int y, int color)
{
  _outp8(SEQ_I, 0x02);
  _outp8(SEQ_D, 1 << (x & 3));

  _g_wmem[y * _g_linesize + (x >> 2)] = color;
}

void g_set(int x, int y, int color)
{
  if (x >= _g_clipx0 && x <= _g_clipx1 && y >= _g_clipy0 && y <= _g_clipy1)
    {
      GLOCK;
      _g_set(x, y, color);
      GUNLOCK;
    }
}
