/* gvline.c (emx+gcc) -- Copyright (c) 1993 by Johannes Martin */

#include <sys/hw.h>
#include <vesa.h>

#include "vgaports.h"
#include "jmgraph.h"
#include "graph2.h"
#include "graph3.h"

void FLAT16_vline(int x, int y0, int y1, int color)
{
  int mask, size, lsize, i;
  char *base1, *base2;

  size  = g_memsize / 4;
  lsize = _g_linesize / 4;
  mask  = 0x80 >> (x % 8);
  base1 = _g_wmem + y0 * lsize + x / 8;
  y1   -= y0;

  for (i = 0; i < 4; i++)
    {
      base2 = base1 + i * size;
      y0 = y1;
      if (color & 1)
        while (y0-- >= 0)
          {
            *base2 |= mask;
            base2  += lsize;
          }
      else
        while (y0-- >= 0)
          {
            *base2 &= ~mask;
            base2  += lsize;
          }
      color >>= 1;
    }
}

void FLAT256_vline(int x, int y0, int y1, int color)
{
  char *base;

  base = _g_wmem + y0 * _g_linesize + x;
  y1  -= y0;
  while (y1-- >= 0)
    {
      *base = color;
      base += _g_linesize;
    }
}

void FLAT32k_vline(int x, int y0, int y1, int color)
{
  char *base;

  base = _g_wmem + y0 * _g_linesize + x * 2;
  y1  -= y0;

  while (y1-- >= 0)
    {
      *(unsigned short *) base = color;
      base += _g_linesize;
    }
}

void FLAT16m_vline(int x, int y0, int y1, int color)
{
  char *base;
  char r, g, b;

  r = color;
  g = color >> 8;
  b = color >> 16;

  base = _g_wmem + y0 * _g_linesize + x * 3;
  y1  -= y0;

  while (y1-- >= 0)
    {
      *base++ = r;
      *base++ = g;
      *base   = b;
      base   += _g_linesize - 2;
    }
}

void SEG16_vline(int x, int y0, int y1, int color)
{
  int  offset, win;
  char *base1, *base2;

  offset  = y0 * _g_linesize + x / 8;
  win     = offset / _g_wingran;
  offset &= _g_wingran - 1;
  y1     -= y0;
  base1   = _g_wmem + offset;
  base2   = _g_rmem + offset;

  _outp16(GRA_I, color << 8);
  _outp16(GRA_I, (0x8000 >> (x & 7)) | 8);

  if (win != _g_wwinstat)
    VesaSetWindow(_g_wwin, win);
  if (win != *_g_rwinstat)
    VesaSetWindow(_g_rwin, win);

  while (y1-- >= 0)
    {
      *base1 = *base2;
      base1 += _g_linesize;
      base2 += _g_linesize;
      if ((offset += _g_linesize) >= _g_winsize)
        {
          offset &= _g_wingran - 1;
          base1   = _g_wmem + offset;
          base2   = _g_rmem + offset;
          win    += _g_winfact;
          _g_setwin(_g_wwin, win);
          _g_setwin(_g_rwin, win);
        }
    }
  _g_wwinstat  = win;
  *_g_rwinstat = win;
}

void SEG256_vline(int x, int y0, int y1, int color)
{
  int  offset, win;
  char *base;

  offset  = y0 * _g_linesize + x;
  win     = offset / _g_wingran;
  offset &= _g_wingran - 1;
  y1     -= y0;
  base    = _g_wmem + offset;

  if (win != _g_wwinstat)
    VesaSetWindow(_g_wwin, win);

  while (y1-- >= 0)
    {
      *base = color;
      base += _g_linesize;
      if ((offset += _g_linesize) >= _g_winsize)
        {
          offset &= _g_wingran - 1;
          base    = _g_wmem + offset;
          win    += _g_winfact;
          _g_setwin(_g_wwin, win);
        }
    }
  _g_wwinstat = win;
}

void SEG32k_vline(int x, int y0, int y1, int color)
{
  int  offset, win;
  char *base;

  offset  = y0 * _g_linesize + x * 2;
  win     = offset / _g_wingran;
  offset &= _g_wingran - 1;
  y1     -= y0;
  base    = _g_wmem + offset;

  if (win != _g_wwinstat)
    _g_setwin(_g_wwin, win);

  while (y1-- >= 0)
    {
      *(unsigned short *) base = color;
      base += _g_linesize;
      if ((offset += _g_linesize) >= _g_winsize)
        {
          offset &= _g_wingran - 1;
          base    = _g_wmem + offset;
          win    += _g_winfact;
          _g_setwin(_g_wwin, win);
        }
    }
  _g_wwinstat = win;
}

void SEG16m_vline(int x, int y0, int y1, int color)
{
  int  offset, win;
  char *base;
  char r, g, b;

  r = color;
  g = color >> 8;
  b = color >> 16;

  offset  = y0 * _g_linesize + x * 3;
  win     = offset / _g_wingran;
  offset &= _g_wingran - 1;
  y1     -= y0;
  base    = _g_wmem + offset;

  if (win != _g_wwinstat)
    _g_setwin(_g_wwin, win);

  while (y1-- >= 0)
    {
      *base++ = r;
      *base++ = g;
      *base   = b;
      base   += _g_linesize - 2;
      if ((offset += _g_linesize) >= _g_winsize)
        {
          offset &= _g_wingran - 1;
          base    = _g_wmem + offset;
          win    += _g_winfact;
          _g_setwin(_g_wwin, win);
        }
    }
  _g_wwinstat = win;
}

void ALT256_vline(int x, int y0, int y1, int color)
{
  char *base;

  _outp8(SEQ_I, 0x02);
  _outp8(SEQ_D, 1 << (x & 3));

  base = _g_wmem + y0 * _g_linesize + (x >> 2);

  y1 -= y0;

  while (y1-- >= 0)
    {
      *base = color;
      base += _g_linesize;
    }
}

void g_vline(int x, int y0, int y1, int color)
{
  int  y;

  if (y0 > y1)
    {
      y  = y0;
      y0 = y1;
      y1 = y;
    }
  if ((x < _g_clipx0) || (x > _g_clipx1) || (y0 > _g_clipy1) || (y1 < _g_clipy0))
    return;
  if (y0 < _g_clipy0)
    y0 = _g_clipy0;
  if (y1 > _g_clipy1)
    y1 = _g_clipy1;
  GLOCK;
  _g_vline(x, y0, y1, color);
  GUNLOCK;
}
