/* REXX (Really EXtraordinary eXecutor) file to install VxFTP.EXE */

/* Written: April 17, 1994, revised May 8, 1994 */
/* Author:  Howard Hyten */

/* install.cmd modified for use with Thumb by Paul Braren
   with permission of author, Howard Hyten */


'@echo off'

if RxFuncQuery("SysLoadFuncs") then do
    rc = RxFuncAdd("SysLoadFuncs", "RexxUtil", "SysLoadFuncs")
    rc = SysLoadFuncs()
    if (rc = 1) then do
        say "You don't have the REXXUtil.DLL installed in your LIBPATH."
        say "You must have these components loaded before Thumb will run."
        exit -1
    end
end

do forever
    say "Please enter the boot drive. [Example: C ]"
    say "Or press CTRL+Break to stop this installer if you plan"
    say "to install into an existing Thumb directory and want to"
    say "keep a copy of your old Thumb.INI file first."
    pull bootDrive
    bootDrive = left(bootDrive, 1)
    if (datatype(bootDrive) = 'CHAR') then do
        call SysFileTree bootDrive":\config.sys", file., 'F'
        if file.1 = "FILE.1" then do
            say bootdrive "is not the Boot Drive. (Press Ctrl-Break to quit.)"
	    iterate
	end
        leave
    end /* if */
    else
        say "Wrong.."
end

do forever
    line_in = linein( bootdrive':\config.sys' )
    if ( translate( left( line_in, 8)) = 'LIBPATH=' ) then
	leave
end

libpath = translate( line_in, "|", ";" )
do until rest = ""
    parse var libpath dir1 "|" rest
    if ( translate( right( dir1, 9)) = 'TCPIP\DLL') then
	leave
    libpath = rest

end

say ' '
say 'Make sure RXSOCK.DLL is somewhere in your path.  If your TCP/IP'
say 'Base Kit SYSLEVEL is at UN56401 (July 94) you may delete'
say 'RXSOCK.DLL and license.txt, since you already have'
say ' \tcpip\dll\rxsock.dll'
say ' '
say "Enter the full path of the directory where you want to install Thumb."
say "Be sure to include the drive as well."
say "(Press return for a default of C:\Thumb)"
parse pull target1
if ( target1 = "" ) then
    target1 = "C:\Thumb"

call SysMkDir target1
'copy Thumb.EXE' target1 '> nul'
'copy Thumb.INI' target1 '> nul'
'copy Thumb.ICO' target1 '> nul'
'copy Thumb.TXT' target1 '> nul'
'copy RXSOCK.DLL' target1 '> nul'
'copy license.txt' target1 '> nul'

setupString = "OBJECTID=<Thumb>;"||,
              "EXENAME="||target1||"\Thumb.EXE;"||,
              "ICONFILE="||target1||"\Thumb.ICO;"||,
              "PROGTYPE=PM;"

if SysCreateObject("WPProgram", "Thumb v1.2", ,
                   "<WP_DESKTOP>", setupString, "R")
then do
    say "A Thumb object was created on your Desktop."
    say "Just double-click the object to start."
    say ""
    say "Put /min into the object's Optional Parameters if"
    say "you want it to start minimized."
end
else
    say "Couldn't create an Thumb object on your Desktop."

say ""

exit 0
