' Area: F-PowerBASIC 
'  Msg#: 8                                            Date: 18 Apr 94  01:33:00
'  From: Arnie Sossner                                Read: Yes    Replied: No 
'    To: All                                          Mark:                     
'  Subj: COMMAND$ parsing
'
'I've seen lots of requests to parse COMMAND$ in the QuikBASIC FIDOnet
'echo.  It's amazingly easy in PowerBASIC version 3 using the EXTRACT$
'and REMOVE$ commands.  I've coded up the following demo for your
'edification.

' MYPARSE.BAS Puts each command line operand into an array. Reports number of
'             operands.
' 4/17/94 - First release - by Arnie Sossner - Prodigy: VRPT68A

' For sake of demonstations, start this program with various operands.
' For example:
'   Demo 1: MYPARSE
'   Demo 2: MYPARSE a B c D
'   Demo 3: MYPARSE /Op1 /Op2
'   Demo 4  MYPARSE /?

' 4/17/94 - First release AP Sossner - Prodigy: VRPT68A

'variables
DIM Operand$(1 TO 20)              'space for twenty operands ought to suffice
Sep$=" "                           'operand separator character

'main program
  CLS
  IF LEN(COMMAND$)<>0 THEN
     PRINT "The command line to be parsed: "+COMMAND$
     CALL ParseCommandLine(Operand$(),OperandCount,Sep$)
  ELSE
     PRINT "No command line operands."
     END IF
  'demo of efficacy
  PRINT "The number of command line operands: "+STR$(OperandCount)
  FOR i = 1 to OperandCount
    PRINT "Operand"+STR$(i)+": "+Operand$(i)
    NEXT i
  END


'subroutines
SUB ParseCommandLine(Operand$(),OperandCount,Sep$)
  'Parse command line for operands. Array starts at 1, no 0; hence Operand$
  'index is incremented by 1.
  Cmd$ = LTRIM$(RTRIM$(UCASE$(COMMAND$)))    'your appl might not want UCASE$
  OperandCount = 0
  DO
    Operand$(OperandCount+1) = EXTRACT$(Cmd$,Sep$) 'extract string to 1st Sep$
    Cmd$ = REMOVE$(Cmd$,Operand$(OperandCount+1))  'remove Op(i) from Cmd$
    Cmd$ = LTRIM$(Cmd$)  'Change this line if Sep$ is not a space character
    OperandCount = OperandCount + 1                'get next Operand$
    LOOP UNTIL LEN(Cmd$) = 0
  END SUB

  'you might want a SELECT to decode the operands either in Main or a SUB
  'SUB ProcessOperands ...
  'DO
  '  FOR i = 1 TO OperandCount
  '    SELECT CASE Operand$(i)
  '      CASE "/?"
  '        ShowHelp
  '        SYSTEM
  '      CASE "A"
  '        DoA
  '      CASE "B"
  '        DoB
  '      END SELECT
  '  NEXT i
  'END DO
  'END SUB
