' Area: F-QUICKBASIC 
'  Msg#: 390                                          Date: 16 Apr 94  23:25:02
'  From: Joe Negron                                   Read: Yes    Replied: No 
'    To: Todd Jacobs                                  Mark:                     
'  Subj: Checking to see if a dir
'
'TJ> I have been unable to figure out a way to make QuickBasic check to
'  > see if a  directory exists.  There's no "IF EXIST" function, and FILES
'  > doesn't do  anything along those lines.

DEFINT A-Z

'$INCLUDE: 'qb.bi'

DECLARE FUNCTION Exist% (FileName$)

'***********************************************************************
'* FUNCTION Exist%
'*
'* PURPOSE
'*    Uses DOS ISR 21H, Function 4EH (Find First Matching Directory
'*    Entry) to determine the existence of FileName$.
'***********************************************************************
FUNCTION Exist% (FileName$) STATIC
   DIM Reg AS RegTypeX

   Reg.ax = &H4E00
   Reg.cx = &H3F                             'search for all files
   FileName$ = FileName$ + CHR$(0)           'must end with null byte

   Reg.ds = VARSEG(FileName$)                'load DS:DX with
   Reg.dx = SADD(FileName$)                  '  address of FileName$

   InterruptX &H21, Reg, Reg
   Exist% = Reg.ax = 0                       'if ax contains a value,
                                             '  then file does not exist
   'remove the null byte
   FileName$ = LEFT$(FileName$, LEN(FileName$) - 1)
END FUNCTION
