$INCLUDE "DNALIB.INC"
$LINK "DNALIB.PBL"

DIM STATIC PBLib$(100)
DIM STATIC Module$(500)
DIM STATIC AddModule$(500)
DIM STATIC FileName$(500)
DIM STATIC Menu$(12)
DIM STATIC Info$(12)
DIM STATIC Message$(2)
DIM STATIC PickMenu$(5)

ON ERROR GOTO LibError

SplitPath GetProgramName$, Home$, EXEName$

IF LEN(DIR$(Home$ + "LIBMAN.CFG")) THEN
  OPEN Home$ + "LIBMAN.CFG" FOR INPUT AS #1
    LINE INPUT #1, PBLibHome$
    LINE INPUT #1, UnitHome$
    LINE INPUT #1, OBJHome$
    LINE INPUT #1, LibHome$
  CLOSE #1
ELSE
  Message$(1) = Home$ + "LIBMAN.CFG is missing !"
  SOUND 50,5
  DIALOG Message$(),"",0,Mouse%,3,0,0,14,79,1,1
  GOTO WayOut
END IF

EmptyLib% = 606 'size of info file when there are no modules
DosAllow$ = CHR$(24) + "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_^$~!{}()@'`*.\:"
Tag% = 16: Ok% = 0
HelpTextColor% = 14
HelpAttr% = 79

IF MouseThere% THEN Mouse% = 1

Menu$(1) = "@Open"
Menu$(2) = "@Create"
Menu$(3) = "@List"
Menu$(4) = "@Browse"
Menu$(5) = "@Add"
Menu$(6) = "@Delete"
Menu$(7) = "E@xtract"
Menu$(8) = "@Print"
Menu$(9) = "@Kill"
Menu$(10) = "@Erase"
Menu$(11) = "@Quit"

Info$(1) = "Open a PowerBASIC Library for modification"
Info$(2) = "Create a PowerBASIC Library"
Info$(3) = "List the OBJ's or PBU modules in a PowerBASIC Library"
Info$(4) = "Browse the current List/Map File"
Info$(5) = "Add OBJ's or PBU modules to a New or Existing PowerBASIC Library"
Info$(6) = "Delete OBJ's or PBU modules from an Existing PowerBASIC Library"
Info$(7) = "Extract OBJ's or PBU modules from an Existing PowerBASIC Library"
Info$(8) = "Print the currently selected library Map File"
Info$(9) = "Delete a PowerBASIC Library File from Disk"
Info$(10) = "Erase OBJ's or PBU modules from DNA Library Managers work Directory"
Info$(11) = "Quit the DNA Library Manager"

SCREEN 0

LPointer% = -1

POPWIND "",1,1,23,80,31,0,1
COLOR 7,1
LOCATE 3,6,0:PRINT "Ŀ           ";
LOCATE 4,6,0:PRINT "                ";
LOCATE 5,6,0:PRINT "      Ŀ Ŀ         Ŀ";
LOCATE 6,6,0:PRINT "         Ĵ           ";
LOCATE 7,6,0:PRINT "         ";

LOCATE 10,22,0:PRINT "";
LOCATE 11,22,0:PRINT "";
LOCATE 12,22,0:PRINT "        Ŀ  Ŀ Ŀ Ŀ   ";
LOCATE 13,22,0:PRINT "            Ĵ  Ĵ";
LOCATE 14,22,0:PRINT "            ";

LOCATE 17,38,0:PRINT "Ŀ";
LOCATE 18,38,0:PRINT "    ";
LOCATE 19,38,0:PRINT "     Ŀ Ŀ Ŀ Ŀ Ŀ Ŀ";
LOCATE 20,38,0:PRINT "     Ĵ    Ĵ  Ŀ    ";
LOCATE 21,38,0:PRINT "                 ";

Jump:

LOTUS Menu$(),Info$(),HiLight%,Mouse%,LPointer%,14,14,79,7,112,24,2

  SELECT CASE LPointer%
    CASE 1
      GOSUB GetPBU
    CASE 2
      GOSUB GetName
    CASE 3
      GOSUB GetUnits
    CASE 4
      GOSUB BrowseMap
    CASE 5
      GOSUB AddUnits
    CASE 6
      GOSUB DeleteUnits
    CASE 7
      GOSUB ExtractUnits
    CASE 8
      GOSUB PrintLib
    CASE 9
      GOSUB EraseLib
    CASE 10
      GOSUB EraseDir
    CASE 11
      GOTO WayOut
  END SELECT

DO
DELAY .5
WHILE NOT INSTAT
  IF Mouse% THEN
    ShowCursor: Rgt% = 0: Lft% = 0
    Clicked Rgt%,Lft%,MRow%,MCol%
    IF Lft% AND MRow% = 24 THEN
      FindMenu MRow%,MCol%,Found%
      IF Found% THEN
        LPointer% = Found%
        HideCursor: HiLight% = 1
        GOTO Jump
      END IF
    END IF
  END IF
  IF AltKey% THEN
    HiLight% = 1
    IF LPointer% = 0 THEN LPointer% = 1
    GOTO Jump
  END IF
WEND
Ky$ = INKEY$

LOOP UNTIL Ky$ = CHR$(27)

WayOut:

IF LEN(DIR$("COMMAND.FIL")) THEN KILL "COMMAND.FIL"
IF LEN(DIR$("LIBINFO.TXT")) THEN KILL "LIBINFO.TXT"

IF LEN(DIR$("*.OBJ")) OR LEN(DIR$("*.PBU")) THEN
  IF YesNo%("Delete all Extracted modules from " + Home$ + " (Y or N)",1,10,79,112,1,1) THEN
    IF LEN(DIR$("*.PBU")) THEN SHELL "DEL *.PBU > NUL"
    IF LEN(DIR$("*.OBJ")) THEN SHELL "DEL *.OBJ > NUL"
  END IF
END IF

IF Mouse% THEN HideCursor

COLOR 7,0
CLS
END
'----------------------------------------------------------------------------
GetPBU:

i% = 1
PBLib$(i%) = DIR$(LibHome$ + "*.PBL")

  DO
    INCR i%
    PBLib$(i%) = DIR$
    IF i% = 100 THEN EXIT LOOP
  LOOP WHILE PBLib$(i%) <> ""

IF LEN(PBLib$(1)) THEN
  PickLibName$ = ""
  SCROLLBOX PBLib$(),PickLibName$,"PBL's",Mouse%,10,0,1,0,14,112,0,0,1,1

  IF LEN(PickLibName$) THEN
    LibName$ = PickLibName$
  ELSE
    RETURN
  END IF

  UpDateModules:

  IF LEN(LibName$) THEN
    IF LEN(DIR$(LibHome$ + LibName$)) THEN
      FileNumber% = FREEFILE
      OPEN "COMMAND.FIL" FOR OUTPUT AS #FileNumber%
      PRINT #FileNumber%,"O";LibHome$ + LibName$
      PRINT #FileNumber%,"M"
      PRINT #FileNumber%,"C"
      PRINT #FileNumber%,"Q"
      CLOSE #FileNumber%
    END IF
    MEMPACK
    SHELL PBLibHome$ + "PBLIB COMMAND.FIL > LIBINFO.TXT"
    IF LEN(DIR$("LIBINFO.TXT")) THEN
      FileNumber% = FREEFILE
      OPEN "LIBINFO.TXT" FOR BINARY AS FileNumber%
      IF LOF(FileNumber%) > EmptyLib% + (4 * LEN(LibHome$ + LibName$)) THEN
        CLOSE FileNumber%
        FOR i% = 1 TO 500
          Module$(i%) = ""
        NEXT i%
        Ok% = 1
        OPEN "LIBINFO.TXT" FOR INPUT AS #1
        i% = 1
        DO
          LINE INPUT #1, Test$
            IF LEN(Test$) THEN
              IF INSTR(Test$,".PBU") OR INSTR(Test$,".OBJ") THEN
                Module$(i%) = Test$: INCR i%
              END IF
            END IF
        LOOP WHILE NOT EOF(1)
        CLOSE #1
      ELSE
        Message$(1) = LibHome$ + LibName$ + " has 0 Modules!"
        FOR i% = 1 TO 500
          Module$(i%) = ""
        NEXT i%
        Ok% = 0
        SOUND 50,5
        DIALOG Message$(),"",1,Mouse%,3,0,0,14,79,1,1
      END IF
      CLOSE FileNumber%
    END IF
  END IF
ELSE
  Message$(1) = LibHome$ + " has No Libraries!"
  Ok% = 0
  SOUND 50,5
  DIALOG Message$(),"",1,Mouse%,3,0,0,14,79,1,1
END IF

RETURN
'----------------------------------------------------------------------------
GetName:

PBLName$ = "        "
Fill% = 176 :Row% = 12 :Col% = 49

IF Mouse% THEN HideCursor

SAVESCREEN EditScreen$,11,18,13,62,1

POPWIND Title$,11,18,13,62,112,1,1
LOCATE Row%,20,0:COLOR 0,7:PRINT "Enter a name for the Library         .PBL"
LINEEDIT DosAllow$,PBLName$,Mouse%,MouseRow%,MouseCol%,Fill%,Row%,Col%,Editkey%,14
LOCATE,,0

IF Mouse% THEN HideCursor

RESTORESCREEN EditScreen$,11,18

IF LEN(LTRIM$(RTRIM$(PBLName$))) THEN
  LibName$ = UCASE$(LTRIM$(RTRIM$(PBLName$))) + ".PBL"
  FOR i% = 1 TO 500
    Module$(i%) = ""
  NEXT i%
  Ok% = 0
  IF LEN(DIR$("COMMAND.FIL")) THEN KILL "COMMAND.FIL"
  IF LEN(DIR$("LIBINFO.TXT")) THEN KILL "LIBINFO.TXT"
END IF

RETURN
'----------------------------------------------------------------------------
GetUnits:

IF Ok% THEN
  PickBox Module$(),NotNeeded$,"Listing of modules in " + LibName$,2,0,Mouse%,112,14,79,1,1
ELSE
  Message$(1) = "You must Open a PBL file first"
  SOUND 50,5
  DIALOG Message$(),"",1,Mouse%,3,0,0,14,79,1,1
END IF

RETURN
'----------------------------------------------------------------------------
BrowseMap:

IF LEN(DIR$("LIBINFO.TXT")) THEN
  FileNumber% = FREEFILE
  OPEN "LIBINFO.TXT" FOR BINARY AS FileNumber%
  IF LOF(FileNumber%) > EmptyLib% + (4 * LEN(LibHome$ + LibName$)) THEN
    BROWSE "LIBINFO.TXT",Mouse%,0,3,8,20,72,112,1,1
  ELSE
    Message$(1) = LibHome$ + LibName$ + " has 0 Modules!"
    SOUND 50,5
    DIALOG Message$(),"",1,Mouse%,3,0,0,14,79,1,1
  END IF
    CLOSE FileNumber%
ELSE
  Message$(1) = "You must Open a PBL file first"
  SOUND 50,5
  DIALOG Message$(),"",1,Mouse%,3,0,0,14,79,1,1
END IF

RETURN
'----------------------------------------------------------------------------
AddUnits:

IF LEN(LibName$) THEN
  PickMenu$(1) = "Extracted modules from current Directory"
  PickMenu$(2) = "OBJ's from " + OBJHome$
  PickMenu$(3) = "PPU's from " + UnitHome$
  PickMenu$(4) = "User defined Path and File specification"
  PickName$ = ""
  SCROLLBOX PickMenu$(),PickName$,"Add modules from which Directory?",Mouse%,10,0,1,3,14,112,0,0,1,1
  IF LEN(PickName$) THEN
    SELECT CASE PickName$
      CASE "Extracted modules from current Directory"
        IF LEN(DIR$("*.OBJ")) OR LEN(DIR$("*.PBU")) THEN
          Path$ = Home$: Ext$ = "*.*"
          GOSUB Selection
        ELSE
          Message$(1) = "There are No Modules In " + Home$
          SOUND 50,5
          DIALOG Message$(),"",1,Mouse%,3,0,0,14,79,1,1
        END IF
      CASE "OBJ's from " + OBJHome$
        Path$ = OBJHome$: Ext$ = "*.OBJ"
        GOSUB Selection
      CASE "PPU's from " + UnitHome$
        Path$ = UnitHome$: Ext$ = "*.PBU"
        GOSUB Selection
      CASE "User defined Path and File specification"
        WriteToBox Rtrn$,"*.*",Mouse%,112,14,79,1,1
        IF LEN(Rtrn$) THEN
          SplitPath Rtrn$,Path$,Ext$
          GOSUB Selection
        END IF
    END SELECT
  END IF
ELSE
  Message$(1) = "You must Open or Create PBL file first"
  SOUND 50,5
  DIALOG Message$(),"",1,Mouse%,3,0,0,14,79,1,1
END IF

RETURN
'----------------------------------------------------------------------------
Selection:

FOR i% = 1 TO 500
  AddModule$(i%) = ""
NEXT i%

AddArray$ = ""

i% = 1
AddModule$(i%) = DIR$(Path$ + Ext$)

  DO
    INCR i%
    AddModule$(i%) = DIR$
    IF i% = 500 THEN EXIT LOOP
  LOOP WHILE AddModule$(i%) <> ""

  PickBox AddModule$(),AddArray$,"Add modules to " + LibName$,2,Tag%,Mouse%,112,14,79,1,1

  IF LEN(AddArray$) THEN
    FileNumber% = FREEFILE
    OPEN "COMMAND.FIL" FOR OUTPUT AS #FileNumber%
    PRINT #FileNumber%,"O";LibHome$ + LibName$
    FOR i% = 1 TO 500
      FileName$(i%) = ""
    NEXT i%
    i% = 0
    Temp$ = LTRIM$(AddArray$,CHR$(Tag%))
    DO
      INCR i%
      j% = INSTR(Temp$,ANY CHR$(Tag%))
      IF j% = 0 THEN
        FileName$(i%) = Temp$
      ELSE
        FileName$(i%) = LEFT$(Temp$,j% - 1)
      END IF
      PRINT #FileNumber%,"A" + Path$ + FileName$(i%)
      Temp$ = LTRIM$(Temp$,FileName$(i%))
      Temp$ = LTRIM$(Temp$,CHR$(Tag%))
    LOOP UNTIL FileName$(i%) = ""
    PRINT #FileNumber%,"C"
    PRINT #FileNumber%,"Q"
    CLOSE #FileNumber%
    MEMPACK
    SHELL PBLibHome$ + "PBLIB COMMAND.FIL > NUL
    GOSUB UpDateModules  'this updates the map file and modules array
  END IF

RETURN
'----------------------------------------------------------------------------
DeleteUnits:

IF Ok% THEN
  DeleteArray$ = ""
  PickBox Module$(),DeleteArray$,"Delete modules from " + LibName$,2,Tag%,Mouse%,112,14,79,1,1
  IF LEN(DeleteArray$) THEN
    IF LEN(DIR$(LibHome$ + LibName$)) THEN
      FileNumber% = FREEFILE
      OPEN "COMMAND.FIL" FOR OUTPUT AS #FileNumber%
      PRINT #FileNumber%,"O";LibHome$ + LibName$
      FOR i% = 1 TO 500
        FileName$(i%) = ""
      NEXT i%
      i% = 0
      Temp$ = LTRIM$(DeleteArray$,CHR$(Tag%))
      DO
        INCR i%
        j% = INSTR(Temp$,ANY CHR$(Tag%))
        IF j% = 0 THEN
          FileName$(i%) = Temp$
        ELSE
          FileName$(i%) = LEFT$(Temp$,j% - 1)
        END IF
        PRINT #FileNumber%,"D" + FileName$(i%)
        Temp$ = LTRIM$(Temp$,FileName$(i%))
        Temp$ = LTRIM$(Temp$,CHR$(Tag%))
      LOOP UNTIL FileName$(i%) = ""
      PRINT #FileNumber%,"C"
      PRINT #FileNumber%,"Q"
      CLOSE #FileNumber%
    END IF
    IF YesNo%("Delete modules from " + LibName$ + " (Y or N)",1,10,79,112,1,1) THEN
      MEMPACK
      SHELL PBLibHome$ + "PBLIB COMMAND.FIL > NUL
      GOSUB UpDateModules  'this updates the map file and modules array
    ELSE
      KILL "COMMAND.FIL"
    END IF
  END IF
ELSE
  Message$(1) = "You must Open a PBL file first"
  SOUND 50,5
  DIALOG Message$(),"",1,Mouse%,3,0,0,14,79,1,1
END IF

RETURN
'----------------------------------------------------------------------------
ExtractUnits:

IF Ok% THEN
  ExtractArray$ = ""
  PickBox Module$(),ExtractArray$,"Extract modules from " + LibName$,2,Tag%,Mouse%,112,14,79,1,1
  IF LEN(ExtractArray$) THEN
    IF LEN(DIR$(LibHome$ + LibName$)) THEN
      FileNumber% = FREEFILE
      OPEN "COMMAND.FIL" FOR OUTPUT AS #FileNumber%
      PRINT #FileNumber%,"O";LibHome$ + LibName$
      FOR i% = 1 TO 500
        FileName$(i%) = ""
      NEXT i%
      i% = 0
      Temp$ = LTRIM$(ExtractArray$,CHR$(Tag%))
      DO
        INCR i%
        j% = INSTR(Temp$,ANY CHR$(Tag%))
        IF j% = 0 THEN
          FileName$(i%) = Temp$
        ELSE
          FileName$(i%) = LEFT$(Temp$,j% - 1)
        END IF
        PRINT #FileNumber%,"E" + FileName$(i%)
        Temp$ = LTRIM$(Temp$,FileName$(i%))
        Temp$ = LTRIM$(Temp$,CHR$(Tag%))
      LOOP UNTIL FileName$(i%) = ""
      PRINT #FileNumber%,"C"
      PRINT #FileNumber%,"Q"
      CLOSE #FileNumber%
    END IF
    MEMPACK
    SHELL PBLibHome$ + "PBLIB COMMAND.FIL > NUL
  END IF
ELSE
  Message$(1) = "You must Open a PBL file first"
  SOUND 50,5
  DIALOG Message$(),"",1,Mouse%,3,0,0,14,79,1,1
END IF

RETURN
'----------------------------------------------------------------------------
PrintLib:

IF Ok% THEN
  FileNumber% = FREEFILE
  OPEN Home$ + "LIBINFO.TXT" FOR BINARY AS FileNumber%
  IF LOF(FileNumber%) > 32000 THEN
    GET$ FileNumber%, 32000, Text$
  ELSE
    GET$ FileNumber%, LOF(FileNumber%),Text$
  END IF
  CLOSE FileNumber%
  Message$(1) = ""
  SELECT CASE Printer%(0)
    CASE 1
      Message$(1) = "  Time Out  "
    CASE 2
      Message$(1) = "  I/O Error  "
    CASE 3
      Message$(1) = "  No Paper  "
    CASE 4
      Message$(1) = "  Printer is Offline  "
    CASE ELSE
      WIDTH "LPT1:",255
      LPRINT Text$
      SOUND 5000,.5:SOUND 1000,.5
  END SELECT
    IF LEN(Message$(1)) THEN
      SOUND 50,5
      DIALOG Message$(),"",1,Mouse%,3,0,0,14,79,1,1
    END IF
END IF

RETURN
'----------------------------------------------------------------------------
EraseLib:

i% = 1
PBLib$(i%) = DIR$(LibHome$ + "*.PBL")

  DO
    INCR i%
    PBLib$(i%) = DIR$
    IF i% = 100 THEN EXIT LOOP
  LOOP WHILE PBLib$(i%) <> ""


IF LEN(PBLib$(1)) THEN
  KillName$ = ""
  SCROLLBOX PBLib$(),KillName$,"PBL's",Mouse%,10,0,1,0,14,112,0,0,1,1
  IF LEN(KillName$) THEN
    IF LEN(DIR$(LibHome$ + KillName$)) THEN
      IF YesNo%("Delete " + LibHome$ + KillName$ + " from Disk (Y or N)",1,10,79,112,1,1) THEN
        KILL LibHome$ + KillName$
        IF KillName$ = LibName$ THEN
          FOR i% = 1 TO 500
            Module$(i%) = ""
          NEXT i%
          Ok% = 0
          IF LEN(DIR$("COMMAND.FIL")) THEN KILL "COMMAND.FIL"
          IF LEN(DIR$("LIBINFO.TXT")) THEN KILL "LIBINFO.TXT"
        END IF
      END IF
    END IF
  END IF
ELSE
  Message$(1) = "No Libraries! to Delete"
  Ok% = 0
  SOUND 50,5
  DIALOG Message$(),"",1,Mouse%,3,0,0,14,79,1,1
END IF

RETURN
'----------------------------------------------------------------------------
EraseDir:

IF LEN(DIR$("*.OBJ")) OR LEN(DIR$("*.PBU")) THEN
  IF YesNo%("Delete all Extracted modules from " + Home$ + " (Y or N)",1,10,79,112,1,1) THEN
    IF LEN(DIR$("*.PBU")) THEN SHELL "DEL *.PBU > NUL"
    IF LEN(DIR$("*.OBJ")) THEN SHELL "DEL *.OBJ > NUL"
  END IF
ELSE
  Message$(1) = "There are No Modules In " + Home$
  SOUND 50,5
  DIALOG Message$(),"",1,Mouse%,3,0,0,14,79,1,1
END IF

RETURN
'----------------------------------------------------------------------------
LibError:

Message$(1) = "   ERROR" + STR$(ERR) + " AT PGM-CTR" + STR$(ERADR) + "   "

SOUND 50,5

DIALOG Message$(),"",0,Mouse%,3,0,0,14,79,1,1

RESUME NEXT
'----------------------------------------------------------------------------
END 'Program
'----------------------------------------------------------------------------
