DECLARE SUB Browse(FileName$,Mouse%,TextColor%,TopRow%,LeftColumn%,BottomRow%,RightColumn%,Attr%,Shadow%,Border%)
DECLARE SUB PopWind(Title$,TopRow%,LeftColumn%,BottomRow%,RightColumn%,Attr%,Shadow%,Border%)
DECLARE SUB SaveScreen(ScreenID$,TopRow%,LeftColumn%,BottomRow%,RightColumn%,Shadow%)
DECLARE SUB SplitPath(FilePath$, Path$, FileName$)
DECLARE SUB RestoreScreen(ScreenID$,TopRow%,LeftColumn%)
DECLARE SUB CalcByte(Attr%,LowByte%,HiByte%)
DECLARE SUB Clicked(Rgt%,Lft%,Row%,Col%)
DECLARE SUB FindMenu(Row%,Col%,Found%)
DECLARE SUB HideCursor()
DECLARE SUB ShowCursor()
DECLARE FUNCTION LeftButtonReleased%()
DECLARE FUNCTION GetProgramName$()
DECLARE FUNCTION GetPSP%()

SUB VerticalMenu(Choices$(),Infoline$(),Rtrn$,BarSave$,Mouse%,HotKey%,HelpTextColor%,HelpAttr%,HiAttr%,MenuRow%,Marker%,HPointer%,Attr%,Shadow%,Border%) PUBLIC

$CODE SEG "DNASEG2"

IF Mouse% THEN HideCursor

CalcByte Attr%,FGround%,BGround%
CalcByte HiAttr%,HiFG%,HiBG%

SplitPath GetProgramName$,Home$,EXEName$

SELECT CASE Border%
  CASE 1,3
    Leftside% = 195
    Middle% = 196
    Rightside% = 180
  CASE 2,4
    Leftside% = 199
    Middle% = 196
    Rightside% = 182
  CASE ELSE
    Leftside% = 32
    Middle% = 32
    Rightside% = 32
END SELECT

i% = 0                                      'loop counter
j% = 0                                      'loop compare
Maxlength% = 0                              'string length counter
Colpos% = Marker%
LeftColumn% = Colpos%
TopRow% = MenuRow% + 1

DO

INCR i%
INCR j%                                 'first find out how many
                                        'strings there are and the
IF LEN (Choices$(i%)) = 0 THEN          'length of the longest one
 DECR i%
ELSEIF LEN(REMOVE$(Choices$(i%),"@")) > Maxlength% THEN
 Maxlength% = LEN(REMOVE$(Choices$(i%),"@"))
END IF

LOOP WHILE i% = j%

Count% = i%

INCR Maxlength%              'add a space

'a simple test to see what size the window will be with the shadow

IF Shadow% = 1 THEN
  b% = 5
ELSE
  b% = 3
END IF


'test the position of the menu to see if it fits and adjust
'its position if its off the screen

IF LeftColumn% + (Maxlength% + b%) >= 80 THEN
  LeftColumn% = 80 - (Maxlength% + b%)
END IF

'work out the size of the window to pass to PopWind

RightColumn% = LeftColumn% + (Maxlength% + 2)
BottomRow% = TopRow% + (Count% + 1)

'this saves just the area under the pulled down window

SaveScreen VertScreen$,TopRow%,LeftColumn%,BottomRow%,RightColumn%,Shadow%

PopWind Title$,TopRow%,LeftColumn%,BottomRow%,RightColumn%,Attr%,Shadow%,Border%

Pointer% = 1                      'initialize all these
SelectionMade% = 0


DO

PrintRoutine:

IF Mouse% THEN HideCursor

Row% = TopRow% + 1
Col% = LeftColumn% + 1

FOR a% = 1 TO Count%
  IF a% = Pointer% THEN
    Fixedup$ = REMOVE$(Choices$(a%),"@")
    COLOR HiFG%,HiBG%
    LOCATE Row%,Col%,0
    PRINT SPACE$(1) + Fixedup$ + SPACE$(Maxlength% - LEN(Fixedup$));
    IF LEN(Infoline$(a%)) > 0 THEN
      InfoLinePrinted% = 1
      COLOR FGround%,BGround%
      LOCATE 25,10,0
      PRINT LEFT$(SPACE$((60 - LEN(Infoline$(a%))) \ 2) + Infoline$(a%) + SPACE$(60),60);
    END IF
  ELSE
    IF INSTR(Choices$(a%),"@") > 0 THEN
      HotKeyPos% = INSTR(Choices$(a%),"@")
      Fixedup$ = REMOVE$(Choices$(a%),"@")
      Front$ = LEFT$(Fixedup$,(HotKeyPos% - 1))
      HotKey$ = MID$(Fixedup$,(HotKeyPos%),1)
      Back$ = RIGHT$(Fixedup$,LEN(Fixedup$) - HotKeyPos%)
      COLOR FGround%,BGround%
      LOCATE Row%,Col%,0
      PRINT SPACE$(1) + Front$;
      COLOR HotKey%,BGround%
      PRINT HotKey$;
      COLOR FGround%,BGround%
      PRINT Back$ + SPACE$(Maxlength% - LEN(Fixedup$));
    ELSE
      IF INSTR(Choices$(a%),"_") THEN
        COLOR FGround%,BGround%
        LOCATE Row%,LeftColumn%,0
        PRINT CHR$(Leftside%) + STRING$(Maxlength% + 1,Middle%) + CHR$(Rightside%);
      ELSE
        COLOR FGround%,BGround%
        LOCATE Row%,Col%,0
        PRINT SPACE$(1) + Choices$(a%) + SPACE$(Maxlength% - LEN(Choices$(a%)));
      END IF
    END IF
  END IF
  INCR Row%
NEXT a%

WHILE NOT INSTAT
  IF Mouse% THEN
    Rgt% = 0:Lft% = 0:MRow% = 0:MCol% = 0
    ShowCursor
    Clicked Rgt%,Lft%,MRow%,MCol%
    IF MRow% > TopRow% AND MRow% < BottomRow% AND MCol% > LeftColumn% AND MCol% < RightColumn% THEN
      SELECT CASE MRow%
        CASE Pointer% + TopRow%
          IF LeftButtonReleased% THEN
            Chose% = 13
            HideCursor
            GOTO KeyBoardRoutine
          END IF
        CASE ELSE
          IF Lft% THEN
            FOR i% = (TopRow% + 1) TO (Count% + TopRow% + 1)
              IF i% = MRow% THEN
                Pointer% = i% - TopRow%
                IF ISFALSE INSTR(Choices$(Pointer%),"_")  THEN
                  GOTO PrintRoutine
                END IF
              END IF
            NEXT i%
          END IF
      END SELECT
    ELSE
      IF Lft% AND MRow% = MenuRow% THEN
        FindMenu MRow%,MCol%,Found%
        IF Found% AND Found% <> HPointer% THEN
          HPointer% = Found%
          Rtrn$ = ""
          HideCursor
          GOTO WayOut
        END IF
      ELSE
        IF LeftButtonReleased% THEN
          Chose% = 27
          HideCursor
          GOTO KeyBoardRoutine
        END IF
      END IF
    END IF
  END IF
WEND

Ky$ = INKEY$


IF LEN(Ky$) = 1 THEN
  Chose% = ASC(Ky$)
ELSE
  Chose% = -ASC(RIGHT$(Ky$,1))
END IF

KeyBoardRoutine:

SELECT CASE Chose%

        CASE 13   'enter key
          Rtrn$ = REMOVE$(Choices$(Pointer%),"@")
          SelectionMade% = 1
          Marker% = 0

        CASE 27   'Esc key
          Marker% = 0
          SelectionMade% = 1
          Rtrn$ = ""

        CASE -59  ' F1 Help key
          IF LEN(REMOVE$(Choices$(Pointer%),ANY "@ ")) > 8 THEN
            FileName$ = LEFT$(UCASE$(REMOVE$(Choices$(Pointer%),ANY "@ ")),8) + ".HLP"
          ELSE
            FileName$ = UCASE$(REMOVE$(Choices$(Pointer%),ANY "@ ")) + ".HLP"
          END IF
          BROWSE Home$ + FileName$,Mouse%,HelpTextColor%,7,16,18,64,HelpAttr%,Shadow%,Border%

        CASE -71  'home key
          Pointer% = 1

        CASE -72  'up arrow
          IF Pointer% > 1 THEN
            DECR Pointer%
          ELSE
            Pointer% = Count%
          END IF
          IF INSTR(Choices$(Pointer%),"_")  THEN
            IF Pointer% > 1 THEN
              DECR Pointer%
            ELSE
              Pointer% = Count%
            END IF
          END IF

        CASE -75 'left arrow
          DECR HPointer%
          SelectionMade% = 1
          Rtrn$ = ""

        CASE -77 'right arrow
          INCR HPointer%
          SelectionMade% = 1
          Rtrn$ = ""

        CASE -79  'end key
          Pointer% = Count%

        CASE -80  'down arrow
          IF Pointer% < Count% THEN
            INCR Pointer%
          ELSE
            Pointer% = 1
          END IF
          IF INSTR(Choices$(Pointer%),"_")  THEN
            IF Pointer% < Count% THEN
              INCR Pointer%
            ELSE
              Pointer% = 1
            END IF
          END IF

        CASE 32 TO 90, 97 TO 122
          FOR m% = 1 TO Count%
            IF INSTR(Choices$(m%),"@") > 0 THEN
              HotKeyPos% = INSTR(Choices$(m%),"@")
              HotKey$ = UCASE$(MID$(Choices$(m%),(HotKeyPos% + 1),1))
              TestKey$ = UCASE$(CHR$(Chose%))
              IF HotKey$ = TestKey$ THEN
                Rtrn$ = REMOVE$(Choices$(m%),"@")
                SelectionMade% = 1
                Marker% = 0
                EXIT FOR
              END IF
            END IF
          NEXT m%

        CASE ELSE
          BEEP

END SELECT


LOOP UNTIL SelectionMade% = 1

WayOut:

IF Mouse% THEN HideCursor

RestoreScreen VertScreen$,TopRow%,LeftColumn%

DEF SEG = &HB800
StartAddress% = (MenuRow% * 160) - 160
POKE$ StartAddress%,BarSave$
DEF SEG

IF InfoLinePrinted% = 1 THEN
  COLOR FGround%,BGround%
  LOCATE 25,15,0
  PRINT SPACE$(50);
END IF

END SUB
