$INCLUDE: 'C:\FG\INTRFACE.FOR'

      PROGRAM MAIN

      INTEGER*2 RECTANGLES
      PARAMETER (RECTANGLES=200)

      INTEGER*2 I
      INTEGER*2 MINX, MAXX, MINY, MAXY
      INTEGER*2 OLD_MODE
      INTEGER*2 XRES, YRES
      INTEGER*2 FG_AUTOMODE, FG_GETMAXX, FG_GETMAXY, FG_GETMODE
      INTEGER*2 RANDOM

      OLD_MODE = FG_GETMODE()
      CALL FG_SETMODE(FG_AUTOMODE())

      XRES = FG_GETMAXX()
      YRES = FG_GETMAXY()

      DO 10 I = 1,RECTANGLES
         MINX = RANDOM(0,XRES)
         MAXX = RANDOM(0,XRES)
         MINY = RANDOM(0,YRES)
         MAXY = RANDOM(0,YRES)
         IF (MINX .GT. MAXX) CALL SWAP(MINX,MAXX)
         IF (MINY .GT. MAXY) CALL SWAP(MINY,MAXY)
         CALL FG_SETCOLOR(RANDOM(0,15))
         CALL FG_RECT(MINX,MAXX,MINY,MAXY)
10    CONTINUE

      CALL FG_SETMODE(OLD_MODE)
      CALL FG_RESET

      STOP ' '
      END

      INTEGER*2 FUNCTION RANDOM(MIN,MAX)

      INTEGER*2 MIN, MAX
      INTEGER*2 SEED, TEMP

      DATA SEED /12345/

      TEMP = IEOR(SEED,ISHFT(SEED,-7))
      SEED = IAND(IEOR(ISHFT(TEMP,8),TEMP),#7FFF)
      RANDOM = MOD(SEED,MAX-MIN+1) + MIN

      RETURN
      END

      SUBROUTINE SWAP(VAR1,VAR2)
      INTEGER*2 VAR1, VAR2
      INTEGER*2 TEMP

      TEMP = VAR1
      VAR1 = VAR2
      VAR2 = TEMP

      RETURN
      END
