
/*

	Char class definition for GCOOPE Version 1.0

		  7/13/94 by Brian Lee Price

	Released as Public Domain   July, 1994.

	This is a flag class.  (Uses the object handle for instance
	variable storage).

	Compatible with strong typing option.

*/

#define CLASS Char

#include "gcoope10.h"

#include <stdio.h>

object CLASS;

extern object String;
extern object ShortInt;
extern object LongInt;
extern object Unsigned;

USEGEN(changeVal);
USEGEN(valueOf);
USEGEN(asString);
USEGEN(asHexStr);
USEGEN(asShortInt);
USEGEN(asLongInt);
USEGEN(asUnsigned);
USEGEN(asChar);

cmethod object m4New(object instance, char initVal)
{
if(((objHndl *) &instance)->fext)
    {
    char * ivptr;
    if(NULL==(ivptr=getIVptr(instance))) return 0;
    *ivptr=initVal;
    }
else
    {
    ((objHndl *) &instance)->fext=(tag)instance | ~SIGNMASK;
    (tag) instance=0;
    (char) instance=initVal;
    }
return instance;
}


imethod object m4changeVal(object instance, char newVal)
{
if(instance>=0)
    {
    char * ivptr;
    if(NULL==(ivptr=getIVptr(instance))) return FUNCFAIL;
    *ivptr=newVal;
    }
else (char) instance=newVal;
return FUNCOKAY;
}


imethod char m4valueOf(object instance)
{
if(instance>=0)
    {
    char * ivptr;
    ivptr=getIVptr(instance);
    return *ivptr;
    }
else return (char) instance;
}


imethod object m4asString(object instance)
{
char strBuf[16];
char a;

if(instance>=0) a=*((char *) getIVptr(instance));
else a=(char) instance;
sprintf(strBuf,"%d",(int) a);
return g(New)(String,strBuf);
}


imethod object m4asHexStr(object instance)
{
char strBuf[16];
char a;

if(instance>=0) a=*((char *) getIVptr(instance));
else a=(char) instance;
sprintf(strBuf, "%x", (unsigned) a);
return g(New)(String,strBuf);
}


imethod object m4asShortInt(object instance)
{
char a;

if(instance>=0) a=*((char *) getIVptr(instance));
else a=(char) instance;
return g(New)(ShortInt,(short) a);
}


imethod object m4asLongInt(object instance)
{
char a;

if(instance>=0) a=*((char *) getIVptr(instance));
else a=(char) instance;
return g(New)(LongInt,(long) a);
}


imethod object m4asUnsigned(object instance)
{
char a;

if(instance>=0) a=*((char *) getIVptr(instance));
else a=(char) instance;
return g(New)(Unsigned,(unsigned short) a);
}


CLASS_INSTALL
{
stat x=FUNCFAIL;

if(END==(CLASS=g(New)(Class, 0, sizeof(char), END)))
    goto end;
if(addGMthd(CLASS, New, (method) m4New)) goto end;
if(addGMthd(CLASS, GEN(changeVal), (method) m4changeVal)) goto end;
if(addGMthd(CLASS, GEN(valueOf), (method) m4valueOf)) goto end;
if(addGMthd(CLASS, GEN(asString), (method) m4asString)) goto end;
if(addGMthd(CLASS, GEN(asHexStr), (method) m4asHexStr)) goto end;
if(addGMthd(CLASS, GEN(asShortInt), (method) m4asShortInt)) goto end;
if(addGMthd(CLASS, GEN(asLongInt), (method) m4asLongInt)) goto end;
if(addGMthd(CLASS, GEN(asUnsigned), (method) m4asUnsigned)) goto end;
if(addGMthd(CLASS, GEN(asChar), bounceBack)) goto end;
x=FUNCOKAY;

end:
return x;
}
