
/*

	 Internal header file for GCOOPE version 1.0

		   by Brian Lee Price

	   Released as Public Domain  July, 1994.

*/


/* typedef object as long give error if long smaller than void * */

#if sizeof(long)>=sizeof(void *)
  typedef long object;
#else
  #error UNSUPPORTED MEMORY MODEL
#endif


/*
     typedef tag as int unless 2*sizeof(int) > sizeof long
     otherwise typedef tag as short unless 2 shorts are larger than
     a long then give error
*/

#if sizeof(long)>=(2*sizeof(int))
  typedef int tag;
#elif sizeof(long)>=(2*sizeof(short))
  typedef short tag;
#else
  #error UNSUPPORTED OBJECT SIZE
#endif

#if sizeof(tag)==1
  #define SIGNMASK 0x7F
#elif sizeof(tag)==2
  #define SIGNMASK 0x7FFF
#elif sizeof(tag)==4
  #define SIGNMASK 0x7FFFFFFFL
#else
  #error UNSUPPORTED TAG SIZE
#endif

#ifndef NULL
  #define NULL ((void *) 0L)
#endif

#define MAX_CHAR 0x7F
#define MAX_USHORT 0xFFFF
#define MAX_GEN 0x7FFF

/*   common type definitions   */

typedef unsigned char byte;
typedef unsigned short int word;
typedef unsigned long int dword;

typedef tag generic;
typedef object (*method)(object,...);
typedef method (*dispatch)(generic,...);


/* objTag definition for object handle structure */

typedef struct {
	tag	tag;
	tag	fext;
	} objHndl;


/* process status definitions */

typedef enum {FUNCOKAY, FUNCFAIL} stat;

/* boolean definition */

typedef enum {FALSE, TRUE} boolean;


/* global variable declarations */

#ifndef __GARBAGE__
  extern byte curProcID;
#else
  byte curProcID;
#endif

#ifndef FIRST_GCOOPE_ERROR
  #define FIRST_GCOOPE_ERROR 1
#endif

typedef enum { ERR_OUT_OF_MEM=FIRST_GCOOPE_ERROR, ERR_BAD_HANDLE,
		ERR_BAD_CLASS, LAST_GCOOPE_ERROR } gcErrTypes;


#ifdef __OBJECT_DEFINITION__

  char *	gcerrmsg[]={	"Out of memory",
				"Bad object handle",
				"Bad class reference",
				"Undefined error type" };
  object 	Object;

  generic      	New;
  generic	Kill;
  generic	Err;
  generic	GFclassOf;                /* these symbols prefaced with */
  generic	GFivSize; 		  /* GF for compatibility with   */
  generic	GFrespondsTo;             /* the experimental strong     */
  generic	GFdeepCopy;               /* typing option.		 */
  generic	GFshallowCopy;

#else

  extern char * 	gcerrmsg[];
  extern object         Object;
  extern generic	New;
  extern generic	Kill;
  extern generic	Err;
  extern generic	GFclassOf;
  extern generic	GFivSize;
  extern generic	GFrespondsTo;
  extern generic	GFdeepCopy;
  extern generic	GFshallowCopy;

#endif

#ifdef __CLASS_DEFINITION__
  object Class;
#else
  extern object Class;
#endif

#define END ((object) 0L)
#define MIN_METHOD_ADD (8)

/* prototypes of public kernel functions */

stat		addGMthd(object, generic, method);
generic 	addGeneric( method defMthd);
stat		cpyGMas(object, generic, object, generic);
void * 		getCVptr(object);
void * 		getIVptr(object);
stat		inhMthd(object, object);
int		tagCmg(const void *, const void *);
void *		makeInst(object *);
stat		makePerm(object);
method		g(generic,...);
stat		rmvGMthd(object, generic);
int		rmvGeneric(generic GenFunc);
object  	steer(object, object);
void *		s_calloc(unsigned, unsigned);
void 		s_free(void *);
void *		s_malloc(unsigned);
void * 		s_realloc(void *, unsigned);
object		bounceBack(object,...);

/* prototype for the pseudo-class Object installation routine */
stat		Object_Install(void);

stat		Class_Install(void);

#ifndef _EXTERNAL_

  #define DYNLIST_STRU word elemSize,firstFree,maxElems;void * listPtr

  #define MAX_BLOCK_SIZE (65523L)

  typedef struct {
	DYNLIST_STRU;
	} dynList;

  #define MIN_LIST_ADD 16


  /* the following functions are defined in listmgr.c */

  int 		addItem(void *listAdr, int elemSize);
  int 		rmvItem(void *listAdr, int elemNdx);
  stat 		compactList(void *listAdr, boolean sorted);


  #ifdef __OBJECTS__
  dynList objList={0,0,0,(void *) 0L};
  #else
  extern dynList objList;
  #endif


  typedef struct {
	void *		objDef;
	byte		procID,
			lastAcc;
	} objectEntry;

  #define PERM_PROC_ID 255
  #define INIT_AGE 255
  #define BAD_OBJ 0x7FFF

  /* the following functions are defined in objlist.c */

  objectEntry * 	getObject(tag objTag);
  void * 		getObjDef(tag objTag);
  int			addObject(void * objDef, byte procID);
  int			rmvObject(tag objTag);


  #ifdef __GENERICS__
  dynList genTable;
  #else
  extern dynList genTable;
  #endif


  typedef struct {
	tag			class;
	tag			owner;
	method			instMethod;
	} genMethod;


  typedef struct {
	DYNLIST_STRU;
	method			defMthd;
	} genEntry;


  /* the following functions are defined in genlist.c */

  int		tagCmg(const void *, const void *);
  genMethod *	getMthd(generic genFunc, tag clsTag);
  stat		addMethod(generic genFunc, method addMthd,
			  tag clsTag, tag owner);
  stat		rmvMethod(generic genFunc, tag clsTag);

  /* the following functions are defined in garbage.c */

  void * 		s_calloc(unsigned nitems, unsigned size);
  void   		s_free(void * block);
  void * 		s_malloc(unsigned size);
  void * 		s_realloc(void * block, unsigned newSize);
  void			outOfElems(void);

  stat			makePerm(object instance);


  #define MINDCRVAL 1
  #define MAXDCRVAL 25
  #define MAXSHIFTVAL 9
  #define MINSHIFTVAL 4
  #define TIMVAL 1000
  #define MAX_ERR_TRY 256


  typedef struct {
    tag		class;
    int		cvSize,
		ivSize,
		totSize,
		numSuper,
		numMthds;
    void *	loadAdr;
    char	cVars[1];
    } classEntry;

  typedef struct {
    tag		class,
		offset;
    } superEntry;



  /* the following functions are defined in funcdisp.c */

  method 		g(generic,...);
  object 		steer(object class, object instance);
  void *		getIVptr(object instance);
  void *		getCVptr(object class);
  void *		makeInst(object * instPtr);



  typedef struct {
	generic		genTag;
	method		clsMthd;
	} methodEntry;


  /* prototype for the pseudo-class Class routines */

  stat		Class_Install(void);
  stat		inhMthd(object class, object super);
  stat		addGMthd(object class, generic genFunc, method addMethod);
  stat		rmvGMthd(object class, generic genFunc);
  stat		cpyGMas(object newClass, generic newGenFunc,
				object oldClass, generic oldGenFunc);

#endif

