
#include "gnuc.h"
#include "config.h"



extern "C" void FAR PASCAL _export GCI_Configure(void)
{
    GC_Configure	*dlg;
    
    dlg = new GC_Configure();
    dlg->DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// Library init

class GCIndentDLL : public CWinApp
{
public:
	virtual BOOL InitInstance(); // Initialization
	virtual int ExitInstance();  // Termination (WEP-like code)
	virtual int WriteParams();	// Store params in .INI file

	// nothing special for the constructor
	GCIndentDLL(const char* pszAppName)
		: CWinApp(pszAppName)
		{ }
};

BOOL GCIndentDLL::InitInstance()
{
	// any DLL initialization goes here
	TRACE("TRACER.DLL initializing\n");
	SetDialogBkColor();     // grey dialogs in the DLL as well 
	
	// Load the default values for the indentation params //
	////////////////////////////////////////////////////////

	c_line_comment_align = GetProfileInt("GNUC_INDENTER", "LineCommentAlign", 1);
	c_tab_always_indent = GetProfileInt("GNUC_INDENTER", "TabAlwaysIndent", 0);
	c_indent_level = GetProfileInt("GNUC_INDENTER", "IndentLevel", 4);
	c_brace_imaginary_offset = GetProfileInt("GNUC_INDENTER", "BraceImaginaryOffset", 0);
	c_brace_offset = GetProfileInt("GNUC_INDENTER", "BraceOffset", 4);
	c_argdecl_indent = GetProfileInt("GNUC_INDENTER", "ArgdeclIndent", 4);
	c_label_offset = GetProfileInt("GNUC_INDENTER", "LabelOffset", -2);
	c_case_offset = GetProfileInt("GNUC_INDENTER", "CaseOffset", -4);
	c_continued_statement_offset = GetProfileInt("GNUC_INDENTER", "ContinuedStatementOffset", 4);
	tab_size = GetProfileInt("GNUC_INDENTER", "TabSize", 8);
	
	WriteParams();
	return TRUE;
}

int GCIndentDLL::ExitInstance()
{
	// any DLL termination goes here (WEP-like code)
	//WriteParams();
	return CWinApp::ExitInstance();
}

int GCIndentDLL::WriteParams()
{
	WriteProfileInt("GNUC_INDENTER", "LineCommentAlign", c_line_comment_align);
	WriteProfileInt("GNUC_INDENTER", "TabAlwaysIndent", c_tab_always_indent);
	WriteProfileInt("GNUC_INDENTER", "IndentLevel", c_indent_level);
	WriteProfileInt("GNUC_INDENTER", "BraceImaginaryOffset", c_brace_imaginary_offset);
	WriteProfileInt("GNUC_INDENTER", "BraceOffset", c_brace_offset);
	WriteProfileInt("GNUC_INDENTER", "ArgdeclIndent", c_argdecl_indent);
	WriteProfileInt("GNUC_INDENTER", "LabelOffset", c_label_offset);
	WriteProfileInt("GNUC_INDENTER", "CaseOffset", c_case_offset);
	WriteProfileInt("GNUC_INDENTER", "ContinuedStatementOffset", c_continued_statement_offset);
	WriteProfileInt("GNUC_INDENTER", "TabSize", tab_size);
       return 1;
}

GCIndentDLL  NEAR indentDLL("gnuc.dll");


/////////////////////////////////////////////////////////////////////////////
// GC_Configure dialog


GC_Configure::GC_Configure(CWnd* pParent /*=NULL*/)
	: CDialog(GC_Configure::IDD, pParent)
{
	//{{AFX_DATA_INIT(GC_Configure)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

void GC_Configure::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(GC_Configure)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(GC_Configure, CDialog)
	//{{AFX_MSG_MAP(GC_Configure)
	ON_EN_KILLFOCUS(IDC_ARGDECL_INDENT, OnKillfocusArgdeclIndent)
	ON_EN_KILLFOCUS(IDC_BRACE_OFFSET, OnKillfocusBraceOffset)
	ON_EN_KILLFOCUS(IDC_CASE_OFFSET, OnKillfocusCaseOffset)
	ON_EN_KILLFOCUS(IDC_CONTINUED_OFFSET, OnKillfocusContinuedOffset)
	ON_EN_KILLFOCUS(IDC_IMAGINARY_OFFSET, OnKillfocusImaginaryOffset)
	ON_EN_KILLFOCUS(IDC_INDENT_LEVEL, OnKillfocusIndentLevel)
	ON_EN_KILLFOCUS(IDC_LABEL_OFFSET, OnKillfocusLabelOffset)
	ON_BN_CLICKED(IDC_LINE_COMMENT_ALIGN, OnLineCommentAlign)
	ON_BN_CLICKED(IDC_TAB_ALWAYS_INDENT, OnTabAlwaysIndent)
	ON_EN_KILLFOCUS(IDC_TAB_SIZE, OnKillfocusTabSize)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// GC_Configure message handlers

void GC_Configure::OnOK()
{
    c_line_comment_align = new_line_comment_align;
    c_tab_always_indent = new_tab_always_indent;
    c_indent_level = new_indent_level;
    c_brace_imaginary_offset = new_brace_imaginary_offset;
    c_brace_offset = new_brace_offset;
    c_argdecl_indent = new_argdecl_indent;
    c_label_offset = new_label_offset;
    c_case_offset = new_case_offset;
    c_continued_statement_offset = new_continued_statement_offset;
    tab_size = new_tab_size;

    indentDLL.WriteParams();
    CDialog::OnOK();
}


BOOL GC_Configure::OnInitDialog()
{
    char	buff[20];
    
    CDialog::OnInitDialog();
    
    new_line_comment_align = c_line_comment_align;
    new_tab_always_indent = c_tab_always_indent;
    new_indent_level = c_indent_level;
    new_brace_imaginary_offset = c_brace_imaginary_offset;
    new_brace_offset = c_brace_offset;
    new_argdecl_indent = c_argdecl_indent;
    new_label_offset = c_label_offset;
    new_case_offset = c_case_offset;
    new_continued_statement_offset = c_continued_statement_offset;
    new_tab_size = tab_size;

    CheckDlgButton(IDC_LINE_COMMENT_ALIGN, c_line_comment_align);
    CheckDlgButton(IDC_TAB_ALWAYS_INDENT, c_tab_always_indent);
    
    wsprintf(buff, "%d", c_indent_level);
    SetDlgItemText(IDC_INDENT_LEVEL, buff);

    wsprintf(buff, "%d", c_brace_imaginary_offset);
    SetDlgItemText(IDC_IMAGINARY_OFFSET, buff);

    wsprintf(buff, "%d", c_argdecl_indent);
    SetDlgItemText(IDC_ARGDECL_INDENT, buff);

    wsprintf(buff, "%d", c_label_offset);
    SetDlgItemText(IDC_LABEL_OFFSET, buff);

    wsprintf(buff, "%d",c_case_offset);
    SetDlgItemText(IDC_CASE_OFFSET, buff);

    wsprintf(buff, "%d", c_continued_statement_offset);
    SetDlgItemText(IDC_CONTINUED_OFFSET, buff);

    wsprintf(buff, "%d", c_brace_offset);
    SetDlgItemText(IDC_BRACE_OFFSET, buff);
    
    wsprintf(buff, "%d", tab_size);
    SetDlgItemText(IDC_TAB_SIZE, buff);
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}

void GC_Configure::ValidateNumber(int	ctlId,
				  int	&dest)
{
    BOOL	success;
    int		newval;
    
    newval =  GetDlgItemInt(ctlId, &success, TRUE);
    if(success)
	dest = newval;
    else
	{
	CEdit	*edit = (CEdit *)GetDlgItem(ctlId);
	if(NULL != edit)
	    {
	    edit->SetFocus();
	    edit->SetSel(0, 1000);
	    }
	::MessageBeep(MB_ICONQUESTION);
	}
}

void GC_Configure::OnKillfocusArgdeclIndent()
{
    ValidateNumber(IDC_ARGDECL_INDENT, new_argdecl_indent);
}

void GC_Configure::OnKillfocusBraceOffset()
{
    ValidateNumber(IDC_BRACE_OFFSET, new_brace_offset);
}

void GC_Configure::OnKillfocusCaseOffset()
{
    ValidateNumber(IDC_CASE_OFFSET, new_case_offset);
	
}

void GC_Configure::OnKillfocusContinuedOffset()
{
    ValidateNumber(IDC_CONTINUED_OFFSET, new_continued_statement_offset);
}

void GC_Configure::OnKillfocusImaginaryOffset()
{
    ValidateNumber(IDC_IMAGINARY_OFFSET, new_brace_imaginary_offset);
}

void GC_Configure::OnKillfocusIndentLevel()
{
    ValidateNumber(IDC_INDENT_LEVEL, new_indent_level);
}

void GC_Configure::OnKillfocusLabelOffset()
{
    ValidateNumber(IDC_LABEL_OFFSET, new_label_offset);
}

void GC_Configure::OnKillfocusTabSize()
{
    ValidateNumber(IDC_TAB_SIZE, new_tab_size);
}

void GC_Configure::OnLineCommentAlign()
{
    CButton	*but = (CButton *)GetDlgItem(IDC_LINE_COMMENT_ALIGN);
    if(NULL != but)
	new_line_comment_align = but->GetCheck();
}

void GC_Configure::OnTabAlwaysIndent()
{
    CButton	*but = (CButton *)GetDlgItem(IDC_TAB_ALWAYS_INDENT);
    if(NULL != but)
	new_tab_always_indent = but->GetCheck();
}

