/*


    DLLink (doubly linked link) object class for PCOOPE2

	  Copyright (C) 1994, Brian Lee Price

	  released as PUBLIC DOMAIN 4/25/94


*/



#define CLASS DLLink

#include "pcoope2.h"

object CLASS;


instVars {
	object  flink;
	object  blink;
	 };


cFunc object New(object instance,object flink, object blink);
cFunc object Kill(object instance);

iFunc object Set(object instance,object flink, object blink);
iFunc object Acc(object instance,object * flinkPtr, object * blinkPtr);

INSTANCEPOLY(pSet);
INSTANCEPOLY(pAcc);


ClassInstallFunc
{
pNew(Base,0,sizeof(instVars),&CLASS,NULL);

MAKE_C_POLY(New);

MAKE_D_POLY(Kill);

MAKE_I_POLY(Set);
MAKE_I_POLY(Acc);

EndClassInstall;
}


cFunc object New(object instance, object flink, object blink)
{
DECLAREivPtr;
BEGIN_NEW;

MakeInstance;
ivPtr->flink=(flink==NULL)?instance:flink;
ivPtr->blink=(blink==NULL)?instance:blink;

END_NEW;
}


cFunc object Kill(object instance)
{
return pKill(Base,instance);
}


iFunc object Set(object instance, object flink, object blink)
{
GETIVPTR;
ivPtr->flink=flink;
ivPtr->blink=blink;

return instance;
}


iFunc object Acc(object instance, object *flink, object *blink)
{
GETIVPTR;

if(flink==NULL || blink==NULL) return NULL;
*flink=ivPtr->flink;
*blink=ivPtr->blink;
return instance;
}

