
/***************************************************************************
*                                                                          *
*		source code for pcoope2 -                                  *
*                                                                          *
*   polymorphing c-language object oriented programming extension ver 2.1  *
*                                                                          *
*	Copyright (C) Brian Lee Price, 1994.                               *
*                                                                          *
*	  released as PUBLIC DOMAIN 4/25/94                                *    *
*                                                                          *
*	ANSI-C CODE WITH 8 CHARACTER IDENTIFIER COMPATIBLE                 *
*                                                                          *
***************************************************************************/

#define _INTERNAL_

#include "pcoope2.h"

#include <stdlib.h>
#include <stdio.h>
#include <alloc.h>


/* adds an base class instance */
static void	addInst(object instance);

/* exits with a memory error message */
static void 	ExitMem(void);

/* frees up object memory */
static void 	instFree(object instance);

/* takes out the trash */
static void	garbage(void);


/* garbage collection variables */

static instType **  end=NULL;
static instType **  start=NULL;
static instType **  head=NULL;
static instType **  tail=NULL;
static int          numInst=0;
static int	    ErrMem=0;
static int	    Killed=0;

/* alias inheritance database variables */

static classAli *aliRoot;
static int	 numClass;

/* quick and dirty object instance verifyation and age update macro */
/* this version calls memErr direct */

#undef VALIDATE
#define VALIDATE(obj)\
if(((((instType *) obj)->verify)^(~((unsigned int) obj))))\
{pErrNum=pErrBADINSTANCE;memErr();}\
else {if( ((instType *)obj)->lastAcc<INITAGE)\
((instType *) obj)->lastAcc=INITAGE;}


/* this routine compares two vars of type object */

int objCmp(const void * elem1, const void * elem2)
{
return (*((cast *) elem1) > *((cast *) elem2))? 1:
		 (*((cast *) elem1) < *((cast *) elem2))? -1: 0;
}


static void ExitMem(void)
{
fputs(pErrText[pErrOUTOFMEM],stderr);
abort();
}



/* this is the dummy / null routine used to exclude ancestor morphs */

object polyNull(object instance,...)
{
return instance;
}



/* this is the basic polymorph lookup routine--used for instance funcs */
/* note: this function also passes the corrected instance var */

pType pLookUp(pRcdType * pRoot, int NAlias,...)
{
register int    step;
register int	index;
object		class;
object *	instance;
va_list		ap;

va_start(ap,NAlias);
instance=ap;
VALIDATE((*instance));

index=step=(NAlias)>>1;
class=((instType *)(*instance))->class;
while(index>=0 &&index<NAlias)
	{
	step>>=1;
	step=(step>0)?step:1;
	if((cast)(pRoot[index].class)>(cast)class) index-=step;
	else if((cast)(pRoot[index].class)<(cast)class) index+=step;
	else goto EQual;
	}
va_end(ap);
pErrNum=pErrBADALIAS;
return pErr;
		  /* now find the correct instance to pass */
EQual:
if(class!=pRoot[index].owner)
   {
   object *parC=(object *)((byte *)((instType *)(*instance))->class
							+sizeof(clsType));
   object *parI=(object *)((byte *)(*instance)+sizeof(instType));
   register int numP=((clsType *)((instType *)(*instance))->class)->numPar;
   register int NP=--numP;
   for(;numP>=0 && parC[numP]!=pRoot[index].owner;numP--);
   if(numP>=0) *instance=parI[numP];
   else
      {
      object locInst=NULL;
      for(;NP>=0 && NULL==(locInst=rcsAinst(pRoot[index].owner,
						parI[NP]));NP--);
      if(NP<0)
	 {
	 pErrNum=pErrFATALDATA;
	 pErr(*instance);
	 }
      else *instance=locInst;
      }
   }
va_end(ap);
return pRoot[index].pRtn;
}



/* this is the std polymorph lookup routine for class funcs */

pType CpLookUp(pRcdType * pRoot,int NAlias,pType baseRtn,...)
{
register int    step;
register int	index;
object 		class;
va_list		ap;

va_start(ap,baseRtn);
class=va_arg(ap,object);
va_end(ap);
if(class==Base) return baseRtn;
index=step=(NAlias)>>1;
while(index>=0 && index<NAlias)
   {
   step>>=1;
   step=(step>0)?step:1;
   if((cast)pRoot[index].class>(cast)class) index-=step;
   else if((cast)pRoot[index].class<(cast)class) index+=step;
   else return pRoot[index].pRtn;
   }
pErrNum=pErrBADCLASS;
return pErr;
}


/* this poly lookup routine allows the specification of a dfltRtn */
/* used for pKill and pErr */

pType DpLookUp(pRcdType * pRoot, int NAlias, pType dfltRtn,...)
{
register int	step;
register int	index;
object		class;
va_list		ap;

va_start(ap,NAlias);
class=va_arg(ap,object);
va_end(ap);
if(class==Base) return dfltRtn;

VALIDATE(class);

index=step=(NAlias)>>1;
class=((instType *) class)->class;

while(index>=0 && index<NAlias)
   {
   step>>=1;
   step=(step>0)?step:1;
   if((cast)pRoot[index].class>(cast)class) index-=step;
   else if((cast)pRoot[index].class<(cast)class) index+=step;
   else return pRoot[index].pRtn;
   step>>=1;
   }
return dfltRtn;
}


/* this routine gets the direct address and correct instance for */
/* repeated calls to the same polymorph */

pType getMorph(pRcdType * pRoot, int NAlias,object * instance)
{
register int	step;
register int	index;
object		class;

VALIDATE((*instance));

		/* find the morph */

index=step=(NAlias)>>1;
class=((instType *)(*instance))->class;
while(index>=0 &&index<NAlias)
   {
   step>>=1;
   step=(step>0)?step:1;
   if((cast)(pRoot[index].class)>(cast)class) index-=step;
   else if((cast)(pRoot[index].class)<(cast)class) index+=step;
   else goto EQual;
   }
return NULL;
	  /* now find the correct instance to pass */
EQual:
if(class!=pRoot[index].owner)
   {
   object *parC=(object *)((byte *)((instType *)(*instance))->class
							+sizeof(clsType));
   object *parI=(object *)((byte *)(*instance)+sizeof(instType));
   register int numP=((clsType *)((instType *)(*instance))->class)->numPar;
   register int NP=--numP;
   for(;numP>=0 && parC[numP]!=pRoot[index].owner;numP--);
   if(numP>=0) *instance=parI[numP];
   else
      {
      object locInst=NULL;
      for(;NP>=0 && NULL==(locInst=rcsAinst(pRoot[index].owner,
							parI[NP]));NP--);
      if(NP<0)
	 {
	 return NULL;
	 }
      else *instance=locInst;
      }
   }
return pRoot[index].pRtn;
}



/* this adds a polymorph to an existing poly function */

void addPFunc(object class,object *pRoot,int *NAlias,pType newMorph)
{
classAli *aliClass;
aliasLst *aliLstP;

addPRcd(class,class,pRoot,NAlias,newMorph); /* add newMorph to poly rtn */

/* install new class in aliRoot ? */

if(NULL==aliRoot) /* create new list */
   {
   numClass=1;
   if(NULL==(aliRoot=(classAli *)malloc(sizeof(classAli))))
      {
      ExitMem();
      }
   aliClass=aliRoot;
   aliClass->class=class;
   aliClass->aliases=NULL;
   }
else   /* check for class in aliRoot */
   {
   while(NULL==(aliClass=(classAli *) bsearch(&class,aliRoot,numClass,
					      sizeof(classAli), objCmp)))
      {
      if(NULL==(aliRoot=(classAli *)realloc(aliRoot,
					(numClass+1)*sizeof(classAli))))
	 {
	 ExitMem();
	 }
      aliRoot[numClass].class=class;
      aliRoot[numClass++].aliases=NULL;
      qsort(aliRoot,numClass,sizeof(classAli),objCmp);
      }
   }
if(aliClass->aliases==NULL)
   {
   aliClass->numAlias=0;
   if(NULL==(aliClass->aliases=(aliasLst *)malloc(sizeof(aliasLst))))
      {
      ExitMem();
      }
   }
else if(NULL==(aliClass->aliases=(aliasLst *) realloc(aliClass->aliases,
				(aliClass->numAlias+1)*sizeof(aliasLst))))
   {
   ExitMem();
   }
aliClass->aliases[aliClass->numAlias].pRoot=pRoot;
aliClass->aliases[aliClass->numAlias].pNAlias=NAlias;
aliClass->aliases[aliClass->numAlias++].pRtn=newMorph;
}


/* adds a new morph to a polymorph function dataBase */

void addPRcd(object class, object owner, object *pRoot,
												int *NAlias, pType newMorph)
{
object temp;

if(!*NAlias)   /* list doesn't exist, create it */
   {
   if(NULL==(*pRoot=malloc(sizeof(pRcdType))))
      {
      ExitMem();
      }
   ((pRcdType *) (*pRoot))->class=class;       /* add new class */
   ((pRcdType *) (*pRoot))->owner=owner;       /* add owning class */
   ((pRcdType *) (*pRoot))->pRtn=newMorph;     /* add new rtn */
   (*NAlias)++;
   }
else     /* list exists, check for previous inclusion */
   {
   if(NULL==bsearch(&class,*pRoot,*NAlias,sizeof(pRcdType),objCmp))
      {
      if(NULL==(temp=realloc(*pRoot,(*NAlias + 1)*sizeof(pRcdType))))
	 {
	 ExitMem();
	 }
      *pRoot=temp;
      (((pRcdType *) (*pRoot))+*NAlias)->class=class;    /* add new class */
      (((pRcdType *) (*pRoot))+*NAlias)->owner=owner;    /* add owner */
      (((pRcdType *) (*pRoot))+*NAlias)->pRtn=newMorph;  /* add new rtn */
      (*NAlias)++;
      qsort(*pRoot,*NAlias,sizeof(pRcdType),objCmp);
      }
   }
}



/* class creation routine called when class==Base */

object newClass(object class,...)
{
va_list ap;
dSizeT 	ivSize,
	cvSize;
object	*parents;
clsType **classPtr;
int 	numParents;
int	x;

va_start(ap,class);
cvSize=va_arg(ap,dSizeT);        /* get class var size */
ivSize=va_arg(ap,dSizeT);			/* get instance var size */
classPtr=va_arg(ap,clsType **);    /* get ptr to new class */

	/* count number of parent classes */
numParents=0;
while(NULL!=va_arg(ap,object)) {numParents++;}

	/* allocate the object class record */
*classPtr=(clsType *) calloc(1,sizeof(clsType)+cvSize
				+sizeof(object)*numParents);
if(NULL==*classPtr)
   {
   ExitMem();
   }
va_end(ap);

(*classPtr)->ivSize=ivSize;    	/* store ivSize */
(*classPtr)->numPar=numParents;  /* store number of parents */

va_start(ap,class);
cvSize=va_arg(ap,dSizeT);
cvSize=va_arg(ap,dSizeT);
parents=va_arg(ap,object);

(byte *) parents=(byte *) (*classPtr) + sizeof(clsType);


	/* store the parent list */
for(x=0;x<numParents;x++)
   {
   parents[x]=va_arg(ap,object);
   }
va_end(ap);

return class;
}


/* the following routine is called at the end of a class's */
/* initialization routine "Class_InstallFunc".  It adds all the */
/* parent's alias routines to its own class.  It is called via */
/* the MACRO: EndClassInstall */

void rcsAlias(object parent, object class)
{
object 	 *curPar;
aliasLst *curAli;
classAli *curCls;
int	  x,y;


(byte *)curPar=(byte *) parent + sizeof(clsType);
for(x=0;x<((clsType *) parent)->numPar;x++)
   {
   curCls=(classAli *) bsearch(&(curPar[x]),aliRoot,numClass,
					sizeof(classAli),objCmp);
   curAli=curCls->aliases;
   for(y=0;y<curCls->numAlias;y++)
      {
      addPRcd(class,curPar[x],curAli[y].pRoot,
			curAli[y].pNAlias,curAli[y].pRtn);
      }
   rcsAlias(curPar[x],class);    /* recurse all ancestors */
   }
}



/* this routine frees up memory no longer needed */
/* in a future dynamic linking version, this routine will be */
/* radically altered */

void rmvAlias(void)
{
classAli *curCls;
int x;

curCls=aliRoot;
for(x=0;x<numClass;x++)
   {
   free(curCls[x].aliases);
   }
free(aliRoot);
}



/* this routine is called via the MACRO: MakeInstanceAndPtr in the */
/* constructor of an object, it checks for family status */

object makeInst(object className, object * newInst)
{
instType *	instPtr;
object	  	ivPtr;
object *  	parentI;
object *	parentC;
clsType *	cPtr;
int		x;

garbage();

cPtr=(clsType *) className;

/*  allocate the instance memory */
while(NULL==((instPtr)=calloc(1,sizeof(instType) + cPtr->ivSize
				+ cPtr->numPar*sizeof(object))))
   {
   pErrNum=pErrOUTOFMEM;
   memErr();
   }

instPtr->class=className;  /* store the class ptr */
instPtr->child=curInst;
instPtr->verify=~((unsigned int) instPtr);
instPtr->lastAcc=MAXINT-1;
*newInst=(object)instPtr;

/* add the new instance to the instance tracking database */
if(curChild==NULL) addInst(*newInst);
else
   {
   cPtr=(clsType *) curChild;
   (byte *) parentC=(byte *) curChild + sizeof(clsType);
   (byte *) parentI=(byte *) curInst + sizeof(instType);
   for(x=0;x<cPtr->numPar;x++)
      {
      if(parentC[x]==className) break;
      }
   if(x>=cPtr->numPar)
      {
      instPtr->child=NULL;
      addInst(*newInst);
      }
   else
      {
      parentI[x]=*newInst;
      }
   cPtr=(clsType *) className;
   }
curInst=*newInst;
return ((byte *) instPtr + sizeof(instType) + cPtr->numPar*sizeof(object));
}



/* recurse ancestor instance - ugly */

object rcsAinst(object aClass, object instance)
{
object * parC = (object *) ((byte *)((instType *)instance)->class
						  + sizeof(clsType));
object * parI = (object *) ((byte *) instance + sizeof(instType));
register int numP=((clsType *)((instType *)instance)->class)->numPar;
object aInst=NULL;

for(numP--;numP>=0 && aInst==NULL;numP--)
   {
   if(parC[numP]==aClass) aInst=parI[numP];
   else aInst=rcsAinst(aClass,parI[numP]);
   }
return aInst;
}



/* get ancestor instance */

object getAinst(object aClass, object instance)
{
if(((instType *)instance)->class!=aClass)
   {
   object * parC = (object *) ((byte *)((instType *)instance)->class
					  + sizeof(clsType));
   object * parI = (object *) ((byte *) instance + sizeof(instType));
   register int numP=((clsType *)((instType *)instance)->class)->numPar;
   register int NP=--numP;

   for(;numP>=0 && parC[numP]!=aClass;numP--);
   if(numP>=0) instance=parI[numP];
   else
      {
      object target=NULL;
      for(;NP>=0 && NULL==(target=rcsAinst(aClass,parI[NP]));NP--);
	 instance=target;
      }
   }
return instance;
}



/* get ancestor by NULL terminated path */

object getApath(object instance,...)
{
va_list ap;
object 	*parentC,
	*parentI;
clsType *class;
register int x;
register int numPar;

va_start(ap,instance);
while(NULL!=(class=va_arg(ap,clsType *)))
   {
   (byte *)parentI=(byte *)instance + sizeof(instType);
   (byte *)parentC=(byte *)((instType *) instance)->class + sizeof(clsType);
   numPar=((clsType *) ((instType *) instance)->class)->numPar;
   for(x=0;x<numPar;x++)
      {
      if(parentC[x]==class) break;
      }
   if(x>=numPar) return NULL;
   instance=parentI[x];
   }
va_end(ap);
return instance;
}




/* replace a part (or all) of the current object with newInst object */

object makePart(object instance, object newInst)
{
instType * replace;
instType * child;
object *   parent;
clsType *  class;
int	   x;

VALIDATE(instance);
VALIDATE(newInst);

replace=getAinst(((instType *)newInst)->class,instance);
if(replace==NULL) return instance;
child=((instType *) newInst)->child=replace->child;
if(child!=NULL)
   {
   class=child->class;
   parent=(object *)((byte *)child + sizeof(instType));
   for(x=0;x<class->numPar;x++)
      {
      if(parent[x]==replace) break;
      }
   if(parent[x]==replace)
      {
      parent[x]=newInst;
      makePerm(newInst);
      pKill(replace);
      }
   return instance;
   }
killInst(instance);
return newInst;
}



/* this is the default routine for pKill */
/* it can be explicity called via pKill(Base,instance) */

object killInst(object instance,...)
{
va_list ap;

if(instance==Base)  /* if explicitly called, the instance is 2nd parm */
   {
   va_start(ap,instance);
   instance=va_arg(ap,object);
   va_end(ap);
   }
VALIDATE(instance);

if(((instType *) instance)->lastAcc >INITAGE &&
   ((instType *) instance)->lastAcc != MAXINT)
      instFree(instance);
else
   {
   ((instType *) instance)->lastAcc=0;
   }
return Base;
}


/* remove an instance and call pKill for parents */

static void instFree(object instance)
{
va_list   ap;
clsType * class;
object *  parent;
int	  x;

class=((instType *) instance)->class;
(byte *) parent = (byte *) instance + sizeof(instType);
for(x=0;x<class->numPar;x++)
   {
   pKill(parent[x]);
   }
((instType *) instance)->verify=(unsigned int) instance;
free(instance);
}


/* default error handler uses garbage collector to free up memory */
/* if an OUTOFMEM error occurs */

object memErr(void)
{
int x;
unsigned long tryCnt;

if(pErrNum!=pErrOUTOFMEM)
   {
   fputs(pErrText[pErrNum],stderr);
   abort();
   }
Killed=0;
tryCnt=0;
while(!Killed)
   {
   ErrMem=1;
   garbage();
   if(tryCnt++>MAXERRTRYS)
      {
      ExitMem();
      }
   }
pErrNum=pErrOK;
return NULL;
}


/*

	the garbage man makes his rounds !


*/

/* initialize object instance verification and add to can */

static void addInst(object instance)
{
VALIDATE(instance);

/*	THE PKILL SPECIFIED EXCLUSION CLAUSE 		*/

if(NULL!=bsearch(&(((instType *)(instance))->class),pKillPR,
	pKillNA,sizeof(pRcdType),objCmp))
   {
   ((instType *) instance)->lastAcc=MAXINT-1;
   }
else
   {
   ((instType *) instance)->lastAcc=INITAGE;
   if(start==NULL)	/* need to initialize garbage can */
      {
      if(NULL==
	 (start=(instType **)malloc(sizeof(object)*(MAXNUMOBJECTS+2))))
	 {
	 ExitMem();
	 }
      head=tail=start;
      end=start+MAXNUMOBJECTS+1;
      numInst=0;
      }
   while(numInst==MAXNUMOBJECTS)
      {
      pErrNum=pErrOUTOFMEM;
      memErr();
      }
   *head=(instType *) instance;
   head=(head==end)?start:head+1;
   numInst++;
   }
}


/* keep garbage collector away from object */

void makePerm(object instance)
{
VALIDATE(instance);

if(NULL!=bsearch(&(((instType *)(instance))->class),pKillPR,
	pKillNA,sizeof(pRcdType),objCmp))
   {
   ((instType *) instance)->lastAcc=MAXINT-1;
   }
else ((instType *) instance)->lastAcc=MAXINT;
}


/* round-robin routine with adaptive features */

static void garbage(void)
{
static int	ageDcr=(int)MINDCRVAL;
static int	shftVal=MAXSHIFTVAL;
static long	timeVal=TIMVAL;
register int 	x;
register int	locDcr;
int		oldDcr;
int		oldShft;


if(start==NULL) return;
if(ErrMem)
   {         /* on mem err, save norm parms, goto max vals */
   oldDcr=ageDcr;
   ageDcr=(int)MAXDCRVAL;
   oldShft=shftVal;
   shftVal=MINSHIFTVAL;
   }
else if(--timeVal<=0)    /* otherwise check for timer time out */
   {
   timeVal=TIMVAL;
   ageDcr-=ageDcr>>2;    /* reduce DCR by 25% */
   if(ageDcr<MINDCRVAL)
      {		/* if DCR bottomed out, check less often */
      ageDcr=(int)(MINDCRVAL*3)/2;
      shftVal+=(shftVal<(MAXSHIFTVAL))?1:0;
      }
   }
x=((unsigned)numInst)>>shftVal;
x=(x<=0)?1:x;

for(locDcr=ageDcr;x>0 && tail!=head;x--)
   {
   if(!(((unsigned int)(*tail)->verify)^(~((unsigned int) *tail))))
	/* verify instance ? */
      {
      if(((*tail)->lastAcc-=locDcr)>0)  /* need to save ? */
	 {
	 if((*tail)->lastAcc<=INITAGE)
	    {
	    *head=*tail;
	    head=(head==end)?start:head+1;
	    }
	 else
	    {
	    numInst--;
	    }
	 }
      else                   /* need to kill ! */
	 {
	 instFree(*tail);
	 numInst--;
	 Killed=1;
	 }
      }
   else												/* bagged for disposal */
      {
      numInst--;
      }
   tail=(tail==end)?start:tail+1;
   }
if(ErrMem) 		/* if in memory error mode reset to normal parms */
   {
   if(Killed)
      {
      ageDcr=oldDcr+(oldDcr>>1);	/* increase norm DCR by 50% */
      shftVal=oldShft;
      if(ageDcr>MAXDCRVAL)
	 {                /* if DCR MAXED, check more often */
	 ageDcr=(int)MAXDCRVAL/2;
	 shftVal-=(shftVal>MINSHIFTVAL)?1:0;
	 }
      }
   else
      {
      ageDcr=oldDcr;
      shftVal=oldShft;
      }
   ErrMem=0;
   }
}



/* end of pcoope2 source code */
