/*

	Sema4  object class definition for PCOOPE2

	  Copyright (C) 1994, Brian Lee Price

	  released as PUBLIC DOMAIN 4/25/94

*/


#define CLASS Sema4

#include "pcoope2.h"
#include "MTask.h"

object CLASS;

extern object DLList;


instVars {
	int flag;
	 };

INSTANCEPOLY(pWait);
INSTANCEPOLY(pSignal);
INSTANCEPOLY(pQuery);

INCLUDEPOLY(pBlock);
INCLUDEPOLY(pAdd);
INCLUDEPOLY(pAcc);
INCLUDEPOLY(pRmv);
INCLUDEPOLY(pGetP);


cFunc object New(object instance,int initVal);
cFunc object Kill(object instance);

iFunc object Wait(object instance, object task);
iFunc object Signal(object instance, object task);
iFunc object Query(object instance);


ClassInstallFunc
{
pNew(Base,0,sizeof(instVars),&CLASS,DLList,NULL);

MAKE_C_POLY(New);

MAKE_D_POLY(Kill);

MAKE_I_POLY(Wait);
MAKE_I_POLY(Signal);
MAKE_I_POLY(Query);

EndClassInstall;
}


#define pBlock I_POLY(pBlock)
#define pAdd I_POLY(pAdd)
#define pRmv I_POLY(pRmv)
#define pAcc I_POLY(pAcc)
#define pGetP I_POLY(pGetP)

cFunc object New(object instance,int initVal)
{
DECLAREivPtr;
BEGIN_NEW;
MakeInstance;

pNew(DLList);
ivPtr->flag=initVal;

END_NEW;
}


iFunc object Wait(object instance, object task)
{
GETIVPTR;

if(ivPtr->flag ==  0)
    {
    pBlock(task);
    pAdd(instance,task);
    Schedule(task);
    }
else ivPtr->flag=(ivPtr->flag>0)?ivPtr->flag-1:0;
return task;
}


iFunc object Signal(object instance, object task)
{
object next;
GETIVPTR;

if(NULL!=(next=pRmv(instance)))
    {
    pBlock(next);
    pAdd(taskSys[(int)pGetP(next)],next);
    Schedule(task);
    }
else ivPtr->flag++;

return task;
}


iFunc object Query(object instance)
{
return (object) ((cast) IVPTR->flag);
}


cFunc object Kill(object instance)
{
object next;

while(NULL!=(next=pRmv(instance)))
    {
    pBlock(next);
    pAdd(taskSys[(int) pGetP(next)],next);
    }
pKill(Base,instance);
return instance;
}


