'RUCKDAC.BI 1.0

DECLARE FUNCTION RUCKDAC% (SEG packinfo AS ANY)

CONST SysInfoDac = 0, InitDac = 1, ExitDac = 2, AtExitDac = 3
CONST LoadDac = 4, PlayDac = 5, RecordDac = 6
CONST StoreDac = 7, EndDac = 8, PauseDac = 9
CONST DeallocDac = 10

CONST SetAllDac = 20, SetVolumeDac = 21, SetIntRateDac = 22, SetPriorityDac = 23
CONST GetBufferDataDac = 28, GetBytePosDac = 29

CONST SetAllSBP = 30, SetVolMainSBP = 31, SetVolVocSBP = 32
CONST SetLevelMicSBP = 33, SetLevelCDSBP = 34, SetLevelLineSBP = 35
CONST SetFilterOutSBP = 36, SetFilterInSBP = 37
CONST SetSourceSBP = 38, SetStereoSBP = 39

CONST SetSpeakerSB = 40
CONST GetMixerRegSBP = 48, GetDacSB = 49

CONST ExitMod = 50, AtExitMod = 51
CONST LoadMod = 52, PlayMod = 53
CONST EndMod = 54, PauseMod = 55
CONST SetIntRateMod = 56, SetSpeedMod = 57
CONST SetVolumeMod = 58, SetPositionMod = 59
CONST SetStereoMod = 60, SetFastMod = 61

TYPE DeallocPackTYPE            'DP
 Func       AS INTEGER
 stat       AS INTEGER
 HandSeg    AS INTEGER          'RUCKUS allocates either XMM handle or DOS para
 TypeFlag   AS INTEGER          '0=DOS para, 1=XMS handle
END TYPE '8

TYPE GetDataPackTYPE            'GDP
 Func       AS INTEGER
 stat       AS INTEGER
 BytePos    AS LONG             'current byte relative base ptr (27)
 BufferPtrOff AS INTEGER        'far pointer to buffer to fill with data,offset
 BufferPtrSeg AS INTEGER        'segment
 StartPos   AS LONG             'start get at this offset relative BufferPtr
 BufferCnt  AS INTEGER          'bytes to fill (2-65520)
 MixerReg   AS INTEGER          'SBPro mixer register to get
END TYPE '20

TYPE InitPackTYPE               'IP
 Func       AS INTEGER
 stat       AS INTEGER
 DeviceID   AS INTEGER          '0=SPKR,1=LPTDAC,2=DSS,4=SB,5=SBPro
 IOport     AS INTEGER
 IRQline    AS INTEGER
 DMAch      AS INTEGER
 Flags      AS INTEGER          '(see source)
 InfoPtrOff AS INTEGER          'ret:far ptr to dac info
 InfoPtrSeg AS INTEGER
 DacExitPtrOff AS INTEGER       'ret:far ptr to dac's ExitXB routine
 DacExitPtrSeg AS INTEGER
 ModExitPtrOff AS INTEGER       'ret:far ptr to mod's ExitXB routine
 ModExitPtrSeg AS INTEGER
END TYPE '24

TYPE LoadPackTYPE               'LP
 Func       AS INTEGER
 stat       AS INTEGER
 FilenamePtrOff AS INTEGER      'far ptr to filenameZ to load
 FilenamePtrSeg AS INTEGER
 StartPos   AS LONG             'offset into file to start load at
 LoadSize   AS LONG             'number of bytes to load (or 0 for autosize)
 XMMflag    AS INTEGER          'if <> 0 use XMS for load
 XMMhandle  AS INTEGER          'ret:XMS handle, or
 LoadPtrOff AS INTEGER          'ret:DOS seg:offset (offset always 0)
 LoadPtrSeg AS INTEGER
END TYPE '20

TYPE PlaybackPackTYPE           'PBP
 Func       AS INTEGER
 stat       AS INTEGER
 Mode       AS INTEGER          'playback mode (0=interrupt FG,1=BG,2=DMA,3=DMA+BG for mod)
 XMMhandle  AS INTEGER          'if <> 0 this XMM handle used regardless
 LoadPtrOff AS INTEGER          'seg:off to start of data to play
 LoadPtrSeg AS INTEGER
 BufferSize AS INTEGER          'size of DMA buffer for mod playback
END TYPE '14

TYPE PausePackTYPE              'PP
 Func       AS INTEGER
 stat       AS INTEGER
 Pause      AS INTEGER          '0=unpause else pause
END TYPE '6

TYPE RecordPackTYPE             'RP
 Func         AS INTEGER
 stat         AS INTEGER
 SampleRate   AS INTEGER
 XMMhandle    AS INTEGER        '-1 auto XMS (ret in dx) else use this handle
 RecordPtrOff AS INTEGER        'seg:off of buffer to store (0 for auto-store)
 RecordPtrSeg AS INTEGER
 RecordBytes  AS LONG           'bytes to record
 StereoFlag   AS INTEGER        'stereo flag
END TYPE '18

TYPE SaveDataPackTYPE           'SDP
 Func       AS INTEGER
 stat       AS INTEGER
 FilenamePtrOff AS INTEGER      'far ptr to filenameZ to save
 FilenamePtrSeg AS INTEGER
 DataPtrOff AS INTEGER          'pointer to start of data to save, offset
 DataPtrSeg AS INTEGER          'segment (or 0 if XMS)
 FileType   AS INTEGER          '1=VOC,2=WAV
 XMMhandle  AS INTEGER          'XMS handle of data to save (0 if DOS data)
END TYPE '16

TYPE SetPackTYPE                'SP
 Func       AS INTEGER
 stat       AS INTEGER          ' (if volume=0 SB speaker off'ed else on'ed)
 Volume     AS INTEGER          'volume (left ch=MSB,right=LSB) (0-127,0-127)
 IntRate    AS INTEGER          'playback interrupt rate (5000-23000)
 Priority   AS INTEGER          'priority level (0-2, default=1)
END TYPE '18

TYPE SetModPackTYPE             'SMP                    'stereo modes
 Func       AS INTEGER                                  'A=ch1+ch3 & ch2+ch4
 stat       AS INTEGER                                  'B=?
 VolCh1     AS INTEGER          'channel volume (0-255) 'C=?
 VolCh2     AS INTEGER          'channel volumes adjustments made only
 VolCh3     AS INTEGER          ' if FastMode=0
 VolCh4     AS INTEGER
 Stereo     AS INTEGER          'playback mode (0=mono,stereo 1=A,2=B,3=C)
 FastMode   AS INTEGER          'fast playback (0=normal,1 fast,no ch volumes)
 IntRate    AS INTEGER          'playback interrupt rate (5000-45500)
 Position   AS INTEGER          'pattern list position (0-patterns to play)
 Speed      AS INTEGER          'overall playback speed (1-15,default=6,15=slow)
 SliceAdj   AS INTEGER          'slice adjust (1-64,default=1)
END TYPE '24

TYPE SetProPackTYPE             'SPP
 Func       AS INTEGER
 stat       AS INTEGER
 Volume     AS INTEGER          'volume (low=right;0-15, high byte=left;0-15)
 VolVoc     AS INTEGER          '
 VolMic     AS INTEGER          '(mono only, 0-7) input level
 VolCD      AS INTEGER          'input level (0-15,0-15)
 VolLI      AS INTEGER          'input level (0-15,0-15)
 FilterOut  AS INTEGER          '0=filter off, 1=filter on
 FilterIn   AS INTEGER          '0=filter off, 1=3.2kHz, 2=8.8kHz
 SourceIn   AS INTEGER          '0=mic,1=CD,2=line
 StereoIn   AS INTEGER          '0=mono,1=stereo record
END TYPE '22

TYPE XitPackTYPE                'XP
 Func       AS INTEGER
 stat       AS INTEGER
END TYPE '4

TYPE SysInfoPackTYPE            'SIP
 Func       AS INTEGER          '
 stat       AS INTEGER
 CPU        AS INTEGER          'CPU class (88,286,386,486)
 CPUmode    AS INTEGER          '0=real mode,1=PM,2=PM w/paging
 MHz        AS INTEGER          'approx speed (5,20,33)
 Device0    AS INTEGER          '=1 speaker available
 D0port     AS INTEGER          '42h
 D0IRQ      AS INTEGER          'n/a
 D0DMA      AS INTEGER          'n/a
 D0flags    AS INTEGER          'bit4=MIDI/3=XMS/2=DMA/1=REC/0=PLAY
 Device1    AS INTEGER          '=1 LPT-DAC available on LPT1
 D1port     AS INTEGER          'port of _first_ LPT found in BIOS data area
 D1IRQ      AS INTEGER          'n/a
 D1DMA      AS INTEGER          'n/a
 D1flags    AS INTEGER          'bit4=MIDI/3=XMS/2=DMA/1=REC/0=PLAY
 Device2    AS INTEGER          '=1 Disney Sound Source available
 D2port     AS INTEGER          'port of DSS
 D2IRQ      AS INTEGER          'n/a
 D2DMA      AS INTEGER          'n/a
 D2flags    AS INTEGER          'bit4=MIDI/3=XMS/2=DMA/1=REC/0=PLAY
 Device3    AS INTEGER          '=1 AdLib available
 D3port     AS INTEGER          '388h
 D3IRQ      AS INTEGER          'n/a
 D3DMA      AS INTEGER          'n/a
 D3flags    AS INTEGER          'bit4=MIDI/3=XMS/2=DMA/1=REC/0=PLAY
 Device4    AS INTEGER          '=1 SB available
 D4port     AS INTEGER          'port of SB
 D4IRQ      AS INTEGER          'IRQ
 D4DMA      AS INTEGER          'DMA
 D4flags    AS INTEGER          'bit4=MIDI/3=XMS/2=DMA/1=REC/0=PLAY
 Device5    AS INTEGER          '=1 SBPro available
 D5port     AS INTEGER          'port of SBPro
 D5IRQ      AS INTEGER          'IRQ
 D5DMA      AS INTEGER          'DMA
 D5flags    AS INTEGER          'bit4=MIDI/3=XMS/2=DMA/1=REC/0=PLAY
END TYPE '70

TYPE SysDevTYPE                 'SD (used by BASIC 7.1 compiler)
 device     AS INTEGER          '=1 device available
 port       AS INTEGER
 IRQ        AS INTEGER
 DMA        AS INTEGER
 Flags      AS INTEGER          'bit4=MIDI/3=XMS/2=DMA/1=REC/0=PLAY
END TYPE '10

TYPE SysInfoPackTYPE7           'SIP   BASIC 7.1: SIP.SD(0).device = ...
 Func       AS INTEGER
 stat       AS INTEGER
 CPU        AS INTEGER          'CPU class (88,286,386,486)
 CPUmode    AS INTEGER          '0=real mode,1=PM,2=PM w/paging
 MHz        AS INTEGER          'approx speed (5,20,33)
 ''SD(0 TO 5) AS SysDevTYPE       'QB45 won't accept arrays in TYPEs
END TYPE '70

'END RUCKDAC.BI -----------------------

