#                              SKYHAWK.MAK
#
#            MAKE FILE FOR SKYHAWK DEVELOPMENT KIT, ver. 2.0
#
# This make file is designed to be used only with Borland's MAKE utility;
# it has not been tested with Microsoft's MAKE. To use this file, enter
#
#     MAKE -fSKYHAWK.MAK
#
# at the DOS command line.
#
# SKYHAWK.MAK is designed to work with Turbo Pascal 5.0-7.0 or Borland
# Pascal 7.0, and Turbo Assembler 1.0+. This is made possible by MAKE
# conditional defines. There are several macros that must either be
# defined or commented out, depending on what version of the compiler you
# have and what assembler, if any. See the comments below for further
# instructions.

# ---------------------------------------------------- Macros

# You may need to modify the definitions below in order for MAKE to be
# able to find your compiler and assembler. To comment out a macro,
# insert '#' at the beginning of the line, as is being done here.

# Comment out all but one of the following lines depending on which
# version of Turbo Pascal (5.0-7.0) or Borland Pascal (7.0) you are
# using:
#
# tp5=1
# tp55=1
# tp6=1
# tp7=1
bp7=1

!if $(tp5) + $(tp55) + $(tp6) + $(tp7) + $(bp7) < 1
!error No compiler is specified
!endif

!if $(tp5) + $(tp55) + $(tp6) + $(tp7) + $(bp7) > 1
!error Only one compiler may be specified
!endif

# Activate this line for Borland Pascal 7.0 protected mode,
# or comment it out for real mode.
#
# pmode=1

# Source code for an extensive menu-driven test suite is included.
# Activate this line if you want the test suite built, or comment it out
# if not.
#
dotests=1

# Activate this line for Turbo Assembler,
# or comment it out for Microsoft Assembler.
#
tasm=1

# Comment this line out if you do not have an assembler.
#
HaveAssembler=1

# DO NOT MODIFY THIS IF-GROUP ***************
# Make sure pmode is undefined if not appropriate.
!ifndef bp7
!undef pmode
!endif

# You may wish to modify the pathnames or command line options in the
# following definitions for "compile" and/or "assemble".
#
!if $d(tp5) || $d(tp55) || $d(tp6) || $d(tp7)
compile=TPC.EXE /M /$D- /$L- /L
!endif
#
!ifdef bp7
!ifdef pmode
compile=BPC.EXE /CP /M /$D- /$L-
!else
compile=BPC.EXE /CD /M /$D- /$L-
!endif
!endif
#
!ifdef tasm
assemble=TASM.EXE
!else
assemble=MASM.EXE
!endif

# There normally should not be any need for you to modify the remainder
# of this file.

# --------------------------------------- Automatic macros

# Specify the file extension used for a unit
!ifdef pmode
uext=TPP
!else
uext=TPU
!endif


# ---------------------------------------- Force evaluation of dependencies

!ifdef dotests
!ifdef pmode
skyhawk.sys:    shclrdef.tpp    sherrmsg.tpp    shcmplx.tpp               \
                shcrcchk.tpp                                              \
                shutilpk.tpp    shdatpk.tpp     shfinanc.tpp              \
                shlist.tpp      shlngstr.tpp                              \
                shcmdlin.tpp                                              \
                testbetw.tpp    testcmpx.tpp    testcolr.tpp              \
                testcrc.tpp     testdate.tpp    testfin.tpp               \
                testlist.tpp    testutil.tpp                              \
                                                                          \
                testdrvr.tpp                                              \
                                                                          \
                testshdk.exe    testcmdl.exe    testerr.exe               \
                testlstr.exe
!else   # not pmode
skyhawk.sys:    shclrdef.tpu    sherrmsg.tpu    shcmplx.tpu               \
                shcrcchk.tpu                                              \
                shutilpk.tpu    shdatpk.tpu     shfinanc.tpu              \
                shlist.tpu      shlngstr.tpu                              \
                shcmdlin.tpu                                              \
                overshdk.tpu    overcmdl.tpu    overlstr.tpu              \
                testbetw.tpu    testcmpx.tpu    testcolr.tpu              \
                testcrc.tpu     testdate.tpu    testfin.tpu               \
                testlist.tpu    testutil.tpu                              \
                                                                          \
                execswap.tpu    testdrvr.tpu                              \
                                                                          \
                testshdk.exe    testcmdl.exe    testerr.exe               \
                testlstr.exe
!endif
!else   # don't do tests
!ifdef pmode
skyhawk.sys:    shclrdef.tpp    sherrmsg.tpp    shcmplx.tpp               \
                shcrcchk.tpp                                              \
                shutilpk.tpp    shdatpk.tpp     shfinanc.tpp              \
                shlist.tpp      shlngstr.tpp                              \
                shcmdlin.tpp
!else   # not pmode
skyhawk.sys:    shclrdef.tpu    sherrmsg.tpu    shcmplx.tpu               \
                shcrcchk.tpu                                              \
                shutilpk.tpu    shdatpk.tpu     shfinanc.tpu              \
                shlist.tpu      shlngstr.tpu                              \
                shcmdlin.tpu
!endif
!endif


# ---------------------------------------  Implicit rules

.pas.exe:
  $(compile) $*

.pas.tpu:
  $(compile) $*

.pas.tpp:
  $(compile) $*

!ifdef HaveAssembler
.asm.obj:
  $(assemble) $*
!endif

# ---------------------------------------  Object files

!ifndef pmode
!ifdef HaveAssembler
execswap.obj:   execswap.asm
!endif
!endif

# ---------------------------------------  Unit files

shclrdef.$(uext):   shdefine.inc      shunitsw.inc      shclrdef.pas

shcmplx.$(uext):    shdefine.inc      shunitsw.inc      shcmplx.pas

shcrcchk.$(uext):   shdefine.inc      shunitsw.inc      shcrcchk.pas

shdatpk.$(uext):    shdefine.inc      shunitsw.inc      shdatpk.pas

sherrmsg.$(uext):   shdefine.inc      shunitsw.inc      sherrmsg.pas

shfinanc.$(uext):   shdefine.inc      shunitsw.inc      shutilpk.$(uext)  \
                    sherrmsg.$(uext)  shfinanc.pas

shlist.$(uext):     shdefine.inc      shunitsw.inc      shlist.pas

shlngstr.$(uext):   shdefine.inc      shunitsw.inc      shlngstr.pas

shutilpk.$(uext):   shdefine.inc      shunitsw.inc      shutilpk.pas

shcmdlin.$(uext):   shdefine.inc      shunitsw.inc      shcmdlin.pas      \
                    shlist.$(uext)    shutilpk.$(uext)

testbetw.$(uext):   shdefine.inc      shunitsw.inc      testbetw.pas      \
                    shutilpk.$(uext)

testcmpx.$(uext):   shdefine.inc      shunitsw.inc      testcmpx.pas      \
                    shcmplx.$(uext)

testcolr.$(uext):   shdefine.inc      shunitsw.inc      testcolr.pas      \
                    shclrdef.$(uext)

testcrc.$(uext):    shdefine.inc      shunitsw.inc      testcrc.pas       \
                    shcrcchk.$(uext)

testdate.$(uext):   shdefine.inc      shunitsw.inc      testdate.pas      \
                    shdatpk.$(uext)                                       \

testlist.$(uext):   shdefine.inc      shunitsw.inc      testlist.pas      \
                    shlist.$(uext)

testfin.$(uext):    shdefine.inc      shunitsw.inc      shfinanc.$(uext)  \
                    sherrmsg.$(uext)  testfin.pas

testutil.$(uext):   shdefine.inc      shunitsw.inc      testutil.pas      \
                    shutilpk.$(uext)

!ifdef pmode
testdrvr.$(uext):   shdefine.inc      testshdk.pas                        \
                    testbetw.$(uext)  testfin.$(uext)                     \
                    testcmpx.$(uext)  testcolr.$(uext)  testcrc.$(uext)   \
                    testdate.$(uext)  testlist.$(uext)  testutil.$(uext)
!else
testdrvr.$(uext):   shdefine.inc      testshdk.pas                        \
                    testbetw.$(uext)  testfin.$(uext)                     \
                    testcmpx.$(uext)  testcolr.$(uext)  testcrc.$(uext)   \
                    testdate.$(uext)  testlist.$(uext)  testutil.$(uext)  \
                    overshdk.$(uext)  execswap.$(uext)
!endif

!ifndef pmode
execswap.$(uext):   execswap.pas      execswap.obj

overshdk.$(uext):   overshdk.pas

overcmdl.$(uext):   overcmdl.pas

overlstr.$(uext):   overlstr.pas
!endif

# ---------------------------------------  Executable files

testerr.exe:        shdefine.inc      testerr.pas       sherrmsg.$(uext)

!ifdef pmode
testcmdl.exe:       shdefine.inc      testcmdl.pas      shcmdlin.$(uext)

testlstr.exe:       shdefine.inc      testlstr.pas      shcrcchk.$(uext)  \
                    shutilpk.$(uext)  shlngstr.$(uext)

testshdk.exe:       shdefine.inc      testshdk.pas                        \
                    testbetw.$(uext)                                      \
                    testcmpx.$(uext)  testcolr.$(uext)  testcrc.$(uext)   \
                    testdate.$(uext)  testlist.$(uext)  testutil.$(uext)  \
                    testdrvr.$(uext)                                      \
                    testcmdl.exe      testerr.exe       testlstr.exe
!else
testcmdl.exe:       shdefine.inc      testcmdl.pas      shcmdlin.$(uext)  \
                    overcmdl.$(uext)

testlstr.exe:       shdefine.inc      testlstr.pas      shcrcchk.$(uext)  \
                    shutilpk.$(uext)  shlngstr.$(uext)                    \
                    overlstr.$(uext)

testshdk.exe:       shdefine.inc      testshdk.pas                        \
                    testbetw.$(uext)                                      \
                    testcmpx.$(uext)  testcolr.$(uext)  testcrc.$(uext)   \
                    testdate.$(uext)  testlist.$(uext)  testutil.$(uext)  \
                    testdrvr.$(uext)                                      \
                    testcmdl.exe      testerr.exe       testlstr.exe      \
                    overshdk.$(uext)  execswap.$(uext)
!endif
