{$I SHDEFINE.INC}

{$I SHUNITSW.INC}

unit TestCrc;
{
                       To test the ShCrcChk unit

                  Copyright 1991 Madison & Associates
                          All Rights Reserved

         This program source file and the associated executable
         file may be  used and distributed  only in  accordance
         with the  provisions  described  on  the title page of
                  the accompanying documentation file
                              SKYHAWK.DOC
}

interface

uses
  Dos,
  ShCrcChk,
  TpString,
  TpCrt,
  TpDos;

procedure CrcTest;

implementation

procedure CrcTest;

var
  OriginalCRC,
  CopiedFileCRC,
  ChangedFileCRC: word;
  XXX           : file of byte;
  T1            : longint;
  B1            : byte;
  FF            : SearchRec;      {For the file to be checked}
  FN            : string[12];     {   The name of the file}

  O             : text;

procedure AnyKey;
  begin
    if HandleIsConsole(1) then begin
      Write(O, 'Any key to continue...');
      if ReadKey = #0 then ;
      WriteLn(O);
      end;
    end;

begin
  if OpenStdDev(O, 1) then ;
  FindFirst('*.*', $00, FF);
  while (FF.Size < $FF)                   and
        (JustExtension(FF.Name) = 'OVR')  and
        (DosError = 0)                    do  FindNext(FF);
  if FF.Size < $FF then begin
    WriteLn(O, 'Couldn''t find a suitable file for checking. Aborting...');
    exit;
    end;
  FN := FF.Name;
  WriteLn(O, 'Reads file '+FN+' and calculates its CRC,');
  WriteLn(O, 'makes a true copy and calculates its CRC, then makes a');
  WriteLn(O, 'copy with one bit at or near the mid-point of the');
  WriteLn(O, 'file changed and calculates its CRC. At the completion the');
  WriteLn(O, 'three CRC''s are displayed.');
  WriteLn(O, '');

  WriteLn(O, 'Copying with CrcCopy...');
  OriginalCRC := CrcCopy(FN, ForceExtension(FN,'CK1'));
  CopiedFileCRC := CrcCopy(ForceExtension(FN,'CK1'), 
                           ForceExtension(FN,'CK2'));

  {Now change one bit in the second file, somewhere near the middle}
  WriteLn(O, 'Changing one bit in the second copy...');
  Assign(XXX, ForceExtension(FN,'CK2'));
  Reset(XXX);
  T1 := FileSize(XXX) shr 1;
  Seek(XXX, T1);
  Read(XXX,B1);
  dec(T1);  {Put the pointer back where it belongs}
  Write(O, '':5,'A $',HexB(B1),' is being changed to a ');
  B1 := B1 xor $10;
  WriteLn(O, '$',HexB(B1));
  Seek(XXX, T1);
  Write(XXX,B1);
  Close(XXX);

  {Now calculate the CRC of the modified file.}
  WriteLn(O, 'Calculating CRC of modified copy with CrcCalc...');
  ChangedFileCRC := CrcCalc(ForceExtension(FN,'CK2'));

  {Tests completed. Display the result.}
  WriteLn(O, 'CRC of original file = ',HexW(OriginalCRC));
  WriteLn(O, 'CRC of true copy     = ',HexW(CopiedFileCRC));
  WriteLn(O, 'CRC of changed copy  = ',HexW(ChangedFileCRC));
  WriteLn(O);
  AnyKey;
  Erase(XXX);
  Assign(XXX, ForceExtension(FN,'CK1'));
  Erase(XXX);
  Flush(O);
  end; {CrcTest}
end.
