VERSION 2.00
Begin Form frmMain 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Snooper"
   ClientHeight    =   2175
   ClientLeft      =   3240
   ClientTop       =   4200
   ClientWidth     =   4215
   Height          =   2865
   Icon            =   SNOOPER.FRX:0000
   Left            =   3180
   LinkTopic       =   "Form1"
   ScaleHeight     =   2175
   ScaleWidth      =   4215
   Top             =   3570
   Width           =   4335
   Begin ComboBox cboCategory 
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   300
      Left            =   1080
      Style           =   2  'Dropdown List
      TabIndex        =   1
      Top             =   120
      Width           =   3015
   End
   Begin TextBox txtDetails 
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   1575
      Left            =   120
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   2
      Top             =   480
      Width           =   3975
   End
   Begin Label Label1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Category:"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   855
   End
   Begin Menu mnuFile 
      Caption         =   "&File"
      Begin Menu mnuFileAbout 
         Caption         =   "&About..."
         Shortcut        =   ^A
      End
      Begin Menu mnuFileSep01 
         Caption         =   "-"
      End
      Begin Menu mnuFileExit 
         Caption         =   "E&xit"
      End
   End
   Begin Menu mnuWinSpy 
      Caption         =   "&Window Spy!"
   End
End
Option Explicit

'Keep track of current category to avoid needless updates
Dim currentCategory As Integer

Sub cboCategory_Click ()

    'Update category details if category has changed
    If cboCategory.ListIndex <> currentCategory Then
        'Display hourglass cursor during processing
        Screen.MousePointer = 11
        'Update category
        currentCategory = cboCategory.ListIndex
        'Dispatch correct procedure
        Select Case currentCategory
            Case CATEGORY_DOSINFO
                Call ShowDOSInfo
            Case CATEGORY_WINDOWSINFO
                Call ShowWindowsInfo
            Case CATEGORY_HARDWAREINFO
                Call ShowHardwareInfo
            Case CATEGORY_DISPLAYINFO
                Call ShowDisplayInfo
            Case CATEGORY_PRINTERINFO
                Call ShowPrinterInfo
            Case CATEGORY_DRIVESINFO
                Call ShowDrivesInfo
            Case CATEGORY_INTVECTORS
                Call ShowIntVectors
            Case CATEGORY_AUTOEXECBAT
                Call ShowAutoExecBat
            Case CATEGORY_CONFIGSYS
                Call ShowConfigSys
            Case CATEGORY_WININI
                Call ShowWinIni
        End Select
        'Restore mouse cursor
        Screen.MousePointer = 0
    End If

End Sub

Sub Form_Load ()
    Dim i As Long

    currentCategory = -1
    newLine = Chr$(13) & Chr$(10)

    'Populate combo box with available categories
    cboCategory.AddItem "Windows Information"
    cboCategory.AddItem "DOS Information"
    cboCategory.AddItem "Hardware Information"
    cboCategory.AddItem "Display Information"
    cboCategory.AddItem "Printer Information"
    cboCategory.AddItem "Drives Information"
    cboCategory.AddItem "Interrupt Vectors"
    cboCategory.AddItem "View AUTOEXEC.BAT"
    cboCategory.AddItem "View CONFIG.SYS"
    cboCategory.AddItem "View WIN.INI"
    cboCategory.ListIndex = 0

    'Prevent user from editing text box
    i = SendMessage(txtDetails.hWnd, EM_SETREADONLY, True, 0&)

    'Center category combo box between area above text box
    cboCategory.Top = (txtDetails.Top - cboCategory.Height) / 2
    
    'Size form to screen and center
    Width = Screen.Width * .75
    Height = Screen.Height * .75
    Move (Screen.Width - Width) / 2, (Screen.Height - Height) / 2

End Sub

Sub Form_Paint ()
    Dim x As Long, y As Long

    'Since some programmers may not have the 3D panel
    'control, we'll just draw our own 3D shading
    x = Screen.TwipsPerPixelX: y = Screen.TwipsPerPixelY

    'Clear any previously-drawn lines
    Line (0, 0)-(ScaleWidth, ScaleHeight), backcolor, BF

    'And make the combo box look "sunken"
    CurrentX = cboCategory.Left - x
    CurrentY = cboCategory.Top + cboCategory.Height
    Line -Step(0, -(cboCategory.Height + y)), RGB(92, 92, 92)
    Line -Step(cboCategory.Width + x, 0), RGB(92, 92, 92)
    Line -Step(0, cboCategory.Height + y), RGB(255, 255, 255)
    Line -Step(-(cboCategory.Width + x), 0), RGB(255, 255, 255)
    
    'Same for text box
    CurrentX = txtDetails.Left - x
    CurrentY = txtDetails.Top + txtDetails.Height
    Line -Step(0, -(txtDetails.Height + y)), RGB(92, 92, 92)
    Line -Step(txtDetails.Width + x, 0), RGB(92, 92, 92)
    Line -Step(0, txtDetails.Height + y), RGB(255, 255, 255)
    Line -Step(-(txtDetails.Width + x), 0), RGB(255, 255, 255)

End Sub

Sub Form_Resize ()
    Dim sizeX As Integer, sizeY As Integer

    'Rearrange controls if window not minimized
    If WindowState <> 1 Then
        'Determine smallest area to size controls
        sizeX = cboCategory.Left + 600
        sizeY = txtDetails.Top + 240
        'Resize to larger area if there's room
        If ScaleWidth > sizeX Then sizeX = ScaleWidth
        If ScaleHeight > sizeY Then sizeY = ScaleHeight
        'Size controls to fit window
        cboCategory.Move cboCategory.Left, cboCategory.Top, sizeX - (cboCategory.Left + 120)
        txtDetails.Move txtDetails.Left, txtDetails.Top, sizeX - (txtDetails.Left + 120), sizeY - (txtDetails.Top + 120)
    End If

End Sub

Sub mnuFileAbout_Click ()
    'Display about form
    frmAbout.Show 1
End Sub

Sub mnuFileExit_Click ()
    Unload Me
End Sub

Sub mnuWinSpy_Click ()
    frmWinInfo.Show 1
End Sub

