///////////////////////////////////////////
//    V.U.R.T.U.A.L.   #SYSTEM COMMAND   //
//	  (C)opyright 1994 Robert J. Tiess   //
//---------------------------------------//
// #VARLINE								 //
// SYNTAX:								 //
// 				#VARLINE				 //
//				3						 //
//				variablename			 //
//				[line#]					 //
//				newvariable				 //
//---------------------------------------//
// #VARLINE is a SYSTEM COMMAND that     //
// allows you to access a specific line  //
// of a defined variable.  This is how a //
// VURTUAL variable can actually have	 //
// hundreds to thousands of meanings,    //
// since each line of a variable file    //
// be considered a separate value.       //
//										 //
// The example below shows how one       //
// variable can be used in mathematical  //
// and string contexts:					 //
//---------------------------------------//
// A sample V.U.R.T.U.A.L. program:		 //
//---------------------------------------//
// beginprogram							 //
//										 //
// variable								 //
//		digit							 //
//		994							     //
// endvariable							 //
//										 //
// variable								 //
// 		flxible							 //
//			This is a sentence.			 //
//			1000						 //
//			The year was 1994...		 //
// endvariable							 //
//										 //
// #varline								 //
// 3									 //
// flxible								 //
// 2									 //
// number								 //
//										 //
// #add									 //
// 2									 //
// digit								 //
// number								 //
// 										 //
// showreturns							 //
//		#add							 //
//										 //
// endprogram							 //
//---------------------------------------//
// As you can see, this example invokes	 //
// another #SYSTEM COMMAND, #ADD.  Since //
// #ADD requires two input strings, a    //
// variable "digit" was defined at the   //
// start of the above program, assigned  //
// the number 994.  #VARLINE will take   //
// the second line of "flxible" and		 //
// create a third variable, "number,"    //
// which is 1000.  The INTERVUR command, //
// showreturns retrieves the number      //
// #ADD produced and put in its .RET     //
// return file. The number shown is 1994.//
///////////////////////////////////////////
// *** NOTE: #VARLINE does NOT produce   //
// a .RET return file because it works   //
// directly on the variables you pass    //
// to it.  Use VIEWVARIABLE to see the   //
// results of this operation.			 //
///////////////////////////////////////////


#include <fstream.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>

int main (int argc, char * argv[])
{
	// Define two arrays to hold incoming .VAR filenames
	char variableone[12];
	char variabletwo[12];

	// Define sufficient input line
	char lineread[256];

	// Define number (the "VARLINE") for ATOI to process
	int linenumber;

	// Create the filenames to access the .VAR files
	stpcpy(variableone,argv[1]);
	stpcpy(variabletwo,argv[3]);
	strcat(variableone,".VAR");
	strcat(variabletwo,".VAR");

	// Convert the second parameter (the "VARLINE") from string to integer
	linenumber=atoi(argv[2]);

	// Open files for I/O
	ifstream f3(variableone);
	ofstream f4(variabletwo);

	// If there is an error, terminate and report error
	if (!f3)
	{
		cout << "#SYSTEM COMMAND ERROR:  ERROR ACCESSING \"" << variableone << "\"!\n";
		exit(1);
	}

	// Read up to and retrieve the desired variable line
	for (int count=0; count<linenumber; count++)
	{
		f3.getline(lineread,255,'\n');

		// If the variable line goes past the EOF, STOP!
		if (!f3)
		{
			cout << "#SYSTEM COMMAND ERROR:  ERROR ACCESSING \"" << variableone << "\"!\n";
			exit(1);
		}
	}

	// Output line read from f3 to new variable file
	f4 << lineread << "\n";

	// Close files, return to INTERVUR
	f3.close();
	f4.close();
	return 0;
}
