//===========================================================
// WCLib - A function library for the WinCmd language
// Copyright (C) 1993 Douglas Boling
//
// Version 1.1 added check for bad file handles.
//===========================================================
// Returns no. of elements
#define dim(x) (sizeof(x) / sizeof(x[0]))   
#define MAXREADLINE       1024   
//
// Defines to reduce number of includes
//
#define NOCOMM             1    Comm driver APIs and definitions
#define NOMINMAX           1    min() and max() macros
#define NOLOGERROR         1    LogError() and related definitions
#define NOPROFILER         1    Profiler APIs
#define NORESOURCE         1    Resource management
#define NOATOM             1    Atom management
#define NOLANGUAGE         1    Character test routines
#define NODBCS             1    Double-byte character set routines
#define NOKEYBOARDINFO     1    Keyboard driver routines
#define NOGDICAPMASKS      1    GDI device capability constants
#define NOCOLOR            1    COLOR_#define color values
#define NOGDIOBJ           1    GDI pens, brushes, fonts
#define NODRAWTEXT         1    DrawText() and related definitions
#define NOTEXTMETRIC       1    TEXTMETRIC and related APIs
#define NOSCALABLEFONT     1    Truetype scalable font support
#define NOBITMAP           1    Bitmap support
#define NORASTEROPS        1    GDI Raster operation definitions
#define NOMETAFILE         1    Metafile support
#define NOSYSTEMPARAMSINFO 1    SystemParametersInfo() and SPI_#define definitions
#define NOMSG              1    APIs and definitions that use MSG structure
#define NOWINSTYLES        1    Window style definitions
#define NODEFERWINDOWPOS   1    DeferWindowPos and related definitions
#define NOVIRTUALKEYCODES  1    VK_* virtual key codes
#define NOKEYSTATES        1    MK_* message key state flags
#define NOWH               1    SetWindowsHook and related WH_* definitions
#define NOMENUS            1    Menu APIs
#define NOSCROLL           1    Scrolling APIs and scroll bar control
#define NOICONS            1    IDI_* icon IDs
#define NOMB               1    MessageBox and related definitions
#define NOSYSCOMMANDS      1    WM_SYSCOMMAND SC_* definitions
#define NOMDI              1    MDI support
//#define NOCTLMGR           1    Control management and controls
#define NOHELP             1    Help support
//
// Sections of windows.h required for compile
//
//#define NOLSTRING          1    lstr* string management routines
//#define NODRIVERS          1    Installable driver APIs and definitions
//#define NOMEMMGR           1    Local and global memory management
//#define NOLFILEIO          1    _l* file I/O routines
//#define NOOPENFILE         1    OpenFile and related definitions
//#define NOSYSMETRICS       1    GetSystemMetrics() and related SM_#define definitions
//#define NOWINOFFSETS       1    Get/SetWindowWord/Long offset definitions
//#define NOSHOWWINDOW       1    ShowWindow and related definitions
//#define NOCLIPBOARD        1    Clipboard APIs and definitions
//#define NOWINMESSAGES      1    WM_* window messages

#include "windows.h"
#include "shellapi.h"
#include "mmsystem.h"

#include "stdlib.h"
#include "string.h"
#include "direct.h"
#include "dos.h"

#include "WinCmd.h"
#include "wclib.h"

typedef struct {
	BYTE	bWidth;
	BYTE	bHeight;
	BYTE	bColorCount;
	BYTE	bReserved;
	WORD	wPlanes;
	WORD	wBitCount;
	DWORD	dwBytesInRes;			
	DWORD	dwImageOffset;
} ICONDIRENTRY;
typedef ICONDIRENTRY FAR *LPICONDIRENTRY;

typedef struct {
   WORD				idReserved;
   WORD				idType;
   WORD				idCount;
   ICONDIRENTRY	idEntries[];
} ICONHEADER;
typedef ICONHEADER FAR *LPICONHEADER;


typedef struct {
	char		*szName;
	PLFUNC	Fxn;
} LIBFUNCSTRUCT;
typedef LIBFUNCSTRUCT *PLIBFUNCSTRUCT;

INT LibHiWord (LPTOKEN, LPTOKEN);
INT LibLowWord (LPTOKEN, LPTOKEN);
INT LibMoveWin (LPTOKEN, LPTOKEN);
INT LibSizeWin (LPTOKEN, LPTOKEN);
INT LibMinimizeWin (LPTOKEN, LPTOKEN);
INT LibZoomWin (LPTOKEN, LPTOKEN);
INT LibRestoreWin (LPTOKEN, LPTOKEN);
INT LibGetWinHandle (LPTOKEN, LPTOKEN);
INT LibGetWinText (LPTOKEN, LPTOKEN);
INT LibGetWinPos (LPTOKEN, LPTOKEN);
INT LibGetWinSize (LPTOKEN, LPTOKEN);
INT LibGetWinState (LPTOKEN, LPTOKEN);
INT LibGetWindow (LPTOKEN, LPTOKEN);
INT LibGetWinEXE (LPTOKEN, LPTOKEN);
INT LibPostMessage (LPTOKEN, LPTOKEN);
INT LibSendMessage (LPTOKEN, LPTOKEN);
INT LibSendMCIString (LPTOKEN, LPTOKEN);
INT LibGetMCIErrString (LPTOKEN, LPTOKEN);
INT LibFileOpen (LPTOKEN, LPTOKEN);
INT LibFileRead (LPTOKEN, LPTOKEN);
INT LibFileReadLine (LPTOKEN, LPTOKEN);
INT LibFileWrite (LPTOKEN, LPTOKEN);
INT LibFileWriteLine (LPTOKEN, LPTOKEN);
INT LibFileSeek (LPTOKEN, LPTOKEN);
INT LibFileClose (LPTOKEN, LPTOKEN);
INT LibFileExist (LPTOKEN, LPTOKEN);
INT LibGetClipText (LPTOKEN, LPTOKEN);
INT LibSetClipText (LPTOKEN, LPTOKEN);
INT LibSetWinIcon (LPTOKEN, LPTOKEN);
INT LibLoadIconFile (LPTOKEN, LPTOKEN);
INT LibGetCWD (LPTOKEN, LPTOKEN);
INT LibChDrive (LPTOKEN, LPTOKEN);

//-----------------------------------------------------------
// Global data
//-----------------------------------------------------------
char     szDllName[] = "WCLib";
char     szTemp[256];
UINT		wWCLibVer = 11;
FIND_T	fs;

HANDLE	hInst;
HWND		hMain;
RECT		rect;
BYTE		nIconWidth, nIconHeight;

LIBFUNCSTRUCT FuncList[] = {
//   Name          Function
	{"GETWINDOWHANDLE", LibGetWinHandle},
	{"GETWINDOWTEXT", LibGetWinText},
	{"GETWINDOWPOS", LibGetWinPos},
	{"GETWINDOWSIZE", LibGetWinSize},
	{"GETWINDOWSTATE", LibGetWinState},
	{"GETWINDOW", LibGetWindow},
	{"GETWINDOWEXE", LibGetWinEXE},
	{"SIZEWINDOW", LibSizeWin},
	{"MINIMIZEWINDOW", LibMinimizeWin},
	{"MAXIMIZEWINDOW", LibZoomWin},
	{"RESTOREWINDOW", LibRestoreWin},
	{"MOVEWINDOW", LibMoveWin},
	{"POSTMESSAGE", LibPostMessage},
	{"SENDMESSAGE", LibSendMessage},
	{"SENDMCISTRING", LibSendMCIString},
	{"GETMCIERRORSTRING", LibGetMCIErrString},
	{"FILEOPEN", LibFileOpen},
	{"FILEREAD", LibFileRead},
	{"FILEREADLINE", LibFileReadLine},
	{"FILEWRITE", LibFileWrite},
	{"FILEWRITELINE", LibFileWriteLine},
	{"FILEMOVEPTR", LibFileSeek},
	{"FILECLOSE", LibFileClose},
	{"FILEEXIST", LibFileExist},
	{"GETCLIPTEXT", LibGetClipText},
	{"SETCLIPTEXT", LibSetClipText},
	{"LOADICONFILE", LibLoadIconFile},
	{"SETICON", LibSetWinIcon},
	{"HIGHWORD", LibHiWord},
	{"LOWWORD", LibLowWord},
	{"GETDIR", LibGetCWD},
	{"SETDRIVE", LibChDrive},
};
LPCBTOKFUNC	lpCallbackTokenFunction;
//
// Library contstant tokens
//
struct {
	char *szName;
	INT sVal;
} ConstList[] = {{"FILE_READONLY", OF_READ | OF_SHARE_DENY_WRITE}, 
                 {"FILE_READWRITE", OF_READWRITE | OF_SHARE_EXCLUSIVE},
                 {"FILE_CREATE", OF_CREATE},
                };

//===========================================================
// Library initialization and terminataion functions
//===========================================================
//-----------------------------------------------------------
// LibMain - DLL initialization routine
//-----------------------------------------------------------
INT CALLBACK LibMain (HANDLE hInstance, WORD wDataSeg, 
                      WORD wHeapSize, LPSTR lpszCmdLine) {
	hInst = hInstance;
	nIconWidth = (BYTE) GetSystemMetrics (SM_CXICON);
	nIconHeight = (BYTE) GetSystemMetrics (SM_CYICON);
	return 1;
}
//-----------------------------------------------------------
// WEP - DLL termination routine
//-----------------------------------------------------------
INT CALLBACK WEP (int nParameter) {
	return 1;
}
//===========================================================
// Library exported functions
//===========================================================
//-----------------------------------------------------------
// WCLibLoad - Routine called by WinCmd at function lib load
//-----------------------------------------------------------
INT CALLBACK WCLibLoad (HWND hWinCmdWnd, INT sNewLibID, INT sLibErrNum) {

   return 0;
}   
//-----------------------------------------------------------
// WCLibReset - Routine called by WinCmd to reset lib
//-----------------------------------------------------------
INT CALLBACK WCLibReset (INT sLibID, LPCBTOKFUNC lpfnCBTokenFunc) {
   INT	i, sRC = 0;

	// Add Functions to token list
   for (i = 0; i < dim (FuncList); i++) {
		sRC = (INT)(*lpfnCBTokenFunc)(CBF_ADDTOKEN, 0, 
		                    (LPSTR) FuncList[i].szName, 
		                    TTYPE_LIBFUNC, 0, MAKELONG (i, sLibID));
		if (sRC) break;
	}	
	// Add predefined tokens
   for (i = 0; i < dim (ConstList); i++) {
		sRC = (INT)(*lpfnCBTokenFunc)(CBF_ADDTOKEN, 0, 
		                    (LPSTR) ConstList[i].szName, 
		                    TTYPE_NUM, 0, (DWORD) ConstList[i].sVal);
		if (sRC) break;
	}
	return 0;
}
//-----------------------------------------------------------
// WCLibFunc - Routine called by WinCmd at function dispatch
//-----------------------------------------------------------
INT CALLBACK WCLibFunc (LPLINETOKEN *lpltLine, LPTOKEN lptDest, UINT wFuncNum,
                        FARPROC lpfnCBTokenFunc, HWND hWin) {
	INT	sRC;
	lpCallbackTokenFunction = (LPCBTOKFUNC) lpfnCBTokenFunc;
	hMain = hWin;
   lptDest->ucType = TTYPE_NUM;
	sRC = (FuncList[wFuncNum].Fxn) (lptDest, (LPTOKEN)lptDest->dwData);
   return sRC;
}
//-----------------------------------------------------------
// WCGetErrStr - Routine that returns a string for an error
// code.
//-----------------------------------------------------------
INT CALLBACK WCGetErrStr (INT sError, LPSTR lpszStrOut, INT sStrSize) {
   return 0;
}   
//-----------------------------------------------------------
// WCGetHelp - Routine that returns a help string for a function.
//-----------------------------------------------------------
INT CALLBACK WCGetHelp (INT sLineNum, LPSTR lpszStrOut, INT sStrSize) {

	if (LoadString (hInst, sLineNum + HELPSTART, lpszStrOut, sStrSize))
		return 1;
	return 0;
}   
//-----------------------------------------------------------
// WCGetVersion - Routine returns lib name and version
//-----------------------------------------------------------
INT CALLBACK WCGetVersion (LPWORD lpwVersion, LPSTR lpszNameOut, INT sStrSize) {
   *lpwVersion = wWCLibVer;
   if (strlen (szDllName) < (UINT) sStrSize)
      lstrcpy (lpszNameOut, szDllName);
   return 0;
}   
//===========================================================
// Local procedures
//===========================================================
//------------------------------------------------------------
// SetToken - Sets a token to a new value
//------------------------------------------------------------ 
INT SetToken (LPTOKEN lptDest, BYTE ucNewType, UINT wData, DWORD dwData) {
   return (INT) (*lpCallbackTokenFunction) (CBF_SETTOKEN, lptDest, 
                               0, ucNewType, wData, dwData);
}   

//-----------------------------------------------------------
// GetTokenString - Returns a pointer to the string value
// for a token.
//-----------------------------------------------------------
LPSTR GetTokenString (LPTOKEN lptDest) {
   return (LPSTR) (*lpCallbackTokenFunction)(CBF_GETTOKENSTRING, 
                                             lptDest, 0, 0, 0, 0);
}  	
//-----------------------------------------------------------
// GetTokenVal - Returns a pointer to the numberic value
// for a token.
//----------------------------------------------------------- 
LONG GetTokenVal (LPTOKEN lptDest) {
   return (LONG) (*lpCallbackTokenFunction)(CBF_GETTOKENVAL, 
                                            lptDest, 0, 0, 0, 0);
}  	
//===========================================================
// WCLib functions
//===========================================================
//------------------------------------------------------------
// LibHiWord - Returns the upper 16 bits of a long
// Arg 1 - Long word
//------------------------------------------------------------ 
INT LibHiWord (LPTOKEN lptDest, LPTOKEN lptArg) {
	if (lptDest->wData <= 1) 
		return ERR_TOO_FEW_PARMS;
	return SetToken (lptDest, TTYPE_NUM, 0, GetTokenVal (lptArg-1) >> 16);
}  	
//------------------------------------------------------------
// LibLowWord - Returns the lower 16 bits of a long
// Arg 1 - Long word
//------------------------------------------------------------ 
INT LibLowWord (LPTOKEN lptDest, LPTOKEN lptArg) {
	if (lptDest->wData <= 1) 
		return ERR_TOO_FEW_PARMS;
	return SetToken (lptDest, TTYPE_NUM, 0, GetTokenVal (lptArg-1) & 0xffff);
}  	
//------------------------------------------------------------
// GetWinHandle - Returns the window handle from the window
// text.
// Arg 1 - Window title text
//------------------------------------------------------------ 
INT LibGetWinHandle (LPTOKEN lptDest, LPTOKEN lptArg) {
	HWND		hWndTarg;
	
	if (lptDest->wData <= 1) 
		return ERR_TOO_FEW_PARMS;
	hWndTarg = FindWindow (0, GetTokenString(lptArg-1));
	return SetToken (lptDest, TTYPE_NUM, 0, (DWORD)hWndTarg);
}  	
//------------------------------------------------------------
// GetWinText - Returns the window text for a window
// Arg 1 - Window handle
//------------------------------------------------------------ 
INT LibGetWinText (LPTOKEN lptDest, LPTOKEN lptArg) {
	HWND		hWndTarg;
	
	if (lptDest->wData <= 1) 
		return ERR_TOO_FEW_PARMS;
   hWndTarg = (HWND) GetTokenVal (lptArg-1);
   szTemp[0] = '\0';
   SendMessage (hWndTarg, WM_GETTEXT, sizeof (szTemp), (DWORD)(LPSTR) szTemp);
		return SetToken (lptDest, TTYPE_STR, 0, (DWORD)(LPSTR)szTemp);
}  	
//-----------------------------------------------------------
// LibMoveWin - Function to move a window
// Arg 1 - Window handle
// Arg 2 - New Horizonal pos
// Arg 3 - New Vertical pos
//----------------------------------------------------------- 
INT LibMoveWin (LPTOKEN lptDest, LPTOKEN lptArg) {
   INT		sRC = 0, sNewX, sNewY;
   HWND     hwndTarg;
   
	if (lptDest->wData <= 3) 
		return ERR_TOO_FEW_PARMS;

   sNewX = (INT) GetTokenVal (lptArg-2);
   sNewY = (INT) GetTokenVal (lptArg-3);
   hwndTarg = (HWND) GetTokenVal (lptArg-1);
	if (!IsWindow (hwndTarg)) 
		return SetToken (lptDest, TTYPE_NUM, 0, MYFALSE);

	SetWindowPos (hwndTarg, 0, sNewX, sNewY, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
	sRC = SetToken (lptDest, TTYPE_NUM, 0, MYTRUE);
  	return sRC;
}  	
//-----------------------------------------------------------
// LibSizeWin - Function to change the size of a window
// Arg 1 - Window handle
// Arg 2 - New Horizonal size
// Arg 3 - New Vertical size
//----------------------------------------------------------- 
INT LibSizeWin (LPTOKEN lptDest, LPTOKEN lptArg) {
   INT		sRC = 0, sNewX, sNewY;
   HWND     hwndTarg;
   
	if (lptDest->wData <= 3) 
		return ERR_TOO_FEW_PARMS;

   sNewX = (INT) GetTokenVal (lptArg-2);
   sNewY = (INT) GetTokenVal (lptArg-3);
   hwndTarg = (HWND) GetTokenVal (lptArg-1);
	if (!IsWindow (hwndTarg)) 
		return SetToken (lptDest, TTYPE_NUM, 0, MYFALSE);

	SetWindowPos (hwndTarg, 0, 0, 0, sNewX, sNewY, SWP_NOMOVE | SWP_NOZORDER);
	sRC = SetToken (lptDest, TTYPE_NUM, 0, MYTRUE);
  	return sRC;
}
//-----------------------------------------------------------
// LibMinimizeWin - Function to minimize a window
// Arg 1 - Window handle
//----------------------------------------------------------- 
INT LibMinimizeWin (LPTOKEN lptDest, LPTOKEN lptArg) {
   HWND     hwndTarg;
   
	if (lptDest->wData <= 1) 
		return ERR_TOO_FEW_PARMS;

   hwndTarg = (HWND) GetTokenVal (lptArg-1);
	if (!IsWindow (hwndTarg)) 
		return SetToken (lptDest, TTYPE_NUM, 0, MYFALSE);

	if (!IsIconic (hwndTarg)) 
		ShowWindow (hwndTarg, SW_MINIMIZE);

	return SetToken (lptDest, TTYPE_NUM, 0, MYTRUE);
}
//-----------------------------------------------------------
// LibZoomWin - Function to maximize a window
// Arg 1 - Window handle
//----------------------------------------------------------- 
INT LibZoomWin (LPTOKEN lptDest, LPTOKEN lptArg) {
   HWND     hwndTarg;
   
	if (lptDest->wData <= 1) 
		return ERR_TOO_FEW_PARMS;

   hwndTarg = (HWND) GetTokenVal (lptArg-1);
	if (!IsWindow (hwndTarg)) 
		return SetToken (lptDest, TTYPE_NUM, 0, MYFALSE);

	if (!IsZoomed (hwndTarg)) 
		ShowWindow (hwndTarg, SW_SHOWMAXIMIZED);

	return SetToken (lptDest, TTYPE_NUM, 0, MYTRUE);
}
//-----------------------------------------------------------
// LibRestoreWin - Function to restore a window
// Arg 1 - Window handle
//----------------------------------------------------------- 
INT LibRestoreWin (LPTOKEN lptDest, LPTOKEN lptArg) {
   HWND     hwndTarg;
   
	if (lptDest->wData <= 1) 
		return ERR_TOO_FEW_PARMS;

   hwndTarg = (HWND) GetTokenVal (lptArg-1);
	if (!IsWindow (hwndTarg)) 
		return SetToken (lptDest, TTYPE_NUM, 0, MYFALSE);

	if (IsZoomed (hwndTarg) || IsIconic (hwndTarg)) 
		ShowWindow (hwndTarg, SW_RESTORE);

	return SetToken (lptDest, TTYPE_NUM, 0, MYTRUE);
}
//-----------------------------------------------------------
// LibGetWinPos - Function that returns a window's position
// Arg 1 - Window handle
//----------------------------------------------------------- 
INT LibGetWinPos (LPTOKEN lptDest, LPTOKEN lptArg) {
   INT		sRC = 0;
   HWND     hwndTarg;
   
	if (lptDest->wData <= 1) 
		return ERR_TOO_FEW_PARMS;

   hwndTarg = (HWND) GetTokenVal (lptArg-1);
	if (!IsWindow (hwndTarg)) 
		return SetToken (lptDest, TTYPE_NUM, 0, MYFALSE);

	GetWindowRect (hwndTarg, &rect);
	sRC = SetToken (lptDest, TTYPE_NUM, 0, MAKELONG (rect.left, rect.top));
  	return sRC;
}
//-----------------------------------------------------------
// LibGetWinSize - Function that returns a window's size
// Arg 1 - Window handle
//----------------------------------------------------------- 
INT LibGetWinSize (LPTOKEN lptDest, LPTOKEN lptArg) {
   INT		sRC = 0;
   HWND     hwndTarg;
   
	if (lptDest->wData < 1) 
		return ERR_TOO_FEW_PARMS;

   hwndTarg = (HWND) GetTokenVal (lptArg-1);
	if (!IsWindow (hwndTarg)) 
		return SetToken (lptDest, TTYPE_NUM, 0, MYFALSE);

	GetWindowRect (hwndTarg, &rect);
	sRC = SetToken (lptDest, TTYPE_NUM, 0, 
	                MAKELONG (rect.right-rect.left, rect.bottom-rect.top));
  	return sRC;
}
//-----------------------------------------------------------
// LibGetWinState - Function returns icon/restore/zoomed state
// of a window
// Arg 1 - Window handle
//----------------------------------------------------------- 
INT LibGetWinState (LPTOKEN lptDest, LPTOKEN lptArg) {
   HWND     hwndTarg;
   
	if (lptDest->wData <= 1) 
		return ERR_TOO_FEW_PARMS;

   hwndTarg = (HWND) GetTokenVal (lptArg-1);
	if (!IsWindow (hwndTarg)) 
		return SetToken (lptDest, TTYPE_NUM, 0, MYFALSE);

	if (IsIconic (hwndTarg))
		return SetToken (lptDest, TTYPE_NUM, 0, 2);
	if (IsZoomed (hwndTarg))
		return SetToken (lptDest, TTYPE_NUM, 0, 3);

	return SetToken (lptDest, TTYPE_NUM, 0, 1);
}
//------------------------------------------------------------
// LibGetWindow - Predefined func that returns the Prev, Next,
// owner, and child info on windows.
// Arg 1 - Window handle
// Arg 2 - Relationship
//------------------------------------------------------------ 
INT LibGetWindow (LPTOKEN lptDest, LPTOKEN lptArg) {
	HWND		hWndTarg;
	UINT     wWinSel;
	
	if (lptDest->wData <= 2) 
		return ERR_TOO_FEW_PARMS;
   hWndTarg = (HWND) GetTokenVal (lptArg-1);
	wWinSel = (WORD) GetTokenVal (lptArg-2);

	if (!IsWindow (hWndTarg)) 
		return SetToken (lptDest, TTYPE_NUM, 0, MYFALSE);
	if (wWinSel < 6) {
		hWndTarg = GetWindow (hWndTarg, wWinSel);
	} else
		hWndTarg = GetParent (hWndTarg);
	return SetToken (lptDest, TTYPE_NUM, 0, (DWORD) hWndTarg);
}  	
//------------------------------------------------------------
// LibGetWinEXE - Predefined func that returns the name of the
// EXE that created a window
// Arg 1 - Window handle
//------------------------------------------------------------ 
INT LibGetWinEXE (LPTOKEN lptDest, LPTOKEN lptArg) {
	HWND		hWndTarg;
	
	if (lptDest->wData <= 1) 
		return ERR_TOO_FEW_PARMS;
   hWndTarg = (HWND) GetTokenVal (lptArg-1);

	if (IsWindow (hWndTarg)) {
			GetModuleFileName (GetWindowWord (hWndTarg, GWW_HINSTANCE),
			                   szTemp, sizeof (szTemp));
			return SetToken (lptDest, TTYPE_STR, 0, (DWORD)(LPSTR) szTemp);
	}
	return SetToken (lptDest, TTYPE_NUM, 0, MYFALSE);
}  	
//-----------------------------------------------------------
// File support routines
//-----------------------------------------------------------
//-----------------------------------------------------------
// LibFileExist - Function to test for file existance
// Arg 1 - File name
//----------------------------------------------------------- 
INT LibFileExist (LPTOKEN lptDest, LPTOKEN lptArg) {
   INT		sRC;

	if (lptDest->wData <= 1) 
		return ERR_TOO_FEW_PARMS;

	lstrcpy (szTemp, GetTokenString (lptArg-1));
	sRC = _dos_findfirst (szTemp, _A_HIDDEN | _A_SYSTEM | 
	                     _A_RDONLY | _A_SUBDIR | _A_ARCH, &fs);
	if (sRC == 0)
		sRC = SetToken (lptDest, TTYPE_NUM, 0, MYTRUE);
	else
		sRC = SetToken (lptDest, TTYPE_NUM, 0, MYFALSE);
  	return sRC;
}  	
//-----------------------------------------------------------
// LibFileOpen - Function to open a file
// Arg 1 - File name
//----------------------------------------------------------- 
INT LibFileOpen (LPTOKEN lptDest, LPTOKEN lptArg) {
   INT		sRC = 0;
   UINT		wFlags;
   HFILE		hFile;
	OFSTRUCT	of;
   
	if (lptDest->wData <= 2) 
		return ERR_TOO_FEW_PARMS;

   wFlags = (UINT)GetTokenVal (lptArg-2);
	hFile = OpenFile (GetTokenString(lptArg-1), &of, wFlags);

	if (hFile != HFILE_ERROR) 
		sRC = SetToken (lptDest, TTYPE_NUM, 0, (DWORD) hFile);
	else
		sRC = SetToken (lptDest, TTYPE_NUM, 0, MYFALSE);
  	return sRC;
}  	
//-----------------------------------------------------------
// LibFileRead - Reads data from a file
// Arg 1 - File handle
// Arg 2 - Amount of data to read
//----------------------------------------------------------- 
INT LibFileRead (LPTOKEN lptDest, LPTOKEN lptArg) {
   INT		sRC = 0;
   UINT		i, wAmount;
   HFILE		hFile;
   PBYTE		pbData;
   
	if (lptDest->wData <= 2)
		return ERR_TOO_FEW_PARMS;

	hFile = (HFILE) GetTokenVal (lptArg-1);
	wAmount = (UINT) GetTokenVal (lptArg-2);
	//Added handle check in 1.1
	if ((hFile == 0) || (hFile == -1))
		return ERR_BADHANDLE;

	pbData = (PBYTE) LocalAlloc (LPTR, wAmount+2);
	if (pbData == 0) {
	   sRC = ERR_OUT_OF_MEMORY;
		SetToken (lptDest, TTYPE_NUM, 0, MYFALSE);
	} else {
		wAmount = _lread (hFile, pbData, wAmount);
		if ((wAmount != HFILE_ERROR) && (wAmount > 0)) {
			for (i = 0; i < wAmount; i++) 
				if (*(pbData+i) == '\0')
					*(pbData+i) = ' ';
			*(pbData+i) = '\0';
		  	sRC = SetToken (lptDest, TTYPE_STR, wAmount, (DWORD)(LPBYTE)pbData);
		} else
			sRC = SetToken (lptDest, TTYPE_NUM, 0, -1);
		LocalFree ((HLOCAL)pbData);		
	}
  	return sRC;
}  	
//-----------------------------------------------------------
// LibFileReadLine - Reads a line from a file
// Arg 1 - File handle
//----------------------------------------------------------- 
INT LibFileReadLine (LPTOKEN lptDest, LPTOKEN lptArg) {
   INT		sRC = 0;
   UINT		i, wAmount;
   HFILE		hFile;
   PBYTE		pbData;
   
	if (lptDest->wData <= 1)
		return ERR_TOO_FEW_PARMS;
	hFile = (HFILE) GetTokenVal (lptArg-1);
	//Added handle check in 1.1
	if ((hFile == 0) || (hFile == -1))
		return ERR_BADHANDLE;

	pbData = (PBYTE) LocalAlloc (LPTR, MAXREADLINE);
	if (pbData == 0) {
	   sRC = ERR_OUT_OF_MEMORY;
		SetToken (lptDest, TTYPE_NUM, 0, MYFALSE);
	} else {
		wAmount = _lread (hFile, pbData, MAXREADLINE);
		if ((wAmount != HFILE_ERROR) && (wAmount > 0)) {
			for (i = 0; i < wAmount-2; i++) {
				if (*(pbData+i) == '\0')
					*(pbData+i) = ' ';
				if (*(pbData+i) == 0x0d)
					break;
			}
			*(pbData+i) = '\0';
			i++;
			if (*(pbData+i) == 0x0a)
			   i++;
			_llseek (hFile, (LONG)i - wAmount, 1);
		  	sRC = SetToken (lptDest, TTYPE_STR, wAmount, (DWORD)(LPBYTE)pbData);
		} else
			sRC = SetToken (lptDest, TTYPE_NUM, 0, -1);
		LocalFree ((HLOCAL)pbData);		
	}
  	return sRC;
}  	
//-----------------------------------------------------------
// LibFileWrite - Function to write data to a file
// Arg 1 - File handle
// Arg 2 - Data to write
//----------------------------------------------------------- 
INT LibFileWrite(LPTOKEN lptDest, LPTOKEN lptArg) {
   INT		sRC = 0;
   HFILE		hFile;
   
	if (lptDest->wData <= 2) 
		return ERR_TOO_FEW_PARMS;

   hFile = (HFILE) GetTokenVal (lptArg-1);
   lstrcpy (szTemp, GetTokenString (lptArg-2));
	//Added handle check in 1.1
	if ((hFile == 0) || (hFile == -1))
		return ERR_BADHANDLE;

	sRC = _lwrite (hFile, szTemp, strlen (szTemp));

   if (sRC != HFILE_ERROR)
   	sRC = SetToken (lptDest, TTYPE_NUM, 0, MYTRUE);
	else
		sRC = SetToken (lptDest, TTYPE_NUM, 0, MYFALSE);
  	return sRC;
}  	
//-----------------------------------------------------------
// LibFileWriteLine - Function to write a line to a file
// Arg 1 - File handle
// Arg 2 - Data to write
//----------------------------------------------------------- 
INT LibFileWriteLine (LPTOKEN lptDest, LPTOKEN lptArg) {
   INT		sRC = 0;
   HFILE		hFile;
   
	if (lptDest->wData <= 2) 
		return ERR_TOO_FEW_PARMS;

   hFile = (HFILE) GetTokenVal (lptArg-1);
   lstrcpy (szTemp, GetTokenString (lptArg-2));
	//Added handle check in 1.1
	if ((hFile == 0) || (hFile == -1))
		return ERR_BADHANDLE;

	sRC = _lwrite (hFile, szTemp, strlen (szTemp));
	if (sRC != HFILE_ERROR) {
	   sRC = 0x0a0d;
		_lwrite (hFile, &sRC, 2);
   	sRC = SetToken (lptDest, TTYPE_NUM, 0, MYTRUE);
	} else
		sRC = SetToken (lptDest, TTYPE_NUM, 0, MYFALSE);
  	return sRC;
}  	
//-----------------------------------------------------------
// LibFileSeek - Function to move the file pointer 
// Arg 1 - File handle
// Arg 1 - Offset
// Arg 1 - Seek mode
//----------------------------------------------------------- 
INT LibFileSeek(LPTOKEN lptDest, LPTOKEN lptArg) {
   INT	sFlags;
   HFILE	hFile;
   LONG	lPtr;
   
	if (lptDest->wData <= 3) 
		return ERR_TOO_FEW_PARMS;

   hFile = (HFILE) GetTokenVal (lptArg-1);
   lPtr = GetTokenVal (lptArg-2);
   sFlags = (INT) GetTokenVal (lptArg-3);
	//Added handle check in 1.1
	if ((hFile == 0) || (hFile == -1))
		return ERR_BADHANDLE;

   if (sFlags > 2)
		return SetToken (lptDest, TTYPE_NUM, 0, MYFALSE);

	lPtr = _llseek (hFile, lPtr, sFlags);
	return SetToken (lptDest, TTYPE_NUM, 0, (DWORD)lPtr);
}  	
//-----------------------------------------------------------
// LibFileClose - Function to close a file
// Arg 1 - File handle
//----------------------------------------------------------- 
INT LibFileClose (LPTOKEN lptDest, LPTOKEN lptArg) {
   INT		sRC = 0;
   HFILE		hFile;
   
	if (lptDest->wData <= 1) 
		return ERR_TOO_FEW_PARMS;

   hFile = (HFILE) GetTokenVal (lptArg-1);
	//Added handle check in 1.1
	if ((hFile == 0) || (hFile == -1))
		return ERR_BADHANDLE;

   if (_lclose (hFile) == 0)
   	sRC = SetToken (lptDest, TTYPE_NUM, 0, MYTRUE);
	else
		sRC = SetToken (lptDest, TTYPE_NUM, 0, MYFALSE);
  	return sRC;
}  	
//-----------------------------------------------------------
// Clipboard functions
//----------------------------------------------------------- 
//-----------------------------------------------------------
// LibGetClipText - Function to return text from the clipboard
//----------------------------------------------------------- 
INT LibGetClipText (LPTOKEN lptDest, LPTOKEN lptArg) {
   INT		sRC = 0;
   HANDLE	hClip;
   LPSTR		lpszClipText;
   
	if (!OpenClipboard(hMain))
   	return SetToken (lptDest, TTYPE_NUM, 0, MYFALSE);

	hClip = GetClipboardData (CF_TEXT);
	if (hClip == 0) {
	   CloseClipboard ();
   	return SetToken (lptDest, TTYPE_NUM, 0, MYFALSE);
	}
	lpszClipText = (LPSTR) GlobalLock (hClip);
	if (lpszClipText == 0) {
	   CloseClipboard ();
   	return SetToken (lptDest, TTYPE_NUM, 0, MYFALSE);
	}
	sRC = SetToken (lptDest, TTYPE_STR, 0, (DWORD)lpszClipText);
	GlobalUnlock (hClip);
   CloseClipboard ();
  	return sRC;
}  	
//-----------------------------------------------------------
// LibSetClipText - Function to copy text into the clipboard
// Arg 1 - Text to copy to clipboard
//----------------------------------------------------------- 
INT LibSetClipText (LPTOKEN lptDest, LPTOKEN lptArg) {
   INT		sRC = 0, i, sLen;
   HANDLE	hClip;
   LPSTR		lpszClipText, lpszPtr;
   
	if (lptDest->wData <= 1) 
		return ERR_TOO_FEW_PARMS;

   lpszClipText = GetTokenString (lptArg-1);
   
	sLen = lstrlen (lpszClipText);
	hClip = GlobalAlloc (GHND, sLen+1);
	if (hClip == 0) {
	   sRC = ERR_OUT_OF_MEMORY;
		return sRC;
	}	
	lpszPtr = (LPSTR) GlobalLock (hClip);
	for (i = 0; i <= sLen; i++)
	   *lpszPtr++ = *lpszClipText++;
	GlobalUnlock (hClip);
	
	if (!OpenClipboard(hMain)) {
	   GlobalFree (hClip);
		return SetToken (lptDest, TTYPE_NUM, 0, MYFALSE);
	}
	if (SetClipboardData (CF_TEXT, hClip) == 0) 
   	sRC = SetToken (lptDest, TTYPE_NUM, 0, MYFALSE);
	else
	  	sRC = SetToken (lptDest, TTYPE_NUM, 0, MYTRUE);
   CloseClipboard ();
  	return sRC;
}
//-----------------------------------------------------------
// LibPostMessage - Function to post a message to a window
// Arg 1 - Window handle
// Arg 2 - Message number
// Arg 3 - wParam
// Arg 4 - lParam
//----------------------------------------------------------- 
INT LibPostMessage (LPTOKEN lptDest, LPTOKEN lptArg) {
   HWND		hWnd;
   UINT		wMsg, wParam;
   LONG		lParam;
   
	if (lptDest->wData <= 4) 
		return ERR_TOO_FEW_PARMS;

   hWnd = (HWND) GetTokenVal (lptArg-1);
   wMsg = (UINT) GetTokenVal (lptArg-2);
   wParam = (UINT) GetTokenVal (lptArg-3);
   lParam = GetTokenVal (lptArg-4);
  	return SetToken (lptDest, TTYPE_NUM, 0, 
  	                 (DWORD) PostMessage (hWnd, wMsg, wParam, lParam));   
}
//-----------------------------------------------------------
// LibSendMessage - Function to send a message to a window
// Arg 1 - Window handle
// Arg 2 - Message number
// Arg 3 - wParam
// Arg 4 - lParam
//----------------------------------------------------------- 
INT LibSendMessage (LPTOKEN lptDest, LPTOKEN lptArg) {
   HWND		hWnd;
   UINT		wMsg, wParam;
   LONG		lParam;
   
	if (lptDest->wData <= 4) 
		return ERR_TOO_FEW_PARMS;

   hWnd = (HWND) GetTokenVal (lptArg-1);
   wMsg = (UINT) GetTokenVal (lptArg-2);
   wParam = (UINT) GetTokenVal (lptArg-3);
   lParam = GetTokenVal (lptArg-4);
  	return SetToken (lptDest, TTYPE_NUM, 0, 
  	                 (DWORD) SendMessage (hWnd, wMsg, wParam, lParam));   
}
//-----------------------------------------------------------
// LibSendMCIString - Function that sends an MCI command string to
// the Windows Multimedia drivers.
// Arg 1 - MCI Command String
//----------------------------------------------------------- 
INT LibSendMCIString (LPTOKEN lptDest, LPTOKEN lptArg) {
   DWORD	dwResult;

	if (lptDest->wData <= 1) 
		return ERR_TOO_FEW_PARMS;
   
   szTemp[0] = '\0';
   dwResult = mciSendString (GetTokenString (lptArg-1), szTemp, sizeof (szTemp), hMain);
	if (dwResult) {
	   strcpy (szTemp, "ERROR ");
	   ltoa (dwResult, &szTemp[strlen (szTemp)], 10);
	}  
return SetToken (lptDest, TTYPE_STR, 0, (DWORD) (LPSTR) szTemp);   
}
//-----------------------------------------------------------
// LibGetMCIErrString - Function that querys MCI for an error
// string
// Arg 1 - MCI Error code
//----------------------------------------------------------- 
INT LibGetMCIErrString (LPTOKEN lptDest, LPTOKEN lptArg) {
   DWORD	dwResult;

	if (lptDest->wData <= 1) 
		return ERR_TOO_FEW_PARMS;
   
   szTemp[0] = '\0';
   dwResult = mciGetErrorString (GetTokenVal (lptArg-1), szTemp, sizeof (szTemp));
	if (!dwResult)	
		return SetToken (lptDest, TTYPE_STR, 0, 0);   
	return SetToken (lptDest, TTYPE_STR, 0, (DWORD) (LPSTR) szTemp);   
}
//----------------------------------------------------------------------
// Read File - Allocates a buff in global memory and reads in a file
//----------------------------------------------------------------------
HANDLE LoadFile (LPSTR szFileName) {
   
	OFSTRUCT	ofFile;
	HFILE		hFileHandle;
	HANDLE	hFileBuff;
	UINT		wBytesRead;
	LPBYTE 	lpbFileBuff;

	hFileBuff = GlobalAlloc (GMEM_MOVEABLE | GMEM_ZEROINIT, 65535);
	
	if (hFileBuff == 0) return 0;
	lpbFileBuff = GlobalLock (hFileBuff);

	hFileHandle = OpenFile (szFileName, &ofFile, OF_READ);
	if (hFileHandle == -1) {
	   GlobalUnlock (hFileBuff);
	   GlobalFree (hFileBuff);
	   return ERR_FOPEN_ERR - ofFile.nErrCode;
	}
	wBytesRead = _lread (hFileHandle, lpbFileBuff, (WORD)65534);
	_lclose (hFileHandle);

	if (wBytesRead == 65534) {
	   GlobalUnlock (hFileBuff);
	   GlobalFree (hFileBuff);
	   return ERR_FILE_TOO_BIG;
	}
	*(lpbFileBuff + wBytesRead) = 0;
   GlobalUnlock (hFileBuff);
   GlobalReAlloc (hFileBuff, wBytesRead+1, 0);
   return hFileBuff;
}
//-----------------------------------------------------------
// LibSetWinIcon - Function to set a window's icon
// Arg 1 - Window handle
//----------------------------------------------------------- 
INT LibSetWinIcon (LPTOKEN lptDest, LPTOKEN lptArg) {
   HWND		hWnd;
   UINT		hIcon;
   
	if (lptDest->wData <= 2) 
		return ERR_TOO_FEW_PARMS;

   hWnd = (HWND) GetTokenVal (lptArg-1);
   hIcon = (WORD) GetTokenVal (lptArg-2);
  	hIcon = SetClassWord (hWnd, GCW_HICON, hIcon);
	if (IsIconic (hWnd)) {
		// Do this to force Windows to redraw the icon
		ShowWindow (hWnd, SW_HIDE);
		ShowWindow (hWnd, SW_SHOW);
	}
  	return SetToken (lptDest, TTYPE_NUM, 0, hIcon);
}
//-----------------------------------------------------------
// LibLoadIconFile - Function that reads in an Icon file
// Arg 1 - File Name
// Arg 2 - Icon number to return (Default 1)
//----------------------------------------------------------- 
INT LibLoadIconFile (LPTOKEN lptDest, LPTOKEN lptArg) {
	HICON		hIcon;
	INT		sSelIcon = 0;

	if (lptDest->wData <= 1) 
		return ERR_TOO_FEW_PARMS;
	
	if (lptDest->wData > 2)
		sSelIcon = (INT) GetTokenVal (lptArg-2);
	
	hIcon = ExtractIcon (hInst,GetTokenString (lptArg-1), sSelIcon);
  	return SetToken (lptDest, TTYPE_NUM, 0, (DWORD) hIcon);
}
//-----------------------------------------------------------
// LibGetCWD - Function that returns the current directory
//----------------------------------------------------------- 
INT LibGetCWD (LPTOKEN lptDest, LPTOKEN lptArg) {

	getcwd (szTemp, sizeof (szTemp));	
  	return SetToken (lptDest, TTYPE_STR, 0, (DWORD)(LPSTR)szTemp);
}
//-----------------------------------------------------------
// LibChDrive - Function that changes the default drive
// Arg 1 - Drive letter
//----------------------------------------------------------- 
INT LibChDrive (LPTOKEN lptDest, LPTOKEN lptArg) {

	if (lptDest->wData <= 1) 
		return ERR_TOO_FEW_PARMS;

	if (_chdrive (*(GetTokenString (lptArg-1))-0x40) == 0)
		return SetToken (lptDest, TTYPE_NUM, 0, MYTRUE);
	else
		return SetToken (lptDest, TTYPE_NUM, 0, MYFALSE);
	}

