/* This file is a part of SecureDevice 1.3
   Copyright (C) 1994 by Max Loewenthal and Arthur Helwig
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <bios.h>
#include <dos.h>
#include <string.h>
#include <ctype.h>
#include "md5.h"
#include "usuals.h"
#include "globals.h"

void invgets(char *input);   /* Get without displaying, allow backspace */

#define KEYLEN  KeySize/2    /* length of key schedule in 16-bit words */
#define MinorName "LOGIN"
#define MinorVer "1.01"

void invgets(char *input)
{ unsigned i=0;
  char c;
  while(i<(MaxPwdLen-1))
    { c=getch();
      if(c=='\x0d')
        { printf("\n");
          *input='\0';
          return;
        }
      if(c=='\b')
        { if(i>0)
           { i--;
             input--;
             printf("\b \b");
           }
        }
      else
       { printf("*");
         *input++=c;
         i++;
       }
    }
  }

void md5key(unsigned char signature[16],char *pass1)
{ MD5_CTX md5buf;

  MD5Init(&md5buf);
  MD5Update(&md5buf,pass1,strlen(pass1));
  MD5Final(signature,&md5buf);
}

/*      Compute IDEA encryption subkeys Z */
void en_key_idea(word16 *userkey, word16 *Z)
{ unsigned i,j;
  word16 *Y=Z;
	/*
	 * shifts
	 */
  for (j=0; j<8; j++)
    Z[j] = *userkey++;

  for (i=0; j<KEYLEN; j++)
    { i++;
      Z[i+7] = Z[i & 7] << 9 | Z[i+1 & 7] >> 7;
      Z += i & 8;
      i &= 7;
	}
  for(i=0;i<KEYLEN;i++)
    Y[i]^=0x0dae;
}        /* en_key_idea */

void main(int argc,char *argv[])
{ unsigned char key[16],passphrase[MaxPwdLen];
  word16 expkey[KEYLEN];
  int i,nofdrivers;
  unsigned char Driveletter='\0';
  char DriveOK=0;
  union REGS regs;
  struct SREGS segregs;

  printf("%s %s's %s %s\n",MajorName,MajorVer,MinorName,MinorVer);
  printf("Written by %s\n",AuthorName);

  regs.x.ax = 0xE209;
  regs.x.dx = 0;
  int86x(0x2F, &regs, &regs, &segregs);
  if(regs.x.ax != 0x1DEA)
    { printf("SECDEV.SYS not loaded\n");
      exit(1);
    }
  nofdrivers=regs.x.dx;

  if(argc>1)
    Driveletter=toupper(*argv[1]);

  if(Driveletter)
      for(i=0;i<nofdrivers && !DriveOK;i++)
        { regs.x.ax = 0xE201;            /* Get information */
          regs.x.dx = i;
          int86x(0x2F, &regs, &regs, &segregs);

          DriveOK = ((Driveletter-'A') >= regs.h.dl) &&
                    ((Driveletter-'A') < regs.h.dl+regs.h.al);
        } else
        { regs.x.ax = 0xE201;
          regs.x.dx = 0;     /* Use 1st driver in mem */
          int86x(0x2F, &regs, &regs, &segregs);

          DriveOK=1;
          Driveletter=regs.h.dl+'A';
        }
  if (!DriveOK)
    { printf("Drive %c: is not an encrypted drive\n",Driveletter);
      exit(1);
    }

  if(argc>2)
    { printf("\nLogging in to drive %c:\n",Driveletter);
      for(i=0;argv[2][i];i++)
        { passphrase[i]=argv[2][i];
          argv[2][i]='\0';
        }
      passphrase[i]='\0';
    } else
    { printf("\nEnter passphrase for drive %c: ",Driveletter);
      invgets(passphrase);
    }

  md5key(key,passphrase);
  burn(passphrase);
  en_key_idea((word16 *) key,expkey);

  regs.x.ax = 0xE200;
  regs.h.dl = Driveletter-'A';
  regs.x.si = FP_OFF(expkey);
  segregs.ds = FP_SEG(expkey);
  int86x(0x2F, &regs, &regs, &segregs);

  burn(expkey);

  exit(0);
}
