IDEAL
MODEL       TINY,C

; ***********************************************************************
; ** Copyright (C) 1990, RSA Data Security, Inc. All rights reserved.  **
; **                                                                   **
; ** License to copy and use this software is granted provided that    **
; ** it is identified as the "RSA Data Security, Inc. MD5 Message-     **
; ** Digest Algorithm" in all material mentioning or referencing this  **
; ** software or this function.                                        **
; **                                                                   **
; ** License is also granted to make and use derivative works          **
; ** provided that such works are identified as "derived from the RSA  **
; ** Data Security, Inc. MD5 Message-Digest Algorithm" in all          **
; ** material mentioning or referencing the derived work.              **
; **                                                                   **
; ** RSA Data Security, Inc. makes no representations concerning       **
; ** either the merchantability of this software or the suitability    **
; ** of this software for any particular purpose.  It is provided "as  **
; ** is" without express or implied warranty of any kind.              **
; **                                                                   **
; ** These notices must be retained in any copies of any part of this  **
; ** documentation and/or software.                                    **
; ***********************************************************************

PUBLIC      MD5Init,MD5Update,MD5Final

STRUC       MD5_CTX
            ; typedef struct {
            ;   UINT4 buf[4];                                    /* scratch buffer */
            ;   UINT4 i[2];                   /* number of _bits_ handled mod 2^64 */
            ;   unsigned char inn[64];                              /* input buffer */
            ; } MD5_CTX;
            buf         DD          4 DUP (?)
            i           DW          4 DUP (?)
            inn         DB          64 DUP (?)
ENDS        MD5_CTX

CODESEG

            Padding DB      128, 63 DUP (0)

PROC        MD5Init
            ; void MD5Init ( MD5_CTX far *mdContext)
            ARG         mdContext:DWORD

                        PUSH        ES BX

                        LES         BX,[mdContext]
            ; { mdContext->i[0] = mdContext->i[1] = (UINT4)0;

                        MOV         [WORD PTR (MD5_CTX PTR ES:BX).i],0
                        MOV         [WORD PTR (MD5_CTX PTR ES:BX+2).i],0
                        MOV         [WORD PTR (MD5_CTX PTR ES:BX+4).i],0
                        MOV         [WORD PTR (MD5_CTX PTR ES:BX+6).i],0
            ;   /* Load magic initialization constants.
            ;    */
            ;   mdContext->buf[0] = (UINT4)0x67452301L;
                        MOV         [WORD PTR (MD5_CTX PTR ES:BX).Buf],2301h
                        MOV         [WORD PTR (MD5_CTX PTR ES:BX+2).Buf],6745h
            ;   mdContext->buf[1] = (UINT4)0xefcdab89L;
                        MOV         [WORD PTR (MD5_CTX PTR ES:BX+4).Buf],0AB89h
                        MOV         [WORD PTR (MD5_CTX PTR ES:BX+6).Buf],0EFCDh
            ;   mdContext->buf[2] = (UINT4)0x98badcfeL;
                        MOV         [WORD PTR (MD5_CTX PTR ES:BX+8).Buf],0DCFEh
                        MOV         [WORD PTR (MD5_CTX PTR ES:BX+0Ah).Buf],98BAh
            ;   mdContext->buf[3] = (UINT4)0x10325476L;
                        MOV         [WORD PTR (MD5_CTX PTR ES:BX+0Ch).Buf],5476h
                        MOV         [WORD PTR (MD5_CTX PTR ES:BX+0Eh).Buf],1032h
            ; }
                        POP         BX ES
                        RET
ENDP        MD5Init

PROC        MD5Update
            ASSUME      DS:NOTHING
            ; void MD5Update (MD5_CTX far *mdContext, unsigned char far *inBuf,unsigned int inLen)
            ARG         mdContext:DWORD,inBuf:DWORD,inLen:WORD

            ; { register int i, ii;
            ;   int mdi;
            ;   UINT4 inn[16];

            ; BX = mdi

            ;   /* compute number of bytes mod 64 */
            ;   mdi = (int)((mdContext->i[0] >> 3) & 0x3F);
                        PUSH        ES DS SI DI AX BX CX DX

                        LES         DI,[mdContext]

                        MOV         BX,[WORD PTR (MD5_CTX PTR ES:DI).i]
                        SHR         BX,1
                        SHR         BX,1
                        SHR         BX,1
                        AND         BX,3Fh

            ;   /* update number of bits */
            ;   if ((mdContext->i[0] + ((UINT4)inLen << 3)) < mdContext->i[0]) mdContext->i[1]++;
            ;   mdContext->i[0] += ((UINT4)inLen << 3);
            ;   mdContext->i[1] += ((UINT4)inLen >> 29);                ?? always 0
                        MOV         AX,[inLen]
                        MOV         CX,0
                        SHL         AX,1
                        RCL         CX,1
                        SHL         AX,1
                        RCL         CX,1
                        SHL         AX,1
                        RCL         CX,1
                        ADD         [WORD PTR (MD5_CTX PTR ES:DI).i],AX
                        ADC         [WORD PTR (MD5_CTX PTR ES:DI+2).i],CX
                        ADC         [WORD PTR (MD5_CTX PTR ES:DI+4).i],0
                        ADC         [WORD PTR (MD5_CTX PTR ES:DI+6).i],0

            ;   while (inLen--) {
                        MOV         CX,[InLen]
                        JCXZ        @@Finished

            ;     /* add new character to buffer, increment mdi */
            ;     mdContext->inn[mdi++] = *inBuf++;
                        LDS         SI,[inBuf]
                        CLD

            @@Next:     LODSB
                        MOV         [(MD5_CTX PTR ES:DI+BX).inn],AL
                        INC         BX

            ;     /* transform if necessary */
            ;     if (mdi == 0x40) {
                        CMP         BX,40h
                        JNE         @@EndLoop
            ;       for (i = 0, ii = 0; i < 16; i++, ii += 4)           unnecessary!
            ;         inn[i] = (((UINT4)mdContext->inn[ii+3]) << 24) |
            ;                 (((UINT4)mdContext->inn[ii+2]) << 16) |
            ;                 (((UINT4)mdContext->inn[ii+1]) << 8) |
            ;                 ((UINT4)mdContext->inn[ii]);

            ;       Transform (mdContext->buf, inn);
                        LEA         AX,[WORD PTR (MD5_CTX PTR ES:DI).inn]
                        PUSH        ES AX
                        LEA         AX,[WORD PTR (MD5_CTX PTR ES:DI).buf]
                        PUSH        ES AX
                        CALL        Transform
                        POP         AX AX AX AX

            ;       mdi = 0;
                        MOV         BX,0
            ;     }
            ;   }
            @@EndLoop:  LOOP        @@Next
            @@Finished:

                        POP         DX CX BX AX DI SI DS ES
                        RET

ENDP        MD5Update

PROC        MD5Final
            ; void MD5Final (unsigned char far digest[16], MD5_CTX *mdContext)
                        ARG         digest:DWORD,mdContext:DWORD
                        LOCAL       NofBits:WORD:4

            ; { UINT4 inn[16];
            ;   int mdi;
            ;   unsigned int i, ii;
            ;   unsigned int padLen;
                        PUSH        ES DS SI DI AX BX CX
                        LES         DI,[mdContext]

            ;  /* save number of bits */
            ;  inn[14] = mdContext->i[0];
            ;  inn[15] = mdContext->i[1];

                        MOV         AX,[(MD5_CTX PTR ES:DI).i]
                        MOV         [NofBits],AX
                        MOV         AX,[(MD5_CTX PTR ES:DI+2).i]
                        MOV         [NofBits+2],AX
                        MOV         AX,[(MD5_CTX PTR ES:DI+4).i]
                        MOV         [NofBits+4],AX
                        MOV         AX,[(MD5_CTX PTR ES:DI+6).i]
                        MOV         [NofBits+6],AX

            ;   /* compute number of bytes mod 64 */
            ;   mdi = (int)((mdContext->i[0] >> 3) & 0x3F);

                        MOV         BX,[WORD PTR (MD5_CTX PTR ES:DI).i]
                        SHR         BX,1
                        SHR         BX,1
                        SHR         BX,1
                        AND         BX,3Fh

            ;   /* pad out to 56 mod 64 */
            ;   padLen = (mdi < 56) ? (56 - mdi) : (120 - mdi);
                        MOV         CX,56
                        CMP         BX,56
                        JB          @0
                        MOV         CX,120
            @0:         SUB         CX,BX

            ;   MD5Update (mdContext, PADDING, padLen);
                        MOV         AX,OFFSET Padding
                        PUSH        CX CS AX ES DI
                        CALL        MD5Update
                        ADD         SP,0Ah

            ;   /* append length inn bits and transform */
            ;   for (i = 0, ii = 0; i < 14; i++, ii += 4)
            ;    inn[i] = (((UINT4)mdContext->inn[ii+3]) << 24) |
            ;      (((UINT4)mdContext->inn[ii+2]) << 16) |
            ;      (((UINT4)mdContext->inn[ii+1]) << 8) |
            ;      ((UINT4)mdContext->inn[ii]);

                        MOV         AX,[NofBits]
                        MOV         [WORD PTR (MD5_CTX PTR ES:DI+4*14).inn],AX
                        MOV         AX,[NofBits+2]
                        MOV         [WORD PTR (MD5_CTX PTR ES:DI+4*14+2).inn],AX
                        MOV         AX,[NofBits+4]
                        MOV         [WORD PTR (MD5_CTX PTR ES:DI+4*15).inn],AX
                        MOV         AX,[NofBits+6]
                        MOV         [WORD PTR (MD5_CTX PTR ES:DI+4*15+2).inn],AX

            ;   Transform (mdContext->buf, inn);
                        LEA         AX,[(MD5_CTX PTR ES:DI).inn]
                        PUSH        ES AX
                        LEA         AX,[(MD5_CTX PTR ES:DI).buf]
                        PUSH        ES AX
                        CALL        Transform
                        POP         AX AX AX AX

            ;   /* store buffer inn digest */
            ;   for (i = 0, ii = 0; i < 4; i++, ii += 4) {
            ;     digest[ii]   = (unsigned char) (mdContext->buf[i]        & 0xFF);
            ;     digest[ii+1] = (unsigned char)((mdContext->buf[i] >> 8)  & 0xFF);
            ;     digest[ii+2] = (unsigned char)((mdContext->buf[i] >> 16) & 0xFF);
            ;     digest[ii+3] = (unsigned char)((mdContext->buf[i] >> 24) & 0xFF);
                        LEA         SI,[(MD5_CTX PTR ES:DI).buf]
                        PUSH        ES
                        LES         DI,[digest]
                        POP         DS
                        CLD
                        MOV         CX,8
                        REP         MOVSW
            ;   }
            ; }
                        POP         CX BX AX DI SI DS ES
                        RET
ENDP        MD5Final

PROC        RotateLeft
            ; #define ROTATE_LEFT(x, n) (((x) << (n)) | ((x) >> (32-(n))))

            ; DS:SI target
            ; CX = count

                        XCHG        AX,[WORD PTR DS:SI]
                        XCHG        DX,[WORD PTR DS:SI+2]
                        PUSH        SI DI BX CX

                        TEST        CX,10h
                        JE          @@0

                        XCHG        AX,DX
                        AND         CX,0Fh

            @@0:        ROL         AX,CL
                        ROL         DX,CL

                        MOV         SI,1
                        SHL         SI,CL
                        DEC         SI
                        MOV         DI,SI
                        NOT         DI

                        MOV         BX,AX
                        MOV         CX,DX
                        AND         BX,SI
                        AND         CX,SI
                        AND         AX,DI
                        AND         DX,DI
                        OR          DX,BX
                        OR          AX,CX

                        POP         CX BX DI SI
                        XCHG        AX,[WORD PTR DS:SI]
                        XCHG        DX,[WORD PTR DS:SI+2]
                        RET

ENDP        RotateLeft

PROC        F           NEAR
            ; #define F(b, c, d) (((b) & (c)) | ((~b) & (d)))
            ; SI->c, BX->d, CX & AX dummy's
                        PUSH        CX BX
                        XCHG        DX,SI
                        XCHG        BX,AX
                        MOV         AX,[WORD PTR DS:DI+2]   ; hi b
                        MOV         CX,AX
                        AND         AX,[WORD PTR DS:SI+2]   ; hi c
                        NOT         CX
                        AND         CX,[WORD PTR DS:BX+2]   ; hi d
                        OR          AX,CX
                        PUSH        AX                                  ; = hi result
                        MOV         AX,[WORD PTR DS:DI]     ; lo b
                        MOV         CX,AX
                        AND         AX,[WORD PTR DS:SI]     ; lo c
                        NOT         CX
                        AND         CX,[WORD PTR DS:BX]     ; lo d
                        OR          AX,CX
                        PUSH        AX                                  ; = lo result
                        XCHG        AX,BX
                        XCHG        DX,SI
                        POP         CX                                  ; = lo result
                        ADD         [WORD PTR DS:SI],CX     ; lo a
                        POP         CX                                  ; = hi result
                        ADC         [WORD PTR DS:SI+2],CX   ; hi a
                        POP         BX CX
                        RET
ENDP        F
PROC        G
            ; #define G(b, c, d) (((b) & (d)) | ((c) & (~d)))  = F(
                        PUSH        CX BX
                        XCHG        DX,SI
                        XCHG        BX,AX
            ; SI->c, BX->d, CX & AX dummy's
                        MOV         AX,[WORD PTR DS:BX+2]   ; hi d
                        MOV         CX,AX
                        AND         AX,[WORD PTR DS:DI+2]   ; hi b
                        NOT         CX
                        AND         CX,[WORD PTR DS:SI+2]   ; hi c
                        OR          AX,CX
                        PUSH        AX                                  ; = hi result
                        MOV         AX,[WORD PTR DS:BX]     ; lo d
                        MOV         CX,AX
                        AND         AX,[WORD PTR DS:DI]     ; lo b
                        NOT         CX
                        AND         CX,[WORD PTR DS:SI]     ; lo c
                        OR          AX,CX
                        PUSH        AX                                  ; = lo result
                        XCHG        AX,BX
                        XCHG        DX,SI
                        POP         CX                                  ; = lo result
                        ADD         [WORD PTR DS:SI],CX     ; lo a
                        POP         CX                                  ; = hi result
                        ADC         [WORD PTR DS:SI+2],CX   ; hi a
                        POP         BX CX
                        RET
ENDP        G
PROC        H
            ; #define H(b, c, d) ((b) ^ (c) ^ (d))
                        PUSH        CX
                        XCHG        DX,SI
                        XCHG        BX,AX
            ; SI->c, BX->d, CX dummy
                        MOV         CX,[WORD PTR DS:DI+2]   ; hi b
                        XOR         CX,[WORD PTR DS:SI+2]   ; hi c
                        XOR         CX,[WORD PTR DS:BX+2]   ; hi d
                        PUSH        CX                                  ; = hi result
                        MOV         CX,[WORD PTR DS:DI]     ; lo b
                        XOR         CX,[WORD PTR DS:SI]     ; lo c
                        XOR         CX,[WORD PTR DS:BX]     ; lo d

                        XCHG        AX,BX
                        XCHG        DX,SI

                        ADD         [WORD PTR DS:SI],CX     ; lo a
                        POP         CX                                  ; = hi result
                        ADC         [WORD PTR DS:SI+2],CX   ; hi a
                        POP         CX
                        RET
ENDP        H
PROC        I
                        PUSH        CX
                        XCHG        DX,SI
                        XCHG        BX,AX
            ; SI->c, BX->d, CX dummy
                        MOV         CX,[WORD PTR DS:BX+2]   ; hi d
                        NOT         CX
                        OR          CX,[WORD PTR DS:DI+2]   ; hi b
                        XOR         CX,[WORD PTR DS:SI+2]   ; hi c
                        PUSH        CX                                  ; = hi result
                        MOV         CX,[WORD PTR DS:BX]     ; hi d
                        NOT         CX
                        OR          CX,[WORD PTR DS:DI]     ; hi b
                        XOR         CX,[WORD PTR DS:SI]     ; hi c

                        XCHG        AX,BX
                        XCHG        DX,SI

                        ADD         [WORD PTR DS:SI],CX     ; lo a
                        POP         CX                                  ; = hi result
                        ADC         [WORD PTR DS:SI+2],CX   ; hi a
                        POP         CX
                        RET
ENDP        I

PROC        FFGGHHII
            ARG         SUBAlgo:WORD
            ; #define FF(a, b, c, d, x, s, ac) \
            ;  {(a) += F ((b), (c), (d)) + (x) + (UINT4)(ac); \
            ;   (a) = ROTATE_LEFT ((a), (s)); \
            ;   (a) += (b); \
            ;  }
            ;   SI->a, DI->b, DX->c, AX->d, ES:CX->x, BX->ac,s


            ; SI->c, BX->d, CX & AX dummy's
                        CALL        [SubAlgo]


                        XCHG        BP,CX
                        PUSH        CX
            ; CX dummy, ES:BP->x
                        MOV         CX,[WORD PTR ES:BP]     ; lo x
                        ADD         [WORD PTR DS:SI],CX     ; lo a
                        MOV         CX,[WORD PTR ES:BP+2]   ; hi x
                        ADC         [WORD PTR DS:SI+2],CX   ; hi a
                        MOV         CX,[WORD PTR DS:BX]     ; lo ac
                        ADD         [WORD PTR DS:SI],CX     ; lo a
                        MOV         CX,[WORD PTR DS:BX+2]   ; hi ac
                        ADC         [WORD PTR DS:SI+2],CX   ; hi a

                        MOV         CX,[WORD PTR DS:BX+4]   ; s
                        CALL        RotateLeft

                        MOV         CX,[WORD PTR DS:DI]     ; lo b
                        ADD         [WORD PTR DS:SI],CX     ; lo a
                        MOV         CX,[WORD PTR DS:DI+2]   ; hi b
                        ADC         [WORD PTR DS:SI+2],CX   ; hi a
                        MOV         CX,BP

                        POP         BP
                        RET
ENDP        FFGGHHII

PROC        Transform
            ; void Transform(register UINT4 *buf,register UINT4 *in)
            ARG         buf:DWORD,inn:DWORD

                        PUSH        ES DS SI DI AX BX CX DX

            ; register UINT4 a = buf[0], b = buf[1], c = buf[2], d = buf[3];
                        LDS         SI,[buf]
                        PUSH        CS
                        POP         ES
                        LEA         DI,[a]
                        CLD
                        MOV         CX,8
                        REP         MOVSW
                        PUSH        CS
                        POP         DS

                        PUSH        BP
                        MOV         AX,OFFSET I
                        PUSH        AX
                        MOV         AX,OFFSET H
                        PUSH        AX
                        MOV         AX,OFFSET G
                        PUSH        AX
                        MOV         AX,OFFSET F
                        PUSH        AX
;   SI->a, DI->b, DX->c, AX->d, ES:CX->x, BX->ac,s
                        LES         CX,[inn]
                        MOV         [Offinn],CX
                        LEA         SI,[a]
                        LEA         DI,[b]
                        LEA         DX,[c]
                        LEA         AX,[d]
                        LEA         BX,[acsTable]

;  /* Round 1 */
; FF ( a, b, c, d, in[ 0], S11, 0xD76AA478L); /* 1 */
; FF ( d, a, b, c, in[ 1], S12, 0xE8C7B756L); /* 2 */
; FF ( c, d, a, b, in[ 2], S13, 0x242070DBL); /* 3 */
; FF ( b, c, d, a, in[ 3], S14, 0xC1BDCEEEL); /* 4 */
; FF ( a, b, c, d, in[ 4], S11, 0xF57C0FAFL); /* 5 */
; FF ( d, a, b, c, in[ 5], S12, 0x4787C62AL); /* 6 */
; FF ( c, d, a, b, in[ 6], S13, 0xA8304613L); /* 7 */
; FF ( b, c, d, a, in[ 7], S14, 0xFD469501L); /* 8 */
; FF ( a, b, c, d, in[ 8], S11, 0x698098D8L); /* 9 */
; FF ( d, a, b, c, in[ 9], S12, 0x8B44F7AFL); /* 10 */
; FF ( c, d, a, b, in[10], S13, 0xFFFF5BB1L); /* 11 */
; FF ( b, c, d, a, in[11], S14, 0x895CD7BEL); /* 12 */
; FF ( a, b, c, d, in[12], S11, 0x6B901122L); /* 13 */
; FF ( d, a, b, c, in[13], S12, 0xFD987193L); /* 14 */
; FF ( c, d, a, b, in[14], S13, 0xA679438EL); /* 15 */
; FF ( b, c, d, a, in[15], S14, 0x49B40821L); /* 16 */

                        MOV         BP,16

            @@NextFF:   CALL        FFGGHHII
                        ADD         BX,6
                        ADD         CX,4

                        PUSH        SI DI DX AX
                        POP         SI AX DX DI
                        DEC         BP
                        JNZ         @@NextFF

                        ADD         SP,2


;  /* Round 2 */
;  GG ( a, b, c, d, in[ 1], S21, 0xF61E2562L); /* 17 */
;  GG ( d, a, b, c, in[ 6], S22, 0xC040B340L); /* 18 */
;  GG ( c, d, a, b, in[11], S23, 0x265E5A51L); /* 19 */
;  GG ( b, c, d, a, in[ 0], S24, 0xE9B6C7AAL); /* 20 */
;  GG ( a, b, c, d, in[ 5], S21, 0xD62F105DL); /* 21 */
;  GG ( d, a, b, c, in[10], S22, 0x02441453L); /* 22 */
;  GG ( c, d, a, b, in[15], S23, 0xD8A1E681L); /* 23 */
;  GG ( b, c, d, a, in[ 4], S24, 0xE7D3FBC8L); /* 24 */
;  GG ( a, b, c, d, in[ 9], S21, 0x21E1CDE6L); /* 25 */
;  GG ( d, a, b, c, in[14], S22, 0xC33707D6L); /* 26 */
;  GG ( c, d, a, b, in[ 3], S23, 0xF4D50D87L); /* 27 */
;  GG ( b, c, d, a, in[ 8], S24, 0x455A14EDL); /* 28 */
;  GG ( a, b, c, d, in[13], S21, 0xA9E3E905L); /* 29 */
;  GG ( d, a, b, c, in[ 2], S22, 0xFCEFA3F8L); /* 30 */
;  GG ( c, d, a, b, in[ 7], S23, 0x676F02D9L); /* 31 */
;  GG ( b, c, d, a, in[12], S24, 0x8D2A4C8AL); /* 32 */

                        MOV         CX,[Offinn]
                        ADD         CX,4

                        MOV         BP,16

            @@NextGG:   CALL        FFGGHHII
                        ADD         BX,6
                        ADD         CX,5*4
                        SUB         CX,[Offinn]
                        AND         CX,4*0Fh
                        ADD         CX,[Offinn]
                        PUSH        SI DI DX AX
                        POP         SI AX DX DI
                        DEC         BP
                        JNZ         @@NextGG

                        ADD         SP,2

;  /* Round 3 */
;  HH ( a, b, c, d, in[ 5], S31, 0xFFFA3942L); /* 33 */
;  HH ( d, a, b, c, in[ 8], S32, 0x8771F681L); /* 34 */
;  HH ( c, d, a, b, in[11], S33, 0x6D9D6122L); /* 35 */
;  HH ( b, c, d, a, in[14], S34, 0xFDE5380CL); /* 36 */
;  HH ( a, b, c, d, in[ 1], S31, 0xA4BEEA44L); /* 37 */
;  HH ( d, a, b, c, in[ 4], S32, 0x4BDECFA9L); /* 38 */
;  HH ( c, d, a, b, in[ 7], S33, 0xF6BB4B60L); /* 39 */
;  HH ( b, c, d, a, in[10], S34, 0xBEBFBC70L); /* 40 */
;  HH ( a, b, c, d, in[13], S31, 0x289B7EC6L); /* 41 */
;  HH ( d, a, b, c, in[ 0], S32, 0xEAA127FAL); /* 42 */
;  HH ( c, d, a, b, in[ 3], S33, 0xD4EF3085L); /* 43 */
;  HH ( b, c, d, a, in[ 6], S34, 0x04881D05L); /* 44 */
;  HH ( a, b, c, d, in[ 9], S31, 0xD9D4D039L); /* 45 */
;  HH ( d, a, b, c, in[12], S32, 0xE6DB99E5L); /* 46 */
;  HH ( c, d, a, b, in[15], S33, 0x1FA27CF8L); /* 47 */
;  HH ( b, c, d, a, in[ 2], S34, 0xC4AC5665L); /* 48 */

                        MOV         CX,[Offinn]
                        ADD         CX,5*4

                        MOV         BP,16

            @@NextHH:   CALL        FFGGHHII
                        ADD         BX,6
                        ADD         CX,3*4
                        SUB         CX,[Offinn]
                        AND         CX,4*0Fh
                        ADD         CX,[Offinn]
                        PUSH        SI DI DX AX
                        POP         SI AX DX DI
                        DEC         BP
                        JNZ         @@NextHH

                        ADD         SP,2

;  /* Round 4 */
;  II ( a, b, c, d, in[ 0], S41, 0xF4292244L); /* 49 */
;  II ( d, a, b, c, in[ 7], S42, 0x432AFF97L); /* 50 */
;  II ( c, d, a, b, in[14], S43, 0xAB9423A7L); /* 51 */
;  II ( b, c, d, a, in[ 5], S44, 0xFC93A039L); /* 52 */
;  II ( a, b, c, d, in[12], S41, 0x655B59C3L); /* 53 */
;  II ( d, a, b, c, in[ 3], S42, 0x8F0CCC92L); /* 54 */
;  II ( c, d, a, b, in[10], S43, 0xFFEFF47DL); /* 55 */
;  II ( b, c, d, a, in[ 1], S44, 0x85845DD1L); /* 56 */
;  II ( a, b, c, d, in[ 8], S41, 0x6FA87E4FL); /* 57 */
;  II ( d, a, b, c, in[15], S42, 0xFE2CE6E0L); /* 58 */
;  II ( c, d, a, b, in[ 6], S43, 0xA3014314L); /* 59 */
;  II ( b, c, d, a, in[13], S44, 0x4E0811A1L); /* 60 */
;  II ( a, b, c, d, in[ 4], S41, 0xF7537E82L); /* 61 */
;  II ( d, a, b, c, in[11], S42, 0xBD3AF235L); /* 62 */
;  II ( c, d, a, b, in[ 2], S43, 0x2AD7D2BBL); /* 63 */
;  II ( b, c, d, a, in[ 9], S44, 0xEB86D391L); /* 64 */

                        MOV         CX,[Offinn]

                        MOV         BP,16

            @@NextII:   CALL        FFGGHHII
                        ADD         BX,6
                        ADD         CX,7*4
                        SUB         CX,[Offinn]
                        AND         CX,4*0Fh
                        ADD         CX,[Offinn]
                        PUSH        SI DI DX AX
                        POP         SI AX DX DI
                        DEC         BP
                        JNZ         @@NextII

                        ADD         SP,2

                        POP         BP

;  buf[0] += a;
                        LES         DI,[buf]
                        MOV         AX,[WORD PTR a]
                        MOV         DX,[WORD PTR a+2]
                        ADD         [WORD PTR ES:DI],AX
                        ADC         [WORD PTR ES:DI+2],DX
;  buf[1] += b;
                        MOV         AX,[WORD PTR b]
                        MOV         DX,[WORD PTR b+2]
                        ADD         [WORD PTR ES:DI+4],AX
                        ADC         [WORD PTR ES:DI+6],DX
;  buf[2] += c;
                        MOV         AX,[WORD PTR c]
                        MOV         DX,[WORD PTR c+2]
                        ADD         [WORD PTR ES:DI+8],AX
                        ADC         [WORD PTR ES:DI+0Ah],DX
;  buf[3] += d;
                        MOV         AX,[WORD PTR d]
                        MOV         DX,[WORD PTR d+2]
                        ADD         [WORD PTR ES:DI+0Ch],AX
                        ADC         [WORD PTR ES:DI+0Eh],DX
;}
                        POP         DX CX BX AX DI SI DS ES
                        RET


S11=7
S12=12
S13=17
S14=22
S21=5
S22=9
S23=14
S24=20
S31=4
S32=11
S33=16
S34=23
S41=6
S42=10
S43=15
S44=21

a           DD          ?
b           DD          ?
c           DD          ?
d           DD          ?
OffInn      DW          ?

STRUC       acsItem
                        ac          DD          ?
                        s           DW          ?
ENDS        acsItem

acsTable    acsItem     <0D76AA478h,S11>,<0E8C7B756h,S12>,<0242070DBh,S13>,<0C1BDCEEEh,S14>
            acsItem     <0F57C0FAFh,S11>,<04787C62Ah,S12>,<0A8304613h,S13>,<0FD469501h,S14>
            acsItem     <0698098D8h,S11>,<08B44F7AFh,S12>,<0FFFF5BB1h,S13>,<0895CD7BEh,S14>
            acsItem     <06B901122h,S11>,<0FD987193h,S12>,<0A679438Eh,S13>,<049B40821h,S14>
            acsItem     <0F61E2562h,S21>,<0C040B340h,S22>,<0265E5A51h,S23>,<0E9B6C7AAh,S24>
            acsItem     <0D62F105Dh,S21>,<002441453h,S22>,<0D8A1E681h,S23>,<0E7D3FBC8h,S24>
            acsItem     <021E1CDE6h,S21>,<0C33707D6h,S22>,<0F4D50D87h,S23>,<0455A14EDh,S24>
            acsItem     <0A9E3E905h,S21>,<0FCEFA3F8h,S22>,<0676F02D9h,S23>,<08D2A4C8Ah,S24>
            acsItem     <0FFFA3942h,S31>,<08771F681h,S32>,<06D9D6122h,S33>,<0FDE5380Ch,S34>
            acsItem     <0A4BEEA44h,S31>,<04BDECFA9h,S32>,<0F6BB4B60h,S33>,<0BEBFBC70h,S34>
            acsItem     <0289B7EC6h,S31>,<0EAA127FAh,S32>,<0D4EF3085h,S33>,<004881D05h,S34>
            acsItem     <0D9D4D039h,S31>,<0E6DB99E5h,S32>,<01FA27CF8h,S33>,<0C4AC5665h,S34>
            acsItem     <0F4292244h,S41>,<0432AFF97h,S42>,<0AB9423A7h,S43>,<0FC93A039h,S44>
            acsItem     <0655B59C3h,S41>,<08F0CCC92h,S42>,<0FFEFF47Dh,S43>,<085845DD1h,S44>
            acsItem     <06FA87E4Fh,S41>,<0FE2CE6E0h,S42>,<0A3014314h,S43>,<04E0811A1h,S44>
            acsItem     <0F7537E82h,S41>,<0BD3AF235h,S42>,<02AD7D2BBh,S43>,<0EB86D391h,S44>
ENDP        Transform
END


END
