
 Rem * Filename: dnddoor.bas  Version: v4.0 r1.0
 Rem * This subprogram contains the main input loop and most common routines.

 Rem $Include: 'dnddoor.inc'

 '  main program. all processing starts here.
 On Error Resume Next ' error trapping
 Clear ,,4096 ' increase stack space
 Randomize Timer ' reseed random generator
 Call Read.Config ' loads all necessary variables, and configuration
 Call Login ' logs in local or remote player
 Do ' main input loop
    Call Encounter.Monster ' search for random monster encounter
    Call Health.Update ' increment/decrement player statistics
    Call Monster.Attack ' search for active monsters that attack
    Call New.Stats ' recalculate player statistics
    Call Restricted.Login ' compute restrictive time
    Call Rust.Weapon ' get weapon rusting rate
    Call Steal.Treasure ' get treasure stealing rate
    Call Set.Clock ' reset hanging clock
    Call Sorter ' sorts player inventory
    If Room.Rate=False Then ' compare room rate reset
       Call Status.Line(False) ' redisplay status line with player statistics
    Endif
    Call Main.Input ' get and process player input
 Loop ' end main input loop
 End ' prevent drop through of loop into routines

 Rem * routine to process action prompt input. all commands processed
 Rem * in this routine call most major routines.

Sub Main.Input
 On Local Error Resume Next ' local error resume
 Graphics.Off=False ' ansi/color on
 Outpt=Action.Prompt ' set prompt (normally Do? is brief, Action? is verbose)
 Call IO.I ' get player command input
 If Len(Func.Buffer) Then ' process funtion key during remote player on
    Function.Key.Number=Asc(Func.Buffer) ' convert function key to variable
    Func.Buffer=Nul ' reset function key buffer to null
    Call Function.Key(Function.Key.Number) ' process function key
    Exit Sub ' exit routine
 Endif ' end process function key
 Inpt=Ltrim$(Inpt) ' strip leading blanks from command
 If Inpt="?" Then ' command is a question mark
    Graphics.Off=True ' ansi/color to white
    Outpt="Type Hint for for short help, Help for detailed help," ' message
    Call IO.O ' send help output
    Outpt="Catalog for command list, or Commands for detailed command list."
    Call IO.O ' send help output
    Graphics.Off=False ' set ansi/color on
    Exit Sub ' return to main
 Endif ' end question mark command
 Sysop.Command=False ' set sysop entered command flag to false
 If Left$(Inpt,1)="!" Then ' sysop entered a command (sysop prefix of !)
    Sysop.Command=True ' set sysop entered command flag to true
    If Normal.User Then ' verify player has no special character
       Sysop.Command=False ' reset sysop command flag
       Outpt="That command is reserved for DMs only!" ' format message
       Call IO.O ' send output
       Exit Sub ' return to main
    Endif ' end verify normal player
    If Len(Inpt)<=1 Then ' length of command is too brief
       Sysop.Command=False ' reset sysop command flag
       Outpt="That DM command is reserved for DMs only!" ' message
       Call IO.O ' send output
       Exit Sub ' return to main
    Endif ' end compare command length
 Endif ' end compute sysop entered a command
 Stored.Parsed.Command1=Inpt ' store the original command entered
 Inpt=Ucase$(Inpt) ' convert original command to upper case
 Stored.Parsed.Command2=Inpt ' store the upper case command
 Restore Strip.Data ' reset data pointer
 For Strip.Pronouns=1 To 70 ' read through pronouns
    Read Pronoun$ ' read next pronoun
    Pronoun$=" "+Pronoun$+" " ' append blanks
    Strip.Word=Instr(Inpt,Pronoun$) ' get position of pronoun in command
    Do While Strip.Word ' loop while pronouns in command
       ' remove pronoun
       Inpt=Left$(Inpt,Strip.Word-1)+Mid$(Inpt,Strip.Word+Len(Pronoun$)-1)
       Strip.Word=Instr(Inpt,Pronoun$) ' get position of next pronoun
    Loop ' end loop through command
 Next ' end loop through pronouns
 If Left$(Inpt,1)="\" Then ' verify command is the repeat command character
    User.Command=Previous.Command1 ' restore previous command
    Stored.Parsed.Command1=Previous.Command2 ' restore previous parsed
    Stored.Parsed.Command2=Previous.Command3 ' restore previous parsed
 Else ' not the repeat command
    User.Command=Inpt ' store original command
    Previous.Command1=User.Command ' store original command
    Previous.Command2=Stored.Parsed.Command1 ' store original command
    Previous.Command3=Stored.Parsed.Command2 ' store upper case command
 Endif ' end compare repeat command
 If User.Command=Nul Then ' command entered is null
    Exit Sub ' return to main
 Endif ' end command is null
 Magic.Spell=False ' reset magic spell is being cast flag
 Command.Name=User.Command ' store command entered
 If Instr(Command.Name," ") Then ' check temporary command variable for space
    Command.Name=Left$(Command.Name,Instr(Command.Name," ")-1) ' parse left of
 Endif ' space and store in temporary variable
 Parser=Instr(User.Command," ") ' set parsed flag if command has space
 If Parser=False Then ' check command has no space/parameters
    If Sysop.Command Then ' command entered is sysop command
       Restore SysopCommands1 ' reset data pointer
       Command.Number=False ' set variable containing command number to false
       Command.Name=Mid$(Command.Name,2) ' strip leading ! from command
       For Last.Command.Number=1 To 9 ' loop to read all nine sysop comands
          Read Outpt ' read command
          If Left$(Outpt,Len(Command.Name))=Command.Name Then ' compare to
             Command.Number=Last.Command.Number ' and store command number
             OutX$=Outpt ' store command from data
             Exit For ' exit the loop, command found
          Endif ' end compare
       Next ' end data read loop
       If Command.Number=False Then ' no command found
          Outpt="Unknown command. Type !Hint for help." ' message
          Call IO.O ' send output
          Exit Sub ' return to main
       Endif ' end check command variable
       Last.Command=OutX$ ' store data command
       Last.Command.Number=Command.Number ' store command number
       Select Case Command.Number ' select routine to call
       Case 1 ' abort function
          Call Abort
       Case 2 ' hint display
          Call Out.File("dmhint.doc")
       Case 3 ' summon random monster
          Call Call.Monster
       Case 4 ' editor routine
          Call Put.User.Record ' store player stats
          Call Editor ' editor routine
       Case 5 ' read dm help
          Stored.Parsed.Command1="HELP" ' help text to search for
          Call Read.Help(True) ' true equals read dmhelp
       Case 6 ' toggle sysop invisible status
          Call Toggle.Invisible
       Case 7 ' enter room link edit routine
          Call Link.Room
       Case 9 ' display memory, free data space
          Call Display.Memory
       End Select ' end select routine
    Else ' command entered is not sysop command
       If User.Command="OU" Then ' compare player command to parse of OUT
          User.Command="O" ' reset player command to abbreviation of out
       Endif ' end compare player command
       If User.Command="OUT" Then ' compare player command to parse of OUT
          User.Command="O" ' reset player command to abbreviation of out
       Endif ' end compare player command
       ' routine to verify command entered is direction
       Call Get.Direction(Direction.Number)
       If Direction.Number Then ' returned variable true if direction
          Call Go.Direction(Direction.Number) ' routine goes certain direction
          Exit Sub ' return to main
       Endif ' end verify direction entered
       Command.Number=False ' set variable containing command number to false
       Restore CommandSet1 ' reset data pointer
       For Last.Command.Number=1 To 85 ' loop through 85 data elements
          Read Last.Command ' read command
          If Command.Name=Left$(Last.Command,Len(Command.Name)) Then  ' compare
             Command.Number=Last.Command.Number ' command from data, left part
             Exit For ' of player command, set variable to command number and
          Endif ' exit data read loop
       Next ' next data item
       If Command.Number=False Then ' loop ended without any matching commands
          Graphics.Off=True ' ansi/color off
          Outpt="Unknown command!" ' message
          Call IO.O ' send output
          If UserRecord.Brief=False Then ' brief mode off
             Outpt="Type ? for Help." ' additional message for help
             Call IO.O ' send output
          Endif ' end compare brief mode
          Graphics.Off=False ' ansi/color on
          Exit Sub ' return to main
       Endif ' end command number
       Last.Command.Number=Command.Number ' set command variable to match
       Select Case Command.Number ' select command number
       Case 1 To 4 ' attack commands
          Parsed.Command1=Last.Monster ' restore last monster number attacked
          Last.Command.Number=55 ' attack command number
          Call Attack.Monster ' go attack the monster
       Case 5, 6 ' display the current room
          Call Display.Room
       Case 7, 8 ' panic the character
          Call Panic
       Case 9 ' search the current room
          Call Search.Room
       Case 10, 51 ' update the player file
          Call Put.User.Record ' store the player record
          Outpt="Player file updated." ' message
          Call IO.O ' send output
       Case 11 ' display player information
          Call Display.Stats
       Case 12 ' display player inventory
          Call Display.Inventory
       Case 13 ' kill of the character
          Call Suicide
       Case 14 ' train character (must have 0 experience and enough gold)
          Call Train ' train routine
       Case 15 ' health command
          Call Display.Health
       Case 16 ' appeal for low stats/room w/o exits
          Call Appeal
       Case 17 To 20 ' end session
          Call Quit.Game
       Case 21 ' experience
          Call Display.Experience
       Case 22 ' enter help
          Stored.Parsed.Command1="HELP" ' get help text
          Call Read.Help(False) ' false equals help.dat file
       Case 23 ' hide
          Call Hide.User
       Case 24 ' cast command
          Call Cast.Spell(True) ' true equals enter chant
       Case 25 ' list command
          Call Weapon.List
       Case 26 ' brief mode toggle/must be level 2 at least
          Call Brief.Mode
       Case 27 ' bank command
          Call Bank
       Case 28 To 30 ' display time on/time left
          Call Time.Online
       Case 33 ' ansi on/off
          Call Toggle.ANSI
       Case 39  ' lunge attack command
          Parsed.Command1=Last.Monster ' restore last monster attacked
          Last.Command.Number=39 ' store lunge command number
          Call Attack.Monster ' go attack the monster
       Case 40 ' dodge attack command
          Parsed.Command1=Last.Monster ' restore last monster attacked
          Last.Command.Number=40 ' store dodge command number
          Call Attack.Monster ' go attack the monster
       Case 41 ' display top ten players/create ranklist.dat
          Call Put.User.Record ' store player record
          Call Top.Ten ' generate top ten list
          Call Get.User.Record ' read player record
       Case 42 ' bless w/o parameter
          Call Bless.Self ' therefore bless self
       Case 43 ' curse w/o parameters
          Call Curse.Self ' therefore curse self
       Case 44 ' change password
          Call Change.PassWord ' call routine
          Call Put.User.Record ' put player record
       Case 45 ' mail routine
          Call Mail
       Case 46 ' display list of all players
          Call Put.User.Record ' store player record
          Call User.List ' generate player list
          Call Get.User.Record ' restore player record
       Case 47 ' page sysop
          Call Page.Sysop
       Case 48, 49 ' exit/leave room
          Call Exit.Room
       Case 50 ' climb/go up/up
          Call Climb
       Case 52, 53 ' relogin if player level >1
          Call Relogin
       Case 54 ' display preferences
          Call Display.Prefs ' routine to display preferences
       Case 55 ' change line length
          Call Change.Linelength ' routine to change line length
       Case 56 ' display catalog file
          Call Out.File("catalog.doc") ' display text file
       Case 57 ' toggle linefeed mode
          Call Toggle.Linefeeds ' routine to toggle linefeed mode
       Case 58 ' change pagelength
          Call Change.Pagelength ' routine to change pagelength
       Case 59 ' change echo mode
          Call Toggle.Echo ' routine to toggle echo mode
       Case 60 ' toggle word wrap
          Call Toggle.Wordwrap ' routine to toggle word wrap
       Case 31 To 35 ' attack commands
          Call Attack.Monster ' go attack monster
       Case 61 ' realign once per character
          Call Align
       Case 64 To 74 ' direction entered
          ' set direction of data set number to 1-11
          Direction.Number=Command.Number-63
          ' get the direction and move player
          Call Go.Direction(Direction.Number)
       Case 76 ' display hint file
          Call Out.File("hint.doc") ' display text file
       Case 77 ' toggle inventory sorting on.off
          Call Sort.Inventory
       Case 78 ' display summary file
          Call Out.File("summary.doc") ' display text file
       Case 83 ' reroll all character statistics once per character
          Call Reroll.Character
       End Select
    Endif ' end compare player command
 Else ' command has parameter(s)
    Parsed.Command1=Mid$(User.Command,Parser+1) ' get first parsed part of
    Parsed.Command2=Parsed.Command1 ' command and store remaining parsed
    Stored.Parsed.Command1=Mid$(Stored.Parsed.Command1,_
    Instr(Stored.Parsed.Command1," ")+1) ' truncate stored parsed command
    Stored.Parsed.Command2=Mid$(Stored.Parsed.Command2,_
    Instr(Stored.Parsed.Command2," ")+1) ' truncate stored parsed command
    Call Numeric ' store parse number
    If Sysop.Command Then ' command entered is sysop command
       Restore SysopCommands2 ' reset data pointer
       Command.Number=False ' set variable containing command number to false
       Command.Name=Mid$(Command.Name,2) ' strip leading ! from command
       For Last.Command.Number=1 To 9 ' loop through all sysop data commands
          Read Outpt ' read command
          If Left$(Outpt,Len(Command.Name))=Command.Name Then ' compare to,
             Command.Number=Last.Command.Number ' set command number variable
             OutX$=Outpt ' store command from data
             Exit For ' exit loop, command found
          Endif ' end compare sysop command
       Next ' end loop through data
       If Command.Number=False Then ' if no matching command in variable
          Outpt="Unknown command. Type !Hint for help." ' message
          Call IO.O ' send output
          Exit Sub ' return to main
       Endif ' end matching compare
       Last.Command=OutX$ ' store data command
       Last.Command.Number=Command.Number ' store command number
       Select Case Command.Number ' select sysop command number
       Case 2 ' get monster number and call
          Call Summon.Monster
       Case 3 ' get object/treasure name and discard
          Call Discard.Object
       Case 4 ' edit room and room monclass
          Change.Number=Val(Parsed.Command1) ' room number parameter to edit
          If Change.Number>False Then ' check file bounds
             If Change.Number<=Lof(RoomFile)/Len(RoomRecord) Then ' file bounds
                Call Change.Room(Change.Number) ' edit room number
             Endif ' end check room number range
          Endif ' end check room number range
       Case 5 ' get object/treasure name
          Call Drop.Object ' get from files, drop in room
       Case 6 ' call DM help about command in parameter
          Call DM.Help
       Case 7 ' kill monster name in parameter
          Call Kill.Monster
       Case 8 ' reduce monsters by the value in number parameter
          Call Reduce.Monsters
       Case 9 ' teleport self/online player to room number in parameter
          Call Teleport.User
       End Select ' end select sysop command
    Else ' not sysop command
       Command.Number=False ' set variable containing command number to false
       Restore CommandSet2 ' reset data pointer
       For Last.Command.Number=1 To 85 ' loop through all player commands
          Read Last.Command ' read command
          If Command.Name=Left$(Last.Command,Len(Command.Name)) Then ' compare
             Command.Number=Last.Command.Number ' to and store command number
             Exit For ' exit read data loop
          Endif ' end compare
       Next ' end data loop
       If Command.Number=False Then ' if command number not matched
          Graphics.Off=True ' ansi/color off
          Outpt="Unknown command!" ' message
          Call IO.O ' send output
          If UserRecord.Brief=False Then ' brief mode off
             Outpt="Type ? for Help." ' additional message
             Call IO.O ' send output
          Endif ' end brief mode compare
          Graphics.Off=False ' ansi/color on
          Exit Sub ' return to main
       Endif ' end command number match
       Last.Command.Number=Command.Number ' store command number
       Select Case Command.Number ' select command number
       Case 1, 2, 74, 79 ' enter/go object command
          Call Enter.Object
       Case 3 To 5 ' display player information commands
          Call Display.Information
       Case 6 ' cast spell on target
          Call Cast.Spell(False) ' false equals get chant
       Case 7, 8 ' take command
          If Instr(Parsed.Command2," ") Then ' second parameter
             Call Take.From.Container ' must be from container
          Else ' no extra parameters
             Call Take.Object ' must be from room
          Endif ' end compare second parameter
       Case 9, 10 ' drop command
          If Instr(Parsed.Command2," ") Then ' second parameter
             Call Drop.Into.Container ' must be into container
          Else ' no extra parameters
             Call Drop.Item ' must be into room
          Endif ' end compare second parameter
       Case 11, 12 ' sell an item
          Call Pawn.Shop
       Case 13, 14 ' smash commands
          Call Smash.Object
       Case 15 ' close command
          Call Close.Object
       Case 16 ' open command
          Call Open.Object
       Case 17 To 19 ' hold/wield command
          Call Hold.Object
       Case 20 ' wear command
          Call Wear.Object
       Case 21 ' return a weapon command
          Call Return.Object
       Case 22 ' cast spell on target
          Call Cast.Spell(True) ' true equals no chant
       Case 23 ' list items
          Call Weapons.Shoppe
       Case 24 ' lock command
          Call Lock.Object
       Case 25, 26 ' unlock/picklock commands
          Call Unlock.Object
       Case 27 ' fix command
          Call Fix.Object
       Case 28 ' buy command
          Call Weapons.Shop
       Case 29 ' charge to repair magic item
          Call Alchemist
       Case 30 ' drink command
          Call Drink.Potion
       Case 32 ' throw command
          Call Throw.Object
       Case 33 ' steal command
          Call Steal.Object
       Case 35 ' bless a target
          Call Bless.Object
       Case 36 ' curse a target
          Call Curse.Object
       Case 37 ' fuel command
          Call Fuel.Object
       Case 40, 41 ' talk/parley commands
          Call Talk.To.Monster
       Case 42, 43 ' offer commands
          Call Offer
       Case 44 ' load command
          Call Load.Object
       Case 45 ' fire command
          Call Fire.Object
       Case 46 ' enter vehicle command
          Call Enter.Vehicle
       Case 48, 73 ' ride/go vehicle commands
          Call Ride.Vehicle
       Case 49 ' hide command
          If Instr(Parsed.Command2," ") Then ' second parameter
             Call Drop.Into.Container ' must be hide in container
          Else ' no extra parameters
             Call Drop.Item ' must be hide in room
          Endif ' end check hide parameters
       Case 50 ' search command
          Call Search.Object
       Case 51 ' help w/ parameter of help topic
          Call Read.Help(False) ' read help file
       Case 52 ' identify/extended information
          Call Identify.Object
       Case 55 To 58 ' attack routine
          Last.Command.Number=55
          Call Attack.Monster
       Case 59 To 70, 82 To 85 ' attack routine
          Call Attack.Monster
       Case 71 ' psi mode, attack/defense
          Call Psi.Mode
       Case 72 ' eat command
          Call Eat.Object
       Case 75 ' move command
          Call Move.Object
       Case 76 ' launch command
          Call Launch.Object
       Case 77 ' learn spell, parameter equals spell name to learn
          Call Learn.Spell ' prompts for spell chant
       Case 78 ' light command
          Call Light.Object
       Case 47, 80, 81 ' exit vehicle commands
          Call Exit.Vehicle
       End Select ' end select commmand number
    Endif ' end command type
 Endif ' end parameter type
End Sub ' end command processing

 Rem * routine to logoff player and terminate program.
 Rem * any call to this routine results in program termination.

Sub Terminate.Program
 On Local Error Resume Next ' local error resume
 Logged.In=False ' reset player logged in flag
 Call Status.Line(-2) ' erase status lines
 Call Put.User.Record ' record player record structure
 Call Clean.Room ' remove extra treasure from room
 Outpt=Nul ' display empty C/R
 Call IO.O ' send empty C/R
 Call Time.Online ' display time used and time left
 Call IO.O ' empty C/R
 Call More.Prompt ' pause for more
 Call Top.Ten ' top player list
 Call IO.O ' empty C/R
 Call Out.File("logoff.dat") ' display logoff text file
 Outpt=Nul ' display empty C/R
 Call IO.O ' send empty C/R
 Outpt="Press "+Enter$+" to exit the adventure:" ' exit program prompt
 No.Echo=True ' no echo of player input
 Line.Length=1 ' get one character
 Call IO.I ' get player input
 No.Echo=False ' reset no echo player input
 Call IO.O ' empty C/R
 Outpt="Returning you to "+BBS.Name+".." ' display return message
 Call IO.O ' send output
 Call Reset.ANSI ' restore local color and remote ansi color
 End ' terminate program
End Sub ' end terminate program routine

 Rem * routine to allow player login with another codename.

Sub Relogin
 On Local Error Resume Next ' local error resume
 If Normal.User Then ' check non DM
    If UserRecord.Level<=1 Then ' minimum player level requirement to relogin
       Outpt="You can't relogin until level two!" ' display restriction
       Call IO.O ' send output
       Exit Sub ' return from routine
    Endif ' end check minimum level
 Endif ' end check normal player
 Logged.In=False ' reset player logged in flag
 Call Put.User.Record ' store player record structure
 Call Clean.Room ' remove extra treasure from room
 Call Login ' get player codename
End Sub ' end relogin routine

 Rem * routine allows player to erase character.
 Rem * sometimes player characters are no longer useful
 Rem * when their statistics become too low.

Sub Suicide
 On Local Error Resume Next ' local error resume
 Outpt="Are you sure(y/n)? " ' verify player suicide
 No.Input.Out="N" ' default input to no
 Call IO.I ' get player input
 If Yes Then ' verified to suicide
    Logged.In=False ' reset player logged in flag
    Graphics.Off=True ' ansi/color to white
    Outpt="Your character falls into deep sleep.." ' display suicide message
    Call IO.O ' send output
    Outpt="   The Ghods take your player to another world.." ' display
    Call IO.O ' send output
    Graphics.Off=False ' ansi/color to normal
    Call Delete.User ' remove player record from file
    Call Share.Record(1,User.Index) ' put deleted record in player file
    Call Terminate.Program ' end program
 Endif
End Sub ' end suicide routine

 Rem * routine for normal logoff.

Sub Quit.Game
 On Local Error Resume Next ' local error resume
 Graphics.Off=True ' ansi/color to white
 Outpt="Are you sure(y/n)? " ' verify player to quit
 No.Input.Out="N" ' default to no
 Call IO.I ' get input
 If Yes Then ' verified to quit
    Logged.In=False ' reset player logged in flag
    Call Terminate.Program ' end program
 Endif
End Sub ' end quit routine

 Rem * routine to quit and terminate quick.

Sub Abort
 On Local Error Resume Next ' local error resume
 Outpt="Are you sure(y/n)? " ' verify abort
 No.Input.Out="N" ' default to no
 Call IO.I ' get input
 If Yes Then ' verified yes
    Logged.In=False ' reset player logged in flag
    Outpt="Program task abort!" ' display abort message
    Call IO.O ' output
    Call Put.User.Record ' store player record structure
    Call Reset.ANSI ' restore ansi/color
    Call Status.Line(-2) ' remove status lines
    End ' end program
 Endif
End Sub ' end abort routine

 Rem * routine to remove an item of player inventory and add to room.

Sub Drop.Item
 On Local Error Resume Next ' local error resume
 If Normal.User=False Then ' only special characters can have objects
    Call Find.Object ' check inventory for object by mnemonic name
    If Index.Number Then ' returns index to objects file
       Call Add.Room.Object(Index.Number,Charges.Number,Item.Added) ' add item
       If Item.Added Then ' check object added flag
          Call Discard.Inventory.Object(Array.Number) ' remove object
          Outpt="You drop "+Outpts+"!" ' format output
          Call IO.O ' send output
       Else ' check item added to room
          Outpt="You can't drop that!" ' message
          Call IO.O ' send output
       Endif ' end check item added to room objects
       Exit Sub ' return from routine
    Endif ' end check inventory for object
 Endif ' end check character type
 Call Find.Inventory ' check inventory for treasure by mnemonic name
 If Index.Number Then ' returns index to treasure file
    If Last.Command.Number=Hide.Command Then ' compare command to hide
       Outpt="You hide "+Outpts+"!" ' format hide message
       Hide.Item=Hidden.Object ' set hide flag
    Else ' not hide command
       Outpt="You drop "+Outpts+"!" ' format message
       Hide.Item=False ' set hide flag
    Endif ' end compare command
    ' add item to room
    Call Add.Room.Treasure(Index.Number,Charges.Number,Hide.Item,Item.Added)
    If Item.Added Then ' added to room flag
       Call Discard.Inventory(Array.Number,True) ' remove from player inventory
    Else ' not added
       Outpt="You can't drop that!" ' message
    Endif ' end check room flag
    Call IO.O ' send output
    Exit Sub ' return from routine
 Endif ' end check inventory for treasure
 Call Num ' decrement parse temp
 Call Check.Inventory.Container ' check player inventory for container
 If Index.Number Then ' returns index of container to treasure
    If Last.Command.Number=Hide.Command Then ' compare to hide command
       Outpt="You can't hide that!" ' message
       Call IO.O ' send output
       Exit Sub ' return from routine
    Endif ' end compare to hide command
    If Rtrim$(RoomRecord.Container.ShortName)=Nul Then ' room container empty
       ' store room container
       RoomRecord.Container=UserRecord.Container(Array.Number)
       Call Share.Record(3,Room) ' record structure, put room record,
       Outpts=Rtrim$(ContainerRec.ContainerName) ' message
       Call Clear.Container(0,True) ' clear player container structure, put
       UserRecord.Container(Array.Number)=ContainerRec ' clear container record
       Outpt="You drop "+Outpts+"!" ' format message
       Call IO.O ' send output
       Exit Sub ' return from routine
    Endif ' end compare room container
 Endif ' end check container index
 Outpt="You can't drop that!" ' message
 Call IO.O ' send output
End Sub ' end drop item routine

 Rem * routine to remove an item from player inventory and add to a container.

Sub Drop.Into.Container
 On Local Error Resume Next ' local error resume
 Call Parse ' get first parameter
 Call Numeric ' parse parameter number from # sign
 Call Check.Inventory.Treasure ' search for inventory to drop
 If Index.Number=False Then ' index to treasure file not found
    Outpt="You can't drop that!" ' message
    Call IO.O ' send output
    Exit Sub ' return from routine
 Endif ' end check treasure index
 Item.Number=Array.Number ' store treasure index to array
 Item.Charges=Charges.Number ' store treasure charges
 Item.Index=Index.Number ' store treasure index to file
 Parsed.Command1=Parsed.Command2 ' get second parameter
 Call Numeric ' parse parameter number from # sign
 Call Examine.Container ' check player inventory and room for container
 If Index.Number=False Then ' index to treasure file not found
    Outpt="You can't drop that!" ' message
    Call IO.O ' send output
    Exit Sub ' return from routine
 Endif ' end check index
 If ContainerRec.Locked>False Then ' check container locked
    Outpt="You can't, it's locked!" ' message
    Call IO.O ' send output
    Exit Sub ' return from routine
 Endif ' end check container
 If ContainerRec.Closed>False Then ' check container closed
    Outpt="You can't, it's closed!" ' message
    Call IO.O ' send output
    Exit Sub ' return from routine
 Endif ' end check container
 Container.Number=Array.Number ' store index of inventory array of container
 For Array.Counter=1 To 5 ' loop through container elements
    ' find empty container element
    If ContainerRec.Inventory(Array.Counter)=False Then
       Container.Name$=ContainerRec.ContainerName ' store container name
       Container.Name$=Rtrim$(Container.Name$) ' strip trailing blanks
       If Last.Command.Number=Hide.Command Then ' last command was hide
          ' set container record hide flag
          ContainerRec.Invisible(Array.Counter)=True
       Else ' not hide
          ' set container record hide
          ContainerRec.Invisible(Array.Counter)=False
       Endif ' end check last command
       ' store container record index
       ContainerRec.Inventory(Array.Counter)=Item.Index
       ' store container record charges
       ContainerRec.Charges(Array.Counter)=Item.Charges
       ' store container treasure name mnemonic
       ContainerRec.TreasureName(Array.Counter)=TreasureRecord.ShortName
       Select Case Type.Number ' select room or inventory
       Case 1 ' drop item into container in room
          RoomRecord.Container=ContainerRec ' set room container record
          Call Share.Record(3,Room) ' put room record
       Case 0 ' dropped item in container in player inventory
          ' update player container
          UserRecord.Container(Container.Number)=ContainerRec
       End Select ' end select container drop
       Outpts=TreasureRecord.TreasureName ' store name of treasure dropped
       Outpts=Rtrim$(Outpts) ' strip trailing blanks
       If Last.Command.Number=Hide.Command Then ' last command hide
          Inpt=" hide " ' set equal to hide
       Else ' not hide
          Inpt=" drop " ' set equal to drop
       Endif ' end check last command
       Outpt="You"+Inpt+Outpts+" in "+Container.Name$+"!" ' format message
       Call IO.O ' send output
       Call Discard.Inventory(Item.Number,True) ' remove item from inventory
       Exit Sub ' return from routine
    Endif ' end check empty container record
 Next ' loop through container records
 Outpt="You can't, it's full!" ' message
 Call IO.O ' send output
End Sub ' end drop into container routine

 Rem * routine to take an object or item of treasure from the room and
 Rem * add to the player inventory.

Sub Take.Object
 On Local Error Resume Next ' local error resume
 If Normal.User=False Then ' normal players cannot take objects
    Call Check.Room.Objects ' find the mnemonic of object to take
    If Index.Number Then ' verify object file index
       ' routine to add object to room
       Call Add.Object(Index.Number,Charges.Number,Item.Added)
       If Item.Added Then ' an empty object element
          ' routine to remove item from room
          Call Discard.Room.Object(Array.Number)
          Outpt="You take "+Outpts+"!" ' format message
          Call IO.O ' display message
       Else ' check empty object found
          Outpt="You can't carry any more!" ' format message
          Call IO.O ' display message
       Endif ' end compare empty object element
       Exit Sub ' exit routine
    Endif ' end find object to take
 Endif ' end normal player
 Call Check.Room.Treasure ' find mnemonic of treasure to take
 If Index.Number Then ' treasure index found in room to take
    ' calculate weight player is carrying
    New.Weight#=Cdbl(Int(Weight+TreasureRecord.Weight))
    If New.Weight#>MaxInt Then ' check maximum integer
       New.Weight#=MaxInt ' reduce to maximum integer
    Endif ' end check maximum integer
    Total.Weight#=Cdbl(UserRecord.Stats(1)) ' store player strength
    Total.Weight#=Total.Weight#*100 ' multiply to weight player can carry
    If New.Weight#>Total.Weight# Then ' compare weight player can carry
       Outpt="You can't carry any more!" ' weight ten times player strength
       Call IO.O ' format message
       Exit Sub ' exit routine
    Endif ' end compare weight
    If UserRecord.ClassType<AsstDM Then ' normal class prevented to take item
       For Array.Counter=1 To Number.Monsters ' loop through all monsters
          ' check monster can prevent
          If MonsterArray(Array.Counter).Prevent Then
             ' compute random percent
             If Rnd<(MonsterArray(Array.Counter).PreventPercent/100) Then
                Inpt=MonsterArray(Array.Counter).MonsterName ' store name
                Inpt=Rtrim$(Inpt) ' format message
                Outpt="The "+Inpt+" prevents you from getting it!"
                Call IO.O ' send message
                Exit Sub ' exit routine
             Endif ' end compare random calculation
          Endif ' end compare monster to prevent taking item
       Next ' end loop through all monsters in room
    Endif ' end compare player class
    If TreasureRecord.Coin Then ' check item is coins
       Outpt="You take "+Outpts+"!" ' format message
       Call IO.O ' send message
       UserRecord.Gold=UserRecord.Gold+TreasureRecord.Gold ' increment gold
       Outpt="You now have"+Str$(UserRecord.Gold)+" Gold!" ' message
       Call IO.O ' send message
       Call Discard.Room.Treasure(Array.Number) ' remove item from room
       Exit Sub ' exit routine
    Endif ' end compare item if coins
    ' add room item to inventory
    Call Add.Inventory(Index.Number,Charges.Number,Item.Added)
    If Item.Added Then ' return flag indicates successful addition to inventory
       Outpt="You take "+Outpts+"!" ' format message
       Call IO.O ' send message
       Call Discard.Room.Treasure(Array.Number) ' remove item from room
    Else ' compare flag
       Outpt="You can't carry any more!" ' make message
       Call IO.O ' send message
    Endif ' end compare flag
    Exit Sub ' exit routine
 Endif ' end item is treasure in room
 Call Num ' decrement parse temp
 Call Check.Room.Container ' verify item to take is a container
 If Index.Number Then ' found container index to treasure file
    ' loop through player inventory to find empty container
    For Array.Number=1 To 3
       ' compare container name
       If Rtrim$(UserRecord.Container(Array.Number).ShortName)=Nul Then
          ' store container record
          UserRecord.Container(Array.Number)=ContainerRec
          Outpts=Rtrim$(ContainerRec.ContainerName) ' format message
          Outpt="You get "+Outpts+"!" ' make message
          Call IO.O ' send message
          Call Clear.Container(0,True) ' clear entire container record
          RoomRecord.Container=ContainerRec ' clear room container
          Call Share.Record(3,Room) ' write room record
          Exit Sub ' exit routine
       Endif ' end compare empty container mnemonic name
    Next ' loop through inventory
 Endif ' end verify taking container
 Outpt="You can't get that!" ' message
 Call IO.O ' send message
End Sub ' end take item routine

 Rem * routine to take an item of treasure from a container and add to
 Rem * the player inventory.

Sub Take.From.Container
 On Local Error Resume Next ' local error resume
 Call ParseX ' parse second parameter
 Call Numeric ' parse parameter number from # sign
 Call Examine.Container ' check container mnemonic
 If Index.Number=False Then ' cmopare treasure index
    Outpt="You can't get that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare container index
 If ContainerRec.Locked>False Then ' check container locked
    Outpt="You can't, it's locked!" ' message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end check container locked
 If ContainerRec.Closed>False Then ' check container closed
    Outpt="You can't, it's closed!" ' message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end check container closed
 Container.Number=Array.Number ' store container index of player inventory
 Container.Name$=ContainerRec.ContainerName ' store container name
 Container.Name$=Rtrim$(Container.Name$) ' edit container name
 Parsed.Command1=Parsed.Command2 ' get first parameter
 Call Numeric ' parse parameter number from # sign
 Item.Counter=False ' parsed number counter
 For Array.Counter=1 To 5 ' loop through all container treasure
    ' get treasure name from container
    Inpt=ContainerRec.TreasureName(Array.Counter)
    Inpt=Left$(Inpt,Len(Parsed.Command1)) ' truncate container treasure name
    If Inpt=Parsed.Command1 Then ' compare to treasure to take
       Item.Counter=Item.Counter+1 ' increment parsed counter
       ' compare to parameter number
       If Parse.Number=False Or Item.Counter=Parse.Number Then
          ' get treasure charges
          Charges.Number=ContainerRec.Charges(Array.Counter)
          ' get treasure number
          Index.Number=ContainerRec.Inventory(Array.Counter)
          Get 6,Index.Number,TreasureRecord ' read treasure file record
          Outpts=TreasureRecord.TreasureName ' format treasure name
          Outpts=Rtrim$(Outpts) ' trim name
          ' compute weight player carrying
          New.Weight#=Cdbl(Int(Weight+TreasureRecord.Weight))
          If New.Weight#>MaxInt Then ' check maximum integer
             New.Weight#=MaxInt ' reduce to maximum integer
          Endif ' end check maximum integer
          Total.Weight#=Cdbl(UserRecord.Stats(1)) ' store player strength
          Total.Weight#=Total.Weight#*100 ' multiply weight player can carry
          If New.Weight#>Total.Weight# Then ' compare wieght player can carry
             Outpt="You can't carry any more!" ' weight and make message
             Call IO.O ' send message
             Exit Sub ' exit routine
          Endif ' end compare weight
          ' add treasure to inventory
          Call Add.Inventory(Index.Number,Charges.Number,Item.Added)
          If Item.Added Then ' flag set to add
             Call Clear.Container(Array.Counter,False) ' clear container item
             Select Case Type.Number ' select room or inventory
             Case 1 ' flag indicating container in room or inventory
                RoomRecord.Container=ContainerRec ' set room container record
                Call Share.Record(3,Room) ' write room record
             Case 0 ' flag indicates player record
                ' update player container
                UserRecord.Container(Container.Number)=ContainerRec
             End Select ' end compare room or inventory
             Outpt="You take "+Outpts+" from "+Container.Name$+"!" ' message
             Call IO.O ' send message
             Exit Sub ' exit routine
          Endif ' end compare add flag
       Endif ' end compare parsed number
    Endif ' end compare treasure name
 Next ' end loop through player container inventory
 Outpt="You can't get that!" ' make message
 Call IO.O ' send message
End Sub ' end take from container routine

 Rem * sets container elements to zero.
 Rem * input variables:
 Rem *   Item.Number - container item to clear.
 Rem *   Clear.Items - true to clear container, false to clear container item.

Sub Clear.Container(Item.Number,Clear.Items)
 On Local Error Resume Next ' local error resume
 If Clear.Items=False Then ' passed parameter to clear one container item 
    ContainerRec.Charges(Item.Number)=False ' container element to zero
    ContainerRec.Inventory(Item.Number)=False ' container element to zero
    ContainerRec.Invisible(Item.Number)=False ' container element to zero
    ContainerRec.TreasureName(Item.Number)=Nul ' container element to zero
 Else ' passed parameter to clear entire container
    ContainerRec.Closed=False ' container to zero
    ContainerRec.ContainerName=Nul ' container to zero
    ContainerRec.Keyed=False ' container to zero
    ContainerRec.Locked=False ' container to zero
    ContainerRec.ShortName=Nul ' container to zero
    For Container.Item=1 To 5 ' loop through all container elements
       ContainerRec.Inventory(Container.Item)=False ' reset container element
       ContainerRec.Charges(Container.Item)=False ' reset container element
       ContainerRec.Invisible(Container.Item)=False ' reset container element
       ContainerRec.TreasureName(Container.Item)=Nul ' reset container element
    Next ' end loop all container elements
 Endif ' end passed parameter
End Sub ' end routine to clear container

 Rem * routine to lock an object or container.

Sub Lock.Object
 On Local Error Resume Next ' local error resume
 Call Examine.Container ' check container mnemonic
 If Index.Number Then ' container index to treasure file
    Container.Number=Array.Number ' store container number
    If ContainerRec.Locked=False Then ' container has no lock setting
       Outpt="You can't lock that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare container lock
    If ContainerRec.Locked>False Then ' container lock variable is already set
       Outpt="It's already locked!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare container lock
    ContainerRec.Locked=1 ' set container variable to locked
    ContainerRec.Closed=1 ' set container variable to locked
    Select Case Type.Number ' select room or inventory
    Case 1 ' container is locked in room
       RoomRecord.Container=ContainerRec
       Call Share.Record(3,Room) ' write room record
    Case 0 ' container is locked in player inventory
       ' update player container
       UserRecord.Container(Container.Number)=ContainerRec
    End Select ' end compare container locked
    Outpt="You lock it!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end check container
 Call Num ' decrement parse temp
 Call Examine.Objects ' check object mnemonic
 If Index.Number Then ' found object index
    If ObjectRecord.RoomLink=False Then ' check object is a portal
       Outpt="You can't lock that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare object portal
    If ObjectRecord.DoorLock=2 Then ' object is already locked
       Outpt="It's already locked!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare object lock
    If ObjectRecord.DoorLock=False Then ' object has no lock setting
       Outpt="You can't lock that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare object lock
    ObjectRecord.DoorLock=2 ' set object lock variable
    ObjectRecord.Closed=True ' set object lock variable
    Call Share.Record(4,Index.Number) ' write object record
    Outpt="You lock it!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end check object
 Outpt="You can't lock that!" ' make message
 Call IO.O ' send message
End Sub ' end routine to lock an item

 Rem * routine to unlock or picklock an object or container.

Sub Unlock.Object
 On Local Error Resume Next ' local error resume
 Call Examine.Container ' check container mnemonic
 If Index.Number Then ' found container treasure index
    Container.Number=Array.Number ' store container number
    If ContainerRec.Locked=False Then ' container has no lock setting
       Outpt="You can't unlock that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare container lock
    If ContainerRec.Locked<False Then ' container lock variable already set
       Outpt="It's already unlocked!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare container lock
    If ContainerRec.Keyed=False Then ' container has no key number
       ContainerRec.Locked=True ' set container lock variable
       ContainerRec.Closed=1 ' set container lock variable
       Select Case Type.Number ' select room or inventory
       Case 1 ' container unlocked in room
          RoomRecord.Container=ContainerRec ' set room container record
          Call Share.Record(3,Room) ' write room record
       Case 0 ' container is locked in player inventory
          ' update player container
          UserRecord.Container(Container.Number)=ContainerRec
       End Select ' end store container record
       Outpt="You unlock it!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare container key number
    If Last.Command.Number=Picklock.Command Then ' picklock container
       If UserRecord.ClassType<>Thief Then ' compare player class to thief
          If Normal.User Then ' compare player type to normal
             Outpt="You can't picklock doors!" ' make message
             Call IO.O ' send message
             Exit Sub ' exit routine
          Endif ' end compare player type
       Endif ' end compare class to thief
       If Int(Rnd*UserRecord.Stats(1))+1<7 Then ' compute random chance
          Outpt="You didn't picklock it!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end random chance
       If Int(Rnd*UserRecord.Stats(2))+1<7 Then ' compute random chance
          Outpt="You didn't picklock it!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end random chance
       If Rnd<.2 Then ' random chance
          Outpt="You didn't picklock it!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end chance
       ContainerRec.Locked=True ' set container record to unlocked
       ContainerRec.Closed=1 ' set container record to unlocked
       Select Case Type.Number ' select room or inventory
       Case 1 ' container unlocked in room
          RoomRecord.Container=ContainerRec ' set room container record
          Call Share.Record(3,Room) ' write room record
       Case 0 ' container unlocked in player inventory
          ' update player container
          UserRecord.Container(Container.Number)=ContainerRec
       End Select ' end set container record
       Outpt="You picklock it!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check picklock container
    ' compare player inventory key numbers to container key number
    Key.Number=ContainerRec.Keyed ' store container key number to unlock
    Inpt=Right$(Str$(Key.Number+100000!),5) ' format key number to string
    For Inventory.Number=1 To 15 ' loop through all player inventory
       ' player inventory treasure index
       If UserRecord.Inv(Inventory.Number) Then
          ' get treasure record
          Get 6,UserRecord.Inv(Inventory.Number),TreasureRecord
          If TreasureRecord.Keyed Then ' compare inventory treasure to key
             ' check inventory index is not container
             If Inventory.Number<>Array.Number Then
                Container.Locked=True ' container unlocked flag
                ' format key number in inventory to string
                Outpts=Right$(Str$(TreasureRecord.Keyed+100000!),5)
                For Digit.Counter=1 To 5 ' loop through all key number digits
                   ' get value of key digit
                   Key.Digit=Val(Mid$(Outpts,Digit.Counter,1))
                   ' compare player inventory key digit to container key digit
                   ' digits unequal
                   If Key.Digit<>Val(Mid$(Inpt,Digit.Counter,1)) Then
                      ' player inventory key digit 0 matches
                      If Key.Digit>False Then
                         ' container is not unlocked flag
                         Container.Locked=False
                         Exit For ' exit loop, digit mismatch
                      Endif ' end compare key digit 0 matches any key number
                   Endif ' end compare key digit matches specific key number
                Next ' end loop through all key digits in player inventory key
                ' key in player inventory found to match container
                If Container.Locked Then
                   ContainerRec.Locked=True ' set container unlock
                   ContainerRec.Closed=1 ' set container unlock
                   Select Case Type.Number ' select room or inventory
                   Case 1 ' container unlocked with key in room
                      RoomRecord.Container=ContainerRec ' set room container
                      Call Share.Record(3,Room) ' write room record
                   Case 0 ' container unlocked with key in player inventory
                      ' update player container
                      UserRecord.Container(Container.Number)=ContainerRec
                   End Select ' end set container record
                   Outpt="You unlock it!" ' make message
                   Call IO.O ' send message
                   Exit Sub ' exit routine
                Endif ' end compare key match
             Endif ' end select key in player inventory
          Endif ' end compare player inventory to a key
       Endif ' end compare player inventory
    Next ' end loop through all keys in player inventory
    Outpt="You don't have the key!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end check container
 Call Num ' decrement parse temp
 Call Examine.Objects ' check object mnemonic
 If Index.Number Then ' found object index
    If ObjectRecord.RoomLink=False Then ' check object is a portal
       Outpt="You can't unlock that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end object portal
    If ObjectRecord.DoorLock=False Then ' object does not lock
       Outpt="You can't unlock that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end object lock
    If ObjectRecord.DoorLock=1 Then ' object is already unlocked
       Outpt="It's already unlocked!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end object lock
    If ObjectRecord.Keyed=False Then ' object has no key number
       ObjectRecord.DoorLock=1 ' set object unlocked
       ObjectRecord.Closed=True ' set object unlocked
       Call Share.Record(4,Index.Number) ' write object record
       Outpt="You unlock it!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end object key number
    If Last.Command.Number=Picklock.Command Then ' picklock object
       If ObjectRecord.Hidden Then ' object is hidden
          Outpt="You can't picklock hidden doors!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end object hidden
       If UserRecord.ClassType<>Thief Then ' check player class to thief
          If Normal.User Then ' check player is normal
             Outpt="You can't picklock doors!" ' make message
             Call IO.O ' send message
             Exit Sub ' exit routine
          Endif ' end compare normal player
       Endif ' end compare class type
       If Int(Rnd*UserRecord.Stats(1))+1<7 Then ' compute random chance
          Outpt="You didn't picklock it!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end random chance
       If Int(Rnd*UserRecord.Stats(2))+1<7 Then ' compute random chance
          Outpt="You didn't picklock it!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end random chance
       If Rnd<.2 Then ' random chance
          Outpt="You didn't picklock it!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end chance
       ObjectRecord.DoorLock=1 ' set object unlocked
       ObjectRecord.Closed=True ' set object unlocked
       Call Share.Record(4,Index.Number) ' write object record
       Outpt="You picklock it!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end picklock
    ' compare player inventory key numbers to object key number
    Inpt=Right$(Str$(ObjectRecord.Keyed+100000!),5) ' format key number
    For Inventory.Number=1 To 15 ' loop through all player inventory
       ' player inventory treasure index
       If UserRecord.Inv(Inventory.Number) Then
          ' get treasure record
          Get 6,UserRecord.Inv(Inventory.Number),TreasureRecord
          If TreasureRecord.Keyed Then ' compare treasure to key
             Container.Locked=True ' set object unlocked flag
             ' format player inventory key number to string
             Outpts=Right$(Str$(TreasureRecord.Keyed+100000!),5)
             For Digit.Counter=1 To 5 ' loop through all key number digits
                ' get inventory key digit
                Key.Digit=Val(Mid$(Outpts,Digit.Counter,1))
                ' compare player inventory key digit to container key digit
                ' compare to object
                If Key.Digit<>Val(Mid$(Inpt,Digit.Counter,1)) Then
                   If Key.Digit>False Then ' zero digit matches any key digit
                      Container.Locked=False ' set object is not unlocked flag
                      Exit For ' exit loop, found unmatching digit
                   Endif ' end compare matching zero digit
                Endif ' end compare both digits
             Next ' end loop through all digits
             If Container.Locked Then ' object key number matched
                ObjectRecord.DoorLock=1 ' set object unlocked
                ObjectRecord.Closed=True ' set object unlocked
                Call Share.Record(4,Index.Number) ' write object record
                Outpt="You unlock it!" ' make message
                Call IO.O ' send message
                Exit Sub ' exit routine
             Endif ' end matching key number
          Endif ' end locate player inventory key
       Endif ' end find player inventory treasure
    Next ' end loop through all player inventory for keys
    Outpt="You don't have the key!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end unlock object
 Outpt="You can't unlock that!" ' make message
 Call IO.O ' send message
End Sub ' end routine to unlock/picklock an item or container

 Rem * routine to close an object.

Sub Close.Object
 On Local Error Resume Next ' local error resume
 Call Examine.Container ' check container mnemonic
 If Index.Number Then ' found container index to treasure file
    Container.Number=Array.Number ' store container number
    If ContainerRec.Locked=False Then ' container has no lock to set
       Outpt="You can't close that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end container lock
    If ContainerRec.Locked>False Then ' check if container already locked
       Outpt="It's already closed!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end container lock
    If ContainerRec.Closed=False Then ' container has no close setting
       Outpt="You can't close that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare closed
    If ContainerRec.Closed>False Then ' container is already closed
       Outpt="It's already closed!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare closed
    ContainerRec.Closed=1 ' set container record closed variable
    Select Case Type.Number ' select room or inventory
    Case 1 ' container closed in room
       RoomRecord.Container=ContainerRec ' set room container record
       Call Share.Record(3,Room) ' write room record
    Case 0 ' container closed in player inventory
       ' update player container
       UserRecord.Container(Container.Number)=ContainerRec
    End Select ' end reset container
    Outpt="You close it!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare container index
 Call Num ' decrement parse temp
 Call Examine.Objects ' check object mnemonic
 If Index.Number Then ' found object index to object file
    If ObjectRecord.DoorLock<>1 Then ' compare object already locked
       Outpt="You can't close that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare lock
    If ObjectRecord.Closed Then ' compare container already closed
       Outpt="It's already closed!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare closed
    ObjectRecord.Closed=True ' set object record closed variable
    Call Share.Record(4,Index.Number) ' write object record
    Outpt="You close it!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end object search
 Outpt="You can't close that!" ' make message
 Call IO.O ' send message
End Sub ' end routine to closed an item

 Rem * routine to open an item.

Sub Open.Object
 On Local Error Resume Next ' local error resume
 Call Examine.Container ' check container mnemonic
 If Index.Number Then ' found container index
    Container.Number=Array.Number ' store container number
    If ContainerRec.Locked=False Then ' container has no lock to set
       Outpt="You can't open that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare container lock
    If ContainerRec.Locked>False Then ' compare container lock variable
       Outpt="You can't, it's locked!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare lock
    If ContainerRec.Closed=False Then ' container has no close variable to set
       Outpt="You can't open that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare close
    If ContainerRec.Closed<False Then ' container is already open
       Outpt="It's already open!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare close
    ContainerRec.Closed=True ' set container open variable
    Select Case Type.Number ' select room or inventory
    Case 1 ' container is opened in room
       RoomRecord.Container=ContainerRec ' reset room container
       Call Share.Record(3,Room) ' write room record
    Case 0 ' container is open in inventory
       ' update player container
       UserRecord.Container(Container.Number)=ContainerRec
    End Select ' end reset container
    Outpt="You open it!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare container
 Call Num ' reset parse temp
 Call Examine.Objects ' check object mnemonic
 If Index.Number Then ' found object index
    If ObjectRecord.DoorLock<>1 Then ' compare object closed variable
       Outpt="You can't open that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare closed
    If ObjectRecord.Closed=False Then ' compare object open variable
       Outpt="It's already open!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare opened
    ObjectRecord.Closed=False ' set object record open variable
    Call Share.Record(4,Index.Number) ' write object record
    Outpt="You open it!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end object index
 Outpt="You can't open that!" ' make message
 Call IO.O ' send message
End Sub ' end routine to open an item

 Rem * routine to smash open a locked item.

Sub Smash.Object
 On Local Error Resume Next ' local error resume
 Call Examine.Container ' check container mnemonic
 If Index.Number Then ' found container index to treasure file
    Container.Number=Array.Number ' store container number
    If ContainerRec.Locked=False Then ' container has no available lock
       Outpt="You can't smash that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare container lock
    If ContainerRec.Locked<False Then ' lock variable is already open
       Outpt="It's already unlocked!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare lock
    If ContainerRec.Keyed>False Then ' container has a key number
       Outpt="You can't smash that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare key number
    If Int(Rnd*UserRecord.Stats(2))+1<7 Then ' compute smash chance
       Outpt="You didn't smash it open!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end chance
    If Int(Rnd*UserRecord.Stats(1))+1<7 Then ' compare smash chance
       Outpt="You didn't smash it open!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end chance
    If Rnd<.2 Then ' random chance to smash lock
       Outpt="You didn't smash it open!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end chance
    ContainerRec.Locked=True ' set container to unlocked
    ContainerRec.Closed=1 ' set container to closed
    Select Case Type.Number ' select room or inventory
    Case 1 ' container unlocked in room
       RoomRecord.Container=ContainerRec ' set new container record
       Call Share.Record(3,Room) ' write room record
    Case 0 ' container unlocked in inventory
       ' update player container
       UserRecord.Container(Container.Number)=ContainerRec
    End Select ' end reset container
    Outpt="You smash it open!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare container index
 Call Num ' decrement parse temp
 Call Examine.Objects ' check object mnemonic
 If Index.Number Then ' found object index
    If ObjectRecord.Hidden Then ' object type is hidden
       Outpt="You can't smash that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end object type
    If ObjectRecord.RoomLink=False Then ' object is not a portal
       Outpt="You can't smash that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end portal
    If ObjectRecord.Keyed Then ' object has a key number
       Outpt="You can't smash that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end object key number
    If ObjectRecord.DoorLock=1 Then ' object lock is already open
       Outpt="It's already unlocked!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end object lock
    If Int(Rnd*UserRecord.Stats(2))+1<7 Then ' compute random chance
       Outpt="You didn't smash it open!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end chance
    If Int(Rnd*UserRecord.Stats(1))+1<7 Then ' compute random chance
       Outpt="You didn't smash it open!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end chance
    If Rnd<.2 Then ' random chance
       Outpt="You didn't smash it open!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end chance
    ObjectRecord.DoorLock=1 ' set object record lock to open
    Call Share.Record(4,Index.Number) ' write object record
    Outpt="You smash it open!" ' make message
    Call IO.O ' send message
    If ObjectRecord.Trap Then ' check object is trapped
       Call Traps ' initiate any object traps
    Endif ' end object trap
    Exit Sub ' exit routine
 Endif ' end object index
 Outpt="You can't smash that!" ' make message
 Call IO.O ' send message
End Sub ' end routine to smash open lock

 Rem * routine for player to hold an item of inventory.

Sub Hold.Object
 On Local Error Resume Next ' local error resume
 Call Check.Inventory.Treasure ' check player inventory treasure mneomnic
 If Index.Number=False Then ' found treasure file index
    Outpt="You aren't carrying that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare player inventory
 If TreasureRecord.Type>False Then ' compare treasure type
    Outpt="You can't hold that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare treasure type
 ' compute treasure charges remaining
 If UserRecord.Charges(Array.Number)=False Then
    Outpt="You can't, it has zero charges!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare treasure charges
 Item.Plus=Abs(TreasureRecord.Plus)
 Select Case TreasureRecord.Type ' select treasure type
 Case Is<False ' compare treasure type to shield
    Weapon3=Item.Plus ' set variable of holding shield plus
    ' set variable of holding shield of inventory array index
    Weapon5=Array.Number
 Case False ' compare treasure type to weapon
    Index.Number=TreasureRecord.Proficiency ' store treasure proficiency
    If UserRecord.ClassType=Cleric Then ' compare player classtype to cleric
       Select Case Index.Number ' select treasure proficiency type
       Case 3 To 4 ' compare to sharp or thrusting
          Outpt="Clerics may only use blunt or pole type weapons!" ' message
          Call IO.O ' send message
          Exit Sub ' exit routine
       End Select ' end compare weapon proficiency type
    Endif ' end compare to cleric
    Weapon2=Item.Plus ' set variable of holding weapon plus
    ' set variable of holding weapon of inventory array index
    Weapon6=Array.Number
    Weapon10=Index.Number ' set variable of holding weapon proficiency type
 End Select ' end select treasure type
 Outpt="You hold "+Outpts+"(+"+Mid$(Str$(Item.Plus),2)+")!" ' format message
 Call IO.O ' send message
End Sub ' end routine to hold an item

 Rem * routine for player to wear an item of inventory.

Sub Wear.Object
 On Local Error Resume Next ' local error resume
 Call Check.Inventory.Treasure ' check player inventory treasure mnemonic
 If Index.Number=False Then ' found treasure index
    Outpt="You aren't carrying that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare index
 If TreasureRecord.Type<=False Then ' commpare treasure type
    If TreasureRecord.RingType=False Then ' compare ring type
       Outpt="You can't wear that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare ring
 Endif ' end compare treasure type
 If UserRecord.Charges(Array.Number)=False Then ' compare player charges array
    Outpt="You can't, it has zero charges!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare charges
 Item.Plus=Abs(TreasureRecord.Plus) ' store treasure item plus hits
 Select Case TreasureRecord.Type ' selecct treasure type
 Case Is>False ' treasure type is armor
    Weapon1=Item.Plus ' set variable of wearing item to plus
    ' set variable of wearing item to inventory array index
    Weapon4=Array.Number
    Plus$="(+"+Mid$(Str$(Item.Plus),2)+")" ' make plus message
 Case Else ' treasure type is ring
    Weapon7=Array.Number ' set wearing ring item to inventory array index
    Weapon8=TreasureRecord.RingType ' set wearing ring type variable
    Weapon9=TreasureRecord.RingSpell ' set wearing ring spell type variable
    Plus$=Nul ' clear plus message
 End Select ' end select treasure type
 Outpt="You wear "+Outpts+Plus$+"!" ' format message
 Call IO.O ' send message
End Sub ' end routine to wear an item

 Rem * routine to return an item from being held or worn.

Sub Return.Object
 On Local Error Resume Next ' local error resume
 Call Check.Inventory.Treasure ' check player inventory mnemonic
 If Index.Number=False Then ' treasure index of item
    Outpt="You aren't carrying that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare treasure inventory
 Outpt="You return "+Outpts+"!" ' format message
 Select Case Array.Number ' select treasure inventory array variable
 Case Weapon4 ' compare treasure inventory array to armor variable
    Weapon1=False ' reset shield holding variable
    Weapon4=False ' reset shield holding variable
    Call IO.O ' send message
 Case Weapon5 ' compare treasure inventory array to shield variable
    Weapon3=False ' reset shield holding variable
    Weapon5=False ' reset shield holding variable
    Call IO.O ' send message
 Case Weapon6 ' compare treasure inventory array to weapon variable
    Weapon2=False ' reset shield holding variable
    Weapon6=False ' reset shield holding variable
    Weapon10=False ' reset shield holding variable
    Call IO.O ' send message
 Case Weapon7 ' compare treasure inventory array to ring variable
    Weapon7=False ' reset shield holding variable
    Weapon8=False ' reset shield holding variable
    Weapon9=False ' reset shield holding variable
    Call IO.O ' send message
 Case Else ' no matching variables being held or worn
    Outpt="Your aren't wearing that!" ' make message
    Call IO.O ' send message
 End Select ' end select treasure array variable
End Sub ' end routine to return item

 Rem * routine to reset an item with original charges if broken.

Sub Fix.Object
 On Local Error Resume Next ' local error resume
 Call Examine.Treasure ' check treasure mnemonic
 If Index.Number=False Then ' treasure index
    Outpt="You can't fix that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end check treasure
 If TreasureRecord.Spell Then ' treasure has spell
    Outpt="You can't fix that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare spell
 If TreasureRecord.Plus=False Then ' treasure is not weapon, armor, shield
    Outpt="You can't fix that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare spell
 If UserRecord.Charges(Array.Number) Then ' check remaining treasure charges
    Outpt="That's not broken!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare charges
 If UserRecord.Stats(3)<7 Then ' compute random chance
    Outpt="You didn't fix it!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end random chance
 If Abs(TreasureRecord.Plus)>10 Then ' compare treasure plus
    Outpt="You didn't fix it!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare plus
 If Rnd<.5 Then ' random chance
    Outpt="You didn't fix it!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end chance
 Item.Charges=TreasureRecord.Charges ' store treasure maximum charges
 If Item.Charges>250 Then ' only repair item to maximum of 250 charges
    Item.Charges=250 ' set storage variable to 15 charges
 Endif ' end compare charges
 Select Case Type.Number ' select room or inventory
 Case 1 ' treasure fixed in room
    ' reset room treasure charges
    RoomRecord.TreCharges(Array.Number)=Item.Charges
    Call Share.Record(3,Room) ' write room record
 Case 0 ' treasure fixed in inventory
    ' reset inventory treasure charges
    UserRecord.Charges(Array.Number)=Item.Charges
 End Select ' end treasure fixed charges
 Outpt="You fix it!" ' make message
 Call IO.O ' send message
End Sub ' end fix routine

 Rem * routine to drink an item.

Sub Drink.Potion
 On Local Error Resume Next ' local error resume
 Call Check.Inventory.Treasure ' check treasure mnemonic
 If Index.Number=False Then ' inventory treasure index
    Outpt="You can't drink that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end treasure index
 If TreasureRecord.Potion=False Then ' compare treasure to potion
    Outpt="That's not a potion!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare potion
 ' check inventory charges remaining
 If UserRecord.Charges(Array.Number)=False Then
    Outpt="You can't, it's empty!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare charges
 Spell.Number=TreasureRecord.Spell ' get treasure spell number
 ' check spell file
 If Spell.Number>False And Spell.Number<=Lof(9)/Len(SpellRecord) Then
    Get 9,Spell.Number,SpellRecord ' get spell record
    ' reduce charges
    UserRecord.Charges(Array.Number)=UserRecord.Charges(Array.Number)-1
    Magic.Spell=SpellRecord.SpellType ' store spell type
    Multiplier=SpellRecord.Level ' store spell level
    Monster.Number=False ' monster not being attacked
    Parser=False ' no extra parameters
    Index.Number=False ' not cast on an object
    Outpt="You drink "+Outpts+"!" ' format message
    Call IO.O ' send message
    Call Magic(True) ' cast the spell
    Exit Sub ' exit routine
 Endif ' end check spell file
 Outpt="You can't drink that!" ' make message
 Call IO.O ' send message
End Sub ' end drink potion

 Rem * routine to eat an item.

Sub Eat.Object
 On Local Error Resume Next ' local error resume
 Call Check.Inventory.Treasure ' check treasure mnemonic
 If Index.Number=False Then ' inventory treasure index
    Outpt="You can't eat that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end treasure index
 If TreasureRecord.Edible=False Then ' compare treasure to food
    Outpt="That's not edible!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare food
 ' check inventory charges remaining
 If UserRecord.Charges(Array.Number)=False Then
    Outpt="You can't, it's been eaten!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare charges
 Spell.Number=TreasureRecord.Spell ' get treasure spell number
 ' check spell file
 If Spell.Number>False And Spell.Number<=Lof(9)/Len(SpellRecord) Then
    Get 9,Spell.Number,SpellRecord ' get spell record
    ' reduce charges
    UserRecord.Charges(Array.Number)=UserRecord.Charges(Array.Number)-1
    Magic.Spell=SpellRecord.SpellType ' store spell type
    Multiplier=SpellRecord.Level ' store spell level
    Monster.Number=False ' monster not being attacked
    Parser=False ' no extra parameters
    Index.Number=False ' not cast on a target
    Outpt="You eat "+Outpts+"!" ' format message
    Call IO.O ' send message
    Call Magic(True) ' cast the spell
    Exit Sub ' exit routine
 Endif ' end check spell file
 Outpt="You can't eat that!" ' make message
 Call IO.O ' send message
End Sub ' end eat routine

 Rem * routine to load device with charges from an item, loads device on
 Rem * ground or player inventory, removes item from from room or inventory.

Sub Load.Object
 On Local Error Resume Next ' local error resume
 Call Examine.Treasure ' check treasure mnemonic
 If Index.Number=False Then ' found treasure index
    Outpt="You can't load that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end treasure index
 Load.Type=False ' set load type flag
 If TreasureRecord.Loadable=True Then ' treasure can be loaded
    ' store treasure index which loads device
    Device.Type=TreasureRecord.AmmoLoads
    Load.Type=True ' set load type flag
 Endif ' end compare loaded treasure
 If TreasureRecord.Launchable=True Then ' treasure can be launched
    ' store treasure index which launchs item
    Device.Type=TreasureRecord.LaunchLoads
    Load.Type=1 ' set load type flag
 Endif ' end compare launched treasure
 If Load.Type=False Then ' compare load type flag
    Outpt="You can't load that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare load type
 ' check index bounds
 If Device.Type<False Or Device.Type>Lof(6)/Len(TreasureRecord) Then
    Outpt="There's no ammunition!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end check index bounds
 Charges.Number=False ' set treasure ammunition flag
 Get 6,Device.Type,TreasureRecord ' read treasure index of ammunition
 If Load.Type=True Then ' check load type
    If TreasureRecord.Ammunition Then ' treasure index ammunition found
       Charges.Number=True ' set treasure ammunition flag
    Endif ' end compare ammunition index
 Endif ' end load type
 If Load.Type=1 Then ' check load type
    If TreasureRecord.LaunchAmmo Then ' treasure index ammunition found
       Charges.Number=True ' set treasure ammunition flag
    Endif ' end compare ammunition index
 Endif ' end load type
 If Charges.Number=False Then ' check ammunition flag
    Outpt="There's no ammunition!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end check ammunition
 Ammo.Used=False ' set ammunition used flag
 For Inventory.Number=1 To 15 ' loop through all player inventory
    ' compare inventory index to ammo index
    If Device.Type=UserRecord.Inv(Inventory.Number) Then
       ' remove ammo from inventory
       Call Discard.Inventory(Inventory.Number,True)
       Ammo.Used=True ' set ammunition used flag
       Exit For ' exit loop to find ammo index
    Endif ' end compare inventory index
 Next ' end loop to find ammo index
 If Ammo.Used=False Then ' check ammunition used flag
    For Inventory.Number=1 To 10 ' loop through all room inventory
       ' compare room inventory to
       If Device.Type=RoomRecord.Treasure(Inventory.Number) Then
          ' ammo index, remove room ammo
          Call Discard.Room.Treasure(Inventory.Number)
          Ammo.Used=True ' set ammunition used flag
          Exit For ' exit loop to find ammo index
       Endif ' end compare inventory index
    Next ' end loop to find ammo index
 Endif ' end ammunition used flag
 If Ammo.Used=False Then ' check ammunition used flag
    Outpt="There's no ammunition!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end check ammunition used flag
 Device.Loaded=False ' set ammunition loaded flag
 Select Case Type.Number ' select room or inventory
 Case 0 ' treasure loaded in player inventory
    ' store increment charges
    Device.Charges=UserRecord.Charges(Array.Number)+1
    If Device.Charges>10 Then ' compare to maximum charges
       Device.Loaded=True ' set ammunition loaded flag
    Else ' compare less than maximum
       UserRecord.Charges(Array.Number)=Device.Charges ' increment charges
    Endif ' end compare maximum charges
 Case 1 ' treasure loaded in room inventory
    ' store increment charges
    Device.Charges=RoomRecord.TreCharges(Array.Number)+1
    If Device.Charges>10 Then ' compare to maximum charges
       Device.Loaded=True ' set ammunition loaded flag
    Else ' compare less than maximum
       RoomRecord.TreCharges(Array.Number)=Device.Charges ' increment charges
    Endif ' end compare maximum charges
    Call Share.Record(3,Room) ' write room record
 End Select ' end compare inventory to load
 If Device.Loaded Then ' compare ammunition loaded flag
    Outpt="The device can't load that much!" ' make message
 Else ' ammunition loaded
    Outpt="You load the device!" ' make message
 Endif ' end compare ammunition loaded flag
 Call IO.O ' send message
End Sub ' end routine to load ammunition to an item

 Rem * routine to fire a device at a monster in room, device explodes in
 Rem * player by chance, device discharges harmlessly.

Sub Fire.Object
 On Local Error Resume Next ' local error resume
 Call Find.Inventory ' check player inventory for mnemonic of device to fire
 If Index.Number=False Then ' found treasure index to player inventory
    Outpt="You can't fire that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end check treasure index
 If TreasureRecord.Loadable=False Then ' check device can be loaded
    Outpt="You can't fire that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare device
 If TreasureRecord.AmmoLoads=False Then ' check item which loads device
    Outpt="It's not loaded with ammunition!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare device
 Get 6,TreasureRecord.AmmoLoads,TreasureRecord ' read record of ammo used
 If TreasureRecord.Ammunition=False Then ' item which loads device is nto ammo
    Outpt="It's not loaded with ammunition!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare device
 ' read treasure record index of device to fire
 Get 6,Index.Number,TreasureRecord
 If Parser=False Then ' check second parameter of monster to fire at
    Outpt="Fire at what?" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare monster
 ' compare remaining charges in device
 If UserRecord.Charges(Array.Number)=False Then
    Outpt="It's not loaded!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare device
 ' decrement charges
 UserRecord.Charges(Array.Number)=UserRecord.Charges(Array.Number)-1
 Parsed.Command1=Parsed.Command2 ' get second parameter of monster
 Call Numeric ' parse out temp variable
 If Rnd<.2 Then ' compute random chance
    Outpt="Bang! The ammunition explodes in your face!" ' device backfires
    Call IO.O ' send message
    Outpt="The device hits you for" ' string preceding points hit on player
    Hits#=Cdbl(Int(Rnd*Abs(TreasureRecord.Plus)+1)) ' calculate random hits
    Call Hit.Player(Hits#) ' routine to get hits on player
    Exit Sub ' exit routine
 Endif ' end random chance
 If Rnd<.2 Then ' random chance
    Outpt="The device fires harmlessly!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end random chance
 Treasure.Name$=TreasureRecord.ShortName ' store treasure name being fired
 Treasure.Name$=Rtrim$(Treasure.Name$) ' strip trailing blanks
 Treasure.Name$=Lcase$(Treasure.Name$) ' format to lower case
 Call Check.Monster ' find monster being fired at in parsed string
 If Monster.Number Then ' monster found from second parameter
    Outpts=MonsterArray(Monster.Number).MonsterName ' store monster name
    Outpts=Rtrim$(Outpts) ' strip trailing blanks
    Outpts=Lcase$(Outpts) ' format to lower case
    Outpt="You fire the "+Treasure.Name$+" at the "+Outpts+"!" ' format message
    Call IO.O ' send message
    Multiplier=Abs(TreasureRecord.Plus) ' calculate hits on monster multiplier
    Call Hit.Monster ' routine to attack monster in Monster.Number
    Exit Sub ' exit routine
 Endif ' end compare monster to fire at
 Outpt="The device fires into empty air!" ' make message
 Call IO.O ' send message
End Sub ' end routine to fire a device at a monster

 Rem * dm/sysop routine to get an item from treasure or object files and
 Rem * add to room, interactive function during remote logon also.

Sub Drop.Object
 On Local Error Resume Next ' local error resume
 Parsed.Command1=Stored.Parsed.Command2 ' get entire second half of command
 Call Numeric ' parse temp variable
 Inpt=Parsed.Command1 ' put full name of item in variable
 Inpt=Lcase$(Inpt) ' convert to lower case
 Call Drop(True) ' routine to put item name in room
End Sub ' end dm/sysop drop routine

 Rem * routine to search a container.

Sub Search.Object
 On Local Error Resume Next ' local error resume
 Call Examine.Container ' check player and room inventory for container name
 If Index.Number Then ' found container index, placed into container record
    If ContainerRec.Locked>False Then ' compare container lock
       Outpt="You can't, it's locked!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare container
    If ContainerRec.Closed>False Then ' compare container closed
       Outpt="You can't, it's closed!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare container
    Outpt="You search the container.." ' make message
    Call IO.O ' send message
    Graphics.Off=True ' color white
    Outpt="In it you find " ' preceding message
    Item.Counter=False ' container contents counter
    For Array.Number=1 To 5 ' loop through all container contents
       If ContainerRec.Invisible(Array.Number) Then ' compare invisible item
          ' get container treasure index
          Inventory.Number=ContainerRec.Inventory(Array.Number)
          If Inventory.Number>False And_
             Inventory.Number<=Lof(6)/Len(TreasureRecord) Then ' bounds
             ' read index from treasure file
             Get 6,Inventory.Number,TreasureRecord
             If Rnd>.5 Then ' compute random chance
                Carriage.Return=True ' supress cr/lf
                Call IO.O ' send message
                Outpt=TreasureRecord.TreasureName ' get treasure name found
                Outpt=Rtrim$(Outpt)+", " ' format treasure name
                ' increment container contents counter
                Item.Counter=Item.Counter+1
             Endif ' end random chance
          Endif ' end check treasure file bounds
       Endif ' end compare container contents invisible
    Next ' end loop through all container contents
    If Item.Counter=False Then ' compare no contents found
       Outpt="In it you find nothing.." ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare container content counter
    Outpt=Left$(Outpt,Len(Outpt)-2)+"." ' format message, strip trailing comma
    If Item.Counter>1 Then ' compare container content counter
       Outpt="and "+Outpt ' format message with last contents found
    Endif ' end compare content counter
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end find container to search
 Outpt="You can't search that!" ' make message
 Call IO.O ' send message
End Sub ' end routine to search container

 Rem * routine to bless an object by increasing the magical charges.

Sub Bless.Object
 On Local Error Resume Next ' local error resume
 If Normal.User Then ' check player is normal player
    If UserRecord.ClassType<>Cleric Then ' compare player class type to cleric
       Outpt="Only clerics can bless!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare class type
 Endif ' end compare player type
 Call Examine.Treasure ' check treasure mnemonic
 If Index.Number Then ' found treasure index
    Charges.Number=TreasureRecord.Spell ' store treasure spell type
    If Charges.Number=False Then ' compare treasure spell type
       Outpt="You can't bless that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare treasure type
    ' check file bounds
    If Charges.Number>False And Charges.Number<Lof(9)/Len(SpellRecord) Then
       ' read spell record from treasure index
       Get 9,Charges.Number,SpellRecord
       If SpellRecord.SpellType=4 Then ' compare spell to wish
          Outpt="You can't bless that!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' and compare spell
       Object.Blessed=False ' set object blessed flag
       Max.Charges=TreasureRecord.Charges ' store maximum charges
       Select Case Type.Number ' select room or inventory
       Case 0 ' bless item in player inventory
          ' get incremented charges
          Type.Charges=UserRecord.Charges(Array.Number)+1
          If Type.Charges>Max.Charges Then ' compare maximum charges
             Object.Blessed=True ' set bless flag
          Else ' compare charges
             ' set incremented charges
             UserRecord.Charges(Array.Number)=Type.Charges
          Endif ' end compare maximum charges
       Case 1 ' bless item in room inventory
          ' get incremented charges
          Type.Charges=RoomRecord.TreCharges(Array.Number)+1
          If Type.Charges>Max.Charges Then ' compare maximum charges
             Object.Blessed=True ' set bless flag
          Else ' compare charges
             ' set incremented charges
             RoomRecord.TreCharges(Array.Number)=Type.Charges
             Call Share.Record(3,Room) ' write room record
          Endif ' end compare maximum charges
       End Select ' end inventory type
       If Object.Blessed Then ' compare bless flag
          Outpt="Nothing happens!" ' make message
       Else ' compare bless flag
          Outpt="You bless it!" ' make message
       Endif ' end compare flag
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif
 Endif
 Outpt="You can't bless that!" ' make message
 Call IO.O ' send message
End Sub ' end routine to bless an object

 Rem * routine to curse a monster by decreasing hits.

Sub Curse.Object
 On Local Error Resume Next ' local error resume
 If Normal.User Then ' check player type
    If UserRecord.ClassType<>Cleric Then ' check player class type to cleric
       Outpt="Only clerics can curse!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare class type
 Endif ' end compare player type
 Call Check.Monster ' search for monster parameter
 If Monster.Number Then ' index found to monster array
    Outpts=MonsterArray(Monster.Number).MonsterName ' store full monster name
    Outpts=Rtrim$(Outpts) ' strip trailing blanks
    Outpts=Lcase$(Outpts) ' convert to lower case
    Outpt="You curse the "+Outpts+"!" ' format message
    Call IO.O ' send message
    Multiplier=Int(UserRecord.Stats(6)/2) ' compute hits on monster multiplier
    Call Hit.Monster ' routine to attack a monster
    Exit Sub ' exit routine
 Endif ' end get monster index
 Outpt="You can't curse that!" ' make message
 Call IO.O ' send message
End Sub ' end routine to curse a monster

 Rem * routine to bless player (bless without parameter).

Sub Bless.Self
 On Local Error Resume Next ' local error resume
 If Normal.User Then ' check player type
    If UserRecord.ClassType<>Cleric Then ' check player class type
       Outpt="Only clerics can bless!" ' message for clerics only
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare class type
 Endif ' end compare player type
 Type.Charges=UserRecord.Stats(6)+1 ' store incremented piety
 If Type.Charges>MaxStat Then ' compare to maximum piety
    Outpt="Nothing happens!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare piety
 UserRecord.Stats(6)=Type.Charges ' update new piety
 Outpt="You feel a glow about you!" ' make message
 Call IO.O ' send message
 Outpt="Your piety is now"+Str$(Type.Charges)+"!" ' format message
 Call IO.O ' send message
End Sub ' end routine to bless self

Rem * routine to curse player (curse without parameter).

Sub Curse.Self
 On Local Error Resume Next ' local error resume
 If Normal.User Then ' check player type
    If UserRecord.ClassType<>Cleric Then ' check player class type
       Outpt="Only clerics can curse!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare class type
 Endif ' end compare player type
 Type.Charges=UserRecord.Stats(6)-1 ' store decremented piety
 If Type.Charges<=False Then ' compare to minimum piety
    Outpt="Nothing happens!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare piety
 UserRecord.Stats(6)=Type.Charges ' set new piety
 Outpt="You feel a darkening about you!" ' make message
 Call IO.O ' send message
 Outpt="Your piety is now"+Str$(Type.Charges)+"!" ' format message
 Call IO.O ' send message
End Sub ' end routine to curse self

 Rem * routine to move a lanuch type object to a nearby room and move player
 Rem * to room also, verify room traps.

Sub Move.Object
 On Local Error Resume Next ' local error resume
 Call Parse ' parse out parameters
 If Parser Then ' check for first parameter
    Call Numeric '  parse temp variable from first parameter
 Endif ' end check parameter
 Call Examine.Treasure ' check treasure mnemonic in inventory or room
 If Index.Number=False Then ' locate treasure index
    Outpt="You can't move that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare treasure
 If TreasureRecord.Movable=False Then ' compare treasure can be moved
    Outpt="You can't move that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare treasure
 If TreasureRecord.Launchable=False Then ' compare treasure can be launched
    Outpt="You can't move that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare treasure
 If Parser=False Then ' compare parameter parsed
    Outpt="Move which direction?" ' no direction specified
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end check parse
 Treasure.Name$=Outpts ' store full treasure name to be moved
 Item.Number=Array.Number ' store treasure index to array
 Item.Charges=Charges.Number ' store treasure charges
 Item.Index=Index.Number ' store treasure index to file
 User.Command=Parsed.Command2 ' get second parameter
 Call Get.Direction(Direction.Number) ' compare moving parameter to direction
 If Direction.Number Then ' direction found flag set
    Next.Room=RoomRecord.Direct(Direction.Number) ' get room number direction
    If Next.Room=False Then ' compare room number
       Outpt="You can't move it there!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare room number
 Else ' no direction flag set, check for moving through an object
    Parsed.Command1=User.Command ' get second parameter
    Call Check.Room.Objects ' check with mnemonic name of object in room
    If Index.Number=False Then ' check object index
       Outpt="You can't move it there!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare room object
    If ObjectRecord.RoomLink=False Then ' verify room object links to room
       Outpt="You can't move it there!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare object is a portal
    If ObjectRecord.JailTrap Then ' verify room is trapped
       Outpt="Trapped portal!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare room trap
    If ObjectRecord.Closed Then ' compare room closed
       If Pass.Door=False Then ' check is passdoor spell cast
          Outpt="You can't, it's closed!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end cmpare passdoor
    Endif ' end compare object closed
    If ObjectRecord.Relocks Then ' object portal closes after entry
       ObjectRecord.DoorLock=2 ' set object portal lock
       ObjectRecord.Closed=True ' set object portal closed
       Call Share.Record(4,Index.Number) ' write object record
    Endif ' end compare relocking object portal
    Pass.Door=False ' reset passdoor spell
    Next.Room=ObjectRecord.RoomLink ' get room number to enter portal
 Endif ' end compare move to a direction or to a portal
 Swap Room,Next.Room ' interchange current room with next room to move item
 Get 3,Room,RoomRecord ' read next room to move item to room file
 ' routine to add room item
 Call Add.Room.Treasure(Item.Index,Item.Charges,False,Item.Added)
 Swap Room,Next.Room ' interchange current room with next room
 Get 3,Room,RoomRecord ' read current room record
 If Item.Added Then ' add item to room flag
    Select Case Type.Number ' select room or inventory
    Case 0 ' treasure moved from player inventory
       Call Discard.Inventory(Item.Number,True) ' remove item from inventory
    Case 1 ' treasure moved from room
       Call Discard.Room.Treasure(Item.Number) ' remove item from room
    End Select ' end compare treasure moved
    Outpt="You move "+Treasure.Name$+"!" ' format message
    Call IO.O ' send message
    Call Enter.Room ' move player to next room
    Exit Sub ' exit routine
 Endif ' end locate empty room inventory
 Outpt="You can't move it there!" ' make message
 Call IO.O ' send message
End Sub ' end routine to move an item

 Rem * routine to launch an item in a specific direction to smash through
 Rem * a random amount of object portal locks connected through successive
 Rem * rooms, or to launch a weapon at a monster.

Sub Launch.Object
 On Local Error Resume Next ' local error resume
 Call Parse ' get first parameter
 If Parser Then ' found parameter
    Call Numeric ' parse number after # sign
 Endif ' end compare parse
 Call Examine.Treasure ' check treasure mnemonic to room or player inventory
 If Index.Number=False Then ' treasure index not found
    Outpt="You can't launch that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare index
 If TreasureRecord.Launchable=False Then ' check if treasure can be launched
    Outpt="That's not a launchable device!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare item to launch
 If Parser=False Then ' compare second parameter
    Outpt="Launch where?" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare second parameter
 Item.Launched=False ' item was launched flag
 Item.Type=Type.Number ' store inventory type
 Item.Index=Array.Number ' store launched item index to array
 Item.Charges=Charges.Number ' store launched item charges
 If Charges.Number=False Then ' compare remaining charges in device
    Outpt="You can't, it's not loaded!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare device
 If Item.Charges>10 Then ' compare device charges
    Item.Charges=10 ' reset maximum charges
 Endif ' end compare device
 Launch.Number=False ' variable of number of loads launched
 Treasure.Name$=TreasureRecord.ShortName ' store name of device
 Treasure.Name$=Rtrim$(Treasure.Name$) ' strip trailing blanks
 Treasure.Name$=Lcase$(Treasure.Name$) ' convert to lower case
 User.Command=Parsed.Command2 ' get second parameter
 Parsed.Command1=User.Command ' store parameter
 Call Get.Direction(Direction.Number) ' determine direction to launch at
 If Direction.Number Then ' returned variable contains direction number
    Next.Room=RoomRecord.Direct(Direction.Number) ' get next room direction
    If Next.Room=False Then ' compare room number
       Outpt="You can't launch at that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare room number
    Item.Launched=True ' set item is launched flag
    Outpts=Direction(Direction.Number) ' store direction name
    Outpts=Rtrim$(Outpts) ' strip trailing blanks
    Outpts=Lcase$(Outpts) ' convert to lower case
    Outpt="You launch the "+Treasure.Name$+" "+Outpts+"!" ' format message
    Call IO.O ' send message
    ' loop through all charges in device to launch
    For Launchs=1 To Item.Charges
       Graphics.Off=False ' color normal
       Outpt="For launch"+Str$(Launchs)+";" ' format message of launch number
       Call IO.O ' send message
       Launch.Number=Launch.Number+1 ' increment number of launches
       Graphics.Off=True ' color white
       Outpt="The device launchs: " ' message
       Carriage.Return=True ' suppress cr/lf
       Call IO.O ' send message
       Outpt=Outpts+", " ' first direction device launches
       Carriage.Return=True ' suppress cr/lf
       Call IO.O ' send direction message
       Locks.Smashed=False ' counter of number of locks smashed
       Rooms.Chained=False ' number of rooms chained to
       Call Chain.Rooms(Next.Room,Room) ' routine to send launched item
       Outpt="and stopped!" ' trailing message
       Call IO.O ' send message
    Next ' end loop through all device launch charges
    If Locks.Smashed=False Then ' compare number of locks smashed
       Outpt="You didn't smash anything!" ' make message
    Else ' compare lock number
       Outpt="You smashed open" ' format message
       Outpt=Outpt+Str$(Locks.Smashed) ' with number of locks smashed
       If Locks.Smashed=1 Then ' compare number
          Outpt=Outpt+" lock.." ' append message
       Else ' compare number
          Outpt=Outpt+" locks!" ' append message
       Endif ' end compare
    Endif ' end compare number
    Call IO.O ' send message
    Graphics.Off=False ' color normal
    Get 3,Room,RoomRecord ' read current room record
 Else ' verify monster to launch at
    Call Check.Monster ' find monster mnemonic to launch device at
    If Monster.Number Then ' found monster variable indexed to array
       Multiplier=Abs(TreasureRecord.Plus) ' compute attack multiplier
       ' store full monster name
       Outpts=MonsterArray(Monster.Number).MonsterName
       Outpts=Rtrim$(Outpts) ' strip trailing blanks
       Outpts=Lcase$(Outpts) ' convert to lower case
       Outpt="You launch "+Treasure.Name$+" at the "+Outpts+"!" ' make message
       Call IO.O ' send message
       Item.Launched=True ' set item is launched flag
       Graphics.Off=True ' color white
       ' loop through all charges in device to launch
       For Launchs=1 To Item.Charges
          ' format message of launch number
          Outpt="For launch"+Str$(Launchs)+";"
          Call IO.O ' send message
          Launch.Number=Launch.Number+1 ' increment number of launches
          Call Attack.Monster ' routine to hit monster
          Call Check.Monster ' reverify monster being attacked
          If Monster.Number=False Then ' monster is not found
             Exit For ' exit device launch loop
          Endif ' end compare monster
       Next ' end loop through all device launch charges
       Graphics.Off=False ' color normal
    Endif ' end find monster
 Endif ' end compare launch direction or monster
 If Item.Launched=False Then ' device was launched flag
    Outpt="You can't launch at that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare if launched
 If Item.Type=False Then ' device launched from player inventory
    ' compute loads launched decrement
    Total.Charges=UserRecord.Charges(Item.Index)-Launch.Number
    If Total.Charges<False Then ' compare lower limit
       Total.Charges=False ' set lower limit
    Endif ' end compare limit
    UserRecord.Charges(Item.Index)=Total.Charges ' store inventory charges
 Else ' device lanuched from room
    ' compute loads launched decrment
    Total.Charges=RoomRecord.TreCharges(Item.Index)-Launch.Number
    If Total.Charges<False Then ' compare lower limit
       Total.Charges=False ' set lower limit
    Endif ' end compare limit
    RoomRecord.TreCharges(Item.Index)=Total.Charges ' store room charges
    Call Share.Record(3,Room) ' write room record
 Endif ' end compare launched from
End Sub ' end routine to launch an item from a device

 Rem * routine to recursively enter rooms by nearby room links, smashing a
 Rem * random number of portals.

Sub Chain.Rooms(Chain.Room,Previous.Room)
 ' Chain.Room is a passed parameter of the next room to access.
 ' Previous.Room stores the called room number to be restored upon exit.
 On Local Error Resume Next ' local error resume
 Get 3,Chain.Room,RoomRecord ' get next chained to room
 For Array.Number=1 To 10 ' loop through all objects in room
    Object.Number=RoomRecord.Object(Array.Number) ' get object index to file
    ' check object file bounds
    If Object.Number>False And Object.Number<=Lof(4)/Len(ObjectRecord) Then
       Get 4,Object.Number,ObjectRecord ' get the object record
       If ObjectRecord.DoorLock=2 Then ' check if object is locked
          If Rnd>.66 Then ' compute random chance
             Locks.Smashed=Locks.Smashed+1 ' increment locks smashed counter
             ObjectRecord.DoorLock=1 ' set object unlocked
             ObjectRecord.Closed=False ' set object to open
             Call Share.Record(4,Object.Number) ' write object record
          Endif ' end random chance
       Endif ' end compare object lock
    Endif ' end end object bounds
 Next ' end loop through all objects
 For Direction.Number=1 to 11 ' loop through all directions in chained to room
    Next.Room=RoomRecord.Direct(Direction.Number) ' get the room number of the
    If Next.Room Then ' direction and compare to
       If Next.Room<>Previous.Room Then ' the current room in routine
          If Rnd>.66 Then ' compute random chance
             If Rooms.Chained<5 Then ' compare to maximum of 5 recursive calls
                Carriage.Return=True ' suppress cr/lf
                Outpt=Direction(Direction.Number) ' get direction name
                Outpt=Rtrim$(Outpt)+", " ' format message
                Call IO.O ' send message
                ' increment number of recursively chained rooms
                Rooms.Chained=Rooms.Chained+1
                Call Chain.Rooms(Next.Room,Chain.Room) ' routine calls self
                Get 3,Chain.Room,RoomRecord ' to next room, get previous room
                Exit Sub ' exit routine (recursively exiting previous calls)
             Endif ' end compare maximum
          Endif ' end random chance
       Endif ' end compare to current room
    Endif ' end compare next direction
 Next ' end loop through all directions in called room (exit recursively)
End Sub ' end routine to recursively loop through all objects in neraby rooms

 Rem * routine for player to steal an item from a monster.

Sub Steal.Object
 On Local Error Resume Next ' local error resume
 If Normal.User Then ' check player type
    If UserRecord.ClassType<>Thief Then ' check player class type
       Outpt="Only thieves can steal!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare class type
 Endif ' end compare player type
 Call ParseX ' parse the second parameter
 If Parser Then ' parse the
    Call Numeric ' number after the # sign
 Endif ' end parse
 If Parser=False Then ' no second parameter
    Outpt="Steal from whom?" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare parse
 Call Check.Monster ' verify monster mnemonic
 If Monster.Number Then ' monster index
    Parsed.Command1=Lcase$(Parsed.Command2) ' get first parameter
    Call Numeric ' parse number
    For Array.Number=1 To 5 ' loop through all monster treasure
       ' get monster treasure index
       Treasure.Number=MonsterArray(Monster.Number).Treasure(Array.Number)
       ' check file bounds
       If Treasure.Number>False And_
       Treasure.Number<=Lof(6)/Len(TreasureRecord) Then
          Get 6,Treasure.Number,TreasureRecord ' read treasure record
          Inpt=TreasureRecord.ShortName ' store short treasure mnemonic
          Inpt=Rtrim$(Inpt) ' strip trailing blanks
          Inpt=Lcase$(Inpt) ' convert to lower case
          Inpt=Left$(Inpt,Len(Parsed.Command1)) ' shorten to parsed length
          If Inpt=Parsed.Command1 Then ' compare treasure to parsed treasure
             ' compare monster to magical, or permanent
             If MonsterArray(Monster.Number).Magic<=True Or_
             MonsterArray(Monster.Number).Permanent<=True Then
                Outpt="You can't steal from that monster!" ' make message
                Call IO.O ' send message
                Exit Sub ' exit routine
             Endif ' end compare monster
             ' compute random chance
             If Int(Rnd*5+5)>UserRecord.Stats(4)/2 Then
                Outpt="Didn't work!" ' make message
                Call IO.O ' send message
                Exit Sub ' exit routine
             Endif ' end random chance
             Inpt=TreasureRecord.TreasureName ' get full name of treasure
             Inpt=Rtrim$(Inpt) ' strip trailing blanks
             Inpt=Lcase$(Inpt) ' convert to lower case
             ' get monster name
             Outpts=MonsterArray(Monster.Number).MonsterName
             Outpts=Rtrim$(Outpts) ' strip trailing blanks
             Outpts=Lcase$(Outpts) ' convert to lower case
             Item.Charges=TreasureRecord.Charges ' store charges
             ' add to player inventory
             Call Add.Inventory(Treasure.Number,Item.Charges,Item.Added)
             If Item.Added Then ' flag set to add inventory
                Outpt="You steal "+Inpt+" from the "+Outpts+"!" ' make message
                Call IO.O ' send message
                ' clear element in monster inventory array
                MonsterArray(Monster.Number).Treasure(Array.Number)=False
                Exit Sub ' exit routine
             Endif ' end compare flag
          Endif ' end compare treasure
       Endif ' end compare treasure
    Next ' end loop through all monster inventory
 Endif ' end find monster number
 Outpt="You can't steal that!" ' make message
 Call IO.O ' send message
End Sub ' end routine to steal

 Rem * routine to throw an item of player inventory at monster, weapon falls
 Rem * into the room.

Sub Throw.Object
 On Local Error Resume Next ' local error resume
 If Normal.User Then ' verify player type
    If UserRecord.ClassType<>Thief Then ' verify player class type
       Outpt="Only thieves can throw!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare class type
 Endif ' end compare player type
 Call ParseX ' get second parameter
 If Parser Then ' parse parameter
    Call Numeric ' store number
 Endif ' end compare parse
 If Parser=False Then ' missing second parameter
    Outpt="Throw at whom?" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare parameter
 Call Check.Monster ' find monster in room
 If Monster.Number Then ' found monster index
    Last.Monster=Parsed.Command1 ' reset last monster attacked
    Parsed.Command1=Ucase$(Parsed.Command2) ' get first parameter
    Call Numeric ' parse number sign
    Call Check.Inventory.Treasure ' search player inventory for treasure
    If Index.Number>False Then ' found treasure index in player inventory
       ' weapon being held must match the weapon thrown
       If Weapon6=Array.Number Then
          Multiplier=Weapon2 ' set attack multiplier
          Inpt=MonsterArray(Monster.Number).MonsterName ' get monster name
          Inpt=Rtrim$(Inpt) ' strip trailing blanks
          Inpt=Lcase$(Inpt) ' convert to lower case
          Outpt="You throw "+Outpts+" at the "+Inpt+"!" ' format message
          Call IO.O ' send message
          If Int(Rnd*5+2)>UserRecord.Stats(4)/2 Then ' compute random chance
             Outpt="You missed!" ' make message
             Call IO.O ' send message
          Else ' random chance
             Parsed.Command1=Last.Monster ' reset parameter to last monster
             Last.Command.Number=55 ' reset the command number to attack
             Call Attack.Monster ' routine to hit monster
          Endif ' end random chance
          Call Discard.Inventory(Weapon6,False) ' remove item from inventory
          Exit Sub ' exit routine
       Endif ' end compare weapon being held
       Outpt="You are'nt holding the weapon!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end search for weapon to throw
 Endif ' end search for monster
 Outpt="You can't throw that!" ' make message
 Call IO.O ' send message
End Sub ' end routine to throw an object

 Rem * routine to fuel an item from the charges of another item.

Sub Fuel.Object
 On Local Error Resume Next ' local error resume
 Call Find.Inventory ' parse first parameter, search player inventory
 Treasure.Name$=TreasureRecord.ShortName ' store treasure short mnemonic name
 Treasure.Name$=Rtrim$(Treasure.Name$) ' strip trailing blanks
 Treasure.Name$=Lcase$(Treasure.Name$) ' convert to lower case
 If Index.Number=False Then ' compare treasure index
    Outpt="You can't fuel that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare index
 If TreasureRecord.LightType=False Then ' check treasure can be fueled
    Outpt="You can't fuel that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare treasure
 If TreasureRecord.LightCharges=False Then ' check treasure can be fueled
    Outpt="It has no light charges!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare treasure
 If UserRecord.Charges(Array.Number) Then ' check treasure already fueled
    Outpt="It's already fueled!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare treasure
 Fuel.Charges=TreasureRecord.LightCharges ' store treasure light charges
 Item.Number=Array.Number ' store treasure array index
 If Parser=False Then ' compare second parameter
    Outpt="Fuel with what?" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare parse
 Parsed.Command1=Parsed.Command2 ' get second parameter
 Call Numeric ' parse number
 Call Find.Inventory ' search player inventory
 If Index.Number=False Then ' compare treasure index
    Outpt="You can't fuel with that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare index
 If TreasureRecord.FuelType=False Then ' check treasure is a fuel
    Outpt="You can't fuel with that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare treasure
 If TreasureRecord.FuelCharges<=False Then ' check treasure fuel amount
    Outpt="It has no fuel charges!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare treasure
 If UserRecord.Charges(Array.Number)=False Then ' check fuel charges
    Outpt="It has no fuel charges!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare treasure
 ' decrement fuel
 UserRecord.Charges(Array.Number)=UserRecord.Charges(Array.Number)-1
 UserRecord.Charges(Item.Number)=Fuel.Charges ' add fuel charges to treasure
 Outpt="You fuel the "+Treasure.Name$+"!" ' format message
 Call IO.O ' send message
End Sub ' end routine to fuel an item

 Rem * routine to light an item.

Sub Light.Object
 On Local Error Resume Next ' local error resume
 Call Check.Inventory.Treasure ' search for player inventory treasure
 If Index.Number=False Then ' compare treasure index
    Outpt="You can't light that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare treasure index
 If TreasureRecord.LightType=False Then ' check treasure is a light
    Outpt="That's not a light!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare treasure
 If UserRecord.Charges(Array.Number)=False Then ' check treasure is fueled
    Outpt="You can't, it's not fueled!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare treasure
 ' check treasure is already lit
 If UserRecord.Charges(Array.Number)<False Then
    Outpt="It's already lit!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare treasure
 ' set inventory charges
 UserRecord.Charges(Array.Number)=-UserRecord.Charges(Array.Number)
 Outpts=TreasureRecord.ShortName ' to negative to indicate treasure is a light
 Outpts=Rtrim$(Outpts) ' store treasure name, strip trailing blanks
 Outpts=Lcase$(Outpts) ' convert to lower case
 Outpt="You light the "+Outpts+"!" ' format message
 Call IO.O ' send message
End Sub ' end routine to light an item

Rem * dm/sysop routine to discard an item of inventory to nowhere, can be
Rem * used interactively during remote with function key.

Sub Discard.Object
 On Local Error Resume Next ' local error resume
 Call Check.Inventory.Treasure ' find treasure in player inventory
 If Index.Number Then ' treasure index to player array
    ' routine to remove from inventory
    Call Discard.Inventory(Array.Number,True)
    Outpt="You discard "+Outpts+"!" ' format message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end search treasure inventory
 Call Num ' decrement parse counter
 Call Check.Inventory.Objects ' find object in player inventory
 If Index.Number Then ' object index to player array
    Call Discard.Inventory.Object(Array.Number)
    Outpt="You discard "+Outpts+"!" ' format message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end search object inventory
 Outpt="You can't discard that!" ' make message
 Call IO.O ' send message
End Sub ' end routine to discard an item

 Rem * main routine to enter mail and process mail selections.

Sub Mail
 On Local Error Resume Next ' local error resume
 Redim Array(1 To 64) As String ' dimension message array
 Do ' loop through mail commands
    Graphics.Off=True ' reset color
    Outpt="[E]nter" ' make display message
    Call IO.O ' send message
    Outpt="[K]ill" ' make display message
    Call IO.O ' send message
    Outpt="[L]ock" ' make display message
    Call IO.O ' send message
    Outpt="[N]ew" ' make display message
    Call IO.O ' send message
    Outpt="[R]ead" ' make display message
    Call IO.O ' send message
    Graphics.Off=False ' reset color
    Outpt="Mail command(q to quit)? " ' input prompt
    No.Input.Out="Q" ' default input
    Call IO.I ' get player input
    Select Case Ucase$(Inpt) ' selection of input
    Case "E" ' option to enter message
       Call Enter.Message ' routine to enter message
    Case "K" ' option to kill message
       Call Kill.Message ' routine to kill message
    Case "L" ' option to toggle locked mailbox
       Call Lock.Mailbox ' routine to toggle locked mailbox
    Case "N" ' option to read new messages
       Call New.Messages ' routine to read new messages
    Case "R" ' option to read messages
       Call Read.Messages ' routine to read messages
    Case "Q" ' option to exit mail menu
       Exit Do ' exit mail menu
    End Select ' end mail option selection
 Loop ' end loop through mail menu
 Redim Array(1 To 1) As String ' redimension array
End Sub ' end mail routine

 Rem * routine to enter a message.
 Rem * output variables:
 Rem *   Array - array containing message.
 Rem *   Message.Length - number of message text lines.
 Rem *   Message.To - codename or null of player message is to.
 Rem *   Private.Message - true if message is private.
 Rem *   Subject - contains subject of message.

Sub Enter.Message
 On Local Error Resume Next ' local error resume
 If Lof(10)/Len(TableRecord)=MaxInt Then ' check table size
    Outpt="The message table is full." ' make error output message
    Call IO.O ' send error output
    Exit Sub ' exit routine
 Endif ' end check table size
 Call Share.Record(1,User.Index) ' routine to store player record
 Do ' loop until message to stored
    Graphics.Off=True ' reset color
    Private.Message=False ' reset private message flag
    Outpt="Message to(Press <enter> for ALL)? " ' input prompt
    Call IO.I ' get player input
    Message.To=Ucase$(Inpt) ' uppercase and store input
    If Inpt=Nul Then ' compare null input
       Exit Do ' exit loop with message to all
    Endif ' end compare input length
    For User.Number=1 To Lof(3)/Len(UserRecord) ' loop through player file
       Get 1,User.Number,UserRecord ' read next player record
       Outpt=UserRecord.CodeName ' store codename
       Call Decrypt(Outpt) ' routine to decrypt codename
       Outpt=Rtrim$(Outpt) ' trim codename
       Outpt=Ucase$(Outpt) ' uppercase codename
       If Message.To=Outpt Then ' compare codename to input
          If User.Index<>User.Number Then ' check not self
             If (UserRecord.Flags And Locked.User)=False Then ' check locked
                Outpt="Private message(y/n)? " ' input prompt
                No.Input.Out="N" ' default input
                Call IO.I ' get player input
                Private.Message=Yes ' store private message flag
                Exit Do ' exit loop until message to found
             Endif ' end check locked player mailbox
          Endif ' end check player indexes
       Endif ' end check codename
    Next ' end loop through player file
    Outpt="There is no such user." ' make display message
    Call IO.O ' send message
 Loop ' end loop until message to stored
 Get 1,User.Index,UserRecord ' reread player record
 Do ' loop until subject entered
    Outpt="Subject? " ' input prompt
    Call IO.I ' get player input
    Inpt=Ltrim$(Inpt) ' trim input
    Inpt=Rtrim$(Inpt) ' trim input
    Inpt=Lcase$(Inpt) ' lowercase input
    If Inpt<>Nul Then ' check input length
       Subject=Inpt ' store input in subject string
       Exit Do ' exit subject loop
    Endif ' end check input length
    Outpt="Abort message(y/n)? " ' input prompt
    No.Input.Out="N" ' default input
    Call IO.I ' get player input
    If Yes Then ' check input response
       Exit Sub ' exit message enter routine
    Endif ' end check input response
 Loop ' end loop until subject entered
 Message.Reply=False
 Outpt="Enter message." ' make message
 Call IO.O ' send message
 Call Write.Message ' routine to enter and store message
End Sub ' end routine to enter a message

 Rem * routine to write message.

Sub Write.Message
 On Local Error Resume Next ' local error resume
 Message.Length=False ' reset message length entered
 User.Word.Wrap=UserRecord.Wordwrap ' store user word wrap
 UserRecord.Wordwrap=False ' reset word wrap
 Do ' loop until message entered
    Outpt="Press <enter> on a blank line to edit." ' make message
    Call IO.O ' send message
    Do ' loop until blank line entered
       Graphics.Off=True ' reset color
       If Message.Length=64 Then ' compare length of message entered
          Outpt="Message buffer full." ' make buffer message
          Call IO.O ' send message
          Exit Do ' exit message entry loop
       Endif ' end compare message length
       Word.Wrap=True ' set word wrap flag
       Outpt="?" ' input prompt
       Call IO.I ' get player input
       If No.Input Then ' check blank line entered
          Exit Do ' exit message entry loop
       Endif ' end check blank line
       Message.Length=Message.Length+1 ' increment message length counter
       Inpt=Rtrim$(Inpt) ' trim input
       Inpt=Left$(Inpt,79) ' truncate input
       Array(Message.Length)=Inpt ' store next message line
    Loop ' end loop until blank line entered
    Word.Wrap=False ' reset word wrap flag
    UserRecord.Wordwrap=User.Word.Wrap ' restore user word wrap
    Call Edit.Message(Message.Edit) ' routine to edit message text
    ' selection of return variable from message editing
    Select Case Message.Edit
    Case True ' true returned
       Outpt="Continue editing." ' make display message
       Call IO.O ' send message
    Case False ' false returned
       Exit Sub ' message aborted
    Case UnTrue ' other returned
       Call Store.Message ' message stored
       Exit Sub ' exit message entry routine
    End Select ' end selection of edit return variable
 Loop ' end loop until message entered
End Sub

 Rem * routine to lock/unlock player mailbox.

Sub Lock.Mailbox
 On Local Error Resume Next ' local error resume
 ' check player locked mailbox
 If (UserRecord.Flags And Locked.User)=False Then
    Outpt="Mailbox locked." ' make locked message
    UserRecord.Flags=UserRecord.Flags Or Locked.User ' set locked player flag
 Else ' check player locked
    Outpt="Mailbox unlocked." ' make locked message
    UserRecord.Flags=UserRecord.Flags And Not Locked.User ' reset locked flag
 Endif ' end check player locked flag
 Call IO.O ' send message
 Call Share.Record(1,User.Index) ' routine to wite player record
End Sub

 Rem * routine to delete message.

Sub Kill.Message
 On Local Error Resume Next ' local error resume
 Max.Messages=Lof(10)/Len(TableRecord) ' store length of table file
 Outpt="Enter message number to delete" ' make range input prompt
 Call Get.Range2(1,Max.Messages,Message.Number) ' routine to get number
 Get 10,Message.Number,TableRecord ' read table record
 Outpt=UserRecord.CodeName ' store codename
 Call Decrypt(Outpt) ' decrypt codename
 Outpt=Rtrim$(Outpt) ' trim codename
 Outpt=Ucase$(Outpt) ' uppercase codename
 Inpt=TableRecord.To ' store message from codename
 Inpt=Rtrim$(Inpt) ' trim message codename
 Inpt=Ucase$(Inpt) ' uppercase from codename
 If Outpt<>Inpt Then ' compare codenames
    Outpt="Message"+Str$(Message.Number)+" is not a private message to you."
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare codenames
 If TableRecord.Private=False Then
    Outpt="Message"+Str$(Message.Number)+" is not a private message to you."
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare codenames
 If TableRecord.Killed Then ' compare deleted message
    Outpt="Message"+Str$(Message.Number)+" is already deleted." ' error message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare deleted message
 TableRecord.Killed=True ' set deleted message flag in table record
 Call Share.Record(10,Message.Number) ' routine to write table record
 Outpt="Message"+Str$(Message.Number)+" deleted." ' make deleted message
 Call IO.O ' send message
End Sub ' end routine to delete a message

 Rem * routine to display message.
 Rem * input variables:
 Rem *   Message.Number - contains number of message to display.
 Rem *   ListLines - true to list line numbers

Sub Read.Message(Message.Number,ListLines)
 On Local Error Resume Next ' local error resume
 Call Message.Header(Message.Number) ' routine to display message header
 Allow.Break=True ' set control-k checking flag
 Break=False ' reset control-k flag
 Continue=False ' reset continuous flag
 Page.Length=5 ' reset page length counter
 ' store beginning of message record flag
 Message.Start!=TableRecord.Start
 ' store ending of message record flag
 Message.End!=Message.Start!+Csng(TableRecord.Length-1)
 ' loop through message contents
 Line.Number=False ' reset line counter
 For Message.Record!=Message.Start! To Message.End!
    Get 11,Message.Record!,MessageRecord ' read message text line
    Outpt=MessageRecord.Message ' store message text
    Call Decrypt(Outpt) ' decrypt message text
    Outpt=Rtrim$(Outpt) ' trim message
    Line.Number=Line.Number+1 ' increment line counter
    If ListLines Then ' check line number list flag
       Outpt=Mid$(Str$(Line.Number),2)+":"+Outpt ' make line number
    Endif ' end check line number flag
    Outpt=Left$(Outpt,79) ' truncate message text
    Call IO.O ' send message text line
    If Break Then ' check control-k pressed flag
       Exit For ' exit message display loop
    Endif ' end check control-k pressed
    Page.Length=Page.Length+1 ' increment page length counter
    If Page.Length=UserRecord.Pagelength Then ' check page length
       Page.Length=False ' reset page length
       If Continue=False Then ' check continuous flag
          Call More.Prompt ' routine to pause
          If No Then ' check pause response
             Exit For ' exit message display loop
          Endif ' end check pause response
       Endif ' end check continuous flag
    Endif ' end check page length
 Next ' end loop through message file
 Allow.Break=False ' reset control-k checking flag
 If Break Then ' check control-k flag
    Break=False ' reset control-k flag
    Outpt=Nul ' set output to null
    Call IO.O ' send empty return
 Endif ' end check control-k flag
End Sub ' end routine to display a message

 Rem * routine to display message header.
 Rem * input variables:
 Rem *   Message.Number - contains number of message.

Sub Message.Header(Message.Number)
 On Local Error Resume Next ' local error resume
 ' make header
 Call Sub.Header(Message.Number) ' routine displays first part of header
 Outpt="Rcvd:  " ' make header
 If TableRecord.Received Then ' check message
    Outpt=Outpt+"Yes" ' append header
 Else ' check message
    Outpt=Outpt+"No" ' append header
 Endif ' end check message
 Outpt=Outpt+Space$(35-Len(Outpt)) ' pad spaces
 Outpt=Outpt+"Read:"+Str$(TableRecord.TimesRead)+" times"
 Call IO.O ' send more header
 Outpt="Reply: " ' make header
 If TableRecord.Reply Then ' check message type
    Outpt=Outpt+"Yes" ' append header
 Else ' check message
    Outpt=Outpt+"No" ' append header
 Endif ' end check message type
 Outpt=Outpt+Space$(35-Len(Outpt)) ' pad spaces
 Outpt=Outpt+"Thread:" ' append more header
 If TableRecord.Reply Then ' check message type again
    If TableRecord.Thread=False Then ' check message thread number
       Outpt=Outpt+" (forward)" ' append default header
    Else ' check thread number
       Outpt=Outpt+Str$(TableRecord.Thread) ' append thread number
    Endif ' end check message type
 Else ' check message type
    Outpt=Outpt+" None" ' append more header
 Endif ' end check message
 Call IO.O ' send header
 Outpt="Stat:  " ' make more header
 Class.Number=TableRecord.ClassType ' store class type from
 Select Case Class.Number ' select class type
 Case 1 To 10 ' check class type range
    Outpt=Outpt+Rtrim$(Class.Name(Class.Number)) ' store class name
 End Select ' end check class type range
 Outpt=Left$(Outpt,35) ' trunacte more header
 Outpt=Outpt+Space$(35-Len(Outpt)) ' pad spaces
 Outpt=Outpt+"Type: " ' append header
 Inpt=Nul ' reset message type from
 If TableRecord.Flags And Special.Char1 Then ' check message from
    Inpt=Inpt+"Town Mayor " ' append class type from
 Endif ' end check class type message from
 If TableRecord.Flags And Special.Char2 Then ' check message from
    Inpt=Inpt+"Governor " ' append class type from
 Endif ' end check class type message from
 If TableRecord.Flags And Special.Char3 Then ' check message from
    Inpt=Inpt+"Guild Master " ' append class type from
 Endif ' end check class type message from
 If TableRecord.Flags And Special.Char4 Then ' check message from
    Inpt=Inpt+"Sysop " ' append class type from
 Endif ' end check class type message from
 If Inpt=Nul Then ' check message from
    Inpt="None" ' reset class type from
 Endif ' end check class type message from
 Outpt=Outpt+Inpt ' append more header
 Outpt=Left$(Outpt,79) ' truncate header
 Outpt=Rtrim$(Outpt) ' trim header
 Call IO.O ' send more header
End Sub ' end routine to display message header

 Rem * routine displays first part of message header
 Rem * input variables:
 Rem *   Message.Number - number of message being read.

Sub Sub.Header(Message.Number)
 On Local Error Resume Next ' local error resume
 Graphics.Off=False ' reset color
 Outpt="Msg#:"+Str$(Message.Number)+" of"+Str$(Lof(10)/Len(TableRecord))
 If TableRecord.Private Then ' check private message
    Outpt=Outpt+" (private)" ' append to header
 Endif ' end check message
 If TableRecord.Killed Then ' check deleted message
    Outpt=Outpt+" (deleted)" ' append to header
 Endif ' end check message
 Call IO.O ' send header
 Graphics.Off=True ' reset color
 Inpt=TableRecord.From ' make header
 Inpt=Lcase$(Inpt) ' lowercase header
 Mid$(Inpt,1,1)=Ucase$(Mid$(Inpt,1,1)) ' uppercase first character
 Outpt="From:  "+Inpt ' make header
 Outpt=Left$(Outpt,35) ' truncate hader
 Outpt=Outpt+Space$(35-Len(Outpt)) ' pad spaces
 Inpt=Rtrim$(TableRecord.Subject) ' make more header
 Mid$(Inpt,1,1)=Ucase$(Mid$(Inpt,1,1)) ' uppercase more header
 Outpt=Outpt+"Subj: "+Inpt ' append header
 Call IO.O ' send more header
 Inpt=TableRecord.To ' make more header
 Inpt=Rtrim$(Inpt) ' trim header
 If Inpt=Nul Then ' check null message to
    Inpt="ALL" ' default to all
 Endif ' end check message to
 Inpt=Lcase$(Inpt) ' lowercase header
 Mid$(Inpt,1,1)=Ucase$(Mid$(Inpt,1,1)) ' uppercase header
 Outpt="To:    "+Inpt ' make more header
 Outpt=Left$(Outpt,35) ' truncate more header
 Outpt=Outpt+Space$(35-Len(Outpt)) ' pad spaces
 Outpt=Outpt+"Time: "+TableRecord.Clock ' append header
 Call IO.O ' send more header
End Sub ' end routine to display subheader

 Rem * routine to read range of messages.

Sub Read.Messages
 On Local Error Resume Next ' local resume next
 Code.Name$=UserRecord.CodeName ' store codename
 Call Decrypt(Code.Name$) ' decrypt codename
 Code.Name$=Rtrim$(Code.Name$) ' trim codename
 Code.Name$=Ucase$(Code.Name$) ' uppercase codename
 Max.Messages=Lof(10)/Len(TableRecord) ' store length of table file
 Outpt="Starting message number" ' make range input prompt
 Call Get.Range2(1,Max.Messages,Message.Number) ' routine to get number
 Do ' message read loop
    If Message.Number>Lof(10)/Len(TableRecord) Then ' compare end of table
       Exit Do ' exit message read loop
    Endif ' end compare table
    Get 10,Message.Number,TableRecord ' read next table record
    Inpt=TableRecord.To ' store message from
    Inpt=Rtrim$(Inpt) ' trim message from
    Inpt=Ucase$(Inpt) ' uppercase message from
    If TableRecord.Private And Inpt<>Code.Name$ Then ' compare private message
       Outpt="Message #"+Mid$(Str$(Message.Number),2)+" is private." ' message
       Call IO.O ' send message
    Else ' compare private message, codenames
       If TableRecord.Killed Then ' compare deleted message
          Outpt="Message #"+Mid$(Str$(Message.Number),2)+" was deleted."
          Call IO.O ' send message
       Else ' compare deleted message
          Call Read.Message(Message.Number,False) ' routine to display message
          TableRecord.Received=True ' set message recieved flag
          TableRecord.TimesRead=TableRecord.TimesRead+1 ' increment times read
          Call Share.Record(10,Message.Number) ' write table record
       Endif ' end compare deleted message
    Endif ' end compare private message
    Graphics.Off=False ' reset color
    If Message.Number>UserRecord.LastMessage Then ' check last message pointer
       UserRecord.LastMessage=Message.Number ' store new last message read
    Endif ' end check last message read
    Outpt="Read more (y)es/(n)o/(r)eply/(t)hread, msg number? " ' make prompt
    No.Input.Out="Y" ' default input
    Call IO.I ' get player input
    Select Case Ucase$(Inpt) ' selection of prompt response
    Case "N", "Q" ' check input response
       Exit Do ' exit message read loop
    Case "R" ' reply to message
       Outpt="Private message(y/n)? " ' prompt
       No.Input.Out="N"
       Call IO.I ' get input
       Private.Message=Yes ' set message type
       Message.Reply=True ' set message type
       Message.Thread=Message.Number ' store message number
       Message.To=TableRecord.From ' store message header
       Subject=TableRecord.Subject ' store message header
       Outpt="Enter message reply." ' make message
       Call IO.O ' send message
       Call Write.Message ' routine to enter and write message
       Get 10,Message.Number,TableRecord ' read current table
       TableRecord.Reply=True ' set reply
       Call Share.Record(10,Message.Number) ' write table record
       Message.Number=Message.Number-1 ' adjust loop variable
    Case "T" ' thread selection
       Outpt="Direction (b)ackward/(f)oward/(s)earch? " ' input prompt
       No.Input.Out="F" ' default input
       Call IO.I ' get input
       Select Case Ucase$(Inpt) ' selection of thread direction
       Case "B" ' backward thread
          If TableRecord.Thread=False Then ' check thread
             Outpt="Message has no backward reply thread." ' make message
             Call IO.O ' send message
             Call More.Prompt ' pause prompt
             Message.Number=Message.Number-1 ' reset loop variable
          Else ' check thread
             ' change loop variable to thread number
             Message.Number=TableRecord.Thread-1
          Endif ' end check thread number
       Case "F" ' forward thread
          ' loop through table
          For Message.Search=Message.Number To Lof(10)/Len(TableRecord)
             Get 10,Message.Search,TableRecord ' read table record
             ' compare thread numbers
             If TableRecord.Thread=Message.Number Then
                Message.Number=Message.Search-1 ' change loop variable
                Exit For ' exit search loop
             Endif ' end compare thread numbers
          Next ' end loop through table
          If Message.Search>Lof(10)/Len(TableRecord) Then ' check loop bounds
             Outpt="Message has no forward thread." ' make message
             Call IO.O ' send message
             Call More.Prompt ' pause prompt
             Message.Number=Message.Number-1 ' reset loop variable
          Endif ' end check loop variable
       Case "S" ' search forward thread
          ' loop through table
          For Message.Search=Message.Number To Lof(10)/Len(TableRecord)
             Get 10,Message.Search,TableRecord ' read table record
             ' compare thread numbers
             If TableRecord.Thread=Message.Number Then
                Call Sub.Header(Message.Search) ' routine displays subheader
                Graphics.Off=False ' reset color
                Outpt="Message thread:(c)ontinue search/(r)ead? " ' prompt
                No.Input.Out="R" ' default input
                Call IO.I ' get user input
                If Ucase$(Inpt)="R" Then ' compare input
                   Message.Number=Message.Search-1 ' change loop variable
                   Exit For ' exit search loop
                Endif ' end compare input
             Endif ' end compare thread numbers
          Next ' end loop through table
          If Message.Search>Lof(10)/Len(TableRecord) Then ' check loop bounds
             Outpt="There are no more forward threads." ' make message
             Call IO.O ' send message
             Call More.Prompt ' pause prompt
             Message.Number=Message.Number-1 ' reset loop variable
          Endif ' end check loop variable
       End Select ' end thread selection
    Case Else ' other selection
       Next.Message=Int(Val(Inpt)) ' convert input to integer
       ' check input range
       If Next.Message>=1 And Next.Message<=Lof(10)/Len(TableRecord) Then
          Message.Number=Next.Message-1 ' reset message loop variable
       Endif ' end check input range
    End Select ' end prompt selection
    Message.Number=Message.Number+1 ' increment table number
 Loop ' end loop through message table
 Outpt="End of messages." ' make message
 Call IO.O ' send message
End Sub ' end routine to read messages

 Rem * routine to read range of new messages.

Sub New.Messages
 On Local Error Resume Next ' local error resume
 If UserRecord.LastMessage>=Lof(10)/Len(TableRecord) Then ' compare last read
    Outpt="No new messages." ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare last message read variable to length of table
 Code.Name$=UserRecord.CodeName ' store codename
 Call Decrypt(Code.Name$) ' decrypt codename
 Code.Name$=Rtrim$(Code.Name$) ' trim codename
 Code.Name$=Ucase$(Code.Name$) ' uppercase codename
 Message.Number=UserRecord.LastMessage+1 ' store last message read variable
 Last.Message=Lof(10)/Len(TableRecord) ' store length of table
 Do ' message read loop
    If Message.Number>Last.Message Then ' compare message range
       Exit Do ' exit message loop
    Endif ' end compare message range
    Get 10,Message.Number,TableRecord ' read next table record
    Inpt=TableRecord.To ' store message to
    Inpt=Rtrim$(Inpt) ' trim message to
    Inpt=Ucase$(Inpt) ' uppercase message to
    Message.Read=True ' set read message flag
    If TableRecord.Private Then ' check private message flag
       If Inpt<>Code.Name$ Then ' compare codenames
          Message.Read=False ' reset read message flag
       Endif ' end compare codenames
    Endif ' end check private message flag
    If TableRecord.Killed Then ' check deleted message
       Message.Read=False ' reset read message flag
    Endif ' end check deleted message
    If Message.Read Then ' verify read message flag
       Call Read.Message(Message.Number,False) ' routine to display message
    Endif ' end verify read message flag
    Graphics.Off=False ' reset color
    ' update player last message variable
    UserRecord.LastMessage=Message.Number
    Outpt="Read more (y)es/(n)o/(r)eply? " ' make more prompt
    No.Input.Out="Y" ' default input
    Call IO.I ' get player input
    If Ucase$(Inpt)="R" Then ' check input
       Outpt="Private message(y/n)? " ' input prompt
       Call IO.I ' get player input
       Private.Message=Yes ' set message type
       Message.Reply=True ' set message type
       Message.Thread=Message.Number ' store message number
       Message.To=TableRecord.From ' store message header
       Subject=TableRecord.Subject ' store message header
       Outpt="Enter message reply." ' make message
       Call IO.O ' send message
       Call Write.Message ' routine to enter and write message
       Get 10,Message.Number,TableRecord ' read current table
       TableRecord.Reply=True ' set reply
       Call Share.Record(10,Message.Number) ' write table record
       Message.Number=Message.Number-1 ' adjust read loop variable
    Endif ' end check input response
    If No Or Quit Then ' check input response
       Exit Do ' exit new message read loop
    Endif ' end check response
    Message.Number=Message.Number+1 ' increment message variable
 Loop ' end loop through new messages
End Sub ' end routine to read new messages

SysopCommands1:
 Data "ABORT","HINT","CALL","EDIT","HELP","INVISIBLE","LINK","<>","STATUS
SysopCommands2:
 Data "<>","CALL","DISCARD","EDIT","GET","HELP","KILL","REDUCE","TELEPORT"
CommandSet1:
 Data "KILL","ATTACK","HIT","STRIKE","READ","LOOK","RUN","PANIC","SEARCH","SAVE"
 Data "INFORMATION","INVENTORY","SUICIDE","TRAIN","HEALTH","APPEAL","BYE","STOP","QUIT","END"
 Data "EXPERIENCE","HELP","HIDE","CAST","LIST","BRIEF","BANK","TIME","DATE","CLOCK"
 Data "CHARM","BEGUILE","ANSI","SHIELD","GUARD","<>","<>","<>","LUNGE","DODGE"
 Data "TOP","BLESS","CURSE","PASSWORD","MAIL","USERS","CHAT","EXIT","LEAVE","CLIMB"
 Data "STORE","LOGIN","RELOGIN","STATUS","LINELENGTH","CATALOG","LINEFEEDS","PAGELENGTH","ECHO","WORDWRAP"
 Data "ALIGNMENT","<>","<>","NORTH","EAST","SOUTH","WEST","OUT","UP","DOWN"
 Data "NORTHEAST","SOUTHEAST","SOUTHWEST","NORTHWEST","<>","HINT","SORT","COMMANDS","<>","<>"
 Data "<>","<>","REROLL","<>","<>"

CommandSet2:
 Data "GO","ENTER","READ","EXAMINE","LOOK","USE","GET","TAKE","DROP","PUT"
 Data "SELL","PAWN","BREAK","SMASH","CLOSE","OPEN","DRAW","WIELD","HOLD","WEAR"
 Data "RETURN","CAST","BUY","LOCK","UNLOCK","PICKLOCK","FIX","REPAIR","RECHARGE","DRINK"
 Data "<>","THROW","STEAL","<>","BLESS","CURSE","FUEL","<>","<>","TALK"
 Data "PARLEY","BRIBE","OFFER","LOAD","FIRE","MOUNT","DISMOUNT","RIDE","HIDE","SEARCH"
 Data "HELP","IDENTIFY","<>","<>","KILL","ATTACK","HIT","STRIKE","BACKSTAB","CIRCLE"
 Data "FEINT","PARRY","THRUST","CHARGE","TURN","COUNTER","BEMUSE","BEFUDDLE","PUMMEL","RESIST"
 Data "PSIONIC","EAT","DRIVE","FLY","MOVE","LAUNCH","LEARN","LIGHT","SWIM","EXIT"
 Data "LEAVE","BEAT","PUNCH","BEWITCH","BEWILDER"

Strip.Data:
 Data "ABOUT","ABOVE","ACROSS","AFTER","AGAINST","AMONG","AN","AROUND","AS","AT"
 Data "AWAY","BEFORE","BEHIND","BELOW","BESIDE","BETWEEN","BY","FROM","FOR","HE"
 Data "HER","HERE","HERS","HIM","HIS","IN","INBETWEEN","INTO","IS","IT"
 Data "ITS","LIKE","ME","MINE","MY","OF","ON","ONTO","OUR","OURS"
 Data "OVER","PAST","SHE","SINCE","THAT","THE","THEIR","THEIRS","THEM","THERE"
 Data "THEY","THIS","THOSE","THROUGH","TO","TOWARD","UNDER","UNTIL","UNTO","UPON"
 Data "US","WHO","WHOM","WHOSE","WITH","WITHIN","WITHOUT","YOU","YOUR","YOURS"
