
 Rem * Filename: dnds1.bas  Version: v4.0 r1.0
 Rem * This subprogram contains most config and communication routines.

 Rem $Include: 'dnddoor.inc'

 Rem * Configure routine:
 Rem * routine to read command line, dimension and load dynamic arrays,
 Rem * open files, read door file, and read monster class arrays.

Sub Read.Config
 On Local Error Resume Next ' local error resume
 Call Get.Command ' read command line
 Call Read.Arrays ' load runtime arrays
 Call Open.Files ' open work files
 Call Read.Door ' read door file
 Call Read.Monclass ' load monster class arrays
End Sub ' end routine to read configure

 Rem * routine reads command line node number 0-9, A-Z, 10-99.

Sub Get.Command
 On Local Error Goto Command.Error ' local error routine
 Local.Mode=False ' default not local mode
 Locate ,,1 ' turn on cursor
 Max.Row=22 ' set maximum rows on screen before scroll
 Node1=False ' reset node number
 Node2=False ' reset node number
 Select Case Len(Command$) ' get length of command line node
 Case 1 ' command line length
    Select Case Command$ ' get command line node number
    Case "0", "A" To "Z" ' command line node
       Node1=Asc(Command$) ' assign to node type 1 variable
       Node2=False ' assign to node type 2 variable
    Case "1" To "9" ' command line node
       Node1=Asc(Command$) ' assign to node type 1 variable
       Node2=Val(Command$) ' assign to node type 2 variable
    End Select ' end command line node number
 Case 2 ' command line length
    Select Case Int(Val(Command$)) ' select extended node number
    Case 10 To 99 ' command line node
       Node1=False ' assign to node type 1 variable
       Node2=Int(Val(Command$)) ' assign to node type 2 variable
    End Select ' end select node number
 End Select ' end select node number
 If Node1=False And Node2=False Then ' verify valid node number
    Error 99 ' force local error
 Endif ' end verify valid node number
 Exit Sub ' exit routine
Command.Error:
 Color 7,0 ' color white on black
 Print "Command line node number must be 0 to 9, A to Z, or 10 to 99."
 End ' halt program
End Sub ' end routine to read command line

 Rem * routine reads runtime arrays.

Sub Read.Arrays
 On Local Error Goto Arrays.Error ' local error routine
 ' allocate runtime arrays
 Redim Alignment.Name1(1 To 3) As String*7,_
 Alignment.Name2(1 To 3) As String*7,_
 Class.Name(1 To 10) As String*15,_
 Direction(1 To 11) As String*9,_
 High.Class.Name(1 To 10) As String*15,_
 Race(1 To 8) As String*8,_
 Stat(1 To 7) As String*12,_
 Training.Room(1 To 10,1 To 4) As Integer,_
 Weapon.Type.Name(1 To 4) As String*9
 Restore Config.Data
 For Array.Index1=1 To 10 ' loop through ten class statistic increment array
    For Array.Index2=1 To 4 ' loop through each four class statistic array
       Read Training.Room(Array.Index1,Array.Index2) ' read statistics
    Next ' loop through
 Next ' loop through
 For Array.Index2=1 To 10 ' loop through high class names
    Read High.Class.Name(Array.Index2) ' read high class names
 Next ' loop through
 For Array.Index2=1 To 8 ' loop through race names
    Read Race(Array.Index2) ' read race names
 Next ' loop through
 For Array.Index2=1 To 10 ' loop through class names
    Read Class.Name(Array.Index2) ' read class names
 Next ' loop through
 For Array.Index2=1 To 7 ' loop through statistic names
    Read Stat(Array.Index2) ' read statistic names
 Next ' loop through
 For Array.Index2=1 To 11 ' loop through direction names
    Read Direction(Array.Index2) ' read direction names
 Next ' loop through
 For Array.Index2=1 To 4 ' loop through weapon proficiency names
    Read Weapon.Type.Name(Array.Index2) ' read weapons proficiency names
 Next ' loop through
 For Array.Index2=1 To 3 ' loop through first set of alignment names
    Read Alignment.Name1(Array.Index2) ' read alignment names
 Next ' loop through
 For Array.Index2=1 To 3 ' loop through second set of alignment names
    Read Alignment.Name2(Array.Index2) ' read alignment names
 Next ' loop through
 Exit Sub ' exit routine
Arrays.Error:
 Color 7,0 ' color white on black
 Print "Error reading data. Increase RAM size." ' output error message
 End ' halt program
End Sub ' end routine to read arrays

 Rem * routine opens all file handles.

Sub Open.Files
 On Local Error Goto Files.Error ' local error routine
 Close ' close all files
 ' files opened in random mode, opened in share mode for multi access,
 ' and each file record length specified as the length of the random record
 ' which will be used to get/put data to the file. nine files.
 Open "users.dat" For Random Shared As #1 Len=Len(UserRecord)
 Open "nonplyrs.dat" For Random Shared As #2 Len=Len(MonsterRecord)
 Open "rooms.dat" For Random Shared As #3 Len=Len(RoomRecord)
 Open "objects.dat" For Random Shared As #4 Len=Len(ObjectRecord)
 Open "monsters.dat" For Random Shared As #5 Len=Len(MonsterRecord)
 Open "treasure.dat" For Random Shared As #6 Len=Len(TreasureRecord)
 Open "montalk.dat" For Random Shared As #7 Len=Len(MonsterTalkRecord)
 Open "monclass.dat" For Random Shared As #8 Len=Len(MonclassRecord)
 Open "spells.dat" For Random Shared As #9 Len=Len(SpellRecord)
 Open "msgtable.dat" For Random Shared As #10 Len=Len(TableRecord)
 Open "messages.dat" For Random Shared As #11 Len=Len(MessageRecord)
 Open "actions.dat" For Random Shared As #12 Len=Len(ActionRecord)
 Exit Sub ' exit routine
Files.Error:
 Color 7,0 ' color white on black
 Print "Error opening files. Set config.sys Files=24." ' output error message
 End ' halt program
End Sub ' end routine to open files

 Rem * routine makes door filename.

Sub Read.Door
 On Local Error Goto Door.Error ' local error routine
 ' construct door information filename
 If Node1 Then ' check node type 1
    FileName="DORINFO"+Chr$(Node1)+".DEF" ' make door info filenname
    If Dir$(FileName)=FileName Then ' check for existing file
       Node=Chr$(Node1) ' store node in string form
       Call Read.Door.File ' routine to read door file
       Exit Sub ' exit door file routine
    Endif ' end check for file
 Endif ' end check node type
 If Node2 Then ' check node type 2
    FileName="DINF"+Mid$(Str$(Node2),2)+".DEF" ' make door info filename
    If Dir$(FileName)=FileName Then ' check for existing file
       Node=Mid$(Str$(Node2),2) ' store node in string form
       Call Read.Door.File ' routine to read door file
       Exit Sub ' exit door file routine
    Endif ' end check for file
 Endif ' end check node type
Door.Error:
 Color 7,0 ' color white on black
 ' output error message
 Print "RBBS door information file for node ";Command$;" not found."
 End ' halt program
End Sub

 Rem * routine reads door file.

Sub Read.Door.File
 On Local Error Goto Door.File.Error ' local error routine
 BBS.Name=Nul ' reset name of bbs
 Color.Graphics=True ' default remote ansi color on
 Door.Name=Nul ' reset name of user
 Door.Time=180! ' reset time remaining
 Close #13 ' close work file
 Open FileName For Input Shared As #13 ' open the door file for input
 Door.File.Line=False ' reset counter of text line read from door file
 While Not Eof(13) ' loop through all lines in door file
    Line Input #13,Inpt ' read next text line from door file
    Inpt=Ucase$(Inpt) ' convert text string to upper case
    Door.File.Line=Door.FIle.Line+1 ' increment text line counter
    Select Case Door.File.Line ' select which line to process
    Case 1 ' line one
       BBS.Name=Inpt ' store name of bbs
    Case 4 ' line four
       Port=Val(Mid$(Inpt,4,1)) ' set port to value of rightmost character
       If Port=False Then ' port zero speficies local console mode
          Local.Mode=True ' set local mode flag
       Else ' other port number
          Port=Port-1 ' convert modem comm (1-8) to modem port (0-7)
       Endif ' end compare port number
    Case 7 ' line seven
       Door.Name=Inpt ' store name of user
       If Left$(Inpt,5)="SYSOP" Then ' compare user name to 'sysop'
          Local.Mode=True ' set local mode flag
       Endif 'end compare user name
    Case 8 ' line eight
       If Len(Inpt) Then ' compare length of user last name
          Door.Name=Door.Name+" "+Inpt ' append user last name
       Endif ' end compare user name length
    Case 10 ' line ten
       Color.Type=Int(Val(Inpt)) ' get value of text line
       If Color.Type<2 Then ' compare graphics preference
          Color.Graphics=False ' value other than two sets graphics off
       Endif ' end compare graphcis
    Case 12 ' line twelve
       Door.Time=Val(Inpt)*60! ' store value of text line of remaining time
    End Select ' end process line
 Wend ' end loop through file
 Exit Sub ' exit routine
Door.File.Error:
 Color 7,0 ' color white on black
 Print "Error reading door information file: "+FileName ' output error message
 End ' halt program
End Sub ' end routine to read door file

 Rem * routine loads runtime file data.

Sub Read.Monclass
 On Local Error Goto Monclass.Error ' local error routine
 Locate ,,1 ' turn on cursor
 Monclass.Max=Lof(8)/Len(MonclassRecord) ' compute number of records in 
 If Monclass.Max=False Then ' monster class file, compare to minimum
    Monclass.Max=1 ' and increment if none found
    For Monster.Classes=1 To 10 ' loop through all monsters in class
       MonclassRecord.Monsters(Monster.Classes)=False ' reset to empty
    Next ' end loop
    Call Share.Record(8,1) ' write first monster class record if empty
 Endif ' end compare length of file
 ' allocate monster class, rate, and percent arrays
 Redim Monster.Class(1 To Monclass.Max,1 To 10) As Integer,_
 Monster.Percent(1 To Monclass.Max,1 To 10) As Integer,_
 Monster.Rate(1 To Monclass.Max,1 To 10) As Integer
 ' loop through all monster classes in file
 For Monster.Classes=1 To Monclass.Max
    Get 8,Monster.Classes,MonclassRecord ' read monster class record
    For Monster.Class.Number=1 To 10 ' loop through all monsters in record
       ' get monster number in class
       Monster.Array.Number=MonclassRecord.Monsters(Monster.Class.Number)
       ' store in monster class array
       Monster.Class(Monster.Classes,Monster.Class.Number)=_
       Monster.Array.Number
       If Monster.Array.Number>False And_
          Monster.Array.Number<=Lof(5)/Len(MonsterRecord) Then ' file bounds
          ' read monster number from monster file
          Get 5,Monster.Array.Number,MonsterRecord
          ' store encounter rate
          Monster.Rate(Monster.Classes,Monster.Class.Number)=_
          MonsterRecord.Rate
          ' store encounter rate percent
          Monster.Percent(Monster.Classes,Monster.Class.Number)=_
          MonsterRecord.RatePercent
       Endif ' end compare file bounds
    Next ' end loop through ten monsters in class
 Next ' end loop through all monster classes
 Max.Spells=Lof(9)/Len(SpellRecord) ' get number of spell records
 Spell.Number=Len(Learned.Spells) ' get length of learned spells array
 If Max.Spells>Spell.Number Then ' compare spells length
    ' extended array
    Learned.Spells=Learned.Spells+String$(Max.Spells-Spell.Number,"0")
 Endif ' end compare length
 Exit Sub ' exit routine
Monclass.Error:
 Color 7,0 ' color white on black
 Print "Error reading arrays. Increase RAM size." ' output error message
 End ' halt program
End Sub ' end configure routine

 Rem * standard output routine to send data to the screen and modem.
 Rem * input variables:
 Rem *   Allow.Break - set to true to allow control-k checking.
 Rem *   Carriage.Return - set to true to suppress cr/lf after output.
 Rem *   Outpt - contains text to output to screen/modem.
 Rem * output variables:
 Rem *   Break - set to true if user entered control-k.
 Rem *   Carriage.Return, Outpt - reset to zero/null.
 Rem * processing variables:
 Rem *   Char.Output$ - character to send to modem/screen.
 Rem *   Count - loop variable for character of output sent.

Sub IO.O
 On Local Error Resume Next ' local error resume
 Call Out.ANSI ' routine to output ansi sequence to modem/color code locally
 Count=False ' reset output character counter
 If Carriage.Return=False Then ' check cr/lf
    Outpt=Rtrim$(Outpt) ' trim output
    Outpt=Outpt+" " ' append wrap space
 Endif ' end check cr/lf
 Do ' output characters loop
    Count=Count+1 ' increment output counter
    Call Keyboard(Keyboard.Break) ' routine reads keyboard
    If Break Then ' check break flag
       Exit Do ' exit output loop
    Endif ' end check break flag
    Gosub IO.Wrap ' subroutine to word wrap
    Char.Output$=Mid$(Outpt,Count,1) ' get single character to output
    Call Put.Modem(Char.Output$) ' send character to modem
    Call Scrn(Char.Output$) ' send character to screen
    If Count>=Len(Outpt) Then ' check length of output
       Exit Do ' exit output loop
    Endif ' end check length of output
 Loop ' output character loop
 If Carriage.Return=False Then ' check output cr/lf suppressed
    If Break=False Then ' check control-k flag
       Call Line.Return ' routine to send cr/lf to modem/screen
    Endif ' end check control-k flag
 Endif ' end check i/o cr/lf
 Carriage.Return=False ' reset supressed cr/lf
 Outpt=Nul ' reset output
 Exit Sub ' exit routine

 ' subroutine to word wrap
IO.Wrap:
 If UserRecord.Linelength=False Then ' check linelength
    Return ' exit subroutine
 Endif ' end check of linelength
 Select Case UserRecord.Wordwrap ' check word wrap preference
 Case True ' word wrap toggled off
    If Pos(0)=UserRecord.Linelength Then ' check line length
       If Mid$(Outpt,Count,1)=" " Then ' check wrapped space
          Count=Count+1 ' increment space from loop
       Endif ' end check wrapped space
       Carriage.Return=True ' supress cr/lf
       Call Line.Return ' send cr/lf
    Endif ' end check line length
 Case False ' word wrap toggled on
    If Mid$(Outpt,Count,1)=" " Then ' check next character is space
       Word$=Mid$(Outpt,Count) ' store next word to send
       Space.Wrap=Instr(2,Word$," ") ' store next word
       If Space.Wrap Then ' find first imbedded space
          Word$=Left$(Word$,Space.Wrap) ' truncate word
       Endif ' end storing next word to send
       ' compute line position plus next word
       If Pos(0)+Len(Word$)>=UserRecord.Linelength-1 Then
          Call Line.Return ' next word wraps, send cr/lf
          Carriage.Return=True ' supress cr/lf
          Count=Count+1 ' increment space from loop
          Return ' exit subroutine
       Endif ' end compute wrap length
    Endif ' end check character sent is space
 End Select ' end select word wrap preference
 Return ' exit subroutine
End Sub ' end routine to send a string to the modem and screen

 Rem * standard input routine to get data from the keyboard and modem.
 Rem * input variables:
 Rem *   Buffer - any previous user input stored during output.
 Rem *   Carriage.Return - set to true to suppress cr/lf after output.
 Rem *   Hide - flag to echo mask characters in place of input.
 Rem *   Line.Length - maximum characters allowed to input.
 Rem *   No.Echo - do not echo user input.
 Rem *   No.Input.Out - string to use if no input entered.
 Rem *   Outpt - contains input prompt.
 Rem *   Word.Wrap - allow words entered to wrap.
 Rem * output variables:
 Rem *   Inpt - contains user input string.
 Rem *   No.Input - flag set if return entered.
 Rem *   No - set if N was entered.
 Rem *   Yes - set if Y was entered.
 Rem *   Quit - set if Q was entered.
 Rem * processing variables:
 Rem *   Buffered.Input$ 0 stores buffered input to add to next input prompt.
 Rem *   Char$ - current character received from modem/keyboard.
 Rem *   Char - ascii code of character input.
 Rem *   Line.Limit - stores length of input line during input.
 Rem *   Time.Out! - current time character input loop entered.
 Rem *   Word - set if a word wrapped.
 Rem *   OutY$, Valid.Char$, Last.Wrap, Last.Word - local work variables.

Sub IO.I
 On Local Error Resume Next ' local error resume
 Static Buffered.Input$ ' stores data input between calls to input routine
 If Pos(0)>1 Then ' check io supressed cr/lf
    Call Line.Return ' make cr/lf before input prompt
 Endif ' end check previous supressed cr/lf
 Carriage.Return=True ' set cr/lf flag
 Line.Limit=Len(Outpt) ' reset length of line for io.o
 Outpt=Outpt+Buffered.Input$ ' add stored data input to input prompt
 Call IO.O ' output the input prompt
 Inpt=Buffered.Input$ ' reset input string+data input between calls
 Buffered.Input$=Nul ' reset data input between calls
 Do ' loop through input characters
    Char$=Nul ' reset input character
    Time.Out!=Timer ' set time loop entered
    Do While Char$=Nul ' loop until received a character
       Gosub IO.Timing ' routine to calculate timing values
       Call Keyboard(Keyboard.Break) ' routine to get any keyboard input
       ' keyboard input received is a function key/extended key
       If Keyboard.Break Then
          Buffer=Nul ' reset type ahead buffer
          Carriage.Return=False ' reset cr/lf flag
          No.Input.Out=Nul ' reset null input echo string
          Exit Sub ' exit routine to process extended keyboard input
       Endif ' end check keyboard routine flag
       Call Get.Modem(Input.Char) ' routine to get character from modem
       If Input.Char Then ' modem input in return variable
          ' append modem input to buffer variable
          Buffer=Buffer+Chr$(Input.Char)
       Endif ' end check modem for character
       If Len(Buffer) Then ' check buffer contents
          Char$=Left$(Buffer,1) ' get first buffer character
          Buffer=Mid$(Buffer,2) ' store buffer minus first character
       Endif ' end check buffer
    Loop ' end loop until character received
    Char=Asc(Char$) ' convert character string to ascii integer
    Select Case Char ' process character ascii integer
    Case 8 ' backspace
       If Len(Inpt) Then ' check length of input
          Inpt=Left$(Inpt,Len(Inpt)-1) ' strip off last character from input
          Call Back.Space ' routine to send backspace codes
       Endif ' end check string length
    Case 13 ' return key
       If Inpt=Nul Then ' no input in string
          If Len(No.Input.Out) Then ' check null input echo string
             Inpt=No.Input.Out ' set input string to default input string
             OutY$=Lcase$(No.Input.Out) ' convert null input string
             Call Scrn(OutY$) ' send string to screen
             If UserRecord.Echo=False Then ' check echo mode
                Call Put.Modem(OutY$) ' send string to modem
             Endif ' end check echo mode
          Endif ' end check null input flag
       Endif ' end check null input
       Call Scrn(Chr$(13)) ' send carriage return to screen
       If UserRecord.Echo=False Then ' check echo mode
          Call Put.Modem(Chr$(13)) ' send carriage return to modem
       Endif ' end check echo mode
       Exit Do ' end routine after return key prssed/return input string
    Case 32 To 127 ' remaining valid input ascii codes
       Valid.Char$=Char$ ' store character
       If No.Echo=False Then ' check echo flag
          If Hide Then ' check hide flag
             Valid.Char$="#" ' echo mask character
          Endif ' end check hide flag
          If UserRecord.Echo=False Then ' check echo mode
             Call Put.Modem(Valid.Char$) ' echo character entered to modem
          Endif ' end check echo mode
          If Word.Wrap=False Then ' check word wrap flag
             Call Scrn(Valid.Char$) ' echo character entered to screen
          Endif ' end check word wrap flag
       Endif ' end check echo flag
       Inpt=Inpt+Char$ ' append character input to input string
       If Word.Wrap And UserRecord.Wordwrap=False Then ' word wrap is set
          Select Case Len(Inpt)+Line.Limit ' check length of input+line length
          Case 0 To UserRecord.Linelength-2 ' position to left, no word wrap
             Call Scrn(Valid.Char$) ' send echo character
          Case Else ' position to left, word wrap
             Last.Word=False ' counter of characters at last word to wrap
             Word=False ' set flag for word wrapped
             ' loop through last word reverse
             For Last.Wrap=Len(Inpt) To 1 Step -1
                If Mid$(Inpt,Last.Wrap,1)=" " Then ' locate space of word
                   For Word.Break=1 To Last.Word ' loop through length of word
                      Call Back.Space ' routine to backspace
                   Next ' end loop through word
                   ' store wrapped word for next i/o
                   Buffered.Input$=Mid$(Inpt,Last.Wrap+1)
                   ' truncate word from input string
                   Inpt=Left$(Inpt,Last.Wrap)
                   Call Scrn(Chr$(13)) ' send return
                   Word=True ' word has wrapped flag
                   Exit For ' end loop for a space
                Endif ' end check space location
                Last.Word=Last.Word+1 ' increment last word wrapped counter
             Next
             If Word=False Then ' check flag for word wrapped
                Call Scrn(Chr$(13)) ' send return to screen
             Endif ' end check word wrapped flag
             Call Put.Modem(Chr$(13)) ' send return to modem
             Exit Do ' end input loop
          End Select ' end check length of input+line length
       Else ' word wrap flag not set
          If Line.Length>False Then ' check line length variable
             If Len(Inpt)>=Line.Length Then ' check input string length
                Call Scrn(Chr$(13)) ' send return to screen
                Call Put.Modem(Chr$(13)) ' send return to modem
                Exit Do ' exit input loop
             Endif ' end check input string length
          Endif ' end check line length
       Endif ' end check word wrap
    End Select ' end select character ascii code
 Loop ' end input loop
 Carriage.Return=False ' reset output cr/lf flag
 Outpt=Nul ' reset input prompt
 No.Echo=False ' reset echoing mask character flag
 No.Input=False ' reset null input flag
 Line.Length=False ' reset length of input line
 If Inpt=Nul Then ' check input string to null
    No.Input=True ' set null input flag
 Endif ' end check input string length
 No.Input.Out=Nul ' reset echo string for null input flag
 If UserRecord.Linefeeds=False Then ' check linefeed mode
    If UserRecord.Echo=False Then ' check echo mode
       Call Put.Modem(Chr$(10)) ' send linefeed
    Endif ' end check echo mode
 Endif ' end check linefeed mode
 Word.Char$=Ucase$(Left$(Inpt,1)) ' get uppercase of first character of input
 No=(Word.Char$="N") ' set no flag (user entered N as first character)
 Yes=(Word.Char$="Y") ' set yes flag (user entered Y as first character)
 Quit=(Word.Char$="Q") ' set quit flag (user entered Q as first character)
 Continue=(Word.Char$="C") ' set continuous flag
 Exit Sub ' exit routine to get input string in Inpt

 Rem * subroutine to verify time limits.

IO.Timing:
 ' routine to calculate input timing
 Call Second.Timer(Time.Expired,Time.Out!,180!)
 If Time.Expired Then ' timing has expired
    Call Hang.Up(1) ' routine to hang up modem with message
 Endif ' end check timing
 ' routine to calculate time on
 Call Second.Timer(Time.Expired,Timeon,Time.Left)
 If Time.Expired Then ' time limit has expired
    Call Hang.Up(2) ' routine to hang up modem with message
 Endif ' end check time limit
 If Two.Minutes.Left=False Then ' check two minutes message flag
    ' calculate two minutes time
    Call Second.Timer(Time.Expired,Timeon,Time.Left-120!)
    If Time.Expired Then ' time has expired, user has two minutes left
       Two.Minutes.Left=True ' set two minutes message flag
       Outpt=Nul ' reset output string
       Call IO.O ' send null return
       Call Put.Modem(Chr$(7)) ' send beep to modem
       Outpt="Two Minutes Left!" ' send two minutes remaining message
       Call IO.O ' to modem
    Endif ' end check two minutes
 Endif ' end check two minutes flag
 Return ' end timing subroutine
End Sub ' end routine to get input string in Inpt

 Rem * Routine to send a string to the modem.
 Rem * input variables:
 Rem *   Allow.Break - set if control-k checking allowed.
 Rem *   Local.Mode - flag if the console is operating program.
 Rem *   Output$ - string to send.
 Rem * output variables:
 Rem *   Break - flag set if control-k entered.
 Rem *   Buffer - any input from modem during output.
 Rem * processing variables:
 Rem *   Char - ascii code of character to send.
 Rem *   Count - loop variable of output string sent.
 Rem *   Input.Char - local work variable.

Sub Put.Modem(Output$)
 On Local Error Resume Next ' local error resume
 If Local.Mode=False Then ' check if local mode is activated
    For Count=1 To Len(Output$) ' loop through output string
       Call Get.Modem(Input.Char) ' routine to get data from modem
       If Input.Char Then ' character received from modem
          If Input.Char=11 Then ' check if character is control-k
             If Allow.Break Then ' check if break allowed
                Break=True ' set break flag
                Exit Sub ' end routine
             Endif ' end check break allowed
          Else ' any other character
             Buffer=Buffer+Chr$(Input.Char) ' append to input buffer
          Endif ' end check character is control-k
       Endif ' end check character received
       ' convert output string character to ascii
       Char=Asc(Mid$(Output$,Count,1))
       Call Driver(&H0100+Char) ' driver routine/send character
    Next ' end loop through output string
 Endif ' end check local mode
End Sub ' end routine to send output to modem

 Rem * Routine to get a character from the modem.
 Rem * input variables:
 Rem *   Local.Mode - flag if console is operating system.
 Rem * output variables:
 Rem *   Input.Char - character received from modem.
 Rem * processing variables:
 Rem *   Outregs - register of modem status.

Sub Get.Modem(Input.Char)
 On Local Error Resume Next ' local error resume
 Input.Char=False ' set received character to zero
 If Local.Mode=False Then ' check if local mode is activated
    Call Driver(&H0300) ' driver routine/get modem status
    If (Outregs.AX And &H80)=False Then ' check modem carrier status
       Call Status.Line(-2) ' routine to clear lower two console status areas
       Call Scrn(Chr$(13)) ' send return to screen
       Call Scrn("Lost carrier!") ' send message to screen
       End ' terminate program
    Endif ' end check carrier
    If (Outregs.AX And &H0100)=&H0100 Then ' check character receive ready
       Call Driver(&H0200) ' driver routine/read character
       Input.Char=Outregs.AX And &HFF ' return lower byte of register received
    Endif ' end check character received ready
 Endif ' end check local mode
End Sub ' end routine to get a character from the modem

 Rem * routine to call the dos function for modem access.
 Rem * Note: Dnd Door only uses the following subfunctions of int Hex14
 Rem *   because they are standard throughout almost all BIOS routines
 Rem *   and communication drivers.
 ' ----------1401-------------------------------
 ' INT 14 - SERIAL - WRITE CHARACTER TO PORT
 '          AH = 01h
 '          AL = character to write
 '          DX = port number
 ' Return:  AH = line status
 ' ----------1402-------------------------------
 ' INT 14 - SERIAL - READ CHARACTER FROM PORT
 '          AH = 02h
 '          DX = port number
 ' Return:  AH = line status
 '          AL = received character
 ' ----------1403-------------------------------
 ' INT 14 - SERIAL - GET PORT STATUS
 '          AH = 03h
 '          DX = port number
 ' Return:  AX = port status
 '               AH = line status
 '               bits 7 - 0
 '                  7: timeout
 '                  6: transmit shift register empty (TSRE)
 '                  5: transmit holding register empty (THRE)
 '                  4: break detected
 '                  3: framing error
 '                  2: parity error
 '                  1: overrun error (OVRN)
 '                  0: receive data ready (RDA) (Dnd Door uses this bit)
 '               AL = modem status
 '               bits 7 - 0
 '                  7: carrier detect (CD) (Dnd Door uses this bit)
 '                  6: ring indicator (RI)
 '                  5: data set ready (DSR)
 '                  4: clear to send (CTS)
 '                  3: delta carrier detect (DCD)
 '                  2: trailing edge of ring indicator (TERI)
 '                  1: delta data set ready (DDSR)
 '                  0: delta clear to send (DCTS)
Sub Driver(Sub.Function) ' Sub.Function is BIOS function 1, 2, or 3.
 On Local Error Resume Next
 Inregs.AX=Sub.Function ' modem function plus parameters
 Inregs.DX=Port ' modem port line 0 to 7
 Call Interrupt(&H14,Inregs,Outregs) ' modem dos function hexidecimal 14
End Sub ' end routine to call modem function

 Rem * routine to calculate elapsed time
 Rem * input variables:
 Rem *   Start.Time! - equals stored start time from Timer function.
 Rem *   Wait.Time! - equals elapsed time to calculate in seconds.
 Rem * output variables:
 Rem *   Time.Expired - set to true if Wait.Time has elapsed.
 Rem * working variables:
 Rem *   Time.Elapsed! - contains time difference.

Sub Second.Timer(Time.Expired,Start.Time!,Wait.Time!)
 On Local Error Resume Next ' local error resume
 Time.Expired=False ' set return flag time has not expired
 Time.Elapsed!=Timer-Start.Time! ' calculate time elapsed from start time
 If Time.Elapsed!<0! Then ' check if midnight has passed
    Time.Elapsed!=Time.Elapsed!+86400! ' increment calculated time elapsed
 Endif ' end check midnight passed
 ' compare calculated elapsed time to wait time
 If Time.Elapsed!>=Wait.Time! Then
    Time.Expired=True ' set return flag time has expired
 Endif ' end compare times
End Sub ' end routine to calculate time

Rem * Routine to adjust system clock during midnight errors.

Sub Set.Clock
 On Local Error Resume Next ' local error resume
 If Time$>"23:59:59" Then ' compare system time to midnight
    Sleep 2 ' wait for two seconds for system date to change
    If Time$="24:00:00" Then ' system clock is stuck
       Time$="00:00:01" ' reset system time past midnight
    Endif ' end check stuck system clock
 Endif ' end check incorrect midnight time
End Sub ' end routine to adjust system clock

 Rem * Routine to get and process keyboard entry.
 Rem * output variables:
 Rem *   Keyboard.Break - true to exit from IO.I when function key pressed.
 Rem * work variables:
 Rem *   Keyboard.Char$ - contains key pressed.

Sub Keyboard(Keyboard.Break)
 On Local Error Resume Next ' local error resume
 Keyboard.Break=False ' reset extended/function key input flag
 Keyboard.Char$=Inkey$ ' store next keyboard character from buffer
 Select Case Len(Keyboard.Char$) ' process keyboard character type
 Case 0 ' nothing entered
    Exit Sub ' end routine
 Case 1 ' single keystroke
    Select Case Asc(Keyboard.Char$) ' process single key
    Case 8, 13, 32 To 127 ' valid keys entered during i/o
       Buffer=Buffer+Keyboard.Char$ ' append keystroke to buffer
    Case 11 ' control-k
       If Allow.Break Then ' check break allowed
          Break=True ' set break flag
       Endif ' end check break allowed
    Case 27 ' escape key
       If Chat Then ' check in chat flag
          Chat=False ' set chat exit flag
          Keyboard.Break=True ' set function/extended key flag
       Else ' escape key at console
          If Logged.In Then ' check player in game
             Call Status.Line(True) ' toggles status line area
          Endif ' end check player logged in game
       Endif ' end check flag
    End Select ' end sigle keystroke
 Case 2 ' function/extended key
    Select Case Asc(Right$(Keyboard.Char$,1)) ' process extended key code
    Case 79 ' end key/terminate key
       Call Hang.Up(4) ' routine to hang up modem with message
       Keyboard.Break=True ' set function/extended key flag
    Case 71 ' home key/chat key
       If Chat=False Then ' check if already in chat
          If Local.Mode=False Then ' check local mode not activated
             If Logged.In Then ' check user logged in flag
                Chat=True ' set in chat flag
                Call Enter.Chat ' routine to chat with user
                Chat=False ' reset in chat flag
                Keyboard.Break=True ' set function/extended key flag
             Endif ' end check user logged in
          Endif ' end check local mode
       Endif ' end check chat flag
    Case 59 To 68 ' function key entered
       If Local.Mode=False Then ' check local mode not activated
          If Logged.In Then ' check user logged in flag
             ' store extended key in buffer
             Func.Buffer=Right$(Keyboard.Char$,1)
             Keyboard.Break=True ' set function/extended key flag
          Endif ' end check user logged in
       Endif ' end check local mode
    End Select ' end process extended key code
 End Select ' end process keyboard character type
End Sub ' end routine to get/process keyboard entry

 Rem * Routine to send carriage return/linefeed (cr/lf) to screen/modem.

Sub Line.Return
 On Local Error Resume Next ' local error resume
 Call Scrn(Chr$(13)) ' send return character to screen
 Call Put.Modem(Chr$(13)) ' send cr to modem
 If UserRecord.Linefeeds=False Then ' check linefeed mode
    Call Put.Modem(Chr$(10)) ' send lf to modem
 Endif ' end check linefeed mode
End Sub ' end routine to send cr/lf

 Rem * Routine to backspace over one previous character.

Sub Back.Space
 On Local Error Resume Next ' local error resume
 ' Store current screen location of cursor column minus one
 Cursor.Column=Pos(0)-1
 Locate Csrlin,Cursor.Column,0 ' locate back one space, cursor off
 Print " "; ' erase character with space
 Locate Csrlin,Cursor.Column,1 ' locate back one space, cursor on
 If UserRecord.Echo=False Then ' check echo mode
    Call Put.Modem(Chr$(8)+" "+Chr$(8)) ' send backspace to modem
 Endif ' end check echo mode
End Sub ' end routine to backspace

 Rem * Routine to change color. ANSI to modem, COLOR statement to screen.

Sub Out.ANSI
 On Local Error Resume Next ' local error resume
 Ansi.ColorCode=37 ' default to ANSI white
 If Graphics.Off=False Then ' check graphics color change flag
    Color.Code=Color.Code+1 ' increment current ANSI color variable
    If Color.Code<31 Or Color.Code>36 Then ' check ANSI color bounds
       Color.Code=31 ' reset to base ANSI color
    Endif ' end check color bounds
    Ansi.ColorCode=Color.Code ' store new color code
 Endif ' end check graphics change flag
 Call Modem.ANSI(Ansi.ColorCode) ' send ANSI color code number
End Sub ' end routine to change color

 Rem * Routine to send ANSI color change code to modem/screen.
 Rem * input variables:
 Rem *   Ansi.ColorCode - contains the Ansi color code number.
 Rem * work variables:
 Rem *   Ansi.Output$ - stores the Ansi string to send.

Sub Modem.ANSI(Ansi.ColorCode)
 On Local Error Resume Next ' local error resume
 Call Convert.Color(Ansi.ColorCode) ' change screen color
 If Color.Graphics Then ' check remote ANSI graphics flag
    ' construct ANSI code
    Ansi.Output$=Chr$(27)+"[0;1;"+Mid$(Str$(Ansi.ColorCode),2)+"m"
    Call Put.Modem(Ansi.Output$) ' send code to modem
 Endif ' end check remote ANSI flag
End Sub ' end routine to send ANSI code

 Rem * Routine to reset ANSI color code to default.
 Rem * work variables:
 Rem *   Ansi.Output$ - stores the default Ansi color string.

Sub Reset.ANSI
 On Local Error Resume Next ' local error resume
 If Color.Graphics Then ' check remote ANSI graphics flag
    Ansi.Output$=Chr$(27)+"[0;37m" ' construct ANSI black on white code
    Call Put.Modem(Ansi.Output$) ' send code to modem
 Endif ' end check remote ANSI flag
 Color 7,0 ' reset local screen to black on white
 Print Nul; ' display a zero length string to change color
End Sub ' end routine to reset ANSI color code

 Rem * Routine to change local screen color to ANSI color code number.
 Rem * input variables:
 Rem *   Ansi.ColorCode - the Ansi color code number.
 Rem * work variables:
 Rem *   Screen.ColorCode - stores the CGA screen color number.

Sub Convert.Color(Ansi.ColorCode)
 On Local Error Resume Next ' local error resume
 Select Case Ansi.ColorCode ' choose ANSI color code number
 Case 31 ' ANSI red
    Screen.ColorCode=12 ' COLOR statement red
 Case 32 ' ANSI green
    Screen.ColorCode=10 ' COLOR statement green
 Case 33 ' ANSI yellow
    Screen.ColorCode=14 ' COLOR statement yellow
 Case 34 ' ANSI blue
    Screen.ColorCode=9 ' COLOR statement blue
 Case 35 ' ANSI magenta
    Screen.ColorCode=13 ' COLOR statement magenta
 Case 36 ' ANSI cyan
    Screen.ColorCode=11 ' COLOR statement cyan
 Case 37 ' ANSI white
    Screen.ColorCode=15 ' COLOR statement white
 Case Else ' default ANSI white
    Screen.ColorCode=15 ' COLOR statement white
 End Select ' end choose ANSI color code
 Color Screen.ColorCode,0 ' change screen color
End Sub ' end routine to change local screen color

 Rem * Routine to process stored function key pressed during remote play.
 Rem * input variables:
 Rem *   FunctionKey.Number - the ascii value of the extended function key.

Sub Function.Key(FunctionKey.Number)
 On Local Error Resume Next ' local error resume
 If Logged.In=False Then ' check user is logged in
    Exit Sub ' exit routine
 Endif ' end check user logged in
 If Local.Mode Then ' check console is logged in
    Exit Sub ' exit routine
 Endif ' end check console logged in
 Inpt=Nul ' reset input string
 Outpt=Nul ' reset output string
 Call IO.O ' send empty cr/lf
 Select Case FunctionKey.Number ' choose function key number
 Case 59 ' F1 - !Edit
    Outpt="System Operator is using the editor. Please wait.." ' send message
    Call IO.O ' sysop will edit during game
    Call Put.User.Record ' store user stats
    Local.Mode=True ' set local mode
    Outpt="Sysop: Enter room number to edit, or press enter to start !Edit:"
    Call IO.O ' write local sysop info message
    Outpt=Action.Prompt+"!EDIT " ' display action prompt plus command
    Call IO.I ' get room number to edit(if any)
    If Inpt<>Nul Then ' determine edit room number
       Room.Number=Int(Val(Inpt)) ' room number parameter to edit
       If Room.Number>False And_
       Room.Number<=Lof(RoomFile)/Len(RoomRecord) Then ' range
          Call Change.Room(Room.Number) ' edit room from number parameter
       Endif ' end compare room number range
    Else ' edit users
      Call Editor ' editor routine
    Endif ' end determine edit prompt
    Local.Mode=False ' reset local mode
 Case 60 ' F2 - !Status
    Local.Mode=True ' reset local mode
    Call Display.Memory ' routine to display memory stats
    Local.Mode=False ' restore local mode
 Case 61 ' F3 - !Discard
    Local.Mode=True ' reset local mode
    Outpt="Sysop: Enter player inventory treasure name to discard:"
    Call IO.O ' write local sysop info message
    Outpt=Action.Prompt+"!DISCARD " ' display action prompt plus command
    Call IO.I ' get item to discard
    Parsed.Command1=Ucase$(Inpt) ' store item name
    Call Discard.Object ' routine to discard item from player inventory
    Local.Mode=False ' restore local mode
 Case 62 ' F4 - !Reduce
    Local.Mode=True ' reset local mode
    Outpt="Sysop: Enter number of monsters in room to reduce to:"
    Call IO.O ' write local sysop info message
    Outpt=Action.Prompt+"!REDUCE " ' display action prompt plus command
    Call IO.I ' get number
    Parsed.Command1=Inpt ' store number
    Call Reduce.Monsters ' routine to reduce monsters in room
    Local.Mode=False ' restore local mode
 Case 63 ' F5 - !Call
    Local.Mode=True ' reset local mode
    Outpt="Sysop: Enter name or number of monster to call:"
    Call IO.O ' write local sysop info message
    Outpt=Action.Prompt+"!CALL " ' display action prompt plus command
    Call IO.I ' get monster number
    Local.Mode=False ' restore local mode
    Parsed.Command1=Inpt ' store monster number
    Call Summon.Monster ' routine to get a monster into room
 Case 64 ' F6 - !Kill
    Local.Mode=True ' reset local mode
    Outpt="Sysop: Enter name of monster in room to kill off:"
    Call IO.O ' write local sysop info message
    Outpt=Action.Prompt+"!KILL " ' display action prompt plus command
    Call IO.I ' get monster name
    Local.Mode=False ' restore local mode
    Parsed.Command1=Ucase$(Inpt) ' store monster name
    Parsed.Command2=Parsed.Command1 ' store monster name
    Call Kill.Monster ' routine to kill monster name
 Case 65 ' F7 - !Teleport
    Local.Mode=True ' reset local mode
    Outpt="Sysop: Enter number of room to teleport player to:"
    Call IO.O ' write local sysop info message
    Outpt=Action.Prompt+"!TELEPORT " ' display action prompt plus command
    Call IO.I ' get room number
    Local.Mode=False ' restore local mode
    Parsed.Command1=Inpt ' store room number
    Parsed.Command2=Parsed.Command1 ' store room number
    Call Teleport.User ' routine to teleport user to a room number
 Case 66 ' F8 - !Invisibility
    Call Toggle.Invisible ' routine to toggle invisibility mode
 Case 67 ' F9 - !Get
    Local.Mode=True ' reset local mode
    Outpt="Sysop: Enter name of treasure item to get from treasure file:"
    Call IO.O ' write local sysop info message
    Outpt=Action.Prompt+"!GET " ' display action prompt plus command
    Call IO.I ' get item name
    Local.Mode=False ' restore local mode
    Inpt=Ucase$(Inpt) ' store item name
    Stored.Parsed.Command2=Inpt ' store item name
    Call Drop.Object ' routine to get an item
 Case 68 ' F10 - !Link
    Outpt="System Operator is using the editor. Please wait.." ' send message
    Call IO.O ' sysop will edit during game
    Local.Mode=True ' reset local mode
    Call Link.Room ' routine to add/remove room links
    Local.Mode=False ' restore local mode
 End Select ' end choose function key number
 Outpt=Nul ' reset output string
 Inpt=Nul ' reset input string
End Sub ' end routine to process game function keys

 Rem * Routine to hang up modem with a message.
 Rem * input variables:
 Rem *   HangUp.Type - the hang up message to display.

Sub Hang.Up(HangUp.Type)
 On Local Error Resume Next ' local error resume
 Allow.Break=False ' disable break
 Break=False ' reset control-k flag
 Buffer=Nul ' reset buffer
 Func.Buffer=Nul ' reset function key buffer
 Graphics.Off=True ' turn off graphics color changing
 Inpt=Nul ' set input string to null
 Outpt=Nul ' set output string to null
 Timeon=Timer ' store current time in time on variable
 Time.Left=180 ' store 3 minutes remaining in variable
 Call IO.O ' empty output
 Select Case HangUp.Type ' choose hang up message
 Case 1 ' type 1
    Outpt="Connect timeout!"
 Case 2 ' type 2
    Outpt="Time limit exceeded!"
 Case 3 ' type 3
    ' carrier lost no longer enters here.
 Case 4 ' type 4
    Outpt="Forced logoff!"
 Case 5 ' type 5
    Outpt="Call limit exceeded!"
 Case 6 ' type 6
    Call Restriction.Notice ' routine to display restricted time
 Case 7 ' type 7
    Outpt="Illegal login attempt!"
 Case 8 ' type 8
    Outpt="Password verification!"
 Case 9 ' type 9
    Outpt="Not resurrected!"
 Case 10 ' type 10
    Outpt="Nondescriptive data files!"
 End Select ' end choose hang up message
 Call IO.O ' display message
 Call Status.Line(-2) ' clear status line areas
 End ' terminate program
End Sub ' end routine to hang up modem

 Rem * Routine to put a character on the screen at current row/column.
 Rem * input variables:
 Rem *   Screen.Char$ - the character to display.

Sub Scrn(Screen.Char$)
 On Local Error Resume Next ' local error resume
 Row=Csrlin-1 ' calculate current row, minus one for bios offset
 Column=Pos(0)-1 ' calculate current column, minus one for bios offset
 Select Case Row ' compare current row
 Case Is>Max.Row ' will scroll past max.row (status area)
    Call Scroll.Screen ' scroll the screen
 Case Max.Row ' scroll at max.row (status area)
    If Column=79 Then ' verify column at 79 to scroll
       If Screen.Char$=Chr$(13) Then ' cr/lf at corner of screen,
          Print ' force screen scroll from basic
          Exit Sub ' end routine to put character
       Endif ' end cr/lf at corner
       Call Scroll.Screen ' otherwise, scroll screen for character at corner
    Endif ' end verify column
 End Select ' end compare row
 Print Screen.Char$; ' display character at row, column
End Sub ' end routine to display a character on screen

 Rem * Routine to scroll screen at Max.Row.
 ' ----------1006-------------------------------
 ' INT 10 - VIDEO - SCROLL UP WINDOW
 '          AH = 06h
 '          AL = number of lines by which to scroll up
 '          BH = attribute used to write blank lines at bottom of window
 '          CH,CL = row,column of window's upper left corner
 '          DH,DL = row,column of window's lower right corner
Sub Scroll.Screen
 On Local Error Resume Next ' local error resume
 Inregs.AX=&H0601 ' function AH=06, scroll 1 lines
 Inregs.BX=&H0700 ' attribute of blank line, white on black
 Inregs.CX=&H0000 ' upper left corner, 0,0
 Inregs.DX=Max.Row*256+&H4F ' lower right corner, DH=Max.Row,DL=80
 Call Interrupt(&H10,Inregs,Outregs) ' routine for BIOS call, function Hex10
 Locate Max.Row+1,1 ' set cursor at lower row, column 1
End Sub ' end routine to scroll screen

 Rem * Routine to display users restricted time online.

Sub Restriction.Notice
 On Local Error Resume Next ' local error resume
 Outpt="Your calls are restricted from" ' start of message
 Restrict.Time=UserRecord.FromHour ' store users hour of restricted time
 If Restrict.Time>12 Then ' compare 24 hour format time to standard time
    Outpt=Outpt+Str$(UserRecord.FromHour-12) ' decrement to 24 hour format
    Inpt="pm" ' 24 hour indicator
 Else ' compare to standard time
    Outpt=Outpt+Str$(UserRecord.FromHour) ' store hour format
    Inpt="am" ' 12 hour indicator
 Endif ' end compare time type
 ' format string of restricted time from, plus minutes
 Outpt=Outpt+":"+Right$(Str$(UserRecord.FromMin+100),2)+Inpt+" to"
 Restrict.Time=UserRecord.ToHour ' store users hour of restricted time
 If Restrict.Time>12 Then ' compare 24 hour format time to standard time
    Outpt=Outpt+Str$(UserRecord.ToHour-12) ' decrement to 24 huur format
    Inpt="pm" ' 24 hour indicator
 Else ' compare to standard time
    Outpt=Outpt+Str$(UserRecord.ToHour) ' store hour format
    Inpt="am" ' 12 hour indicator
 Endif ' end compare time type
 ' format string of restricted time to, plus minutes
 Outpt=Outpt+":"+Right$(Str$(UserRecord.ToMin+100),2)+Inpt+"."
 Call IO.O ' display message
End Sub ' end routine to display restricted time

 Rem * Routine to display a text file.
 Rem * input variables:
 Rem *   File.Output$ - filename of file to display.
 Rem * processing variables:
 Rem *   Allow.Break - flag to allow control-k.
 Rem *   Break - set to true if control-k pressed.
 Rem *   Continue - set to true for continuous output
 Rem *   Page.Length, Page.Break - paginating variables.

Sub Out.File(File.Output$)
 On Local Error Goto OutFile.Error ' local error routine
 Graphics.Off=True ' turn off graphics color changing
 File.Page=UserRecord.Pagelength ' store pagelength
 If File.Page=False Then ' check pagelength
    File.Page=24 ' reset pagelength
 Endif ' end check pagelength
 Allow.Break=True ' turn on allow break flag
 Break=False ' reset control-k flag
 Continue=False ' reset continuous flag
 Page.Length=False ' reset page counter
 Page.Break=False ' reset paginated flag
 Close 13 ' free the temporary file handle
 Open File.Output$ For Input Shared As #13 ' open the file
 Do While Not Eof(13) ' loop through all the text in file
    Line Input #13,Outpt ' get the next text line
    Call IO.O ' display the text line
    If Break Then ' check control-k pressed
       Exit Do ' exit text input loop
    Endif ' end check control-k
    Page.Length=Page.Length+1 ' increment line displayed counter
    If Page.Length=File.Page Then ' compare page counter
       Page.Length=False ' reset page counter
       Page.Break=True ' set paginated flag
       If Continue=False Then ' check continuous flag
          Call More.Prompt ' routine to prompt for more
          If No Then ' check more prompt returned no flag
             Exit Do ' exit text input loop
          Endif ' end check more prompt no flag
       Endif ' end check page counter
    Endif ' end check continuous flag
 Loop ' end text file input loop
 Allow.Break=False ' reset allow break flag
 If Break Then ' check control-k flag
    Break=False ' reset control-k flag
    Outpt=Nul ' set output to null
    Call IO.O ' send empty return
 Endif ' end check control-k flag
 Graphics.Off=False ' reset graphics color changer
 If Page.Break Then ' check paginated flag
    If Page.Length Then ' check page counter
       Call More.Prompt ' routine to prompt for more
    Endif ' end check page counter
 Endif ' end check paginated flag
OutFile.Exit:
 Allow.Break=False ' reset allow break flag
 Break=False ' reset control-k flag
 Graphics.Off=False ' reset color change flag
 Exit Sub ' exit routine
OutFile.Error:
 Resume OutFile.Exit
End Sub ' end routine to display a text file

 Rem * Routine to display the more prompt.
 Rem * work variables:
 Rem *   Graphics.Type - stores graphics cycling variable.

Sub More.Prompt
 On Local Error Resume Next ' local error resume
 Graphics.Type=Graphics.Off ' store graphics changing flag
 Graphics.Off=False ' turn off graphics changing
 Outpt=More$ ' get the more prompt
 Line.Length=1 ' allow one key input
 No.Echo=True ' do not echo any key
 Call IO.I ' input routine
 Graphics.Off=Graphics.Type ' restore graphics changing flag
End Sub

 Rem * Routine to restrict a room direction to a players level.
 Rem * input variable:
 Rem *   Room.Direction - direction to restrict.
 Rem * output variable:
 Rem *   Direction.Restricted - set true to restrict player.
 Rem * work variables:
 Rem *   Action.Number - contains the room action number.

Sub Restrict(Room.Direction,Direction.Restricted)
 On Local Error Resume Next ' local error resume
 Direction.Restricted=False ' reset return variable
 Action.Number=RoomRecord.Action ' store room action number
 If Action.Number>False And_
 Action.Number<=Lof(12)/Len(ActionRecord) Then ' check file bounds
    Get 12,Action.Number,ActionRecord ' read action record
    Select Case ActionRecord.Level ' determine player level
    Case Is>False ' player at least room level
       If UserRecord.Level<ActionRecord.Level Then ' compare levels
          ' compare room direction
          If ActionRecord.Restrictions And 2^Room.Direction Then
             Direction.Restricted=True ' direction restricted flag
          Endif ' end compare room direction
       Endif ' end compare levels
    Case Is<False ' player at most room level
       If UserRecord.Level>Abs(ActionRecord.Level) Then ' compare levels
          ' compare room direction
          If ActionRecord.Restrictions And 2^Room.Direction Then
             Direction.Restricted=True ' direction restricted flag
          Endif ' end compare room direction
       Endif ' end compare levels
    End Select ' end choose room/player level
 Endif ' end check file bounds
End Sub ' end routine to restrict room entrance

 Rem * Routine to restrict a room direction to entry type.
 Rem * input variable:
 Rem *   Room.Direction - direction to restrict.
 Rem * output variable:
 Rem *   Direction.Restricted - set true to restrict player.
 Rem * work variables:
 Rem *   Action.Number - contains the room action number.

Sub Restrict.Room.Type(Room.Direction,Direction.Restricted)
 On Local Error Resume Next ' local error resume
 Get 3,Next.Room,RoomRecord ' read next room number record
 Direction.Restricted=False ' reset return variable
 Action.Number=RoomRecord.Action ' store room action number
 If Action.Number>False And_
 Action.Number<=Lof(12)/Len(ActionRecord) Then ' check file bounds
    Get 12,Action.Number,ActionRecord ' read action record
    If ActionRecord.Attribute2>False Then ' check action attribute 2
       If ActionRecord.Attribute2=Air Then ' verify room is air
          If Entry.Command<>Fly Then ' verify player fly
             Direction.Restricted=True ' set restricted flag
          Endif ' end verify player fly command
       Endif ' end verify room air attribute
       If ActionRecord.Attribute2=Underwater Then ' verify room underwater
          If Entry.Command<>Swim Then ' verify player swim
             Direction.Restricted=True ' set restricted flag
          Endif ' end verify player swim command
       Endif ' end verify room underwater attribute
    Endif ' end verify room action attribute
 Endif ' end check file bounds
 Get 3,Room,RoomRecord ' read current room record
End Sub ' end routine to restrict room entrance

 Rem * Routine to determine validity of a string.
 Rem * input variables:
 Rem *   Validate$ - string to verify.
 Rem *   Length - stores length string must be (an even number).
 Rem * output variables:
 Rem *   Validate$ - set to null if invalid.
 Rem * work variables:
 Rem *   String.Length - loop counter of string to validate.
 Rem *   Char - character in string to check.

Sub Valid(Validate$,Length)
 On Local Error Resume Next ' local error resume
 Validate$=Left$(Validate$,Length) ' truncate string to length
 Validate$=Validate$+Space$(Length-Len(Validate$)) ' extend string length
 For String.Length=1 To Len(Validate$) ' loop through all characters in string
    ' get ascii value of string character
    Char=Asc(Mid$(Validate$,String.Length,1))
    If Char<32 Or Char>127 Then ' verify bounds of character
       Validate$=Nul ' return null if not valid
       Exit Sub ' end routine
    Endif ' end verify ascii code
 Next ' end loop
End Sub ' end routine to determine string validity

 Rem * Routine to encrypt a string.
 Rem * input variables:
 Rem *   Encrypted$ - the string to encrypt.
 Rem *   Add.Checksum - set to false to add byte checksum.
 Rem * output variables:
 Rem *   Encrypted$ - the encrypted string.
 Rem * work variables:
 Rem *   Encrypt.Work$ - variable containing encrypted string.
 Rem *   Encrypt.Count - loop variable.
 Rem *   Encrypted.Sum - calculated byte encryption variable.
 Rem *   Encrypt.Work1, Encrypt.Work2, Encrypt.Work3.

Sub Encrypt(Encrypted$,Add.Checksum)
 On Local Error Resume Next ' local error resume
 Encrypt.Work$=Nul ' reset encrypted work variable
 ' loop through string to encrypt in byte pairs
 For Encrypt.Count=1 To Len(Encrypted$) Step 2
    ' get first byte substring of pair
    Encrypt.Work1=Asc(Mid$(Encrypted$,Encrypt.Count,1))
    ' get second byte substring of pair
    Encrypt.Work2=Asc(Mid$(Encrypted$,Encrypt.Count+1,1))
    If Add.Checksum Then ' check checksum ordering
       Encrypted.Sum=20000 ' checksum bit off
    Else ' checksum ordering on
       Encrypt.Work3=Encrypt.Work1+Encrypt.Work2 ' compute sum
       ' compute even sum of bytes
       If Int(Encrypt.Work3/2)=Encrypt.Work3/2 Then
          Encrypted.Sum=10000 ' checksum bit for even parity
       Else ' checksum ordering
          Encrypted.Sum=False ' checksum bit for odd parity
       Endif ' end check checksum ordering
    Endif ' end verify checksum used
    ' convert checksum and bytes to integer
    Encrypted.Sum=Encrypted.Sum+(Encrypt.Work1-32)*100+(Encrypt.Work2-32)
    ' convert integer to string
    Encrypt.Work$=Encrypt.Work$+Mki$(Encrypted.Sum)
 Next ' end loop through string to encrypt
 Encrypted$=Encrypt.Work$ ' set return variable to encrypted string
End Sub ' end routine to encrypt a string

 Rem * Routine to decrypt a string.
 Rem * input variables:
 Rem *   Decrypted$ - the string to decrypt.
 Rem * output variables:
 Rem *   Decrypted$ - the decrypted string, or null for checksum error.
 Rem * work variables:
 Rem *   Decrypt.Work$ - variable containing encrypted string.
 Rem *   Decrypt.Count - loop variable.
 Rem *   Decrypted.Sum - calculated byte encryption variable.
 Rem *   Decrypt.Work1, Decrypt.Work2, Decrypt.Work3.
 Rem *   Decrypted.Checksum - contains the bit parity.

Sub Decrypt(Decrypted$)
 On Local Error Resume Next ' local error resume
 Decrypt.Work$=Nul ' reset decrypted work variable
 ' loop through string to decrypt in byte pairs
 For Decrypt.Count=1 To Len(Decrypted$) Step 2
    ' convert the two byte string to integer
    Decrypted.Sum=Cvi(Mid$(Decrypted$,Decrypt.Count,2))
    ' divide two byte integer to one byte integer
    Decrypted.Checksum=Decrypted.Sum\100
    ' get low byte from pair
    Decrypt.Work1=Decrypted.Sum-Decrypted.Checksum*100
    ' adjust byte ascii value
    Decrypt.Work1=Decrypt.Work1+32
    ' reset integer of string to high byte
    Decrypted.Sum=Decrypted.Checksum
    ' divide byte integer out leaving checksum bit
    Decrypted.Checksum=Decrypted.Sum\100
    ' get high byte from pair
    Decrypt.Work2=Decrypted.Sum-Decrypted.CHecksum*100
    Decrypt.Work2=Decrypt.Work2+32 ' adjust byte ascii value
    Decrypt.Work3=Decrypt.Work1+Decrypt.Work2 ' compute sum
    Select Case Decrypted.Checksum ' select checksum parity
    Case 0 ' verify the checksum bit for odd parity
       If Int(Decrypt.Work3/2)=Decrypt.Work3/2 Then ' check not odd parity
          Decrypted$=Nul ' return null for checksum error
          Exit Sub ' end routine
       Endif ' end check not odd parity
    Case 1 ' verify the checksum bit for even parity
       If Int(Decrypt.Work3/2)<>Decrypt.Work3/2 Then ' check not even parity
          Decrypted$=Nul ' return null for checksum error
          Exit Sub ' end routine
       Endif ' end check not even parity
    End Select ' end verify checksum bit
    ' convert integer bytes to string
    Decrypt.Work$=Decrypt.Work$+Chr$(Decrypt.Work2)+Chr$(Decrypt.Work1)
 Next ' end loop through string to decrypt
 Decrypted$=Decrypt.Work$ ' set return variable to decryptes string
End Sub ' end routine to decrypt a string

 Rem * Routine to store a file record
 Rem * input variables:
 Rem *   File.Number - number of the file to write record.
 Rem *   Record.Number - the number of the record to write.

Sub Share.Record(File.Number,Record.Number)
 On Local Error Resume Next ' local error resume
 Select Case File.Number ' select file number to write a record to
 Case 1 ' type 1
    Put 1,Record.Number,UserRecord ' write user record
 Case 2 ' type 2
    Put 2,Record.Number,MonsterRecord ' write nonplayers record
 Case 3 ' type 3
    Put 3,Record.Number,RoomRecord ' write room record
 Case 4 ' type 4
    Put 4,Record.Number,ObjectRecord ' write object record
 Case 5 ' type 5
    Put 5,Record.Number,MonsterRecord ' write monsters record
 Case 6 ' type 6
    Put 6,Record.Number,TreasureRecord ' write treasure record
 Case 7 ' type 7
    Put 7,Record.Number,MonsterTalkRecord ' write monster talk record
 Case 8 ' type 8
    Put 8,Record.Number,MonclassRecord ' write monster class record
 Case 9 ' type 9
    Put 9,Record.Number,SpellRecord ' write spell record
 Case 10 ' type 10
    Put 10,Record.Number,TableRecord ' write message table record
 Case 11 ' type 11
    Put 11,Record.Number,MessageRecord ' write message record
 Case 12 ' type 12
    Put 12,Record.Number,ActionRecord ' write action record
 End Select ' end select file number
End Sub ' end routine to write file record using share

 Rem * This routines displays information of the action file.
 Rem * input variables:
 Rem *   Number - the room file record.

Sub Display.Action(Number)
 On Local Error Resume Next ' local error resume
 Graphics.Off=False ' reset color
 Outpt="Action number"+Str$(Number)+":" ' action number message
 Call IO.O ' send output message
 Graphics.Off=True ' reset color
 If ActionRecord.MonsterTrigger Then ' check action trigger
    ' get monster trigger record
    Get 5,ActionRecord.MonsterTrigger,MonsterRecord
    Outpt=MonsterRecord.MonsterName ' store monster name
    Outpt=Rtrim$(Outpt) ' trim name
    Inpt=Str$(ActionRecord.MonsterTrigger)+", "+Outpt+"." ' make message
 Else ' check trigger
    Inpt=" <none>" ' make default message
 Endif ' end check trigger
 Outpt="[A]Monster trigger in effect for monster:"+Inpt ' make message
 Call IO.O ' send output message
 If ActionRecord.SpellTrigger Then ' check action trigger
    Get 9,ActionRecord.SpellTrigger,SpellRecord ' get spell trigger record
    Outpt=SpellRecord.SpellName ' store spell name
    Outpt=Rtrim$(Outpt) ' trim name
    Inpt=Str$(ActionRecord.SpellTrigger)+", "+Outpt+"." ' make message
 Else ' check trigger
    Inpt=" <none>" ' make default message
 Endif ' end check trigger
 Outpt="[B]Spell trigger in effect for spell:"+Inpt
 Call IO.O ' send output message
 If ActionRecord.MonsterTalk Then ' check action trigger
    Get 5,ActionRecord.MonsterTalk,MonsterRecord ' get monster trigger record
    Outpt=MonsterRecord.MonsterName ' store monster name
    Outpt=Rtrim$(Outpt) ' trim name
    Inpt=Str$(ActionRecord.MonsterTalk)+", "+Outpt+"." ' make message
 Else ' check trigger
    Inpt=" <none>" ' make default message
 Endif ' end check trigger
 Outpt="[C]Monster talk trigger in effect for monster:"+Inpt ' make message
 Call IO.O ' send output message
 If ActionRecord.Level>False Then ' check action trigger
    Inpt=Str$(ActionRecord.Level) ' make message
 Else ' check trigger
    Inpt=" <none>" ' make default message
 Endif ' end check trigger
 Outpt="[D]High level room entry:"+Inpt ' message
 If ActionRecord.Level<False Then ' check action trigger
    Inpt=Str$(Abs(ActionRecord.Level)) ' make message
 Else ' check trigger
    Inpt=" <none>" ' make default message
 Endif ' end check trigger
 Outpt=Outpt+", Low level room entry:"+Inpt ' message
 Call IO.O ' send output message
 Outpt="Restricted room directions:" ' make message
 Call IO.O ' send output message
 If ActionRecord.Restrictions>False Then ' check action trigger
    Outpt=Nul ' reset message
    If ActionRecord.Restrictions And 2^1 Then ' check restriction trigger
       Outpt=Outpt+"North, " ' append direction
    Endif ' end check trigger
    If ActionRecord.Restrictions And 2^2 Then ' check restriction trigger
       Outpt=Outpt+"East, " ' append message
    Endif ' end check trigger
    If ActionRecord.Restrictions And 2^3 Then ' check restriction trigger
       Outpt=Outpt+"South, " ' append message
    Endif ' end check trigger
    If ActionRecord.Restrictions And 2^4 Then ' check restriction trigger
       Outpt=Outpt+"West, " ' append message
    Endif ' end check trigger
    If ActionRecord.Restrictions And 2^5 Then ' check restriction trigger
       Outpt=Outpt+"Out, " ' append message
    Endif ' end check trigger
    If ActionRecord.Restrictions And 2^6 Then ' check restriction trigger
       Outpt=Outpt+"Up, " ' append message
    Endif ' end check trigger
    If ActionRecord.Restrictions And 2^7 Then ' check restriction trigger
       Outpt=Outpt+"Down, " ' append message
    Endif ' end check trigger
    If ActionRecord.Restrictions And 2^8 Then ' check restriction trigger
       Outpt=Outpt+"Northeast, " ' append message
    Endif ' end check trigger
    If ActionRecord.Restrictions And 2^9 Then ' check restriction trigger
       Outpt=Outpt+"Southeast, " ' append message
    Endif ' end check trigger
    If ActionRecord.Restrictions And 2^10 Then ' check restriction trigger
       Outpt=Outpt+"Southwest, " ' append message
    Endif ' end check trigger
    If ActionRecord.Restrictions And 2^11 Then ' check restriction trigger
       Outpt=Outpt+"Northwest, " ' append message
    Endif ' end check trigger
    If ActionRecord.Restrictions And 2^12 Then ' check restriction trigger
       Outpt=Outpt+"Go to portal, " ' append message
    Endif ' end check trigger
    If Len(Outpt) Then ' check string length
       Outpt=Left$(Outpt,Len(Outpt)-2) ' truncate comma
    Endif ' end check string length
 Else ' check trigger
    Outpt="<none>" ' default message
 Endif ' end check trigger
 Call IO.O ' send output message
 Outpt="[E]Action hits for:"
 Select Case ActionRecord.HitPoints ' check action trigger
 Case Is>False
    Inpt=Str$(ActionRecord.HitPoints)+" fatigue" ' make message
 Case Is<False
    Inpt=Str$(Abs(ActionRecord.HitPoints))+" vitality" ' make message
 Case Else ' check trigger
    Inpt=" <none>" ' default message
 End Select ' end check trigger
 Outpt=Outpt+Inpt
 Call IO.O ' send output message
 If ActionRecord.EncounterRate Then ' check action trigger
    Inpt=Str$(ActionRecord.EncounterRate) ' make message
 Else ' check trigger
    Inpt=" <none>" ' default message
 Endif ' end check trigger
 Outpt="[F]Encounter rate:"+Inpt
 If ActionRecord.HealthRate Then ' check action trigger
    Inpt=Str$(ActionRecord.HealthRate) ' make message
 Else ' check trigger
    Inpt=" <none>" ' default message
 Endif ' end check trigger
 Outpt=Outpt+", Health rate:"+Inpt
 Call IO.O ' send output message
 Outpt="[G]Inventory: "
 Select Case ActionRecord.Inventory ' make selection of inventory actions
 Case 1 ' weapon action
    Inpt="breaks weapons" ' make message
 Case 2 ' shield action
    Inpt="smashes shields" ' make message
 Case 3 ' armor action
    Inpt="wrecks armor" ' make message
 Case 4 ' magic item action
    Inpt="drains magic items" ' make message
 Case Else ' check trigger
    Inpt="<none>"
 End Select ' end selection of inventory actions
 Outpt=Outpt+Inpt
 Call IO.O
 If ActionRecord.Fumble Then ' check action trigger
    Outpt="[H]Action fumbles." ' make message
 Else ' check trigger
    Outpt="[H]Action does not fumble." ' make message
 Endif ' end check trigger
 Call IO.O ' send output message
 If ActionRecord.Teleport Then ' check action trigger
    Outpt="[I]Action teleports to room"+Str$(ActionRecord.Teleport)+"."
 Else ' check trigger
    Outpt="[I]Action does not teleport." ' make message
 Endif ' end check trigger
 Call IO.O ' send output message
 If ActionRecord.RustRate Then ' check action trigger
    Inpt=Str$(ActionRecord.RustRate) ' make message
 Else ' check trigger
    Inpt=" <none>" ' default message
 Endif ' end check trigger
 Outpt="[J]Action has weapon rusting rate of"+Inpt+" rounds." ' message
 Call IO.O ' send output message
 If ActionRecord.StealRate Then ' check action trigger
    Inpt=Str$(ActionRecord.StealRate) ' make message
 Else ' check trigger
    Inpt=" <none>" ' default message
 Endif ' end check trigger
 Outpt="[K]Action has monster stealing rate of"+Inpt+" rounds." ' message
 Call IO.O ' send output message
 Outpt="[L]Action attributes: " ' make edit display message
 If ActionRecord.Attribute1=False Then ' check attribute
    Outpt=Outpt+"Lit" ' append attribute message
 Else ' check attribute
    Outpt=Outpt+"Dark" ' append attribute message
 Endif ' end check attribute
 Outpt=Outpt+", " ' append comma
 Select Case ActionRecord.Attribute2 ' select attribute
 Case False ' check attribute
    Outpt=Outpt+"Land" ' append attribute message
 Case Air ' check attribute
    Outpt=Outpt+"Air" ' append attribute message
 Case Underwater ' check attribute
    Outpt=Outpt+"Underwater" ' append attribute message
 End Select ' end select attribute
 Call IO.O ' send attribute message
 Outpt="[X]Clear action" ' make alternate display message
 Call IO.O ' send alternate display message
End Sub

 Rem * This routines displays information on the monster file.
 Rem * input variables:
 Rem *   Number - the monster file record.

Sub Display.Monster(Number)
 On Local Error Resume Next ' local error resume
 Graphics.Off=False ' reset color
 Outpt="Monster number"+Str$(Number)+":" ' monster number message
 Call IO.O ' send output message
 Graphics.Off=True ' reset color
 Outpt="[A]Monster name: "+Rtrim$(MonsterRecord.MonsterName) ' message
 Call IO.O ' send output message
 Outpt="[B]Plural of monster name: "+MonsterRecord.PluralName ' message
 Call IO.O ' send output message
 Outpt="[C]Monster level:"+Str$(MonsterRecord.Level) ' message
 Call IO.O ' send output message
 Outpt="[D]Magical monster: " ' message
 If MonsterRecord.Magic Then ' verify monster
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[E]Hit points:"+Str$(MonsterRecord.Hits) ' message
 Call IO.O ' send output message
 Outpt="[F]Experience points:"+Str$(MonsterRecord.Experience) ' message
 Call IO.O ' send output message
 Outpt="[G]Gold points:"+Str$(MonsterRecord.Gold) ' message
 Call IO.O ' send output message
 Outpt="[H]Number appearing:"+Str$(MonsterRecord.NumberAppearing) ' message
 Call IO.O ' send output message
 Outpt="[I]Poisonous monster: " ' message
 If MonsterRecord.Poison Then ' verify monster
    Outpt=Outpt+"Yes("+Mid$(Str$(MonsterRecord.PoisonPercent),2)+_
    " percent)" ' message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[J]Level draining monster: " ' message
 If MonsterRecord.LevelDrain Then ' verify monster
    Outpt=Outpt+"Yes("+Mid$(Str$(MonsterRecord.DrainPercent),2)+_
    " percent)" ' message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[K]Monster blocks exits: " ' message
 If MonsterRecord.Block Then ' verify monster
    Outpt=Outpt+"Yes("+Mid$(Str$(MonsterRecord.BlockPercent),2)+_
    " percent)" ' message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[L]Monster prevents treasure take: " ' message
 If MonsterRecord.Prevent Then ' verify monster
    Outpt=Outpt+"Yes("+Mid$(Str$(MonsterRecord.PreventPercent),2)+_
    " percent)" ' message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[M]Monster follows player: " ' message
 If MonsterRecord.Follow Then ' verify monster
    Outpt=Outpt+"Yes("+Mid$(Str$(MonsterRecord.FollowPercent),2)+_
    " percent)("+Mid$(Str$(MonsterRecord.Teleport),2)+"% teleport)"
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[N]Monster casts spells: " ' message
 Spell.Number=MonsterRecord.Spell ' store spell number
 If Spell.Number=False Then ' verify monster
    Outpt=Outpt+"No" ' add to message
 Else ' verify
    ' file bounds
    If Spell.Number>False And Spell.Number<=Lof(9)/Len(SpellRecord) Then
       Get 9,Spell.Number,SpellRecord ' get spell record
       Outpt=Outpt+"Yes, "+Rtrim$(SpellRecord.SpellName)+_
       "("+Mid$(Str$(MonsterRecord.SpellPercent),2)+" percent)" ' message
    Endif ' end check file bounds
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[O]Monster jails attacker: " ' message
 If MonsterRecord.Jail Then ' verify monster
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[P]Encounter rate:"+Str$(MonsterRecord.Rate)+_
 " ("+Mid$(Str$(MonsterRecord.RatePercent),2)+" percent)" ' message
 Call IO.O ' send output message
 Outpt="[R]Permanent monster: " ' message
 If MonsterRecord.Permanent Then ' verify monster
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[S]Monster uses psionics: " ' message
 If MonsterRecord.Psionic=False Then ' verify monster
    Outpt=Outpt+"No" ' add to message
 Else ' verify
    Spell.Number=MonsterRecord.PsionicSpell ' store psionic spell number
    ' file bounds
    If Spell.Number>False And Spell.Number<=Lof(9)/Len(SpellRecord) Then
       Get 9,Spell.Number,SpellRecord ' get spell record
       Outpt=Outpt+"Yes, "+SpellRecord.SpellName ' message
    Endif ' end check file bounds
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[T]Carries treasure:" ' message
 Call IO.O ' send output message
 For Array.Number=1 To 5 ' loop through monster treasure
    ' get monster treasure number
    Treasure.Number=MonsterRecord.Treasure(Array.Number)
    If Treasure.Number>False And_
    Treasure.Number<=Lof(6)/Len(TreasureRecord) Then ' file bounds
       Get 6,Treasure.Number,TreasureRecord ' get treasure record
       Outpt=TreasureRecord.TreasureName ' store treasure name
       Call IO.O ' send output message
    Endif ' end check file bounds
 Next ' end loop through monster treasure
End Sub ' end routine

 Rem * This routines displays information on the monster class file.
 Rem * input variables:
 Rem *   Number - the monster class file record.

Sub Display.Monster.Class(Number)
 On Local Error Resume Next ' local error resume
 Graphics.Off=False ' reset color
 Outpt="Monster class number"+Str$(Number)+":"
 Call IO.O ' send output message
 Graphics.Off=True ' reset color
 For Array.Number=1 To 10 ' loop through the monster classes
    ' get monster number in class
    Monster.Index=MonclassRecord.Monsters(Array.Number)
    ' file bounds
    If Monster.Index>False And Monster.Index<=Lof(5)/Len(MonsterRecord) Then
       Get 5,Monster.Index,MonsterRecord ' get monster record
       Outpt="Monster number"+Str$(Array.Number)+":"+_
       Rtrim$(MonsterRecord.MonsterName) ' make display message
       Call IO.O ' send output message
    Endif ' end check file bounds
 Next ' end loop through monster class
End Sub ' end routine to display monster class

 Rem * This routines displays information on the nonplayer file.
 Rem * input variables:
 Rem *   Number - the nonplayer file record.

Sub Display.Nonplayer(Number)
 On Local Error Resume Next ' local error resume
 Graphics.Off=False ' reset color
 Outpt="Nonplayer number"+Str$(Number)+":" ' nonplayer number message
 Call IO.O ' send output message
 Graphics.Off=True ' reset color
 Outpt="[A]Nonplayer name: "+Rtrim$(MonsterRecord.MonsterName) ' message
 Call IO.O ' send output message
 Outpt="[B]Nonplayer rooms: "+MonsterRecord.PluralName ' message
 Call IO.O ' send output message
 Outpt="[C]Nonplayer level:"+Str$(MonsterRecord.Level) ' message
 Call IO.O ' send output message
 Outpt="[D]Hit points:"+Str$(MonsterRecord.Hits) ' message
 Call IO.O ' send output message
 Outpt="[E]Experience points:"+Str$(MonsterRecord.Experience) ' message
 Call IO.O ' send output message
 Outpt="[F]Gold points:"+Str$(MonsterRecord.Gold) ' message
 Call IO.O ' send output message
 Outpt="[G]Poisonous nonplayer: " ' message
 If MonsterRecord.Poison Then ' verify nonplayer
    Outpt=Outpt+"Yes("+Mid$(Str$(MonsterRecord.PoisonPercent),2)+_
    " percent)" ' message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[H]Level draining nonplayer: " ' message
 If MonsterRecord.LevelDrain Then ' verify nonplayer
    Outpt=Outpt+"Yes("+Mid$(Str$(MonsterRecord.DrainPercent),2)+_
    " percent)" ' message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[I]Nonplayer blocks exits: " ' message
 If MonsterRecord.Block Then ' verify nonplayer
    Outpt=Outpt+"Yes("+Mid$(Str$(MonsterRecord.BlockPercent),2)+_
    " percent)" ' message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[J]Nonplayer prevents treasure take: " ' message
 If MonsterRecord.Prevent Then ' verify nonplayer
    Outpt=Outpt+"Yes("+Mid$(Str$(MonsterRecord.PreventPercent),2)+_
    " percent)" ' message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[K]Nonplayer follows player: " ' message
 If MonsterRecord.Follow Then ' verify nonplayer
    Outpt=Outpt+"Yes("+Mid$(Str$(MonsterRecord.FollowPercent),2)+_
    " percent)("+Mid$(Str$(MonsterRecord.Teleport),2)+"% teleport)" ' message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[L]Nonplayer casts spells: " ' message
 Spell.Number=MonsterRecord.Spell ' store spell number
 If Spell.Number=False Then ' verify nonplayer
    Outpt=Outpt+"No" ' add to message
 Else ' verify
    ' file bounds
    If Spell.Number>False And Spell.Number<=Lof(9)/Len(SpellRecord) Then
       Get 9,Spell.Number,SpellRecord ' get spell record
       Outpt=Outpt+"Yes, "+Rtrim$(SpellRecord.SpellName)+"("+_
       Mid$(Str$(MonsterRecord.SpellPercent),2)+" percent)" ' message
    Endif ' end check file bounds
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[M]Nonplayer jails attacker: " ' message
 If MonsterRecord.Jail Then ' verify nonplayer
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[N]Encounter rate:"+Str$(MonsterRecord.Rate)+_
 " ("+Mid$(Str$(MonsterRecord.RatePercent),2)+" percent)" ' message
 Call IO.O ' send output message
 Outpt="[O]Nonplayer uses psionics: " ' message
 If MonsterRecord.Psionic=False Then ' verify nonplayer
    Outpt=Outpt+"No" ' add to message
 Else ' verify
    Spell.Number=MonsterRecord.PsionicSpell ' store psionic spell number
    ' file bounds
    If Spell.Number>False And Spell.Number<=Lof(9)/Len(SpellRecord) Then
       Get 9,Spell.Number,SpellRecord ' get spell record
       Outpt=Outpt+"Yes, "+SpellRecord.SpellName ' message
    Endif ' end check file bounds
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[P]Carries treasure:" ' message
 Call IO.O ' send output message
 For Array.Number=1 To 5 ' loop through nonplayer treasure
    ' get nonplayer treasure number
    Treasure.Number=MonsterRecord.Treasure(Array.Number)
    If Treasure.Number>False And_
    Treasure.Number<=Lof(6)/Len(TreasureRecord) Then ' file bounds
       Get 6,Treasure.Number,TreasureRecord ' get treasure record
       Outpt=TreasureRecord.TreasureName ' store treasure name
       Call IO.O ' send output message
    Endif ' end check file bounds
 Next ' end loop through nonplayer treasure
End Sub ' end routine

 Rem * This routines displays information on the object file.
 Rem * input variables:
 Rem *   Number - the object file record.

Sub Display.Object(Number)
 On Local Error Resume Next ' local error resume
 Graphics.Off=False ' reset color
 Outpt="Object number"+Str$(Number)+":" ' object number message
 Call IO.O ' send output message
 Graphics.Off=True ' reset color
 Outpt="[A]Object name: "+Rtrim$(ObjectRecord.ObjectName) ' message
 Call IO.O ' send output message
 Outpt="[B]Object identifier: "+Lcase$(Rtrim$(ObjectRecord.ShortName))
 Call IO.O ' send output message
 Outpt="[C]Room number link:"+Str$(ObjectRecord.RoomLink) ' message
 Call IO.O ' send output message
 Outpt="[D]Trapped portal: " ' message
 Select Case ObjectRecord.Trap ' selection of object trap type
 Case False ' verify object
    Outpt=Outpt+"No" ' add to message
 Case 1 ' verify object
    Outpt=Outpt+"poison needles" ' message
 Case 2 ' berify object
    Outpt=Outpt+"teleport to"+Str$(ObjectRecord.Teleport) ' message
 Case 3 ' verify object
    Outpt=Outpt+"hits for"+Str$(Abs(ObjectRecord.Teleport))+" " ' message
    Select Case Object.Teleport ' selection of object trap hit type
    Case Is<False ' verify object
       Outpt=Outpt+"vitality" ' message
    Case Else ' verify object
       Outpt=Outpt+"fatigue" ' message
    End Select ' end selection of object hit type
 End Select ' end selection of object type
 Call IO.O ' send output message
 Outpt="[E]Long description:" ' message
 Call IO.O ' send output message
 Outpt=Rtrim$(ObjectRecord.LongDesc) ' message
 Call IO.O ' send output message
 Outpt="[F]Entry description:" ' message
 Call IO.O ' send output message
 Outpt=Rtrim$(ObjectRecord.ShortDesc) ' message
 Call IO.O ' send output message
 Outpt="[G]Hidden object: " ' message
 If ObjectRecord.Hidden Then ' verify object
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[H]Invisible object: " ' message
 If ObjectRecord.Invisible Then ' verify object
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[I]Jail attacker trap: " ' message
 If ObjectRecord.JailTrap Then ' verify object
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[J]Locked portal: " ' message
 If ObjectRecord.DoorLock=2 Then ' verify object
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[K]Relocking portal: " ' message
 If ObjectRecord.Relocks Then ' verify object
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[L]Key number:"+Str$(ObjectRecord.Keyed) ' message
 Call IO.O ' send output message
 Outpt="[M]Permanent object: " ' message
 If ObjectRecord.Permanent Then ' verify object
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[N]Object is a light: " ' message
 If ObjectRecord.LightRoom=False Then ' verify object
    Outpt=Outpt+"No" ' add to message
 Else ' verify
    Outpt=Outpt+"Yes, Light Time: " ' message
    If ObjectRecord.LightTime=False Then ' verify object
       Outpt=Outpt+"<any>" ' message
    Else ' verify
       Outpt=Outpt+"From:"+Right$(Str$(ObjectRecord.FromHour+100),2)+":"+_
       Right$(Str$(ObjectRecord.FromMin+100),2)+" to "+_
       Right$(Str$(ObjectRecord.ToHour+100),2)+":"+_
       Right$(Str$(ObjectRecord.ToMin+100),2) ' message
    Endif ' end verify
 Endif ' end verify
 Call IO.O ' send output message
End Sub ' end routine

 Rem * This routines displays information on the room file.
 Rem * input variables:
 Rem *   Number - the room file record.

Sub Display.Room.Desc(Number)
 On Local Error Resume Next ' local error resume
 Graphics.Off=False ' reset color
 Outpt="Room number"+Str$(Number)+": Action"+Str$(RoomRecord.Action)+_
 ": Monster class:"+Str$(RoomRecord.MonsterClass)+"." ' make room message
 Call IO.O ' send output message
 Outpt="Short description:" ' message
 Call IO.O ' send output message
 Graphics.Off=True ' reset color
 Outpt=Rtrim$(RoomRecord.ShortDesc) ' message
 If Instr(Outpt,Chr$(0)) Then ' find any null characters from old structures
    Outpt=Left$(Outpt,Instr(Outpt,Chr$(0))-1) ' truncate off nulls
 Endif ' end find old nulls
 Call IO.O ' send output message
 Graphics.Off=False ' reset color
 Outpt="Long description:" ' message
 Call IO.O ' send output message
 Graphics.Off=True ' reset color
 For Array.Number=1 To 4 ' loop through all four long room description lines
    Outpt=RoomRecord.LongDesc(Array.Number) ' get next room description line
    Outpt=Rtrim$(Outpt) ' trim room description line
    If Instr(Outpt,Chr$(0)) Then ' find any nul characters from old files
       Outpt=Left$(Outpt,Instr(Outpt,Chr$(0))-1) ' truncate off nulls
    Endif ' end find old nulls
    If Outpt=Nul Then ' check if long description ends
       Exit For ' exit long description display loop
    Endif ' end check description end
    Call IO.O ' send output message
 Next ' end long room description loop
End Sub ' end routine

 Rem * This routines displays information on the spell file.
 Rem * input variables:
 Rem *   Number - the spell file record.

Sub Display.Spell(Number)
 On Local Error Resume Next ' local error resume
 Graphics.Off=False ' reset color
 Outpt="Spell number"+Str$(Number)+":" ' spell number message
 Call IO.O ' send output message
 Graphics.Off=True ' reset color
 Outpt="[A]Spell name: "+Rtrim$(SpellRecord.SpellName) ' message
 Call IO.O ' send output message
 Outpt="[B]Spell chant:" ' message
 Call IO.O ' send output message
 Outpt=Lcase$(Rtrim$(SpellRecord.Chant)) ' message
 Call IO.O ' send output message
 Outpt="[C]Spell cast description:" ' message
 Call IO.O ' send output message
 Outpt=Rtrim$(SpellRecord.Desc)
 Call IO.O ' send output message
 Outpt="[D]Spell level:"+Str$(SpellRecord.Level) ' message
 Call IO.O ' send output message
 Outpt="[E]" ' set to option
 Select Case SpellRecord.SpellType ' selection of spell type
 Case Enchant
    Inpt="Enchant" ' message
 Case Offense
    Inpt="Offense" ' message
 Case Bless
    Inpt="Bless" ' message
 Case Wish
    Inpt="Wish" ' message
 Case Poison
    Inpt="Poison" ' message
 Case Vigor
    Inpt="Vigor" ' message
 Case Heal
    Inpt="Heal" ' message
 Case CurePoison
    Inpt="Curepoison" ' message
 Case LevelDrain
    Inpt="Level Drain" ' message
 Case Teleport
    Inpt="Teleport to Room"+Str$(SpellRecord.Teleport)
 Case Befuddled
    Inpt="Befuddle" ' message
 Case TurnUndead
    Inpt="Turn Undead" ' message
 Case PassDoor
    Inpt="Pass Door" ' message
 Case Conjure
    Inpt="Conjure" ' message
 Case Psionic
    Inpt="Psionic" ' message
 Case DetectLock
    Inpt="Detect Lock" ' message
 Case DetectEvil
    Inpt="Detect Evil" ' message
 Case DetectTrap
    Inpt="Detect Trap" ' message
 Case Intoxicate
    Inpt="Intoxicate" ' message
 Case SetTrap
    Inpt="Set Trap" ' message
 Case Hiding
    Inpt="Hide" ' message
 Case Search
    Inpt="Search" ' message
 Case Invisibility
    Inpt="Invisibility" ' message
 Case Identify
    Inpt="Identify" ' message
 Case Enlighten
    Inpt="Enlighten" ' message
 Case Illuminate
    Inpt="Illuminate" ' message
 Case Psyche
    Inpt="Psyche" ' message
 Case Telepathy
    Inpt="Telepathy" ' message
 Case Else ' other
    Inpt="<none>" ' message
 End Select ' end selection of spell type
 Outpt=Outpt+"Spell type: "+Inpt ' message
 Call IO.O ' send output message
 Outpt="[F]Spell is psionic: " ' message
 If SpellRecord.Psionic=False Then ' verify spell
    Outpt=Outpt+"No" ' add to message
 Else ' verify
    Outpt=Outpt+"Yes, " ' message
    Select Case SpellRecord.PsionicMode ' selection of spell psionic type
    Case PsiAttack
       Outpt=Outpt+"Attack" ' message
    Case PsiDefense
       Outpt=Outpt+"Defense" ' message
    Case Else ' other
       Outpt=Outpt+"<none>" ' message
    End Select ' end selection of spell type
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[G]Characters which can cast spell:" ' message
 Call IO.O ' send output message
 Spell.Cast=False ' set spell cast found flag
 For Class.Number=1 To 8 ' loop through spell cast flags
    If SpellRecord.ClassType And 2^Class.Number Then ' compare spell cast flag
       Class.Type$=Class.Name(Class.Number) ' store class name
       Class.Type$=Rtrim$(Class.Type$) ' trim name
       ' uppercase first word
       Mid$(Class.Type$,1,1)=Ucase$(Mid$(Class.Type$,1,1))
       Outpt=Outpt+Class.Type$+", " ' append to output string
       Spell.Cast=True ' set spell cast found flag
    Endif ' end compare spell cast flags
 Next ' end loop through spell cast flags
 If Spell.Cast Then ' check spell cast found flag
    Outpt=Left$(Outpt,Len(Outpt)-2)+"." ' message
 Else ' check spell flag
    Outpt="<none>" ' message
 Endif ' end check spell cast found flag
 Call IO.O ' send output message
 Outpt="[H]Spell ingredients:" ' message
 Call IO.O ' send output message
 Spell.Ingredient=False ' set spell ingredient found flag
 For Array.Number=1 To 5 ' loop through spell ingerdients
    ' get spell ingredient number
    Treasure.Number=SpellRecord.Ingred(Array.Number)
    If Treasure.Number>False And_
    Treasure.Number<=Lof(6)/Len(TreasureRecord) Then ' file bounds
       Get 6,Treasure.Number,TreasureRecord ' get treasure record
       Ingredient.Name$=TreasureRecord.TreasureName ' store treasure name
       Ingredient.Name$=Rtrim$(Ingredient.Name$) ' trim name
       Ingredient.Name$=Lcase$(Ingredient.Name$) ' lowercase name
       ' uppercase first word
       Mid$(Ingredient.Name$,1,1)=Ucase$(Mid$(Ingredient.Name$,1,1))
       Outpt=Outpt+Ingredient.Name$+", " ' message
       Spell.Ingredient=True ' set spell ingredient found flag
    Endif ' end check file bounds
 Next ' end loop through spell ingredients
 If Spell.Ingredient Then ' check spell ingredient found flag
    Outpt=Left$(Outpt,Len(Outpt)-2)+"." ' message
 Else ' check spell ingredient
    Outpt="<none>" ' message
 Endif ' end check spell ingredient found flag
 Call IO.O ' send output message
 Outpt="[I]Spell casting type which requires ingredients:" ' message
 Call IO.O ' send output message
 Spell.Requirement=False ' set ingredient requirement flag
 If SpellRecord.SpellFlag And Use.Spell.Type Then ' verify spell
    Outpt="use command, " ' message
    Spell.Requirement=True ' set ingredient flag
 Endif ' end verify
 If SpellRecord.SpellFlag And Scroll.Spell.Type Then ' verify spell
    Outpt=Outpt+"read scroll, " ' message
    Spell.Requirement=True ' set ingredient flag
 Endif ' end verify
 If SpellRecord.SpellFlag And Cast.Spell.Type Then ' verify spell
    Outpt=Outpt+"cast spell, " ' message
    Spell.Requirement=True ' set ingredient flag
 Endif ' end verify
 If Spell.Requirement Then ' check ingredient flag
    Outpt=Left$(Outpt,Len(Outpt)-2)+"." ' message
 Else ' check flag
    Outpt="<none>" ' message
 Endif ' end check ingredient flag
 Call IO.O ' send output message
End Sub ' end routine

 Rem * This routines displays information on the treasure file.
 Rem * input variables:
 Rem *   Number - the treasure file record.

Sub Display.Treasure(Number)
 On Local Error Resume Next ' local error resume
 Graphics.Off=False ' reset color
 Outpt="Treasure number"+Str$(Number)+":" ' treasure number message
 Call IO.O ' send output message
 Graphics.Off=True ' reset color
 Outpt="[A]Treasure name: "+TreasureRecord.TreasureName ' message
 Outpt=Left$(Outpt,40) ' truncate string
 Outpt=Outpt+Space$(40-Len(Outpt)) ' pad with blanks
    Outpt=Outpt+"[U]Treasure is coins: " ' message
 If TreasureRecord.Coin Then ' verify treasure
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[B]Treasure identifier: "+Lcase$(TreasureRecord.ShortName) ' message
 Outpt=Left$(Outpt,40) ' truncate string
 Outpt=Outpt+Space$(40-Len(Outpt)) ' pad with blanks
    Outpt=Outpt+"[V]Treasure is a potion: " ' message
 If TreasureRecord.Potion Then ' verify treasure
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[C]Weight:"+Str$(TreasureRecord.Weight) ' message
 Outpt=Left$(Outpt,40) ' truncate string
 Outpt=Outpt+Space$(40-Len(Outpt)) ' pad with blanks
    Outpt=Outpt+"[W]Treasure is a scroll: " ' message
 If TreasureRecord.Scroll Then ' verify treasure
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[D]Gold coin value:"+Str$(TreasureRecord.Gold) ' message
 Outpt=Left$(Outpt,40) ' truncate string
 Outpt=Outpt+Space$(40-Len(Outpt)) ' pad with blanks
    Outpt=Outpt+"[X]Treasure is invisible: " ' message
 If TreasureRecord.Invisible Then ' verify treasure
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[E]Treasure type: " ' message
 Select Case TreasureRecord.Type ' selection of treasure type
 Case False ' verify treasure type
    If TreasureRecord.Plus=False Then ' verify weapon type
       Outpt=Outpt+"Treasure" ' message
    Else ' verify type
       Outpt=Outpt+"Weapon" ' message
    Endif ' end verify treasure type
 Case Is<False ' verify shield type
    Outpt=Outpt+"Shield" ' message
 Case Is>False ' verify armor type
    Outpt=Outpt+"Armor" ' message
 End Select ' end selection of treasure type
 Outpt=Left$(Outpt,40) ' truncate string
 Outpt=Outpt+Space$(40-Len(Outpt)) ' pad with blanks
    Outpt=Outpt+"[Y]Treasure is a container: " ' message
 If TreasureRecord.Container Then ' verify treasure
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[F]Hit plus:"+Str$(Abs(TreasureRecord.Plus)) ' message
 Outpt=Left$(Outpt,40) ' truncate string
 Outpt=Outpt+Space$(40-Len(Outpt)) ' pad with blanks
    Outpt=Outpt+"[Z]Container is locked: " ' message
 If TreasureRecord.Locked=1 And TreasureRecord.Closed=1 Then ' verify treasure
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[G]Charges:"+Str$(TreasureRecord.Charges) ' message
 Outpt=Left$(Outpt,40) ' truncate string
 Outpt=Outpt+Space$(40-Len(Outpt)) ' pad with blanks
    Outpt=Outpt+"[1]Treasure key number:"+Str$(TreasureRecord.Keyed) ' message
 Call IO.O ' send output message
 Outpt="[H]Weapon class: " ' message
 ' selection of treasure proficiency type
 Select Case TreasureRecord.Proficiency
 Case Blunt
    Outpt=Outpt+"Blunt" ' message
 Case Pole
    Outpt=Outpt+"Pole" ' message
 Case Sharp
    Outpt=Outpt+"Sharp" ' message
 Case Thrusting
    Outpt=Outpt+"Thrusting" ' message
 Case Else ' other
    Outpt=Outpt+"None" ' message
 End Select ' end selection of weapon proficiency type
 Outpt=Left$(Outpt,40) ' truncate string
 Outpt=Outpt+Space$(40-Len(Outpt)) ' pad with blanks
    Outpt=Outpt+"[2]Treasure is fuel: " ' message
 If TreasureRecord.FuelType=False Then ' verify treasure
    Outpt=Outpt+"No" ' add to message
 Else ' verify
    Outpt=Outpt+"Yes:"+Str$(TreasureRecord.FuelCharges)+" charges" ' message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[I]Treasure is permanent: " ' message
 If TreasureRecord.Permanent Then ' verify treasure
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Outpt=Left$(Outpt,40) ' truncate string
 Outpt=Outpt+Space$(40-Len(Outpt)) ' pad with blanks
    Outpt=Outpt+"[3]Weapon rusts: " ' message
 If TreasureRecord.Rustable Then ' verify treasure
    Outpt=Outpt+"Yes:"+Str$(TreasureRecord.RustPercent)+"%"
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[J]Treasure is edible: " ' message
 If TreasureRecord.Edible Then ' verify treasure
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Outpt=Left$(Outpt,40) ' truncate string
 Outpt=Outpt+Space$(40-Len(Outpt)) ' pad with blanks
    Outpt=Outpt+"[4]Weapon is stealable: " ' message
 If TreasureRecord.Stealable Then ' verify treasure
    Outpt=Outpt+"Yes:"+Str$(TreasureRecord.StealPercent)+"%"
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[K]Treasure is magical: " ' message
 Spell.Number=TreasureRecord.Spell ' store spell number
 If Spell.Number=False Then ' verify treasure
    Outpt=Outpt+"No" ' add to message
 Else ' verify
    ' file bounds
    If Spell.Number>False And Spell.Number<=Lof(9)/Len(SpellRecord) Then
       Get 9,Spell.Number,SpellRecord ' get spell record
       Outpt=Outpt+"Yes, "+Rtrim$(SpellRecord.SpellName)+" spell" ' message
    Endif ' end check file bounds
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[L]Treasure is a ring: " ' message
 Select Case TreasureRecord.RingType
 Case 1
    Outpt=Outpt+"protection from poison" ' message
 Case 2
    Outpt=Outpt+"protection from level drain" ' message
 Case 3
    Outpt=Outpt+"protection from spell: " ' message
    Spell.Number=TreasureRecord.RingSpell ' store ring spell number
    If Spell.Number=True Then ' verify treasure
       Outpt=Outpt+"generic spell" ' message
    Else ' verify
       ' file bounds
       If Spell.Number>False And Spell.Number<=Lof(9)/Len(SpellRecord) Then
          Get 9,Spell.Number,SpellRecord ' get spell record
          Outpt=Outpt+Rtrim$(Lcase$(SpellRecord.SpellName))+" spell" ' message
       Endif ' end check file bounds
    Endif ' end verify
 Case Else ' verify
    Outpt=Outpt+"No" ' add to message
 End Select
 Call IO.O ' send output message
 Outpt="[M]Treasure is a light: " ' message
 If TreasureRecord.LightType=False Then ' verify treasure
    Outpt=Outpt+"No" ' add to message
 Else ' verify
    Outpt=Outpt+"Yes, Charges:"+Str$(TreasureRecord.LightCharges) ' message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[N]Treasure is a vehicle: " ' message
 If TreasureRecord.Vehicle=False Then ' verify treasure
    Outpt=Outpt+"No" ' add to message
 Else ' verify
    Outpt=Outpt+"Yes, hits:"+Str$(TreasureRecord.VehicleHits) ' message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[O]Treasure loads from devices: " ' message
 If TreasureRecord.Ammunition Then ' verify treasure
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[P]Treasure is loadable: " ' message
 If TreasureRecord.Loadable Then ' verify treasure
    Outpt=Outpt+"Yes: Loads(" ' add to message
    ' store ammunition treasure number
    Treasure.Number=TreasureRecord.AmmoLoads
    If Treasure.Number>False And_
    Treasure.Number<=Lof(6)/Len(TreasureRecord) Then ' file bounds
       Call Share.Record(6,Number) ' store current treasure record
       Get 6,Treasure.Number,TreasureRecord ' get treasure record
       Outpt=Outpt+Rtrim$(TreasureRecord.TreasureName)+")" ' message
       Get 6,Number,TreasureRecord ' restore treasure record
    Else ' check file bounds
       Outpt=Outpt+"<none>)" ' append message
    Endif ' end check file bounds
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[R]Treasure launchs from devices: " ' message
 If TreasureRecord.LaunchAmmo Then ' verify treasure
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[S]Treasure is launchable: " ' message
 If TreasureRecord.Launchable Then ' verify treasure
    Outpt=Outpt+"Yes: Launchs(" ' add to message
    ' store ammunition treasure number
    Treasure.Number=TreasureRecord.LaunchLoads
    If Treasure.Number>False And_
    Treasure.Number<=Lof(6)/Len(TreasureRecord) Then ' file bounds
       Call Share.Record(6,Number) ' store current treasure record
       Get 6,Treasure.Number,TreasureRecord ' get treasure record
       Outpt=Outpt+Rtrim$(TreasureRecord.TreasureName)+")" ' message
       Get 6,Number,TreasureRecord ' restore treasure record
    Else ' check file bounds
       Outpt=Outpt+"<none>)" ' append message
    Endif ' end check file bounds
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[T]Launchable device can be moved: " ' message
 If TreasureRecord.Movable Then ' verify treasure
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
End Sub ' end routine

 Rem * This routines displays information on the user file.
 Rem * input variables:
 Rem *   Number - the user file record.

Sub Display.User(Number)
 On Local Error Resume Next ' local error resume
 Graphics.Off=False ' reset color
 Outpt="User number"+Str$(Number)+"." ' user number message
 Call IO.O ' send output message
 Graphics.Off=True ' reset color
 Inpt=UserRecord.CodeName ' store player codename
 Call Decrypt(Inpt) ' decrypt codename
 Inpt=Rtrim$(Inpt) ' trim codename
 Inpt=Lcase$(Inpt) ' lowercase codename
 Mid$(Inpt,1,1)=Ucase$(Mid$(Inpt,1,1)) ' uppercase first word
 Outpt="[A]Codename: "+Inpt+" " ' message
 Inpt=String$(10,"#") ' mask passwword
 If Local.Mode Then ' check console
    Inpt=UserRecord.PassWord ' store password
    Call Decrypt(Inpt) ' decrypt password
    Inpt=Rtrim$(Inpt) ' trim password
    Inpt=Lcase$(Inpt) ' lowercase password
 Endif ' end check
 Outpt=Outpt+"[B]Password: "+Inpt ' message
 Call IO.O ' send output message
 Outpt="[C]Level:"+Str$(UserRecord.Level) ' message
 Call IO.O ' send output message
 Outpt="[D]" ' set to option
 Class.Number=UserRecord.ClassType ' store player class type
 Select Case Class.Number ' selection of class type
 Case 1 To 10 ' check class type
    Class.Type$=Class.Name(Class.Number) ' store class name
 Case Else ' check
    Class.Type$=Class.Name(1) ' default class name
 End Select ' end selection of class type
 Outpt=Outpt+"Class: "+Rtrim$(Class.Type$) ' message
 Call IO.O ' send output message
 Outpt="[E]" ' set to option
 Weapon.Number=UserRecord.Proficiency ' store player proficiency number
 Select Case Weapon.Number ' selection of proficiency
 Case 1 To 4 ' check type
    Weapon.Type$=Weapon.Type.Name(Weapon.Number) ' store proficiency name
 Case Else ' check
    Weapon.Type$=Weapon.Type.Name(1) ' default name
 End Select ' end seelction of proficiency
 Outpt=Outpt+"Weapon proficiency: "+Rtrim$(Weapon.Type$) ' message
 Call IO.O ' send output message
 Outpt="[F]Blunt%:"+Str$(UserRecord.Weapons(1))+" " ' message
 Outpt=Outpt+"[G]Pole%:"+Str$(UserRecord.Weapons(2)) ' message
 Call IO.O ' send output message
 Outpt="[H]Sharp%:"+Str$(UserRecord.Weapons(3))+" " ' message
 Outpt=Outpt+"[I]Thrusting%:"+Str$(UserRecord.Weapons(4)) ' message
 Call IO.O ' send output message
 Outpt="[J]Classname: " ' message
 Inpt=UserRecord.ClassName
 Call Decrypt(Inpt)
 Inpt=Rtrim$(Inpt)
 Outpt=Outpt+Inpt
 Call IO.O ' send output message
 Outpt="[K]Strength:"+Str$(UserRecord.Stats(1)) ' message
 Call IO.O ' send output message
 Outpt="[L]Intelligence:"+Str$(UserRecord.Stats(2)) ' message
 Call IO.O ' send output message
 Outpt="[M]Wisdom:"+Str$(UserRecord.Stats(3)) ' message
 Call IO.O ' send output message
 Outpt="[N]Dexterity:"+Str$(UserRecord.Stats(4)) ' message
 Call IO.O ' send output message
 Outpt="[O]Constitution:"+Str$(UserRecord.Stats(5)) ' message
 Call IO.O ' send output message
 Outpt="[P]Piety:"+Str$(UserRecord.Stats(6)) ' message
 Call IO.O ' send output message
 Outpt="[R]Charisma:"+Str$(UserRecord.Stats(7)) ' message
 Call IO.O ' send output message
 Outpt="[S]Experience:"+Str$(UserRecord.Experience) ' message
 Call IO.O ' send output message
 Outpt="[T]Gold:"+Str$(UserRecord.Gold) ' message
 Call IO.O ' send output message
 Outpt="[U]Room number:"+Str$(UserRecord.Room) ' message
 Call IO.O ' send output message
 Outpt="[V]Call restrictions." ' message
 Call IO.O ' send output message
 Outpt="[W]Inventory." ' message
 Call IO.O ' send output message
 Outpt="[X]Special characters: " ' message
 Special.Flag=False
 If UserRecord.Flags And Special.Char1 Then ' verify user
    Outpt=Outpt+"Town Mayor, " ' message
    Special.Flag=True
 Endif ' end verify
 If UserRecord.Flags And Special.Char2 Then ' verify user
    Outpt=Outpt+"Governor, " ' message
    Special.Flag=True
 Endif ' end verify
 If UserRecord.Flags And Special.Char3 Then ' verify user
    Outpt=Outpt+"Guild Master, " ' message
    Special.Flag=True
 Endif ' end verify
 If UserRecord.Flags And Special.Char4 Then ' verify user
    Outpt=Outpt+"Sysop, " ' message
    Special.Flag=True
 Endif ' end verify
 If Special.Flag Then ' verify user
    Outpt=Left$(Outpt,Len(Outpt)-2)+"." ' message
 Else ' verify
    Outpt=Outpt+"None." ' message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[!]Delete user" ' message
 Call IO.O ' send output message
 Graphics.Off=False ' reset color
End Sub ' end routine

 Rem * routine used by the editor to find monster file number
 Rem * of a monster name.
 Rem * output variables:
 Rem *   Number - record number of monster.
 Rem * processing variables:
 Rem *   Inpt - monster name or number to search for.
 Rem *   Parsed.Value - monster number increment.

Sub Find.Monster(Number)
 On Local Error Resume Next ' local error resume
 Outpt="Monster name, or number" ' input prompt
 Outpt=Outpt+"(1-"+Mid$(Str$(Lof(5)/Len(MonsterRecord)),2)+")? " ' prompt
 Call IO.I ' get input
 If Inpt=Nul Then ' compare input length
    Number=False ' reset number found
    Exit Sub ' exit routine
 Endif ' end compare length
 Call Parse.Num(Inpt,Parsed.Value) ' parse number
 Number.Count=False ' reset monster found counter
 For Number=1 To Lof(5)/Len(MonsterRecord) ' loop through monster file
    Get 5,Number,MonsterRecord ' get monster record
    ' compare monster record name to input monster name,
    ' truncated to input length
    If Left$(MonsterRecord.MonsterName,Len(Inpt))=Inpt Then ' compare
       Number.Count=Number.Count+1 ' increment monster found counter
       ' compare parsed number of monster to search for
       If Parsed.Value=False Or Number.Count=Parsed.Value Then ' compare
          Exit Sub ' exit routine
       Endif ' end compare counters
    Endif ' end compare monster names
 Next ' end loop through monster file
 Number=Int(Val(Inpt)) ' convert input to integer
 If Number<=False Or Number>Lof(5)/Len(MonsterRecord) Then ' file bounds
    Outpt=Range$ ' make error message
    Call IO.O ' send error message
    Number=False ' reset monster found
 Else ' end check file bounds
    Get 5,Number,MonsterRecord ' get monster record number
 Endif ' end check file bounds
End Sub ' end routine

 Rem * routine used by the editor to find nonplayer file number
 Rem * of a nonplayer name.
 Rem * output variables:
 Rem *   Number - record number of nonplayer.
 Rem * processing variables:
 Rem *   Inpt - nonplayer name or number to search for.
 Rem *   Parsed.Value - nonplayer number increment.

Sub Find.Nonplayer(Number)
 On Local Error Resume Next ' local error resume
 Outpt="Nonplayer name, or number" ' input prompt
 Outpt=Outpt+"(1-"+Mid$(Str$(Lof(2)/Len(MonsterRecord)),2)+")? " ' prompt
 Call IO.I ' get input
 If Inpt=Nul Then ' compare input length
    Number=False ' reset number found
    Exit Sub ' exit routine
 Endif ' end compare length
 Call Parse.Num(Inpt,Parsed.Value) ' parse number
 Number.Count=False ' reset nonplayer counter
 For Number=1 To Lof(2)/Len(MonsterRecord) ' loop through nonplayer file
    Get 2,Number,MonsterRecord ' get nonplayer record
    ' compare nonplayer record name to input nonplayer name,
    ' truncated to input length
    If Left$(MonsterRecord.MonsterName,Len(Inpt))=Inpt Then ' compare
       Number.Count=Number.Count+1 ' increment nonplayer found counter
       ' compare parsed number of object to search for
       If Parsed.Value=False Or Number.Count=Parsed.Value Then ' compare
          Exit Sub ' exit routine
       Endif ' end compare counters
    Endif ' end compare nonplayer names
 Next ' end loop through nonplayer file
 Number=Int(Val(Inpt)) ' convert input to integer
 If Number<=False Or Number>Lof(2)/Len(MonsterRecord) Then ' file bounds
    Outpt=Range$ ' make error message
    Call IO.O ' send error message
    Number=False ' reset nonplayer found
 Else ' end check file bounds
    Get 2,Number,MonsterRecord ' get nonplayer record number
 Endif ' end check file bounds
End Sub ' end routine

 Rem * routine used by the editor to find the object file number
 Rem * of an object name.
 Rem * output variables:
 Rem *   Number - record number of object.
 Rem * processing variables:
 Rem *   Inpt - object name or number to search for.
 Rem *   Parsed.Value - object number increment.

Sub Find.Objects(Number)
 On Local Error Resume Next ' local error resume
 Outpt="Object name, or number" ' make input prompt
 Outpt=Outpt+"(1-"+Mid$(Str$(Lof(4)/Len(ObjectRecord)),2)+")? " ' prompt
 Call IO.I ' get input
 If Inpt=Nul Then ' compare input length
    Number=False ' reset number found
    Exit Sub ' exit routine
 Endif ' end compare length
 Call Parse.Num(Inpt,Parsed.Value) ' get parsed number
 Number.Count=False ' reset spell found counter
 For Number=1 To Lof(4)/Len(ObjectRecord) ' loop through object file
    Get 4,Number,ObjectRecord ' get object record
    ' compare object record name to input object name,
    ' truncated to input length
    If Left$(ObjectRecord.ObjectName,Len(Inpt))=Inpt Then ' compare
       Number.Count=Number.Count+1 ' increment object counter
       ' compare parsed number of object to search for
       If Parsed.Value=False Or Number.Count=Parsed.Value Then ' compare
          Exit Sub ' exit routine
       Endif ' end compare counters
    Endif ' end compare object names
 Next ' end loop through object file
 Number=Int(Val(Inpt)) ' convert input to integer
 If Number<=False Or Number>Lof(4)/Len(ObjectRecord) Then ' file bounds
    Outpt=Range$ ' make error message
    Call IO.O ' send error message
    Number=False ' reset object number to zero
 Else ' end check file bounds
    Get 4,Number,ObjectRecord ' get object record number
 Endif ' end check file bounds
End Sub ' end routine

 Rem * routine used by the editor to find the spell file number
 Rem * of a spell name.
 Rem * output variables:
 Rem *   Number - record number of spell.
 Rem * processing variables:
 Rem *   Inpt - spell name or number to search for.
 Rem *   Parsed.Value - spell number increment.

Sub Find.Spell(Number)
 On Local Error Resume Next ' local error resume
 Outpt="Spell name, or number" ' input prompt
 Outpt=Outpt+"(1-"+Mid$(Str$(Lof(9)/Len(SpellRecord)),2)+")? " ' prompt
 Call IO.I ' get input
 If Inpt=Nul Then ' check length of input
    Number=False ' reset number found
    Exit Sub ' exit routine
 Endif ' end check length
 Call Parse.Num(Inpt,Parsed.Value) ' parse out number
 Number.Count=False ' reset spell found counter
 For Number=1 To Lof(9)/Len(SpellRecord) ' loop through spell file
    Get 9,Number,SpellRecord ' get spell record
    ' compare spell record name to input spell name, truncated to input length
    If Left$(SpellRecord.SpellName,Len(Inpt))=Inpt Then ' compare
       Number.Count=Number.Count+1 ' increment spell found
       ' compare parsed number of spell to search for
       If Parsed.Value=False Or Number.Count=Parsed.Value Then ' compare
          Exit Sub ' exit routine
       Endif ' end compare counters
    Endif ' end compare spell names
 Next ' end loop through spell file
 Number=Int(Val(Inpt)) ' convert input to integer
 If Number<=False Or Number>Lof(9)/Len(SpellRecord) Then ' compare file bounds
    Outpt=Range$ ' make error message
    Call IO.O ' send error message
    Number=False ' reset return spell number to zero
 Else ' end compare spell number
    Get 9,Number,SpellRecord ' get spell record number
 Endif ' end check file bounds
End Sub ' end routine

 Rem * routine used by the editor to find the treasure file number
 Rem * of a treasure name.
 Rem * output variables:
 Rem *   Number - record number of spell.
 Rem * processing variables:
 Rem *   Inpt - spell name or number to search for.
 Rem *   Parsed.Value - spell number increment.

Sub Find.Treasure(Number)
 On Local Error Resume Next ' local error resume
 Outpt="Treasure name, or number" ' input prompt
 Outpt=Outpt+"(1-"+Mid$(Str$(Lof(6)/Len(TreasureRecord)),2)+")? " ' prompt
 Call IO.I ' get input
 If Inpt=Nul Then ' compare input length
    Number=False ' reset number found
    Exit Sub ' exit routine
 Endif ' end compare length
 Call Parse.Num(Inpt,Parsed.Value) ' parse number
 Number.Count=False ' reset treasure found counter
 For Number=1 To Lof(6)/Len(TreasureRecord) ' loop through treasure file
    Get 6,Number,TreasureRecord ' get treasure record
    ' compare treasure record name to input treasure name,
    ' truncated to input length
    If Left$(TreasureRecord.TreasureName,Len(Inpt))=Inpt Then ' compare
       Number.Count=Number.Count+1 ' increment treasure found counter
       ' compare parsed number of treasure to search for
       If Parsed.Value=False Or Number.Count=Parsed.Value Then ' compare
          Exit Sub ' exit routine
       Endif ' end compare counters
    Endif ' end compare treasure names
 Next ' end loop through treasure file
 Number=Int(Val(Inpt)) ' convert input to integer
 If Number<=False Or Number>Lof(6)/Len(TreasureRecord) Then ' file bounds
    Outpt=Range$ ' make error message
    Call IO.O ' send error message
    Number=False ' reset treasure found
 Else ' end check file bounds
    Get 6,Number,TreasureRecord ' get treasure record number
 Endif ' end check file bounds
End Sub ' end routine

 Rem * routine to parse out number after pound sign in a string
 Rem * input variables:
 Rem *   Parsed.Input$ - string to check.
 Rem * output variables:
 Rem *   Parsed.Input$ - string truncated before pound sign, lowercased.
 Rem *   Parsed.Value - number parsed after pound sign.
 Rem * work variables:
 Rem *   Parsed.Token - contains position of # sign.

Sub Parse.Num(Parsed.Input$,Parsed.Value)
 On Local Error Resume Next ' local error resume
 Parsed.Input$=Lcase$(Parsed.Input$) ' lowercase string
 Parsed.Value=False ' set return variable
 Parsed.Token=Instr(Parsed.Input$,"#") ' search string for pound sign
 If Parsed.Token>False Then ' check string search
    ' set return variable
    Parsed.Value=Int(Val(Mid$(Parsed.Input$,Parsed.Token+1)))
    Parsed.Input$=Left$(Parsed.Input$,Parsed.Token-1) ' truncate string
 Endif ' end check string
End Sub ' end routine

 Rem * routine to search player and room containers for parameter name
 Rem * input variables:
 Rem *   Parsed.Command1 - name of container.
 Rem * output variables:
 Rem *   Index.Number - true if container name found.
 Rem *   Type.Number - 0 for container in inventory, 1 for container in room.

Sub Examine.Container
 On Local Error Resume Next ' local error resume
 Type.Number=False ' store container flag
 Call Check.Inventory.Container ' search player inventory containers
 If Index.Number=False Then ' check player container found
    Call Num ' decrement counters
    Type.Number=1 ' store container flag
    Call Check.Room.Container ' search room inventory containers
 Endif ' end check player container found
End Sub ' end routine to search inventory for container name

 Rem * routine to search player and room treasure for parameter name
 Rem * input variables:
 Rem *   Parsed.Command1 - name of treasure.
 Rem * output variables:
 Rem *   Charges.Number - charges of treasure.
 Rem *   Index.Number - index of treasure to file.
 Rem *   Type.Number - 0 for treasure in inventory, 1 for treasure in room.

Sub Examine.Treasure
 On Local Error Resume Next ' local error resume
 Type.Number=False ' store treasure flag
 Call Check.Inventory.Treasure ' routine to search player inventory treasure
 If Index.Number=False Then ' check player treasure found
    Call Num ' decrement counters
    Type.Number=1 ' store treasure flag
    Call Check.Room.Treasure ' routine to search room inventory treasure
 Endif ' end check player treasure found
End Sub ' end routine to search inventory treasure for treasure name

 Rem * routine to search player and room objects for parameter name
 Rem * input variables:
 Rem *   Parsed.Command1 - name of object.
 Rem * output variables:
 Rem *   Charges.Number - charges of object.
 Rem *   Index.Number - index of object to file.
 Rem *   Type.Number - 0 for object in inventory, 1 for object in room.

Sub Examine.Objects
 On Local Error Resume Next ' local error resume
 Type.Number=False ' store object flag
 Call Check.Inventory.Objects ' routine to search player inventory objects
 If Index.Number=False Then ' check player inventory object found
    Call Num ' decrement counters
    Type.Number=1 ' store object flag
    Call Check.Room.Objects ' routine to search room inventory objects
 Endif ' end check player inventory object found
End Sub ' end routine to search inventory objects for object name

 Rem * routine to search player inventory for treasure name
 Rem * input variables:
 Rem *   Parsed.Command2 - contains command parameter.
 Rem * output variables:
 Rem *   Charges.Number - treasure charges.
 Rem *   Index.Number - treasure index to file.

Sub Find.Inventory
 On Local Error Resume Next ' local error resume
 Call Parse ' parse command parameter
 If Parser Then ' check for parsed command
    Call Numeric ' store # sign counter
 Endif ' end check parsed command
 Call Check.Inventory.Treasure ' routine to search player treasure inventory
End Sub ' end routine to search player treasure inventory

 Rem * routine to search player inventory for object name
 Rem * input variables:
 Rem *   Parsed.Command2 - contains command parameter.
 Rem * output variables:
 Rem *   Charges.Number - object charges.
 Rem *   Index.Number - object index to file.

Sub Find.Object
 On Local Error Resume Next ' local error resume
 Call Parse ' parse command parameter
 If Parser Then ' check for parsed command
    Call Numeric ' store # sign counter
 Endif ' end check parsed command
 Call Check.Inventory.Objects ' routine to search player object inventory
End Sub ' end routine to search player object inventory

 Rem * routine searches for treasure name in room treasure inventory
 Rem * input variables:
 Rem *   Parsed.Command1 - name of treasure to search for.
 Rem *   Parse.Number - number increment of treasure.
 Rem * output variables:
 Rem *   Charges.Number - treasure charges.
 Rem *   Index.Number - treasure file index.
 Rem *   Outpts - treasure name.
 Rem * processing variables:
 Rem *   Parse.Count - counter of treasure found in search.

Sub Check.Room.Treasure
 On Local Error Resume Next ' local error resume
 Charges.Number=False ' reset treasure charges
 Index.Number=False ' reset treasure index
 Parse.Count=False ' reset treasure counter
 If Parsed.Command1<>Nul Then ' compare search string length
    For Array.Number=1 To 10 ' loop through room inventory
       If RoomRecord.Treasure(Array.Number) Then ' check room inventory index
          ' get treasure record
          Get 6,RoomRecord.Treasure(Array.Number),TreasureRecord
          Outpts=TreasureRecord.ShortName ' store treasure name
          ' trim length of treasure name to length of search string
          Outpts=Left$(Outpts,Len(Parsed.Command1)) ' trim
          ' compare treasure name to search name
          If Outpts=Parsed.Command1 Then
             Parse.Count=Parse.Count+1 ' increment counter
             ' check increment counter not specified,
             ' or counter equals increment counter.
             If Parse.Number=False Or Parse.Count=Parse.Number Then
                Outpts=TreasureRecord.TreasureName ' get treasure name
                Outpts=Rtrim$(Outpts) ' trim name
                ' store treasure index
                Index.Number=RoomRecord.Treasure(Array.Number)
                ' store treasure charges
                Charges.Number=RoomRecord.TreCharges(Array.Number)
                Exit For ' exit loop through room treasure inventory
             Endif ' end check counters equal
          Endif ' end compare treasure names
       Endif ' end check room inventory index
    Next ' end loop through room treasure inventory
 Endif ' end compare search string length
End Sub ' end room treasure inventory search

 Rem * routine searches for object name in room object inventory
 Rem * input variables:
 Rem *   Parsed.Command1 - name of object to search for.
 Rem *   Parse.Number - number increment of object.
 Rem * output variables:
 Rem *   Charges.Number - object charges.
 Rem *   Index.Number - object file index.
 Rem *   Outpts - object name.
 Rem * processing variables:
 Rem *   Parse.Count - counter of object found in search.

Sub Check.Room.Objects
 On Local Error Resume Next ' local error resume
 Charges.Number=False ' reset object charges
 Index.Number=False ' reset object index
 Parse.Count=False ' reset object counter
 If Parsed.Command1<>Nul Then ' check search string length
    For Array.Number=1 To 10 ' loop through room object inventory
       If RoomRecord.Object(Array.Number) Then ' check room object index
          ' get room object record
          Get 4,RoomRecord.Object(Array.Number),ObjectRecord
          Outpts=ObjectRecord.ShortName ' store room object name
          ' trim length of object name to length of search string
          Outpts=Left$(Outpts,Len(Parsed.Command1)) ' trim
          ' compare object name to search string
          If Outpts=Parsed.Command1 Then
             Parse.Count=Parse.Count+1 ' increment counter
             ' check increment counter not specified,
             ' or counter equals increment counter.
             If Parse.Number=False Or Parse.Count=Parse.Number Then
                Outpts=ObjectRecord.ObjectName ' store object name
                Outpts=Rtrim$(Outpts) ' trim name
                ' store object index
                Index.Number=RoomRecord.Object(Array.Number)
                ' store object charges
                Charges.Number=RoomRecord.ObjCharges(Array.Number)
                Exit For ' exit loop through room object inventory
             Endif ' end check counters
          Endif ' end compare object names
       Endif ' end check room object index
    Next ' end loop through room object inventory
 Endif ' end check search string length
End Sub ' end routine to search room object inventory

 Rem * routine searches for treasure name in player treasure inventory
 Rem * input variables:
 Rem *   Parsed.Command1 - name of treasure to search for.
 Rem *   Parse.Number - number increment of treasure.
 Rem * output variables:
 Rem *   Charges.Number - treasure charges.
 Rem *   Index.Number - treasure file index.
 Rem *   Outpts - treasure name.
 Rem * processing variables:
 Rem *   Parse.Count - counter of treasure found in search.

Sub Check.Inventory.Treasure
 On Local Error Resume Next ' local error resume
 Charges.Number=False ' reset treasure charges
 Index.Number=False ' reset treasure index
 Parse.Count=False ' reset treasure counter
 If Parsed.Command1<>Nul Then ' compare search string length
    For Array.Number=1 To 15 ' loop through player treasure inventory
       If UserRecord.Inv(Array.Number) Then ' check player inventory index
          ' get treasure record
          Get 6,UserRecord.Inv(Array.Number),TreasureRecord
          Outpts=TreasureRecord.ShortName ' store treasure name
          ' trim length of treasure name to length of search string
          Outpts=Left$(Outpts,Len(Parsed.Command1)) ' trim
          ' compare treasure name to search string
          If Outpts=Parsed.Command1 Then
             Parse.Count=Parse.Count+1 ' increment counter
             ' check increment counter not specified,
             ' or counter equals increment counter.
             If Parse.Number=False Or Parse.Count=Parse.Number Then
                Outpts=TreasureRecord.TreasureName ' store treasure name
                Outpts=Rtrim$(Outpts) ' trim name
                ' store treasure index
                Index.Number=UserRecord.Inv(Array.Number)
                ' store treasure charges
                Charges.Number=UserRecord.Charges(Array.Number)
                Exit For ' exit loop through player treasure inventory
             Endif ' end check counters
          Endif ' end compare treasure names
       Endif ' end check player treasure inventory index
    Next ' end loop through player treasure inventory
 Endif ' end check search string length
End Sub ' end routine to search player treasure inventory for treasure name

 Rem * routine searches for object name in player object inventory
 Rem * input variables:
 Rem *   Parsed.Command1 - name of object to search for.
 Rem *   Parse.Number - number increment of object.
 Rem * output variables:
 Rem *   Charges.Number - object charges.
 Rem *   Index.Number - object file index.
 Rem *   Outpts - object name.
 Rem * processing variables:
 Rem *   Parse.Count - counter of object found in search.

Sub Check.Inventory.Objects
 On Local Error Resume Next ' local error resume
 Charges.Number=False ' reset object charges
 Index.Number=False ' reset object index
 Parse.Count=False ' reset counter
 If Parsed.Command1<>Nul Then ' check search strig length
    For Array.Number=1 To 5 ' loop through player object inventory
       If UserRecord.Object(Array.Number) Then ' check player object index
          ' get object record
          Get 4,UserRecord.Object(Array.Number),ObjectRecord
          Outpts=ObjectRecord.ShortName ' store object name
          ' trim length of object name to length of search string
          Outpts=Left$(Outpts,Len(Parsed.Command1)) ' trim
          ' compare object name to search string
          If Outpts=Parsed.Command1 Then
             Parse.Count=Parse.Count+1 ' increment counter
             ' check increment counter not specified,
             ' or counter equals increment counter.
             If Parse.Number=False Or Parse.Count=Parse.Number Then
                Outpts=ObjectRecord.ObjectName ' store objecct name
                Outpts=Rtrim$(Outpts) ' trim name
                ' store object index
                Index.Number=UserRecord.Object(Array.Number)
                ' store object charges
                Charges.Number=UserRecord.ObjCharges(Array.Number)
                Exit For ' exit loop through player object inventory
             Endif ' end check counters
          Endif ' end compare object names
       Endif ' end check player object index
    Next ' end loop through player object inventory
 Endif ' end check search string length
End Sub ' end routine to search player object inventory

 Rem * routine to search for monster name in room monsters
 Rem * input variables:
 Rem *   Parsed.Command1 - name of monster to search for.
 Rem * output variables:
 Rem *   Monster.Number - number of monster array.
 Rem *   Last.Monster - name of monster found.
 Rem * work variables:
 Rem *   Word.Parse1, Word.Parse2.

Sub Check.Monster
 On Local Error Resume Next ' local error resume
 Array.Number=False ' reset monster number loop counter
 Parse.Count=False ' reset increment counter
 Monster.Number=False ' reset monster number
 If Parsed.Command1<>Nul Then ' check search string length
    For Array.Number=1 To Number.Monsters ' loop through all room monsters
       Word.Parse1=False ' reset monster name parse variable
       Word.Parse2=False ' reset monster name parse variable
       Outpts=MonsterArray(Array.Number).MonsterName ' store monster name
       Outpts=Rtrim$(Outpts) ' trim name
       Outpts=Ucase$(Outpts) ' uppercase name
       ' locate first imbedded space in name
       Word.Parse1=Instr(Word.Parse1+1,Outpts," ")
       While Word.Parse1 ' loop until last space in monster name found
          Word.Parse2=Word.Parse1 ' store position of last space
          Word.Parse1=Instr(Word.Parse1+1,Outpts," ") ' locate next space
       Wend ' end loop
       ' monster name is last word of full name
       Inpt=Mid$(Outpts,Word.Parse2+1)
       ' trim length of monster name to length of search string
       Inpt=Left$(Inpt,Len(Parsed.Command1)) ' trim
       If Inpt=Parsed.Command1 Then ' compare monster name to search string
          Parse.Count=Parse.Count+1 ' increment counter
          ' check increment counter not specified,
          ' or counter equals increment counter.
          If Parse.Number=False Or Parse.Count=Parse.Number Then
             ' store monster name
             Outpts=MonsterArray(Array.Number).MonsterName
             Outpts=Rtrim$(Outpts) ' trim name
             Monster.Number=Array.Number ' store monster number
             Last.Monster=Parsed.Command1 ' store monster name
             Exit For ' exit loop through room monsters
          Endif ' end check counters
       Endif ' end compare search strings
    Next ' end loop through room monsters
 Endif ' end check search string length
End Sub ' end routine to search room monsters for monster name

 Rem * routine to search player inventory for container name
 Rem * input variables:
 Rem *   Parsed.Command1 - name of container to search for.
 Rem * output variables:
 Rem *   Array.Number - container number.
 Rem *   Index.Number - true if container found.
 Rem *   Outpts - name of container.
 Rem * processing variables:
 Rem *   Parse.Count - increment counter.
 Rem *   Container.Name$ - container name.

Sub Check.Inventory.Container
 On Local Error Resume Next ' local error resume
 Index.Number=False ' reset container found flag
 Parse.Count=False ' reset counter
 If Parsed.Command1<>Nul Then ' check search string length
    For Array.Number=1 To 3 ' loop through player inventory containers
       ' store container name
       Container.Name$=Rtrim$(UserRecord.Container(Array.Number).ShortName)
       Outpts=Container.Name$ ' store container name
       If Container.Name$<>Nul Then ' check length of container name
          ' trim length of container name to length of search string
          Container.Name$=Left$(Container.Name$,Len(Parsed.Command1)) ' trim
          If Container.Name$=Parsed.Command1 Then ' compare container names
             Parse.Count=Parse.Count+1 ' increment counter
             ' check increment counter not specified,
             ' or counter equals increment counter.
             If Parse.Number=False Or Parse.Count=Parse.Number Then
                Index.Number=True ' set container found flag
                ' store container record
                ContainerRec=UserRecord.Container(Array.Number) ' store
                Exit For ' exit loop through player containers
             Endif ' end check counters
          Endif ' end compare container names
       Endif ' end check container name length
    Next ' end loop through player containers
 Endif ' end check search string length
End Sub ' end routine to search player inventory for container name

 Rem * routine to compare room container to search container name
 Rem * input variables:
 Rem *   Parsed.Command1 - name of container to ccompare.
 Rem * output variables:
 Rem *   Index.Number - room container matched.
 Rem *   Outpts - name of container.
 Rem * processing variables:
 Rem *   Parse.Count - increment counter.
 Rem *   Container.Name$ - container name.

Sub Check.Room.Container
 On Local Error Resume Next ' local error resume
 Index.Number=False ' reset container found flag
 Parse.Count=False ' reset counter
 If Parsed.Command1<>Nul Then ' check search string length
    ' get room container name
    Container.Name$=Rtrim$(RoomRecord.Container.ShortName)
    Outpts=Container.Name$ ' store container name
    If Container.Name$<>Nul Then ' check length of container name
       ' trim length of container name to length of search string
       Container.Name$=Left$(Container.Name$,Len(Parsed.Command1)) ' trim
       If Container.Name$=Parsed.Command1 Then ' compare container names
          Parse.Count=Parse.Count+1
          ' check increment counter not specified,
          ' or counter equals increment counter.
          If Parse.Number=False Or Parse.Count=Parse.Number Then
             Index.Number=True ' set container match flag
             ContainerRec=RoomRecord.Container ' store container record
          Endif ' end check counters
       Endif ' end compare names
    Endif ' end check container name
 Endif ' end check search string length
End Sub

Config.Data:
 Data 12,4,6,3,9,6,10,5,10,3,5,4,9,6,5,4,11,5,6,3,11,4,6,3,10,3,7,3,9,6,8,3,125,125,125,125,250,250,250,250
 Data "Lord","Wizard","Assassin","Bard","Monk","Knight","Priest","Empress","Assistant DM","Dungeon Master"
 Data "Human","Elf","Gnome","Dwarf","Halfling","Half-elf","Half-orc","Ogre"
 Data "Fighter","Magic User","Thief","Cleric","Paladin","Ranger","Druid","Lady","Assistant DM","Dungeon Master"
 Data "Strength","Intelligence","Wisdom","Dexterity","Constitution","Piety","Charisma"
 Data "north","east","south","west","out","up","down","northeast","southeast","southwest","northwest"
 Data "blunt","pole","sharp","thrusting","good","neutral","evil","lawful","neutral","chaotic"
