; This is the screen control file.  The commands in this file will tell
; Labtest what and where to place remarks on the user's screen.
;
; NOTE CHANGES FROM PREVIOUS VERSIONS!  The order of the keywords are no
; longer relevant.  This file is now divided into two sections, ANSI
; DEFINITION and RIP DEFINITION, each controlling how Labtest uses ANSI or
; RIP screens.
;
; ANSI Color codes are now made up of english text color codes for very
; simple customization.
;
;    Color code keywords    Description
;
;    Bright                 Causes the text to be displayed in bright attribute
;    Flashing               Causes the text to blink.
;    Black        Ŀ
;    Blue            
;    Green                 You may add the Bright and Flashing keywords
;    Cyan                  to alter the appearance of these basic colors.
;    Red                White is actually dim white (grey) unless used
;    Magenta               with Bright.  The foreground colors are always
;    Brown                 specified first, followed by the background.
;    Yellow          
;    White (grey) 
;
; Examples:
;
; Bright white on blue               Bright white text with blue background
; Flashing bright white on red       Blinking bright white text with a red
;                                    background
; white red                          dim white (grey) text on a red background
; yellow on green                    yellow text with a green background.
;
; The use of extra words to make the color codes more readable is allowed.
; For example:
;
; Bright white on a blue background
;
; is the same as:
;
; bright white blue
;
; The case of the letters is not significant, and is only shown here
; in upper/lower case for esthetic purposes.
;
;
; The Working_Text will be displayed during the actual processing of
; each phase of Labtest.  It will be displayed in place of the Pass or
; Fail text at the given coordinates for each phase.  The Row and Col
; for Working_Text is ignored, but should be set to 1, not 0.
;
; To disable displaying of an item, set the row and col to 0.
;
; The #Begin Ansi definition marks the beggining of the Ansi Screen Control
; section.

#Begin Ansi definition

; Keyword                 Text      Row   Col   Color
Working_Text                     1      1    Flashing Bright blue on white
File_Name_Display         @         8     28    Bright white on blue
File_Date_Pass                   11     5    Blue on white
File_Date_Fail                   11     5    Flashing bright red on white
HackReport_Pass                  12     5    Blue on white
HackReport_Fail                  12     5    Flashing bright red on white
Jpg/Gif_Test_Pass                13     5    Blue on white
Jpg/Gif_Test_Fail                13     5    Flashing bright red on white
Unpack_Pass                      14     5    Blue on white
Unpack_Fail                      14     5    Flashing bright red on white
FileIdDiz_Pass                   15     5    Blue on white
FileIdDiz_Fail                   15     5    Flashing bright red on white
Imbedded_Files_Pass              16     5    Blue on white
Imbedded_Files_Fail              16     5    Flashing bright red on white
Remove_Unwanted_Pass             11     72   Blue on white
Remove_Unwanted_Fail             11     72   Flashing bright red on white
Add_Files_Pass                   11     72   Blue on white
Add_Files_Fail                   11     72   Flashing bright red on white
Virus_Scan_Pass                  12     72   Blue on white
Virus_Scan_Fail                  12     72   Flashing bright red on white
Repack_Pass                      13     72   Blue on white
Repack_Fail                      13     72   Flashing bright red on white
Add_Comment_Pass                 14     72   Blue on white
Add_Comment_Fail                 14     72   Flashing bright red on white
Remove_Work_Dir_Pass             15     72   Blue on white
Remove_Work_Dir_Fail             15     72   Flashing bright red on white
Update_Files_Pass                16     72   Blue on white
Update_Files_Fail                16     72   Flashing bright red on white
;
; End ANSI definition
;
; The #Begin Rip definition marks the beggining of the Rip Screen Control
; section.  This is optional.

#Begin Rip definition

; For Rip:
;
; Labtest 3.2 brings a much more simplified method of customizing
; your RIP screens.  Instead of worrying about where to put stuff, or colors
; or anything, we leave it all up to you!  Below you will define for
; each stage in Labtest a RIP ACTION.  These actions will be sent to the
; modem instead of the previous coordinates/color/text info.  This way you
; can make boxes, alarms, anything, for each action.  Just specify your
; complete RIP command on the line following the keyword.  The entire RIP
; ACTION will be transmitted to the remote terminal.  These actions must be
; less than 120 characters!  This is the string length used by Labtest.  If
; this is not enough, please let us know and it will be increased, but this
; seemed like a fair starting point!

; The easiest way to write your rip actions is to load your rip editor and
; then load the Labtest screen if you are using the stock screen.  If you are
; starting from scratch, create your screen and save the finished work.
; Actions in Labtest have three parts - Working, Pass and Fail.  You will
; define a Rip Action for each of these three parts.  Using your Rip editor,
; creat all of the actions for one phase (example, create all the PASS
; actions).  For instance, when we designed the Labtest rip screen, we
; created a box of text with each working/pass/fail prompts in between two
; brackets, much like the familiar ansi screen.  We save this screen under
; the name LABTEST.RIP and then began typing in the word 'Passed' in the
; correct position for all of the Labtest phases.  We then saved our screen
; under a new name, LABTEST1.RIP.  Then using the good ole text editor,
; loaded this file in one window, and the LABTEST1.RIP file in another.  By
; using CUT and PASTE, we copied the RIP commands from the .RIP screen and
; placed them in the corresponding position below.  This was repeated for
; each part (Working/Pass/Fail).  It really isn't very difficult if you are
; comfortable with a text editor and have the RIPScript command reference
; handy.  The stock screen should be sufficient if you don't feel up to the
; challenge!

; Labtest will replace the string FILENAME.EXT with the current file name
; and extension in the File_Name_Display section.

;
; Keyword                      Rip Action
File_Name_Display              !|1UBU1QH82E0000<>FILENAME.EXT<>
;
File_Date_Working              !|1B0000020PHC030F000F080300000F07000000|1U0U307W3L0000<>File date and integrity<>
HackReport_Working             !|1B0000020PHC030F000F080300000F07000000|1U0U3P7W4A0000<>Hack Report Check<>
JPG/GIF_Test_Working           !|1B0000020PHC030F000F080300000F07000000|1U0U4E7W4Z0000<>Processing GIF/JPG File<>
Unpack_Working                 !|1B0000020PHC030F000F080300000F07000000|1U0U537W5O0000<>Decompressing archive<>
FileIdDiz_Working              !|1B0000020PHC030F000F080300000F07000000|1U0U5S7W6D0000<>Checking for FILE_ID.DIZ<>
Imbedded_Files_Working         !|1B0000020PHC030F000F080300000F07000000|1U0U6H7W720000<>Testing Imbedded Files<>
Remove_Unwanted_Working        !|1B0000020PHC030F000F080300000F07000000|1UA030GT3L0000<>Adding/Removing files<>
Add_Files_Working              !|1B0000020PHC030F000F080300000F07000000|1UA030GT3L0000<>Adding/Removing files<>
Virus_Scan_Working             !|1B0000020PHC030F000F080300000F07000000|1UA03PGT4A0000<>Performing Virus Scan<>
Repack_Working                 !|1B0000020PHC030F000F080300000F07000000|1UA04EGT4Z0000<>Recompressing Archive<>
Add_Comment_Working            !|1B0000020PHC030F000F080300000F07000000|1UA053GT5O0000<>Adding Archive Comment<>
Remove_Work_Dir_Working        !|1B0000020PHC030F000F080300000F07000000|1UA05SGT6D0000<>Cleaning Up Work Area<>
Update_Files_Working           !|1B0000020PHC030F000F080300000F07000000|1UA06HGT720000<>Updating System Files<>
;
File_Date_Pass                 !|1B0000020PHC030F000F080200000F07000000|1U0U307W3L0000<>File date and integrity<>
HackReport_Pass                !|1B0000020PHC030F000F080200000F07000000|1U0U3P7W4A0000<>Hack Report Check<>
JPG/GIF_Test_Pass              !|1B0000020PHC030F000F080200000F07000000|1U0U4E7W4Z0000<>Processing GIF/JPG File<>
Unpack_Pass                    !|1B0000020PHC030F000F080200000F07000000|1U0U537W5O0000<>Decompressing archive<>
FileIdDiz_Pass                 !|1B0000020PHC030F000F080200000F07000000|1U0U5S7W6D0000<>Checking for FILE_ID.DIZ<>
Imbedded_Files_Pass            !|1B0000020PHC030F000F080200000F07000000|1U0U6H7W720000<>Testing Imbedded Files<>
Remove_Unwanted_Pass           !|1B0000020PHC030F000F080200000F07000000|1UA030GT3L0000<>Adding/Removing files<>
Add_Files_Pass                 !|1B0000020PHC030F000F080200000F07000000|1UA030GT3L0000<>Adding/Removing files<>
Virus_Scan_Pass                !|1B0000020PHC030F000F080200000F07000000|1UA03PGT4A0000<>Performing Virus Scan<>
Repack_Pass                    !|1B0000020PHC030F000F080200000F07000000|1UA04EGT4Z0000<>Recompressing Archive<>
Add_Comment_Pass               !|1B0000020PHC030F000F080200000F07000000|1UA053GT5O0000<>Adding Archive Comment<>
Remove_Work_Dir_Pass           !|1B0000020PHC030F000F080200000F07000000|1UA05SGT6D0000<>Cleaning Up Work Area<>
Update_Files_Pass              !|1B0000020PHC030F000F080200000F07000000|1UA06HGT720000<>Updating System Files<>
;
File_Date_Fail                 !|1B0000020PHC030F000F080400000F07000000|1U0U307W3L0000<>File date and integrity<>
HackReport_Fail                !|1B0000020PHC030F000F080400000F07000000|1U0U3P7W4A0000<>Hack Report Check<>
JPG/GIF_Test_Fail              !|1B0000020PHC030F000F080400000F07000000|1U0U4E7W4Z0000<>Processing GIF/JPG File<>
Unpack_Fail                    !|1B0000020PHC030F000F080400000F07000000|1U0U537W5O0000<>Decompressing archive<>
FileIdDiz_Fail                 !|1B0000020PHC030F000F080400000F07000000|1U0U5S7W6D0000<>Checking for FILE_ID.DIZ<>
Imbedded_Files_Fail            !|1B0000020PHC030F000F080400000F07000000|1U0U6H7W720000<>Testing Imbedded Files<>
Remove_Unwanted_Fail           !|1B0000020PHC030F000F080400000F07000000|1UA030GT3L0000<>Adding/Removing files<>
Add_Files_Fail                 !|1B0000020PHC030F000F080400000F07000000|1UA030GT3L0000<>Adding/Removing files<>
Virus_Scan_Fail                !|1B0000020PHC030F000F080400000F07000000|1UA03PGT4A0000<>Performing Virus Scan<>
Repack_Fail                    !|1B0000020PHC030F000F080400000F07000000|1UA04EGT4Z0000<>Recompressing Archive<>
Add_Comment_Fail               !|1B0000020PHC030F000F080400000F07000000|1UA053GT5O0000<>Adding Archive Comment<>
Remove_Work_Dir_Fail           !|1B0000020PHC030F000F080400000F07000000|1UA05SGT6D0000<>Cleaning Up Work Area<>
Update_Files_Fail              !|1B0000020PHC030F000F080400000F07000000|1UA06HGT720000<>Updating System Files<>
;
;
; End RIP definition
