'
'  Copyright (C) 1988-1993 The GAP Development Company
'
'  All Rights Reserved
'
'
'  GAPQBDR.BI
'
'  Include file for all modules that use GAPQBDR
'
'

DECLARE FUNCTION keybrd% ()               ' checks if key was pressed locally
DECLARE FUNCTION read.doorsys% ()         ' reads door.sys
DECLARE FUNCTION getakey% ()              ' gets a single character
DECLARE FUNCTION a.ccess% (a$)            ' checks for file existence
DECLARE FUNCTION right.trim$ (a$)         ' trims C strings
DECLARE FUNCTION read.gapdos% ()          ' reads GAPDOS.DAT
DECLARE FUNCTION write.gapdos% ()         ' writes GAPDOS.DAT
DECLARE FUNCTION read.gapuser% ()         ' reads USERS.DAT
DECLARE FUNCTION write.gapuser% ()        ' writes USERS.DAT
DECLARE FUNCTION read.pcbsys% ()          ' reads PCBOARD.SYS
DECLARE FUNCTION write.pcbsys% ()         ' writes PCBOARD.SYS
DECLARE FUNCTION read.pcbuser% ()         ' read pcb USERS
DECLARE FUNCTION write.pcbuser% ()        ' write pcb USERS
DECLARE FUNCTION getrand% (low%, high%)   ' get a random number
DECLARE FUNCTION read.score% (datfile$, message$)  ' read high scores

DECLARE SUB at (r.ow%, c.ol%)             ' position cursor at row, column
DECLARE SUB atsay (r.ow%, c.ol%, a$)      ' position cursor and print string
DECLARE SUB eraeol ()                     ' erase from cursor to end of line
DECLARE SUB show.mess (message$, bell%, newline%)  ' displays a string
DECLARE SUB lostcd ()                     ' used by com routines
DECLARE SUB no.carrier ()                 ' shows message and calls leave
DECLARE SUB write.score (datfile$, score&) ' write high scores
DECLARE SUB init.time ()                  ' inits get.time variables
DECLARE SUB get.string (fld$)             ' main imput routine
DECLARE SUB read.cnf (f.name$)            ' reads the configuration file
DECLARE SUB init.door ()                  ' initializes the door
DECLARE SUB leave ()                      ' normal exit
DECLARE SUB nl (how%)                     ' sends CR/LF
DECLARE SUB ansi (ansicolor$)             ' shows ansi colors
DECLARE SUB more ()                       ' checks for full screen
DECLARE SUB pause ()                      ' waits for a keypress
DECLARE SUB elap.time ()                  ' computes elapsed time
DECLARE SUB backspace (num.times%)        ' erases characters
DECLARE SUB time.left ()                  ' computes time left
DECLARE SUB waitasec (secs%)              ' waits for x number of seconds
DECLARE SUB time.credit (how%)            ' computes time credits
DECLARE SUB putachar (c%)                 ' sends a single character
DECLARE SUB show.file (filename$)         ' displays a text file
DECLARE SUB set.status (up.date%)         ' displays status line
DECLARE SUB update.clock ()               ' updates status line clock
DECLARE SUB putkey (c%)                   ' sends a single character
DECLARE SUB do.chat ()                    ' chat with caller
DECLARE SUB pagesysop ()                  ' page sysop for chat
DECLARE SUB clear.scr ()                  ' clears local and remote screen
DECLARE SUB setctrlc ()                   ' ctrl-c trapper
DECLARE SUB reset.port ALIAS "RESET_PORT" ()   ' restores the comm port


CONST MOREG = "[1;31;40mMORE - [33m[[31mY[33m]es, [[31mN[33m]o, [[31mC[33m]ontinous[0m "
CONST MOREA = "MORE - [Y]es, [N]o, [C]ontinous "

CONST MORE1G = "[1;31;40mMORE - [33m[[31mY[33m]es, [[31mN[33m]o, [[31mC[33m]ontinous, [[31mR[33m]edisplay[0m "
CONST MORE1A = "MORE - [Y]es, [N]o, [C]ontinous, [R]edisplay "

CONST PAUSEG = "[1;33;40mPress [[31mAny Key[33m] To Continue[0m "
CONST PAUSEA = "Press [Any Key] To Continue "

CONST YES = 1
CONST NO = 0


  '***********************************************************************
  '*                         ANSI colors                                 *
  '***********************************************************************

' dim colors

CONST BLACK = "[0;30m"
CONST RED = "[0;31m"
CONST GREEN = "[0;32m"
CONST BROWN = "[0;33m"
CONST BLUE = "[0;34m"
CONST MAGENTA = "[0;35m"
CONST CYAN = "[0;36m"
CONST WHITE = "[0;37m"

' bright colors

CONST BBLACK = "[0;1;30m"
CONST BRED = "[0;1;31m"
CONST BGREEN = "[0;1;32m"
CONST YELLOW = "[0;1;33m"
CONST BBLUE = "[0;1;34m"
CONST BMAGENTA = "[0;1;35m"
CONST BCYAN = "[0;1;36m"
CONST BWHITE = "[0;1;37m"

CONST REVID = "[0;30;47m"


'$INCLUDE: 'qb.bi'


   '***********************************************************************
   '*  global variables                                                   *
   '***********************************************************************

   COMMON SHARED interface  AS INTEGER     ' 0=Standard,1=Digi Direct,2=Int14/EBIOS
   COMMON SHARED digiseg    AS INTEGER     ' DigiBoard Memory Window
   COMMON SHARED digiport   AS INTEGER     ' DigiBoard I/O Port
   COMMON SHARED digichnl   AS INTEGER     ' DigiBoard Channel
   COMMON SHARED port       AS INTEGER     ' comm port being used
   COMMON SHARED node       AS INTEGER     ' node number
   COMMON SHARED s.creen    AS INTEGER     ' 0 = screen off, 1 = screen on
   COMMON SHARED printer    AS INTEGER     ' 0 = printer off, 1 = printer on
   COMMON SHARED bell       AS INTEGER     ' 0 = page bell off, 1 = on
   COMMON SHARED alarm      AS INTEGER     ' 0 = caller alarm off, 1 = on
   COMMON SHARED level      AS INTEGER     ' user's security level
   COMMON SHARED minsleft   AS INTEGER     ' number of minutes left at start
   COMMON SHARED c.olor     AS INTEGER     ' 0 = no color, 1 = color ok
   COMMON SHARED page       AS INTEGER     ' user's page length
   COMMON SHARED expert     AS INTEGER     ' 0 = novice, 1 = expert
   COMMON SHARED l.ocal     AS INTEGER     ' l.ocal user flag
   COMMON SHARED lines      AS INTEGER     ' # of lines currently displayed
   COMMON SHARED v.iew      AS INTEGER     ' true if want a more prompt
   COMMON SHARED noup       AS INTEGER     ' if 1, get.string wont upper case
   COMMON SHARED timeleft   AS INTEGER     ' time user has left
   COMMON SHARED timecredit AS INTEGER     ' time credits for user (in mins)
   COMMON SHARED realcredit AS INTEGER     ' time credits from BBS
   COMMON SHARED dflt.color AS INTEGER     ' BBS default color
   COMMON SHARED maxfiles   AS INTEGER     ' Max files available
   COMMON SHARED curfiles   AS INTEGER     ' Current files downloaded

   COMMON SHARED maindir    AS STRING      ' path to the main directory
   COMMON SHARED gendir     AS STRING      ' path to the gen directory
   COMMON SHARED sysname    AS STRING      ' sysop's name
   COMMON SHARED birthday   AS STRING      ' caller's birth date
   COMMON SHARED bbs.dir    AS STRING      ' path to BBS default dir
   COMMON SHARED board.name AS STRING      ' name of the BBS
   COMMON SHARED username   AS STRING      ' caller's full name
   COMMON SHARED first      AS STRING      ' caller's first name
   COMMON SHARED last       AS STRING      ' caller's last name
   COMMON SHARED city       AS STRING      ' home state
   COMMON SHARED hphone     AS STRING      ' home phone number
   COMMON SHARED bphone     AS STRING      ' voice or data phone number
   COMMON SHARED password   AS STRING      ' user's password
   COMMON SHARED lastdate   AS STRING      ' last date user was on
   COMMON SHARED subscrip   AS STRING      ' date user's subscription expires
   COMMON SHARED CRLF       AS STRING      ' carriage return and line feed
   COMMON SHARED handle     AS STRING      ' caller's Handle
   COMMON SHARED event.time AS STRING      ' event run time
   COMMON SHARED last.new   AS STRING      ' last new files scan

   COMMON SHARED userbaud   AS LONG        ' user's bps rate
   COMMON SHARED baud       AS LONG        ' DTE bps rate
   COMMON SHARED timeson    AS LONG        ' number of times on
   COMMON SHARED uploads    AS LONG        ' total number of uploads
   COMMON SHARED downloads  AS LONG        ' total number of downloads
   COMMON SHARED upbytes    AS LONG        ' total bytes uploaded
   COMMON SHARED curbytes   AS LONG        ' current bytes downloaded
   COMMON SHARED maxbytes   AS LONG        ' max number of bytes available
   COMMON SHARED timenow    AS LONG        ' time it is now  (in secs)
   COMMON SHARED starttime  AS LONG        ' time the user started (in secs)
   COMMON SHARED doors.open AS LONG        ' Total doors opened
   COMMON SHARED mesleft    AS LONG        ' Total messages left
   COMMON SHARED downbytes  AS LONG        ' total download bytes


   '***********************************************************************
   '*  USERS.DAT record structure.                                        *
   '*  The index (fname and lname) must NOT be touched!                   *
   '*  STRING fields are fully padded with spaces and the last position   *
   '*  of the string MUST be a 0. This means that for a field such as     *
   '*  handle, you may use 15 characters of the string. The 16th position *
   '*  is reserved for the chr$(0).                                       *
   '*  Phone number fields must be of the type "(999)999-999"+chr$(0).    *
   '*  Date fields must be of the type "01/01/01"+chr$(0).                *
   '*  Note that even if a phone number or date field has no data, they   *
   '*  still contain the picture clauses (IE, "(   )  -" or "  /  /")     *
   '***********************************************************************

   TYPE GAPUSER
      fname       AS STRING * 16           ' first name
      lname       AS STRING * 16           ' last name
      handle      AS STRING * 16           ' handle for MPART!
      passwd      AS STRING * 13           ' password
      hphone      AS STRING * 16           ' homephone
      bphone      AS STRING * 16           ' work/data phone
      subscribe   AS STRING * 9            ' subscription date
      level       AS INTEGER               ' security - up to 255
      usernum     AS LONG                  ' user's sequence number
      timeson     AS LONG                  ' times on - over 2 billion
      lastdate    AS STRING * 9            ' last date on - mm/dd/yy
      lasttime    AS STRING * 6            ' last time on - hh:mm
      ttlmins     AS LONG                  ' total mins on - 2+ billion
      minutes     AS INTEGER               ' # of minutes last call
      uploads     AS LONG                  ' # of uploads - 2+ billion
      downloads   AS LONG                  ' # of downloads - 2+ billion
      ttlbytes    AS LONG                  ' total bytes downloaded
      curbytes    AS LONG                  ' bytes downloaded this call
      private     AS STRING * 1            ' allow on private nodes?
      protocol    AS STRING * 3            ' transfer protocol
      page        AS INTEGER               ' page length - to 23
      lastdir     AS STRING * 9            ' date last looked at dir
      lastmsg     AS LONG                  ' last message read - 99999 max
      mesread     AS LONG                  ' total msgs read - 2+ billion
      mesleft     AS LONG                  ' total messages left
      joined      AS LONG                  ' total forums joined
      blts        AS LONG                  ' total bulletins read
      doors       AS LONG                  ' total doors opened
      lastfrm     AS INTEGER               ' last forum in
      expert      AS STRING * 1            ' novice = N, expert = Y
      sysop       AS STRING * 1            ' sysop record, 1 = Y, 0 = N
      upbytes     AS LONG                  ' total bytes uploaded
      curdown     AS INTEGER               ' total files downed today
      birthdate   AS STRING * 9            ' user's birthdate
      comment     AS STRING * 51           ' comment about user
      add1        AS STRING * 26           ' Company or address
      add2        AS STRING * 26           ' Address
      city        AS STRING * 26           ' City
      state       AS STRING * 11           ' State
      zip         AS STRING * 11           ' Zip
      country     AS STRING * 16           ' Country
      regisdate   AS STRING * 9            ' Date 1st signed on
      enftime     AS STRING * 1            ' Y = enforce time limit
      editor      AS STRING * 1            ' V = Visual, L = Line, A = Ask
      chat        AS STRING * 1            ' Y/N if available for chat
      msgclr      AS STRING * 1            ' Y/N to clear screen between msgs
      newmsg      AS INTEGER               ' # of new messages
      timecredit  AS INTEGER               ' time credits
      expired     AS INTEGER               ' Expired Subscription level
      pubforums   AS STRING * 1            ' put back to public Forums?
      discons     AS INTEGER               ' # of dropped carriers
      pertime     AS LONG                  ' time used during sub period
      notused     AS LONG                  ' later additions
      flags       AS STRING * 1            ' miscellaneous flags
      notused1    AS STRING * 9            ' later additions
   END TYPE                                ' 424 bytes

   COMMON SHARED user AS GAPUSER


   '***********************************************************************
   '*  PCBOARD.SYS record structure.                                      *
   '*  GAPQBDR supports version 14.x ONLY!                                *
   '*  Note - There is no consistency with this file. For instance, node  *
   '*    number is stored as a short integer (1 byte integer), where as   *
   '*    port number is stored as a 1 byte string.  Display, printer, etc *
   '*    are stored as space 0 (if the function is off), where as event   *
   '*    active and slide event are stored as 0 space.  Have fun!         *
   '***********************************************************************

   TYPE PCBSYS14                           ' structure of PCBOARD.SYS
      display     AS STRING * 2            ' display on/off -1=on,0=off
      printer     AS STRING * 2            ' printer on/off -1=on,0=off
      pagebell    AS STRING * 2            ' page bell      -1=on,0=off
      calleralarm AS STRING * 2            ' caller alarm   -1=on,0=off
      sysopnext   AS STRING * 1            ' sysop on next  N,X,space
      errcorrect  AS STRING * 2            ' ecc modem      -1=yes,0=no
      colorc      AS STRING * 1            ' color toggle   Y,N,7
      nu          AS STRING * 1            ' node chat, not provided
      baud        AS STRING * 5            ' com port bps rate
      userbaud    AS STRING * 5            ' call bps rate
      userrec     AS INTEGER               ' user record position
      userfirst   AS STRING * 15           ' caller's first name
      password    AS STRING * 12           ' users password
      timeon      AS INTEGER               ' time user logged on (mins)
      timeused    AS INTEGER               ' time user has used that day
      ctime       AS STRING * 5            ' time user logged on hh:mm
      timeallowed AS INTEGER               ' allowed time in minutes
      ttlbytes    AS INTEGER               ' total bytes available /1024
      forumnum    AS STRING * 1            ' forum user was in "0" = main
      nu1         AS STRING * 10           ' areas been in, not provided
      timegiven   AS INTEGER               ' highest forum time given
      timecredit  AS INTEGER               ' time credit in minutes
      nu2         AS STRING * 4            ' language being used
      username    AS STRING * 25           ' name of caller
      minsleft    AS INTEGER               ' minutes left for caller
      node        AS STRING * 1            ' node number as short integer
      event       AS STRING * 5            ' event time hh:mm
      eactive     AS STRING * 2            ' event active -1=yes,0 = no
      eslide      AS STRING * 2            ' slide event  -1=yes,0 = no
      nu3         AS STRING * 4            ' memorized mess #, not prov
      port        AS STRING * 1            ' com port, "0","1","2" in ascii
      nu4         AS STRING * 2            ' not used
   END TYPE

   COMMON SHARED pcbsys AS PCBSYS14


   '***********************************************************************
   '*  PCB USERS record structure.                                        *
   '***********************************************************************

   TYPE PCBUSER14                          ' pcb 14 user file
      username    AS STRING * 25           ' users name
      city        AS STRING * 24           ' users city
      passwd      AS STRING * 12           ' users password
      bphone      AS STRING * 13           ' business or data phone number
      hphone      AS STRING * 13           ' home phone number
      lastdate    AS STRING * 6            ' Last date on as yymmdd
      lasttime    AS STRING * 5            ' last time on hh:mm
      expert      AS STRING * 1            ' expert mode - Y or N
      protocol    AS STRING * 1            ' Protocol
      nu          AS STRING * 1            ' not used
      lastdir     AS STRING * 6            ' last date looked at DIR as yymmdd
      level       AS STRING * 1            ' security level
      timeson     AS INTEGER               ' number of times on
      page        AS STRING * 1            ' page length
      uploads     AS INTEGER               ' total number of uploads
      downloads   AS INTEGER               ' total number of downloads
      nu1         AS STRING * 70           ' cur down bytes,comments,elapsed time
      regisdate   AS STRING * 6            ' registration date
      nu2         AS STRING * 1            ' expired security level
      lastconf    AS STRING * 1            ' last forum in
      cnfregis    AS STRING * 5            ' forum registration
      nu3         AS STRING * 10           ' not provided
      downbytes   AS STRING * 8            ' total download bytes
      upbytes     AS STRING * 8            ' total upload bytes
      delete      AS STRING * 1            ' Deleted, Y = yes, N = no
      lastmsg     AS STRING * 4            ' last message number read in main
      lastmsg1    AS STRING * 156          ' last message read in forums
      nu4         AS STRING * 15           ' not used
   END TYPE

   COMMON SHARED pcbuser AS PCBUSER14

