'Types for PCBOARD.SYS, USERS.SYS, USERS, USERS.INF, CNAMES.@@@, CNAMES.ADD,
'          MSGS, MSGS.IDX, MESSAGES.DAT/QWKID.MSG, PCBSM.CLR, PCBSTATS.DAT,
'          USERNET.XXX & MAKEIDX *.IDX Files for PCBoard 15.x in QB4.5

' * * * * * PCBoard 15.x PCBOARD.SYS File Formats

TYPE PCBSysRecord
    Display AS STRING * 2   'Display On/Off ("-1" = On, " 0" = Off)                1
    Printer AS STRING * 2   'Printer On/Off ("-1" = On, " 0" = Off)                3
    PageBell AS STRING * 2  'Page Bell On/Off ("-1" = On, " 0" = Off)              5
    CallAlarm AS STRING * 2 'Caller Alarm On/Off ("-1" = On, " 0" = Off)           7
    SysopFlag AS STRING * 1 'Sysop Flag (" ", "N"=sysop next, "X"=exit dos)        9
    ErrCorr AS STRING * 2   'Error Corrected ("-1" = On, " 0" = Off)              10
    Graphics AS STRING * 1  'Graphics Mode ('Y'=yes, 'N'=no, '7'=7E1)             12
    NodeChat AS STRING * 1  'Node Chat Status ('A'=available, 'U'=unavailable)    13
    DTEPort  AS STRING * 5  'DTE Port Speed (PC to Modem speed)                   14
    Connect  AS STRING * 5  'Connect Speed shown to caller or "Local"             19
    RecNum   AS INTEGER     'User's Record Number in the USERS file               24
    FirstName AS STRING * 15 'User's First Name (padded to 15 characters)         26
    Password AS STRING * 12 'User's Password (padded to 12 characters)            41
    TimeOn   AS INTEGER     'Time User Logged On (in minutes since midnight)      53
    TimeUsed AS INTEGER     'Time used so far today (negative number of minutes)  55
    TimeOnF  AS STRING * 5  'Time User Logged On (in "HH:MM" format)              57
    DayTime  AS INTEGER     'Time Allowed On (from PWRD file)                     62
    DLKbytes AS INTEGER     'Allowed K-Bytes for Download                         64
    ConfArea AS STRING * 1  'Conference Area user was in (if <= 255)              66
    ConfJoined AS STRING * 5 'Conference Areas the user has joined this session   67
    ConfScaned AS STRING * 5 'Conference Areas the user has scanned this session  72
    ConfAddTime AS INTEGER  'Conference Add Time in minutes                       77
    CreditTime AS INTEGER   'Upload/Sysop CHAT Credit Minutes                     79
    LangExt AS STRING * 4   'Language Extension                                   81
    UserName AS STRING * 25 'User's Full Name (padded to 25 characters)           85
    MinRemain AS INTEGER    'Calculated Minutes Remaining (see note 5 below)     110
    NodeNum AS STRING * 1   'Node Number (or ' ' if no network)                  112
    EventTime AS STRING * 5 'Event Time (in "HH:MM" format, "00:00" if no event) 113
    EventOn AS STRING * 2   'Is Event Active ("-1" = On, " 0" = Off)             118
    Reserved AS STRING * 2  'Slide Event (was Slide Event, no longer used here)  120
    MemMesg AS STRING * 4   'Memorized Message Number               MKSMBF$()    122
    ComPort AS STRING * 1   'Comm Port Number (0=none, 1-8)                      126
    Reserved1 AS STRING * 1 'Reserved for PCBoard                                127
    BitMap AS STRING * 1    ' 1    See Node 8 below for details
    ANSI AS STRING * 1      'Use ANSI (1 = Yes, 0 = No)                          129
    CountryCode AS INTEGER  'Country Code                                        130
    CodePage AS INTEGER     'Code Page                                           132
    YesChar AS STRING * 1   'YES character                                       134
    NoChar AS STRING * 1    'NO character                                        135
    Language AS STRING * 1  'Language 0=None, otherwise correspond with PCBML.DAT136
    Reserved3 AS STRING * 3 'RESERVED                                            137
    ExitToDOS AS STRING * 1 'Caller Exited to DOS (1 = Yes, 0 = No)              140
    Reserved4 AS STRING * 1 'RESERVED (was Event Up Coming, no longer used)      141
    StopUploads AS STRING * 1 'Stop Uploads (1 = Yes, 0 = No)                    142
    ConfAreaIn AS INTEGER  ' Conference Area user was in (up to 65535)           143
END TYPE

'  ConfJoined2 AS STRING * ? 'High Conference Areas the user has joined          145
'  ConfScaned2 AS STRING * ? 'High Conference Areas the user has scanned         Varies
'  NodeNum2 AS INTEGER       'Node Number if offset 111 is set to 255, seek to   Varies
'                             the end of the file, minus 2, to read this value
' Note 8
' ------
' The structure for this byte is as follows:
'
'     Bit 0:  Used by PCBoard - reserved
'     Bit 1:  Caller wants RIP Graphics
'     Bit 2:  Caller wants to use his alias when in an alias supported conf.
'     Bit 3:  Undefined - RESERVED - do NOT use
'     Bit 4:  Undefined - RESERVED - do NOT use
'     Bit 5:  Undefined - RESERVED - do NOT use
'     Bit 6:  Undefined - RESERVED - do NOT use
'     Bit 7:  Undefined - RESERVED - do NOT use

' * * * * * PCBoard 15.x USERS.SYS File Formats

TYPE UsersSysHdrRecord
   Version AS INTEGER            'PCBoard version number (i.e. 150) unsigned
   RecNo AS LONG                 'Record number from USER's file
   SizeOfRec AS INTEGER          'Size of "fixed" user record unsigned
   NumOfAreas AS INTEGER         'Number of conference areas (Main=1 thru 65535) unsigned
   NumOfBitFields AS INTEGER     'Number of Bit Map fields for conferences unsigned
   SizeOfBitFields AS INTEGER    'Size of each Bit Map field unsigned
   AppName AS STRING * 15        'Name of the Third Party Application (if any)
   AppVersion AS INTEGER         'Version number for the application (if any) unsigned
   AppSizeOfRec AS INTEGER       'Size of a "fixed length" record (if any) unsigned
   AppSizeOfConfRec AS INTEGER   'Size of each conference record (if any) unsigned
   AppRecOffset AS LONG          'Offset of AppRec into USERS.INF record (if any)
   Updated AS STRING * 1         'TRUE if the USERS.SYS file has been updated (Bollean)
END TYPE

TYPE UsersSysRecord
   UserName AS STRING * 26       'User's Full Name (NUL terminated)
   CityState AS STRING * 25      'City and State (NULL terminated)
   Password AS STRING * 13       'Password (NULL terminated)
   BusDataPhone AS STRING * 14   'Business or Data Phone (NULL terminated)
   HomeVoicePhone AS STRING * 14 'Home or Voice Phone (NULL terminated)
   LastOnDate AS INTEGER         'Last Date on system (unsigned - Julian)
   LastOnTime AS STRING * 6      'Last Time on system (in hh:mm format) (NULL term)
   ExpertMode AS STRING * 1      'Expert Mode - 1=Expert, 0=Novice
   Protocol AS STRING * 1        'Protocol (A thru Z)
   PackedFlags AS STRING * 1     'Dirty, ClrScrn, HasMail, DontAsk, Editor, Default, Scroll, Short, Wide
   LastDirScan AS INTEGER        'Last date looked at directory (of DateType)
   SecLevel AS INTEGER           'Security Level
   NumTimesOn AS INTEGER         'Number of times on the system
   PageLen AS STRING * 1         'Page Length CHR$(X)
   NumUploads AS INTEGER         'Number of Uploads   (unsigned)
   NumDownloads AS INTEGER       'Number of Downloads (unsigned)
   DailyDnldBytes AS LONG        'Daily Download Bytes so far
   UserComment AS STRING * 31    'User Maintained Comment  (NULL terminated)
   SysopComment AS STRING * 31   'Sysop Maintained Comment (NULL terminated)
   ElapsedTimeOn AS INTEGER      'Elapsed Time on system on last date called
   RegExpDate AS INTEGER         'Subscription Registration Date (unsigned Julian)
   ExpSecLevel AS INTEGER        'Subscription Expired Security Level
   LastConference AS INTEGER     'Last Conference left - (unsigned)
   TotDnldBytes AS LONG          'Total Bytes Download - all calls
   TotUpldBytes AS LONG          'Total Bytes Upload - all calls
   DeleteFlag AS STRING * 1      'Positive Delete Flag to Delete User (Repack) 1=delete this record, 0=keep
   UsersInfPointer AS LONG       'Pointer into USERS.INF record
   PackedFlags2 AS STRING * 1    'More bit packed flags (Unavailable, 7 bits reserved)
   Space2 AS STRING * 8          'Bytes 391-398 from the USERS file
   MsgsRead AS LONG              'Number of messages the user has read in PCB
   MsgsLeft AS LONG              'Number of messages the user has left in PCB
END TYPE

' * * * * * PCBoard 15.x USERS.SYS PSA Formats

TYPE UAddressRecord
   Street1 AS STRING * 51   ' A NULL-terminated strings for street address
   Street2 AS STRING * 51   ' A NULL-terminated strings for street address
   City    AS STRING * 26   ' A NULL-terminated string for city
   State   AS STRING * 11   ' A NULL-terminated string for state
   Zip     AS STRING * 11   ' A NULL-terminated string for zip
   Country AS STRING * 16   ' A NULL-terminated string for country
END TYPE

TYPE UNotesRecord
   Line1 AS STRING * 61         '5 NULL-terminated strings for notes on caller
   Line2 AS STRING * 61
   Line3 AS STRING * 61
   Line4 AS STRING * 61
   Line5 AS STRING * 61
END TYPE

TYPE UPasswordRecord
   Previous1    AS STRING * 13  'NULL-terminated strings for last 3 passwords
   Previous2    AS STRING * 13  '  "
   Previous3    AS STRING * 13  '  "
   LastChange   AS INTEGER      ' Date of last password change
   TimesChanged AS INTEGER      ' Number of times password has been changed
   ExpireDate   AS INTEGER      ' Expiration date of current password
END TYPE

' * * * * * PCBoard 15.x USERS File Format

TYPE PCBNDXRecord
   Index AS INTEGER
   UserName As STRING * 25
END TYPE

TYPE UsersRecord                                                              ' Start
   UserName AS STRING * 25       'First name and Last name                           1
   CityState AS STRING * 24      'City and State                                    26
   Password AS STRING * 12       'Password                                          50
   BusDataPhone AS STRING * 13   'Business or Data Phone Number                     62
   HomeVoicePhone AS STRING * 13 'Home or Voice Phone Number                        75
   LastOnDate AS STRING * 6      'Last Date on system (in yymmdd format)            88
   LastOnTime AS STRING * 5      'Last Time on system (in hh:mm format)             94
   ExpertMode AS STRING * 1      'Expert Mode - "Y" or "N"                          99
   Protocol AS STRING * 1        'Protocol                                         100
   PackedFlags AS STRING * 1     'Dirty, ClrScrn, HasMail, DontAsk, Editor         101
   LastDirScan AS STRING * 6     'Last date looked at directory (in yymmdd format) 102
   SecLevel AS STRING * 1        'Security Level CHR$(X)                           108
   NumTimesOn AS INTEGER         'Number of times on the system                    109
   PageLen AS STRING * 1         'Page Length CHR$(X)                              111
   NumUploads AS INTEGER         'Number of Uploads                                112
   NumDownloads AS INTEGER       'Number of Downloads                              114
   DailyDnldBytes AS STRING * 8  'Daily Download Bytes so far         MKDMBF$()    116
   UserComment AS STRING * 30    'User Maintained Comment                          124
   SysopComment AS STRING * 30   'Sysop Maintained Comment                         154
   ElapsedTimeOn AS INTEGER      'Elapsed Time on system on last date called       184
   RegExpDate AS STRING * 6      'Subscription Registration Date (yymmdd format)   186
   ExpSecLevel AS STRING * 1     'Subscription Expired Security Level CHR$(X)      192
   LastConference AS STRING * 1  'Last Conference left - CHR$(X) - 255 = Ext.      193
   AreaReg AS STRING * 5         'Area Registration Info (1-39) BitMap             194
   ExpAreaReg AS STRING * 5      'Expired Area Registration Info (1-39) BitMap     199
   UserScanArea AS STRING * 5    'User Message Scan Areas (1-39) BitMap            204
   TotDnldBytes AS STRING * 8    'Total Bytes Download - all calls    MKDMBF$()    209
   TotUpldBytes AS STRING * 8    'Total Bytes Upload - all calls      MKDMBF$()    217
   DeleteFlag AS STRING * 1      'Positive Delete Flag to Delete User (Repack)     225
   LastMsgMain AS STRING * 4     'Last message read in Main Board     MKSMBF$()    226
   LastMsgConf AS STRING * 156   'Last message read in Conferences 39 * 4  "       230
   UsersInfPointer AS LONG       'Pointer into USERS.INF record                    386
   PackedFlags2 AS STRING * 1    'More bit packed flags                            390
   Reserved AS STRING * 8        'Reserved                                         391
   ExtLastConference AS INTEGER  'Last Conference Left (If .LastConference$ = 255) 399
END TYPE                                                                       '   401

' * * * * * PCBoard 15.x USERS.INF File Format

TYPE UsersInfHdrRecord
   Version AS INTEGER        'PCBoard Version Number
   NumOfConf AS INTEGER      'Number of EXTENDED Conferences Allocated in File
   SizeOfRec AS INTEGER      'Size of the 'static' PCBoard User Record
   SizeOfConf AS LONG        'Total Size of PCBoard Conference Information
   NumOfApps AS INTEGER      'Number of Third Party Apps adding onto the record
   TotalRecSize AS LONG      'Total Record Size (PCB and all TPA components)
END TYPE

TYPE UsersAppRecord
    AppName AS STRING * 15   'Name of Application (NULL terminated)
    Version AS INTEGER       'Version Number
    SizeOfRec AS INTEGER     'Size of Application Record information (0-65535)
    SizeOfConfRec AS INTEGER 'Size of Conference Record information (0-65535)
    KeyWord AS STRING * 9    'Keyword to execute Application (NULL terminated)
    Offset AS LONG           'Offset in User Record where TPA record begins
END TYPE

TYPE UsersInfRecord
   UserName AS STRING * 25   'User Name (in case connection to USERS is lost)
   MsgsRead AS LONG          'Number of messages the user has read in PCBoard
   MsgsLeft AS LONG          'Number of messages the user has left in PCBoard
END TYPE

' * * * * * PCBoard 15.x USERS.INF PSA Formats

TYPE AddressRecord
   Street1 AS STRING * 50   ' A NULL-terminated strings for street address
   Street2 AS STRING * 50   ' A NULL-terminated strings for street address
   City    AS STRING * 25   ' A NULL-terminated string for city
   State   AS STRING * 10   ' A NULL-terminated string for state
   Zip     AS STRING * 10   ' A NULL-terminated string for zip
   Country AS STRING * 15   ' A NULL-terminated string for country
END TYPE

TYPE NotesRecord
   Line1 AS STRING * 60         '5 NULL-terminated strings for notes on caller
   Line2 AS STRING * 60
   Line3 AS STRING * 60
   Line4 AS STRING * 60
   Line5 AS STRING * 60
END TYPE

TYPE PasswordRecord
   Previous1    AS STRING * 12  'NULL-terminated strings for last 3 passwords
   Previous2    AS STRING * 12  '  "
   Previous3    AS STRING * 12  '  "
   LastChange   AS INTEGER      ' Date of last password change
   TimesChanged AS INTEGER      ' Number of times password has been changed
   ExpireDate   AS INTEGER      ' Expiration date of current password
END TYPE

TYPE StatsRecord
   FirstDateOn     AS INTEGER   'First date on, in julian date format
   NumSysopPages   AS INTEGER   'Number of times caller paged the sysop
   NumGroupChats   AS INTEGER   'Number of times caller entered group chat
   NumComments     AS INTEGER   'Number of times caller left comment to sysop
   Num300          AS INTEGER   'Number of times caller was on a 300 bps
   Num1200         AS INTEGER   'Number of times caller was on a 1200 bps
   Num2400         AS INTEGER   'Number of times caller was on a 2400 bps
   Num9600         AS INTEGER   'Number of times caller was on a 9600 bps
   Num14400        AS INTEGER   'Number of times caller was on a 14400+ bps
   NumSecViol      AS INTEGER   'Number of security violations committed
   NumNotReg       AS INTEGER   'Number of attempts to join un-reg conference
   NumReachDnldLim AS INTEGER   'Number of times download limit was reached
   NumFileNotFound AS INTEGER   'Number of times download file was not found
   NumPwrdErrors   AS INTEGER   'Number of times entered password incorrectly
   NumVerifyErrors AS INTEGER   'Number of times upload verification failed
END TYPE

TYPE AccountRecord
   StartingBalance AS STRING * 8      'Starting Balance
   StartThisSession AS STRING * 8     'Balance at login of current session
   DebitCall AS STRING * 8            'Charges for calls made to the system
   DebitTime AS STRING * 8            'Charges for time spent online
   DebitMsgRead AS STRING * 8         'Charges for messages read
   DebitMsgReadCapture AS STRING * 8  'Charges for messages captured
   DebitMsgWrite AS STRING * 8        'Charges for messages written
   DebitMsgWriteEchoed AS STRING * 8  'Charges for messages written (echoed)
   DebitMsgWritePrivate AS STRING * 8 'Charges for messages written (private)
   DebitDownloadFile AS STRING * 8    'Charges for files downloaded
   DebitDownloadBytes AS STRING * 8   'Charges for bytes downloaded
   DebitGroupChat AS STRING * 8       'Charges for time spent in group chat
   DebitTPU AS STRING * 8             'Charges for third party utility usage
   DebitSpecial AS STRING * 8         'Charges made via PPEs
   CreditUploadFile AS STRING * 8     'Payback for files uploaded
   CreditUploadBytes AS STRING * 8    'Payback for bytes uploaded
   CreditSpecial AS STRING * 8        'Packback made via PPEs
   DropSecLevel AS STRING * 1         'Security level on empty/negative balance  CHR$(X)
END TYPE

' NOTE: All of the above 8 character strings are a DOUBLE precision number

TYPE QwkConfigRecord
   MaxMsgs AS INTEGER            'Maximum messages desired in QWK packet
   MaxMsgsPerConf AS INTEGER     'Maximum messages per conference
   PersonalAttachLimit AS LONG   'Attach limit on personal messages
   PublicAttachLimit AS LONG     'Attach limit on public (non-personal) msgs
   Reserved AS STRING * 18
END TYPE

' * * * * * PCBoard 15.x CNAMES.@@@, CNAMES.ADD, CNAMES.IDX

TYPE CNamesAtRecord
   ConfName AS STRING * 14      ' conference name
   PublicConf AS STRING * 1     ' new user default registration (BOOLEAN)
   AutoRejoin AS STRING * 1     ' auto-rejoin for this conference (BOOLEAN)
   ViewMembers AS STRING * 1    ' allow viewing conference members (BOOLEAN)
   PrivUplds AS STRING * 1      ' make uploads private (BOOLEAN)
   PrivMsgs AS STRING * 1       ' make all messages private (BOOLEAN)
   EchoMail AS STRING * 1       ' is this an Echo-Mail conference (BOOLEAN)
   ReqSecLevel AS INTEGER       ' security required to join non-public conf.
   AddSec AS INTEGER            ' additional security level added after join
   AddTime AS INTEGER           ' additional time added after join
   MsgBlocks AS STRING * 1      ' number of message base index blocks (CHR$())
   MsgBaseFile AS STRING * 32   ' name and location of messages file
   UserMenu AS STRING * 32      ' name and location of Users Menu
   SysopMenu AS STRING * 32     ' name and location of Sysops Menu
   NewsFile AS STRING * 32      ' name and location of Conference News
   PubUpldSort AS STRING * 1    ' sort type for public upload DIR file
   UpldDir AS STRING * 29       ' name and location of public upload DIR file
   PubUpldLoc AS STRING * 26    ' public upload location
   PrvUpldSort AS STRING * 1    ' sort type for public upload DIR file
   PrivDir AS STRING * 29       ' name and location of private upload DIR file
   PrvUpldLoc AS STRING * 26    ' private upload location
   DrsMenu AS STRING * 29       ' name and location of conference doors menu
   DrsFile AS STRING * 33       ' name and location of DOORS.LST file
   BltMenu AS STRING * 29       ' name and location of conference blt menu
   BltNameLoc AS STRING * 33    ' name and location of BLT.LST file
   ScrMenu AS STRING * 29       ' name and location of conference scripts menu
   ScrNameLoc AS STRING * 33    ' name and location of SCRIPT.LST
   DirMenu AS STRING * 29       ' name and location of directories menu
   DirNameLoc AS STRING * 33    ' name and location of DIR.LST file
   PthNameLoc AS STRING * 33    ' name and location of DLPATH.LST file
END TYPE

TYPE CNamesAddRecord
   ForceEcho AS STRING * 1         'turn off echo question, force all msgs to echo (BOOLEAN)  1
   ReadOnly AS STRING * 1          'do not allow ANY msgs to be entered in conf (BOOLEAN)     2
   NoPrivateMsgs AS STRING * 1     'do not allow PRIVATE msgs to be entered (BOOLEAN)         3
   RetReceiptLevel AS STRING * 1   'level required to request return receipts (CHR$())        4
   RecordOrigin AS STRING * 1      'Record ORIGIN in messages (BOOLEAN)                       5
   PromptForRouting AS STRING * 1  'Prompt user for ROUTING information (BOOLEAN)             6
   AllowAliases AS STRING * 1      'Allow aliases to be used (BOOLEAN)                        7
   ShowIntroOnRA AS STRING * 1     'Show the Conf INTRO in the middle of R A scan (BOOLEAN)   8
   ReqLevelToEnter AS STRING * 1   'Security Level required to enter messages (CHR$())        9
   Password AS STRING * 13         'password reqd to join if private                          10
   Intro AS STRING * 32            'name/location of conference INTRO file                    23
   AttachLoc AS STRING * 32        'location for file attachment storage                      55
   RegFlags AS STRING * 4          'RXS flags for automatic conf registration                 87
   AllowAttachments AS STRING * 1  'Allow file attachments when saving messages (BOOLEAN)     91
   CarbonLimit AS STRING * 1       'max number of names in carbon list (CHR$())               92
   CmdLst AS STRING * 32           'name/location of CMD.LST use instead of default           93
   OldIndex AS STRING * 1          'maintain old MSGS indexes? (BOOLEAN)                     125
   LongToNames AS STRING * 1       'allow long TO: names to be entered (BOOLEAN)             126
   CarbonLevel AS STRING * 1       'level required to enter @LIST@ messages (CHR$())         127
   ConfType AS STRING * 1          'one byte code for conference type (*see below)
   ExportPtr AS LONG               'a pointer to the last message number exported
   ChargeTime AS STRING * 4        'amount to charge for time spent in conference (FLOAT)
   ChargeMsgRead AS STRING * 4     'amount to charge for each message read (FLOAT)
   ChargeMsgWrite AS STRING * 4    'amount to charge for each message written (FLOAT)
   Reserved AS STRING * 64         'reserved for future growth                               128
   Name2 AS STRING * 48            'the rest of the conference name
END TYPE                                                                                 '   257

' *NOTE:  Conference types are defined as follows:
'
'         ConfType = 0 = Normal PCBoard Conference
'         ConfType = 1 = Internet Email (Import & Export)
'         ConfType = 2 = Internet/Usenet Junk (Import Only)
'         ConfType = 3 = Usenet Moderated Newsgroup
'                        (Import Normally /
'                         Export Public Messages as Email to Moderator /
'                         Export Private Messages as Email to TO:)
'         ConfType = 4 = Usenet Public Newsgroup
'                        (Import Normally /
'                         Export Public Messages as Articles /
'                         Export Private Messages as Email to TO:)
'         ConfType = 5 = Fido Conference
'
'  **NOTE: The actual conference name is now composed of two parts.  The
'          first 13 bytes of the name are found in CNAMES.@@@, the last 47
'          bytes of the name are found in CNAMES.ADD at the end of the
'          structure (skipping over the reserved bytes).  Don't forget that
'          the first part had a NULL terminator which needs to be removed as
'          you concatenate the two strings together.

TYPE CNamesIDXRecord
   ConfName AS STRING * 61      ' Conference Name (NUL terminated)
   Index AS INTEGER             ' Conference Record Number
END TYPE                                                                                 '   257

' * * * * * PCBoard 15.x MSGS File Header & Message Block Formats

TYPE MsgHdrRecord
   HighMsg AS STRING * 4         'High Message Number (0 - 9,999,999) MKSMBF$()
   LowMsg AS STRING * 4          'Low Message Number (0 - 9,999,999)       "
   ActiveMsg AS STRING * 4       'Number of Active Messages (0 - 32,767)   "
   LastCaller AS STRING * 4      'Number of System Callers (0 - 9,999,999) "
   Locked AS STRING * 6          'The word "LOCKED" if being updated
   Space1 AS STRING * 105        'Reserved
END TYPE

TYPE MsgRecord
   Status AS STRING * 1          'Status Flag (*+-`~ or blank)                       1
   MsgNumber AS STRING * 4       'Message Number (0 - 9,999,999)      MKSMBF$()      2
   RefNumber AS STRING * 4       'Reference Message Number (0 - 9,999,999) "         6
   NumBlocks AS STRING * 1       'Number of 128 byte blocks in Message CHR$(X)      10
   MsgDate AS STRING * 8         'Date of Message (in mm-dd-yy format)              11
   MsgTime AS STRING * 5         'Time of Message (in hh:mm format)                 19
   ToField AS STRING * 25        'Who the Message is For                            24
   ReplyDate AS STRING * 4       'Date of Reply Message MKSMBF$(in yymmdd format)   49
   ReplyTime AS STRING * 5       'Time of Reply Message (in hh:mm format)           53
   ReplyStatus AS STRING * 1     'The letter 'R' if an ALL Mesg has Reply(s)        58
   FromField AS STRING * 25      'Who the Message is From                           59
   SubjField AS STRING * 25      'Subject of the Message                            84
   Password AS STRING * 12       'Message Password (if any or ^^)                  109
   ActiveFlag AS STRING * 1      'Flag for Message Status (#225 or #226)           121
   EchoFlag AS STRING * 1        'The letter 'E' if message is to be echoed        122
   Reserved AS STRING * 4        '(Not currently used)                             123
   ExtendedStatus AS STRING * 1  '0 for compatibility, accept 32 also              127
   Reserved2 AS STRING * 1       '(Not currently used)                             128
END TYPE                                                                          '129

TYPE MsgExtendRecord
    Ident AS INTEGER             '16639 (40FF hex)
    MFunction AS STRING * 7      'TO,FROM,SUBJECT,ATTACH,LIST,ROUTE,ORIGIN,
                                 ' REQRR,ACKRR,ACKNAME,PACKOUT
    Colon AS STRING * 1          'Always set to ":"
    Descript AS STRING * 60      'User Name, Subject, Filename
    Status AS STRING * 1         'NONE, READ (if LIST) (Boolean)
    CarReturn AS STRING * 1      '0xE3 or 0x0D
END TYPE

TYPE MsgIdxRecord
    Offset AS LONG               'Offset (0 if none, >0 if active, <0 if killed)
    Num AS LONG                  'Message Number
    ToField AS STRING * 25       'TO Name
    FromField AS STRING * 25     'FROM Name
    Status AS STRING * 1         'Status Character (from Message Header)
    Date AS INTEGER              'Date of Message (in julian date format)
    Reserved AS STRING * 3       'Reserved for future use
END TYPE

' * * * * * PCBoard 15.x QWK MESSAGES.DAT/QWKID.MSG Message Block Formats

TYPE QWKMsgRecord
   Status AS STRING * 1          'Status Flag (*+-`~ or blank)                   1
   Number AS STRING * 7          'Message Number                                 2
   MDate AS STRING * 8           'Date of Message (in mm-dd-yy format)           9
   MTime AS STRING * 5           'Time of Message (in hh:mm format)             17
   ToWho AS STRING * 25          'Who the Message is For                        22
   From AS STRING * 25           'Who the Message is From                       47
   Subject AS STRING * 25        'Subject of the Message                        72
   Password AS STRING * 12       'Message Password (if any or ^^)               97
   Reference AS STRING * 8       'Reference Message Number                     109
   Blocks AS STRING * 6          'Number of 128 byte blocks in Message         117
   Deleted AS STRING * 1         'Flag for Message Status (#225 or #226)       123
   ConfNum AS INTEGER            'Conference number (unsigned word)            124
   MsgNum AS INTEGER             'Logical message number in the current packet 126
   NetTag AS STRING * 1          '                                             128
END TYPE                                                                      '129

' * * * * * PCBoard 15.x PCBSM.CLR Formats

TYPE ClrIntRecord
   Frame AS INTEGER          ' 01     07   Blue
   FrameText AS INTEGER      ' 03     07   Cyan
   ScreenTitle AS INTEGER    ' 0C     0F   HiRed
   MenuFrame AS INTEGER      ' 04     07   Red
   MenuTitle AS INTEGER      ' 0E     0F   Yellow
   MenuItem AS INTEGER       ' 0A     07   HiGreen
   MenuSel AS INTEGER        ' 3E     70   Yellow on Cyan
   MenuInst AS INTEGER       ' 4E     70   Yellow on Red
   MenuUnItem AS INTEGER     ' 07     08   White
   MenuUnSel AS INTEGER      ' 30     78   Black on Cyan
   QuestText AS INTEGER      ' 0A     0F   HiGreen
   InputItem AS INTEGER      ' 03     07   Cyan
   InputSel AS INTEGER       ' 4F     70   HiWhite on Red
   DescText AS INTEGER       ' 07     07   White
   SpecialInst AS INTEGER    ' 60     70   Black on Brown
   HelpFrame AS INTEGER      ' 20     70   Black on Green
   HelpTitle AS INTEGER      ' 2F     70   HiWhite on Green
   HelpSubTitle AS INTEGER   ' 2E     70   Yellow on Green
   HelpText AS INTEGER       ' 20     70   Black on Green
   HelpInst AS INTEGER       ' 4F     07   HiWhite on Red
   FrameHelp AS INTEGER      ' 0F     0F   HiWhite
   FrameBar AS INTEGER       ' 70     70   Black on White
   FrameSlider AS INTEGER    ' 0F     7F   White
END TYPE

' * * * * * PCBoard 15.x Stats records

TYPE PCBStatsRecord
   LastCaller AS STRING * 54
   LastTimeOn AS STRING * 6
   NewMsgs    AS LONG
   NewCalls   AS LONG
   TotalUp    AS LONG
   TotalDn    AS LONG
   LocalStats AS STRING * 1
END TYPE

' * * * * * PCBoard 15.x USERNET.XXX header

TYPE UserNetHdrRecord
   Version AS INTEGER            'PCBoard Version Number (150) unsigned
   NumOfNodes AS INTEGER         'The number of nodes supported in the file
   SizeOfRec AS INTEGER          'The record size for each node
END TYPE

TYPE UserNetRecord
   Status AS STRING * 1          'Node status
   MailWaiting AS STRING * 1     'Flag to show mail posted while caller is online (Boolean)
   Pager AS INTEGER              'Node number of pager (if node has been paged)
   UserName AS STRING * 26       'Caller's Name (if a caller is online)
   CityState AS STRING * 25      'Caller's City (if a caller is online)
   Operation AS STRING * 49      'Current operation (door name, etc)
   Message AS STRING * 80        'For broadcast messages
   Channel AS STRING * 1         'Channel number of pager (if node has been paged)
   LastUpdate AS LONG            'hour:min:sec of last update on this record
END TYPE

' * * * * * PCBoard 15.x File Index Formats

TYPE IDXFileRec
   FileName AS STRING * 11              'FileName & Extension (no '.')
   Path AS INTEGER                      'path associated with the file
END TYPE

TYPE BltLstRec
   FileName AS STRING * 30
END TYPE

TYPE ScriptLstRec
   ScriptFileName AS STRING * 30
   AnswerFileName AS STRING * 30
END TYPE

TYPE DirLstRec
   FileName AS STRING * 30
   DownPath AS STRING * 30
   Descript AS STRING * 35
   SortType AS STRING * 1
END TYPE

TYPE CmdLstRec
   CmdName AS STRING * 15
   SecLevel AS STRING * 1
   File AS STRING * 40
   Reserved AS STRING * 8
END TYPE

' * * * * * PCBoard 15.x DIRxx.IDX Formats

TYPE DirIdxHdrRec
    FileSize AS LONG
    FileTime AS INTEGER
    FileDate AS INTEGER    ' <-- file date using DOS's bit-packed date
    Latest AS INTEGER      ' <-- file date of the most recent file in index
    Reserved AS STRING * 6
END TYPE

TYPE DirIdxRec
    FileName AS STRING * 8       '<-- 8 bytes
    FileExt  AS STRING * 3       '<-- 3 bytes
    Date AS INTEGER              '<-- file date using DOS's bit-packed date
    LoOffset AS INTEGER          '/
    HiOffset AS STRING * 1       '\ these two fields make a 3-byte-integer
END TYPE

' * * * * * PCBoard 15.x PCBFILER.DEF Formats

TYPE ViewType
   Ext AS STRING * 4            ' Extension (NUL Terminated String)
   Cmd AS STRING * 31           ' Command (NUL Terminated String)
END TYPE

TYPE PCBFilerDefRecord
   DateFile AS STRING * 1      'Update FILE DATE with date found on disk file (Boolean)                       - 0
   NonStop AS STRING * 1       'Perform DIR processing in NON-STOP mode (no pause when screen full) (Boolean) - 0
   DeleteTagged AS STRING * 1  'Delete tagged files from disk (Y=Yes, N=No, A=Always i.e. don't ask)          - N
   MaxEdLines AS INTEGER       'Max number of lines allowed in DIR file editor                                - 03E8h
   IncNotListed AS STRING * 1  'Include files found on DISK that are not listed in the DIR file (Boolean)     - 0
   PerfOnMarked AS STRING * 1  'Perform operation (Move/Rename/Delete) on marked files                        - Y
   VerifyFile AS STRING * 1    'Verify file existence (Y=attached directory, N=No, A=All download paths)      - N
   DupCheck AS STRING * 1      'Check for duplicate files in each text DIR listing processed (Boolean)        - 0
   Colorize AS STRING * 1      'Colorize Directory (Boolean) ?                                                - 0
   OffLineDir AS STRING * 31   'Off-line directory (NULL Term)                                                - 0
   MissDupScan AS STRING * 41  'Include for Missing/Dupe Scan (NULL Term)
   Conferences AS STRING * 41  'Include Conferences in File List (NULL Term)
   ClrFileName AS INTEGER      'Color of FileName                     - 0E
   ClrFileSize AS INTEGER      'Color of File Size                    - 02
   ClrFileDate AS INTEGER      'Color of File Date                    - 04
   ClrFileDesc AS INTEGER      'Color of File Description             - 0B
   ClrHeader AS INTEGER        'Color of Directory Headers            - 06
   ClrText AS INTEGER          'Color of Text Lines                   - 06
   ClrDesc2 AS INTEGER         'Color of additional description lines - 03
   ClrDelete AS INTEGER        'Color of DELETED                      - 0F
   ClrOffline AS INTEGER       'Color of OFF-LINE                     - 05
   ClrNewFlag AS INTEGER       'Color of New File Flag                - 8F
   MaxScanLines AS INTEGER     'Max number of files allowed in Scan for duplicate/missing files - 2710h
   BackupDir AS STRING * 41    'Backup directory (NULL Term)
   OrigionalDir AS STRING * 41 'Origional directory (NULL Term)
   NewDir AS STRING * 41       'Origional directory (NULL Term)
   ZeroByte AS STRING * 1      'Create 0-Byte file when moving OFF-LINE or creating DELETED entries (Boolean) - 0
   View1 AS ViewType           ' See ViewType
   View2 AS ViewType           '  "      "
   View3 AS ViewType           '  "      "
   View4 AS ViewType           '  "      "
   View5 AS ViewType           '  "      "
   View6 AS ViewType           '  "      "
   ExpertMode AS STRING * 1    'Default to Expert Mode inside DIR File Editor (Boolean)               - 0
   SetFileDate AS STRING * 1   'Set FILE DATE to today when moving/copying files (Y=Yes, N=No, A=Ask) - N
   BarIndent AS STRING * 1     'Def indentation for vert bar on Sec Lines CHR$()                      - 20h
   Reserved AS STRING * 19     '
END TYPE

TYPE FListRecord
   FullPath AS STRING * 66                                      '  1
   FileName AS STRING * 13                                      ' 67
   Size AS LONG                                                 ' 80
   Seconds AS LONG                                              ' 84
   CPS AS INTEGER                                               ' 88
   Success AS INTEGER       '{FAILED=0,UPOKAY,DNOKAY,REMOVE}    ' 90
   HasDesc AS STRING * 1                                        ' 92
   Checked AS STRING * 1                                        ' 93
   Found AS STRING * 1                                          ' 94
   FsecOkay AS STRING * 1                                       ' 95
   Free AS STRING * 1                                           ' 96
   NoTime AS STRING * 1                                         ' 97
   MovedToWork AS STRING * 1                                    ' 98
   Failed AS STRING * 1                                         ' 99
   OldName AS STRING * 13                                       '110
   Duplicate AS STRING * 1                                      '113
   CapType AS INTEGER       '{NOTCAP,MSGCAP,QWKCAP}             '115
   Reserved AS STRING * 14                                      '116
END TYPE                                                        '130
