/*

 Ŀ
                                                                        
  File Name...: BIGTEXT.PRG                                             
  Author......: Vernon E. Six, Jr.                                      
  Date created: 04-04-94              Date updated: 04-04-94           
  Time created: 09:31:02pm            Time updated: 09:31:02pm         
  CopyRight...: (c) 1994 by FrontLine Software                          
                                                                        
 
  

*/

#include "BAS_VERN.CH"

/* HYPERTEXT START
!short: basBigText()    Draw huge letters on the screen, printer, etc.
basBigText()    Draw huge letters on the screen, printer, etc.

^BDescription: ^B

   basBigText() is a handy little function that allows you to print HUGE
   banners on the screen, printer, etc.  This is very handy for title
   screens and the like.


^BSyntax:^B

   cLine := basBigText( cPhrase, nLine )


^BPass:^B

   ^BcPhrase^B is a character expression of up to approximately ten characters
   in length.

   ^BnLine^B is the line number of ^BcPhrase^B you want basBigText() to return.
   ie: Because the letters drawn will be six lines high, you must call
   basBigText() six times in order to get one line (one sixth) of ^BcPhrase^B.
   See examples below.


^BReturns:^B

   ^BcLine^B is a character expression containing one line (one sixth) of
   ^BcPhrase^B in BIG letters


^BExample:^B

   for nI := 1 to 6
      ? basBigText("TESTING",nI)
   next nI


^BSource:^B

   BIGTEXT.PRG

HYPERTEXT END */
function basBigText( pcPhrase, pnLine )

   // Returns a line of BIG TEXT

   local nCntr   := 0
   local nPos    := 0
   local cRetVal := ""
   local nLength := 0
   static taLetters := {}

   if len( taLetters ) = 0

      aAdd( taLetters, { "A", {;
         "", ;
         "߱", ;
         "", ;
         " ", ;
         " ", ;
         "   "    } }  )

      aAdd( taLetters, { "B", {;
         " ", ;
         "߱", ;
         "", ;
         "߱", ;
         "", ;
         "  "    } }  )

      aAdd( taLetters, { "C", {;
         "", ;
         "", ;
         "    ", ;
         "    ", ;
         "", ;
         " "    } })

      aAdd( taLetters, { "D", {;
         " ", ;
         "߱", ;
         " ", ;
         " ", ;
         "", ;
         "  "    } })

      aAdd( taLetters, { "E", {;
         "", ;
         "", ;
         " ", ;
         " ", ;
         "", ;
         " "    } })

      aAdd( taLetters, { "F", {;
         "", ;
         "", ;
         " ", ;
         " ", ;
         "    ", ;
         "     "    } })

      aAdd( taLetters, { "G", {;
         "", ;
         "", ;
         "۱", ;
         " ", ;
         "", ;
         " "    } } )

      aAdd( taLetters, { "H", {;
         " ", ;
         " ", ;
         "", ;
         "߱", ;
         " ", ;
         "   "    } } )

      aAdd( taLetters, { "I", {;
         "", ;
         "", ;
         "", ;
         "", ;
         "", ;
         " "    } } )

      aAdd( taLetters, { "J", {;
         "    ", ;
         "    ", ;
         "    ", ;
         " ", ;
         " ", ;
         "   "    } } )

      aAdd( taLetters, { "K", {;
         " ", ;
         " ", ;
         "", ;
         "߱", ;
         " ", ;
         "   "    } } )

      aAdd( taLetters, { "L", {;
         "    ", ;
         "    ", ;
         "    ", ;
         "    ", ;
         "", ;
         " "    } } )

      aAdd( taLetters, { "M", {;
         "ܱ", ;
         "۱۱", ;
         " ߱", ;
         "   ", ;
         "   ", ;
         "     "    } })

      aAdd( taLetters, { "N", {;
         " ", ;
         "۱۱", ;
         " ߱", ;
         "   ", ;
         "   ", ;
         "     "    } })

      aAdd( taLetters, { "O", {;
         "", ;
         "߱", ;
         " ", ;
         " ", ;
         "", ;
         " "    } } )

      aAdd( taLetters, { "P", {;
         "", ;
         "߱", ;
         "", ;
         "", ;
         "    ", ;
         "     "    } } )

      aAdd( taLetters, { "Q", {;
         " ", ;
         "߱ ", ;
         "  ", ;
         "۱ ", ;
         "۱", ;
         "  "    } } )

      aAdd( taLetters, { "R", {;
         "", ;
         "߱", ;
         "", ;
         "߱", ;
         " ", ;
         "   "    } } )

      aAdd( taLetters, { "S", {;
         "", ;
         "", ;
         "", ;
         " ߱", ;
         "", ;
         " "    } } )

      aAdd( taLetters, { "T", {;
         "", ;
         " ߱", ;
         "    ", ;
         "    ", ;
         "    ", ;
         "     "    } } )

      aAdd( taLetters, { "U", {;
         " ", ;
         " ", ;
         " ", ;
         " ", ;
         "", ;
         " "    } } )

      aAdd( taLetters, { "V", {;
         " ", ;
         " ", ;
         " ", ;
         " ", ;
         "   ", ;
         "     "    } } )

      aAdd( taLetters, { "W", {;
         "   ", ;
         "   ", ;
         "   ", ;
         "۱ܱ", ;
         " ߱", ;
         "     "    } } )

      aAdd( taLetters, { "X", {;
         " ", ;
         "  ", ;
         "    ", ;
         "  ", ;
         "߱", ;
         "   "    } } )

      aAdd( taLetters, { "Y", {;
         " ", ;
         " ", ;
         " ", ;
         "   ", ;
         "    ", ;
         "     "    } } )

      aAdd( taLetters, { "Z", {;
         "", ;
         " ߱", ;
         "    ", ;
         "    ", ;
         "", ;
         " "    } } )

      aAdd( taLetters, { "1", {;
         "   ", ;
         "    ", ;
         "    ", ;
         "    ", ;
         "", ;
         " "    } } )

      aAdd( taLetters, { "2", {;
         "", ;
         " ߱", ;
         "", ;
         "", ;
         "", ;
         " "    } } )

      aAdd( taLetters, { "3", {;
         "", ;
         " ߱", ;
         " ", ;
         "  ߱", ;
         "", ;
         " "    } } )

      aAdd( taLetters, { "4", {;
         " ", ;
         " ", ;
         "", ;
         " ߱", ;
         "    ", ;
         "     "    } } )

      aAdd( taLetters, { "5", {;
         "", ;
         "", ;
         "", ;
         " ߱", ;
         "", ;
         " "    } } )

      aAdd( taLetters, { "6", {;
         "", ;
         "", ;
         "", ;
         "߱", ;
         "", ;
         " "    } } )

      aAdd( taLetters, { "7", {;
         "", ;
         " ߱", ;
         "    ", ;
         "    ", ;
         "    ", ;
         "     "    } } )

      aAdd( taLetters, { "8", {;
         "", ;
         "߱", ;
         "", ;
         "߱", ;
         "", ;
         " "    } } )

      aAdd( taLetters, { "9", {;
         "", ;
         "߱", ;
         "", ;
         " ߱", ;
         "", ;
         " "    } } )

      aAdd( taLetters, { "0", {;
         "", ;
         "߱", ;
         " ", ;
         " ", ;
         "", ;
         " "    } } )

      aAdd( taLetters, { "!", {;
         "", ;
         "", ;
         "", ;
         " ", ;
         "", ;
         " "    } } )

      aAdd( taLetters, { ".", {;
         "   ", ;
         "   ", ;
         "   ", ;
         "   ", ;
         "", ;
         " "    } } )

      aAdd( taLetters, { ",", {;
         "   ", ;
         "   ", ;
         "   ", ;
         "", ;
         " ", ;
         "  "    } } )

      aAdd( taLetters, { "'", {;
         "", ;
         " ", ;
         "  ", ;
         "   ", ;
         "   ", ;
         "   "    } } )

      aAdd( taLetters, { "?", {;
         "", ;
         " ߱", ;
         " ", ;
         "  ", ;
         "  ", ;
         "   "    } } )

      aAdd( taLetters, { "-", {;
         "       ", ;
         "       ", ;
         "", ;
         " ", ;
         "       ", ;
         "       "    } } )

      aAdd( taLetters, { "_", {;
         "       ", ;
         "       ", ;
         "       ", ;
         "       ", ;
         "", ;
         " "    } } )

      aAdd( taLetters, { " ", {;
         "     ", ;
         "     ", ;
         "     ", ;
         "     ", ;
         "     ", ;
         "     "    } } )

                               ;

      aAdd( taLetters, { "", {;
         "    ", ;
         "    ", ;
         "", ;
         "", ;
         " ", ;
         "    "    } } )

   endif

   nLength := len(pcPhrase)

   for nCntr := 1 to nLength

      nPos := aScan( taLetters, {|x| upper(x[1]) == upper(substr(pcPhrase,nCntr,1))})

      if nPos > 0

         if len(cRetVal) != 0
            cRetval += " "
         endif

         cRetVal += taLetters[nPos,2,pnLine]

      endif

   next nCntr

   return cRetVal




